/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.writeoff.client;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.scm.framework.writeoff.client.AbstractBillFilterUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BillFilterUI
extends AbstractBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BillFilterUI.class);
    private String mainBillFilter;
    private String secBillFilter;
    private CommonEntityFilterPanel mainPnlFilter;
    private CommonEntityFilterPanel secPnlFilter;

    public BillFilterUI() throws Exception {
        this.actionOK.setEnabled(true);
        this.actionCancel.setEnabled(true);
    }

    public void initBillFilterUI(EntityObjectInfo mainEntity, EntityObjectInfo secEntity, String mainFilter, String secFilter) throws Exception {
        this.initUI(mainEntity, mainFilter, true);
        this.initUI(secEntity, secFilter, false);
    }

    private void initUI(EntityObjectInfo entity, String dataFilter, boolean isMain) throws Exception {
        MetaDataPK srcEntityPk = MetaDataPK.create((String)entity.getFullName());
        FilterInfo filterInfo = null;
        if (dataFilter != null && dataFilter.length() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo(dataFilter);
            filterInfo = entityViewInfo.getFilter();
        }
        if (isMain) {
            this.mainPnlFilter = this.buildFilterPanel((IMetaDataPK)srcEntityPk, filterInfo, isMain);
        } else {
            this.secPnlFilter = this.buildFilterPanel((IMetaDataPK)srcEntityPk, filterInfo, isMain);
        }
        this.setDataFilter(isMain);
    }

    private CommonEntityFilterPanel buildFilterPanel(IMetaDataPK entityPK, FilterInfo entryFilterInfo, boolean isMain) throws Exception {
        KDContainer container = this.mainContainer;
        if (!isMain) {
            container = this.secContainer;
        }
        container.getContentPane().removeAll();
        container.removeAllButton();
        CommonEntityFilterPanel pnlEntryFilter = new CommonEntityFilterPanel(entityPK, entryFilterInfo, null, null, null, 540, 400, 10, false, true);
        container.getContentPane().setLayout(new BorderLayout());
        container.getContentPane().add((Component)pnlEntryFilter.getKdtTable(), "Center");
        container.addButton((JButton)pnlEntryFilter.getAddRowButton());
        container.addButton((JButton)pnlEntryFilter.getDelRowButton());
        container.addButton((JButton)pnlEntryFilter.getClearButton());
        return pnlEntryFilter;
    }

    private void setDataFilter(boolean isMain) {
        if (isMain) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(this.mainPnlFilter.getFilterInfo());
            this.setMainBillFilter(view.toString());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            view = new EntityViewInfo();
            view.setFilter(this.secPnlFilter.getFilterInfo());
            this.setSecBillFilter(view.toString());
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.mainPnlFilter != null && !this.mainPnlFilter.verify() || this.secPnlFilter != null && !this.secPnlFilter.verify()) {
            SysUtil.abort();
        }
        this.setDataFilter(true);
        this.setDataFilter(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public String getMainBillFilter() {
        return this.mainBillFilter;
    }

    public void setMainBillFilter(String filter) {
        this.mainBillFilter = filter;
    }

    public String getSecBillFilter() {
        return this.secBillFilter;
    }

    public void setSecBillFilter(String filter) {
        this.secBillFilter = filter;
    }
}

