/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;

public class mxPartitionLayout
extends mxGraphLayout {
    protected boolean horizontal;
    protected int spacing;
    protected int border;
    protected boolean resizeVertices = true;

    public mxPartitionLayout(mxGraph graph) {
        this(graph, true);
    }

    public mxPartitionLayout(mxGraph graph, boolean horizontal) {
        this(graph, horizontal, 0);
    }

    public mxPartitionLayout(mxGraph graph, boolean horizontal, int spacing) {
        this(graph, horizontal, spacing, 0);
    }

    public mxPartitionLayout(mxGraph graph, boolean horizontal, int spacing, int border) {
        super(graph);
        this.horizontal = horizontal;
        this.spacing = spacing;
        this.border = border;
    }

    @Override
    public void moveCell(Object cell, double x, double y) {
        mxIGraphModel model = this.graph.getModel();
        Object parent = model.getParent(cell);
        if (cell instanceof mxICell && parent instanceof mxICell) {
            int idx;
            int i = 0;
            double last = 0.0;
            int childCount = model.getChildCount(parent);
            for (i = 0; i < childCount; ++i) {
                Object child = model.getChildAt(parent, i);
                mxRectangle bounds = this.getVertexBounds(child);
                if (bounds == null) continue;
                double tmp = bounds.getX() + bounds.getWidth() / 2.0;
                if (last < x && tmp > x) break;
                last = tmp;
            }
            idx = Math.max(0, i - (i > (idx = ((mxICell)parent).getIndex((mxICell)cell)) ? 1 : 0));
            model.add(parent, cell, idx);
        }
    }

    public mxRectangle getContainerSize() {
        return new mxRectangle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object parent) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry pgeo = model.getGeometry(parent);
        if (pgeo == null && model.getParent(parent) == model.getRoot() || parent == this.graph.getView().getCurrentRoot()) {
            mxRectangle tmp = this.getContainerSize();
            pgeo = new mxGeometry(0.0, 0.0, tmp.getWidth(), tmp.getHeight());
        }
        if (pgeo != null) {
            int childCount = model.getChildCount(parent);
            ArrayList<Object> children = new ArrayList<Object>(childCount);
            for (int i = 0; i < childCount; ++i) {
                Object child = model.getChildAt(parent, i);
                if (this.isVertexIgnored(child) || !this.isVertexMovable(child)) continue;
                children.add(child);
            }
            int n = children.size();
            if (n > 0) {
                double value;
                double x0 = this.border;
                double y0 = this.border;
                double other = this.horizontal ? pgeo.getHeight() : pgeo.getWidth();
                other -= (double)(2 * this.border);
                mxRectangle size = this.graph.getStartSize(parent);
                other -= this.horizontal ? size.getHeight() : size.getWidth();
                double tmp = this.border + (n - 1) * this.spacing;
                double d = value = this.horizontal ? (pgeo.getWidth() - (x0 += size.getWidth()) - tmp) / (double)n : (pgeo.getHeight() - (y0 += size.getHeight()) - tmp) / (double)n;
                if (value > 0.0) {
                    model.beginUpdate();
                    try {
                        for (int i = 0; i < n; ++i) {
                            Object child = children.get(i);
                            mxGeometry geo = model.getGeometry(child);
                            if (geo == null) continue;
                            geo = (mxGeometry)geo.clone();
                            geo.setX(x0);
                            geo.setY(y0);
                            if (this.horizontal) {
                                if (this.resizeVertices) {
                                    geo.setWidth(value);
                                    geo.setHeight(other);
                                }
                                x0 += value + (double)this.spacing;
                            } else {
                                if (this.resizeVertices) {
                                    geo.setHeight(value);
                                    geo.setWidth(other);
                                }
                                y0 += value + (double)this.spacing;
                            }
                            model.setGeometry(child, geo);
                        }
                    }
                    finally {
                        model.endUpdate();
                    }
                }
            }
        }
    }
}

