/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.api.bizflow.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.api.bizflow.client.AbstractSelectBizFlowUI;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.framework.bizflow.util.CollectionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;

public class SelectBizFlowUI
extends AbstractSelectBizFlowUI {
    private static final long serialVersionUID = 1L;
    public static final String BIZRELATION_SPLIT_TOKEN = "-";
    public static final String SPLIT_TOKEN = "!@#!@#";
    public static final String SPLIT_BLANK = " ";
    protected boolean isCancel = false;
    private Map<String, String> tableMap = new LinkedHashMap<String, String>();
    private Map<String, String> returnObjs = null;
    private int entryCount = 0;
    private String billEntryName = null;
    private IObjectValue billInfo = null;
    private static String COL_SEQ = "seq";
    private static String COL_BizFlowSelect = "BizFlowSelect";
    private static String COL_BillEntryID = "BillEntryID";
    private static String COL_MATCH_PRESELECT = "MATCH_PRESELECT";
    private static String Property_ID = "id";
    private static String PROPERTY_VERSION = "version";
    private static String PROPERTY_ENTRY_OLDID = "oldID";
    Map<String, Set<String>> bizFlowSelectMap = null;
    Map<String, Set<String>> billBizFlowMap = null;
    Map<String, String> bizFlowMap = new HashMap<String, String>();
    Set<String> bizFlow4AllBill = null;
    Map<String, Integer> bizFlowGroupMap = null;
    private static final String NULL_KEY = "@NULL_KEY@";
    private KDTable curTable = null;
    private KDTEditListener tableListener = new KDTEditAdapter(){

        public void editStopped(KDTEditEvent e) {
            SelectBizFlowUI.this.tableValueChanged(e);
        }
    };
    private static final String resource = "com.kingdee.eas.scm.framework.bizflow.BizProcessResource";
    private boolean isLockRow = false;
    private final String OP_ALTER = "ALERT";
    private static IDynamicObject iDynamicObject = null;
    private IObjectCollection oldVersionEntryCollection = null;
    private Map bizFlowRelationMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.buildReturnObjs();
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.buildReturnObjsCancel();
        this.disposeUIWindow();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        super.actionClear_actionPerformed(e);
        this.curTable = (KDTable)this.kdTab.getSelectedComponent();
        if (this.curTable == null) {
            return;
        }
        IRow row = null;
        int rowCount = this.curTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.curTable.getRow(i);
            if (row.getCell(COL_BizFlowSelect).getStyleAttributes().isLocked()) {
                return;
            }
            row.getCell(COL_BizFlowSelect).setValue(null);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Map<String, String> getReturnObjects() {
        return this.returnObjs;
    }

    public int getEntryRowCount() {
        return this.entryCount;
    }

    protected void buildReturnObjs() {
        IRow row = null;
        String billEntryID = null;
        String bizFlowID = null;
        String bizFlowName = null;
        String bizFlowNumber = null;
        this.returnObjs = new HashMap<String, String>();
        this.entryCount = 0;
        boolean isHasBizFlow = true;
        int count = this.kdTab.getTabCount();
        for (int i = 0; i < count; ++i) {
            this.curTable = (KDTable)this.kdTab.getComponentAt(i);
            int rowCount = this.curTable.getRowCount();
            for (int j = 0; j < rowCount; ++j) {
                row = this.curTable.getRow(j);
                billEntryID = (String)row.getCell(COL_BillEntryID).getValue();
                ++this.entryCount;
                bizFlowName = (String)row.getCell(COL_BizFlowSelect).getValue();
                if (StringUtils.isEmpty((String)bizFlowName) || bizFlowName.equals(EASResource.getString((String)resource, (String)"99_SelectBizFlow"))) {
                    isHasBizFlow = false;
                    continue;
                }
                bizFlowNumber = bizFlowName.split(SPLIT_BLANK)[0];
                bizFlowID = this.bizFlowMap.get(bizFlowNumber);
                this.returnObjs.put(billEntryID, bizFlowID);
            }
        }
        if (!isHasBizFlow && this.returnObjs.size() > 0) {
            String msg = EASResource.getString((String)resource, (String)"79_BizFlowIsNull");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected void buildReturnObjsCancel() {
        IRow row = null;
        String billEntryID = null;
        String bizFlowID = null;
        String bizFlowName = null;
        String bizFlowNumber = null;
        this.returnObjs = new HashMap<String, String>();
        this.entryCount = 0;
        int count = this.kdTab.getTabCount();
        for (int i = 0; i < count; ++i) {
            this.curTable = (KDTable)this.kdTab.getComponentAt(i);
            int rowCount = this.curTable.getRowCount();
            for (int j = 0; j < rowCount; ++j) {
                String bizFlowRelation;
                row = this.curTable.getRow(j);
                billEntryID = (String)row.getCell(COL_BillEntryID).getValue();
                ++this.entryCount;
                String isMatchRow = (String)row.getCell(COL_MATCH_PRESELECT).getValue();
                if (!"YES".equals(isMatchRow)) continue;
                if (this.bizFlowRelationMap.containsKey(billEntryID) && !StringUtils.isEmpty((String)(bizFlowRelation = (String)this.bizFlowRelationMap.get(billEntryID))) && bizFlowRelation.indexOf("#" + billEntryID) > 1) {
                    bizFlowRelation = bizFlowRelation.substring(0, bizFlowRelation.indexOf("#" + billEntryID));
                    this.matchBizFlow(row, bizFlowRelation);
                }
                if (StringUtils.isEmpty((String)(bizFlowName = (String)row.getCell(COL_BizFlowSelect).getValue()))) continue;
                bizFlowNumber = bizFlowName.split(SPLIT_BLANK)[0];
                bizFlowID = this.bizFlowMap.get(bizFlowNumber);
                this.returnObjs.put(billEntryID, bizFlowID);
            }
        }
    }

    public void init(IObjectValue billInfo, String billEntryName, Map<String, Set<String>> bizFlowSelectMap) {
        this.billInfo = billInfo;
        this.billEntryName = billEntryName;
        this.bizFlowSelectMap = bizFlowSelectMap;
        SelectBizFlowUI.initDynamicObject();
        this.initAlterBillProperty();
        this.initBizFlowRelationMap();
        this.initControl(bizFlowSelectMap != null && bizFlowSelectMap.size() != 0);
        this.initBillBizFlowMap();
        this.initTableCol();
        this.initTable();
    }

    private static void initDynamicObject() {
        if (iDynamicObject == null) {
            try {
                iDynamicObject = DynamicObjectFactory.getRemoteInstance();
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
    }

    private void initOldEntryCollection(IObjectValue model) {
        this.oldVersionEntryCollection = null;
        if (model == null || model.getBOSType() == null || model.get("number") == null) {
            return;
        }
        EntityObjectInfo entity = BizBillValueChangeUtil.getEntityByBosType(null, model.getBOSType().toString());
        if (entity.getPropertyByName(PROPERTY_VERSION) == null) {
            return;
        }
        Map<String, PropertyInfo> map = BizBillValueChangeUtil.getEntityProperty(null, model.getBOSType().toString());
        if (!map.containsKey(this.billEntryName + "." + PROPERTY_ENTRY_OLDID)) {
            return;
        }
        String billNumber = (String)model.get("number");
        int version = model.get(PROPERTY_VERSION) == null ? 0 : Integer.parseInt(model.get(PROPERTY_VERSION).toString());
        int oldVersion = version - 1;
        IObjectCollection col = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
            if (model.get(PROPERTY_VERSION) != null) {
                filter.getFilterItems().add(new FilterItemInfo(PROPERTY_VERSION, (Object)oldVersion, CompareType.EQUALS));
            }
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo(Property_ID));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo(PROPERTY_VERSION));
            sic.add(new SelectorItemInfo(this.billEntryName + "." + Property_ID));
            sic.add(new SelectorItemInfo(this.billEntryName + "." + PROPERTY_ENTRY_OLDID));
            view.setSelector(sic);
            col = iDynamicObject.getCollection(model.getBOSType(), view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (CollectionUtil.isEmpty(col)) {
            return;
        }
        IObjectValue oldModel = col.getObject(0);
        this.oldVersionEntryCollection = (IObjectCollection)oldModel.get(this.billEntryName);
    }

    private boolean isAlterAddRow(IObjectValue model, String entryId) {
        if (!this.isLockRow) {
            return true;
        }
        if (model == null || model.getBOSType() == null || model.get("id") == null) {
            return true;
        }
        if (StringUtils.isEmpty((String)entryId) || StringUtils.isEmpty((String)PROPERTY_ENTRY_OLDID)) {
            return true;
        }
        if (this.oldVersionEntryCollection == null) {
            this.initOldEntryCollection(model);
        }
        if (CollectionUtil.isEmpty(this.oldVersionEntryCollection)) {
            try {
                IObjectValue oldModel = iDynamicObject.getValue(model.getBOSType(), (IObjectPK)new ObjectUuidPK(model.get(Property_ID).toString()));
                if (oldModel == null) {
                    return true;
                }
                IObjectCollection oldEntryCollection = (IObjectCollection)oldModel.get(this.billEntryName);
                if (CollectionUtil.isEmpty(oldEntryCollection)) {
                    return true;
                }
                IObjectValue oldEntry = null;
                int size = oldEntryCollection.size();
                for (int i = 0; i < size; ++i) {
                    oldEntry = oldEntryCollection.getObject(i);
                    if (oldEntry.get(Property_ID) == null || !entryId.equals(oldEntry.get(Property_ID).toString())) continue;
                    return false;
                }
            }
            catch (BOSException e) {
                return true;
            }
        } else {
            IObjectValue oldEntry = null;
            int size = this.oldVersionEntryCollection.size();
            for (int i = 0; i < size; ++i) {
                oldEntry = this.oldVersionEntryCollection.getObject(i);
                if (oldEntry.get(PROPERTY_ENTRY_OLDID) == null || !entryId.equals(oldEntry.get(PROPERTY_ENTRY_OLDID).toString())) continue;
                return false;
            }
        }
        return true;
    }

    private void initAlterBillProperty() {
        Object bizUI = this.getUIContext().get("Owner");
        if (bizUI == null) {
            return;
        }
        if (bizUI instanceof CoreUIObject && "ALERT".equals(((CoreUIObject)bizUI).getOprtState())) {
            this.isLockRow = true;
        }
        PROPERTY_ENTRY_OLDID = (String)this.getUIContext().get("ALTERBILLOLDENTRY");
    }

    private void initBizFlowRelationMap() {
        try {
            this.bizFlowRelationMap = BizFlowFacadeFactory.getRemoteInstance().getBizFlowRelationMap(this.billInfo);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    protected void initTable() {
        if (this.billInfo != null) {
            IObjectCollection entryColl = (IObjectCollection)this.billInfo.get(this.billEntryName);
            IObjectValue entryInfo = null;
            String billEntryID = null;
            IRow row = null;
            this.bizFlowGroupMap = new HashMap<String, Integer>();
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entryColl.getObject(i);
                billEntryID = entryInfo.getString(Property_ID);
                this.curTable = this.getTable(billEntryID);
                row = this.curTable.addRow();
                row.getCell(COL_SEQ).setValue((Object)(i + 1));
                row.getCell(COL_BillEntryID).setValue((Object)billEntryID);
                row.getCell(COL_MATCH_PRESELECT).setValue((Object)"NO");
                this.initBizFlowSelectCol(row);
            }
        }
    }

    private void initControl(boolean isEnable) {
        this.btnConfirm.setEnabled(isEnable);
        this.btnCancel.setEnabled(isEnable);
        this.btnClear.setEnabled(isEnable);
    }

    private void initBizFlowSelectCol(IRow row) {
        String bizFlowRelation;
        KDComboBox cbBizFlow = new KDComboBox();
        String entryID = row.getCell(COL_BillEntryID).getValue().toString();
        this.addBizFlowItem(this.bizFlow4AllBill, cbBizFlow);
        Set<String> bizFlowSet = this.billBizFlowMap.get(entryID);
        this.addBizFlowItem(bizFlowSet, cbBizFlow);
        row.getCell(COL_BizFlowSelect).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbBizFlow));
        if (cbBizFlow.getItemCount() == 1) {
            cbBizFlow.setSelectedIndex(0);
            row.getCell(COL_BizFlowSelect).setValue(cbBizFlow.getSelectedItem());
            row.getCell(COL_BizFlowSelect).getStyleAttributes().setLocked(true);
        } else {
            row.getCell(COL_BizFlowSelect).setValue((Object)EASResource.getString((String)resource, (String)"99_SelectBizFlow"));
        }
        if (this.bizFlowRelationMap != null && this.bizFlowRelationMap.containsKey(entryID) && !StringUtils.isEmpty((String)(bizFlowRelation = (String)this.bizFlowRelationMap.get(entryID))) && bizFlowRelation.indexOf("#" + entryID) > 1) {
            bizFlowRelation = bizFlowRelation.substring(0, bizFlowRelation.indexOf("#" + entryID));
            this.matchBizFlow(row, bizFlowRelation);
        }
    }

    private void matchBizFlow(IRow row, String bizFlowRelation) {
        Iterator<Map.Entry<String, Set<String>>> itor = this.bizFlowSelectMap.entrySet().iterator();
        String bizFlow = null;
        while (itor.hasNext()) {
            Map.Entry<String, Set<String>> mapEntry = itor.next();
            bizFlow = mapEntry.getKey();
            if (bizFlow.indexOf(bizFlowRelation) >= 0) {
                row.getCell(COL_BizFlowSelect).setValue((Object)bizFlow.split(SPLIT_TOKEN)[1]);
                row.getCell(COL_MATCH_PRESELECT).setValue((Object)"YES");
                row.getStyleAttributes().setLocked(this.isLockRow && !this.isAlterAddRow(this.billInfo, (String)row.getCell(COL_BillEntryID).getValue()));
                return;
            }
            if (bizFlowRelation.split(BIZRELATION_SPLIT_TOKEN).length <= 1) continue;
            int len = bizFlowRelation.split(BIZRELATION_SPLIT_TOKEN).length;
            String thisBizFlowRelation = bizFlowRelation.split(BIZRELATION_SPLIT_TOKEN)[len - 1];
            if (bizFlow.indexOf(thisBizFlowRelation) < 0) continue;
            row.getCell(COL_BizFlowSelect).setValue((Object)bizFlow.split(SPLIT_TOKEN)[1]);
            row.getCell(COL_MATCH_PRESELECT).setValue((Object)"YES");
            row.getStyleAttributes().setLocked(this.isLockRow && !this.isAlterAddRow(this.billInfo, (String)row.getCell(COL_BillEntryID).getValue()));
            return;
        }
    }

    private void addBizFlowItem(Set<String> bizFlowSet, KDComboBox cbBizFlow) {
        if (bizFlowSet == null || bizFlowSet.size() == 0) {
            return;
        }
        String key2 = null;
        String[] str = null;
        String bizFlowID = null;
        String bizFlowName = null;
        String bizFlowNumber = null;
        for (String key2 : bizFlowSet) {
            str = key2.split(SPLIT_TOKEN);
            bizFlowID = str[0];
            bizFlowName = str[1];
            cbBizFlow.addItem((Object)bizFlowName);
            bizFlowNumber = bizFlowName.split(SPLIT_BLANK)[0];
            this.bizFlowMap.put(bizFlowNumber, bizFlowID);
        }
    }

    private void initTableCol() {
        this.tableMap.put(COL_BillEntryID, COL_BillEntryID);
        this.tableMap.put(COL_MATCH_PRESELECT, COL_MATCH_PRESELECT);
        this.tableMap.put(COL_SEQ, EASResource.getString((String)resource, (String)"billEntrySeq"));
        this.tableMap.put(COL_BizFlowSelect, EASResource.getString((String)resource, (String)"selectBizFlow"));
    }

    private KDTable buildKDTable() {
        KDTable table = new KDTable();
        table.removeColumns();
        IRow headRow = table.addHeadRow();
        Iterator<String> itor = this.tableMap.keySet().iterator();
        String key = null;
        IColumn col = null;
        while (itor.hasNext()) {
            key = itor.next();
            col = table.addColumn();
            col.setKey(key);
            if (COL_BillEntryID.equals(key)) {
                col.getStyleAttributes().setHided(true);
            } else if (COL_SEQ.equals(key)) {
                col.setWidth(98);
                col.getStyleAttributes().setLocked(true);
            } else if (COL_BizFlowSelect.equals(key)) {
                col.setWidth(450);
            } else if (COL_MATCH_PRESELECT.equals(key)) {
                col.getStyleAttributes().setHided(true);
            }
            headRow.getCell(key).setValue((Object)this.tableMap.get(key));
        }
        return table;
    }

    private void initBillBizFlowMap() {
        this.bizFlow4AllBill = new LinkedHashSet<String>();
        this.billBizFlowMap = new HashMap<String, Set<String>>();
        Iterator<Map.Entry<String, Set<String>>> itor = this.bizFlowSelectMap.entrySet().iterator();
        String bizFlow = null;
        String billEntryID2 = null;
        Set<String> billEntrySet = null;
        while (itor.hasNext()) {
            Map.Entry<String, Set<String>> mapEntry = itor.next();
            bizFlow = mapEntry.getKey();
            billEntrySet = mapEntry.getValue();
            if (billEntrySet.size() == 0) {
                this.bizFlow4AllBill.add(bizFlow);
                continue;
            }
            for (String billEntryID2 : billEntrySet) {
                Set<String> bizFlowSet = this.billBizFlowMap.get(billEntryID2);
                if (bizFlowSet == null) {
                    bizFlowSet = new LinkedHashSet<String>();
                }
                bizFlowSet.add(bizFlow);
                this.billBizFlowMap.put(billEntryID2, bizFlowSet);
            }
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
            return;
        }
        this.curTable = (KDTable)e.getSource();
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (rowIndex != 0 || colIndex != this.curTable.getColumn(COL_BizFlowSelect).getColumnIndex()) {
            return;
        }
        IRow row = null;
        Object obj = e.getValue();
        int rowCount = this.curTable.getRowCount();
        for (int i = 1; i < rowCount; ++i) {
            row = this.curTable.getRow(i);
            if (row.getCell(COL_BizFlowSelect).getValue() != null && !row.getCell(COL_BizFlowSelect).getValue().toString().equals(EASResource.getString((String)resource, (String)"99_SelectBizFlow"))) continue;
            row.getCell(COL_BizFlowSelect).setValue(obj);
        }
    }

    protected KDTable getTable(String billEntryID) {
        if (billEntryID == null || billEntryID.length() == 0) {
            return this.curTable;
        }
        Set<String> bizFlowSet = this.billBizFlowMap.get(billEntryID);
        String key = this.getKey(bizFlowSet);
        Integer tabNum = this.bizFlowGroupMap.get(key);
        KDTable table = null;
        if (tabNum == null) {
            table = this.buildKDTable();
            tabNum = this.kdTab.getTabCount();
            String title = EASResource.getString((String)resource, (String)"group") + (tabNum + 1);
            this.kdTab.add(title, (Component)table);
            this.bizFlowGroupMap.put(key, tabNum);
            table.addKDTEditListener(this.tableListener);
        } else {
            table = (KDTable)this.kdTab.getComponentAt(tabNum.intValue());
        }
        return table;
    }

    private String getKey(Set<String> bizFlowSet) {
        if (bizFlowSet == null || bizFlowSet.size() == 0) {
            return NULL_KEY;
        }
        StringBuilder key = new StringBuilder();
        String bizFlowID2 = null;
        for (String bizFlowID2 : bizFlowSet) {
            key.append(bizFlowID2);
        }
        return key.toString();
    }

    protected void disposeUIWindow() {
        if (this.returnObjs == null) {
            this.buildReturnObjsCancel();
        }
        super.disposeUIWindow();
    }
}

