/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sd.sale.client.AbstractConsignSaleBillConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ConsignSaleBillConditionUI
extends AbstractConsignSaleBillConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ConsignSaleBillConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.ConsignSaleBalanceResource";
    private static final String permItem_view = "consign_view";
    private Map curPeriodMap = new HashMap();
    private Map startPeriodMap = new HashMap();
    int minYear = 0;
    int maxYear = 0;
    int minMonth = 1;
    int maxMonth = 12;

    public ConsignSaleBillConditionUI() throws Exception {
        this.setSize(400, 260);
        this.setReport(false);
        this.addChangeListener();
        this.setF7();
        this.initDefaultFilter();
        this.setUIDefaultValue();
        this.setDefaultYearAndProidValue(null);
    }

    private void addChangeListener() {
        this.bizStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ConsignSaleBillConditionUI.this.bizStorageOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    ConsignSaleBillConditionUI.this.handUIException(exc);
                }
            }
        });
        this.spnYearFrom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(ConsignSaleBillConditionUI.this.spnYearFrom)) {
                    ConsignSaleBillConditionUI.this.setPeriod(ConsignSaleBillConditionUI.this.spnYearFrom);
                }
            }
        });
        this.spnYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (((KDSpinner)arg0.getSource()).equals(ConsignSaleBillConditionUI.this.spnYearTo)) {
                    ConsignSaleBillConditionUI.this.setPeriod(ConsignSaleBillConditionUI.this.spnYearTo);
                }
            }
        });
    }

    private void setDefaultYearAndProidValue(CompanyOrgUnitInfo companyOrgInfo) throws EASBizException, BOSException {
        if (companyOrgInfo == null) {
            companyOrgInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
        }
        PeriodInfo curPeriodInfo = null;
        if (companyOrgInfo != null) {
            if (this.curPeriodMap.containsKey(companyOrgInfo)) {
                curPeriodInfo = (PeriodInfo)this.curPeriodMap.get(companyOrgInfo.getId().toString());
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgInfo);
                if (curPeriodInfo != null) {
                    this.curPeriodMap.put(companyOrgInfo.getId().toString(), curPeriodInfo);
                }
                this.minYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyOrgInfo.getId().toString(), (boolean)false);
                this.maxYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyOrgInfo.getId().toString(), (boolean)true);
            }
        }
        this.SetSpinnerMaxMin((JSpinner)this.spnYearFrom, this.minYear, this.maxYear);
        this.SetSpinnerMaxMin((JSpinner)this.spnYearTo, this.minYear, this.maxYear);
        if (curPeriodInfo != null) {
            this.spnYearFrom.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.spnYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.setPeriod(this.spnYearFrom);
            this.setPeriod(this.spnYearTo);
        } else {
            int year = Calendar.getInstance().get(1);
            this.spnYearFrom.setValue((Object)new Integer(year));
            this.spnYearTo.setValue((Object)new Integer(year));
            this.setPeriod(this.spnYearFrom);
            this.setPeriod(this.spnYearTo);
        }
    }

    private void setPeriod(KDSpinner periodYear) {
        try {
            if (periodYear.getValue() != null) {
                KDSpinner kdspinner = this.spnPeriodFrom;
                if (periodYear.equals(this.spnYearTo)) {
                    kdspinner = this.spnPeriodTo;
                }
                int year = (Integer)periodYear.getValue();
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData();
                PeriodInfo curPeriodInfo = null;
                PeriodInfo startPeriodInfo = null;
                if (companyInfo != null) {
                    if (this.startPeriodMap.containsKey(companyInfo.getId().toString())) {
                        startPeriodInfo = (PeriodInfo)this.startPeriodMap.get(companyInfo.getId().toString());
                    }
                    if (this.curPeriodMap.containsKey(companyInfo.getId().toString())) {
                        curPeriodInfo = (PeriodInfo)this.curPeriodMap.get(companyInfo.getId().toString());
                    } else {
                        curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        if (curPeriodInfo != null) {
                            this.curPeriodMap.put(companyInfo.getId().toString(), curPeriodInfo);
                        }
                        if ((startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo)) != null) {
                            this.startPeriodMap.put(companyInfo.getId().toString(), curPeriodInfo);
                        }
                        this.minMonth = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                        this.maxMonth = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                    }
                    if (this.minMonth == 0) {
                        this.minMonth = 1;
                    }
                    if (this.maxMonth == 0) {
                        this.maxMonth = 12;
                    }
                }
                if (startPeriodInfo != null && year == startPeriodInfo.getPeriodYear()) {
                    this.minMonth = startPeriodInfo.getPeriodNumber();
                }
                this.SetSpinnerMaxMin((JSpinner)kdspinner, this.minMonth, this.maxMonth);
                if (curPeriodInfo != null) {
                    kdspinner.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                }
                if (kdspinner.getIntegerVlaue() < this.minMonth) {
                    kdspinner.setValue((Object)new Integer(this.minMonth));
                }
                if (kdspinner.getIntegerVlaue() > this.maxMonth) {
                    kdspinner.setValue((Object)new Integer(this.maxMonth));
                }
            }
        }
        catch (EASBizException ex) {
            logger.info((Object)ex);
            this.handUIException(ex);
        }
        catch (BOSException ex) {
            logger.info((Object)ex);
            this.handUIException(ex);
        }
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private void initDefaultFilter() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.bizStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement saleOrgElement = new SingleFilterElement("saleOrgUnit.number", (Component)this.bizPromptSaleOrgUnit);
        saleOrgElement.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)saleOrgElement);
        RangeFilterElement dateElement = new RangeFilterElement("bizDate", (Component)this.kdtVerifyDateFrom, (Component)this.kdtVerifyDateTo);
        dateElement.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        dateElement.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)dateElement);
        RangeFilterElement customerElementRage = new RangeFilterElement("customer.number", (Component)this.bizPrmtCustomerFrom, (Component)this.bizPrmtCustomerTo);
        elements.add((FilterElement)customerElementRage);
        RangeFilterElement materailElementRage = new RangeFilterElement("material.number", (Component)this.bizPrmtMaterialFrom, (Component)this.bizPrmtMaterialTo);
        elements.add((FilterElement)materailElementRage);
        RangeFilterElement numberElementRage = new RangeFilterElement("number", (Component)this.numberFrom, (Component)this.numberTo);
        elements.add((FilterElement)numberElementRage);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "storageOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPrmtCustomerFrom, this.bizPrmtCustomerTo, this.bizPrmtMaterialFrom, this.bizPrmtMaterialTo, this.bizPromptSaleOrgUnit});
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.bizStorageOrgUnit, (OrgType)OrgType.Storage, (String)permItem_view);
        this.bizStorageOrgUnit.setEnabledMultiSelection(true);
        this.bizPromptSaleOrgUnit.setEnabledMultiSelection(true);
    }

    public void onLoad() throws Exception {
        this.bizPromptSaleOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.SaleOrgUnitQuery");
        this.prmtCompanyOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        super.onLoad();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    private void setF7() {
        this.setBizCustomerF7(this.bizPrmtCustomerFrom, null);
        this.setBizCustomerF7(this.bizPrmtCustomerTo, null);
        this.setBizMaterialF7(this.bizPrmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.bizPrmtMaterialTo, false, null);
        this.bizPromptSaleOrgUnit.setRequired(false);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("storageOrgUnit", this.bizStorageOrgUnit.getValue());
        para.setObject("saleOrgUnit", this.bizPromptSaleOrgUnit.getValue());
        para.setObject("customerFrom", this.bizPrmtCustomerFrom.getValue());
        para.setObject("customerTo", this.bizPrmtCustomerTo.getValue());
        para.setObject("materialFrom", this.bizPrmtMaterialFrom.getValue());
        para.setObject("materialTo", this.bizPrmtMaterialTo.getValue());
        para.setObject("yearFrom", this.spnYearFrom.getValue());
        para.setObject("yearTo", this.spnYearTo.getValue());
        para.setObject("periodFrom", this.spnPeriodFrom.getValue());
        para.setObject("periodTo", this.spnPeriodTo.getValue());
        para.setObject("verifyDateFrom", this.kdtVerifyDateFrom.getValue());
        para.setObject("verifyDateTo", this.kdtVerifyDateTo.getValue());
        para.setObject("numberFrom", (Object)this.numberFrom.getText());
        para.setObject("numberTo", (Object)this.numberTo.getText());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.bizPromptSaleOrgUnit.setValue(params.getObject("saleOrgUnit"));
        this.bizPrmtCustomerFrom.setValue(params.getObject("customerFrom"));
        this.bizPrmtCustomerTo.setValue(params.getObject("customerTo"));
        this.bizPrmtMaterialFrom.setValue(params.getObject("materialFrom"));
        this.bizPrmtMaterialTo.setValue(params.getObject("materialTo"));
        this.spnYearFrom.setValue(params.getObject("yearFrom"));
        this.spnYearTo.setValue(params.getObject("yearTo"));
        this.spnPeriodFrom.setValue(params.getObject("periodFrom"));
        this.spnPeriodTo.setValue(params.getObject("periodTo"));
        this.kdtVerifyDateFrom.setValue(params.getObject("verifyDateFrom"));
        this.kdtVerifyDateTo.setValue(params.getObject("verifyDateTo"));
        this.numberFrom.setText((String)params.getObject("numberFrom"));
        this.numberTo.setText((String)params.getObject("numberTo"));
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)customerParams, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getCustomCondition()));
        return customerParams;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (Boolean.valueOf(String.valueOf(this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
                return;
            }
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setCustomCondition((RptParams)RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setCustomCondition((RptParams)RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public boolean verify() {
        Object[] obj;
        if (this.bizStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (this.bizStorageOrgUnit.getData() instanceof Object[] && (obj = (Object[])this.bizStorageOrgUnit.getData()).length > 0 && obj[0] == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        String dateFrom = this.spnPeriodFrom.getValue().toString();
        String dateTo = this.spnPeriodTo.getValue().toString();
        String yearFrom = this.spnYearFrom.getValue().toString();
        String yearTo = this.spnYearTo.getValue().toString();
        Object selFrom = this.kdtVerifyDateFrom.getValue();
        Object selTo = this.kdtVerifyDateTo.getValue();
        if (dateFrom == null || dateFrom.equals("0")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"beginPeriodNotNullOrZero"));
            this.spnPeriodFrom.requestFocus();
            return false;
        }
        if (dateTo == null || dateTo.equals("0")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endPeriodNotNullOrZero"));
            this.spnPeriodTo.requestFocus();
            return false;
        }
        if (Integer.parseInt(yearTo) == Integer.parseInt(yearFrom) && Integer.parseInt(dateTo) < Integer.parseInt(dateFrom)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endPriodBiggerBeginPriod"));
            this.spnPeriodTo.requestFocus();
            return false;
        }
        if (yearFrom == null || yearFrom.equals("0")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"beginYearNotNullOrZero"));
            this.spnYearFrom.requestFocus();
            return false;
        }
        if (yearTo == null || yearTo.equals("0")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endYearNotNullOrZero"));
            this.spnYearTo.requestFocus();
            return false;
        }
        if (Integer.parseInt(yearTo) < Integer.parseInt(yearFrom)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endYearBiggerBeginYear"));
            this.spnYearTo.requestFocus();
            return false;
        }
        if (selFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"beginVerifyNotNullOrZero"));
            this.kdtVerifyDateFrom.requestFocus();
            return false;
        }
        if (selTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endVerifyNotNullOrZero"));
            this.kdtVerifyDateTo.requestFocus();
            return false;
        }
        Date dSelFrom = (Date)selFrom;
        Date dSelTo = (Date)selTo;
        if (dSelFrom.after(dSelTo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"endVerifyBiggerBeginPriod"));
            this.kdtVerifyDateTo.requestFocus();
            return false;
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return permItem_view;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public Object[] getAdditiveBillStatus() {
        return new Object[]{BillBaseStatusEnum.ALTERING};
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.RELEASED};
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void setUIDefaultValue() {
        this.bizStorageOrgUnit.setData((Object)this.getDefaultMainBizOrg());
    }

    protected void bizStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object storageObj = this.bizStorageOrgUnit.getValue();
        if (storageObj == null) {
            this.bizStorageOrgUnit.setData(e.getOldValue());
        }
        OrgUnitCollection oldOrgUnitCollection = null;
        if (e.getOldValue() instanceof Object[]) {
            Object[] oldObject = (Object[])e.getOldValue();
            oldOrgUnitCollection = new OrgUnitCollection();
            int length = oldObject.length;
            for (int i = 0; i < length; ++i) {
                if (oldObject[i] == null) continue;
                oldOrgUnitCollection.add((OrgUnitInfo)oldObject[i]);
            }
        }
        OrgUnitCollection newOrgUnitCollection = null;
        if (e.getNewValue() instanceof Object[]) {
            newOrgUnitCollection = new OrgUnitCollection();
            Object[] newObject = (Object[])e.getNewValue();
            int length = newObject.length;
            for (int i = 0; i < length; ++i) {
                if (newObject[i] == null) continue;
                newOrgUnitCollection.add((OrgUnitInfo)newObject[i]);
            }
        }
        if (e.getNewValue() instanceof StorageOrgUnitInfo) {
            if (newOrgUnitCollection == null) {
                newOrgUnitCollection = new OrgUnitCollection();
            }
            if (e.getNewValue() != null) {
                newOrgUnitCollection.add((OrgUnitInfo)e.getNewValue());
            }
        }
        if (!SCMGroupClientUtils.isDiffrent4OrgCollection((OrgUnitCollection)oldOrgUnitCollection, (OrgUnitCollection)newOrgUnitCollection)) {
            return;
        }
        this.bizPromptSaleOrgUnit.setValue(null);
        this.bizPrmtCustomerFrom.setValue(null);
        this.bizPrmtCustomerTo.setValue(null);
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        Object obj = this.bizStorageOrgUnit.getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
        StorageOrgUnitInfo[] storageOrgUnitInfos = null;
        HashSet<String> storageIDs = new HashSet<String>();
        HashSet<String> saleIDs = new HashSet<String>();
        if (obj instanceof Object[]) {
            int length = ((Object[])obj).length;
            for (int i = 0; i < length; ++i) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)((Object[])obj)[i];
                if (storageOrgUnitInfo == null) continue;
                storageIDs.add(storageOrgUnitInfo.getId().toString());
                OrgUnitCollection orgUnitCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)storageOrgUnitInfo.getId());
                int size = orgUnitCollection.size();
                for (int j = 0; j < size; ++j) {
                    saleIDs.add(orgUnitCollection.get(j).getId().toString());
                }
            }
        } else if (obj instanceof StorageOrgUnitInfo && (storageOrgUnitInfo = (StorageOrgUnitInfo)obj) != null) {
            storageIDs.add(storageOrgUnitInfo.getId().toString());
            OrgUnitCollection orgUnitCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)storageOrgUnitInfo.getId());
            int size = orgUnitCollection.size();
            for (int j = 0; j < size; ++j) {
                saleIDs.add(orgUnitCollection.get(j).getId().toString());
            }
        }
        if (storageIDs.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", storageIDs, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            StorageOrgUnitCollection storageOrgUnitCollection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
            int size = storageOrgUnitCollection.size();
            if (storageOrgUnitCollection != null && size > 0) {
                storageOrgUnitInfos = new StorageOrgUnitInfo[size];
                for (int i = 0; i < size; ++i) {
                    storageOrgUnitInfos[i] = storageOrgUnitCollection.get(i);
                }
            }
        }
        CompanyOrgUnitInfo[] companyOrgUnitInfos = null;
        if (storageOrgUnitInfos != null && storageOrgUnitInfos.length > 0) {
            companyOrgUnitInfos = InvClientUtils.getCompanyInfos2(storageOrgUnitInfos);
        }
        if (null == companyOrgUnitInfos || companyOrgUnitInfos.length == 0) {
            this.setCustomerFilter(null, this.bizPrmtCustomerFrom);
            this.setCustomerFilter(null, this.bizPrmtCustomerTo);
            return;
        }
        HashSet<CompanyOrgUnitInfo> companySet = new HashSet<CompanyOrgUnitInfo>();
        int length = companyOrgUnitInfos.length;
        for (int i = 0; i < length; ++i) {
            if (companyOrgUnitInfos[i] == null) continue;
            companySet.add(companyOrgUnitInfos[i]);
        }
        if (companySet.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyMustSame"));
            this.bizStorageOrgUnit.setData(e.getOldValue());
        }
        if (companySet.size() == 1) {
            if (saleIDs.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", saleIDs, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                this.bizPromptSaleOrgUnit.setEntityViewInfo(viewInfo);
                this.bizPromptSaleOrgUnit.setCommitFormat("$number$");
                this.bizPromptSaleOrgUnit.setDisplayFormat("$name$");
                this.bizPromptSaleOrgUnit.setEditFormat("$number$");
            }
            this.prmtCompanyOrgUnit.setData((Object)companyOrgUnitInfos[0]);
            this.setCustomerFilter(companyOrgUnitInfos[0], this.bizPrmtCustomerFrom);
            this.setCustomerFilter(companyOrgUnitInfos[0], this.bizPrmtCustomerTo);
            this.setDefaultYearAndProidValue(companyOrgUnitInfos[0]);
        }
    }

    public void clear() {
        this.bizPromptSaleOrgUnit.setValue(null);
        this.bizPrmtCustomerFrom.setValue(null);
        this.bizPrmtCustomerTo.setValue(null);
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        this.numberFrom.setText(null);
        this.numberTo.setText(null);
        this.setUIDefaultValue();
        super.clear();
    }

    private void setCustomerFilter(CompanyOrgUnitInfo companyInfo, KDBizPromptBox bizPrmtCustomer) throws Exception {
        if (companyInfo != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0), CompareType.EQUALS));
            evi.setFilter(filterInfo);
            String queryInfo = "com.kingdee.eas.scm.sd.sale.app.F7ConsignCustomerCompanyQuery";
            bizPrmtCustomer.setQueryInfo(queryInfo);
            bizPrmtCustomer.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
            bizPrmtCustomer.setEntityViewInfo(evi);
            bizPrmtCustomer.setCommitFormat("$number$");
            bizPrmtCustomer.setDisplayFormat("$name$");
            bizPrmtCustomer.setEditFormat("$number$");
            GeneralKDPromptSelectorAdaptor selectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPrmtCustomer, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            bizPrmtCustomer.setSelector((KDPromptSelector)selectorAdaptor);
            bizPrmtCustomer.addSelectorListener((SelectorListener)selectorAdaptor);
        } else {
            this.setBizCustomerF7(bizPrmtCustomer, null);
            this.setBizMaterialF7(this.bizPrmtMaterialFrom, false, null);
            this.setBizMaterialF7(this.bizPrmtMaterialTo, false, null);
        }
    }
}

