/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.credit.client.CreditCheck;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillCollection;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryCollection;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillFactory;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleException;
import com.kingdee.eas.scm.sd.sale.IConsignSaleBill;
import com.kingdee.eas.scm.sd.sale.client.AbstractConsignSaleBillListUI;
import com.kingdee.eas.scm.sd.sale.client.ConsignSaleBillConditionUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConsignSaleBillListUI
extends AbstractConsignSaleBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(ConsignSaleBillListUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.ConsignSaleBalanceResource";
    private ConsignSaleBillConditionUI conditionPanel = null;
    String userId = null;
    private static String[] NUMBERTAB = new String[]{"entrys.unWriteOffQty", "entrys.writeOffQty", "entrys.writeOffPrice", "entrys.writeOffAmount"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionUnAudit.setEnabled(false);
        this.actionUnAudit.setVisible(false);
        this.actionAudit.setEnabled(false);
        this.actionAudit.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionUnVerify.setEnabled(true);
        this.actionRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionView.setVisible(true);
        this.actionView.setEnabled(true);
        this.setTableAmountPrecision(SysContext.getSysContext().getCurrentFIUnit());
        String[] columnFormatter = new String[]{"entrys.unWriteOffQty", "entrys.writeOffQty", "entrys.writeOffPrice"};
        int length = columnFormatter.length;
        for (int i = 0; i < length; ++i) {
            this.tblMain.getColumn(columnFormatter[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        this.userId = user.getId().toString();
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])NUMBERTAB, (String)"%{0.##########}f");
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"bizdate"};
    }

    private void setTableAmountPrecision(CompanyOrgUnitInfo cou) {
        int amtPrecision = 2;
        try {
            amtPrecision = CalculateUtil.getLocalCurrencyPrecision(null, (CompanyOrgUnitInfo)cou);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        InvClientUtils.fmtTableAmt((KDTable)this.tblMain, (String)"entrys.writeOffAmount", (int)amtPrecision);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemUnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.btnUnVerify.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.menuItemExportData.setVisible(false);
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ConsignSaleBillConditionUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new ConsignSaleBillConditionUI();
        }
        return this.conditionPanel;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        return filterInfo;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return "companyOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SaleIssueBillFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
    }

    @Override
    public void actionUnVerify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IConsignSaleBill iConsignSaleBill = ConsignSaleBillFactory.getRemoteInstance();
        List billIdList = this.getSelectedIDList();
        HashSet idSet = new HashSet();
        idSet.addAll(billIdList);
        FilterInfo idfilter = new FilterInfo();
        idfilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        if (!iConsignSaleBill.exists(idfilter)) {
            throw new ConsignSaleException(ConsignSaleException.RECORD_ERROR);
        }
        ArrayList checkBillIdList = new ArrayList();
        ArrayList<List> list = new ArrayList<List>();
        checkBillIdList.addAll(billIdList);
        HashSet billSet = new HashSet(billIdList);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billSet, CompareType.INCLUDE));
        entityView.setFilter(filter);
        ConsignSaleBillCollection coll = iConsignSaleBill.getConsignSaleBillCollection(entityView);
        ConsignSaleBillInfo info = null;
        ConsignSaleBillEntryInfo entry = null;
        ConsignSaleBillEntryCollection entryColl = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            entryColl = info.getEntrys();
            for (int j = 0; j < entryColl.size(); ++j) {
                entry = entryColl.get(j);
                if (!entry.getTransactionType().getId().toString().equals("DawAAAAPoBGwCNyn") || !checkBillIdList.contains(info.getId().toString())) continue;
                checkBillIdList.remove(info.getId().toString());
            }
        }
        list.add(0, billIdList);
        list.add(1, checkBillIdList);
        List billSaleIssueBillID = this.getSelectedSaleIssueBillIDList();
        HashMap<String, String> storageMap = new HashMap<String, String>();
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        int blockCount = selectManager.size();
        int storageIdField = this.tblMain.getColumnIndex("storage.id");
        int stroageNameField = this.tblMain.getColumnIndex("storageOrgUnit.name");
        IRow row = null;
        Object storageID = null;
        String storageName = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = selectManager.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                row = this.tblMain.getRow(j);
                storageID = row.getCell(storageIdField).getValue();
                if (storageID == null || storageID.toString().trim().length() == 0) continue;
                storageName = row.getCell(stroageNameField).getValue().toString();
                if (storageMap.containsKey(storageID.toString())) continue;
                storageMap.put(storageID.toString(), storageName);
            }
        }
        List storageUnPermissionList = this.isAuthoriedForOrg(storageMap);
        if (storageUnPermissionList.size() > 0) {
            StringBuffer unPermissionStorageStr = new StringBuffer();
            unPermissionStorageStr.append(EASResource.getString((String)resClassName, (String)"beginStr"));
            int size = storageUnPermissionList.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    unPermissionStorageStr.append("\u3001");
                }
                unPermissionStorageStr.append(storageUnPermissionList.get(i));
            }
            unPermissionStorageStr.append(EASResource.getString((String)resClassName, (String)"isUnverify"));
            MsgBox.showWarning((Component)((Object)this), (String)unPermissionStorageStr.toString());
            return;
        }
        IMutexServiceControl iMutexService = MutexServiceControlFactory.getRemoteInstance();
        try {
            iMutexService.batchRequestObjIDForUpdate(billIdList);
            iMutexService.batchRequestObjIDForUpdate(billSaleIssueBillID);
            CreditCheck.checkIssuedBillAtUnSettle((ConsignSaleBillListUI)this, list);
            iConsignSaleBill.unVerify(billSaleIssueBillID, billIdList);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"unverifySuccess"));
            this.refreshList();
        }
        catch (Throwable e1) {
            logger.info((Object)e1);
            super.handUIException(e1);
        }
    }

    private List isAuthoriedForOrg(Map storageMap) throws EASBizException, BOSException {
        ArrayList storageUnPermissionList = new ArrayList();
        ArrayList<String> storagePermissionList = new ArrayList<String>();
        FullOrgUnitCollection result = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(this.userId), (OrgType)OrgType.Storage, (String)this.getViewPermission());
        if (result != null && result.size() > 0) {
            int size = result.size();
            for (int j = 0; j < size; ++j) {
                storagePermissionList.add(result.get(j).getId().toString());
            }
        }
        int count = 0;
        Iterator iterator = storageMap.keySet().iterator();
        String storageID = null;
        while (iterator.hasNext()) {
            storageID = (String)iterator.next();
            if (storagePermissionList.contains(storageID)) continue;
            storageUnPermissionList.add(count, storageMap.get(storageID));
            ++count;
        }
        return storageUnPermissionList;
    }

    protected String getViewPermission() {
        return "consign_unverify";
    }

    private List getSelectedIDList() {
        ArrayList<String> IDList = new ArrayList<String>();
        String[] strIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        String id2 = null;
        for (String id2 : strIDs) {
            if (IDList.contains(id2)) continue;
            IDList.add(id2);
        }
        return IDList;
    }

    private List getSelectedSaleIssueBillIDList() throws Exception {
        String[] strIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        return ConsignSaleBillFactory.getRemoteInstance().getSaleIssueBillList(strIDs);
    }

    public String[] getMergeColumnKeys() {
        String[] mergeCols = new String[]{"number", "period", "year", "bizDate", "balanacePerson", "storageOrgUnit.name"};
        return mergeCols;
    }

    public String getEntriesName() {
        return "entrys";
    }

    protected String getEditUIName() {
        String UIName = "com.kingdee.eas.scm.im.inv.client.SaleIssueBillEditUI";
        return UIName;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        String billId = row.getCell("sourceBillMID").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billId);
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        popUI.show();
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        String key = this.getPropertyOfBizOrg(this.getMainBizOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    cp = XMLBean.transStrToCommonCustParams((String)params);
                    com.kingdee.eas.base.commonquery.client.CustomerParams cps = new com.kingdee.eas.base.commonquery.client.CustomerParams();
                    cps = com.kingdee.eas.base.commonquery.client.CustomerParams.castToClientCustomerParams((CustomerParams)cp);
                    Object param = RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)cps);
                    Object mainOrgObject = null;
                    mainOrgObject = param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[] ? ((RptParams)RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)cps))).getObject("storageOrgUnit") : ((RptParams)RptParamsUtil.getFromCustomerParams((com.kingdee.eas.base.commonquery.client.CustomerParams)cps)).getObject("storageOrgUnit");
                    if (mainOrgObject instanceof Object[]) {
                        Object[] os = (Object[])mainOrgObject;
                        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[os.length];
                        int length = os.length;
                        for (int j = 0; j < length; ++j) {
                            if (!(os[j] instanceof StorageOrgUnitInfo)) continue;
                            storageOrgUnitInfos[j] = (StorageOrgUnitInfo)os[j];
                        }
                        return storageOrgUnitInfos;
                    }
                    if (mainOrgObject instanceof Object) {
                        return new StorageOrgUnitInfo[]{(StorageOrgUnitInfo)mainOrgObject};
                    }
                    return null;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return null;
                }
            }
        }
        return null;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.30sd.consignSale";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

