/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.sd.sale.client.AbstractEntireSingleDiscountUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class EntireSingleDiscountUI
extends AbstractEntireSingleDiscountUI {
    private static final Logger logger = CoreUIObject.getLogger(EntireSingleDiscountUI.class);
    private DiscountModeEnum discountType = null;
    private BigDecimal totalDiscountAmount = new BigDecimal("0.00");
    private boolean isSuccess = false;
    private BigDecimal orginalsinglTotalTaxAmount = null;
    private BigDecimal currentTotalTaxAmount = null;
    private int amountPrecision = 4;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.discountType = DiscountModeEnum.PERCENT;
        this.totalDiscountAmount = SysConstant.BIGZERO;
        if (this.radionPercent.isSelected()) {
            this.discountType = DiscountModeEnum.PERCENT;
            this.totalDiscountAmount = this.txtTotalDiscountPercent.getBigDecimalValue();
        } else {
            this.discountType = DiscountModeEnum.PERUNIT;
            this.totalDiscountAmount = this.txtTotalDiscountAmount.getBigDecimalValue();
        }
        if (this.discountType == DiscountModeEnum.PERUNIT && this.totalDiscountAmount != null && this.orginalsinglTotalTaxAmount != null && this.totalDiscountAmount.compareTo(this.orginalsinglTotalTaxAmount) >= 0) {
            MsgBox.showInfo((String)SaleUtil.getUIResource("NOTFULLDISCOUNT"));
            SysUtil.abort();
        }
        this.setIsSuccess(true);
        if (this.isSuccess) {
            this.actionExitCurrent_actionPerformed(e);
        }
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setIsSuccess(false);
        this.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.txtTotalDiscountAmount.setHorizontalAlignment(4);
        this.txtTotalDiscountPercent.setHorizontalAlignment(4);
        this.txtTotalDiscountAmount.setRemoveingZeroInDispaly(false);
        this.txtTotalDiscountPercent.setRemoveingZeroInDispaly(false);
        this.radionAmount.setSelected(true);
        int discountPrecision = (Integer)this.getUIContext().get("DISCOUNTPRECISION");
        this.amountPrecision = (Integer)this.getUIContext().get("AMOUNTPRECISION");
        this.orginalsinglTotalTaxAmount = new BigDecimal((String)this.getUIContext().get("ORIGINALSINGLETOTALTAXAMOUNT"));
        this.txtInitTotalTaxAmount.setText(this.orginalsinglTotalTaxAmount.setScale(this.amountPrecision, 4).toString());
        this.currentTotalTaxAmount = new BigDecimal((String)this.getUIContext().get("CURRENTTOTALTAXAMOUNT"));
        this.txtCurrentTotalTaxAmount.setText(this.currentTotalTaxAmount.setScale(this.amountPrecision, 4).toString());
        this.txtTotalDiscountAmount.setPrecision(this.amountPrecision);
        this.txtTotalDiscountPercent.setPrecision(discountPrecision);
        this.txtTotalDiscountPercent.setMaximumValue((Comparable)new BigDecimal("100.00"));
        this.txtTotalDiscountPercent.setMinimumValue((Comparable)SysConstant.BIGZERO);
        this.radionPercent.setEnabled(false);
        this.radionAmount.setEnabled(false);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setIsSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public BigDecimal getDiscountAmount() {
        return this.totalDiscountAmount;
    }

    public DiscountModeEnum getDiscountMode() {
        return this.discountType;
    }

    @Override
    protected void txtTotalDiscountAmount_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtTotalDiscountAmount.getBigDecimalValue() != null) {
            this.radionPercent.setSelected(false);
            this.radionAmount.setSelected(true);
            this.txtTotalDiscountPercent.setValue(null);
            this.txtDiscountTotalTaxAmount.setText(this.orginalsinglTotalTaxAmount.subtract(new BigDecimal(this.txtTotalDiscountAmount.getText())).toString());
        } else {
            this.txtTotalDiscountAmount.setValue(null);
        }
    }

    @Override
    protected void txtTotalDiscountPercent_dataChanged(DataChangeEvent e) throws Exception {
        if (this.txtTotalDiscountPercent.getBigDecimalValue() != null) {
            this.radionPercent.setSelected(true);
            this.radionAmount.setSelected(false);
            this.txtTotalDiscountAmount.setValue(null);
            BigDecimal discountAmount = this.orginalsinglTotalTaxAmount.multiply(this.txtTotalDiscountPercent.getBigDecimalValue().divide(new BigDecimal("100.00"))).setScale(this.amountPrecision, 4);
            this.txtDiscountTotalTaxAmount.setText(this.orginalsinglTotalTaxAmount.subtract(discountAmount).toString());
        } else {
            this.txtTotalDiscountPercent.setValue(null);
        }
    }
}

