/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ChannelTypeInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.AsstAttrPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceBathAdjustTypeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceCollection;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.framework.client.SCMPasteHelper;
import com.kingdee.eas.scm.sd.sale.IMaterialBasePriceAdjust;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustEntryInfo;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustFactory;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustInfo;
import com.kingdee.eas.scm.sd.sale.MaterialPriceAdjustException;
import com.kingdee.eas.scm.sd.sale.client.AbstractMaterialBasePriceAdjustEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MaterialBasePriceAdjustEditUI
extends AbstractMaterialBasePriceAdjustEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialBasePriceAdjustEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustResource";
    private static final String TB_MATERIAL = "material";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_MODEL = "model";
    private static final String TB_ASSISTPROPERTY = "assistProperty";
    private static final String TB_PRICETYPE = "priceType";
    private static final String TB_CHANNELTYPE = "channelType";
    private static final String TB_UNIT = "unit";
    private static final String TB_CURRENCY = "currency";
    private static final String TB_NEWPRICE = "newPrice";
    private static final String TB_OLDPRICE = "oldPrice";
    private static final String TB_NEWLOWESTPRICE = "newLowestPrice";
    private static final String TB_OLDLOWESTPRICE = "oldLowestPrice";
    private static final String TB_NEWHIGHESTPRICE = "newHighestPrice";
    private static final String TB_OLDHIGHESTPRICE = "oldHighestPrice";
    private static final String TB_NEWEFFECTDATE = "newEffectDate";
    private static final String TB_OLDEFFECTDATE = "oldEffectDate";
    private static final String TB_NEWEXPDATE = "newExpDate";
    private static final String TB_OLDEXPDATE = "oldExpDate";
    private int toAddRowIndex = 0;
    private static final String[] Prices = new String[]{"newPrice", "oldPrice", "newLowestPrice", "oldLowestPrice", "newHighestPrice", "oldHighestPrice"};
    private int f7DisplayMode = 0;
    private static final String[][] NEEDVALIDCOL = new String[][]{{"material"}, {"priceType"}, {"unit"}, {"currency"}, {"newPrice"}};
    private String[] numberForRight = new String[]{"newPrice", "oldPrice", "newLowestPrice", "oldLowestPrice", "newHighestPrice", "oldHighestPrice"};
    private ItemListener adjustChange = null;
    private DataChangeListener changeListener = null;
    private DataChangeListener effectiveDateChangeListener = null;
    private DataChangeListener expiredDateChangeListener = null;
    protected SCMClientHelper clientHelper = new SCMClientHelper((SCMBillEditUI)this);
    private int precision = 4;
    private SCMPasteHelper pasteHelper;

    public MaterialBasePriceAdjustEditUI() throws Exception {
        this.clientHelper.registerRequireColumns(NEEDVALIDCOL);
    }

    private void initSCMPasteHelper() {
        this.pasteHelper = new SCMPasteHelper(this.getDetailTable()){

            public String[] getDateFieldColumns() {
                return new String[0];
            }

            public String[] getCheckBoxFieldColumns() {
                return new String[0];
            }

            public void insertRow(int row) {
                MaterialBasePriceAdjustEditUI.this.insertLine(row);
            }

            protected void pasteAfterProcess() {
            }
        };
    }

    public void onLoad() throws Exception {
        this.initSCMPasteHelper();
        super.onLoad();
        this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.initTableF7();
        this.initPrecision();
        this.txtNumber.setMaxLength(80);
        this.prmtCU.setMaxLength(44);
        this.prmtCU.setEnabled(false);
        this.txtAdjustReason.setMaxLength(200);
        this.txtDescription.setMaxLength(80);
        this.txtAdjustAmount.setRequired(false);
        this.txtAdjustAmount.setPrecision(this.precision);
        this.txtAdjustAmount.setHorizontalAlignment(4);
        this.txtAdjustAmount.setDataType(1);
        this.adjustChange = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                MaterialBasePriceAdjustEditUI.this.adjustChange(arg0);
            }
        };
        this.comboBathAdjustType.addItemListener(this.adjustChange);
        this.changeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialBasePriceAdjustEditUI.this.changePrice();
            }
        };
        this.txtAdjustAmount.addDataChangeListener(this.changeListener);
        this.effectiveDateChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialBasePriceAdjustEditUI.this.effectiveDateChange(eventObj);
            }
        };
        this.pkNewEffectDate.addDataChangeListener(this.effectiveDateChangeListener);
        this.expiredDateChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialBasePriceAdjustEditUI.this.expiredDateChange(eventObj);
            }
        };
        this.pkNewExpDate.addDataChangeListener(this.expiredDateChangeListener);
        this.txtAdjustAmount.setEnabled(false);
        this.btnAuditResult.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.setEntryLockedCol();
        this.setNumberForRight();
    }

    private void effectiveDateChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)((Date)eventObj.getNewValue()), (Date)new Date())) {
            this.pkNewEffectDate.setValue(null, false);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_lt_currDate"));
            return;
        }
        Date expDate = (Date)this.pkNewExpDate.getValue();
        if (expDate != null && !DateTimeUtils.dayAfter((Date)expDate, (Date)((Date)eventObj.getNewValue()))) {
            this.pkNewEffectDate.setValue(null, false);
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
            return;
        }
        this.fillEffectiveDateToEntry(eventObj);
    }

    private void expiredDateChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            return;
        }
        if (DateTimeUtils.dayBefore((Date)((Date)eventObj.getNewValue()), (Date)new Date())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"expDate_cannt_lt_currDate"));
            this.pkNewExpDate.setValue(null);
            return;
        }
        Date effDate = (Date)this.pkNewEffectDate.getValue();
        if (effDate != null && DateTimeUtils.dayAfter((Date)effDate, (Date)((Date)eventObj.getNewValue()))) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
            this.pkNewExpDate.setValue(null);
            return;
        }
        this.fillExpiredDateToEntry(eventObj);
    }

    private void fillEffectiveDateToEntry(DataChangeEvent e) {
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow arow = this.kdtEntries.getRow(i);
            if (arow.getCell(TB_NEWEFFECTDATE).getValue() != null) continue;
            Date newEffectiveDate = (Date)this.pkNewEffectDate.getValue();
            Date newExpDate = (Date)arow.getCell(TB_NEWEXPDATE).getValue();
            if (newExpDate == null) {
                newExpDate = (Date)arow.getCell(TB_OLDEXPDATE).getValue();
            }
            if (newExpDate != null && DateTimeUtils.dayAfter((Date)newEffectiveDate, (Date)newExpDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
                arow.getCell(TB_NEWEFFECTDATE).setValue(null);
                continue;
            }
            arow.getCell(TB_NEWEFFECTDATE).setValue((Object)newEffectiveDate);
        }
    }

    private void fillExpiredDateToEntry(DataChangeEvent e) {
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow arow = this.kdtEntries.getRow(i);
            if (arow.getCell(TB_NEWEXPDATE).getValue() != null) continue;
            Date newExpireDate = (Date)this.pkNewExpDate.getValue();
            Date newEffectiveDate = (Date)arow.getCell(TB_NEWEFFECTDATE).getValue();
            if (newEffectiveDate == null) {
                newEffectiveDate = (Date)arow.getCell(TB_OLDEFFECTDATE).getValue();
            }
            if (newEffectiveDate != null && DateTimeUtils.dayAfter((Date)newEffectiveDate, (Date)newExpireDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
                arow.getCell(TB_NEWEXPDATE).setValue(null);
                continue;
            }
            arow.getCell(TB_NEWEXPDATE).setValue((Object)newExpireDate);
        }
    }

    private void setEntryLockedCol() {
        this.kdtEntries.getColumn(TB_MATERIALNAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_MODEL).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OLDPRICE).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OLDEFFECTDATE).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OLDHIGHESTPRICE).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OLDLOWESTPRICE).getStyleAttributes().setLocked(true);
    }

    private void initPrecision() {
        SCMClientUtils.changeTableColPrecisionByCol((int)6, (KDTable)this.kdtEntries, (String[])Prices);
    }

    protected void changePrice() {
        if (this.txtAdjustAmount.getText() != null) {
            int colIndex = this.getDetailTable().getColumnIndex(TB_NEWPRICE);
            int colIndex1 = this.getDetailTable().getColumnIndex(TB_OLDPRICE);
            BigDecimal price = SCMConstant.BIGDECIMAL_ZERO;
            if ("".equals(this.txtAdjustAmount.getText())) {
                this.txtAdjustAmount.setText("0");
            }
            BigDecimal priceChange = new BigDecimal(this.txtAdjustAmount.getText());
            priceChange = priceChange.setScale(this.precision, RoundingMode.HALF_UP);
            MaterialBasePriceBathAdjustTypeEnum tempEnum = (MaterialBasePriceBathAdjustTypeEnum)this.comboBathAdjustType.getSelectedItem();
            if (tempEnum == MaterialBasePriceBathAdjustTypeEnum.ADJUST_BY_RATE && priceChange.signum() == -1 && priceChange.abs().compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"rateadjust_cannt_lt100"));
                this.txtAdjustAmount.setText("");
                return;
            }
            int n = this.getDetailTable().getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.kdtEntries.getRow(i);
                if (row.getCell(TB_OLDPRICE).getValue() == null) continue;
                if (this.getDetailTable().getCell(i, colIndex1).getValue() != null) {
                    price = new BigDecimal(this.getDetailTable().getCell(i, colIndex1).getValue() + "");
                }
                if (tempEnum == MaterialBasePriceBathAdjustTypeEnum.ADJUST_BY_SUM) {
                    BigDecimal newPrice = price.add(priceChange);
                    if (newPrice.compareTo(SCMClientUtils.ZERO) > 0) {
                        this.getDetailTable().getCell(i, colIndex).setValue((Object)newPrice);
                    } else {
                        this.getDetailTable().getCell(i, colIndex).setValue(null);
                    }
                }
                if (tempEnum != MaterialBasePriceBathAdjustTypeEnum.ADJUST_BY_RATE) continue;
                BigDecimal div = SCMConstant.BIGDECIMAL_ONE.add(priceChange.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 3, 3));
                BigDecimal newPrice = price.multiply(div);
                if (newPrice.compareTo(SCMClientUtils.ZERO) >= 0) {
                    this.getDetailTable().getCell(i, colIndex).setValue((Object)newPrice);
                    continue;
                }
                this.getDetailTable().getCell(i, colIndex).setValue(null);
            }
        }
    }

    private void initTableF7() {
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setEditFormat("$name$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$;$helpCode$");
        bizMaterialBox.setEditable(true);
        this.setBizMaterial(bizMaterialBox, null, null);
        this.kdtEntries.getColumn(TB_MATERIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_MATERIAL).setRenderer((IBasicRender)avr);
        KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
        bizAssistPropertyBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.AsstAttrValueF7Query");
        bizAssistPropertyBox.setEditFormat("$number$");
        bizAssistPropertyBox.setDisplayFormat("$name$");
        bizAssistPropertyBox.setCommitFormat("$number$");
        this.kdtEntries.getColumn(TB_ASSISTPROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
        KDBizPromptBox bizPriceTypeBox = new KDBizPromptBox();
        bizPriceTypeBox.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7PriceTypeQuery");
        bizPriceTypeBox.setEditFormat("$number$");
        bizPriceTypeBox.setDisplayFormat("$name$");
        bizPriceTypeBox.setCommitFormat("$number$");
        bizPriceTypeBox.setEditable(true);
        this.kdtEntries.getColumn(TB_PRICETYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPriceTypeBox));
        KDBizPromptBox bizChannelTypeBox = new KDBizPromptBox();
        bizChannelTypeBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7ChannelTypeDefaultQuery");
        bizChannelTypeBox.setEditFormat("$number$");
        bizChannelTypeBox.setDisplayFormat("$name$");
        bizChannelTypeBox.setCommitFormat("$number$");
        bizChannelTypeBox.setEditable(true);
        this.kdtEntries.getColumn(TB_CHANNELTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizChannelTypeBox));
        this.kdtEntries.getColumn(TB_CHANNELTYPE).getStyleAttributes().setLocked(true);
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        this.kdtEntries.getColumn(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        this.kdtEntries.getColumn(TB_UNIT).getStyleAttributes().setLocked(false);
        KDBizPromptBox bizCurrencyBox = new KDBizPromptBox();
        bizCurrencyBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        bizCurrencyBox.setEditFormat("$number$");
        bizCurrencyBox.setDisplayFormat("$name$");
        bizCurrencyBox.setCommitFormat("$number$");
        bizCurrencyBox.setEditable(true);
        this.kdtEntries.getColumn(TB_CURRENCY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCurrencyBox));
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setNegatived(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.kdtEntries.getColumn(TB_NEWPRICE).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(TB_OLDPRICE).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(TB_NEWLOWESTPRICE).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(TB_OLDLOWESTPRICE).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(TB_NEWHIGHESTPRICE).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(TB_OLDHIGHESTPRICE).setEditor((ICellEditor)editor);
        this.initEntriesTable();
        this.initEntriesTableListener();
    }

    public void adjustChange(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (evt.getSource() == this.comboBathAdjustType) {
            if (MaterialBasePriceBathAdjustTypeEnum.NOT_BATH_ADJUST.compareTo(this.comboBathAdjustType.getSelectedItem()) == 0) {
                this.txtAdjustAmount.setValue(null);
                this.txtAdjustAmount.setEnabled(false);
            } else {
                this.txtAdjustAmount.setValue(null);
                this.txtAdjustAmount.setEnabled(true);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().getValue() == 2) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"submit_cant_save"));
            return;
        }
        try {
            if (this.editData != null && this.editData.getId() != null) {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
        }
        catch (Throwable e1) {
            super.handUIException(e1);
            return;
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        MaterialBasePriceAdjustInfo info;
        this.checkCanSubmit();
        try {
            if (this.editData != null && this.editData.getId() != null) {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
        }
        catch (Throwable e1) {
            super.handUIException(e1);
            return;
        }
        if (this.editData.getId() != null && (info = MaterialBasePriceAdjustFactory.getRemoteInstance().getMaterialBasePriceAdjustInfo((IObjectPK)new ObjectStringPK(this.editData.getId().toString()))).getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"audit_cannt_submit"));
            SysUtil.abort();
        }
        this.storeFields();
        super.actionSubmit_actionPerformed(e);
        this.refreshCurPage();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"submit_after_save"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IMaterialBasePriceAdjust iMaterial = MaterialBasePriceAdjustFactory.getRemoteInstance();
        MaterialBasePriceAdjustInfo info = iMaterial.getMaterialBasePriceAdjustInfo((IObjectPK)pk);
        if (info.getBaseStatus().getValue() != 2) {
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"notsubmit_cannt_audit"));
            return;
        }
        this.multiApproveIfInWF();
        iMaterial.audit((IObjectPK)pk);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
        this.refreshCurPage();
    }

    private void checkCanSubmit() throws Exception {
        int nrow;
        if (this.prmtCU.getData() == null) {
            this.prmtCU.requestFocus();
            super.handleException((Exception)((Object)new MaterialPriceAdjustException(MaterialPriceAdjustException.FIELD_CANNOT_EMPTY, new String[]{EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"63_MaterialBasePriceAdjustEditUI")})));
            SysUtil.abort();
        }
        if ((nrow = this.kdtEntries.getRowCount()) <= 0) {
            throw new MaterialPriceAdjustException(MaterialPriceAdjustException.ENTRY_CANNOT_EMPTY);
        }
        this.clientHelper.checkEntryRquiredColumns();
        HashSet<String> materialIDSet = new HashSet<String>();
        HashSet<String> currencyIDSet = new HashSet<String>();
        HashSet<String> unitIDSet = new HashSet<String>();
        HashSet<String> priceTypeIDSet = new HashSet<String>();
        ArrayList list = new ArrayList();
        String num = "";
        for (int i = 0; i < nrow; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            PriceTypeInfo ptInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue();
            if ("04".equals(ptInfo.getNumber()) && row.getCell(TB_CHANNELTYPE).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"CHANNELTYPEISNOTNULL"));
                this.kdtEntries.getEditManager().editCellAt(i, row.getCell(TB_CHANNELTYPE).getColumnIndex());
                SysUtil.abort();
            }
            BigDecimal p = (BigDecimal)row.getCell(TB_NEWPRICE).getValue();
            this.checkPriceInScope(row, p, list);
            MaterialInfo materialInfo = null;
            if (row.getCell(TB_MATERIAL).getValue() != null) {
                materialInfo = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
            }
            CurrencyInfo currencyInfo = null;
            if (row.getCell(TB_CURRENCY).getValue() != null) {
                currencyInfo = (CurrencyInfo)row.getCell(TB_CURRENCY).getValue();
            }
            MeasureUnitInfo measureUnitInfo = null;
            if (row.getCell(TB_UNIT).getValue() != null) {
                measureUnitInfo = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
            }
            PriceTypeInfo priceTypeInfo = null;
            if (row.getCell(TB_PRICETYPE).getValue() != null) {
                priceTypeInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue();
            }
            if (materialInfo == null || currencyInfo == null || measureUnitInfo == null || priceTypeInfo == null) continue;
            if (!materialIDSet.contains(materialInfo.getId().toString())) {
                materialIDSet.add(materialInfo.getId().toString());
            }
            if (!currencyIDSet.contains(currencyInfo.getId().toString())) {
                currencyIDSet.add(currencyInfo.getId().toString());
            }
            if (!unitIDSet.contains(measureUnitInfo.getId().toString())) {
                unitIDSet.add(measureUnitInfo.getId().toString());
            }
            if (priceTypeIDSet.contains(priceTypeInfo.getNumber().toString())) continue;
            priceTypeIDSet.add(priceTypeInfo.getNumber().toString());
        }
        int tt = 0;
        if (list.size() > 0) {
            Object[] temp = list.toArray();
            int size = temp.length;
            for (int i = 0; i < size; ++i) {
                tt = (Integer)temp[i] + 1;
                num = num + Integer.toString(tt);
                if (i == size - 1) continue;
                num = num + ",";
            }
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"price_notin_scope1"), num));
            SysUtil.abort();
        }
        this.checkCanSubmitData(materialIDSet, currencyIDSet, unitIDSet, priceTypeIDSet);
        this.checkEntryDataRepeat();
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        IRow row = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            PriceTypeInfo priceTypeInfo;
            row = this.kdtEntries.getRow(i);
            if (row.getCell(TB_PRICETYPE).getValue() != null && (priceTypeInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue()) != null && "04".equals(priceTypeInfo.getNumber())) {
                row.getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(false);
            }
            if (row.getCell(TB_MATERIAL).getValue() != null) {
                MaterialInfo materialinfo = (MaterialInfo)this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue();
                this.setUnitFilterByMaterial(materialinfo, i);
            }
            this.setEntryAssistProperty(row.getRowIndex(), (MaterialInfo)this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue());
        }
    }

    private void initEntriesTableListener() {
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                MaterialBasePriceAdjustEditUI.this.propertyEditStopped(e);
            }
        });
    }

    private void propertyEditStopped(KDTEditEvent e) {
        Date newExpireDate;
        Date newEffectiveDate;
        BigDecimal newPrice;
        IRow arow;
        BigDecimal newPrice2;
        MaterialBasePriceInfo info;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (e.getOldValue() == e.getValue()) {
            return;
        }
        String columnName = this.kdtEntries.getColumn(colIndex).getKey();
        if (TB_MATERIAL.equalsIgnoreCase(columnName)) {
            MaterialInfo[] materialInfos = new MaterialInfo[1];
            Object[] nobjs = null;
            if (e.getValue() != null) {
                if (e.getValue() instanceof MaterialInfo[]) {
                    materialInfos = (MaterialInfo[])e.getValue();
                } else if (e.getValue() instanceof Object[]) {
                    nobjs = (Object[])e.getValue();
                } else {
                    materialInfos[0] = (MaterialInfo)e.getValue();
                }
            }
            MaterialInfo[] materialOldInfos = new MaterialInfo[1];
            Object[] objs = null;
            if (e.getOldValue() != null) {
                if (e.getOldValue() instanceof MaterialInfo[]) {
                    materialOldInfos = (MaterialInfo[])e.getOldValue();
                } else if (e.getOldValue() instanceof Object[]) {
                    objs = (Object[])e.getOldValue();
                    materialOldInfos[0] = (MaterialInfo)objs[0];
                } else {
                    materialOldInfos[0] = (MaterialInfo)e.getOldValue();
                }
            }
            this.toAddRowIndex = rowIndex;
            if (nobjs != null) {
                int n = nobjs.length;
                for (int i = 0; i < n; ++i) {
                    MaterialInfo materialInfot = (MaterialInfo)nobjs[i];
                    this.materialChanged(materialInfot, materialOldInfos[0], rowIndex, colIndex);
                }
            } else if (materialInfos != null && materialInfos.length != 0) {
                for (MaterialInfo materialInfot : materialInfos) {
                    this.materialChanged(materialInfot, materialOldInfos[0], rowIndex, colIndex);
                }
            }
        }
        if (TB_CURRENCY.equalsIgnoreCase(columnName)) {
            this.cleanMaterialPrice(rowIndex);
            info = this.getMaterialBasePrice(rowIndex);
            this.fillRowData(rowIndex, info);
        }
        if (TB_ASSISTPROPERTY.equalsIgnoreCase(columnName)) {
            this.cleanMaterialPrice(rowIndex);
            info = this.getMaterialBasePrice(rowIndex);
            this.fillRowData(rowIndex, info);
        }
        if (TB_PRICETYPE.equalsIgnoreCase(columnName)) {
            if (e.getValue() != null && "04".equals(((PriceTypeInfo)e.getValue()).getNumber())) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(false);
                this.kdtEntries.getRow(rowIndex).getCell(TB_CHANNELTYPE).getStyleAttributes().setBackground(UIManager.getColor("TextField.requiredBackground"));
            }
            if (e.getValue() == null || !"04".equals(((PriceTypeInfo)e.getValue()).getNumber())) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_CHANNELTYPE).setValue(null);
                this.kdtEntries.getRow(rowIndex).getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(true);
                this.kdtEntries.getRow(rowIndex).getCell(TB_CHANNELTYPE).getStyleAttributes().setBackground(Color.white);
            }
            this.cleanMaterialPrice(rowIndex);
            info = this.getMaterialBasePrice(rowIndex);
            this.fillRowData(rowIndex, info);
        }
        if (TB_CHANNELTYPE.equalsIgnoreCase(columnName)) {
            this.cleanMaterialPrice(rowIndex);
            info = this.getMaterialBasePrice(rowIndex);
            this.fillRowData(rowIndex, info);
        }
        if (TB_UNIT.equalsIgnoreCase(columnName)) {
            this.cleanMaterialPrice(rowIndex);
            info = this.getMaterialBasePrice(rowIndex);
            this.fillRowData(rowIndex, info);
        }
        if (TB_NEWPRICE.equalsIgnoreCase(columnName) && ((newPrice2 = (BigDecimal)(arow = this.kdtEntries.getRow(e.getRowIndex())).getCell(TB_NEWPRICE).getValue()) == null || newPrice2.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 1)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"price_gt_zero"));
            arow.getCell(TB_NEWPRICE).setValue(null);
            return;
        }
        if (TB_NEWLOWESTPRICE.equalsIgnoreCase(columnName)) {
            BigDecimal newPriceMax;
            arow = this.kdtEntries.getRow(e.getRowIndex());
            BigDecimal newPriceMin = e.getValue() != null && ((BigDecimal)e.getValue()).compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 ? (BigDecimal)e.getValue() : null;
            arow.getCell(TB_NEWLOWESTPRICE).setValue(newPriceMin);
            BigDecimal bigDecimal = newPriceMax = arow.getCell(TB_NEWHIGHESTPRICE).getValue() != null ? (BigDecimal)arow.getCell(TB_NEWHIGHESTPRICE).getValue() : null;
            if (newPriceMax == null) {
                BigDecimal bigDecimal2 = newPriceMax = arow.getCell(TB_OLDHIGHESTPRICE).getValue() != null ? (BigDecimal)arow.getCell(TB_OLDHIGHESTPRICE).getValue() : null;
            }
            if (newPriceMin != null && newPriceMax != null && newPriceMin.compareTo(newPriceMax) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"priceMin_cannt_gt_priceMax"));
                arow.getCell(TB_NEWLOWESTPRICE).setValue(null);
                return;
            }
            newPrice = (BigDecimal)arow.getCell(TB_NEWPRICE).getValue();
            if (newPrice == null) {
                newPrice = (BigDecimal)arow.getCell(TB_OLDPRICE).getValue();
            }
        }
        if (TB_NEWHIGHESTPRICE.equalsIgnoreCase(columnName)) {
            BigDecimal newPriceMin;
            arow = this.kdtEntries.getRow(e.getRowIndex());
            BigDecimal newPriceMax = e.getValue() != null && ((BigDecimal)e.getValue()).compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 ? (BigDecimal)e.getValue() : null;
            arow.getCell(TB_NEWHIGHESTPRICE).setValue(newPriceMax);
            BigDecimal bigDecimal = newPriceMin = arow.getCell(TB_NEWLOWESTPRICE).getValue() != null ? (BigDecimal)arow.getCell(TB_NEWLOWESTPRICE).getValue() : null;
            if (newPriceMin == null) {
                BigDecimal bigDecimal3 = newPriceMin = arow.getCell(TB_OLDLOWESTPRICE).getValue() != null ? (BigDecimal)arow.getCell(TB_OLDLOWESTPRICE).getValue() : null;
            }
            if (newPriceMax != null && newPriceMin != null && newPriceMax.compareTo(newPriceMin) < 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"priceMin_cannt_gt_priceMax"));
                arow.getCell(TB_NEWHIGHESTPRICE).setValue(null);
                return;
            }
            newPrice = (BigDecimal)arow.getCell(TB_NEWPRICE).getValue();
            if (newPrice == null) {
                newPrice = (BigDecimal)arow.getCell(TB_OLDPRICE).getValue();
            }
        }
        if (TB_NEWEFFECTDATE.equalsIgnoreCase(columnName) && (newEffectiveDate = (Date)(arow = this.kdtEntries.getRow(e.getRowIndex())).getCell(TB_NEWEFFECTDATE).getValue()) != null) {
            if (DateTimeUtils.dayBefore((Date)newEffectiveDate, (Date)new Date())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_lt_currDate"));
                arow.getCell(TB_NEWEFFECTDATE).setValue(null);
                return;
            }
            Date newExpDate = (Date)arow.getCell(TB_NEWEXPDATE).getValue();
            if (newExpDate == null) {
                newExpDate = (Date)arow.getCell(TB_OLDEXPDATE).getValue();
            }
            if (newExpDate != null && DateTimeUtils.dayAfter((Date)newEffectiveDate, (Date)newExpDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
                arow.getCell(TB_NEWEFFECTDATE).setValue(null);
            }
        }
        if (TB_NEWEXPDATE.equalsIgnoreCase(columnName) && (newExpireDate = (Date)(arow = this.kdtEntries.getRow(e.getRowIndex())).getCell(TB_NEWEXPDATE).getValue()) != null) {
            if (DateTimeUtils.dayBefore((Date)newExpireDate, (Date)new Date())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"expDate_cannt_lt_currDate"));
                arow.getCell(TB_NEWEXPDATE).setValue(null);
                return;
            }
            Date newEffectiveDate2 = (Date)arow.getCell(TB_NEWEFFECTDATE).getValue();
            if (newEffectiveDate2 == null) {
                newEffectiveDate2 = (Date)arow.getCell(TB_OLDEFFECTDATE).getValue();
            }
            if (newEffectiveDate2 != null && DateTimeUtils.dayAfter((Date)newEffectiveDate2, (Date)newExpireDate)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"effDate_cannt_gt_expDate"));
                arow.getCell(TB_NEWEXPDATE).setValue(null);
            }
        }
    }

    private void fillRowData(int rowIndex, MaterialBasePriceInfo info) {
        if (info != null) {
            IRow row = this.kdtEntries.getRow(rowIndex);
            row.getCell(TB_OLDPRICE).setValue((Object)info.getPrice());
            row.getCell(TB_OLDLOWESTPRICE).setValue((Object)info.getFloorPrice());
            row.getCell(TB_OLDHIGHESTPRICE).setValue((Object)info.getMaxPrice());
            row.getCell(TB_OLDEFFECTDATE).setValue((Object)info.getEffectiveDate());
            row.getCell(TB_OLDEXPDATE).setValue((Object)info.getExpireDate());
            row.getCell(TB_NEWPRICE).setValue((Object)info.getPrice());
            row.getCell(TB_NEWLOWESTPRICE).setValue((Object)info.getFloorPrice());
            row.getCell(TB_NEWHIGHESTPRICE).setValue((Object)info.getMaxPrice());
        }
    }

    private MaterialBasePriceInfo getMaterialBasePrice(int rowIndex) {
        IRow row = this.kdtEntries.getRow(rowIndex);
        MaterialInfo materialInfo = null;
        if (row.getCell(TB_MATERIAL).getValue() != null) {
            materialInfo = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
        }
        MeasureUnitInfo measureUnitInfo = null;
        if (row.getCell(TB_UNIT).getValue() != null) {
            measureUnitInfo = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
        }
        CurrencyInfo currencyInfo = null;
        if (row.getCell(TB_CURRENCY).getValue() != null) {
            currencyInfo = (CurrencyInfo)row.getCell(TB_CURRENCY).getValue();
        }
        PriceTypeInfo priceTypeInfo = null;
        if (row.getCell(TB_PRICETYPE).getValue() != null) {
            priceTypeInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue();
        }
        AsstAttrValueInfo asst = null;
        if (row.getCell(TB_ASSISTPROPERTY).getValue() != null) {
            asst = (AsstAttrValueInfo)row.getCell(TB_ASSISTPROPERTY).getValue();
        }
        ChannelTypeInfo channelTypeInfo = null;
        if (row.getCell(TB_CHANNELTYPE).getValue() != null) {
            channelTypeInfo = (ChannelTypeInfo)row.getCell(TB_CHANNELTYPE).getValue();
        }
        if (materialInfo == null || measureUnitInfo == null || currencyInfo == null || priceTypeInfo == null) {
            return null;
        }
        if ("04".equals(priceTypeInfo.getNumber().toString()) && channelTypeInfo == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)measureUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("priceType.number", (Object)priceTypeInfo.getNumber().toString(), CompareType.EQUALS));
        if ("04".equals(priceTypeInfo.getNumber().toString())) {
            filter.getFilterItems().add(new FilterItemInfo("channelType.number", (Object)channelTypeInfo.getNumber(), CompareType.EQUALS));
        }
        if (asst != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)asst.getId().toString(), CompareType.EQUALS));
        }
        CtrlUnitInfo cu = null;
        if (this.prmtCU.getValue() != null && this.prmtCU.getValue() instanceof CtrlUnitInfo) {
            cu = (CtrlUnitInfo)this.prmtCU.getValue();
        }
        if (cu != null && cu.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getSelectors());
        MaterialBasePriceInfo materialBasePriceInfo = null;
        try {
            CoreBaseCollection coreBaseCollection = MaterialBasePriceFactory.getRemoteInstance().getCollection(viewInfo);
            Iterator iterator = coreBaseCollection.iterator();
            if (iterator.hasNext()) {
                materialBasePriceInfo = (MaterialBasePriceInfo)iterator.next();
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return materialBasePriceInfo;
    }

    private void setNumberForRight() {
        int num = this.numberForRight.length;
        for (int i = 0; i < num; ++i) {
            this.kdtEntries.getColumn(this.numberForRight[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private void checkPriceInScope(IRow row, BigDecimal price, ArrayList l1) {
        BigDecimal newPriceMin = (BigDecimal)row.getCell(TB_NEWLOWESTPRICE).getValue();
        BigDecimal newPriceMax = (BigDecimal)row.getCell(TB_NEWHIGHESTPRICE).getValue();
        BigDecimal oldPrice = (BigDecimal)row.getCell(TB_OLDPRICE).getValue();
        BigDecimal newPrice = price;
        if (newPriceMin != null && newPrice != null && newPrice.compareTo(newPriceMin) < 0) {
            l1.add(row.getRowIndex());
        }
        if (newPriceMax != null && newPrice != null && newPrice.compareTo(newPriceMax) > 0) {
            l1.add(row.getRowIndex());
        }
    }

    private void materialChanged(MaterialInfo materialInfo, MaterialInfo oldMaterialInfo, int rowIndex, int colIndex) {
        if (materialInfo == oldMaterialInfo || materialInfo != null && oldMaterialInfo != null && materialInfo.getId().toString().equals(oldMaterialInfo.getId().toString()) && this.toAddRowIndex == rowIndex) {
            this.kdtEntries.getRow(rowIndex).getCell(TB_MATERIAL).setValue((Object)oldMaterialInfo);
            this.toAddRowIndex = rowIndex + 1;
            return;
        }
        if (rowIndex == this.toAddRowIndex) {
            this.cleanRowDate(rowIndex);
        }
        if (materialInfo != null) {
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
                CtrlUnitInfo cu = null;
                if (this.prmtCU.getValue() != null && this.prmtCU.getValue() instanceof CtrlUnitInfo) {
                    cu = (CtrlUnitInfo)this.prmtCU.getValue();
                }
                if (cu != null && cu.getId() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
                }
                viewInfo.setFilter(filter);
                viewInfo.setSelector(this.getSelectors());
                CoreBaseCollection coreBaseCollection = MaterialBasePriceFactory.getRemoteInstance().getCollection(viewInfo);
                Iterator iterator = coreBaseCollection.iterator();
                int precision = 0;
                if (!iterator.hasNext()) {
                    if (this.toAddRowIndex != rowIndex) {
                        this.insertLine(this.toAddRowIndex);
                    }
                    if ((precision = materialInfo.getPricePrecision()) != 0) {
                        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kdtEntries, (String[])Prices, (int)this.toAddRowIndex);
                    }
                    this.materialInfoToRow(materialInfo, this.toAddRowIndex);
                    ++this.toAddRowIndex;
                }
                while (iterator.hasNext()) {
                    MaterialBasePriceInfo materialBasePriceInfo = (MaterialBasePriceInfo)iterator.next();
                    IRow arow = null;
                    if (this.toAddRowIndex == rowIndex) {
                        arow = this.kdtEntries.getRow(this.toAddRowIndex);
                    } else {
                        this.insertLine(this.toAddRowIndex);
                        arow = this.kdtEntries.getRow(this.toAddRowIndex);
                    }
                    if (materialBasePriceInfo != null) {
                        this.priceInfoToRow(materialBasePriceInfo, arow);
                        precision = materialBasePriceInfo.getMaterial().getPricePrecision();
                        if (precision != 0) {
                            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kdtEntries, (String[])Prices, (int)this.toAddRowIndex);
                        }
                    }
                    ++this.toAddRowIndex;
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            IRow row = this.kdtEntries.getRow(this.toAddRowIndex);
            row.getCell(TB_MATERIALNAME).setValue(null);
            row.getCell(TB_MATERIAL).setValue(null);
        }
    }

    private void cleanRowDate(int rowIndex) {
        IRow row = this.kdtEntries.getRow(rowIndex);
        row.getCell(TB_ASSISTPROPERTY).setValue(null);
        row.getCell(TB_PRICETYPE).setValue(null);
        row.getCell(TB_CHANNELTYPE).setValue(null);
        row.getCell(TB_UNIT).setValue(null);
        row.getCell(TB_CURRENCY).setValue(null);
        row.getCell(TB_NEWPRICE).setValue(null);
        row.getCell(TB_OLDPRICE).setValue(null);
        row.getCell(TB_NEWLOWESTPRICE).setValue(null);
        row.getCell(TB_OLDLOWESTPRICE).setValue(null);
        row.getCell(TB_NEWHIGHESTPRICE).setValue(null);
        row.getCell(TB_OLDHIGHESTPRICE).setValue(null);
    }

    private void cleanMaterialPrice(int rowIndex) {
        IRow row = this.kdtEntries.getRow(rowIndex);
        row.getCell(TB_NEWPRICE).setValue(null);
        row.getCell(TB_OLDPRICE).setValue(null);
        row.getCell(TB_NEWLOWESTPRICE).setValue(null);
        row.getCell(TB_OLDLOWESTPRICE).setValue(null);
        row.getCell(TB_NEWHIGHESTPRICE).setValue(null);
        row.getCell(TB_OLDHIGHESTPRICE).setValue(null);
        row.getCell(TB_NEWEFFECTDATE).setValue(null);
        row.getCell(TB_OLDEFFECTDATE).setValue(null);
    }

    private void materialInfoToRow(MaterialInfo materialInfo, int rowIndex) {
        IRow row = this.getDetailTable().getRow(rowIndex);
        row.getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(true);
        row.getCell(TB_MATERIAL).setValue((Object)materialInfo);
        row.getCell(TB_MATERIALNAME).setValue((Object)materialInfo.getName());
        row.getCell(TB_MODEL).setValue((Object)materialInfo.getModel());
        if (materialInfo.getBaseUnit() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
            try {
                MeasureUnitInfo measureUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)pk);
                row.getCell(TB_UNIT).setValue((Object)measureUnitInfo);
                this.setUnitFilterByMaterial(materialInfo, rowIndex);
                row.getCell(TB_UNIT).getStyleAttributes().setLocked(false);
                this.setEntryAssistProperty(rowIndex, materialInfo);
                CurrencyInfo currencyInfo = null;
                if (materialInfo != null && row.getCell(TB_CURRENCY).getValue() == null) {
                    if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                        CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
                        if (ficompanyOrgInfo != null && ficompanyOrgInfo.getBaseCurrency() != null) {
                            try {
                                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
                            }
                            catch (EASBizException e) {
                                logger.error((Object)e);
                            }
                            catch (BOSException e) {
                                logger.error((Object)e);
                            }
                        }
                    } else {
                        EntityViewInfo currencyView = new EntityViewInfo();
                        currencyView.setFilter(new FilterInfo());
                        currencyView.getFilter().getFilterItems().add(new FilterItemInfo("isoCode", (Object)"RMB"));
                        try {
                            CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(currencyView);
                            if (currencyCollection.size() > 0) {
                                currencyInfo = currencyCollection.get(0);
                            }
                        }
                        catch (Exception e) {
                            super.handUIException((Throwable)e);
                        }
                    }
                } else if (row.getCell(TB_CURRENCY).getValue() instanceof CurrencyInfo) {
                    currencyInfo = (CurrencyInfo)row.getCell(TB_CURRENCY).getValue();
                }
                row.getCell(TB_CURRENCY).setValue(currencyInfo);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    private void setPrecisionByCurrency(CurrencyInfo currencyInfo, int rowIndex) {
        if (currencyInfo != null) {
            SCMClientUtils.changeTableColPrecision((int)currencyInfo.getPrecision(), (KDTable)this.kdtEntries, (String[])new String[]{"amount"});
        }
    }

    private void setPrecisionByMaterial(MaterialInfo materialInfo, int rowIndex) {
        if (materialInfo != null) {
            SCMClientUtils.changeTableColPrecision((int)materialInfo.getPricePrecision(), (KDTable)this.kdtEntries, (String[])new String[]{TB_NEWPRICE, TB_OLDPRICE, TB_NEWLOWESTPRICE, TB_OLDLOWESTPRICE, TB_NEWHIGHESTPRICE, TB_OLDHIGHESTPRICE}, (int)rowIndex);
        }
    }

    protected void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo) {
        if (materialInfo != null) {
            String assistAttrTypeID = materialInfo.getAssistAttr() == null ? null : materialInfo.getAssistAttr().getId().toString();
            KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
            MaterialBasePriceAdjustEditUI.setF7AssistProperty(bizAssistPropertyBox, assistAttrTypeID, (EditUI)this);
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            this.kdtEntries.getColumn(TB_ASSISTPROPERTY).setRenderer((IBasicRender)avr);
            if (assistAttrTypeID != null) {
                this.kdtEntries.getRow(rowIndex).getCell(TB_ASSISTPROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
                this.kdtEntries.getRow(rowIndex).getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
            }
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
        }
    }

    public static void setF7AssistProperty(KDBizPromptBox bizBox, String asstAttrTypeID, EditUI editUI) {
        AsstAttrPromptBox box = new AsstAttrPromptBox((IUIObject)editUI);
        bizBox.setDisplayFormat("$name$");
        bizBox.setEditFormat("$number$");
        bizBox.setCommitFormat("$number$");
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEditable(true);
        bizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7AsstAttrValueQuery");
        box.AsstAttrTypeID = asstAttrTypeID;
        EntityViewInfo viewInfo = box.getViewInfoByType(asstAttrTypeID);
        bizBox.setEntityViewInfo(viewInfo);
        bizBox.setSelector((KDPromptSelector)box);
    }

    private void setAssistPropertyFilterByMaterial(MaterialInfo materialInfo, int rowIndex) {
        KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
        bizAssistPropertyBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.AsstAttrValueF7Query");
        bizAssistPropertyBox.setEditFormat("$number$");
        bizAssistPropertyBox.setDisplayFormat("$name$");
        bizAssistPropertyBox.setCommitFormat("$number$");
        this.kdtEntries.getColumn(TB_ASSISTPROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
        if (materialInfo.getAssistAttr() != null && materialInfo.getAssistAttr().getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("basictypeid", (Object)materialInfo.getAssistAttr().getId(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            bizAssistPropertyBox.setEntityViewInfo(viewInfo);
            IRow row = this.getDetailTable().getRow(rowIndex);
            row.getCell(TB_ASSISTPROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
            row.getCell(TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
        }
    }

    private void setUnitFilterByMaterial(MaterialInfo materialInfo, int rowIndex) {
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        bizUnitBox.setEntityViewInfo(viewInfo);
        IRow row = this.getDetailTable().getRow(rowIndex);
        row.getCell(TB_UNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        row.getCell(TB_UNIT).getStyleAttributes().setLocked(false);
    }

    private void priceInfoToRow(MaterialBasePriceInfo materialBasePriceInfo, IRow arow) {
        arow.getCell(TB_MATERIAL).setValue((Object)materialBasePriceInfo.getMaterial());
        arow.getCell(TB_MATERIALNAME).setValue((Object)materialBasePriceInfo.getMaterial().getName());
        arow.getCell(TB_MODEL).setValue((Object)materialBasePriceInfo.getMaterial().getModel());
        arow.getCell(TB_ASSISTPROPERTY).setValue((Object)materialBasePriceInfo.getAssistProperty());
        this.setEntryAssistProperty(arow.getRowIndex(), materialBasePriceInfo.getMaterial());
        arow.getCell(TB_UNIT).setValue((Object)materialBasePriceInfo.getUnit());
        arow.getCell(TB_PRICETYPE).setValue((Object)materialBasePriceInfo.getPriceType());
        if (materialBasePriceInfo.getPriceType() != null && "04".equals(materialBasePriceInfo.getPriceType().getNumber())) {
            arow.getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(false);
        } else {
            arow.getCell(TB_CHANNELTYPE).getStyleAttributes().setLocked(true);
        }
        arow.getCell(TB_CHANNELTYPE).setValue((Object)materialBasePriceInfo.getChannelType());
        arow.getCell(TB_CURRENCY).setValue((Object)materialBasePriceInfo.getCurrency());
        arow.getCell(TB_OLDPRICE).setValue((Object)materialBasePriceInfo.getPrice());
        arow.getCell(TB_OLDLOWESTPRICE).setValue((Object)materialBasePriceInfo.getFloorPrice());
        arow.getCell(TB_OLDHIGHESTPRICE).setValue((Object)materialBasePriceInfo.getMaxPrice());
        arow.getCell(TB_NEWPRICE).setValue((Object)materialBasePriceInfo.getPrice());
        arow.getCell(TB_NEWLOWESTPRICE).setValue((Object)materialBasePriceInfo.getFloorPrice());
        arow.getCell(TB_NEWHIGHESTPRICE).setValue((Object)materialBasePriceInfo.getMaxPrice());
        if (MaterialBasePriceBathAdjustTypeEnum.NOT_BATH_ADJUST.compareTo(this.comboBathAdjustType.getSelectedItem()) != 0 && this.txtAdjustAmount.getText() != null && !this.txtAdjustAmount.getText().equals("")) {
            BigDecimal newPrice;
            MaterialBasePriceBathAdjustTypeEnum tempEnum = (MaterialBasePriceBathAdjustTypeEnum)this.comboBathAdjustType.getSelectedItem();
            BigDecimal priceChange = new BigDecimal(this.txtAdjustAmount.getText());
            if (tempEnum == MaterialBasePriceBathAdjustTypeEnum.ADJUST_BY_SUM && (newPrice = materialBasePriceInfo.getPrice().add(priceChange)).compareTo(SCMClientUtils.ZERO) > 0) {
                arow.getCell(TB_NEWPRICE).setValue((Object)newPrice);
            }
            if (tempEnum == MaterialBasePriceBathAdjustTypeEnum.ADJUST_BY_RATE) {
                BigDecimal div = SCMConstant.BIGDECIMAL_ONE.add(priceChange.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 3, 3));
                BigDecimal newPrice2 = materialBasePriceInfo.getPrice().multiply(div);
                if (newPrice2.compareTo(SCMClientUtils.ZERO) >= 0) {
                    arow.getCell(TB_NEWPRICE).setValue((Object)newPrice2);
                }
            }
        }
        this.setUnitFilterByMaterial(materialBasePriceInfo.getMaterial(), arow.getRowIndex());
    }

    private void initEntriesTable() {
        KDDatePicker sendDateDp = new KDDatePicker();
        String dateFormatString = SCMClientUtils.getDateFormatString();
        this.kdtEntries.getColumn(TB_NEWEFFECTDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(sendDateDp));
        this.kdtEntries.getColumn(TB_NEWEFFECTDATE).getStyleAttributes().setNumberFormat(dateFormatString);
        this.kdtEntries.getColumn(TB_OLDEFFECTDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(sendDateDp));
        this.kdtEntries.getColumn(TB_OLDEFFECTDATE).getStyleAttributes().setNumberFormat(dateFormatString);
        this.kdtEntries.getColumn(TB_NEWEXPDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(sendDateDp));
        this.kdtEntries.getColumn(TB_NEWEXPDATE).getStyleAttributes().setNumberFormat(dateFormatString);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCU;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.getMainBizOrg();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialBasePriceAdjustFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        MaterialBasePriceAdjustInfo materialBasePriceAdjustInfo = new MaterialBasePriceAdjustInfo();
        materialBasePriceAdjustInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date curDate = new Date();
        materialBasePriceAdjustInfo.setCreateTime(new Timestamp(curDate.getTime()));
        materialBasePriceAdjustInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        materialBasePriceAdjustInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        materialBasePriceAdjustInfo.setBathAdjustType(MaterialBasePriceBathAdjustTypeEnum.NOT_BATH_ADJUST);
        materialBasePriceAdjustInfo.setBizDate(curDate);
        materialBasePriceAdjustInfo.getEntries().add((MaterialBasePriceAdjustEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return materialBasePriceAdjustInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        MaterialBasePriceAdjustEntryInfo materialBasePriceAdjustEntryInfo = new MaterialBasePriceAdjustEntryInfo();
        materialBasePriceAdjustEntryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        return materialBasePriceAdjustEntryInfo;
    }

    protected void setBizMaterial(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo) {
        if (queryInfo != null) {
            bizMaterialBox.setQueryInfo(queryInfo);
        }
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$;$helpCode$");
        bizMaterialBox.setEditable(true);
        bizMaterialBox.setEnabledMultiSelection(true);
        if (this.f7DisplayMode == 0) {
            try {
                GeneralKDPromptSelectorAdaptor selectorLisenter = null;
                selectorLisenter = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", "MaterialGroup.id");
                selectorLisenter.setQueryProperty("helpCode", "or");
                selectorLisenter.setIsMultiSelect(true);
                bizMaterialBox.setSelector((KDPromptSelector)selectorLisenter);
                bizMaterialBox.addSelectorListener((SelectorListener)selectorLisenter);
                EntityViewInfo eve = new EntityViewInfo();
                FilterInfo filterinfo = new FilterInfo();
                CtrlUnitInfo CU = null;
                if (this.prmtCU.getValue() != null && this.prmtCU.getValue() instanceof CtrlUnitInfo) {
                    CU = (CtrlUnitInfo)this.prmtCU.getValue();
                }
                if (CU != null && CU.getId() != null) {
                    filterinfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)("SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '4409E7F0' AND FAssignCUID = '" + CU.getId().toString() + "' UNION ALL SELECT fid FROM T_BD_Material WHERE fcontrolunitid = '" + CU.getId().toString() + "'"), CompareType.INNER));
                    eve.setFilter(filterinfo);
                    bizMaterialBox.setEntityViewInfo(eve);
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        } else if (queryInfo == null) {
            bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        }
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "BasePriceAdjust_addnew";
        }
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.baseUnit"));
        sic.add(new SelectorItemInfo("material.assistUnit"));
        sic.add(new SelectorItemInfo("priceType.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("material.assistAttr"));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("floorPrice"));
        sic.add(new SelectorItemInfo("priority"));
        sic.add(new SelectorItemInfo("checkedFlag"));
        sic.add(new SelectorItemInfo("blockedFlag"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("priceType.number"));
        sic.add(new SelectorItemInfo("assistProperty.name"));
        sic.add(new SelectorItemInfo("maxPrice"));
        sic.add(new SelectorItemInfo("channelType.name"));
        sic.add(new SelectorItemInfo("channelType.number"));
        sic.add(new SelectorItemInfo("priceType.number"));
        return sic;
    }

    public String getNewNumber() {
        CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        String companyId = ctrlUnit.getId().toString();
        if (this.editData == null) {
            this.editData = new MaterialBasePriceAdjustInfo();
        }
        try {
            return CodingRuleManagerFactory.getRemoteInstance().getNumber((IObjectValue)this.editData, companyId);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isNewNumAddView() {
        return this.getCodingRule() != null && this.getCodingRule().isIsAddView();
    }

    private CodingRuleInfo getCodingRule() {
        CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        if (ctrlUnit == null) {
            return null;
        }
        String companyId = ctrlUnit.getId().toString();
        try {
            if (this.editData == null) {
                this.editData = new MaterialBasePriceAdjustInfo();
            }
            ICodingRuleManager iCodingMgr = CodingRuleManagerFactory.getRemoteInstance();
            return iCodingMgr.getCodingRule((IObjectValue)this.editData, companyId);
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected final OrgUnitInfo getDefaultMainBizOrgNew() {
        int i;
        OrgUnitInfo[] mainOrgs = null;
        try {
            FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)this.getPermissionItem("ADDNEW"));
            if (collection != null && collection.size() > 0) {
                mainOrgs = new OrgUnitInfo[collection.size()];
                for (i = 0; i < collection.size(); ++i) {
                    mainOrgs[i] = collection.get(i);
                }
            }
            if (mainOrgs == null) {
                mainOrgs = new OrgUnitInfo[]{};
                return null;
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            int n = mainOrgs.length;
            for (i = 0; i < n; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            if (mainOrgs[0] instanceof FullOrgUnitInfo) {
                mainOrgs[0] = (CtrlUnitInfo)mainOrgs[0].cast(CtrlUnitInfo.class);
            }
            return mainOrgs[0];
        }
        return null;
    }

    private void checkEntryDataRepeat() throws BOSException, EASBizException {
        HashMap<String, String> materialBasePriceMap = new HashMap<String, String>();
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            String materialID = null;
            String currencyID = null;
            String unitID = null;
            String priceTypeID = null;
            String channelTypeID = null;
            String assistPropertyID = null;
            MaterialInfo materialInfo = null;
            if (row.getCell(TB_MATERIAL).getValue() != null) {
                materialInfo = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
            }
            CurrencyInfo currencyInfo = null;
            if (row.getCell(TB_CURRENCY).getValue() != null) {
                currencyInfo = (CurrencyInfo)row.getCell(TB_CURRENCY).getValue();
            }
            MeasureUnitInfo measureUnitInfo = null;
            if (row.getCell(TB_UNIT).getValue() != null) {
                measureUnitInfo = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
            }
            PriceTypeInfo priceTypeInfo = null;
            if (row.getCell(TB_PRICETYPE).getValue() != null) {
                priceTypeInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue();
            }
            ChannelTypeInfo channelTypeInfo = null;
            if (row.getCell(TB_CHANNELTYPE).getValue() != null) {
                channelTypeInfo = (ChannelTypeInfo)row.getCell(TB_CHANNELTYPE).getValue();
            }
            AsstAttrValueInfo asst = null;
            if (row.getCell(TB_ASSISTPROPERTY).getValue() != null) {
                asst = (AsstAttrValueInfo)row.getCell(TB_ASSISTPROPERTY).getValue();
            }
            if (materialInfo == null || currencyInfo == null || measureUnitInfo == null || priceTypeInfo == null) continue;
            materialID = materialInfo.getId().toString();
            currencyID = currencyInfo.getId().toString();
            unitID = measureUnitInfo.getId().toString();
            priceTypeID = priceTypeInfo.getId().toString();
            channelTypeID = "04".equals(priceTypeInfo.getNumber().toString()) && channelTypeInfo != null && channelTypeInfo.getId() != null ? channelTypeInfo.getId().toString() : "";
            assistPropertyID = asst != null && asst.getId() != null ? asst.getId().toString() : "";
            if (materialID == null || materialID.length() <= 0 || currencyID == null || currencyID.length() <= 0 || unitID == null || unitID.length() <= 0 || priceTypeID == null || priceTypeID.length() <= 0) continue;
            if (materialBasePriceMap.containsKey(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID)) {
                String msg = "" + (String)materialBasePriceMap.get(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID) + "," + Integer.toString(i + 1);
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"submit_REPEAT_ENTRY1"), msg));
                SysUtil.abort();
                continue;
            }
            materialBasePriceMap.put(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID, Integer.toString(i + 1));
        }
    }

    private void checkCanSubmitData(Set materialIDSet, Set currencyIDSet, Set unitIDSet, Set priceTypeIDSet) throws BOSException, EASBizException {
        Map materialBasePriceMap = this.getExistInMaterialBasePrice(materialIDSet, currencyIDSet, unitIDSet, priceTypeIDSet);
        String num = "";
        String delNum = "";
        String[] selectRows = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            String materialID = null;
            String currencyID = null;
            String unitID = null;
            String priceTypeID = null;
            String channelTypeID = null;
            String assistPropertyID = null;
            MaterialInfo materialInfo = null;
            if (row.getCell(TB_MATERIAL).getValue() != null) {
                materialInfo = (MaterialInfo)row.getCell(TB_MATERIAL).getValue();
            }
            CurrencyInfo currencyInfo = null;
            if (row.getCell(TB_CURRENCY).getValue() != null) {
                currencyInfo = (CurrencyInfo)row.getCell(TB_CURRENCY).getValue();
            }
            MeasureUnitInfo measureUnitInfo = null;
            if (row.getCell(TB_UNIT).getValue() != null) {
                measureUnitInfo = (MeasureUnitInfo)row.getCell(TB_UNIT).getValue();
            }
            PriceTypeInfo priceTypeInfo = null;
            if (row.getCell(TB_PRICETYPE).getValue() != null) {
                priceTypeInfo = (PriceTypeInfo)row.getCell(TB_PRICETYPE).getValue();
            }
            ChannelTypeInfo channelTypeInfo = null;
            if (row.getCell(TB_CHANNELTYPE).getValue() != null) {
                channelTypeInfo = (ChannelTypeInfo)row.getCell(TB_CHANNELTYPE).getValue();
            }
            AsstAttrValueInfo asst = null;
            if (row.getCell(TB_ASSISTPROPERTY).getValue() != null) {
                asst = (AsstAttrValueInfo)row.getCell(TB_ASSISTPROPERTY).getValue();
            }
            if (materialInfo == null || currencyInfo == null || measureUnitInfo == null || priceTypeInfo == null) continue;
            materialID = materialInfo.getId().toString();
            currencyID = currencyInfo.getId().toString();
            unitID = measureUnitInfo.getId().toString();
            priceTypeID = priceTypeInfo.getId().toString();
            channelTypeID = "04".equals(priceTypeInfo.getNumber().toString()) && channelTypeInfo != null && channelTypeInfo.getId() != null ? channelTypeInfo.getId().toString() : "";
            assistPropertyID = asst != null && asst.getId() != null ? asst.getId().toString() : "";
            MaterialBasePriceInfo materialBasePriceInfo = null;
            materialBasePriceInfo = (MaterialBasePriceInfo)materialBasePriceMap.get(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID);
            if (materialBasePriceInfo == null || !this.updateCheck(row)) continue;
            num = num + Integer.toString(i + 1) + ",";
            delNum = delNum + Integer.toString(i) + ",";
        }
        if (num.length() > 0) {
            num = num.substring(0, num.length() - 1);
            delNum = delNum.substring(0, delNum.length() - 1);
            if (MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"submit_ATLEAST_CHANGE_ONE1"), num)))) {
                SysUtil.abort();
            } else {
                selectRows = delNum.split(",");
                this.autoDelEntryLine(selectRows);
            }
        }
    }

    private void autoDelEntryLine(String[] selectRows) {
        int size = selectRows.length;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            indexSet.add(new Integer(selectRows[i]));
        }
        Object[] indexArr = new Integer[indexSet.size()];
        Object[] indexObj = indexSet.toArray();
        System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        for (int i = indexArr.length - 1; i >= 0; --i) {
            int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
            this.kdtEntries.removeRow(rowIndex);
        }
    }

    private Map getExistInMaterialBasePrice(Set materialIDSet, Set currencyIDSet, Set unitIDSet, Set priceTypeIDSet) throws BOSException, EASBizException {
        HashMap<String, MaterialBasePriceInfo> materialBasePriceMap = new HashMap<String, MaterialBasePriceInfo>();
        if (materialIDSet.size() == 0 || currencyIDSet.size() == 0 || unitIDSet.size() == 0 || priceTypeIDSet.size() == 0) {
            return materialBasePriceMap;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("priceType.number", (Object)priceTypeIDSet, CompareType.INCLUDE));
        CtrlUnitInfo cu = null;
        if (this.prmtCU.getValue() != null && this.prmtCU.getValue() instanceof CtrlUnitInfo) {
            cu = (CtrlUnitInfo)this.prmtCU.getValue();
        }
        if (cu != null && cu.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getSelectors());
        MaterialBasePriceCollection materialBasePriceInfo = null;
        MaterialBasePriceInfo info = null;
        try {
            materialBasePriceInfo = MaterialBasePriceFactory.getRemoteInstance().getMaterialBasePriceCollection(viewInfo);
            String materialID = null;
            String currencyID = null;
            String unitID = null;
            String priceTypeID = null;
            String channelTypeID = null;
            String assistPropertyID = null;
            int size = materialBasePriceInfo.size();
            for (int i = 0; i < size; ++i) {
                info = materialBasePriceInfo.get(i);
                if (info != null && info.getMaterial() != null && info.getCurrency() != null && info.getUnit() != null && info.getPriceType() != null) {
                    materialID = info.getMaterial().getId().toString();
                    currencyID = info.getCurrency().getId().toString();
                    unitID = info.getUnit().getId().toString();
                    priceTypeID = info.getPriceType().getId().toString();
                    channelTypeID = info.getChannelType() != null && info.getChannelType().getId() != null ? info.getChannelType().getId().toString() : "";
                    assistPropertyID = info.getAssistProperty() != null && info.getAssistProperty().getId() != null ? info.getAssistProperty().getId().toString() : "";
                }
                if (materialID == null || materialID.length() <= 0 || currencyID == null || currencyID.length() <= 0 || unitID == null || unitID.length() <= 0 || priceTypeID == null || priceTypeID.length() <= 0 || materialBasePriceMap.containsKey(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID)) continue;
                materialBasePriceMap.put(materialID + currencyID + unitID + priceTypeID + channelTypeID + assistPropertyID, materialBasePriceInfo.get(i));
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return materialBasePriceMap;
    }

    private boolean updateCheck(IRow row) throws BOSException, EASBizException {
        if (row.getCell(TB_NEWHIGHESTPRICE).getValue() != null && row.getCell(TB_OLDHIGHESTPRICE).getValue() != null) {
            BigDecimal oldHighestPrice;
            BigDecimal newHighestPrice = (BigDecimal)row.getCell(TB_NEWHIGHESTPRICE).getValue();
            if (newHighestPrice.compareTo(oldHighestPrice = (BigDecimal)row.getCell(TB_OLDHIGHESTPRICE).getValue()) != 0) {
                return false;
            }
        } else {
            if (row.getCell(TB_NEWHIGHESTPRICE).getValue() != null && row.getCell(TB_OLDHIGHESTPRICE).getValue() == null) {
                return false;
            }
            if (row.getCell(TB_NEWHIGHESTPRICE).getValue() == null && row.getCell(TB_OLDHIGHESTPRICE).getValue() != null) {
                return false;
            }
        }
        if (row.getCell(TB_NEWLOWESTPRICE).getValue() != null && row.getCell(TB_OLDLOWESTPRICE).getValue() != null) {
            BigDecimal oldLowestPrice;
            BigDecimal newLowestPrice = (BigDecimal)row.getCell(TB_NEWLOWESTPRICE).getValue();
            if (newLowestPrice.compareTo(oldLowestPrice = (BigDecimal)row.getCell(TB_OLDLOWESTPRICE).getValue()) != 0) {
                return false;
            }
        } else {
            if (row.getCell(TB_NEWLOWESTPRICE).getValue() != null && row.getCell(TB_OLDLOWESTPRICE).getValue() == null) {
                return false;
            }
            if (row.getCell(TB_NEWLOWESTPRICE).getValue() == null && row.getCell(TB_OLDLOWESTPRICE).getValue() != null) {
                return false;
            }
        }
        if (row.getCell(TB_NEWPRICE).getValue() != null && row.getCell(TB_OLDPRICE).getValue() != null) {
            BigDecimal oldPrice;
            BigDecimal newPrice = (BigDecimal)row.getCell(TB_NEWPRICE).getValue();
            if (newPrice.compareTo(oldPrice = (BigDecimal)row.getCell(TB_OLDPRICE).getValue()) != 0) {
                return false;
            }
        } else {
            if (row.getCell(TB_NEWPRICE).getValue() != null && row.getCell(TB_OLDPRICE).getValue() == null) {
                return false;
            }
            if (row.getCell(TB_NEWPRICE).getValue() == null && row.getCell(TB_OLDPRICE).getValue() != null) {
                return false;
            }
        }
        return true;
    }
}

