/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.sale.IMaterialBasePriceAdjust;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustFactory;
import com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractMaterialBasePriceAdjustListUI;
import com.kingdee.eas.scm.sd.sale.client.MaterialBasePriceAdjustEditUI;
import com.kingdee.eas.scm.sd.sale.client.MaterialBasePriceAdjustQueryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class MaterialBasePriceAdjustListUI
extends AbstractMaterialBasePriceAdjustListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialBasePriceAdjustListUI.class);
    MaterialBasePriceAdjustQueryUI materialBasePriceAdjustQueryUI = null;
    public static final String TB_AUDITTIME = "auditTime";
    public static final String TB_CREATETIME = "createTime";
    public static final String TB_NEWPRICE = "entries.newPrice";
    public static final String TB_OLDPRICE = "entries.oldPrice";
    public static final String TB_NEWLOWESTPRICE = "entries.newLowestPrice";
    public static final String TB_OLDLOWESTPRICE = "entries.oldLowestPrice";
    public static final String TB_NEWHIGHESTPRICE = "entries.newHighestPrice";
    public static final String TB_OLDHIGHESTPRICE = "entries.oldHighestPrice";
    private static final String RESOURCE = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";
    private static final String PRESOURCE = "com.kingdee.eas.scm.sd.sale.MaterialBasePriceAdjustResource";
    private static final String ADJUST_AMOUNT = "adjustAmount";
    private String[] numberForRight = new String[]{"entries.newPrice", "entries.oldPrice", "entries.newLowestPrice", "entries.newHighestPrice", "entries.oldLowestPrice", "entries.oldHighestPrice"};

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnUnAudit.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.menuItemUnAudit.setVisible(false);
        this.tblMain.getColumn(TB_AUDITTIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(TB_CREATETIME).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.tblMain.getColumn(ADJUST_AMOUNT).getStyleAttributes().setNumberFormat("%r-[=]{#,##0.############}f");
        this.tblMain.getColumn(ADJUST_AMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.setNumberForRight();
        this.initPrecision();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog commonQueryDialog = super.initCommonQueryDialog();
        commonQueryDialog.setWidth(578);
        return commonQueryDialog;
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{TB_CREATETIME, TB_AUDITTIME, "lastUpdateTime"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_NEWPRICE, TB_OLDPRICE};
    }

    private void initPrecision() {
        SCMClientUtils.changeTableColPrecisionByCol((int)6, (KDTable)this.tblMain, (String[])this.numberForRight);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setNumberForRight() {
        int num = this.numberForRight.length;
        for (int i = 0; i < num; ++i) {
            this.tblMain.getColumn(this.numberForRight[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (ev.getFilter() != null) {
            FilterItemInfo fii;
            boolean isHasAuditTime = false;
            Calendar curDate = Calendar.getInstance();
            CompareType oldCompareType = null;
            String compareName = null;
            int i = 0;
            int count = ev.getFilter().getFilterItems().size();
            if (i < count && ((fii = ev.getFilter().getFilterItems().get(i)).getPropertyName().equals(TB_AUDITTIME) || fii.getPropertyName().equals("modifyTime") || fii.getPropertyName().equals(TB_CREATETIME))) {
                compareName = fii.getPropertyName();
                if (fii.getCompareType().equals((Object)CompareType.EQUALS)) {
                    fii.setCompareType(CompareType.GREATER_EQUALS);
                    oldCompareType = CompareType.EQUALS;
                    curDate.setTime((Date)fii.getCompareValue());
                }
                if (fii.getCompareType().equals((Object)CompareType.LESS_EQUALS)) {
                    oldCompareType = CompareType.LESS_EQUALS;
                    curDate.setTime((Date)fii.getCompareValue());
                    curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
                    fii.setCompareValue((Object)new Date(curDate.getTimeInMillis()));
                }
                if (fii.getCompareType().equals((Object)CompareType.NOTEQUALS)) {
                    oldCompareType = CompareType.NOTEQUALS;
                    Date oldDate = (Date)fii.getCompareValue();
                    curDate.setTime((Date)fii.getCompareValue());
                    curDate.set(1949, 1, 1, 0, 0, 0);
                    fii.setCompareType(CompareType.GREATER_EQUALS);
                    fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
                    curDate.setTime(oldDate);
                }
                if (fii.getCompareType().equals((Object)CompareType.GREATER)) {
                    curDate.setTime((Date)fii.getCompareValue());
                    curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
                    fii.setCompareValue((Object)new Timestamp(curDate.getTimeInMillis()));
                }
                isHasAuditTime = true;
            }
            if (isHasAuditTime && oldCompareType != null) {
                try {
                    if (oldCompareType.equals((Object)CompareType.EQUALS)) {
                        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
                        FilterInfo addFilterInfo = new FilterInfo();
                        addFilterInfo.getFilterItems().add(new FilterItemInfo(compareName, (Object)new Timestamp(curDate.getTimeInMillis()), CompareType.LESS_EQUALS));
                        ev.getFilter().mergeFilter(addFilterInfo, "AND");
                    }
                    if (oldCompareType.equals((Object)CompareType.NOTEQUALS)) {
                        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 23, 59, 59);
                        FilterInfo addFilterInfo = new FilterInfo();
                        Timestamp begin = new Timestamp(curDate.getTimeInMillis());
                        addFilterInfo.getFilterItems().add(new FilterItemInfo(compareName, (Object)begin, CompareType.GREATER_EQUALS));
                        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 0, 0, 0);
                        addFilterInfo.getFilterItems().add(new FilterItemInfo(compareName, (Object)new Timestamp(curDate.getTimeInMillis()), CompareType.LESS_EQUALS));
                        addFilterInfo.setMaskString("#0 OR #1");
                        ev.getFilter().mergeFilter(addFilterInfo, "AND");
                    }
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.materialBasePriceAdjustQueryUI == null) {
            this.materialBasePriceAdjustQueryUI = new MaterialBasePriceAdjustQueryUI();
        }
        return this.materialBasePriceAdjustQueryUI;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditAlert"));
        if (!MsgBox.isYes((int)isYes)) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        if (SCMClientUtils.checkAllBizObjInWfProcess((String[])IDs)) {
            this.actionMultiapprove_actionPerformed(null);
            this.execQuery();
            return;
        }
        ((IMaterialBasePriceAdjust)this.getBizInterface()).batchAudit((IObjectPK[])pks);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
        this.refreshList();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialBasePriceAdjustFactory.getRemoteInstanceWithObjectContext(this.getMainContext());
    }

    protected String getEditUIName() {
        return MaterialBasePriceAdjustEditUI.class.getName();
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"number", "CU.name", "auditor.name", TB_AUDITTIME, "creator", TB_CREATETIME, "lastUpdateTime", "modify", "adjustReason", "bathAdjustType", ADJUST_AMOUNT, "baseStatus"};
        return columns;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "CU.id";
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList idList = this.getSelectedIdValues();
            ObjectUuidPK[] pks = new ObjectUuidPK[idList.size()];
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                pks[i] = new ObjectUuidPK(idList.get(i).toString());
            }
            this.getBizInterface().delete((IObjectPK[])pks);
        }
        this.refresh(e);
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)PRESOURCE, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new MaterialBasePriceAdjustInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }
}

