/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.LocationHelper;
import com.kingdee.eas.common.BizCheckException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.KDTableUtils;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.client.CreditCheck;
import com.kingdee.eas.scm.im.inv.ILockInventory;
import com.kingdee.eas.scm.im.inv.LockInventoryCollection;
import com.kingdee.eas.scm.im.inv.LockInventoryFactory;
import com.kingdee.eas.scm.im.reservation.BillReservationFacadeFactory;
import com.kingdee.eas.scm.im.reservation.IBillReservationFacade;
import com.kingdee.eas.scm.sd.sale.IPostRequisition;
import com.kingdee.eas.scm.sd.sale.IPostRequisitionEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionAgent;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryAgent;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractPostRequisitionEditUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PostRequisitionEditUI
extends AbstractPostRequisitionEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(PostRequisitionEditUI.class);
    private static final String TB_MATERIAL = "material";
    private static final String TB_UNIT = "unit";
    private static final String TB_MODEL = "model";
    private static final String TB_MATERIALNAME = "materialName";
    private static final String TB_ASSISTANTUNIT = "assistantUnit";
    private static final String TB_POSTQTY = "postedQty";
    private static final String TB_QTY = "qty";
    private static final String TB_PROJECTNAME = "projectName";
    private static final String TB_TRACKNUMBERNAME = "trackNumberName";
    private static final String TB_ASSISTQTY = "assistQuantity";
    private static final String TB_INNAGEQTY = "innageQty";
    private static final String TB_TOTAL = "total";
    private static final String TB_PRICE = "price";
    private static final String TB_POSTDATE = "postDate";
    private static final String TB_DELIVERYDATE = "deliveryDate";
    private static final String TB_ASISTPROPERTY = "asistProperty";
    private static final String TB_DELIVERTYPE = "deliverType";
    private static final String TB_ORDERCUSTOMER = "orderCustomer";
    private static final String TB_DELIVERYCUSTOMER = "deliveryCustomer";
    private static final String TB_RECEIVECUSTOMER = "receiveCustomer";
    private static final String TB_PAYMENTCUSTOMER = "paymentCustomer";
    private static final String TB_ADDRESS = "shipTo";
    private static final String TB_SOURCENUMBER = "sourceBillNumber";
    private static final String TB_SOURCESEQ = "sourceBillEntrySeq";
    private static final String TB_CUSPURNUMBER = "custPurNumber";
    private static final String TB_BIZPERSON = "bizPerson";
    private static final String TB_BIZGROUP = "bizGroup";
    private static final String TB_ADVANCEDAY = "transAdvanceDay";
    private static final String TB_REASONCODE = "reasonCode";
    private static final String TB_BASESTATUS = "baseStatus";
    private static final String TB_POSTWAREHOUSE = "postWarehouse";
    private static final String TB_LOCATION = "location";
    private static final String TB_ISPRESENT = "isPresent";
    private static final String TB_SEQ = "sourceBillEntrySeq";
    private static final String TB_BASEQTY = "baseUnitQty";
    private static final String TB_LOCALAMOUNT = "localAmount";
    private static final String TB_TOTALREVERSEDQTY = "totalReversedQty";
    private static final String TB_PLANDELIVERYQTY = "planDeliveryQty";
    private static final String TB_BASEUNIT = "baseUnit";
    private static String[] ALIGNRIGHTTAB = new String[]{"postedQty", "qty", "assistQuantity", "innageQty", "total", "price", "localAmount", "totalReversedQty", "planDeliveryQty"};
    private static String[] ALIGNLEFTTAB = new String[]{"unit", "assistantUnit", "sourceBillEntrySeq"};
    private static String[] NECESSITYTAB = new String[]{"material", "unit", "qty", "orderCustomer", "deliveryCustomer", "receiveCustomer", "paymentCustomer"};
    private static String[] LOCKEDTAB = new String[]{"material", "materialName", "model", "asistProperty", "unit", "postedQty", "assistantUnit", "assistQuantity", "innageQty", "total", "sourceBillNumber", "sourceBillEntrySeq", "custPurNumber", "reasonCode", "bizPerson", "bizGroup", "baseStatus", "isPresent", "localAmount", "planDeliveryQty"};
    private static String[] PRICEPRECISIONTAB = new String[]{"price"};
    private static String[] CURRENCYPRECISIONTAB = new String[]{"total"};
    private static String[] LOCALAMOUNTPRECISIONTAB = new String[]{"localAmount"};
    private static String[] QTYPRECISIONTAB = new String[]{"postedQty", "qty", "innageQty", "totalReversedQty", "planDeliveryQty"};
    private static final String[] QTYPRECISIONFROMBASEUNITTAB = new String[]{"baseUnitQty"};
    private static final String[] QTYPRECISIONFROMASSISTUNITTAB = new String[]{"assistQuantity"};
    private static String[] ASSISTQTYPRECISIONTAB = new String[]{"assistQuantity"};
    private static String[] NUMBERTAB = new String[]{"postedQty", "qty", "assistQuantity", "innageQty", "total", "price", "planDeliveryQty"};
    private static BigDecimal defaultNum = new BigDecimal("0.0");
    private KDBizPromptBox prmtMaterial = null;
    private KDBizPromptBox prmtCustomer = null;
    private KDBizPromptBox prmtDeliveryCustomer = null;
    private KDBizPromptBox prmtPaymentCustomer = null;
    private KDBizPromptBox prmtReceiveCustomer = null;
    private KDBizPromptBox kdtEntrys_salePerson_PromptBox = null;
    private SCMClientHelper clientHelper = null;
    private CurrencyInfo baseCurrInfo = null;
    private CompanyOrgUnitInfo ficompanyOrgInfo = null;
    private BigDecimal exchangeRate = null;
    private ExchangeRateInfo tempexrateinfo = null;
    private SCMEntryDataVO resultVO = null;
    private KDBizPromptBox prmtEntrySendAddress = null;

    public PostRequisitionEditUI() throws Exception {
        this.initConfigMap();
        this.setCacheParameters(new String[]{"SALEORDER002", "POSTREQUISITION001"});
        this.clientHelper = new SCMClientHelper((SCMBillEditUI)this);
        this.txtMemo.setMaxLength(255);
        this.setUseAgent(true);
    }

    private void initConfigMap() {
        HashMap<String, Object> colMap = new HashMap<String, Object>();
        colMap.put("MATERIAL", TB_MATERIAL);
        colMap.put("TB_BASEUNIT", TB_BASEUNIT);
        colMap.put("TB_UNIT", TB_UNIT);
        colMap.put("QTY", TB_QTY);
        colMap.put("TB_BASEQTY", TB_BASEQTY);
        colMap.put("TB_ASSISTUNIT", TB_ASSISTANTUNIT);
        colMap.put("TB_ASSISTQTY", TB_ASSISTQTY);
        colMap.put("prmtCurrency", this.prmtCurrency);
        colMap.put("PRICEPRECISIONTAB", PRICEPRECISIONTAB);
        colMap.put("QTYPRECISIONFROMUNITTAB", QTYPRECISIONTAB);
        colMap.put("QTYPRECISIONFROMBASEUNITTAB", QTYPRECISIONFROMBASEUNITTAB);
        colMap.put("QTYPRECISIONFROMASSISTUNITTAB", QTYPRECISIONFROMASSISTUNITTAB);
        this.uiHelper.setConfigMap(colMap);
        this.uiHelper.setKdtEntries(this.kdtEntrys);
    }

    @Override
    public void loadFields() {
        this.setInnerLoadFields(true);
        Map allTableListeners = this.removeAllTableListener(KDTPropertyChangeListener.class);
        if (this.getOprtState().equals("ADDNEW") && !SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData) && this.editData.getEntries().size() == 0) {
            PostRequisitionEntryInfo entryInfo = (PostRequisitionEntryInfo)this.createNewDetailData(this.kdtEntrys);
            this.editData.getEntries().add(entryInfo);
        }
        this.loadFieldsByIsReverse(this.editData.isIsReverse());
        this.setLockTab();
        this.initInterface();
        super.loadFields();
        try {
            this.setStatusByReverseProject(this.isReverseProject());
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        this.setQtyPrecision();
        this.initData();
        this.initKDTEntry();
        this.clientHelper.registerRequireColumns(NECESSITYTAB);
        try {
            this.prmtstorageOrgUnit_dataChanged(null);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.f7Manager.registerMeasureUnitF7(this.kdtEntrys, TB_MATERIAL, TB_UNIT);
        this.f7Manager.registerMeasureUnitF7(this.kdtEntrys, TB_MATERIAL, TB_ASSISTANTUNIT);
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData)) {
            this.prmtBizType.setEnabled(false);
            this.prmtSaleOrgUnit.setEnabled(false);
            this.prmtCurrency.setEnabled(false);
            if (this.baseCurrInfo != null) {
                ObjectUuidPK sourceCurrPK = null;
                ObjectUuidPK destCurrPK = null;
                destCurrPK = new ObjectUuidPK(this.baseCurrInfo.getId());
                CurrencyInfo currencyInfo = this.prmtCurrency.getValue() == null ? this.editData.getCurrency() : (CurrencyInfo)this.prmtCurrency.getValue();
                ObjectUuidPK objectUuidPK = sourceCurrPK = currencyInfo == null ? destCurrPK : new ObjectUuidPK(currencyInfo.getId());
                if (!destCurrPK.equals((Object)sourceCurrPK)) {
                    try {
                        this.tempexrateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)this.ficompanyOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                }
                this.exchangeRate = this.isBotpBill("510b6503-0105-1000-e000-0113c0a812fd463ED552") || this.isBotpBill("Eg5BUQEVEADgAAABwKgOEEY+1VI=") ? this.editData.getExchangeRate() : (destCurrPK.equals((Object)sourceCurrPK) ? new BigDecimal("1.00") : (this.tempexrateinfo != null ? this.tempexrateinfo.getConvertRate() : new BigDecimal("1.00")));
                boolean isCreatedBySaleOrder = this.isBotpBill("510b6503-0105-1000-e000-0113c0a812fd463ED552");
                if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    this.kdtEntrys.getColumn(TB_POSTDATE).getStyleAttributes().setLocked(false);
                    this.kdtEntrys.getColumn(TB_DELIVERYDATE).getStyleAttributes().setLocked(false);
                } else {
                    KDTableUtils.setLockFields((KDTable)this.getDetailTable(), (String[])new String[]{TB_POSTDATE, TB_DELIVERYDATE}, (boolean)isCreatedBySaleOrder);
                }
                KDTableUtils.setLockFields((KDTable)this.getDetailTable(), (String[])new String[]{TB_ADVANCEDAY}, (!isCreatedBySaleOrder ? 1 : 0) != 0);
            }
            KDBizPromptBox box = new KDBizPromptBox();
            int n = this.kdtEntrys.getRowCount();
            for (int i = 0; i < n; ++i) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)this.kdtEntrys.getRow(i).getCell(TB_POSTWAREHOUSE).getValue();
                try {
                    if (warehouseInfo != null) {
                        box = LocationHelper.setLocationF7((CoreUIObject)this, (KDBizPromptBox)box, (String)warehouseInfo.getId().toString());
                    } else {
                        this.kdtEntrys.getRow(i).getCell(TB_LOCATION).getStyleAttributes().setLocked(true);
                    }
                    this.kdtEntrys.getRow(i).getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
                    continue;
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
            }
        } else {
            this.prmtSaleOrgUnit.setEditable(true);
            this.prmtSaleOrgUnit.setEnabled(true);
            this.prmtCurrency.setEnabled(true);
        }
        this.initCompenentFromStatus();
        this.initToolBar();
        this.prmtSaleOrgUnit.setEditable(false);
        this.initKDTEntryData();
        this.curBizAction = null;
        this.prmtEntrySendAddress = new KDBizPromptBox();
        this.prmtEntrySendAddress.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7AddressForCustomerQuery");
        this.prmtEntrySendAddress.setEditFormat("$address$");
        this.prmtEntrySendAddress.setDisplayFormat("$address$");
        this.prmtEntrySendAddress.setCommitParser((IParser)new ExtendParser(this.prmtEntrySendAddress));
        this.kdtEntrys.getColumn(TB_ADDRESS).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtEntrySendAddress));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$address$"));
        this.kdtEntrys.getColumn(TB_ADDRESS).setRenderer((IBasicRender)avr);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            for (int rowIndex = 0; rowIndex < this.kdtEntrys.getRowCount3(); ++rowIndex) {
                WarehouseInfo warehouseInfo;
                if (!(this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) || !(warehouseInfo = (WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue()).isHasLocation()) continue;
                this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(false);
            }
        }
        this.restoreAllTableListener(KDTPropertyChangeListener.class, allTableListeners);
        this.reSetDepTbListeners();
    }

    public void setQtyPrecision() {
        SaleOrderDataVO dataVo = this.prepareVoForLoadData();
        if (dataVo.getMaterialInfos() != null && dataVo.getMaterialInfos().length > 0 && dataVo.getMaterialInfos()[0] != null) {
            try {
                if (this.resultVO == null || this.resultVO.getMmuPrecisions() == null || this.resultVO.getMaterialInventoryInfos() == null || this.curBizAction != BatchActionEnum.AUDIT && this.curBizAction != BatchActionEnum.SAVE && this.curBizAction != BatchActionEnum.SUBMIT && this.curBizAction != BatchActionEnum.UNAUDIT) {
                    this.resultVO = SCMGroupFacadeFactory.getRemoteInstance().loadSaleComplexData(dataVo);
                }
                if (this.resultVO != null) {
                    this.initLotEntry(this.resultVO);
                    dataVo.setMmuPrecisions(this.resultVO.getMmuPrecisions());
                    SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])dataVo.getMaterialInfos(), (SCMEntryDataVO)dataVo, (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (String[])QTYPRECISIONFROMBASEUNITTAB, (String[])QTYPRECISIONFROMASSISTUNITTAB);
                    SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo[])dataVo.getMaterialInfos(), (KDTable)this.getDetailTable(), (String[])PRICEPRECISIONTAB);
                }
            }
            catch (EASBizException e) {
                logger.info((Object)"loadComplexData error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.info((Object)"loadComplexData error:", (Throwable)e);
            }
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        Object ov = dataObject;
        if (this.isUseAgent()) {
            if ("ADDNEW".equals(this.getOprtState())) {
                if (!(dataObject instanceof IObjectValueAgent)) {
                    ov = PostRequisitionAgent.copyOvAsNewAgent(dataObject);
                } else if (((IObjectValueAgent)dataObject).getAgentState() != AgentState.NEW) {
                    ((PostRequisitionAgent)ov).recursiveSetAgentState(AgentState.NEW);
                }
            } else if (!(dataObject instanceof IObjectValueAgent)) {
                ov = PostRequisitionAgent.copyOvToAgent(dataObject);
            }
        }
        super.setDataObject((IObjectValue)ov);
        this.editData = (PostRequisitionInfo)ov;
    }

    private SaleOrderDataVO prepareVoForLoadData() {
        SaleOrderDataVO inVO = new SaleOrderDataVO();
        inVO.setIsLoadingMmuPrecision(true);
        int num = this.getDetailTable().getRowCount();
        MaterialInfo[] materialInfos = new MaterialInfo[num];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[num];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[num];
        MeasureUnitInfo[] measureAssistUnitInfos = new MeasureUnitInfo[num];
        StorageOrgUnitInfo[] storages = new StorageOrgUnitInfo[num];
        for (int i = 0; i < num; ++i) {
            materialInfos[i] = (MaterialInfo)this.getDetailTable().getRow(i).getCell(TB_MATERIAL).getValue();
            measureUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(TB_UNIT).getValue();
            measureBaseUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(TB_BASEUNIT).getValue();
            measureAssistUnitInfos[i] = (MeasureUnitInfo)this.getDetailTable().getRow(i).getCell(TB_ASSISTANTUNIT).getValue();
            if (!(this.prmtStorageOrgUnit.getData() instanceof StorageOrgUnitInfo)) continue;
            storages[i] = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
        }
        inVO.setMaterialInfos(materialInfos);
        inVO.setMeasureUnitInfos(measureUnitInfos);
        inVO.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        inVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        if (this.prmtStorageOrgUnit.getData() instanceof StorageOrgUnitInfo) {
            inVO.setStorageOrgUnitInfos(storages);
            inVO.setIsLoadingMaterialInventory(true);
        }
        return inVO;
    }

    private void initLotEntry(SCMEntryDataVO resultVO) {
        if (this.prmtStorageOrgUnit.getData() instanceof StorageOrgUnitInfo) {
            StorageOrgUnitInfo storageorg = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
            int c = this.kdtEntrys.getRowCount();
            for (int i = 0; i < c; ++i) {
                MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getRow(i).getCell(TB_MATERIAL).getValue();
                boolean isLotNumber = false;
                if (resultVO.getMaterialInventoryInfos().get(materialInfo.getId().toString() + storageorg.getId().toString()) instanceof MaterialInventoryInfo) {
                    MaterialInventoryInfo info = (MaterialInventoryInfo)resultVO.getMaterialInventoryInfos().get(materialInfo.getId().toString() + storageorg.getId().toString());
                    isLotNumber = info.isIsLotNumber();
                }
                this.kdtEntrys.getRow(i).getCell("lot").getStyleAttributes().setLocked(!isLotNumber);
            }
        }
    }

    protected void initCompenentFromStatus() {
        if (this.editData.isIsReverse()) {
            this.clientHelper.initComponentEnabledStatus(this.getComponents(), new Component[]{this.txtNumber, this.dpBillDate}, new HashMap());
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setLocked(false);
        } else {
            this.clientHelper.renewComponentEnabledStatus(this.getComponents());
        }
    }

    private void loadFieldsByIsReverse(boolean isReverse) {
        if (isReverse) {
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_BASEQTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.RED);
            this.getDetailTable().getColumn(TB_LOCALAMOUNT).getStyleAttributes().setFontColor(Color.RED);
            PostRequisitionEntryCollection entrys = this.editData.getEntries();
            int entrySize = entrys.size();
            for (int i = 0; i < entrySize; ++i) {
                PostRequisitionEntryInfo aPostRequisitionEntryInfo = entrys.get(i);
                if (aPostRequisitionEntryInfo.getQty() != null) {
                    aPostRequisitionEntryInfo.setQty(aPostRequisitionEntryInfo.getQty().abs());
                }
                if (aPostRequisitionEntryInfo.getBaseQty() != null) {
                    aPostRequisitionEntryInfo.setBaseQty(aPostRequisitionEntryInfo.getBaseQty().abs());
                }
                if (aPostRequisitionEntryInfo.getAssistQty() != null) {
                    aPostRequisitionEntryInfo.setAssistQty(aPostRequisitionEntryInfo.getAssistQty().abs());
                }
                if (aPostRequisitionEntryInfo.getAmount() != null) {
                    aPostRequisitionEntryInfo.setAmount(aPostRequisitionEntryInfo.getAmount().abs());
                }
                if (aPostRequisitionEntryInfo.getLocalAmount() == null) continue;
                aPostRequisitionEntryInfo.setLocalAmount(aPostRequisitionEntryInfo.getLocalAmount().abs());
            }
        } else {
            this.getDetailTable().getColumn(TB_QTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_BASEQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_ASSISTQTY).getStyleAttributes().setFontColor(Color.BLACK);
            this.getDetailTable().getColumn(TB_LOCALAMOUNT).getStyleAttributes().setFontColor(Color.BLACK);
        }
    }

    private void setStatusByReverseProject(boolean isReverseProject) {
        IColumn aCol;
        this.actionReverse.setVisible(isReverseProject);
        this.cbIsReverse.setVisible(isReverseProject);
        KDTable table = this.getDetailTable();
        if (table != null && (aCol = table.getColumn(TB_TOTALREVERSEDQTY)) != null) {
            aCol.getStyleAttributes().setHided(!isReverseProject);
        }
        if (this.editData.isIsReverse()) {
            this.actionReverse.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.btnSplitLine.setEnabled(false);
            this.menuItemSplitLine.setEnabled(false);
        } else if (isReverseProject && this.editData.getBaseStatus().getValue() == 4) {
            this.actionReverse.setEnabled(true);
        } else {
            this.actionReverse.setEnabled(false);
        }
    }

    public boolean isSaleParam(String mainOrgID, String key, boolean defaultValue) throws EASBizException, BOSException {
        boolean isPurParam = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        } else if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public boolean isReverseProject() throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData();
        boolean isReverseProject = this.isReverseProject(saleOrgUnitInfo);
        return isReverseProject;
    }

    public boolean isReverseProject(SaleOrgUnitInfo saleOrgUnitInfo) throws EASBizException, BOSException {
        boolean isReverseProject = false;
        if (saleOrgUnitInfo != null) {
            isReverseProject = this.isSaleParam(saleOrgUnitInfo.getId().toString(), "POSTREQUISITION001", false);
        }
        return isReverseProject;
    }

    @Override
    public void storeFields() {
        this.storeSendAddress();
        super.storeFields();
        if (this.editData.isIsReverse()) {
            this.editData.setSyncOldValue(true);
        }
        this.storeFieldsByIsReverse(this.editData.isIsReverse());
        if (this.editData.isIsReverse()) {
            this.editData.setSyncOldValue(false);
        }
        if (BillBaseStatusEnum.SUBMITED.equals((Object)this.editData.getBaseStatus())) {
            this.initOldData((IObjectValue)this.editData);
        }
    }

    private void storeFieldsByIsReverse(boolean isReverse) {
        if (isReverse) {
            PostRequisitionEntryCollection entrys = this.editData.getEntries();
            int entrySize = entrys.size();
            for (int i = 0; i < entrySize; ++i) {
                PostRequisitionEntryInfo aPostRequisitionEntryInfo = entrys.get(i);
                if (aPostRequisitionEntryInfo.getQty() != null) {
                    aPostRequisitionEntryInfo.setQty(aPostRequisitionEntryInfo.getQty().abs().negate());
                }
                if (aPostRequisitionEntryInfo.getBaseQty() != null) {
                    aPostRequisitionEntryInfo.setBaseQty(aPostRequisitionEntryInfo.getBaseQty().abs().negate());
                }
                if (aPostRequisitionEntryInfo.getAssistQty() != null) {
                    aPostRequisitionEntryInfo.setAssistQty(aPostRequisitionEntryInfo.getAssistQty().abs().negate());
                }
                if (aPostRequisitionEntryInfo.getAmount() != null) {
                    aPostRequisitionEntryInfo.setAmount(aPostRequisitionEntryInfo.getAmount().abs().negate());
                }
                if (aPostRequisitionEntryInfo.getLocalAmount() == null) continue;
                aPostRequisitionEntryInfo.setLocalAmount(aPostRequisitionEntryInfo.getLocalAmount().abs().negate());
            }
        }
    }

    @Override
    protected String getEditUIName() {
        return PostRequisitionEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PostRequisitionFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (this.editData != null && SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData)) {
            MsgBox.showInfo((Component)((Object)this), (String)SaleUtil.getBizResource("Error_RelateCreateCantAddEntry"));
            SysUtil.abort();
        }
        PostRequisitionEntryInfo postRequisitionEntryInfo = null;
        try {
            postRequisitionEntryInfo = this.isUseAgent() ? PostRequisitionEntryAgent.create() : new PostRequisitionEntryInfo();
            postRequisitionEntryInfo.setShippedQty(defaultNum);
            postRequisitionEntryInfo.setPlanDeliveryQty(defaultNum);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return postRequisitionEntryInfo;
    }

    @Override
    protected IObjectValue createNewData() {
        PostRequisitionInfo objectValue = null;
        try {
            objectValue = this.isUseAgent() ? PostRequisitionAgent.create() : new PostRequisitionInfo();
            objectValue.setCompanyOrgUnit(SysContext.getSysContext().getCurrentFIUnit());
            objectValue.setBizDate(this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getCurrentTime() : SCMClientUtils.getServerDate2());
            objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            if (this.getDefaultMainBizOrg() instanceof SaleOrgUnitInfo) {
                objectValue.setSaleOrgUnit((SaleOrgUnitInfo)this.getDefaultMainBizOrg());
            }
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
            objectValue.setBillType(aBillTypeInfo);
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setMainTableAlign();
        this.kdtEntrys.getViewManager().setFreezeView(0, 2);
        this.setMessageBarText(null);
        this.initSaleOrgUnitF7();
        this.actionAudit.setBindWorkFlow(false);
        this.setFieldsToCopy(new String[]{TB_DELIVERTYPE, TB_POSTDATE, TB_DELIVERYDATE});
        this.txtMemo.setRequired(false);
        this.txtMemo.setMaxLength(255);
        this.kdtEntrys.getColumn(TB_PROJECTNAME).setEditor(null);
        UIHelper.registerProjectF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntrys, (String)TB_PROJECTNAME);
        UIHelper.registerTrackNumberF7((KDBizPromptBox)this.getMainOrgUnit(), null, (KDTable)this.kdtEntrys, (String)TB_PROJECTNAME, (String)TB_TRACKNUMBERNAME, (boolean)false);
        this.btnSplitOption.setVisible(false);
        this.menuItemCopyLine.setEnabled(false);
        this.menuItemCopyLine.setVisible(false);
        this.menuItemBillOptions.setVisible(true);
        this.btnCopyLine.setEnabled(false);
        this.btnCopyLine.setVisible(false);
        this.kdtEntrys.getColumn(TB_BASEUNIT).getStyleAttributes().setHided(false);
        this.kdtEntrys.getColumn(TB_BASEQTY).getStyleAttributes().setHided(false);
        this.kdtEntrys.getColumn(TB_BASEQTY).getStyleAttributes().setLocked(true);
        this.menuItemSplitLine.setVisible(true);
        this.menuItemSplitLine.setAccelerator(KeyStroke.getKeyStroke("shift ctrl F"));
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        int nrow = this.kdtEntrys.getRowCount();
        for (int i = 0; i < nrow; ++i) {
            this.disableCellForASSISTQTY(i);
        }
        if (this.prmtCreator.getData() == null || this.editData.getCreator() == null) {
            this.prmtCreator.setData((Object)SysContext.getSysContext().getCurrentUserInfo());
        }
    }

    @Override
    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
    }

    protected void calEntryDeliveryDate(int rowIndex, int colIndex, Date serverDate) {
        DeliveryTypeInfo deliveryTypeInfo;
        DeliveryTypeInfo deliveryTypeInfo2 = deliveryTypeInfo = this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERTYPE).getValue() == null ? null : (DeliveryTypeInfo)this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERTYPE).getValue();
        if (deliveryTypeInfo == null) {
            return;
        }
        if ("CARRY".equalsIgnoreCase(deliveryTypeInfo.getNumber())) {
            this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERYDATE).setValue(this.kdtEntrys.getRow(rowIndex).getCell(TB_POSTDATE).getValue());
            this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERYDATE).getStyleAttributes().setLocked(true);
            return;
        }
        Calendar curDate = Calendar.getInstance();
        int leadTime = this.kdtEntrys.getCell(rowIndex, TB_ADVANCEDAY).getValue() == null ? 0 : (Integer)this.kdtEntrys.getCell(rowIndex, TB_ADVANCEDAY).getValue();
        Date deliveryDate = serverDate != null ? serverDate : SCMClientUtils.getServerDate2();
        curDate.setTime(this.kdtEntrys.getRow(rowIndex).getCell(TB_POSTDATE).getValue() == null ? deliveryDate : (Date)this.kdtEntrys.getRow(rowIndex).getCell(TB_POSTDATE).getValue());
        curDate.add(5, leadTime);
        this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERYDATE).setValue((Object)curDate.getTime());
        this.kdtEntrys.getRow(rowIndex).getCell(TB_DELIVERYDATE).getStyleAttributes().setLocked(false);
    }

    public void afterChangeUnit(int rowIndex) throws EASBizException, BOSException {
        if (this.kdtEntrys.getCell(rowIndex, TB_UNIT).getValue() != null && this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue() != null) {
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue();
            IRow curRow = this.kdtEntrys.getRow(rowIndex);
            MeasureUnitInfo unitsInfo = (MeasureUnitInfo)curRow.getCell(TB_UNIT).getValue();
            BigDecimal baseUnitQty = (BigDecimal)this.kdtEntrys.getCell(rowIndex, TB_BASEQTY).getValue();
            BigDecimal unitQty = SCMClientUtils.getUnitQty((MeasureUnitInfo)unitsInfo, (MaterialInfo)materialInfo, (BigDecimal)baseUnitQty, (SCMFetchData)new SCMFetchData());
            curRow.getCell(TB_QTY).setValue((Object)unitQty);
        }
    }

    public void afterChangeUnitQty(int rowIndex) throws EASBizException, BOSException {
        if (this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue() != null) {
            if (!SCMClientUtils.isPlusData((String)this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue().toString())) {
                MsgBox.showInfo((String)SaleUtil.getBizResource("OutOfRange"));
                this.kdtEntrys.getCell(rowIndex, TB_QTY).setValue((Object)"");
                SysUtil.abort();
            } else {
                BigDecimal qty = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue());
                BigDecimal postQty = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).getValue());
                if (postQty != null) {
                    if (postQty.compareTo(qty) == 1) {
                        MsgBox.showInfo((String)SaleUtil.getBizResource("postQtyTooGreat"));
                        this.kdtEntrys.getCell(rowIndex, TB_QTY).setValue((Object)"");
                        SysUtil.abort();
                    } else if (!this.cbIsReverse.isSelected()) {
                        this.kdtEntrys.getCell(rowIndex, TB_INNAGEQTY).setValue((Object)qty.subtract(postQty));
                    }
                }
                if (this.kdtEntrys.getCell(rowIndex, TB_PRICE).getValue() != null) {
                    BigDecimal price = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_PRICE).getValue());
                    int scale = this.kdtEntrys.getColumn(TB_TOTAL).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntrys.getColumn(TB_TOTAL).getEditor().getComponent()).getPrecision();
                    int localscale = this.kdtEntrys.getColumn(TB_LOCALAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntrys.getColumn(TB_LOCALAMOUNT).getEditor().getComponent()).getPrecision();
                    this.kdtEntrys.getCell(rowIndex, TB_TOTAL).setValue((Object)qty.multiply(price).setScale(scale, 4));
                    BigDecimal oldAmount = (BigDecimal)this.kdtEntrys.getCell(rowIndex, TB_TOTAL).getValue();
                    if (this.tempexrateinfo != null) {
                        if (this.tempexrateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                            this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.multiply(this.exchangeRate).setScale(localscale, 4));
                        } else {
                            this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.divide(this.exchangeRate, localscale, 4));
                        }
                    } else {
                        this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.multiply(this.exchangeRate).setScale(localscale, 4));
                    }
                }
                if (this.kdtEntrys.getCell(rowIndex, TB_UNIT).getValue() != null && this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue() != null) {
                    MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue();
                    MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.kdtEntrys.getCell(rowIndex, TB_UNIT).getValue();
                    BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (BigDecimal)qty);
                    this.kdtEntrys.getCell(rowIndex, TB_BASEQTY).setValue((Object)baseUnitQty);
                    MeasureUnitInfo otherUnitInfo = (MeasureUnitInfo)this.kdtEntrys.getCell(rowIndex, TB_ASSISTANTUNIT).getValue();
                    if (otherUnitInfo != null) {
                        int scale;
                        BigDecimal assistantQty = SCMUtils.getExchangeQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)otherUnitInfo, (BigDecimal)qty);
                        int n = scale = this.kdtEntrys.getRow(rowIndex).getCell(TB_ASSISTQTY).getEditor() == null ? 6 : ((KDFormattedTextField)this.kdtEntrys.getRow(rowIndex).getCell(TB_ASSISTQTY).getEditor().getComponent()).getPrecision();
                        if (this.billOptionsHelper.isTransAssistByQty()) {
                            this.kdtEntrys.getCell(rowIndex, TB_ASSISTQTY).setValue((Object)assistantQty.setScale(scale, 4));
                        }
                        this.kdtEntrys.getRow(rowIndex).getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(false);
                    }
                }
            }
        }
    }

    private void disableCellForASSISTQTY(int rowIndex) {
        Object materialInfo = this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue();
        if (materialInfo instanceof MaterialInfo && ((MaterialInfo)materialInfo).getAssistUnit() == null) {
            this.kdtEntrys.getCell(rowIndex, TB_ASSISTQTY).getStyleAttributes().setLocked(true);
        } else {
            this.kdtEntrys.getCell(rowIndex, TB_ASSISTQTY).getStyleAttributes().setLocked(false);
        }
    }

    private void initInterface() {
        this.prmtBizType.setLabelVisible(true);
        this.prmtSaleOrgUnit.setLabelVisible(true);
        this.prmtSaleOrgUnit.setCommitFormat("$number$");
        this.prmtStorageOrgUnit.setLabelVisible(true);
        this.prmtStorageOrgUnit.setEnabled(false);
        this.prmtBizType.setReadOnly(true);
        if (!this.getOprtState().equals(OprtState.VIEW)) {
            this.dpBillDate.setRequired(true);
            SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntrys, (String[])NECESSITYTAB);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        }
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtSaleOrgUnit);
        this.contCompanyOrgUnit.setVisible(false);
    }

    private void setMainTableAlign() {
        int i;
        int num = ALIGNRIGHTTAB.length;
        for (i = 0; i < num; ++i) {
            this.kdtEntrys.getColumn(ALIGNRIGHTTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        num = ALIGNLEFTTAB.length;
        for (i = 0; i < num; ++i) {
            this.kdtEntrys.getColumn(ALIGNLEFTTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        }
    }

    private void initData() {
        if (!this.getOprtState().equals("ADDNEW")) {
            if (this.editData.getStorageOrgUnit() != null) {
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                storageOrgUnitInfo = this.editData.getStorageOrgUnit();
                this.prmtStorageOrgUnit.setText(storageOrgUnitInfo.getNumber());
                this.prmtStorageOrgUnit.setLabelText(storageOrgUnitInfo.getName());
            } else {
                this.prmtStorageOrgUnit.setText("");
                this.prmtStorageOrgUnit.setLabelText("");
            }
            if (this.editData.getBizType() != null) {
                BizTypeInfo bizTypeInfo = this.editData.getBizType();
                this.prmtBizType.setText(bizTypeInfo.getNumber());
                this.prmtBizType.setLabelText(bizTypeInfo.getName());
            } else {
                this.prmtBizType.setText("");
                this.prmtBizType.setLabelText("");
            }
        }
        this.registeUnVisibleField(new KDLabelContainer[]{this.contBaseStatus, this.contAuditor, this.contAuditTime, this.contUpdator, this.contUpdateDate, this.contCreator, this.contCreateTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.multiApproveIfInWF();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.curBizAction = BatchActionEnum.AUDIT;
            try {
                this.setOprtState("AUDIT");
                this.pubFireVOChangeListener(this.editData.getId().toString());
                IPostRequisition postRequisition = (IPostRequisition)this.getBizInterface();
                postRequisition.audit(new IObjectPK[]{pk});
                this.setMessageText(SaleUtil.getBizResource("AuditSuccess"));
                this.refreshCurPage();
                this.setAuditStatus(false);
                this.setUnAuditStatus(true);
                CoreBaseInfo model = postRequisition.getValue((IObjectPK)pk);
                IBillReservationFacade iBillReservationFacade = BillReservationFacadeFactory.getRemoteInstance();
                List list = iBillReservationFacade.doBillAutoReservation((IObjectValue)model);
                if (CollectionUtil.isEmpty((Collection)list)) return;
                EASBizException ex = null;
                StringBuffer msg = new StringBuffer(250);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ex = (EASBizException)((Object)list.get(i));
                    msg.append(ex.getMessage() + "\n");
                }
                String title = EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"AUTORESERVATION_WARNNING");
                MsgBox.showDetailAndOK(null, (String)title, (String)msg.toString(), (int)2);
                return;
            }
            catch (EASBizException er) {
                super.handUIException((Throwable)er);
                return;
            }
            catch (Throwable t) {
                this.handUIException(t);
                return;
            }
            finally {
                if (this.editData.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                    this.setOprtState(OprtState.VIEW);
                    this.setLockTab();
                } else {
                    this.setOprtState(OprtState.EDIT);
                }
                try {
                    this.pubFireVOChangeListener(null);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
            }
        }
        MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
        SysUtil.abort();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.curBizAction = BatchActionEnum.UNAUDIT;
        super.actionUnAudit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null && !this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            String[] strID = new String[]{this.editData.getId().toString()};
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])strID);
            if (pks != null) {
                try {
                    IPostRequisition iPostRequisition = (IPostRequisition)this.getBizInterface();
                    this.setOprtState("REVOKE");
                    this.btnRemoveLine.setEnabled(false);
                    this.pubFireVOChangeListener(this.editData.getId().toString());
                    iPostRequisition.isCancel(pks);
                    Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
                    if (reasonCodeInfo != null) {
                        if (reasonCodeInfo instanceof IObjectValue) {
                            iPostRequisition.cancel(pks, ((ReasonCodeInfo)reasonCodeInfo).getName());
                        }
                        if (reasonCodeInfo instanceof String) {
                            iPostRequisition.cancel(pks[0], (String)reasonCodeInfo);
                        }
                        this.setMessageText(SaleUtil.getBizResource("RevokeSuccess"));
                    }
                    this.setSaved(true);
                    this.refreshInterface();
                }
                catch (EASBizException er) {
                    super.handUIException((Throwable)er);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                }
                finally {
                    this.setOprtState("RELEASEALL");
                    try {
                        this.pubFireVOChangeListener(null);
                    }
                    catch (Throwable t) {
                        this.handUIException(t);
                    }
                }
            }
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] strID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntrys, (String)"entryID");
        if (this.editData.getId() != null && strID != null) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])strID);
            IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            try {
                this.setOprtState("FREEZE");
                this.pubFireVOChangeListener(this.editData.getId().toString());
                iPostRequisitionEntry.isFreezed(pks);
                Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
                if (reasonCodeInfo != null && pks != null) {
                    if (reasonCodeInfo instanceof IObjectValue) {
                        iPostRequisitionEntry.freezed(pks, (IObjectValue)((ReasonCodeInfo)reasonCodeInfo));
                    }
                    if (reasonCodeInfo instanceof String) {
                        iPostRequisitionEntry.freezed(pks, (String)reasonCodeInfo);
                    }
                    this.setMessageText(SaleUtil.getBizResource("BlockSuccess"));
                }
                this.setSaved(true);
            }
            catch (EASBizException er) {
                super.handUIException((Throwable)er);
                SysUtil.abort();
            }
            catch (Throwable t) {
                this.handUIException(t);
                SysUtil.abort();
            }
            finally {
                this.setOprtState("RELEASEALL");
                try {
                    this.pubFireVOChangeListener(null);
                }
                catch (Throwable t) {
                    this.handUIException(t);
                    SysUtil.abort();
                }
            }
            this.refreshInterface();
        } else if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
            SysUtil.abort();
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionSelectEntry"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnFreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] strID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntrys, (String)"entryID");
        if (this.editData.getId() != null && strID != null) {
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])strID);
            if (pks != null) {
                IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                try {
                    this.setOprtState("UNFREEZE");
                    this.pubFireVOChangeListener(this.editData.getId().toString());
                    iPostRequisitionEntry.isUnFreezed(pks);
                    iPostRequisitionEntry.unFreezed(pks);
                    this.setSaved(true);
                    this.setMessageText(SaleUtil.getBizResource("UnBlockSuccess"));
                }
                catch (EASBizException er) {
                    super.handUIException((Throwable)er);
                    SysUtil.abort();
                }
                catch (Throwable t) {
                    this.handUIException(t);
                    SysUtil.abort();
                }
                finally {
                    this.setOprtState("RELEASEALL");
                    try {
                        this.pubFireVOChangeListener(null);
                    }
                    catch (Throwable t) {
                        this.handUIException(t);
                        SysUtil.abort();
                    }
                }
                this.refreshInterface();
            }
        } else if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
            SysUtil.abort();
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionSelectEntry"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionReverse_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getBaseStatus() != null && this.editData.getBaseStatus().getValue() == 4) {
            boolean isChkPassed = false;
            PostRequisitionEntryCollection entries = this.editData.getEntries();
            PostRequisitionEntryInfo aPostRequisitionEntryInfo = null;
            int entrySize = entries.size();
            for (int i = 0; i < entrySize; ++i) {
                aPostRequisitionEntryInfo = entries.get(i);
                EntryBaseStatusEnum baseStatus = aPostRequisitionEntryInfo.getBaseStatus();
                if (baseStatus == null || baseStatus.getValue() != 4) continue;
                isChkPassed = true;
                break;
            }
            if (!isChkPassed) {
                new OrderException(OrderException.ONE_ADUITED_ENTRY_CAN_REVERSE);
            }
        } else {
            throw new OrderException(OrderException.ORDER_CANNOT_REVERSE);
        }
        BigDecimal ZERO = new BigDecimal("0.00");
        String oldBillId = this.editData.getId().toString();
        String oldBillNumber = this.editData.getNumber();
        ObjectUuidPK billTypePK = new ObjectUuidPK("510b6503-0105-1000-e000-011bc0a812fd463ED552");
        BillTypeInfo oldBillType = BillTypeFactory.getRemoteInstance().getBillTypeInfo((IObjectPK)billTypePK);
        this.checkModified();
        if (this.editData != null) {
            IObjectValue objectValue = (IObjectValue)this.getUIContext().get("CURRENT.VO");
            if (objectValue != null) {
                try {
                    String id = this.idList.getID(this.idList.getCurrentIndex());
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(id);
                }
                catch (Throwable err) {
                    this.handUIException(new Exception(err));
                }
            }
            this.editData.setId(null);
            this.editData.setNumber(null);
        }
        this.setMakeRelations(null);
        this.unLockUI();
        this.setOprtState("ADDNEW");
        if (this.getMainBizOrg().getValue() != null) {
            this.setNumWhereCopy();
            this.getNumTextField().setEnabled(this.getIsEditable());
            this.getNumTextField().setEditable(this.getIsEditable());
        }
        this.showReverseMessage();
        this.editData.setBaseStatus(BillBaseStatusEnum.ADD);
        this.editData.setSourceBillId(oldBillId);
        this.editData.setSourceBillType(oldBillType);
        this.editData.setIsReverse(true);
        Timestamp curDate = SCMClientUtils.getServerDate();
        this.editData.setBizDate(curDate);
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setCreateTime(curDate);
        this.editData.setLastUpdateTime(null);
        this.editData.setLastUpdateUser(null);
        this.editData.setModificationTime(null);
        this.editData.setModifier(null);
        this.editData.setAuditor(null);
        this.editData.setAuditTime(null);
        super.actionReverse_actionPerformed(e);
        PostRequisitionEntryCollection entries = this.editData.getEntries();
        PostRequisitionEntryInfo aPostRequisitionEntryInfo = null;
        int entrySize = entries.size();
        for (int i = 0; i < entrySize; ++i) {
            int localPrecision;
            aPostRequisitionEntryInfo = entries.get(i);
            EntryBaseStatusEnum baseStatus = aPostRequisitionEntryInfo.getBaseStatus();
            if (aPostRequisitionEntryInfo.getId() == null || baseStatus == null || baseStatus.getValue() != 4) {
                entries.removeObject((IObjectValue)aPostRequisitionEntryInfo);
                --i;
                --entrySize;
                continue;
            }
            aPostRequisitionEntryInfo.setSourceBillId(oldBillId);
            aPostRequisitionEntryInfo.setSourceBillNumber(oldBillNumber);
            aPostRequisitionEntryInfo.setSourceBillType(oldBillType);
            aPostRequisitionEntryInfo.setSourceBillEntryId(aPostRequisitionEntryInfo.getId().toString());
            aPostRequisitionEntryInfo.setSourceBillEntrySeq(aPostRequisitionEntryInfo.getSeq());
            aPostRequisitionEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            aPostRequisitionEntryInfo.setReason(null);
            aPostRequisitionEntryInfo.setReasonCode(null);
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)aPostRequisitionEntryInfo.getQty());
            BigDecimal totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)aPostRequisitionEntryInfo.getTotalReversedQty());
            BigDecimal shippedQty = SCMUtils.effectualNumeric((BigDecimal)aPostRequisitionEntryInfo.getShippedQty());
            qty = qty.subtract(totalReversedQty).subtract(shippedQty);
            aPostRequisitionEntryInfo.setQty(qty);
            MaterialInfo materialInfo = aPostRequisitionEntryInfo.getMaterial();
            MeasureUnitInfo unitInfo = aPostRequisitionEntryInfo.getUnit();
            MeasureUnitInfo assistUnitInfo = aPostRequisitionEntryInfo.getAssistUnit();
            MeasureUnitInfo baseUnitInfo = aPostRequisitionEntryInfo.getBaseUnit();
            BigDecimal price = aPostRequisitionEntryInfo.getPrice();
            if (qty != null && unitInfo != null && baseUnitInfo != null) {
                aPostRequisitionEntryInfo.setBaseQty(SCMUtils.getExchangePricesionQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)qty));
            }
            if (qty != null && unitInfo != null && assistUnitInfo != null) {
                aPostRequisitionEntryInfo.setAssistQty(SCMUtils.getExchangePricesionQtyForClient((String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty));
            }
            if (qty != null && price != null) {
                int precision = this.editData.getCurrency() == null ? 2 : this.editData.getCurrency().getPrecision();
                aPostRequisitionEntryInfo.setAmount(qty.multiply(price).setScale(precision, 4));
            }
            int n = localPrecision = this.baseCurrInfo == null ? 2 : this.baseCurrInfo.getPrecision();
            if (this.tempexrateinfo != null) {
                if (this.tempexrateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    aPostRequisitionEntryInfo.setLocalAmount(aPostRequisitionEntryInfo.getAmount().multiply(this.exchangeRate).setScale(localPrecision, 4));
                } else {
                    aPostRequisitionEntryInfo.setLocalAmount(aPostRequisitionEntryInfo.getAmount().divide(this.exchangeRate, localPrecision, 4));
                }
            } else {
                aPostRequisitionEntryInfo.setLocalAmount(aPostRequisitionEntryInfo.getAmount().multiply(this.exchangeRate).setScale(localPrecision, 4));
            }
            aPostRequisitionEntryInfo.setAssociateQty(ZERO);
            aPostRequisitionEntryInfo.setShippedQty(ZERO);
            aPostRequisitionEntryInfo.setShippedBaseQty(ZERO);
            aPostRequisitionEntryInfo.setUnShippedQty(ZERO);
            aPostRequisitionEntryInfo.setTotalReversedQty(ZERO);
            aPostRequisitionEntryInfo.setTotalReversedBaseQty(ZERO);
            aPostRequisitionEntryInfo.setId(null);
            aPostRequisitionEntryInfo.setParent(this.editData);
        }
        ObjectValueUtil.copy((AbstractObjectValue)this.editData);
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void showReverseMessage() {
        this.setMessageText(MessageFormat.format(SaleUtil.getUIResource("BILL_REVERSE"), this.getClassAlise()));
        this.setIsShowTextOnly(true);
        this.setShowMessagePolicy(2);
        this.showMessage();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        ((PostRequisitionInfo)newData).setNumber(null);
        ((PostRequisitionInfo)newData).setBaseStatus(BillBaseStatusEnum.ADD);
        ((PostRequisitionInfo)newData).setCreator(SysContext.getSysContext().getCurrentUserInfo());
        try {
            ((PostRequisitionInfo)newData).setCreateTime(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        ((PostRequisitionInfo)newData).setLastUpdateUser(null);
        ((PostRequisitionInfo)newData).setLastUpdateTime(null);
        ((PostRequisitionInfo)newData).setAuditor(null);
        ((PostRequisitionInfo)newData).setAuditTime(null);
        PostRequisitionEntryCollection collection = ((PostRequisitionInfo)newData).getEntries();
        int c = collection.size();
        for (int i = 0; i < c; ++i) {
            PostRequisitionEntryInfo prEntryInfo = collection.get(i);
            prEntryInfo.setShippedQty(SysConstant.BIGZERO);
            prEntryInfo.setShippedBaseQty(SysConstant.BIGZERO);
            prEntryInfo.setUnShippedQty(prEntryInfo.getQty());
            prEntryInfo.setTotalReversedQty(SysConstant.BIGZERO);
            prEntryInfo.setTotalReversedBaseQty(SysConstant.BIGZERO);
            prEntryInfo.setPlanDeliveryQty(SysConstant.BIGZERO);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            this.curBizAction = BatchActionEnum.SAVE;
            super.actionSave_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionNotSave"));
            SysUtil.abort();
        }
    }

    public void checkSourceBill() throws Exception {
        if (!SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData)) {
            MsgBox.showError((Component)((Object)this), (String)SaleUtil.getBizResource("Error_NotRelateCreate"));
            SysUtil.abort();
        }
    }

    protected boolean checkSubmit() throws Exception {
        KDTable table;
        this.checkSourceBill();
        if (this.dpBillDate.getValue() == null) {
            this.dpBillDate.requestFocus();
            super.handleException((Exception)new SCMBillException(SCMBillException.BIZDATEISNULL));
            SysUtil.abort();
        }
        if (this.prmtPaymentType.getValue() == null) {
            this.prmtPaymentType.requestFocus();
            super.handleException((Exception)((Object)new PostRequisitionException(PostRequisitionException.NULL_PAYMENTTYPE)));
            SysUtil.abort();
        }
        if ((table = this.getDetailTable()).getRowCount() < 1) {
            throw new OrderException(OrderException.ENTRY_CANNOT_EMPTY);
        }
        String[] FIELDNAMES = new String[]{TB_ORDERCUSTOMER, TB_DELIVERYCUSTOMER, TB_RECEIVECUSTOMER, TB_PAYMENTCUSTOMER};
        int errorCounts = 0;
        int MAX_ERRORS = 5;
        StringBuffer sb = new StringBuffer();
        String diStr = PurUtil.getUIResource((String)"NO");
        String rowStr = PurUtil.getUIResource((String)"ROW");
        IRow headRow = table.getHeadRow(0);
        String cannotNull = SCMClientUtils.getResource((String)"EntryFieldCheck_NotSet") + "\n";
        BigDecimal qty = null;
        int rowCount = table.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            IRow row = table.getRow(rowIndex);
            for (String fieldName : FIELDNAMES) {
                if (row.getCell(fieldName).getValue() != null) continue;
                String fieldCaption = String.valueOf(headRow.getCell(fieldName).getValue());
                sb.append(diStr).append(rowIndex + 1).append(rowStr).append(fieldCaption).append(cannotNull);
                if (++errorCounts >= MAX_ERRORS) break;
            }
            if ((qty = (BigDecimal)row.getCell(TB_QTY).getValue()) == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
                sb.append(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.common.SCMResource", (String)"QtyGreaterZero", (String[])new String[]{"" + (rowIndex + 1)}) + "\r\n");
                ++errorCounts;
            }
            if (errorCounts >= MAX_ERRORS) break;
        }
        if (errorCounts > 0) {
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSubmit();
        CreditCheck.checkPostbillAtSubmit((PostRequisitionEditUI)this);
        this.curBizAction = BatchActionEnum.SUBMIT;
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            if (!this.cbIsReverse.isSelected()) {
                if (this.checkBusinessRule() == 0) {
                    super.actionSubmit_actionPerformed(e);
                    if (this.editData != null && this.editData.getId() != null) {
                        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
                        IPostRequisition postRequisition = (IPostRequisition)this.getBizInterface();
                        CoreBaseInfo model = postRequisition.getValue((IObjectPK)pk);
                        IBillReservationFacade iBillReservationFacade = BillReservationFacadeFactory.getRemoteInstance();
                        List list = iBillReservationFacade.doBillAutoReservation((IObjectValue)model);
                        if (!CollectionUtil.isEmpty((Collection)list)) {
                            EASBizException ex = null;
                            StringBuffer msg = new StringBuffer(250);
                            int size = list.size();
                            for (int i = 0; i < size; ++i) {
                                ex = (EASBizException)((Object)list.get(i));
                                msg.append(ex.getMessage() + "\n");
                            }
                            String title = EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"AUTORESERVATION_WARNNING");
                            MsgBox.showDetailAndOK(null, (String)title, (String)msg.toString(), (int)2);
                        }
                    }
                } else {
                    SysUtil.abort();
                }
            } else {
                int rowCount = this.getDetailTable().getRowCount();
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    IRow arow = this.getDetailTable().getRow(rowIndex);
                    BigDecimal qty = (BigDecimal)arow.getCell(TB_QTY).getValue();
                    if (SCMUtils.effectualNumeric((BigDecimal)qty).compareTo(SysConstant.BIGZERO) > 0) continue;
                    this.handUIException((Throwable)new SCMBillException(SCMBillException.REVERSE_QTY_MUST_BIG_THAN_ZERO, (Object[])new String[]{String.valueOf(rowIndex + 1)}));
                    SysUtil.abort();
                }
                super.actionSubmit_actionPerformed(e);
            }
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionNotSubmit"));
        }
        this.setStatus();
    }

    public boolean isAdminOrgUnitByPerson() throws EASBizException, BOSException {
        SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData();
        boolean isAdminOrgUnitByPerson = false;
        if (saleOrgUnitInfo != null) {
            isAdminOrgUnitByPerson = this.isSaleParam(saleOrgUnitInfo.getId().toString(), "SALEORDER002", false);
        }
        return isAdminOrgUnitByPerson;
    }

    private int checkBusinessRule() {
        block7: {
            try {
                if (!this.isAdminOrgUnitByPerson()) break block7;
                PostRequisitionEntryCollection entries = this.editData.getEntries();
                int size = entries.size();
                String[] entriesIds = new String[size];
                for (int i = 0; i < size; ++i) {
                    entriesIds[i] = entries.get(i).getSourceBillEntryId();
                }
                try {
                    IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getRemoteInstance();
                    iPostRequisitionEntry.checkBusinessRule(entriesIds);
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
                catch (BizCheckException e) {
                    return MsgBox.showConfirm2((String)SaleUtil.getBizResource("BOTPSaleOrderEntreisUnReceivedAmount"));
                }
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        return 0;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionAuditNotDelete"));
                SysUtil.abort();
            }
            if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
                MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionCancelNotDelete"));
                SysUtil.abort();
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    private void initToolBar() {
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.btnReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuItemReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuItemClose.setVisible(false);
        this.menuItemUnClose.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnFreeze.setEnabled(true);
        this.btnUnFreeze.setEnabled(true);
        this.btnUnClose.setEnabled(true);
        this.btnRevoke.setEnabled(true);
        this.btnEdit.setEnabled(true);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.btnEdit.setEnabled(false);
        }
        this.btnAddNew.setEnabled(true);
        this.btnCopy.setVisible(false);
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(true);
        this.menuTable1.setVisible(true);
        this.menuItemAddLine.setEnabled(false);
        this.menuItemInsertLine.setEnabled(false);
        this.menuItemRemoveLine.setVisible(true);
        this.menuItemRemoveLine.setEnabled(true);
        this.menuItemCopy.setVisible(false);
        this.menuItemAddNew.setEnabled(true);
        this.separator9.setVisible(false);
        this.separator8.setVisible(false);
        this.separator7.setVisible(false);
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            if (!"VIEW".equals(this.getOprtState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
            this.setAuditStatus(false);
            this.setUnAuditStatus(false);
        }
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            this.setAuditStatus(true);
        }
        if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.setAuditStatus(false);
            this.setUnAuditStatus(true);
            this.menuItemRemoveLine.setEnabled(false);
        }
        this.separator1.setVisible(false);
        this.menuItemAudit.setVisible(true);
        if (!this.getOprtState().equals("VIEW") && (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED))) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(true);
        } else {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionSplitLine.setEnabled(false);
        }
    }

    private void refreshInterface() {
        try {
            IPostRequisition iPostRequisition = (IPostRequisition)this.getBizInterface();
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            this.editData = iPostRequisition.getPostRequisitionInfo((IObjectPK)iObjectPk, this.getSelectors());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtSaleOrgUnit;
    }

    private void initKDTEntry() {
        KDBizPromptBox prmtAdminOrgUint;
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    PostRequisitionEditUI.this.kdtEntrys_Changing(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    PostRequisitionEditUI.this.handUIExceptionAndAbort(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    PostRequisitionEditUI.this.kdtEntrys_valueChanged(e);
                }
                catch (Exception exc) {
                    PostRequisitionEditUI.this.handUIExceptionAndAbort(exc);
                }
            }
        });
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtSaleOrgUnit.setEntityViewInfo(viewInfo);
        this.setBizTypeF7();
        this.kdtEntrys_salePerson_PromptBox = new KDBizPromptBox();
        this.kdtEntrys_salePerson_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        KDTDefaultCellEditor kdtEntrys_salePerson_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.kdtEntrys_salePerson_PromptBox);
        this.kdtEntrys_salePerson_PromptBox.setCommitFormat("$person.number$;$person.idNum$");
        this.kdtEntrys.getColumn(TB_BIZPERSON).setEditor((ICellEditor)kdtEntrys_salePerson_CellEditor);
        if (this.kdtEntrys.getColumn("adminOrgUnit") != null && this.kdtEntrys.getColumn("adminOrgUnit").getEditor() != null && (prmtAdminOrgUint = (KDBizPromptBox)this.kdtEntrys.getColumn("adminOrgUnit").getEditor().getComponent()) != null) {
            prmtAdminOrgUint.setCommitFormat("$number$;$code$");
        }
        KDBizPromptBox kdtEntrys_saleGroup_PromptBox = new KDBizPromptBox();
        kdtEntrys_saleGroup_PromptBox.setVisible(true);
        kdtEntrys_saleGroup_PromptBox.setEditable(true);
        kdtEntrys_saleGroup_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_saleGroup_PromptBox.setEditFormat("$number$");
        kdtEntrys_saleGroup_PromptBox.setCommitFormat("$number$");
        kdtEntrys_saleGroup_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SaleGroupQuery");
        KDTDefaultCellEditor kdtEntrys_saleGroup_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_saleGroup_PromptBox);
        this.kdtEntrys.getColumn(TB_BIZGROUP).setEditor((ICellEditor)kdtEntrys_saleGroup_CellEditor);
        KDTextField txtField = new KDTextField();
        KDTDefaultCellEditor kdtEntrys_postWarehouse_CellEditor = new KDTDefaultCellEditor((JTextField)txtField);
        this.kdtEntrys.getColumn(TB_POSTWAREHOUSE).setEditor((ICellEditor)kdtEntrys_postWarehouse_CellEditor);
        this.clientHelper.validQtyCell(this.kdtEntrys, NUMBERTAB);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn(TB_MATERIAL).setRenderer((IBasicRender)avr);
        ObjectValueRender avrname = new ObjectValueRender();
        avrname.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn(TB_ORDERCUSTOMER).setRenderer((IBasicRender)avrname);
        this.kdtEntrys.getColumn(TB_DELIVERYCUSTOMER).setRenderer((IBasicRender)avrname);
        this.kdtEntrys.getColumn(TB_RECEIVECUSTOMER).setRenderer((IBasicRender)avrname);
        this.kdtEntrys.getColumn(TB_PAYMENTCUSTOMER).setRenderer((IBasicRender)avrname);
        this.kdtEntrys.getColumn(TB_POSTDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        this.kdtEntrys.getColumn(TB_DELIVERYDATE).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
        String[] qtyMaxLen = new String[]{TB_QTY};
        String[] addressMaxLen = new String[]{TB_ADDRESS, "memo"};
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.getDetailTable(), (String[])qtyMaxLen, (int)13);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.getDetailTable(), (String[])addressMaxLen, (int)255);
    }

    private void kdtEntrys_valueChanged(KDTEditEvent e) throws Exception {
        BigDecimal qty;
        if (TB_POSTWAREHOUSE.equalsIgnoreCase(this.kdtEntrys.getColumn(e.getColIndex()).getKey())) {
            WarehouseInfo oldWarehouseInfo = (WarehouseInfo)e.getOldValue();
            WarehouseInfo newWarehouseInfo = (WarehouseInfo)e.getValue();
            KDBizPromptBox box = new KDBizPromptBox();
            IRow curRow = this.kdtEntrys.getRow(e.getRowIndex());
            if (oldWarehouseInfo != null && newWarehouseInfo != null && !oldWarehouseInfo.equals((Object)newWarehouseInfo)) {
                curRow.getCell(TB_LOCATION).setValue(null);
                curRow.getCell(TB_LOCATION).getStyleAttributes().setLocked(false);
            }
            int rowCount = this.getDetailTable().getRowCount();
            IRow iRow = null;
            int currindex = e.getRowIndex();
            Object tempWI = null;
            Object tempMi = null;
            try {
                box = newWarehouseInfo != null ? LocationHelper.setLocationF7((CoreUIObject)this, (KDBizPromptBox)box, (String)newWarehouseInfo.getId().toString()) : LocationHelper.setLocationF7((CoreUIObject)this, (KDBizPromptBox)box, null);
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
            curRow.getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
            for (int i = currindex; i < rowCount; ++i) {
                iRow = this.getDetailTable().getRow(i);
                if (iRow.getCell(TB_POSTWAREHOUSE).getValue() != null) continue;
                iRow.getCell(TB_POSTWAREHOUSE).setValue((Object)newWarehouseInfo);
                if (this.kdtEntrys.getCell(i, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) {
                    if (((WarehouseInfo)this.kdtEntrys.getCell(i, TB_POSTWAREHOUSE).getValue()).isHasLocation()) {
                        this.kdtEntrys.getCell(i, TB_LOCATION).getStyleAttributes().setLocked(false);
                        iRow.getCell(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
                        continue;
                    }
                    this.kdtEntrys.getCell(i, TB_LOCATION).getStyleAttributes().setLocked(true);
                    continue;
                }
                this.kdtEntrys.getCell(i, TB_LOCATION).setValue(null);
                this.kdtEntrys.getCell(i, TB_LOCATION).getStyleAttributes().setLocked(true);
            }
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtEntrys.getRow(rowIndex) == null || this.kdtEntrys.getCell(rowIndex, colIndex) == null) {
            return;
        }
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if (TB_MATERIAL.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue() instanceof MaterialInfo) {
                MaterialInfo materialInfo = (MaterialInfo)this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).getValue();
                this.kdtEntrys.getCell(rowIndex, TB_MATERIAL).setValue((Object)materialInfo);
                this.kdtEntrys.getCell(rowIndex, TB_MATERIALNAME).setValue((Object)materialInfo.getName());
                this.kdtEntrys.getCell(rowIndex, TB_MODEL).setValue((Object)materialInfo.getModel());
                this.initEntryPrecision(rowIndex, materialInfo);
            }
        } else if (TB_LOCATION.equalsIgnoreCase(fieldName)) {
            if (rowIndex == 0 && this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) {
                WarehouseInfo warehouseInfo = (WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue();
                LocationInfo locationInfo = (LocationInfo)this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getValue();
                int count = this.kdtEntrys.getRowCount();
                for (int i = 1; i < count; ++i) {
                    if (this.kdtEntrys.getRow(i).getCell(TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) continue;
                    this.kdtEntrys.getRow(i).getCell(TB_POSTWAREHOUSE).setValue((Object)warehouseInfo);
                    this.kdtEntrys.getRow(i).getCell(TB_LOCATION).setValue((Object)locationInfo);
                    this.kdtEntrys.getRow(i).getCell(TB_LOCATION).getStyleAttributes().setLocked(false);
                }
            }
        } else if (TB_QTY.equalsIgnoreCase(fieldName)) {
            BigDecimal newValue;
            BigDecimal oldValue = e.getOldValue() == null ? BigDecimal.ZERO : (BigDecimal)e.getOldValue();
            BigDecimal bigDecimal = newValue = e.getValue() == null ? BigDecimal.ZERO : SCMClientUtils.toBigDecimal((Object)e.getValue());
            if (oldValue.compareTo(newValue) != 0) {
                this.afterChangeUnitQty(rowIndex);
            }
        } else if (TB_ASSISTQTY.equalsIgnoreCase(fieldName)) {
            if (this.billOptionsHelper.isTransQtyByAssist()) {
                MaterialInfo material = (MaterialInfo)this.kdtEntrys.getRow(rowIndex).getCell(TB_MATERIAL).getValue();
                MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)this.kdtEntrys.getRow(rowIndex).getCell(TB_BASEUNIT).getValue();
                MeasureUnitInfo assistUnitInfo = (MeasureUnitInfo)this.kdtEntrys.getRow(rowIndex).getCell(TB_ASSISTANTUNIT).getValue();
                MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.kdtEntrys.getRow(rowIndex).getCell(TB_UNIT).getValue();
                Object newValue = this.kdtEntrys.getRow(rowIndex).getCell(TB_ASSISTQTY).getValue();
                BigDecimal assistQty = newValue == null ? defaultNum : (BigDecimal)newValue;
                BigDecimal baseQty = null;
                if (assistUnitInfo != null && baseUnitInfo != null) {
                    baseQty = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)assistUnitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)assistQty);
                    this.kdtEntrys.getRow(rowIndex).getCell(TB_BASEQTY).setValue((Object)baseQty);
                }
                if (baseUnitInfo != null && unitInfo != null) {
                    BigDecimal qty2 = SCMUtils.getExchangePricesionQtyForClient((String)material.getId().toString(), (MeasureUnitInfo)baseUnitInfo, (MeasureUnitInfo)unitInfo, (BigDecimal)baseQty);
                    this.kdtEntrys.getRow(rowIndex).getCell(TB_QTY).setValue((Object)qty2);
                }
                this.afterChangeUnitQty(rowIndex);
            }
        } else if (TB_POSTQTY.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).getValue() != null) {
                if (!SCMClientUtils.isPlusData((String)this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).getValue().toString())) {
                    MsgBox.showInfo((String)SaleUtil.getBizResource("OutOfRange"));
                    this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).setValue((Object)"");
                    SysUtil.abort();
                } else {
                    qty = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue());
                    if (qty != null) {
                        BigDecimal postQty = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).getValue());
                        if (postQty.compareTo(qty) == 1) {
                            MsgBox.showInfo((String)SaleUtil.getBizResource("postQtyTooGreat"));
                            this.kdtEntrys.getCell(rowIndex, TB_POSTQTY).setValue((Object)defaultNum);
                            this.kdtEntrys.getCell(rowIndex, TB_INNAGEQTY).setValue(this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue());
                            SysUtil.abort();
                        } else {
                            this.kdtEntrys.getCell(rowIndex, TB_INNAGEQTY).setValue((Object)qty.subtract(postQty));
                        }
                    }
                }
            }
        } else if (TB_PRICE.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntrys.getCell(rowIndex, TB_PRICE).getValue() != null && this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue() != null) {
                qty = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_QTY).getValue());
                BigDecimal price = SCMClientUtils.toBigDecimal((Object)this.kdtEntrys.getCell(rowIndex, TB_PRICE).getValue());
                int scale = this.kdtEntrys.getRow(rowIndex).getCell(TB_TOTAL).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntrys.getRow(rowIndex).getCell(TB_TOTAL).getEditor().getComponent()).getPrecision();
                int localscale = this.kdtEntrys.getRow(rowIndex).getCell(TB_LOCALAMOUNT).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntrys.getRow(rowIndex).getCell(TB_LOCALAMOUNT).getEditor().getComponent()).getPrecision();
                this.kdtEntrys.getCell(rowIndex, TB_TOTAL).setValue((Object)qty.multiply(price).setScale(scale, 4));
                BigDecimal oldAmount = (BigDecimal)this.kdtEntrys.getCell(rowIndex, TB_TOTAL).getValue();
                if (this.tempexrateinfo != null) {
                    if (this.tempexrateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                        this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.multiply(this.exchangeRate).setScale(localscale, 4));
                    } else {
                        this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.divide(this.exchangeRate, localscale, 4));
                    }
                } else {
                    this.kdtEntrys.getCell(rowIndex, TB_LOCALAMOUNT).setValue((Object)oldAmount.multiply(this.exchangeRate).setScale(localscale, 4));
                }
            }
        } else if (TB_POSTWAREHOUSE.equalsIgnoreCase(fieldName)) {
            if (this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) {
                if (((WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue()).isHasLocation()) {
                    this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(true);
                }
            } else {
                this.kdtEntrys.getCell(rowIndex, TB_LOCATION).setValue(null);
                this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(true);
            }
        } else if (TB_DELIVERTYPE.equalsIgnoreCase(fieldName)) {
            int c = this.kdtEntrys.getRowCount();
            for (int i = 0; i < c; ++i) {
                if (this.kdtEntrys.getCell(i, TB_DELIVERTYPE).getValue() != null) continue;
                this.kdtEntrys.getCell(i, TB_DELIVERTYPE).setValue(this.kdtEntrys.getCell(rowIndex, TB_DELIVERTYPE).getValue());
            }
            this.calEntryDeliveryDate(rowIndex, colIndex, null);
        } else if (TB_POSTDATE.equalsIgnoreCase(fieldName) || TB_ADVANCEDAY.equalsIgnoreCase(fieldName)) {
            this.calEntryDeliveryDate(rowIndex, colIndex, null);
        } else if (TB_UNIT.equalsIgnoreCase(fieldName)) {
            if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
                return;
            }
            this.afterChangeUnit(rowIndex);
        }
        this.disableCellForASSISTQTY(rowIndex);
    }

    protected void kdtEntrys_Changing(int rowIndex, int colIndex) throws Exception {
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if (TB_POSTWAREHOUSE.equalsIgnoreCase(fieldName)) {
            if (this.prmtStorageOrgUnit.getData() == null) {
                this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).setValue((Object)"");
                this.kdtEntrys.getColumn(TB_POSTWAREHOUSE).setEditor(null);
                MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionStoreOrg"));
                this.prmtStorageOrgUnit.requestFocusInWindow();
                SysUtil.abort();
            }
        } else if (TB_LOCATION.equalsIgnoreCase(fieldName)) {
            String wareHouseId = ((WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue()).getId().toString();
            if (this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)((WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue()).getId().toString(), CompareType.EQUALS));
                view.setFilter(filter);
                if (this.kdtEntrys.getColumn(TB_LOCATION).getEditor() != null && this.kdtEntrys.getColumn(TB_LOCATION).getEditor().getComponent() instanceof KDBizPromptBox) {
                    KDBizPromptBox box = new KDBizPromptBox();
                    box = LocationHelper.setLocationF7((CoreUIObject)this, (KDBizPromptBox)box, (String)wareHouseId);
                    this.kdtEntrys.getColumn(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
                }
            } else if (this.kdtEntrys.getColumn(TB_LOCATION).getEditor() != null && this.kdtEntrys.getColumn(TB_LOCATION).getEditor().getComponent() instanceof KDBizPromptBox) {
                KDBizPromptBox box = new KDBizPromptBox();
                box = LocationHelper.setLocationF7((CoreUIObject)this, (KDBizPromptBox)box, null);
                this.kdtEntrys.getColumn(TB_LOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)box));
            }
        } else if (TB_ADDRESS.equals(fieldName)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            CustomerInfo customerInfo = (CustomerInfo)this.kdtEntrys.getCell(rowIndex, TB_DELIVERYCUSTOMER).getValue();
            SaleOrgUnitInfo saleOrgInfo = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData();
            if (saleOrgInfo != null && customerInfo != null) {
                filter.appendFilterItem("SaleOrgUnit.id", (Object)(saleOrgInfo == null ? "nonexisted_saleorgid" : saleOrgInfo.getId().toString()));
                filter.appendFilterItem("Customer.id", (Object)(customerInfo == null ? "nonexisted_customerid" : customerInfo.getId().toString()));
                viewInfo.setFilter(filter);
            }
            this.prmtEntrySendAddress.setEntityViewInfo(viewInfo);
        }
    }

    protected void setBizTypeF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"320", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtBizType.setEntityViewInfo(viewInfo);
        this.prmtBizType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7BizTypeHasBillTypeQuery");
    }

    private void setLockTab() {
        int length = LOCKEDTAB.length;
        for (int i = 0; i < length; ++i) {
            this.kdtEntrys.getColumn(LOCKEDTAB[i]).getStyleAttributes().setLocked(true);
        }
    }

    private void initEntryPrecision() throws Exception {
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.editData.getCurrency(), (KDTable)this.getDetailTable(), (String[])CURRENCYPRECISIONTAB);
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.baseCurrInfo, (KDTable)this.getDetailTable(), (String[])LOCALAMOUNTPRECISIONTAB);
    }

    public static void changeTableRowColPrecisionByCurrency(CurrencyInfo[] infos, KDTable table, String[] fieldNames) {
        int num = infos.length;
        for (int i = 0; i < num; ++i) {
            int precision = infos[i] == null ? 2 : infos[i].getPrecision();
            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)table, (String[])fieldNames, (int)i);
        }
    }

    private void initEntryPrecision(int rowIndex, MaterialInfo materialInfo) throws Exception {
        if (this.prmtSaleOrgUnit.getData() != null) {
            SaleOrgUnitInfo saleOrgUnitInfo = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getData();
            MaterialSalesInfo materialSalesInfo = MaterialSalesFactory.getRemoteInstance().getSalesInfo(materialInfo.getId().toString(), saleOrgUnitInfo.getId().toString());
            if (materialSalesInfo != null && materialSalesInfo.getUnit() != null) {
                if ((MeasureUnitInfo)this.kdtEntrys.getCell(rowIndex, TB_UNIT).getValue() == null) {
                    this.kdtEntrys.getCell(rowIndex, TB_UNIT).setValue((Object)materialSalesInfo.getUnit());
                }
                MeasureUnitInfo unitInfo = (MeasureUnitInfo)this.kdtEntrys.getCell(rowIndex, TB_UNIT).getValue();
                MeasureUnitInfo assistUnitInfo = null;
                if (this.kdtEntrys.getCell(rowIndex, TB_ASSISTANTUNIT).getValue() != null) {
                    assistUnitInfo = (MeasureUnitInfo)this.kdtEntrys.getCell(rowIndex, TB_ASSISTANTUNIT).getValue();
                }
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)unitInfo, (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int)rowIndex);
                SCMClientUtils.changeTableColPrecisionByMaterial((MaterialInfo)materialInfo, (MeasureUnitInfo)assistUnitInfo, (KDTable)this.getDetailTable(), (String[])ASSISTQTYPRECISIONTAB, (int)rowIndex);
            } else {
                SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.getDetailTable(), (String[])QTYPRECISIONTAB, (int)rowIndex);
                SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.getDetailTable(), (String[])ASSISTQTYPRECISIONTAB, (int)rowIndex);
            }
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfo, (KDTable)this.kdtEntrys, (String[])PRICEPRECISIONTAB, (int)rowIndex);
        } else {
            SCMClientUtils.changeTableRowColPrecisionByMaterial((MaterialInfo)materialInfo, (KDTable)this.kdtEntrys, (String[])PRICEPRECISIONTAB, (int)rowIndex);
            SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.kdtEntrys, (String[])QTYPRECISIONTAB, (int)rowIndex);
            SCMClientUtils.changeTableColPrecisionByMaterial(null, null, (KDTable)this.getDetailTable(), (String[])ASSISTQTYPRECISIONTAB, (int)rowIndex);
        }
    }

    protected void bizUnitBox_dataChanged(DataChangeEvent e) throws Exception {
        SCMClientUtils.setMultiToMeasureUnit((KDBizPromptBox)((KDBizPromptBox)e.getSource()));
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initToolBar();
        this.initInterface();
        for (int rowIndex = 0; rowIndex < this.kdtEntrys.getRowCount3(); ++rowIndex) {
            WarehouseInfo warehouseInfo;
            if (!(this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) || !(warehouseInfo = (WarehouseInfo)this.kdtEntrys.getCell(rowIndex, TB_POSTWAREHOUSE).getValue()).isHasLocation()) continue;
            this.kdtEntrys.getCell(rowIndex, TB_LOCATION).getStyleAttributes().setLocked(false);
        }
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData)) {
            this.prmtSaleOrgUnit.setEditable(false);
            this.prmtSaleOrgUnit.setEnabled(false);
            this.prmtCurrency.setEnabled(false);
        } else {
            this.prmtSaleOrgUnit.setEnabled(true);
            this.prmtCurrency.setEnabled(true);
        }
    }

    private void initKDTEntryData() {
        this.f7Manager.registerAssistPropertyF7(this.kdtEntrys, TB_MATERIAL, TB_ASISTPROPERTY, (SCMBillEditUI)this);
        try {
            this.initEntryPrecision();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        SCMClientHelper scmClientHelper = new SCMClientHelper((SCMBillEditUI)this);
        scmClientHelper.setSalePersonDisplay(this.kdtEntrys_salePerson_PromptBox);
        scmClientHelper.initSalePersonDisplay(this.kdtEntrys_salePerson_PromptBox);
        int rowCount = this.kdtEntrys.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                DeliveryTypeInfo deliveryTypeInfo;
                MaterialInfo materialInfo;
                if (this.kdtEntrys.getRow(i).getCell(TB_MATERIAL).getValue() != null && (materialInfo = (MaterialInfo)this.kdtEntrys.getRow(i).getCell(TB_MATERIAL).getValue()).getAssistAttr() != null) {
                    this.kdtEntrys.getRow(i).getCell(TB_ASISTPROPERTY).getStyleAttributes().setLocked(false);
                }
                if (this.kdtEntrys.getRow(i).getCell(TB_ASSISTANTUNIT).getValue() != null) {
                    this.kdtEntrys.getRow(i).getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntrys.getRow(i).getCell(TB_ASSISTQTY).getStyleAttributes().setLocked(true);
                }
                if (SCMUtils.isBotpBill((SCMBillBaseInfo)this.editData)) {
                    this.kdtEntrys.getRow(i).getCell(TB_UNIT).getStyleAttributes().setLocked(true);
                } else {
                    this.kdtEntrys.getRow(i).getCell(TB_UNIT).getStyleAttributes().setLocked(false);
                }
                if (this.kdtEntrys.getRow(i).getCell(TB_POSTWAREHOUSE).getValue() instanceof WarehouseInfo) {
                    if (((WarehouseInfo)this.kdtEntrys.getRow(i).getCell(TB_POSTWAREHOUSE).getValue()).isHasLocation()) {
                        this.kdtEntrys.getRow(i).getCell(TB_LOCATION).getStyleAttributes().setLocked(false);
                    } else {
                        this.kdtEntrys.getRow(i).getCell(TB_LOCATION).getStyleAttributes().setLocked(true);
                    }
                } else {
                    this.kdtEntrys.getRow(i).getCell(TB_LOCATION).getStyleAttributes().setLocked(true);
                }
                DeliveryTypeInfo deliveryTypeInfo2 = deliveryTypeInfo = this.kdtEntrys.getRow(i).getCell(TB_DELIVERTYPE).getValue() == null ? null : (DeliveryTypeInfo)this.kdtEntrys.getRow(i).getCell(TB_DELIVERTYPE).getValue();
                if (deliveryTypeInfo != null && "CARRY".equalsIgnoreCase(deliveryTypeInfo.getNumber())) {
                    this.kdtEntrys.getRow(i).getCell(TB_DELIVERYDATE).getStyleAttributes().setLocked(true);
                    continue;
                }
                this.kdtEntrys.getRow(i).getCell(TB_DELIVERYDATE).getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void prmtstorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getData() != null) {
            SCMClientUtils.setWarehouseFitler((StorageOrgUnitInfo)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData()), (KDTable)this.kdtEntrys, (String)TB_POSTWAREHOUSE, (int)-1);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.remove(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("id"));
        sic.remove(new SelectorItemInfo("entries.material.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.coefficient"));
        sic.add(new SelectorItemInfo("entries.material.helpCode"));
        sic.remove(new SelectorItemInfo("entries.sourceBillType.*"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.name"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.number"));
        sic.remove(new SelectorItemInfo("entries.orderCustomer.*"));
        sic.add(new SelectorItemInfo("entries.orderCustomer.id"));
        sic.add(new SelectorItemInfo("entries.orderCustomer.name"));
        sic.add(new SelectorItemInfo("entries.orderCustomer.number"));
        sic.remove(new SelectorItemInfo("entries.baseUnit.*"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.remove(new SelectorItemInfo("entries.unit.*"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.remove(new SelectorItemInfo("entries.assistUnit.*"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.remove(new SelectorItemInfo("entries.saleGroup.*"));
        sic.add(new SelectorItemInfo("entries.saleGroup.id"));
        sic.add(new SelectorItemInfo("entries.saleGroup.name"));
        sic.add(new SelectorItemInfo("entries.saleGroup.number"));
        sic.remove(new SelectorItemInfo("entries.deliveryType.*"));
        sic.add(new SelectorItemInfo("entries.deliveryType.id"));
        sic.add(new SelectorItemInfo("entries.deliveryType.name"));
        sic.add(new SelectorItemInfo("entries.deliveryType.number"));
        sic.remove(new SelectorItemInfo("entries.adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.number"));
        sic.remove(new SelectorItemInfo("entries.warehouse.*"));
        sic.add(new SelectorItemInfo("entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.warehouse.name"));
        sic.add(new SelectorItemInfo("entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.hasLocation"));
        sic.remove(new SelectorItemInfo("entries.salePerson.*"));
        sic.add(new SelectorItemInfo("entries.salePerson.id"));
        sic.add(new SelectorItemInfo("entries.salePerson.name"));
        sic.add(new SelectorItemInfo("entries.salePerson.number"));
        sic.remove(new SelectorItemInfo("entries.assistProperty.*"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.remove(new SelectorItemInfo("entries.location.*"));
        sic.add(new SelectorItemInfo("entries.location.id"));
        sic.add(new SelectorItemInfo("entries.location.name"));
        sic.add(new SelectorItemInfo("entries.location.number"));
        sic.remove(new SelectorItemInfo("entries.deliveryCustomer.*"));
        sic.add(new SelectorItemInfo("entries.deliveryCustomer.id"));
        sic.add(new SelectorItemInfo("entries.deliveryCustomer.name"));
        sic.add(new SelectorItemInfo("entries.deliveryCustomer.number"));
        sic.remove(new SelectorItemInfo("entries.receiveCustomer.*"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.id"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.name"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.number"));
        sic.remove(new SelectorItemInfo("entries.paymentCustomer.*"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.id"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.name"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.number"));
        sic.remove(new SelectorItemInfo("entries.project.*"));
        sic.add(new SelectorItemInfo("entries.project.id"));
        sic.add(new SelectorItemInfo("entries.project.name"));
        sic.add(new SelectorItemInfo("entries.project.number"));
        sic.remove(new SelectorItemInfo("entries.trackNumber.*"));
        sic.add(new SelectorItemInfo("entries.trackNumber.id"));
        sic.add(new SelectorItemInfo("entries.trackNumber.name"));
        sic.add(new SelectorItemInfo("entries.trackNumber.number"));
        sic.add(new SelectorItemInfo("entries.stockTransferBill.id"));
        sic.add(new SelectorItemInfo("entries.stockTransferBillEntry.id"));
        sic.add(new SelectorItemInfo("entries.stockTransferBillNumber"));
        sic.add(new SelectorItemInfo("entries.stockTransferBillEntrySeq"));
        sic.remove(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.remove(new SelectorItemInfo("saleOrgUnit.*"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.CU"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isCU"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isBizUnit"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isSaleOrgUnit"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isAdminOrgUnit"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isPurchaseOrgUnit"));
        sic.add(new SelectorItemInfo("saleOrgUnit.isStorageOrgUnit"));
        sic.remove(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.remove(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.remove(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.remove(new SelectorItemInfo("modifier.*"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.remove(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.remove(new SelectorItemInfo("companyOrgUnit.*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency"));
        sic.remove(new SelectorItemInfo("entries.saleOrderEntry.*"));
        sic.add(new SelectorItemInfo("entries.saleOrderEntry.id"));
        sic.add(new SelectorItemInfo("entries.saleOrderEntrySeq"));
        sic.add(new SelectorItemInfo("entries.saleOrderNumber"));
        sic.add(new SelectorItemInfo("entries.saleOrder.id"));
        sic.add(new SelectorItemInfo("entries.b2cBillType"));
        sic.add(new SelectorItemInfo("entries.netOrderBillNumber"));
        sic.add(new SelectorItemInfo("entries.netOrderBillID"));
        sic.add(new SelectorItemInfo("entries.netOrderBillEntryID"));
        sic.add(new SelectorItemInfo("CU.id"));
        return sic;
    }

    @Override
    protected void prmtSaleOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getOldValue() == null || e.getNewValue() == null || e.getNewValue().equals(e.getOldValue()) || this.prmtSaleOrgUnit.getValue() != null) {
            // empty if block
        }
        this.setStatusByReverseProject(this.isReverseProject());
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.PostRequisitionPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SD/SalePostRequisition";
    }

    protected HashMap getQueryCondition() throws Exception {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        boolean isTableFocus = SCMClientUtils.isTableFocus((KDTable)this.kdtEntrys);
        hm.put("TABLEHASFOCUS", isTableFocus);
        KDTSelectBlock selectBlock = this.kdtEntrys.getSelectManager().get();
        if (selectBlock != null) {
            TrackNumberInfo trackNumberInfo;
            ProjectInfo projectInfo;
            StorageOrgUnitInfo aStorageOrgUnitInfo;
            MeasureUnitInfo aMeasureUnitInfo;
            WarehouseInfo aWarehouseInfo;
            int rowIndex = selectBlock.getTop();
            IRow row = this.kdtEntrys.getRow(rowIndex);
            if (row == null) {
                return hm;
            }
            ICell cell = row.getCell(TB_MATERIAL);
            MaterialInfo material = (MaterialInfo)cell.getValue();
            hm.put("MATERIAL", material);
            cell = row.getCell(TB_ASISTPROPERTY);
            AsstAttrValueInfo assistantAttr = (AsstAttrValueInfo)cell.getValue();
            if (assistantAttr != null && assistantAttr.getId() != null) {
                hm.put("ASSISTANTATTR", assistantAttr.getId().toString());
            }
            if ((aWarehouseInfo = (WarehouseInfo)(cell = row.getCell(TB_POSTWAREHOUSE)).getValue()) != null && aWarehouseInfo.getId() != null) {
                hm.put("WAREHOUSE", aWarehouseInfo.getId().toString());
            }
            if ((aMeasureUnitInfo = (MeasureUnitInfo)(cell = row.getCell(TB_UNIT)).getValue()) != null && aMeasureUnitInfo.getId() != null) {
                hm.put("UNIT", aMeasureUnitInfo.getId().toString());
            }
            if ((aStorageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData()) != null) {
                hm.put("STORAGEORGUNIT", aStorageOrgUnitInfo);
            }
            if ((projectInfo = (ProjectInfo)(cell = row.getCell(TB_PROJECTNAME)).getValue()) != null && projectInfo.getId() != null) {
                hm.put("PROJECT", projectInfo.getId().toString());
            }
            if ((trackNumberInfo = (TrackNumberInfo)(cell = row.getCell(TB_TRACKNUMBERNAME)).getValue()) != null && trackNumberInfo.getId() != null) {
                hm.put("TRACKNUM", trackNumberInfo.getId().toString());
            }
        }
        return hm;
    }

    protected void setLotAndAssistProperty(HashMap hmResult) {
        LocationInfo locationInfo;
        WarehouseInfo warehouseInfo;
        int selectRow = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int colAssisistProperty1 = this.getDetailTable().getColumnIndex("assistProperty");
        int colAssisistProperty2 = this.getDetailTable().getColumnIndex(TB_ASISTPROPERTY);
        int colAssisistProperty = 0;
        colAssisistProperty = colAssisistProperty1 > -1 ? colAssisistProperty1 : colAssisistProperty2;
        if (selectRow >= 0) {
            AsstAttrValueInfo asstAttrValue = (AsstAttrValueInfo)hmResult.get("asstAttrValue");
            if (asstAttrValue != null && asstAttrValue.getId() == null) {
                asstAttrValue = null;
            }
            if (asstAttrValue != null && colAssisistProperty > -1) {
                this.getDetailTable().getRow(selectRow).getCell(colAssisistProperty).setValue((Object)asstAttrValue);
            }
        }
        if (hmResult.containsKey("lot")) {
            String batch = hmResult.get("lot").toString();
            this.getDetailTable().getRow(selectRow).getCell("lot").setValue((Object)batch);
        }
        if ((warehouseInfo = (WarehouseInfo)hmResult.get("warehouse")) != null) {
            this.getDetailTable().getRow(selectRow).getCell(TB_POSTWAREHOUSE).setValue((Object)warehouseInfo);
        }
        if ((locationInfo = (LocationInfo)hmResult.get(TB_LOCATION)) != null) {
            this.getDetailTable().getRow(selectRow).getCell(TB_LOCATION).setValue((Object)locationInfo);
        }
    }

    protected void insertLine(int row) {
        if (this.kdtEntrys == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(this.kdtEntrys);
        IRow irow = null;
        irow = this.kdtEntrys.addRow(row);
        this.editData.getEntries().addObject(detailData);
        this.loadLineFields(this.kdtEntrys, irow, detailData);
        this.afterInsertLine(this.kdtEntrys, detailData);
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtSaleOrgUnit;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected void initNeedMainOrgF7s() {
        this.setBizOrgF7(this.prmtStorageOrgUnit, OrgType.Storage, null);
        this.prmtMaterial = this.getBizMaterialF7(this.kdtEntrys.getColumn(TB_MATERIAL), null);
        this.prmtCustomer = this.getBizCustomerF7(this.kdtEntrys.getColumn(TB_ORDERCUSTOMER), null);
        this.prmtDeliveryCustomer = this.getBizCustomerF7(this.kdtEntrys.getColumn(TB_DELIVERYCUSTOMER), null);
        this.prmtPaymentCustomer = this.getBizCustomerF7(this.kdtEntrys.getColumn(TB_PAYMENTCUSTOMER), null);
        this.prmtReceiveCustomer = this.getBizCustomerF7(this.kdtEntrys.getColumn(TB_RECEIVECUSTOMER), null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtStorageOrgUnit, this.prmtMaterial, this.prmtCustomer, this.prmtDeliveryCustomer, this.prmtPaymentCustomer, this.prmtReceiveCustomer});
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equalsIgnoreCase(status)) {
            return "postreq_addnew";
        }
        return null;
    }

    private void initSaleOrgUnitF7() {
        try {
            this.setMainBizOrgF7(this.prmtSaleOrgUnit, OrgType.Sale);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected String[] getSumColNames() {
        return new String[]{TB_BASEQTY, TB_QTY, TB_ASSISTQTY, TB_LOCALAMOUNT, TB_TOTAL, TB_POSTQTY, TB_TOTALREVERSEDQTY, TB_PLANDELIVERYQTY};
    }

    protected void checkUnAudit(String[] selIDs) throws BOSException, EASBizException, SCMBillException {
        if (selIDs == null) {
            this.handUIException((Throwable)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_AUDIT")})));
            return;
        }
        IPostRequisition iPostRequisition = PostRequisitionFactory.getRemoteInstance();
        int cont = selIDs.length;
        for (int i = 0; i < cont; ++i) {
            PostRequisitionInfo info = iPostRequisition.getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(selIDs[i]));
            SCMClientUtils.checkUnAuditDetail((PostRequisitionInfo)info);
        }
    }

    protected boolean checkValid() {
        return true;
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("stockTransferBillType", "transferOrderBill");
        super.actionTraceUp_actionPerformed(e);
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        super.afterMainOrgChanged(arg0, arg1);
        if (!SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1)) {
            return;
        }
        if (SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1)) {
            this.initUIData(this.getMainCompanyOrg(arg1));
            if (this.baseCurrInfo != null) {
                ObjectUuidPK sourceCurrPK = null;
                ObjectUuidPK destCurrPK = null;
                destCurrPK = new ObjectUuidPK(this.baseCurrInfo.getId());
                CurrencyInfo currencyInfo = this.prmtCurrency.getValue() == null ? this.editData.getCurrency() : (CurrencyInfo)this.prmtCurrency.getValue();
                ObjectUuidPK objectUuidPK = sourceCurrPK = currencyInfo == null ? destCurrPK : new ObjectUuidPK(currencyInfo.getId());
                if (!destCurrPK.equals((Object)sourceCurrPK)) {
                    try {
                        this.tempexrateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)this.ficompanyOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                }
                this.exchangeRate = this.isBotpBill("510b6503-0105-1000-e000-0113c0a812fd463ED552") || this.isBotpBill("Eg5BUQEVEADgAAABwKgOEEY+1VI=") ? this.editData.getExchangeRate() : (destCurrPK.equals((Object)sourceCurrPK) ? new BigDecimal("1.00") : (this.tempexrateinfo != null ? this.tempexrateinfo.getConvertRate() : new BigDecimal("1.00")));
            }
        }
    }

    private void initUIData(CompanyOrgUnitInfo companyOrgUnitInfo) {
        this.ficompanyOrgInfo = (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        this.baseCurrInfo = this.getSCMBizDataVO() != null ? this.getSCMBizDataVO().getBaseCurrInfo() : null;
        this.prmtCompanyOrgUnit.setValue((Object)this.ficompanyOrgInfo);
        if (this.getOprtState().equals("ADDNEW") && !this.isBotpBill()) {
            this.prmtCurrency.setData((Object)this.baseCurrInfo);
            this.editData.setCurrency(this.baseCurrInfo);
        }
    }

    protected int getDefaultOrgMask() {
        return 18;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        String[] strID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntrys, (String)"entryID");
        if (this.editData.getId() != null && strID != null) {
            IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            try {
                Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
                int c = strID.length;
                for (int i = 0; i < c; ++i) {
                    if (reasonCodeInfo == null || strID == null) continue;
                    if (reasonCodeInfo instanceof IObjectValue) {
                        iPostRequisitionEntry.close((IObjectPK)new ObjectStringPK(strID[i]), ((ReasonCodeInfo)reasonCodeInfo).getName());
                    }
                    if (!(reasonCodeInfo instanceof String)) continue;
                    iPostRequisitionEntry.close((IObjectPK)new ObjectStringPK(strID[i]), (String)reasonCodeInfo);
                }
                this.setMessageText(SaleUtil.getBizResource("CLOSESUCCESS"));
                this.refreshInterface();
            }
            catch (EASBizException er) {
                super.handUIException((Throwable)er);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        } else if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionSelectEntry"));
        }
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        String[] strID = KDTableUtil.getSelectRowFieldValue((KDTable)this.kdtEntrys, (String)"entryID");
        if (this.editData.getId() != null && strID != null) {
            IPostRequisitionEntry iPostRequisitionEntry = PostRequisitionEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            try {
                int c = strID.length;
                for (int i = 0; i < c; ++i) {
                    iPostRequisitionEntry.unClose((IObjectPK)new ObjectStringPK(strID[i]));
                }
                this.setMessageText(SaleUtil.getBizResource("UNCLOSESUCCESS"));
                this.refreshInterface();
            }
            catch (EASBizException er) {
                super.handUIException((Throwable)er);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        } else if (this.editData.getId() == null) {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionFirstSave"));
        } else {
            MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionSelectEntry"));
        }
    }

    protected boolean isSplitLine() {
        return true;
    }

    @Override
    public void actionSplitLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null) {
            return;
        }
        super.actionSplitLine_actionPerformed(e);
        this.setQtyPrecision();
    }

    protected List getSplitLineData(SCMBillEntryBaseInfo entryInfo, int splitNum, int splitType) {
        if (splitType == 1) {
            return this._getCopyLineData(entryInfo, splitNum);
        }
        ArrayList<PostRequisitionEntryAgent> entryList = new ArrayList<PostRequisitionEntryAgent>();
        PostRequisitionEntryAgent aEntryInfo = null;
        for (int i = 1; i < splitNum; ++i) {
            aEntryInfo = PostRequisitionEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
            aEntryInfo.put("reservationId", null);
            aEntryInfo.setId(BOSUuid.create((String)"CCFD4923"));
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    private List _getCopyLineData(SCMBillEntryBaseInfo entryInfo, int splitNum) {
        ArrayList<PostRequisitionEntryInfo> entryList = new ArrayList<PostRequisitionEntryInfo>();
        PostRequisitionEntryInfo aEntryInfo = null;
        for (int i = 0; i < splitNum - 1; ++i) {
            aEntryInfo = this.getCopiedEntryInfo((PostRequisitionEntryInfo)entryInfo, false);
            entryList.add(aEntryInfo);
        }
        return entryList;
    }

    protected PostRequisitionEntryCollection getSplitLineData(PostRequisitionEntryInfo entryInfo) {
        PostRequisitionEntryCollection collection;
        block6: {
            collection = new PostRequisitionEntryCollection();
            boolean canBeSplited = true;
            int c = this.kdtEntrys.getRowCount();
            for (int i = 0; i < c; ++i) {
                PostRequisitionEntryInfo tmp = (PostRequisitionEntryInfo)this.kdtEntrys.getRow(i).getUserObject();
                if (tmp.getId() == null || tmp.getId().equals((Object)entryInfo.getId()) || !tmp.getSourceBillEntryId().equals(entryInfo.getSourceBillEntryId())) continue;
                canBeSplited = false;
                break;
            }
            if ((this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) && this.isBotpBill("510b6503-0105-1000-e000-0113c0a812fd463ED552") && canBeSplited) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryInfo.getSaleOrderEntry().getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
                try {
                    ILockInventory ili = LockInventoryFactory.getRemoteInstance();
                    LockInventoryCollection lic = ili.getLockInventoryCollection(evi);
                    SelectorItemCollection invSelector = new SelectorItemCollection();
                    invSelector.add(new SelectorItemInfo("*"));
                    invSelector.add(new SelectorItemInfo("unit.*"));
                    if (lic.size() > 0) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"ENTRYHASLOCKINV");
                        MsgBox.showInfo((String)msg);
                        SysUtil.abort();
                        break block6;
                    }
                    PostRequisitionEntryInfo aEntryInfo = this.getCopiedEntryInfo(entryInfo, true);
                    collection.clear();
                    collection.add(entryInfo);
                    collection.add(aEntryInfo);
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            } else {
                PostRequisitionEntryInfo aEntryInfo = this.getCopiedEntryInfo(entryInfo, true);
                collection.clear();
                collection.add(entryInfo);
                collection.add(aEntryInfo);
            }
        }
        return collection;
    }

    private PostRequisitionEntryInfo getCopiedEntryInfo(PostRequisitionEntryInfo entryInfo, boolean needCleanQty) {
        PostRequisitionEntryAgent aEntryInfo = PostRequisitionEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
        aEntryInfo.setId(BOSUuid.create((String)"CCFD4923"));
        if (needCleanQty) {
            aEntryInfo.setQty(defaultNum);
            aEntryInfo.setAssistQty(defaultNum);
            aEntryInfo.setBaseQty(defaultNum);
            aEntryInfo.setAmount(defaultNum);
            aEntryInfo.setLocalAmount(defaultNum);
        }
        aEntryInfo.setLot(entryInfo.getLot());
        aEntryInfo.setStockTransferBill(entryInfo.getStockTransferBill());
        aEntryInfo.setStockTransferBillEntry(entryInfo.getStockTransferBillEntry());
        aEntryInfo.setStockTransferBillEntrySeq(entryInfo.getStockTransferBillEntrySeq());
        aEntryInfo.setStockTransferBillNumber(entryInfo.getStockTransferBillNumber());
        return aEntryInfo;
    }

    protected void processTargetBillArray(String[] targetBillBosTypeArray, String[] targetBillAliasArray) {
        boolean isStart;
        super.processTargetBillArray(targetBillBosTypeArray, targetBillAliasArray);
        ICustomizedScheme ics = null;
        CustomizedSchemeInfo csInfo = null;
        try {
            ics = CustomizedSchemeFactory.getRemoteInstance();
            csInfo = ics.getCustomizedSchemeInfo("where name = 'WeightedSoulution'");
        }
        catch (ObjectNotFoundException exc) {
            logger.error((Object)exc);
            csInfo = null;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        boolean bl = isStart = csInfo != null ? csInfo.isStart() : false;
        if (targetBillBosTypeArray == null || targetBillAliasArray == null) {
            return;
        }
        for (int i = 0; i < targetBillBosTypeArray.length; ++i) {
            if ("8B07BBDB".equals(targetBillBosTypeArray[i])) {
                targetBillBosTypeArray[i] = null;
                targetBillAliasArray[i] = null;
            }
            if (!"B2ABD4E9".equals(targetBillBosTypeArray[i]) || isStart) continue;
            targetBillBosTypeArray[i] = null;
            targetBillAliasArray[i] = null;
        }
    }

    public BOTRelationCollection getMakeRelations() {
        if (this.editData.isIsReverse()) {
            return null;
        }
        return super.getMakeRelations();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void prepareInit(RequestContext request) {
        super.prepareInit(request);
        SaleOrderDataVO vo = new SaleOrderDataVO();
        vo.setIsLoadingMaterialInventory(true);
        request.put("__SCMENTRYDATA", (Object)vo);
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, PostRequisitionFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, PostRequisitionEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, this.kdtEntrys, "entryID", this.txtNumber, null);
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"close");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnClose, (String)"unClose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnClose");
        actionProxy.bindTo((AbstractButton)this.btnUnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemUnClose);
        super.initBatchActions();
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        boolean result = super.beforeAction(bizAction, selectionEntries, event);
        if (BatchActionEnum.SUBMIT.equals((Object)bizAction)) {
            try {
                if (!this.checkSubmit()) {
                    return false;
                }
                CreditCheck.checkPostbillAtSubmit((PostRequisitionEditUI)this);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
                return false;
            }
            if (this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
                if (!this.cbIsReverse.isSelected()) {
                    if (this.checkBusinessRule() != 0) {
                        SysUtil.abort();
                        return false;
                    }
                } else {
                    int rowCount = this.getDetailTable().getRowCount();
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        IRow arow = this.getDetailTable().getRow(rowIndex);
                        BigDecimal qty = (BigDecimal)arow.getCell(TB_QTY).getValue();
                        if (SCMUtils.effectualNumeric((BigDecimal)qty).compareTo(SysConstant.BIGZERO) > 0) continue;
                        this.handUIException((Throwable)new SCMBillException(SCMBillException.REVERSE_QTY_MUST_BIG_THAN_ZERO, (Object[])new String[]{String.valueOf(rowIndex + 1)}));
                        SysUtil.abort();
                        return false;
                    }
                }
            } else {
                MsgBox.showInfo((String)SaleUtil.getBizResource("PostRequisitionNotSubmit"));
                return false;
            }
            this.setStatus();
        } else if (BatchActionEnum.UNAUDIT.equals((Object)bizAction)) {
            this.setOprtState(OprtState.VIEW);
        } else if (BatchActionEnum.AUDIT.equals((Object)bizAction)) {
            try {
                CreditCheck.checkPostbillAtAudit((PostRequisitionEditUI)this);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
                return false;
            }
        }
        return result;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        IObjectValue v = super.getValue(pk);
        if (v == null) {
            throw new ObjectNotFoundException();
        }
        return v;
    }

    protected void storeSendAddress() {
        int MAXLENGTH = 255;
        PostRequisitionEntryInfo soEntryInfo = null;
        Object addressObjectValue = null;
        String address = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            soEntryInfo = (PostRequisitionEntryInfo)this.kdtEntrys.getRow(i).getUserObject();
            if (soEntryInfo == null) continue;
            addressObjectValue = this.kdtEntrys.getRow(i).getCell(TB_ADDRESS).getValue();
            address = addressObjectValue instanceof String ? (String)addressObjectValue : (addressObjectValue instanceof CustomerDeliveryAddressInfo ? ((CustomerDeliveryAddressInfo)addressObjectValue).getAddress() : null);
            if (address != null && address.length() > MAXLENGTH) {
                address = address.substring(0, MAXLENGTH);
            }
            this.kdtEntrys.getRow(i).getCell(TB_ADDRESS).setValue((Object)address);
            soEntryInfo.setDeliveryAddress(address);
        }
    }

    private void setDefaultWarehouse(int rowIdx, MaterialInfo[] materialInfos) throws Exception {
        WarehouseInfo warehs = null;
        StorageOrgUnitInfo sou = null;
        MaterialInfo materialInfo = null;
        int n = materialInfos.length;
        for (int i = 0; i < n; ++i) {
            if (materialInfos[i] == null) continue;
            int currentRow = rowIdx + i;
            materialInfo = materialInfos[i];
            sou = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData();
            if (sou == null) continue;
            warehs = this.fetchData.getDefaultWarehouse(materialInfo.getId().toString(), sou.getId().toString());
            this.kdtEntrys.getRow(currentRow).getCell(TB_POSTWAREHOUSE).setValue((Object)warehs);
        }
    }

    protected void doMaterialChanged(KDBizPromptBox bizMaterialBox, MaterialInfo[] materialInfos, int selectedRow, String materialFieldname) throws Exception {
        super.doMaterialChanged(bizMaterialBox, materialInfos, selectedRow, materialFieldname);
        this.setDefaultWarehouse(selectedRow, materialInfos);
    }

    protected void afterSplitLine(SCMBillEntryBaseInfo entryBaseInfo, KDTable detailTable, List rowIndexList) {
        IRow row = null;
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumLocalAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmount = BigDecimal.ZERO;
        BigDecimal rowAmount = null;
        int size = rowIndexList.size() - 1;
        for (int i = 0; i < size; ++i) {
            row = detailTable.getRow(((Integer)rowIndexList.get(i)).intValue());
            rowAmount = (BigDecimal)row.getCell(TB_TOTAL).getValue();
            if (rowAmount == null) {
                rowAmount = BigDecimal.ZERO;
            }
            sumAmount = sumAmount.add(rowAmount);
            rowAmount = (BigDecimal)row.getCell(TB_LOCALAMOUNT).getValue();
            if (rowAmount == null) {
                rowAmount = BigDecimal.ZERO;
            }
            sumLocalAmount = sumLocalAmount.add(rowAmount);
        }
        int last = (Integer)rowIndexList.get(size);
        if (((PostRequisitionEntryInfo)entryBaseInfo).getAmount() != null) {
            amount = ((PostRequisitionEntryInfo)entryBaseInfo).getAmount();
        }
        if (((PostRequisitionEntryInfo)entryBaseInfo).getLocalAmount() != null) {
            localAmount = ((PostRequisitionEntryInfo)entryBaseInfo).getLocalAmount();
        }
        amount = amount.subtract(sumAmount);
        localAmount = localAmount.subtract(sumLocalAmount);
        this.getDetailTable().getRow(last).getCell(TB_TOTAL).setValue((Object)amount);
        this.getDetailTable().getRow(last).getCell(TB_LOCALAMOUNT).setValue((Object)localAmount);
    }

    protected SCMBillEntryBaseInfo getCloneEntryBaseInfo(SCMBillEntryBaseInfo info) {
        return PostRequisitionEntryAgent.copyOvAsNewAgent((IObjectValue)info);
    }
}

