/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.sale.IPricePolicyAdjust;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustFactory;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractPricePolicyAdjustListUI;
import com.kingdee.eas.scm.sd.sale.client.PricePolicyAdjustEditUI;
import com.kingdee.eas.scm.sd.sale.client.PricePolicyAdjustQueryUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PricePolicyAdjustListUI
extends AbstractPricePolicyAdjustListUI {
    private static final Logger logger = CoreUIObject.getLogger(PricePolicyAdjustListUI.class);
    protected PricePolicyAdjustQueryUI queryUI = null;
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    protected int numericPrecision = 4;
    private static final String[] NUMERICCOLUMNS = new String[]{"change"};
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RESOURCE = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";
    private static final String RESOURCE_PPA = "com.kingdee.eas.scm.sd.sale.PricePolicyAdjustResource";

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList sids = this.getSelectedIdValues();
        if (sids != null) {
            int size = sids.size();
            for (int i = 0; i < size; ++i) {
                String id = (String)sids.get(i);
                try {
                    if (id != null) {
                        this.pubFireVOChangeListener(id);
                    }
                }
                catch (Throwable e1) {
                    super.handUIException(e1);
                    return;
                }
                if (((IPricePolicyAdjust)this.getBizInterface()).isCanDelete((String)sids.get(i))) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PPA, (String)"cannt_modify_after_audit"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void setDefaultEntityViewInfo(EntityViewInfo entryViewInfo) {
        super.setDefaultEntityViewInfo(entryViewInfo);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.actionRemove_actionPerformed1(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        int size = 0;
        int start = 0;
        int end = 0;
        size = this.tblMain.getSelectManager().size();
        if (size > 1 || size == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PPA, (String)"only_one_record"));
            return;
        }
        boolean editable = true;
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(boID);
        info.setCode("");
        info.setListener(this.createAttatchListener("HEAD"));
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
            if (sb == null || sb.getMode() != 2) continue;
            start = sb.getTop();
            if (start != (end = sb.getBottom())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PPA, (String)"only_one_record"));
                return;
            }
            for (int j = start; j <= end; ++j) {
                int status;
                if (this.tblMain.getRow(j).getCell("checkedStatus") == null || this.tblMain.getRow(j).getCell("checkedStatus").getValue() == null || 4 != (status = ((BizEnumValueDTO)this.tblMain.getRow(j).getCell("checkedStatus").getValue()).getInt())) continue;
                editable = false;
            }
        }
        info.setEdit(editable);
        acm.showAttachmentListUIByBoID((Object)this, info);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PricePolicyAdjustFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PricePolicyAdjustEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initActionState();
        this.setDateExportFormat();
        this.handleFiledsPrecision();
    }

    private void handleFiledsPrecision() throws Exception {
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getNumericColumns(), (String)SCMClientUtils.getFormatPattern((int)this.numericPrecision, (boolean)false));
    }

    protected String[] getNumericColumns() throws Exception {
        return NUMERICCOLUMNS;
    }

    protected void setDateExportFormat() {
        String[] fields = this.getFormattedDateColumns();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (this.tblMain.getColumn(fields[i]) == null) continue;
                this.tblMain.getColumn(fields[i]).getStyleAttributes().setNumberFormat(SCMClientUtils.getDateFormatString());
            }
        }
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"effectiveDate", "expireDate", "createTime", "auditDate", "lastUpdateTime"};
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    private void initActionState() {
        this.actionAudit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.btnAudit.setText(EASResource.getString((String)RESOURCE, (String)"audit"));
        this.btnAudit.setToolTipText(EASResource.getString((String)RESOURCE, (String)"auditTooltip"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setToolTipText(EASResource.getString((String)RESOURCE, (String)"unAuditTooltip"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAuditResult.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.actionSubmit.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed1(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(this.getSelectedKeyValue());
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            try {
                ArrayList aids = this.getSelectedIdValues();
                String[] IDs = aids.toArray(new String[0]);
                ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
                int n = pks.length;
                for (int i = 0; i < n; ++i) {
                    String id = IDs[i];
                    try {
                        if (id != null) {
                            this.pubFireVOChangeListener(id);
                        }
                    }
                    catch (Throwable e1) {
                        super.handUIException(e1);
                        try {
                            this.pubFireVOChangeListener(this.getSelectedKeyValue());
                        }
                        catch (Throwable e12) {
                            logger.error((Object)e12);
                        }
                        return;
                    }
                    pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
                }
                ((IPricePolicyAdjust)this.getBizInterface()).delete((IObjectPK[])pks);
                this.pubFireVOChangeListener(this.getSelectedKeyValue());
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)onfe);
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            catch (Throwable e1) {
                logger.error((Object)e1);
                this.handUIException(e1);
                this.abort();
            }
            finally {
                try {
                    this.pubFireVOChangeListener(this.getSelectedKeyValue());
                }
                catch (Throwable e1) {
                    logger.error((Object)e1);
                }
            }
            this.refresh(e);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditAlert"));
        if (!MsgBox.isYes((int)isYes)) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            String id = IDs[i];
            try {
                if (id != null) {
                    this.pubFireVOChangeListener(id);
                }
            }
            catch (Throwable e1) {
                super.handUIException(e1);
                return;
            }
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        if (SCMClientUtils.checkAllBizObjInWfProcess((String[])IDs)) {
            this.actionMultiapprove_actionPerformed(null);
            this.execQuery();
            return;
        }
        ((IPricePolicyAdjust)this.getBizInterface()).audit((IObjectPK[])pks);
        PricePolicyCache.clearCache();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditAlert"));
        if (!MsgBox.isYes((int)isYes)) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        ((IPricePolicyAdjust)this.getBizInterface()).unAudit((IObjectPK[])pks);
        PricePolicyCache.clearCache();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditSuccess"));
        this.refreshList();
    }

    protected CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.queryUI == null) {
            this.queryUI = new PricePolicyAdjustQueryUI();
        }
        this.queryUI.onLoad();
        return this.queryUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog commonQueryDialog = super.initCommonQueryDialog();
        try {
            if (this.queryUI == null) {
                this.queryUI = new PricePolicyAdjustQueryUI();
            }
            commonQueryDialog.addUserPanel((KDPanel)this.queryUI);
            commonQueryDialog.setTitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"Query_Filter"), this.getUITitle()));
            commonQueryDialog.setShowSorter(true);
            commonQueryDialog.setShowFilter(true);
            commonQueryDialog.setWidth(578);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return commonQueryDialog;
    }

    protected boolean initDefaultFilter() {
        HashSet numberSet = (HashSet)this.getUIContext().get("adjustNumberMap");
        return numberSet == null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        HashSet numberSet = (HashSet)this.getUIContext().get("adjustNumberMap");
        if (numberSet != null && numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
            return filter;
        }
        if (this.queryUI != null) {
            Set set;
            String end;
            String begin;
            String id;
            Map map = this.queryUI.getParamMap();
            if (map.get("Saleorg") != null) {
                id = map.get("Saleorg").toString();
                filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)id, CompareType.EQUALS));
            } else {
                ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
                try {
                    FullOrgUnitCollection mainOrgs = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Sale, (IObjectPK)treePK, "PricePolicyAdjust_view");
                    StringBuffer ids = new StringBuffer();
                    int length = mainOrgs.size();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            ids.append(",");
                        }
                        ids.append(mainOrgs.get(i).getId().toString());
                    }
                    filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)ids.toString(), CompareType.INCLUDE));
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
            if (map.get("PricePolicy") != null) {
                id = map.get("PricePolicy").toString();
                filter.getFilterItems().add(new FilterItemInfo("pricePolicy.id", (Object)id, CompareType.EQUALS));
            }
            if (map.get("BaseStatus") != null) {
                id = map.get("BaseStatus").toString();
                filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)id, CompareType.EQUALS));
            }
            if (map.get("Priority") != null) {
                id = map.get("Priority").toString();
                filter.getFilterItems().add(new FilterItemInfo("priority", (Object)id, CompareType.EQUALS));
            }
            if (map.get("NumberBegin") != null && map.get("NumberEnd") != null) {
                begin = map.get("NumberBegin").toString();
                end = map.get("NumberEnd").toString();
                try {
                    set = ((IPricePolicyAdjust)this.getBizInterface()).getIdSetByNumber(begin, end);
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            if (map.get("AuditPersonBegin") != null && map.get("AuditPersonEnd") != null) {
                begin = map.get("AuditPersonBegin").toString();
                end = map.get("AuditPersonEnd").toString();
                try {
                    set = ((IPricePolicyAdjust)this.getBizInterface()).getIdSetByPerson(begin, end);
                    filter.getFilterItems().add(new FilterItemInfo("auditor.id", (Object)set, CompareType.INCLUDE));
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            if (map.get("CreatePersonBegin") != null && map.get("CreatePersonEnd") != null) {
                begin = map.get("CreatePersonBegin").toString();
                end = map.get("CreatePersonEnd").toString();
                try {
                    set = ((IPricePolicyAdjust)this.getBizInterface()).getIdSetByPerson(begin, end);
                    filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)set, CompareType.INCLUDE));
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            if (map.get("PriceCom") != null) {
                id = map.get("PriceCom").toString();
                filter.getFilterItems().add(new FilterItemInfo("priceComposition", (Object)id, CompareType.EQUALS));
            }
            try {
                if (map.get("CreateBegin") != null) {
                    Date createDateFrom = this.sdf.parse(map.get("CreateBegin").toString());
                    filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)this.getFilterDate(createDateFrom, KEY_STARTDATE), CompareType.GREATER_EQUALS));
                }
                if (map.get("CreateEnd") != null) {
                    Date createDateTo = this.sdf.parse(map.get("CreateEnd").toString());
                    filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)this.getFilterDate(createDateTo, KEY_ENDDATE), CompareType.LESS_EQUALS));
                }
                if (map.get("AuditBegin") != null) {
                    Date auditDateFrom = this.sdf.parse(map.get("AuditBegin").toString());
                    filter.getFilterItems().add(new FilterItemInfo("auditDate", (Object)this.getFilterDate(auditDateFrom, KEY_STARTDATE), CompareType.GREATER_EQUALS));
                }
                if (map.get("AuditEnd") != null) {
                    Date auditDateTo = this.sdf.parse(map.get("AuditEnd").toString());
                    filter.getFilterItems().add(new FilterItemInfo("auditDate", (Object)this.getFilterDate(auditDateTo, KEY_ENDDATE), CompareType.LESS_EQUALS));
                }
            }
            catch (ParseException e) {
                logger.error((Object)e);
            }
        }
        filter.setMaskString("");
        return filter;
    }

    public String getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return DateTimeUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        for (int i = 0; i < pks.length; ++i) {
            String id = IDs[i];
            try {
                if (id != null) {
                    this.pubFireVOChangeListener(id);
                }
            }
            catch (Throwable e1) {
                super.handUIException(e1);
                return;
            }
            PricePolicyAdjustInfo info = PricePolicyAdjustFactory.getRemoteInstance().getPricePolicyAdjustInfo((IObjectPK)new ObjectStringPK(id));
            if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
                ((IPricePolicyAdjust)this.getBizInterface()).submit((CoreBaseInfo)info);
                continue;
            }
            MsgBox.showError((String)EASResource.getString((String)RESOURCE_PPA, (String)"cannt_submit_but_save"));
            SysUtil.abort();
        }
        this.refreshList();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.logPrint();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.logPrint();
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)RESOURCE_PPA, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new PricePolicyAdjustInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }
}

