/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.IPromotionStrategyDetail;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyDetailCollection;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyDetailFactory;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyDetailInfo;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyEnum;
import com.kingdee.eas.scm.sd.sale.PromotionStrategyInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractPromotionStrategyDetailEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class PromotionStrategyDetailEditUI
extends AbstractPromotionStrategyDetailEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(PromotionStrategyDetailEditUI.class);
    public static final String SOUID = "souID";
    public static final String SOUNUM = "souNum";
    public static final String SOUNAME = "souName";
    public static final String PSID = "psID";
    public static final String PSNUM = "psNum";
    public static final String PSNAME = "psName";
    public static final String ID = "id";
    public static final String CONTROLVALUE = "controlValue";
    public static final String LASTUPDATER = "lastupdater";
    public static final String LASTUPDATERNAME = "lastupdaterName";
    public static final String LASTUPDATETIME = "lastupdateTime";
    private boolean isViewOperate = false;

    public PromotionStrategyDetailEditUI() throws Exception {
        this.registListener();
    }

    private void registListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    PromotionStrategyDetailEditUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    logger.info((Object)exc);
                    PromotionStrategyDetailEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void tblMain_tableSelectChanged(KDTSelectEvent e) {
        if (this.isViewOperate) {
            return;
        }
        KDTSelectBlock selectBlock = e.getSelectBlock();
        if (selectBlock.getTop() == selectBlock.getBottom()) {
            return;
        }
        if (selectBlock.getBeginCol() != this.tblMain.getColumnIndex(CONTROLVALUE)) {
            return;
        }
        IRow iRow = null;
        Object value = null;
        int length = selectBlock.getBottom();
        for (int j = selectBlock.getTop(); j <= length; ++j) {
            int selectBeginCol;
            iRow = this.tblMain.getRow(j);
            if (iRow == null) continue;
            if (j == selectBlock.getTop()) {
                value = iRow.getCell(CONTROLVALUE).getValue();
            }
            if (iRow.getCell(selectBeginCol = selectBlock.getBeginCol()).getStyleAttributes().isLocked()) continue;
            iRow.getCell(CONTROLVALUE).setValue(value);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.defaultValueProcess();
        this.btnSave.setEnabled(true);
        this.prmtCU.setEnabled(false);
    }

    private void defaultValueProcess() throws EASBizException, BOSException {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        this.prmtCU.setValue((Object)cu);
    }

    public void onShow() throws Exception {
        Object[] obj;
        super.onShow();
        Map context = this.getUIContext();
        String id = (String)context.get(ID);
        String number = (String)context.get("number");
        String name = (String)context.get("name");
        String operateStatus = (String)context.get("operateStatus");
        if (!StringUtil.isEmpty((String)operateStatus)) {
            this.lockUIComponent();
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.actionExitCurrent.setEnabled(true);
            this.isViewOperate = true;
        } else {
            this.btnEdit.setEnabled(false);
            this.isViewOperate = false;
        }
        this.txtStrategyNumber.setText(number);
        this.kDLblStrategyName.setText(name);
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        String longNumber = cu.getLongNumber() + "%";
        KDComboBox discountTypeBox = new KDComboBox();
        if (number.equals("PS01")) {
            obj = new Object[]{PromotionStrategyEnum.PS01_FALSE, PromotionStrategyEnum.PS01_TRUE};
            discountTypeBox.addItems(obj);
        } else if (number.equals("PS02")) {
            obj = new Object[]{PromotionStrategyEnum.PS02_FALSE, PromotionStrategyEnum.PS02_HALSAUTOMATCH, PromotionStrategyEnum.PS02_AUTOMATCH};
            discountTypeBox.addItems(obj);
        }
        this.tblMain.getColumn(CONTROLVALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)discountTypeBox));
        SCMClientUtils.setNecessColorInTable((KDTable)this.getDetailTable(), (String)CONTROLVALUE);
        String[] colNames = new String[]{SOUNUM, SOUNAME, LASTUPDATERNAME, LASTUPDATETIME};
        SCMClientUtils.lockColumns((KDTable)this.getDetailTable(), (String[])colNames, (boolean)true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.LIKE));
        view.setFilter(filter);
        TreeBaseCollection treeBaseCollection = SaleOrgUnitFactory.getRemoteInstance().getTreeBaseCollection(view);
        HashSet<String> psdIDSet = new HashSet<String>();
        for (int i = 0; i < treeBaseCollection.size(); ++i) {
            TreeBaseInfo info = treeBaseCollection.get(i);
            psdIDSet.add(info.getId().toString());
        }
        IPromotionStrategyDetail ipsd = PromotionStrategyDetailFactory.getRemoteInstance();
        view.getFilter().getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", psdIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("promotionStrategy.id", (Object)id, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        view.setSelector(sic);
        PromotionStrategyDetailCollection psdColl = ipsd.getPromotionStrategyDetailCollection(view);
        HashMap<String, PromotionStrategyDetailInfo> psdMap = new HashMap<String, PromotionStrategyDetailInfo>();
        String key = "";
        for (int i = 0; i < psdColl.size(); ++i) {
            PromotionStrategyDetailInfo psdInfo = psdColl.get(i);
            key = psdInfo.getSaleOrgUnit().getId().toString() + psdInfo.getPromotionStrategy().getId().toString();
            psdMap.put(key, psdInfo);
        }
        key = "";
        String value = null;
        for (int i = 0; i < treeBaseCollection.size(); ++i) {
            TreeBaseInfo info = treeBaseCollection.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell(SOUID).setValue((Object)info.getId());
            row.getCell(SOUNUM).setValue((Object)info.getNumber());
            row.getCell(SOUNAME).setValue((Object)info.getName());
            row.getCell(PSID).setValue((Object)id);
            key = info.getId().toString() + id;
            if (psdMap.containsKey(key)) {
                psdMap.get(key);
                PromotionStrategyDetailInfo psdInfo = (PromotionStrategyDetailInfo)psdMap.get(key);
                value = psdInfo.getControlValue() == null || StringUtil.isEmpty((String)psdInfo.getControlValue().getValue()) ? "0" : psdInfo.getControlValue().getValue();
                row.getCell(ID).setValue((Object)psdInfo.getId());
                this.setControlValue(row, number, Integer.parseInt(value));
                row.getCell(LASTUPDATER).setValue((Object)psdInfo.getLastUpdateUser().getId());
                row.getCell(LASTUPDATERNAME).setValue((Object)psdInfo.getLastUpdateUser().getName());
                row.getCell(LASTUPDATETIME).setValue((Object)psdInfo.getLastUpdateTime());
                continue;
            }
            if (number.equals("PS01")) {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS01_FALSE);
            } else if (number.equals("PS02")) {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS02_FALSE);
            }
            row.getCell(LASTUPDATER).setValue(null);
            row.getCell(LASTUPDATERNAME).setValue(null);
            row.getCell(LASTUPDATETIME).setValue(null);
        }
    }

    private void setControlValue(IRow row, String number, int value) {
        if (number.equals("PS01")) {
            if (value == 1) {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS01_TRUE);
            } else {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS01_FALSE);
            }
        } else if (number.equals("PS02")) {
            if (value == 1) {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS02_HALSAUTOMATCH);
            } else if (value == 2) {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS02_AUTOMATCH);
            } else {
                row.getCell(CONTROLVALUE).setValue((Object)PromotionStrategyEnum.PS02_FALSE);
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.getDetailTable().getRowCount();
        CoreBaseCollection cbc4update = new CoreBaseCollection();
        CoreBaseCollection cbc4add = new CoreBaseCollection();
        Timestamp date = SCMClientUtils.getServerDate();
        PromotionStrategyInfo psInfo = new PromotionStrategyInfo();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.getDetailTable().getRow(i);
            String souid = row.getCell(SOUID).getValue() != null ? row.getCell(SOUID).getValue().toString() : null;
            String psid = row.getCell(PSID).getValue().toString();
            if (i == 0) {
                psInfo.setId(BOSUuid.read((String)psid));
            }
            String id = row.getCell(ID).getValue() != null ? row.getCell(ID).getValue().toString() : null;
            PromotionStrategyEnum controlvalue = (PromotionStrategyEnum)((Object)row.getCell(CONTROLVALUE).getValue());
            String lastupdateid = row.getCell(LASTUPDATER).getValue() != null ? row.getCell(LASTUPDATER).getValue().toString() : null;
            PromotionStrategyDetailInfo psd = new PromotionStrategyDetailInfo();
            SaleOrgUnitInfo sou = new SaleOrgUnitInfo();
            sou.setId(BOSUuid.read((String)souid));
            psd.setSaleOrgUnit(sou);
            psd.setPromotionStrategy(psInfo);
            psd.setLastUpdateTime(date);
            psd.setControlValue(controlvalue);
            if (lastupdateid != null) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)lastupdateid));
                psd.setLastUpdateUser(user);
            } else {
                psd.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
            }
            if (id != null) {
                psd.setId(BOSUuid.read((String)id));
                cbc4update.add((CoreBaseInfo)psd);
                continue;
            }
            cbc4add.add((CoreBaseInfo)psd);
        }
        IPromotionStrategyDetail ipsd = PromotionStrategyDetailFactory.getRemoteInstance();
        if (!cbc4update.isEmpty()) {
            ipsd.update(cbc4update);
        }
        if (!cbc4add.isEmpty()) {
            ipsd.addnew(cbc4add);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleBizResource", (String)"SaveSuccess"));
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.unLockUIAndAction();
        this.btnEdit.setEnabled(false);
        this.btnSave.setEnabled(true);
        this.isViewOperate = false;
    }
}

