/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.IQuotation;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.QuotationEntryFactory;
import com.kingdee.eas.scm.sd.sale.QuotationFactory;
import com.kingdee.eas.scm.sd.sale.QuotationInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractQuotationListUI;
import com.kingdee.eas.scm.sd.sale.client.QuotationEditUI;
import com.kingdee.eas.scm.sd.sale.client.QuotationQueryUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class QuotationListUI
extends AbstractQuotationListUI {
    private static final Logger logger = CoreUIObject.getLogger(QuotationListUI.class);
    QuotationQueryUI conditionPanel = null;
    private static final String TB_ENTBASEQTYFROM = "entries.baseQtyFrom";
    private static final String TB_ENTBASEQTYTO = "entries.baseQtyTo";
    private static final String TB_ENTQTYFROM = "entries.qtyFrom";
    private static final String TB_ENTQTYTO = "entries.qtyTo";
    private static final String TB_ENTPRICE = "entries.price";
    private static final String TB_ENTDISCOUNT = "entries.discount";
    private static final String TB_ENTTAXRATE = "entries.taxRate";
    private static final String TB_ENTTAXPRICE = "entries.taxPrice";
    private static final String TB_ENTACTUALTAXPRICE = "entries.actualTaxPrice";
    private static final String RESOURCE = "com.kingdee.eas.scm.sd.sale.QuotationResource";
    private static String[] NUMBERTAB = new String[]{"exchangeRate", "entries.baseQtyFrom", "entries.baseQtyTo", "entries.qtyFrom", "entries.qtyTo", "entries.price", "entries.discount", "entries.taxRate", "entries.taxRate", "entries.taxPrice", "entries.actualTaxPrice"};
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog != null) {
            this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
            this.commonQueryDialog.setWidth(576);
            this.commonQueryDialog.setHeight(350);
            return this.commonQueryDialog;
        }
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
        this.commonQueryDialog.setWidth(576);
        this.commonQueryDialog.setHeight(350);
        return this.commonQueryDialog;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return QuotationFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnIcon();
        this.setMainTableAlign();
        this.btnAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemAudit.setVisible(true);
        this.btnAudit.setVisible(true);
        this.btnAudit.setEnabled(true);
        this.actionSubmit.setVisible(true);
        this.actionSubmit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        this.setMainTableFreeze();
        this.btnVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
        this.btnCopyTo.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modificationTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"bizDate", "disibleDate", "disibleDate", "createTime", "enableDate", "modificationTime", "auditTime"};
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, 4);
    }

    @Override
    protected String getEditUIName() {
        return QuotationEditUI.class.getName();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "baseStatus", "bizDate", "cusPurNumber", "orderCustomer.name", "deliveryType.name", "currency.name", "exchangeRate", "enableDate", "disibleDate", "saleOrgUnit.name", "saleGroup.name", "salePerson.name", "description", "creator.name", "createTime", "auditor.name", "auditTime", "modifier.name", "modificationTime", "processNode", "version"};
        return columns;
    }

    public String[] getVisibleFields() {
        return new String[]{"number", "bizDate", "orderCustomer.name", "deliveryType.name", "saleOrgUnit.name", "baseStatus", "entries.seq", "material.number", "material.name", "material.model", "unit.name", TB_ENTQTYFROM, TB_ENTQTYTO, TB_ENTPRICE, TB_ENTTAXRATE, TB_ENTTAXPRICE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = super.getSelectedIdValues();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseStatus"));
            IQuotation iQuotation = QuotationFactory.getRemoteInstance();
            QuotationInfo quotationInfo = iQuotation.getQuotationInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (quotationInfo == null) {
                throw new ObjectNotFoundException();
            }
            if (quotationInfo.getBaseStatus().getValue() != -2) {
                super.actionEdit_actionPerformed(e);
            } else {
                super.actionEdit_actionPerformed(e);
                this.setOprtState("ALTER");
                this.pubFireVOChangeListener(ids.get(0).toString());
                this.showAlertUI(e);
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        String firstStorageID = "";
        String nextStorageID = "";
        this.checkSelected();
        firstStorageID = this.tblMain.getRow(sm.get(0).getBeginRow()).getCell("saleOrgUnit.id").getValue().toString();
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                nextStorageID = this.tblMain.getRow(j).getCell("saleOrgUnit.id").getValue().toString();
                if (!firstStorageID.equals(nextStorageID)) {
                    MsgBox.showError((String)SaleUtil.getUIResource("QUO_SALEORG_ERROR"));
                    SysUtil.abort();
                }
                Date d1 = (Date)this.tblMain.getRow(j).getCell("enableDate").getValue();
                Date d2 = (Date)this.tblMain.getRow(j).getCell("disibleDate").getValue();
                Timestamp dCurDate = SCMClientUtils.getServerDate();
                if ((d1 == null || !dCurDate.before(d1)) && (d2 == null || !dCurDate.after(d2))) continue;
                MsgBox.showError((String)SaleUtil.getUIResource("QUO_ENABLEDATE_ERROR"));
                SysUtil.abort();
            }
        }
        super.actionCreateTo_actionPerformed(e);
    }

    private void setMainTableAlign() {
        int num = NUMBERTAB.length;
        for (int i = 0; i < num; ++i) {
            this.tblMain.getColumn(NUMBERTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        if (this.isSwitchView()) {
            return;
        }
        int pricePre = 2;
        int ratePre = 2;
        BizEnumValueInfo discountTypeValue = null;
        String[] QTY_COLUMNS = new String[]{TB_ENTQTYFROM, TB_ENTQTYTO, TB_ENTBASEQTYFROM, TB_ENTBASEQTYTO};
        String[] PRICE_COLUMNS = new String[]{TB_ENTPRICE, TB_ENTACTUALTAXPRICE, TB_ENTTAXPRICE};
        String[] RATE_COLUMNS = new String[]{TB_ENTTAXRATE};
        try {
            while (rowSet.next()) {
                pricePre = rowSet.getInt("material.pricePrecision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)ratePre, (String[])RATE_COLUMNS, (IRowSet)rowSet);
                discountTypeValue = (BizEnumValueInfo)rowSet.getObject("entries.discountType");
                if (discountTypeValue == null) {
                    SCMClientUtils.iniColumnsPrecision((int)4, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
                    continue;
                }
                if (discountTypeValue.getInt() == 0) {
                    SCMClientUtils.iniColumnsPrecision((int)4, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
                    continue;
                }
                SCMClientUtils.iniColumnsPrecision((int)pricePre, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getAmountColumns() {
        return new String[]{TB_ENTDISCOUNT, TB_ENTTAXRATE, "entries.deliveryDate"};
    }

    protected String[][] getNullColumns() {
        return new String[][]{{"NULL", "priceSourceType"}};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_ENTQTYFROM, TB_ENTQTYTO, TB_ENTBASEQTYFROM, TB_ENTBASEQTYTO};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_ENTPRICE, TB_ENTACTUALTAXPRICE, TB_ENTTAXPRICE};
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new QuotationQueryUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new QuotationQueryUI();
        }
        return this.conditionPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        try {
            ArrayList ids = super.getSelectedIdValues();
            String[] idsString = new String[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                idsString[i] = (String)ids.get(i);
            }
            SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])idsString);
            this.setOprtState("AUDIT");
            this.pubFireVOChangeListener(ids.get(0).toString());
            IQuotation iQuotation = QuotationFactory.getRemoteInstance();
            iQuotation.audit((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        IQuotation iQuotation = QuotationFactory.getRemoteInstance();
        this.checkSelected();
        String[] allIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        String[] selIDs = SCMClientUtils.getSetArray((String[])allIDs);
        this.checkUnAudit(selIDs);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        iQuotation.unAudit(pks);
        this.setMessageText(SaleUtil.getUIResource("UNAUDIT_SUCCESS"));
        this.showMessage();
        this.refreshList();
    }

    protected void checkUnAudit(String[] selIDs) throws BOSException, EASBizException, SCMBillException {
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_AUDIT")})));
            return;
        }
        IQuotation iQuotation = QuotationFactory.getRemoteInstance();
        int cont = selIDs.length;
        for (int i = 0; i < cont; ++i) {
            QuotationInfo info = iQuotation.getQuotationInfo((IObjectPK)new ObjectUuidPK(selIDs[i]));
            SCMClientUtils.checkUnAuditDetail((QuotationInfo)info);
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleQuotationPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SD/SaleQuotation";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlert_actionPerformed(ActionEvent e) throws Exception {
        super.actionAlert_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        this.checkAlter(String.valueOf(ids.get(0)));
        IQuotation iQuotation = QuotationFactory.getRemoteInstance();
        try {
            this.setOprtState("ALTER");
            this.pubFireVOChangeListener(ids.get(0).toString());
            iQuotation.checkAlert((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void checkAlter(String srcId) throws BOSException {
        int result;
        if (SCMClientUtils.hasDestBill((String)srcId) && (result = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"HAS_DEST_BILL_CONTINUE"))) != 0) {
            SysUtil.abort();
        }
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("cusPurNumber"));
        sic.add(new SelectorItemInfo("orderCustomer.id"));
        sic.add(new SelectorItemInfo("orderCustomer.number"));
        sic.add(new SelectorItemInfo("orderCustomer.name"));
        sic.add(new SelectorItemInfo("deliveryType.id"));
        sic.add(new SelectorItemInfo("deliveryType.number"));
        sic.add(new SelectorItemInfo("deliveryType.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.number"));
        sic.add(new SelectorItemInfo("salePerson.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo(TB_ENTBASEQTYFROM));
        sic.add(new SelectorItemInfo(TB_ENTBASEQTYTO));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo(TB_ENTQTYFROM));
        sic.add(new SelectorItemInfo(TB_ENTQTYTO));
        sic.add(new SelectorItemInfo(TB_ENTPRICE));
        sic.add(new SelectorItemInfo(TB_ENTTAXRATE));
        sic.add(new SelectorItemInfo(TB_ENTTAXPRICE));
        sic.add(new SelectorItemInfo("entries.discountCondition"));
        sic.add(new SelectorItemInfo("entries.discountType"));
        sic.add(new SelectorItemInfo(TB_ENTDISCOUNT));
        sic.add(new SelectorItemInfo(TB_ENTACTUALTAXPRICE));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modificationTime"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("entries.deliveryDate"));
        sic.add(new SelectorItemInfo("enabledDate"));
        sic.add(new SelectorItemInfo("disibleDate"));
        sic.add(new SelectorItemInfo("baseStatus"));
        return sic;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected void logPrint() {
        String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new QuotationInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, QuotationFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, QuotationEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", "number", "entries.seq", "saleOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"handClose");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionClose, (String)"handUnClose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnClose");
        actionProxy.bindTo((AbstractButton)this.btnUnClose);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorCol = super.getSelectors();
        selectorCol.add(new SelectorItemInfo("material.pricePrecision"));
        selectorCol.add(new SelectorItemInfo("currency.precision"));
        return selectorCol;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        if (selIDs == null) {
            this.handleException((Exception)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        Map uiContext = this.getUIContext();
        uiContext.put("billId", SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put("mainOrgId", (OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType()));
        this.getUIContext().put("IDList", null);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sd.sale.client.QuotationVersionUI", uiContext, null);
        window.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        String[] selectIds = SCMClientUtils.filterDistnctID((String[])KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        if (selectIds == null || selectIds.length == 0) {
            MsgBox.showError((String)EASResource.getString((String)RESOURCE, (String)"MUST_SELECT_ENTRY"));
            return;
        }
        try {
            IQuotation iQuotation = QuotationFactory.getRemoteInstance();
            this.setOprtState("REVOKE");
            int num = selectIds.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selectIds[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else if (reasonCodeInfo instanceof IObjectValue) {
                iQuotation.revoke(selectIds, (IObjectValue)reasonCodeInfo);
            } else {
                iQuotation.revoke(selectIds, (String)reasonCodeInfo);
            }
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void initBtnIcon() {
        this.menuItemViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemViewVersion.setEnabled(true);
        this.btnClose.setEnabled(true);
        this.btnUnClose.setEnabled(true);
        this.btnRevoke.setEnabled(true);
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.43supplyManage.436saleManage.saleQuotation";
        param.alias = EASResource.getString((String)RESOURCE, (String)"QUOTATION");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.43supplyManage.436saleManage.saleQuotation";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

