/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMCommonDataProvider;
import com.kingdee.eas.scm.common.util.SCMSlaveCommonDataProvider;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.ISaleContract;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractException;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleContractListUI;
import com.kingdee.eas.scm.sd.sale.client.SaleContractCommonProcessor;
import com.kingdee.eas.scm.sd.sale.client.SaleContractEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleContractQueryUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SaleContractListUI
extends AbstractSaleContractListUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleContractListUI.class);
    private static final String TB_ENTQTY = "entries.qty";
    private static final String TB_ENTBASEQTY = "entries.baseQty";
    private static final String TB_ENTASSISTQTY = "entries.assistQty";
    private static final String TB_ENTPRICE = "entries.price";
    private static final String TB_ENTTAXRATE = "entries.taxRate";
    private static final String TB_ENTTAXPRICE = "entries.taxPrice";
    private static final String TB_ENTAMOUNT = "entries.amount";
    private static final String TB_ENTTAX = "entries.tax";
    private static final String TB_ENTTAXAMOUNT = "entries.taxAmount";
    private static final String TB_ENTDISCOUNT = "entries.discount";
    private static final String TB_ENTDISCOUNTAMOUNT = "entries.discountAmount";
    private static final String TB_ENTACTUALPRICE = "entries.actualPrice";
    private static final String TB_ENTACTUALTAXPRICE = "entries.actualTaxPrice";
    private static final String TB_ENTTOTALORDEREDAMT = "entries.totalOrderedAmt";
    private static final String TB_ENTTOTALORDEREDQTY = "entries.totalOrderedQty";
    public static final String RES_PROMPT = "com.kingdee.eas.scm.sd.sale.SaleUIResource";
    private static String[] NUMBERTAB = new String[]{"entries.qty", "entries.baseQty", "entries.assistQty", "entries.price", "entries.taxRate", "entries.taxPrice", "entries.amount", "entries.tax", "entries.taxAmount", "entries.discount", "entries.discountAmount", "entries.actualPrice", "entries.actualTaxPrice", "entries.totalOrderedAmt", "entries.totalOrderedQty", "exchangeRate"};
    SaleContractQueryUI conditionPanel = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public SaleContractListUI() throws Exception {
        this.actionAudit.setBindWorkFlow(true);
        this.actionAlter.setBindWorkFlow(false);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog != null) {
            this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
            return this.commonQueryDialog;
        }
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setProcessor((IProcessor)new SaleContractCommonProcessor());
        this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
        return this.commonQueryDialog;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.btnSubmit.setVisible(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return SaleContractEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleContractFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnIcon();
        this.initTableAlign();
        this.setMainTableFreeze();
        this.menuItemAudit.setVisible(true);
        this.btnAudit.setVisible(true);
        this.actionImportData.setVisible(true);
        this.actionExportData.setVisible(true);
        this.btnFreeze.setVisible(false);
        this.btnUnfreeze.setVisible(false);
        this.kdMenuVoucher.setVisible(false);
        this.tblMain.getColumn("currency.precision").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("material.pricePrecision").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("materialGroup.name").getStyleAttributes().setHided(true);
        this.btnSubmit.setVisible(true);
        this.menuItemSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSubmit.setEnabled(true);
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"bizDate", "entries.sendDate", "entries.deliveryDate"};
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.scm.sd.saleContract";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.client.SaleResource", (String)"SaleContractTitle");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.sd.saleContract";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void initBtnIcon() {
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnfreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnUnclose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.btnAlter.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.menuItemUnfreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemUnclose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.menuItemAlter.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemViewVersion.setIcon(EASResource.getIcon((String)"imgTable_task"));
    }

    private void initTableAlign() {
        int num = NUMBERTAB.length;
        for (int i = 0; i < num; ++i) {
            this.tblMain.getColumn(NUMBERTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "bizDate", "bizType.name", "baseStatus", "customer.name", "saleOrgUnit.name", "receiveCondition.name", "salePerson.name", "currency.name", "exchangeRate", "contractType.name", "paymentType.name", "description", "processNode", "version"};
        return columns;
    }

    public String[] getVisibleFields() {
        return new String[]{"number", "bizDate", "customer.name", "baseStatus", "saleOrgUnit.name", "storageOrgUnit.name", "entries.seq", "material.number", "material.name", "material.model", "unit.name", TB_ENTQTY, TB_ENTPRICE, TB_ENTTAXPRICE, TB_ENTAMOUNT, TB_ENTTAX, TB_ENTTAXAMOUNT};
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleContractQueryUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleContractQueryUI();
        }
        return this.conditionPanel;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.CU"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("transLeadTime"));
        sic.add(new SelectorItemInfo("deliveryType.id"));
        sic.add(new SelectorItemInfo("deliveryType.number"));
        sic.add(new SelectorItemInfo("deliveryType.name"));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("receiveCondition.id"));
        sic.add(new SelectorItemInfo("receiveCondition.number"));
        sic.add(new SelectorItemInfo("receiveCondition.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.number"));
        sic.add(new SelectorItemInfo("salePerson.name"));
        sic.add(new SelectorItemInfo("salePerson.person.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo(TB_ENTQTY));
        sic.add(new SelectorItemInfo(TB_ENTPRICE));
        sic.add(new SelectorItemInfo(TB_ENTAMOUNT));
        sic.add(new SelectorItemInfo(TB_ENTTAXAMOUNT));
        sic.add(new SelectorItemInfo(TB_ENTACTUALPRICE));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.warehouse.name"));
        sic.add(new SelectorItemInfo("entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo(TB_ENTTOTALORDEREDQTY));
        sic.add(new SelectorItemInfo(TB_ENTTOTALORDEREDAMT));
        sic.add(new SelectorItemInfo("isIntax"));
        return sic;
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(SaleUtil.getUIResource(msgResource));
        this.showMessage();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int ratePre = 2;
        int amountPre = 2;
        String[] QTY_COLUMNS = new String[]{TB_ENTQTY, TB_ENTBASEQTY, TB_ENTASSISTQTY, TB_ENTTOTALORDEREDQTY};
        String[] PRICE_COLUMNS = new String[]{TB_ENTDISCOUNT, TB_ENTPRICE, TB_ENTACTUALPRICE, TB_ENTTAXPRICE, TB_ENTACTUALTAXPRICE};
        String[] Amount_Columns = new String[]{TB_ENTAMOUNT, TB_ENTTAX, TB_ENTTAXAMOUNT, TB_ENTDISCOUNTAMOUNT, TB_ENTTOTALORDEREDAMT};
        String[] RATE_COLUMNS = new String[]{TB_ENTTAXRATE};
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])Amount_Columns, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)ratePre, (String[])RATE_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_ENTQTY, TB_ENTBASEQTY, TB_ENTASSISTQTY, TB_ENTTOTALORDEREDQTY};
    }

    protected String[] getTaxRateColumns() {
        return new String[]{TB_ENTTAXRATE};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_ENTDISCOUNT, TB_ENTPRICE, TB_ENTACTUALPRICE, TB_ENTTAXPRICE, TB_ENTACTUALTAXPRICE};
    }

    public String[] getAmountColumns() {
        return new String[]{TB_ENTAMOUNT, TB_ENTTAX, TB_ENTTAXAMOUNT, TB_ENTDISCOUNTAMOUNT, TB_ENTTOTALORDEREDAMT};
    }

    protected String[][] getNullColumns() {
        return new String[][]{{"NULL", "priceSourceType"}};
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleContractInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return "companyOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkDelete();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkDelete() throws Exception {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                String baseStatus = this.tblMain.getRow(i).getCell("baseStatus").getValue().toString().trim();
                if (baseStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) || baseStatus.equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) continue;
                throw new SaleContractException(SaleContractException.CANNOT_DELETE, new String[]{baseStatus});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int num;
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_AUDIT")})));
            return;
        }
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])selIDs);
        ISaleContract iSaleContract = (ISaleContract)this.getBizInterface();
        try {
            int i;
            this.setOprtState("AUDIT");
            num = selIDs.length;
            for (int i2 = 0; i2 < num; ++i2) {
                this.pubFireVOChangeListener(selIDs[i2]);
            }
            KDTSelectManager sm = this.tblMain.getSelectManager();
            int blockCount = sm.size();
            BizEnumValueInfo statusValue = null;
            boolean isAlter = true;
            block19: for (i = 0; i < blockCount; ++i) {
                KDTSelectBlock block = sm.get(i);
                int bottom = block.getBottom();
                for (int j = block.getTop(); j <= bottom; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("entries.baseStatus").getValue() == null || (statusValue = (BizEnumValueInfo)row.getCell("entries.baseStatus").getValue()).getInt() == -2) continue;
                    isAlter = false;
                    continue block19;
                }
            }
            if (isAlter) {
                int c = selIDs.length;
                for (i = 0; i < c; ++i) {
                    iSaleContract.agreeAlter((IObjectPK)new ObjectUuidPK(selIDs[i]));
                }
                this.refreshList();
                return;
            }
            this.checkAudit();
            iSaleContract.audit(SCMUtils.convertStringToObjectPK((String[])selIDs));
            MsgBox.showInfo((String)SaleUtil.getUIResource("CONTRACT_AUDIT_SUCCESS"));
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlter_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        ISaleContract iSaleContract = (ISaleContract)this.getBizInterface();
        try {
            this.setOprtState("ALTER");
            this.pubFireVOChangeListener(ids.get(0).toString());
            iSaleContract.checkAlter((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_REVOKE")})));
            return;
        }
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleContract iSaleContract = (ISaleContract)this.getBizInterface();
        try {
            int i;
            int num;
            iSaleContract.canRevoke(pks);
            this.setOprtState("REVOKE");
            int num2 = selIDs.length;
            for (int i2 = 0; i2 < num2; ++i2) {
                this.pubFireVOChangeListener(selIDs[i2]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else if (reasonCodeInfo instanceof IObjectValue) {
                ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                }
                iSaleContract.revoke(pks, (IObjectValue[])reasonCodeInfos);
            } else if (reasonCodeInfo instanceof String) {
                String[] reasonCodeInfos = new String[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (String)reasonCodeInfo;
                }
                iSaleContract.revoke(pks, reasonCodeInfos);
            }
            this.showSuccessMsg("CONTRACT_REVOKE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_CLOSE")})));
            return;
        }
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        try {
            int i;
            int num;
            iSaleContractEntry.canHandClose(pks);
            this.setOprtState("CLOSE");
            int num2 = selIDs.length;
            for (int i2 = 0; i2 < num2; ++i2) {
                this.pubFireVOChangeListener(selIDs[i2]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else if (reasonCodeInfo instanceof IObjectValue) {
                ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                }
                iSaleContractEntry.handClose(pks, (IObjectValue[])reasonCodeInfos);
            } else if (reasonCodeInfo instanceof String) {
                String[] reasonCodeInfos = new String[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (String)reasonCodeInfo;
                }
                iSaleContractEntry.handClose(pks, reasonCodeInfos);
            }
            this.showSuccessMsg("CONTRACT_CLOSE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_FREEZED")})));
            return;
        }
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        try {
            int i;
            int num;
            this.setOprtState("FREEZED");
            int num2 = selIDs.length;
            for (int i2 = 0; i2 < num2; ++i2) {
                this.pubFireVOChangeListener(selIDs[i2]);
            }
            iSaleContractEntry.canFreeze(pks);
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else if (reasonCodeInfo instanceof IObjectValue) {
                ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                }
                iSaleContractEntry.freeze(pks, (IObjectValue[])reasonCodeInfos);
            } else if (reasonCodeInfo instanceof String) {
                String[] reasonCodeInfos = new String[selIDs.length];
                num = selIDs.length;
                for (i = 0; i < num; ++i) {
                    reasonCodeInfos[i] = (String)reasonCodeInfo;
                }
                iSaleContractEntry.freeze(pks, reasonCodeInfos);
            }
            this.showSuccessMsg("CONTRACT_FREEZE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnfreeze_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_UNFREEZED")})));
            return;
        }
        ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        try {
            this.setOprtState("UNFREEZED");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iSaleContractEntry.unFreeze(SCMUtils.convertStringToObjectPK((String[])selIDs));
            this.showSuccessMsg("CONTRACT_UNFREEZE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    @Override
    public void actionViewVersion_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        if (selIDs == null) {
            this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{""})));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BillID", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"mainOrgId", (Object)((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sd.sale.client.SaleContractVersionUI", (Map)uiContext, null);
        window.show();
    }

    protected void invokeMultiPrintFunction(boolean isPrint) {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        this.invokeMultiPrintFunction(idList, isPrint);
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleContractPrintQuery");
    }

    protected IMetaDataPK getTDQueryPK2() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleContractEntryPrintQuery");
    }

    protected IMetaDataPK getTDQueryPK3() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleContractTermPrintQuery");
    }

    protected IMetaDataPK getTDQueryPK4() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleContractQCItemPrintQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/SCM/SD/SaleContract";
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, SaleContractFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, SaleContractEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", "number", "entries.seq", "saleOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionClose, (String)"handClose");
        this.actionManager.registerBatchAction(actionProxy, "actionClose");
        actionProxy.bindTo((AbstractButton)this.btnClose);
        actionProxy.bindTo((AbstractButton)this.menuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.FREEZE, (ItemAction)this.actionFreeze, (String)"freeze");
        this.actionManager.registerBatchAction(actionProxy, "actionFreeze");
        actionProxy.bindTo((AbstractButton)this.btnFreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemFreeze);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNFREEZE, (ItemAction)this.actionUnfreeze, (String)"unFreeze");
        this.actionManager.registerBatchAction(actionProxy, "actionUnfreeze");
        actionProxy.bindTo((AbstractButton)this.btnUnfreeze);
        actionProxy.bindTo((AbstractButton)this.menuItemUnfreeze);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionRevoke, (String)"revoke");
        this.actionManager.registerBatchAction(actionProxy, "ActionRevoke");
        actionProxy.bindTo((AbstractButton)this.btnRevoke);
        actionProxy.bindTo((AbstractButton)this.menuItemRevoke);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnclose, (String)"handleUnclose");
        this.actionManager.registerBatchAction(actionProxy, "actionUnclose");
        actionProxy.bindTo((AbstractButton)this.btnUnclose);
        actionProxy.bindTo((AbstractButton)this.menuItemUnclose);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void invokeMultiPrintFunction(List idList, boolean isPrint) {
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        StringBuffer err = new StringBuffer();
        CoreBaseCollection collection = new CoreBaseCollection();
        collection = this.getScmBillCollection(idList);
        SCMBillBaseInfo aSCMBillBaseInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            aSCMBillBaseInfo = (SCMBillBaseInfo)collection.get(i);
            if (aSCMBillBaseInfo.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED) continue;
            err.append(EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BILL") + aSCMBillBaseInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"CANNOTPRINT") + "\n");
        }
        if (err.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"SELECTBILLCANNOTPRINT"), (String)err.toString(), (int)2);
            SysUtil.abort();
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        this.setCustomerDataProvider(data, idList);
        SCMCommonDataProvider mainQueryData = new SCMCommonDataProvider(idList, this.gettDQueryPKEx());
        mainQueryData.setFilter(this.getPrintFilter(idList));
        data.put("MainQuery", (BOSQueryDelegate)mainQueryData);
        SCMCommonDataProvider saleContractData = new SCMCommonDataProvider(idList, this.getTDQueryPK());
        SCMSlaveCommonDataProvider saleContractEntryData = new SCMSlaveCommonDataProvider(idList, this.getTDQueryPK2(), "id");
        SCMSlaveCommonDataProvider saleContractTermData = new SCMSlaveCommonDataProvider(idList, this.getTDQueryPK3(), "id");
        SCMSlaveCommonDataProvider saleContractQCItemData = new SCMSlaveCommonDataProvider(idList, this.getTDQueryPK4(), "id");
        data.put("SaleContract", (BOSQueryDelegate)saleContractData);
        data.put("SaleContractEntry", (BOSQueryDelegate)saleContractEntryData);
        data.put("SaleContractTerm", (BOSQueryDelegate)saleContractTermData);
        data.put("SaleContractQCItem", (BOSQueryDelegate)saleContractQCItemData);
        SCMSlaveCommonDataProvider multiApproveViewQueryData = new SCMSlaveCommonDataProvider(idList, this.getMultiApproveViewQuery(), "billId");
        data.put("MultiApproveViewQuery", (BOSQueryDelegate)multiApproveViewQueryData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BOSObjectType bosType = null;
        try {
            bosType = this.getBizInterface().getType();
            logger.info((Object)("current bostype:>>" + bosType.toString()));
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.remoteerror"));
            SysUtil.abort();
        }
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(bosType.toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)bosType, (List)idList, (String)this.getTDFileName(), (String)"com.kingdee.eas.scm.common.SCMResource", (boolean)false);
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionUnclose_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionUnclose_actionPerformed(e);
            String[] entryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
            if (entryIDs == null) {
                this.handleException((Exception)((Object)new SaleContractException(SaleContractException.MUST_SELECT_ONE_ENTRY, new String[]{SaleUtil.getUIResource("OPERATOR_UNCLOSE")})));
                return;
            }
            IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])entryIDs);
            ISaleContractEntry saleContractEntry = SaleContractEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            saleContractEntry.handleUnclose(pks);
            this.showSuccessMsg("UNCLOSE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorCol = super.getSelectors();
        selectorCol.add(new SelectorItemInfo("preReceived"));
        selectorCol.add(new SelectorItemInfo("unPrereceivedAmount"));
        return selectorCol;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanEdit();
        ArrayList ids = super.getSelectedIdValues();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseStatus"));
            SaleContractInfo saleContractInfo = SaleContractFactory.getRemoteInstance().getSaleContractInfo((IObjectPK)new ObjectUuidPK(ids.get(0).toString()), sic);
            if (saleContractInfo.getBaseStatus().getValue() != -2) {
                super.actionEdit_actionPerformed(e);
            } else {
                this.setOprtState("ALTER");
                this.pubFireVOChangeListener(ids.get(0).toString());
                this.showAlertUI(e);
            }
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void checkCanEdit(SCMBillBaseInfo billInfo) throws Exception {
        if (this.getUIContext().get("BillQuery") != null) {
            if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                MsgBox.showError((Component)((Object)this), (String)(SCMClientUtils.getResource((String)"BillAt") + billInfo.getBaseStatus().getAlias() + SCMClientUtils.getResource((String)"CantBeEdited")));
                SysUtil.abort();
            }
            return;
        }
        if (!(billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD))) {
            MsgBox.showError((Component)((Object)this), (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.SCMResource", (String)"BillStatusCantBeEdited", (String[])new String[]{billInfo.getBaseStatus().getAlias()}));
            SysUtil.abort();
        }
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        CompanyOrgUnitInfo currentCompany = null;
        if (this.getBOTPViewStatus() == 1) {
            Map map = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            if (map != null && currentCompany == null) {
                currentCompany = (CompanyOrgUnitInfo)map.get("ARAPCOMPANY");
            }
            if (currentCompany != null) {
                FilterItemInfo companyFilter = new FilterItemInfo("companyOrgUnit.id", (Object)currentCompany.getId(), CompareType.EQUALS);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(companyFilter);
                FilterInfo oldFilter = ev.getFilter();
                try {
                    if (filter.getFilterItems().size() > 0) {
                        oldFilter.mergeFilter(filter, "AND");
                    }
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                ev.setFilter(oldFilter);
            }
        }
        super.beforeExcutQuery(ev);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceDown_actionPerformed(e);
    }

    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
        return super.beforeAction(bizAction, selectionEntries, event);
    }

    protected static class PrintListner
    implements IPrintActionListener {
        protected PrintListner() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
            IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleContractInfo().getBOSType(), null, (String)operName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }

        public void closePreview() {
        }
    }
}

