/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceCollection;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleInnerDealPriceEditUI;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SaleInnerDealPriceEditUI
extends AbstractSaleInnerDealPriceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleInnerDealPriceEditUI.class);
    KDTEditAdapter entryTableChange = null;
    private static final String TB_ID = "id";
    private static final String TB_TAXRATE = "taxRate";
    private static final String TB_PRICE = "price";
    private static final String TB_TAXPRICE = "taxPrice";
    private static final String TB_DISCOUNTMODE = "discountMode";
    private static final String TB_DISCOUNT = "discount";
    private static final String TB_ACTUALPRICE = "actualPrice";
    private static final String TB_ACTUALTAXPRICE = "actualTaxPrice";
    private static final String TB_SALEORDERENTRYID = "saleOrderEntry.id";
    private static final String TB_SOENTRYACTUALPRICE = "saleOrderEntry.actualPrice";
    private static final String TB_PRECISION = "precision";
    private static String[] QTYAMOUNTCOLUMNS = new String[]{"taxRate", "saleOrderEntry.actualPrice", "price", "taxPrice", "discount", "actualPrice", "actualTaxPrice"};
    private static String[] EDITCOLUMNS = new String[]{"taxRate", "taxPrice", "discountMode", "discount"};

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.setOprtState(OprtState.VIEW);
        this.setQueryFilter();
        super.onLoad();
        this.initBtn();
        this.initTableListener();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    private void initBtn() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.setEditable(false);
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(true);
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.tblMain.setEditable(true);
            this.btnSave.setEnabled(true);
            this.btnEdit.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setQueryFilter() {
        Object[] tempIds = (String[])this.getUIContext().get("saleOrderEntryIds");
        Object[] id = null;
        id = this.getUIContext().get("ID") != null ? new String[]{(String)this.getUIContext().get("ID")} : (String[])this.getUIContext().get("saleOrderIds");
        FilterInfo filter = new FilterInfo();
        if (tempIds != null) {
            filter.getFilterItems().add(new FilterItemInfo(TB_SALEORDERENTRYID, (Object)StringUtil.getKeyIdList((Object[])tempIds).replaceAll("'", ""), CompareType.INCLUDE));
        } else if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)StringUtil.getKeyIdList((Object[])id).replaceAll("'", ""), CompareType.INCLUDE));
        }
        this.querySaleInnerDealPriceQuery = new EntityViewInfo();
        this.querySaleInnerDealPriceQuery.setFilter(filter);
    }

    private void initTableCellEditor() {
        int count = this.getTable().getRowCount();
        for (int r = 0; r < count; ++r) {
            IRow row = this.getTable().getRow(r);
            int n = QTYAMOUNTCOLUMNS.length;
            for (int i = 0; i < n; ++i) {
                int precision = 8;
                Object precisionInteger = row.getCell(TB_PRECISION).getValue();
                if (precisionInteger != null) {
                    precision = Integer.parseInt(String.valueOf(precisionInteger));
                }
                KDFormattedTextField colTxtField = new KDFormattedTextField();
                colTxtField.setDataType(1);
                colTxtField.setPrecision(precision);
                colTxtField.setHorizontalAlignment(4);
                colTxtField.setRemoveingZeroInDispaly(true);
                String colPrecision = PrecisionUtil.getFormatString((int)precision);
                KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JTextField)colTxtField);
                if (row.getCell(QTYAMOUNTCOLUMNS[i]) != null) {
                    row.getCell(QTYAMOUNTCOLUMNS[i]).setEditor((ICellEditor)col_CellEditor);
                }
                row.getCell(QTYAMOUNTCOLUMNS[i]).getStyleAttributes().setNumberFormat(colPrecision);
            }
        }
        KDComboBox kdtEntries_discountType_ComboBox = new KDComboBox();
        kdtEntries_discountType_ComboBox.setName("kdtEntries_discountType_ComboBox");
        kdtEntries_discountType_ComboBox.setVisible(true);
        kdtEntries_discountType_ComboBox.addItems(DiscountModeEnum.getEnumList().toArray());
        KDTDefaultCellEditor kdtEntries_discountType_CellEditor = new KDTDefaultCellEditor((JComboBox)kdtEntries_discountType_ComboBox);
        this.tblMain.getColumn(TB_DISCOUNTMODE).setEditor((ICellEditor)kdtEntries_discountType_CellEditor);
    }

    private void initTableListener() {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    SaleInnerDealPriceEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    SaleInnerDealPriceEditUI.this.handUIException(exc);
                }
            }

            public void editStarting(KDTEditEvent e) {
                try {
                    SaleInnerDealPriceEditUI.this.kdtEntrys_editStarting(e);
                }
                catch (Exception exc) {
                    SaleInnerDealPriceEditUI.this.handUIException(exc);
                }
            }
        };
        this.tblMain.addKDTEditListener((KDTEditListener)this.entryTableChange);
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SaleInnerDealPriceEditUI.this.tbl_afterDataFill(e);
            }
        });
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        this.initTableCellEditor();
        this.initEntryData();
    }

    public void kdtEntrys_editStarting(KDTEditEvent e) throws Exception {
    }

    private void initEntryData() {
        int count = this.getTable().getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.getTable().getRow(i);
            Object discountTypeObject = row.getCell(TB_DISCOUNTMODE).getValue();
            if (discountTypeObject == null) continue;
            row.getCell(TB_DISCOUNTMODE).setValue((Object)DiscountModeEnum.getEnum((int)Integer.parseInt(discountTypeObject.toString())));
        }
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (newValue == null) {
            newValue = oldValue;
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.tblMain.getColumnKey(colIndex);
        if (TB_TAXRATE.equals(fieldName)) {
            this.calEntryPrice(rowIndex, colIndex);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
        }
        if (TB_TAXPRICE.equals(fieldName)) {
            this.calEntryPrice(rowIndex, colIndex);
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
        }
        if (TB_DISCOUNTMODE.equals(fieldName)) {
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
        }
        if (TB_DISCOUNT.equals(fieldName)) {
            this.calEntryActualTaxPrice(rowIndex, colIndex);
            this.calEntryActualPrice(rowIndex, colIndex);
        }
    }

    public void calEntryActualPrice(int rowIndex, int colIndex) {
        BigDecimal taxRate = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_TAXRATE).getValue();
        BigDecimal actualTaxPrice = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_ACTUALTAXPRICE).getValue();
        BigDecimal price = null;
        if (taxRate != null && actualTaxPrice != null) {
            price = actualTaxPrice.intValue() != 0 ? actualTaxPrice.divide(SCMConstant.BIGDECIMAL_ONE.add(taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED)), 10, RoundingMode.HALF_UP) : new BigDecimal("0.00");
            this.getTable().getRow(rowIndex).getCell(TB_ACTUALPRICE).setValue((Object)price);
        }
    }

    public void calEntryActualTaxPrice(int rowIndex, int colIndex) {
        BigDecimal actualTaxPrice;
        BigDecimal taxPrice;
        int intDiscountModel;
        Object disModel = this.getTable().getRow(rowIndex).getCell(TB_DISCOUNTMODE).getValue();
        if (disModel instanceof Integer) {
            intDiscountModel = (Integer)disModel;
        } else {
            DiscountModeEnum discountModel = (DiscountModeEnum)this.getTable().getRow(rowIndex).getCell(TB_DISCOUNTMODE).getValue();
            intDiscountModel = discountModel.getValue();
        }
        BigDecimal discount = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_DISCOUNT).getValue();
        if (disModel != null && 0 == intDiscountModel) {
            taxPrice = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_TAXPRICE).getValue();
            if (SCMConstant.BIGDECIMAL_ZERO.compareTo(discount) == 0) {
                this.getTable().getRow(rowIndex).getCell(TB_ACTUALTAXPRICE).setValue((Object)taxPrice);
            } else {
                actualTaxPrice = taxPrice.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discount.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED))).setScale(10, RoundingMode.HALF_UP);
                this.getTable().getRow(rowIndex).getCell(TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
            }
        }
        if (disModel != null && 1 == intDiscountModel) {
            taxPrice = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_TAXPRICE).getValue();
            actualTaxPrice = taxPrice.subtract(discount);
            this.getTable().getRow(rowIndex).getCell(TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
        }
    }

    public void calEntryPrice(int rowIndex, int colIndex) {
        BigDecimal taxRate = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_TAXRATE).getValue();
        BigDecimal taxPrice = (BigDecimal)this.getTable().getRow(rowIndex).getCell(TB_TAXPRICE).getValue();
        if (taxRate != null && taxPrice != null) {
            BigDecimal price = taxPrice.divide(SCMConstant.BIGDECIMAL_ONE.add(taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED)), 10, RoundingMode.HALF_UP);
            this.getTable().getRow(rowIndex).getCell(TB_PRICE).setValue((Object)price);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        SaleInnerDealPriceFactory.getRemoteInstance().batchSave(this.setDataForSave());
        this.setOprtState(OprtState.VIEW);
        this.initBtn();
        SCMClientUtils.setNecessColorInTable((KDTable)this.tblMain, (String[])EDITCOLUMNS, (boolean)false);
    }

    private SaleInnerDealPriceCollection setDataForSave() {
        SaleInnerDealPriceCollection col = new SaleInnerDealPriceCollection();
        int count = this.getTable().getRowCount();
        for (int i = 0; i < count; ++i) {
            int intDiscountModel;
            SaleInnerDealPriceInfo info = new SaleInnerDealPriceInfo();
            IRow row = this.getTable().getRow(i);
            String id = (String)row.getCell(TB_ID).getValue();
            if (id != null) {
                info.setId(BOSUuid.read((String)id));
            }
            info.setTaxRate(this.changeZero((BigDecimal)row.getCell(TB_TAXRATE).getValue()));
            info.setPrice(this.changeZero((BigDecimal)row.getCell(TB_PRICE).getValue()));
            info.setTaxPrice(this.changeZero((BigDecimal)row.getCell(TB_TAXPRICE).getValue()));
            info.setActualTaxPrice(this.changeZero((BigDecimal)row.getCell(TB_ACTUALTAXPRICE).getValue()));
            info.setActualPrice(this.changeZero((BigDecimal)row.getCell(TB_ACTUALPRICE).getValue()));
            Object disModel = row.getCell(TB_DISCOUNTMODE).getValue();
            if (disModel instanceof Integer) {
                intDiscountModel = (Integer)disModel;
            } else {
                DiscountModeEnum discountModel = (DiscountModeEnum)row.getCell(TB_DISCOUNTMODE).getValue();
                intDiscountModel = discountModel.getValue();
            }
            info.setDiscountMode(DiscountModeEnum.getEnum((int)intDiscountModel));
            info.setDiscount(this.changeZero((BigDecimal)row.getCell(TB_DISCOUNT).getValue()));
            SaleOrderEntryInfo entryInfo = new SaleOrderEntryInfo();
            entryInfo.setId(BOSUuid.read((String)((String)row.getCell(TB_SALEORDERENTRYID).getValue())));
            info.setSaleOrderEntry(entryInfo);
            col.add(info);
        }
        return col;
    }

    private BigDecimal changeZero(BigDecimal value) {
        if (value == null || value.compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
            value = SCMConstant.BIGDECIMAL_ZERO;
        }
        return value;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.EDIT);
        this.initBtn();
        SCMClientUtils.setNecessColorInTable((KDTable)this.tblMain, (String[])EDITCOLUMNS);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }
}

