/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.InitializeInvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.UserQueryFilterProcessor;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.ISaleInvoice;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleInvoiceListUI;
import com.kingdee.eas.scm.sd.sale.client.SaleInvoiceEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleInvoiceQueryUI;
import com.kingdee.eas.scm.sd.sale.client.SaleInvoiceUIUtil;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleInvoiceListUI
extends AbstractSaleInvoiceListUI {
    static final String TB_ID = "id";
    static final String TB_SALEORGNAME = "saleOrgUnit.name";
    static final String TB_NUMBER = "number";
    static final String TB_INVOICEDATE = "invoiceDate";
    static final String TB_CUSTOMERNAME = "customer.name";
    static final String TB_BIZTYPE = "bizType";
    static final String TB_SOURCEBILLTYPE = "sourceBillType";
    static final String TB_INVOICETYPE = "invoiceType";
    static final String TB_PAYMENTTYPE = "paymentType";
    static final String TB_SETTLEMENTTYPE = "settlementType";
    static final String TB_QTY = "entries.quantity";
    static final String TB_ASSISTQTY = "entries.assistQuantity";
    static final String TB_PRICE = "entries.price";
    static final String TB_DISCOUNT = "entries.discount";
    static final String TB_DEALPRICE = "entries.dealPrice";
    static final String TB_AMOUNT = "entries.amount";
    static final String TB_EXCHANGERATE = "exchangeRate";
    static final String TB_LOCALAMOUNT = "entries.localAmount";
    static final String TB_TAXRATE = "entries.taxRate";
    static final String TB_TAXPRICE = "entries.taxPrice";
    static final String TB_TAX = "entries.tax";
    static final String TB_TAXAMOUNT = "entries.taxAmount";
    static final String TB_BASESTATUS = "baseStatus";
    static final String TB_INITINVTYPE = "InitInvType";
    static final String TB_VOUCHERNUM = "voucherNum";
    static final String TB_NONCHECKOFFQTY = "nonCheckoffQty";
    static final String TB_NONCHECKOFFAMOUNT = "nonCheckoffAmount";
    static final String TB_CHECKOFFQTY = "checkoffQty";
    static final String TB_CHECKOFFAMOUNT = "checkoffAmount";
    static final String TB_ISREVERSEINV = "isReverseInv";
    static final String TB_UNWRITEOFFBASEQTY = "unWrittenOffBaseQty";
    static final String TB_UNWRITEOFFLOCALAMOUNT = "unWrittenOffLocalAmount";
    static final String TB_WRITEOFFBASEQTY = "writeOffBaseQty";
    static final String TB_WRITEOFFLOCALAMOUNT = "writeOffLocalAmount";
    static final String TB_BIZTYPEID = "bizTypeID";
    static final String TB_COREBILLENTRYSEQ = "coreBillEntrySeq";
    private static final String[] AMOUT_QTY_COLS = new String[]{"entries.quantity", "entries.assistQuantity", "entries.amount", "entries.localAmount", "entries.tax", "entries.taxAmount", "nonCheckoffQty", "nonCheckoffAmount", "checkoffQty", "checkoffAmount", "unWrittenOffBaseQty", "unWrittenOffLocalAmount", "writeOffBaseQty", "writeOffLocalAmount"};
    private static final Logger logger = CoreUIObject.getLogger(SaleInvoiceListUI.class);
    String UIParam = null;
    Map companyOrgisArScmRelateMap = new HashMap();
    private SaleInvoiceQueryUI conditionQueryUI = null;

    public SaleInvoiceListUI() throws Exception {
        boolean isArScmRelate = false;
        isArScmRelate = SCMClientUtils.isARRelationSCM((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        this.companyOrgisArScmRelateMap.put(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), new Boolean(isArScmRelate));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected EntityViewInfo getInitDefaultSolution() {
        Timestamp startTime = SCMUtils.getSCMQueryTime(null, (String)"startDate");
        Timestamp endTime = SCMUtils.getSCMQueryTime(null, (String)"endDate");
        FilterItemInfo itemFromInfo = new FilterItemInfo(TB_INVOICEDATE, (Object)startTime, CompareType.GREATER_EQUALS);
        FilterItemInfo itemToInfo = new FilterItemInfo(TB_INVOICEDATE, (Object)endTime, CompareType.LESS_EQUALS);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(itemFromInfo);
        filterInfo.getFilterItems().add(itemToInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    @Override
    protected String getEditUIName() {
        return SaleInvoiceEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleInvoiceFactory.getRemoteInstance();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanAudit();
        ISaleInvoice saleInvoice = SaleInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)this.getStringRes("SALEINV_IFAUDIT"));
        if (i == 0) {
            try {
                saleInvoice.audit(billIdlist);
                MsgBox.showInfo((String)this.getStringRes("SALEINV_AUDITSUCCESS"));
                this.refresh(e);
            }
            catch (EASBizException exp) {
                this.handUIException(exp);
            }
        }
    }

    public void checkCanAudit() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String initType = row.getCell(TB_INITINVTYPE).getValue().toString();
                if (initType.trim().equals(InitializeInvoiceTypeEnum.GENERAL.getAlias())) continue;
                MsgBox.showError((Component)((Object)this), (String)this.getStringRes("SALEINV_INITINVCANNOTAUDIT"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanCancel();
        int i = MsgBox.showConfirm2((Component)((Object)this), (String)this.getStringRes("SALEINV_IFCANCEL"));
        if (i == 0) {
            try {
                ReasonCodeInfo reasonCodeInfo = ReasonF7Until.getReasonCode((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
                if (reasonCodeInfo != null) {
                    ISaleInvoice saleInvoice = SaleInvoiceFactory.getRemoteInstance();
                    String[] billIdlist = this.getSelectedListId();
                    ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
                    SaleInvoiceInfo saleinvInfo = saleInvoice.getSaleInvoiceInfo((IObjectPK)pk);
                    saleinvInfo.setInvoiceReason(reasonCodeInfo);
                    saleInvoice.cancel((IObjectPK)pk, (CoreBaseInfo)saleinvInfo);
                    this.setMessageText(this.getStringRes("SALEINV_CANCELSUCCESS"));
                    this.showMessage();
                    this.refresh(e);
                }
            }
            catch (EASBizException exp) {
                this.handUIException(exp);
            }
        }
        super.actionCancel_actionPerformed(e);
    }

    private void checkCanCancel() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo invStatus;
                String statuStr;
                String msg;
                IRow row = this.tblMain.getRow(i);
                String initType = row.getCell(TB_INITINVTYPE).getValue().toString();
                if (!initType.trim().equals(InitializeInvoiceTypeEnum.GENERAL.getAlias())) {
                    MsgBox.showError((Component)((Object)this), (String)this.getStringRes("SALEINV_INITINVCANNOTCANCEL"));
                    SysUtil.abort();
                }
                if ((msg = SaleInvoiceUIUtil.checkCanCancel(statuStr = (String)(invStatus = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue())) == null) continue;
                String number = row.getCell(TB_NUMBER).getValue().toString();
                MsgBox.showError((String)(SaleInvoiceUIUtil.getSaleInvResource("Invoice") + number + msg));
                SysUtil.abort();
            }
        }
    }

    private String[] getSelectedListId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        HashMap<String, String> mapId = new HashMap<String, String>();
        if (selectBlock != null) {
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.getKeyFieldName());
                Object keyValue = cell.getValue();
                if (keyValue == null || mapId.containsKey(keyValue.toString())) continue;
                mapId.put(keyValue.toString(), keyValue.toString());
            }
        }
        String[] listId = null;
        if (mapId != null && mapId.size() > 0) {
            Iterator iterat = mapId.keySet().iterator();
            listId = new String[mapId.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    public String getStringRes(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key);
    }

    public void onLoad() throws Exception {
        this.UIParam = (String)this.getUIContext().get("UIClassParam");
        if (this.UIParam != null) {
            this.UIParam = this.UIParam.trim();
        }
        super.onLoad();
        this.setMainTableFormat();
        this.initToolBar();
        this.initTitle();
        this.initMenuBar();
        this.setButtonEnabledBySelectInfo();
    }

    private void MainTableDataFilled(KDTDataRequestEvent e) {
        int r1 = e.getFirstRow();
        int r2 = e.getLastRow();
        for (int i = r1; i <= r2; ++i) {
            BigDecimal value;
            int j;
            if (this.tblMain.getCell(i, TB_ISREVERSEINV).getValue() != null && this.tblMain.getCell(i, TB_ISREVERSEINV).getValue() instanceof Boolean && ((Boolean)this.tblMain.getCell(i, TB_ISREVERSEINV).getValue()).booleanValue()) {
                for (j = 0; j < AMOUT_QTY_COLS.length; ++j) {
                    value = (BigDecimal)this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getValue();
                    if (value == null) continue;
                    this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).setValue((Object)value.abs());
                    this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getStyleAttributes().setFontColor(Color.RED);
                }
            }
            if (this.tblMain.getCell(i, TB_BIZTYPEID).getValue() == null || !this.tblMain.getCell(i, TB_BIZTYPEID).getValue().toString().equals("d8e80652-0107-1000-e000-04c5c0a812202407435C") && !this.tblMain.getCell(i, TB_BIZTYPEID).getValue().toString().equals("d8e80652-0114-1000-e000-04c5c0a812202407435C")) continue;
            for (j = 0; j < AMOUT_QTY_COLS.length; ++j) {
                value = (BigDecimal)this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).getValue();
                if (value == null) continue;
                this.tblMain.getCell(i, AMOUT_QTY_COLS[j]).setValue((Object)value.abs());
            }
        }
    }

    private void initIcon() {
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.menuReverse.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.btnAuditResult.setVisible(false);
    }

    private void initTitle() {
        if (this.UIParam != null && this.UIParam.equals("PAYMENT")) {
            this.setUITitle(this.getStringRes("SALEINV_ARLISTTITLE"));
        }
    }

    private void initToolBar() throws Exception {
        this.btnAudit.setVisible(false);
        this.btnCancel.setEnabled(true);
        this.btnRemove.setEnabled(true);
        this.btnAuditResult.setEnabled(true);
        this.initIcon();
    }

    private void initMenuBar() {
        this.menuItemAuditResult.setEnabled(true);
        this.menuItemCancel.setEnabled(true);
        this.menuReverse.setEnabled(true);
        this.menuItemAudit.setVisible(false);
        this.menuItemTaxRelation.setEnabled(true);
    }

    private void setMainTableFormat() {
        this.setMainTablePrecision();
        this.setMainTableAlign();
        this.setMainTableFreeze();
    }

    private void setMainTablePrecision() {
    }

    private void setMainTableAlign() {
        for (int i = 0; i < AMOUT_QTY_COLS.length; ++i) {
            this.tblMain.getColumn(AMOUT_QTY_COLS[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.tblMain.getColumn(TB_PRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_DISCOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_DEALPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_EXCHANGERATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_TAXRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_TAXPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(TB_COREBILLENTRYSEQ).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{TB_SALEORGNAME, TB_NUMBER, TB_BASESTATUS, TB_INVOICEDATE, TB_CUSTOMERNAME, TB_INVOICETYPE, TB_ISREVERSEINV, TB_SOURCEBILLTYPE, TB_BIZTYPE, TB_PAYMENTTYPE, TB_SETTLEMENTTYPE, TB_VOUCHERNUM};
        return columns;
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex(TB_SALEORGNAME));
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"UIClassParam", (Object)this.UIParam);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = this.UIParam != null ? (this.UIParam.trim().equals("bizInitInv") ? new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(0), CompareType.EQUALS) : (this.UIParam.trim().equals("PAYMENT") ? new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.EQUALS) : new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.NOTEQUALS))) : new FilterItemInfo("initializeInvoiceType", (Object)String.valueOf(1), CompareType.NOTEQUALS);
        filterInfo.getFilterItems().add(filterItem);
        FilterInfo companyOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"company.id");
        try {
            filter.mergeFilter(companyOrgFilter, "AND");
            filter.mergeFilter(filterInfo, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        dialog.setShowFilter(true);
        dialog.setShowSorter(true);
        dialog.setTitle(SCMClientUtils.getStandardFilterTitle((String)this.getUITitle()));
        dialog.setWidth(430);
        dialog.setHeight(310);
        if (this.conditionQueryUI == null) {
            try {
                this.conditionQueryUI = new SaleInvoiceQueryUI();
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        if (this.UIParam != null && this.UIParam.trim().equals("PAYMENT")) {
            this.conditionQueryUI.setIsArInitInvoiceQuery(true);
        }
        dialog.addUserPanel((KDPanel)this.conditionQueryUI);
        UserQueryFilterProcessor userFilter = new UserQueryFilterProcessor();
        userFilter.setOwner((IUIObject)this.conditionQueryUI);
        dialog.setProcessor((IProcessor)userFilter);
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setParentUIClassName(SaleInvoiceListUI.class.getName());
        return dialog;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.canCreateVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void canCreateVoucher() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo value;
                IRow row = this.tblMain.getRow(i);
                BizEnumValueInfo initTypeInfo = (BizEnumValueInfo)row.getCell(TB_INITINVTYPE).getValue();
                if (!initTypeInfo.getValue().equals(String.valueOf(InitializeInvoiceTypeEnum.GENERAL.getValue()))) {
                    MsgBox.showError((Component)((Object)this), (String)this.getStringRes("SALEINV_INITINVCANNOTVOUCHER"));
                    SysUtil.abort();
                }
                if ((value = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue().equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) continue;
                MsgBox.showError((Component)((Object)this), (String)this.getResString("SALEINV_CANNOTVOUCHER"));
                SysUtil.abort();
            }
        }
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.initToolBar();
    }

    public void actionImportData_actionPerformed(ActionEvent arg0) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(arg0);
        this.tblMain.removeRows();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.saleinvoice";
        param.alias = SaleInvoiceUIUtil.getSaleInvResource("SaleInvoice");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionReverse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanReverse();
        if (0 == MsgBox.showConfirm2((Component)((Object)this), (String)SaleInvoiceUIUtil.getSaleInvResource("MSG_ConfirmReverse"))) {
            String[] ids = this.getSelectedListId();
            IObjectPK[] pks = new IObjectPK[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                pks[i] = new ObjectStringPK(ids[0]);
            }
            IObjectPK[] newPKs = SaleInvoiceFactory.getRemoteInstance().createReverseInv(pks);
            if (newPKs != null) {
                SaleInvoiceUIUtil.showSuccessMsg((ListUI)this, "MSG_ReverseSucces");
                this.actionRefresh_actionPerformed(null);
            }
            super.actionReverse_actionPerformed(e);
        }
    }

    private void checkCanReverse() throws Exception {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        ISaleInvoice isaleInvoice = SaleInvoiceFactory.getRemoteInstance();
        HashSet<BOSUuid> infoedIds = new HashSet<BOSUuid>();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                BizEnumValueInfo invStatus;
                String statuStr;
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                SaleInvoiceInfo saleInvoiceInfo = isaleInvoice.getSaleInvoiceInfo((IObjectPK)pk);
                if (saleInvoiceInfo.getReverseInvNumber() != null) {
                    MsgBox.showError((String)SaleInvoiceUIUtil.getSaleInvResource("Error_CantReverse_Reverseded"));
                    SysUtil.abort();
                }
                if (saleInvoiceInfo.isIsReversed()) {
                    MsgBox.showError((String)SaleInvoiceUIUtil.getSaleInvResource("Error_CantReverse_ReverseInv"));
                    SysUtil.abort();
                }
                if (!(statuStr = (String)(invStatus = (BizEnumValueInfo)row.getCell(TB_BASESTATUS).getValue()).getValue()).equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) {
                    MsgBox.showError((Component)((Object)this), (String)SaleInvoiceUIUtil.getSaleInvResource("Error_CantReverse_NotAudited"));
                    SysUtil.abort();
                }
                if (SaleUtil.isInvoiceCheckOffed(saleInvoiceInfo)) {
                    MsgBox.showError((String)SaleInvoiceUIUtil.getSaleInvResource("Error_CantReverse_Checkoffed"));
                    SysUtil.abort();
                }
                if (!saleInvoiceInfo.getBizType().getId().toString().equals("d8e80652-0111-1000-e000-04c5c0a812202407435C") || infoedIds.contains(saleInvoiceInfo.getId())) continue;
                MsgBox.showInfo((String)SaleInvoiceUIUtil.getSaleInvResource("MSG_ReverseDirectPurInv"));
                infoedIds.add(saleInvoiceInfo.getId());
            }
        }
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(TB_NUMBER));
        sic.add(new SelectorItemInfo(TB_EXCHANGERATE));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("localTotalTaxAmount"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("summary"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo(TB_TAXAMOUNT));
        sic.add(new SelectorItemInfo("entries.localTaxAmount"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.coreBillType.id"));
        sic.add(new SelectorItemInfo("entries.coreBillType.name"));
        sic.add(new SelectorItemInfo("entries.coreBillType.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo(TB_CUSTOMERNAME));
        sic.add(new SelectorItemInfo("customer.bankAccount"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo(TB_SALEORGNAME));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.person.number"));
        sic.add(new SelectorItemInfo("salePerson.person.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("cashDiscount.id"));
        sic.add(new SelectorItemInfo("cashDiscount.number"));
        sic.add(new SelectorItemInfo("cashDiscount.name"));
        return sic;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        this.initColPrecision(rowSet);
    }

    private void initColPrecision(IRowSet rowSet) {
        int amountPre = 2;
        int localAmountPre = 2;
        String[] QTY_COLUMNS = new String[]{TB_QTY, "entries.checkOffQty", "entries.nonCheckOffQty"};
        String[] BASEQTY_COLUMNS = new String[]{"entries.wittenOffBaseQty", "entries.unwriteOffBaseQty"};
        String[] ASSISQTY_COLUMNS = new String[]{TB_ASSISTQTY};
        String[] PRICE_COLUMNS = new String[]{TB_PRICE, TB_DEALPRICE, TB_TAXPRICE};
        String[] AMOUNT_COLUMNS = new String[]{TB_AMOUNT, TB_TAX, TB_TAXAMOUNT, "entries.checkOffAmount", "entries.nonCheckOffAmount"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{TB_LOCALAMOUNT, "entries.localUnwriteOffAmount", "entries.localWrittenOffAmount"};
        try {
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                localAmountPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])BASEQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])AMOUNT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)localAmountPre, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_QTY, "entries.checkoffQty", "entries.nonCheckoffQty", "entries.wittenOffBaseQty", "entries.unWriteOffBaseQty", TB_ASSISTQTY};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_PRICE, TB_DEALPRICE, TB_TAXPRICE};
    }

    protected void checkCanEdit(SCMBillBaseInfo billInfo) throws Exception {
        super.checkCanEdit(billInfo);
        SaleInvoiceInfo invInfo = (SaleInvoiceInfo)billInfo;
        if (invInfo != null && invInfo.isIsReversed()) {
            MsgBox.showError((Component)((Object)this), (String)SaleInvoiceUIUtil.getSaleInvResource("ReverseInv_CantBeEdited"));
            SysUtil.abort();
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        ISaleInvoice saleInvoice = SaleInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
        SaleInvoiceInfo saleinvInfo = saleInvoice.getSaleInvoiceInfo((IObjectPK)pk);
        return saleinvInfo.getCompanyOrgUnit();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.setButtonEnabledBySelectInfo();
    }

    private void setButtonEnabledBySelectInfo() throws Exception {
        this.setVoucherButtonEnabled();
        this.setCreateToButtonEnabled();
    }

    private void setVoucherButtonEnabled() throws Exception {
        SaleInvoiceInfo info = this.getSelectedSaleInvInfo();
        this.btnVoucher.setEnabled(false);
        this.btnDelVoucher.setEnabled(false);
        this.menuItemVoucher.setEnabled(false);
        this.menuItemDelVoucher.setEnabled(false);
        if (info != null && !SCMClientUtils.isBillInWf((SCMBillBaseInfo)info)) {
            if (this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString()) == null) {
                boolean isArScmRelate = false;
                isArScmRelate = SCMClientUtils.isARRelationSCM((CompanyOrgUnitInfo)info.getCompanyOrgUnit());
                this.companyOrgisArScmRelateMap.put(info.getCompanyOrgUnit().getId().toString(), new Boolean(isArScmRelate));
            }
            if (!((Boolean)this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString())).booleanValue()) {
                this.btnVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
        }
    }

    private void setCreateToButtonEnabled() throws Exception {
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        this.menuItemCreateTo.setEnabled(false);
        this.menuItemCreateTo.setVisible(false);
    }

    private SaleInvoiceInfo getSelectedSaleInvInfo() throws Exception {
        SaleInvoiceInfo saleInvoiceInfo = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        ISaleInvoice isaleInvoice = SaleInvoiceFactory.getRemoteInstance();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                saleInvoiceInfo = isaleInvoice.getSaleInvoiceInfo((IObjectPK)pk);
            }
        }
        return saleInvoiceInfo;
    }

    @Override
    public void actionTaxRelation_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.scm.sd.sale.client.TaxRelationList", this.getUIContext());
        window.show();
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceDown_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }
}

