/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleOrderForYHListUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderForYHQueryUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderListUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SaleOrderForYHListUI
extends AbstractSaleOrderForYHListUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderListUI.class);
    SaleOrderForYHQueryUI conditionPanel = null;
    private static final String TB_ENTQTY = "entries.qty";
    private static final String TB_ENTASSISTQTY = "entries.assistQty";
    private static final String TB_ENTPRICE = "entries.price";
    private static final String TB_ENTACTUALPRIC = "entries.actualPrice";
    private static final String TB_ENTACTUALTAXPRIC = "entries.actualTaxPrice";
    private static final String TB_ENTDISCOUNT = "entries.discount";
    private static final String TB_ENTAMOUNT = "entries.amount";
    private static final String TB_ENTLOCALAMOUNT = "entries.localAmount";
    private static final String TB_ENTTAXRATE = "entries.taxRate";
    private static final String TB_ENTTAXPRICE = "entries.taxPrice";
    private static final String TB_ENTTAX = "entries.tax";
    private static final String TB_ENTTAXAMOUNT = "entries.taxAmount";
    private static final String TB_ENTTOTALISSUEQTY = "entries.totalIssueQty";
    private static final String TB_ENTTOTALINVOICEDQTY = "entries.totalInvoicedQty";
    private static final String TB_ENTTOTALRETURNEDQTY = "entries.totalReturnedQty";
    private static final String TB_ENTTOTALSHIPPINGQTY = "entries.totalShippingQty";
    private static final String TB_ENTTOTALRECEIVEDQTY = "entries.totalReceivedAmount";
    private static String[] NUMBERTAB = new String[]{"entries.actualPrice", "entries.qty", "entries.assistQty", "entries.price", "entries.actualTaxPrice", "entries.discount", "entries.amount", "entries.localAmount", "entries.taxRate", "entries.taxPrice", "entries.tax", "entries.taxAmount", "entries.totalIssueQty", "entries.totalInvoicedQty", "entries.totalReturnedQty", "entries.totalShippingQty", "entries.totalReceivedAmount", "entries.totalArAmount"};
    private static final String TB_SALEORGUNITNAME = "saleOrgUnit.name";
    private static final String TB_NUMBER = "number";
    private static final String TB_BASESTATUS = "baseStatus";
    private static final String TB_BIZTYPENAME = "bizType.name";
    private static final String TB_BIZDATE = "bizDate";
    private static final String TB_CUSTOMER = "customerName";

    public SaleOrderForYHListUI() throws Exception {
        this.actionAudit.setBindWorkFlow(true);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return SaleOrderEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SaleOrderFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnIcon();
        this.setMainTableAlign();
        this.setMainTableFreeze();
        this.menuItemAudit.setVisible(false);
        this.btnAudit.setVisible(false);
        this.menuItemPerfromInstance.setEnabled(true);
        this.btnPerfromInstance.setEnabled(true);
        this.btnFreezed.setVisible(false);
        this.btnUnfreezed.setVisible(false);
        this.kdMenuVoucher.setVisible(false);
    }

    private void setMainTableFreeze() {
        this.tblMain.getViewManager().setFreezeView(0, 3);
    }

    private void initBtnIcon() {
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnFreezed.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnfreezed.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemAlert.setIcon(EASResource.getIcon((String)"imgTbtn_assetchangeinfo"));
        this.menuItemLockInv.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.menuItemUnLockInv.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuItemPerfromInstance.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnAudit.setEnabled(true);
        this.btnPerfromInstance.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnLockInv.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnLockInv.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{TB_SALEORGUNITNAME, TB_NUMBER, TB_BASESTATUS, TB_BIZTYPENAME, TB_BIZDATE, TB_CUSTOMER, "paymentType.name", "settlementType.name", "cashDiscount.cashDiscType", "currency.name", "exchangeRate"};
        return columns;
    }

    private void setMainTableAlign() {
        int num = NUMBERTAB.length;
        for (int i = 0; i < num; ++i) {
            this.tblMain.getColumn(NUMBERTAB[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_AUDIT")})));
            return;
        }
        super.actionAudit_actionPerformed(e);
        ISaleOrder iSaleOrder = SaleOrderFactory.getRemoteInstance();
        try {
            this.setOprtState("AUDIT");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iSaleOrder.audit(SCMUtils.convertStringToObjectPK((String[])selIDs));
            MsgBox.showInfo((String)SaleUtil.getUIResource("ORDER_AUDIT_SUCCESS"));
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleOrderForYHQueryUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleOrderForYHQueryUI();
        }
        return this.conditionPanel;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(TB_NUMBER));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo(TB_BIZTYPENAME));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo(TB_SALEORGUNITNAME));
        sic.add(new SelectorItemInfo("orderCustomer.id"));
        sic.add(new SelectorItemInfo("orderCustomer.number"));
        sic.add(new SelectorItemInfo("orderCustomer.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("totalTaxAmount"));
        sic.add(new SelectorItemInfo("transLeadTime"));
        sic.add(new SelectorItemInfo("customerOrderNumber"));
        sic.add(new SelectorItemInfo("deliveryType.id"));
        sic.add(new SelectorItemInfo("deliveryType.number"));
        sic.add(new SelectorItemInfo("deliveryType.name"));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.number"));
        sic.add(new SelectorItemInfo("salePerson.name"));
        sic.add(new SelectorItemInfo("salePerson.person.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo(TB_ENTQTY));
        sic.add(new SelectorItemInfo(TB_ENTPRICE));
        sic.add(new SelectorItemInfo(TB_ENTAMOUNT));
        sic.add(new SelectorItemInfo(TB_ENTTAXAMOUNT));
        sic.add(new SelectorItemInfo(TB_ENTACTUALPRIC));
        sic.add(new SelectorItemInfo("entries.deliveryDate"));
        sic.add(new SelectorItemInfo(TB_ENTTOTALSHIPPINGQTY));
        sic.add(new SelectorItemInfo("entries.sendDate"));
        sic.add(new SelectorItemInfo("entries.deliveryDate"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.id"));
        sic.add(new SelectorItemInfo("entries.warehouse.name"));
        sic.add(new SelectorItemInfo("entries.warehouse.number"));
        sic.add(new SelectorItemInfo("entries.warehouse.hasLocation"));
        sic.add(new SelectorItemInfo("entries.prepaymentRate"));
        sic.add(new SelectorItemInfo("entries.prepayment"));
        sic.add(new SelectorItemInfo("isIntax"));
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        return sic;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TB_BASESTATUS, (Object)"4"));
        return filter;
    }

    public void showAlertUI(ActionEvent e) throws Exception {
        IUIWindow uiWindow = this.getAlertUI(e);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    private IUIWindow getAlertUI(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, "ALERT") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "ALERT");
        return uiWindow;
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAlert_actionPerformed(ActionEvent e) throws Exception {
        super.actionAlert_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = super.getSelectedIdValues();
        ISaleOrder iSaleOrder = SaleOrderFactory.getRemoteInstance();
        try {
            this.setOprtState("ALTER");
            this.pubFireVOChangeListener(ids.get(0).toString());
            iSaleOrder.checkAlert((IObjectPK)new ObjectUuidPK(ids.get(0).toString()));
            this.showAlertUI(e);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_REVOKE")})));
            return;
        }
        super.actionRevoke_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleOrder iSaleOrder = SaleOrderFactory.getRemoteInstance();
        try {
            iSaleOrder.canRevoke(pks);
            this.setOprtState("REVOKE");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num2;
                if (reasonCodeInfo instanceof IObjectValue) {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iSaleOrder.revoke(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    String[] reasonCodeInfos = new String[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iSaleOrder.revoke(pks, reasonCodeInfos);
                }
            }
            this.showSuccessMsg("ORDER_REVOKE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_CLOSE")})));
            return;
        }
        this.checkLockQty(e);
        super.actionClose_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getRemoteInstance();
        try {
            iSaleOrderEntry.canHandleClose(pks);
            this.setOprtState("CLOSE");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num2;
                if (reasonCodeInfo instanceof IObjectValue) {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iSaleOrderEntry.handClose(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    String[] reasonCodeInfos = new String[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iSaleOrderEntry.handClose(pks, reasonCodeInfos);
                }
            }
            this.showStartReturn(e);
            this.showSuccessMsg("ORDER_CLOSE_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void showStartReturn(ActionEvent e) throws Exception {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        BizEnumValueInfo statusValue = null;
        BigDecimal prepaid = null;
        BigDecimal zero = new BigDecimal("0.00");
        BigDecimal totalIsUseQty = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = this.tblMain.getRow(j);
                if (row.getCell("entries.baseStatus").getValue() != null) {
                    statusValue = (BizEnumValueInfo)row.getCell("entries.baseStatus").getValue();
                    if (statusValue.getInt() != 4) {
                        return;
                    }
                } else {
                    return;
                }
                if (row.getCell("preReceived").getValue() != null) {
                    prepaid = new BigDecimal(row.getCell("preReceived").getValue().toString());
                    if (prepaid.compareTo(zero) <= 0) {
                        return;
                    }
                } else {
                    return;
                }
                if (row.getCell(TB_ENTTOTALISSUEQTY).getValue() == null || (totalIsUseQty = new BigDecimal(row.getCell(TB_ENTTOTALISSUEQTY).getValue().toString())).compareTo(zero) == 0) continue;
                return;
            }
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)SaleUtil.getUIResource("STARTRETURN")))) {
            this.actionCreateTo_actionPerformed(e);
        }
    }

    private void checkLockQty(ActionEvent e) throws Exception {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        BigDecimal loclQty = null;
        BigDecimal zero = new BigDecimal("0.00");
        BizEnumValueInfo statusValue = null;
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                IRow row = this.tblMain.getRow(j);
                if (row.getCell("entries.baseStatus").getValue() != null && (statusValue = (BizEnumValueInfo)row.getCell("entries.baseStatus").getValue()).getInt() != 4) {
                    return;
                }
                if (row.getCell("entries.lockQty").getValue() == null || (loclQty = (BigDecimal)row.getCell("entries.lockQty").getValue()).compareTo(zero) == 0) continue;
                MsgBox.showInfo((String)SaleUtil.getUIResource("ORDER_HAVELOCKQTY"));
                SysUtil.abort();
            }
        }
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(SaleUtil.getUIResource(msgResource));
        this.showMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFreezed_actionPerformed(ActionEvent e) throws Exception {
        super.actionFreezed_actionPerformed(e);
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_FREEZED")})));
            return;
        }
        super.actionFreezed_actionPerformed(e);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getRemoteInstance();
        try {
            this.setOprtState("FREEZED");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iSaleOrderEntry.canFreezed(pks);
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int num2;
                if (reasonCodeInfo instanceof IObjectValue) {
                    ReasonCodeInfo[] reasonCodeInfos = new ReasonCodeInfo[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (ReasonCodeInfo)reasonCodeInfo;
                    }
                    iSaleOrderEntry.freezed(pks, (IObjectValue[])reasonCodeInfos);
                }
                if (reasonCodeInfo instanceof String) {
                    String[] reasonCodeInfos = new String[selIDs.length];
                    num2 = selIDs.length;
                    for (i = 0; i < num2; ++i) {
                        reasonCodeInfos[i] = (String)reasonCodeInfo;
                    }
                    iSaleOrderEntry.freezed(pks, reasonCodeInfos);
                }
            }
            this.showSuccessMsg("ORDER_FREEZED_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnfreezed_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnfreezed_actionPerformed(e);
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_UNFREEZED")})));
            return;
        }
        super.actionUnfreezed_actionPerformed(e);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getRemoteInstance();
        try {
            this.setOprtState("UNFREEZED");
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iSaleOrderEntry.unFreezed(SCMUtils.convertStringToObjectPK((String[])selIDs));
            this.showSuccessMsg("ORDER_UNFREEZED_SUCCESS");
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int ratePre = 2;
        int currencyPre = 2;
        BizEnumValueInfo discountTypeValue = null;
        String[] QTY_COLUMNS = new String[]{TB_ENTQTY, TB_ENTTOTALRETURNEDQTY, TB_ENTTOTALISSUEQTY, TB_ENTTOTALINVOICEDQTY, TB_ENTTOTALSHIPPINGQTY, TB_ENTTOTALRECEIVEDQTY};
        String[] PRICE_COLUMNS = new String[]{TB_ENTPRICE, TB_ENTACTUALTAXPRIC, TB_ENTACTUALPRIC, TB_ENTTAXPRICE};
        String[] ASSISQTY_COLUMNS = new String[]{TB_ENTASSISTQTY};
        String[] RATE_COLUMNS = new String[]{TB_ENTTAXRATE};
        String[] CURRENCY_COLUMNS = new String[]{TB_ENTAMOUNT, TB_ENTLOCALAMOUNT, TB_ENTTAX, TB_ENTTAXAMOUNT, TB_ENTTOTALRECEIVEDQTY, "entries.totalArAmount"};
        String[] EXCHANGE_COLUMNS = new String[]{"exchangeRate"};
        try {
            while (rowSet.next()) {
                currencyPre = rowSet.getInt("currency.precision");
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)ratePre, (String[])RATE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)currencyPre, (String[])CURRENCY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)8, (String[])EXCHANGE_COLUMNS, (IRowSet)rowSet);
                discountTypeValue = (BizEnumValueInfo)rowSet.getObject("entries.discountType");
                if (discountTypeValue != null && discountTypeValue == null) {
                    SCMClientUtils.iniColumnsPrecision((int)4, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
                    continue;
                }
                if (discountTypeValue != null && discountTypeValue.getInt() == 0) {
                    SCMClientUtils.iniColumnsPrecision((int)4, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
                    continue;
                }
                int pricePre = rowSet.getInt("material.pricePrecision");
                SCMClientUtils.iniColumnsPrecision((int)pricePre, (String)TB_ENTDISCOUNT, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{TB_ENTQTY, TB_ENTTOTALRETURNEDQTY, TB_ENTTOTALISSUEQTY, TB_ENTTOTALINVOICEDQTY, TB_ENTTOTALSHIPPINGQTY, TB_ENTTOTALRECEIVEDQTY, TB_ENTASSISTQTY};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{TB_ENTPRICE, TB_ENTACTUALTAXPRIC, TB_ENTACTUALPRIC, TB_ENTTAXPRICE};
    }

    public String[] getAmountColumns() {
        return new String[]{TB_ENTAMOUNT, TB_ENTLOCALAMOUNT, TB_ENTTAX, TB_ENTTAXAMOUNT, TB_ENTTOTALRECEIVEDQTY, TB_ENTTAXRATE, TB_ENTDISCOUNT, "entries.totalArAmount"};
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.SaleOrder";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionPerfromInstance_actionPerformed(ActionEvent e) throws Exception {
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"queryType", (Object)"sale");
        uiContext.put((Object)"idList", (Object)SaleOrderForYHListUI.convertStringToArrayList(selIDs));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sm.report.client.PurPerformInstanceUI", (Map)uiContext, null);
        window.show();
    }

    @Override
    public void actionLockInv_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"idList", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"lockType", (Object)"lock");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sd.sale.client.SaleOrderLockUI", (Map)uiContext, null);
        window.show();
        this.refreshList();
    }

    @Override
    public void actionUnLockInv_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        if (selIDs == null) {
            this.handleException((Exception)new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, (Object[])new String[]{""}));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"idList", (Object)SCMUtils.convertStringToObjectPK((String[])selIDs));
        uiContext.put((Object)"lockType", (Object)"unlock");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create("com.kingdee.eas.scm.sd.sale.client.SaleOrderLockUI", (Map)uiContext, null);
        window.show();
        this.refreshList();
    }

    public static ArrayList convertStringToArrayList(String[] pkStrs) {
        if (pkStrs == null || pkStrs.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int num = pkStrs.length;
        for (int i = 0; i < num; ++i) {
            list.add(pkStrs[i]);
        }
        return list;
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceDown_actionPerformed(e);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleOrderInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return "companyOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        return filterInfo;
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        FilterInfo bizFilterInfo = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && botpMap.get("DESTBILLTYPE.ID") != null && (billTypeId = botpMap.get("DESTBILLTYPE.ID").toString()) != null && billTypeId.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            int i;
            bizFilterInfo = new FilterInfo();
            PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)botpMap.get("MAINBIZORG");
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
            OrgUnitCollection saleCollection = null;
            CompanyOrgUnitInfo comOrgInfo = null;
            OrgUnitCollection storageCollection = null;
            try {
                OrgUnitCollection collection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Purchase, (OrgType)OrgType.Company, (BOSUuid)purOrgInfo.getId());
                if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
                    comOrgInfo = (CompanyOrgUnitInfo)collection.get(0);
                }
                if (comOrgInfo != null) {
                    saleCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Company, (OrgType)OrgType.Sale, (BOSUuid)comOrgInfo.getId());
                }
                storageCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Purchase, (OrgType)OrgType.Storage, (BOSUuid)purOrgInfo.getId());
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            StringBuffer saleOrgIdBuffer = new StringBuffer();
            StringBuffer storageOrgIdBuffer = new StringBuffer();
            if (saleCollection != null) {
                for (i = 0; i < saleCollection.size(); ++i) {
                    if (!(saleCollection.get(i) instanceof SaleOrgUnitInfo)) continue;
                    if (saleOrgIdBuffer.length() > 0) {
                        saleOrgIdBuffer.append(",");
                    }
                    saleOrgIdBuffer.append("'");
                    saleOrgIdBuffer.append(saleCollection.get(i).getId().toString());
                    saleOrgIdBuffer.append("'");
                }
            }
            if (storageCollection != null) {
                for (i = 0; i < storageCollection.size(); ++i) {
                    if (!(storageCollection.get(i) instanceof StorageOrgUnitInfo)) continue;
                    if (storageOrgIdBuffer.length() > 0) {
                        storageOrgIdBuffer.append(",");
                    }
                    storageOrgIdBuffer.append("'");
                    storageOrgIdBuffer.append(storageCollection.get(i).getId().toString());
                    storageOrgIdBuffer.append("'");
                }
            }
            if (saleOrgIdBuffer.length() <= 0) {
                saleOrgIdBuffer.append("'").append("'");
            }
            if (storageOrgIdBuffer.length() <= 0) {
                storageOrgIdBuffer.append("'").append("'");
            }
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", null, CompareType.EQUALS));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgIdBuffer.toString(), CompareType.INNER));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.EQUALS));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgIdBuffer.toString(), CompareType.INNER));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("entries.isBySaleOrder", (Object)String.valueOf(true), CompareType.EQUALS));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.NOTEQUALS));
            if (comOrgInfo != null) {
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)comOrgInfo.getId().toString(), CompareType.EQUALS));
            }
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("entries.isBySaleOrder", (Object)String.valueOf(false), CompareType.EQUALS));
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)"d8e80652-0111-1000-e000-04c5c0a812202407435C", CompareType.NOTEQUALS));
            bizFilterInfo.setMaskString("(#0 or #1) and ((#2 and #3) or ( #4 and #5 and #6) or (#7 and #8 and #9))");
            OrgType srcType = this.getMainBizOrgType();
            String srcOrgProp = this.getPropertyOfBizOrg(srcType);
            OrgUnitCollection collection = null;
            ISCMBillBase iBiz = null;
            if (srcType.equals((Object)destType)) {
                this.getUIContext().put(this.getMainBizOrgType(), (OrgUnitInfo)botpMap.get("MAINBIZORG"));
                this.initUIMainOrgContext(destOrgId);
            } else if (srcOrgProp != null) {
                try {
                    iBiz = (ISCMBillBase)this.getBizInterface();
                    collection = iBiz.getAuthOrgsByRelation(destType, srcType, destOrgId, this.mainQueryPK);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (null != collection && collection.size() > 0) {
                    this.getUIContext().put(this.getMainBizOrgType(), collection.get(0));
                    this.initUIMainOrgContext(collection.get(0).getId().toString());
                }
            }
        }
        return bizFilterInfo;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        String purOrderType = new PurOrderInfo().getBOSType().toString();
        destBosTypeList.remove(purOrderType);
        return destBosTypeList;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"UIClassParam", (Object)"isSCMBill");
        uiContext.put((Object)"HideMenuToolBar", (Object)"isHideMenuToolBar");
        super.prepareUIContext(uiContext, e);
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }
}

