/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.ISCMBillStatusControl;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonF7KDTableListener;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleOrderForYHQueryUI;
import com.kingdee.eas.scm.sd.sale.client.SaleOrderQueryUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class SaleOrderForYHQueryUI
extends AbstractSaleOrderForYHQueryUI
implements ISCMBillStatusControl {
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderQueryUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.client.SaleResource";
    private static final String permItem = "saleorder_view";
    private SCMRptMultiOrgsF7 f7;

    public SaleOrderForYHQueryUI() throws Exception {
        this.isReport = true;
        this.f7 = new SCMRptMultiOrgsF7(this.prmtSaleOrgUnitFrom, OrgType.Sale, permItem, EASResource.getString((String)resClassName, (String)"SaleOrgUnitMutilF7"));
        this.f7.setUseCache(false);
        this.setBizTypeF7(this.prmtBizTypeTo);
        SCMQueryFormat.formatBillStatus((ISCMBillStatusControl)this, (KDComboBox)this.combStatus);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)this.prmtSalePersonFrom);
        this.initF7Control();
        this.setSaleGroupF7(this.prmtSaleGroupTo);
        this.setSaleOrderF7(this.prmtNumFrom);
        this.setSaleOrderF7(this.prmtNumTo);
        this.setBizCustomerF7(this.prmtCustomerNumFrom, null);
        this.setBizCustomerF7(this.prmtCustomerNumTo, null);
        this.setBizMaterialF7(this.prmtMaterialNumFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialNumTo, false, null);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement element = new RangeFilterElement("bizDate", (Component)this.pkBizDateFrom, (Component)this.pkBizDateTo);
        element.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        element.setDefaultValue((Object)new Timestamp[]{SCMUtils.getSCMQueryTime(null, (String)"startDate"), SCMUtils.getSCMQueryTime(null, (String)"endDate")});
        elements.add((FilterElement)element);
        elements.add((FilterElement)new RangeFilterElement("bizType.number", (Component)this.prmtBizTypeFrom, (Component)this.prmtBizTypeTo));
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumFrom, (Component)this.prmtNumTo));
        elements.add((FilterElement)new RangeFilterElement("orderCustomer.number", (Component)this.prmtCustomerNumFrom, (Component)this.prmtCustomerNumTo));
        elements.add((FilterElement)new RangeFilterElement("material.number", (Component)this.prmtMaterialNumFrom, (Component)this.prmtMaterialNumTo));
        elements.add((FilterElement)new RangeFilterElement("salePerson.number", (Component)this.prmtSalePersonFrom, (Component)this.prmtSalePersonTo));
        elements.add((FilterElement)new RangeFilterElement("saleGroup.number", (Component)this.prmtSaleGroupFrom, (Component)this.prmtSaleGroupTo));
        SingleFilterElement mainOrgElement = new SingleFilterElement("saleOrgUnit.number", (Component)this.prmtSaleOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"SALEORGNOTNULL")));
        mainOrgElement.setExclude(true);
        elements.add((FilterElement)mainOrgElement);
        elements.setExclude(true);
        elements.add((FilterElement)new SingleFilterElement("baseStatus", (Component)this.combStatus, (Object)BillBaseStatusEnum.NULL));
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "saleOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtCustomerNumFrom, this.prmtCustomerNumTo, this.prmtMaterialNumFrom, this.prmtCustomerNumTo});
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setSaleOrderF7(KDBizPromptBox prmtSaleOrder) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizedSaleOrg((String)"saleOrgUnit.id"));
        prmtSaleOrder.setEntityViewInfo(viewInfo);
        prmtSaleOrder.addCommonF7KDTableListener((CommonF7KDTableListener)new SCMCommonF7KDTableListener("baseStatus"));
    }

    private void setSalePersonF7(KDBizPromptBox prmtSalePerson) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizedSaleOrg((String)"saleOrg.id"));
        prmtSalePerson.setEntityViewInfo(viewInfo);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)prmtSalePerson);
    }

    private void setSaleGroupF7(KDBizPromptBox prmtSaleGroup) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(SCMClientUtils.getF7FilterInfoByAuthorizedSaleOrg((String)"saleOrg.id"));
        prmtSaleGroup.setEntityViewInfo(viewInfo);
    }

    protected void setBizTypeF7(KDBizPromptBox bizPrompt) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"310", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        bizPrompt.setEntityViewInfo(viewInfo);
    }

    public Object[] getUnVisibleBillStatus() {
        return new Object[]{BillBaseStatusEnum.ADD, BillBaseStatusEnum.RELEASED};
    }

    public Object[] getAdditiveBillStatus() {
        return null;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSaleOrgUnitFrom;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getViewPermission() {
        return permItem;
    }

    private void initF7Control() {
        Object selectorMaterialFromLisenter = null;
        Object selectorMaterialToLisenter = null;
        try {
            this.prmtSaleOrgUnitFrom.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    public void afterMainOrgChanged(String ids) {
        this.prmtNumFrom.setEntityViewInfo(super.setEntityViewInfo(SCMClientUtils.getF7FilterInfoByAuthorizedSaleOrg((String)"saleOrgUnit.id"), "saleOrgUnit.id", ids));
        this.prmtNumTo.setEntityViewInfo(super.setEntityViewInfo(SCMClientUtils.getF7FilterInfoByAuthorizedSaleOrg((String)"saleOrgUnit.id"), "saleOrgUnit.id", ids));
        this.prmtSaleGroupFrom.setEntityViewInfo(super.setEntityViewInfo(null, "saleOrg.id", ids));
        this.prmtSaleGroupTo.setEntityViewInfo(super.setEntityViewInfo(null, "saleOrg.id", ids));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        String ids = null;
        Object[] results = (Object[])this.f7.getFullData();
        if (results == null || results.length == 0) {
            results = null;
            results = this.getMainBizOrgs().toArray();
        }
        if ((ids = this.getOrgListId(results)) != null) {
            FilterInfo thisinfo = new FilterInfo();
            thisinfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)ids, CompareType.INCLUDE));
            try {
                if (filter == null) {
                    filter = thisinfo;
                } else {
                    filter.mergeFilter(thisinfo, "AND");
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    private String getOrgListId(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Integer fisleaf = (Integer)((OrgUnitInfo)infos[i]).get("isleaf");
            if (fisleaf != 1) continue;
            OrgunitId.append("," + ((OrgUnitInfo)infos[i]).getId().toString());
        }
        String orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    public void clear() {
        this.getMainBizOrgF7().setData(null);
        super.clear();
    }
}

