/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextIconRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.ILockInventory;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.LockInventoryCollection;
import com.kingdee.eas.scm.im.inv.LockInventoryFactory;
import com.kingdee.eas.scm.im.inv.LockInventoryInfo;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleLockOrderRuleEnum;
import com.kingdee.eas.scm.sd.sale.SaleLockUIEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleOrderLockUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class SaleOrderLockUI
extends AbstractSaleOrderLockUI {
    private static final long serialVersionUID = 3396634849433382450L;
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderLockUI.class);
    private static final String[] QTYPRECISIONFROMUNITTAB = new String[]{"FQty", "FCanLockQty", "FLockQty", "FLockAssistQty"};
    private static final String[] QTYPRECISIONFROMUNITTAB2 = new String[]{"FCurQty", "FCurLockQty"};
    private static final String[] QTYPRECISIONFORSALEQTY = new String[]{"FSaleQty", "FSaleLockQty"};
    private static final String[] QTYPRECISIONFORBASEQTY = new String[]{"FBaseQty", "FBaseLockQty"};
    private static final String[] QTYPRECISIONFROMBASEUNITTAB = new String[]{"FLockBaseQty", "FCanLockBaseQty"};
    private static final String CONFIGTYPEKEY = "orderRule";
    private KDTEditAdapter entryTableChange = null;
    private HashMap LockMap = new HashMap();
    private static final String[][] UNNEGATIVEDTAB = new String[][]{{"FCurLockQty", ">="}, {"FSaleLockQty", ">="}, {"FBaseLockQty", ">="}};
    private ItemListener cbProxyListener = null;
    private boolean isFirst = true;
    private BigDecimal ZERO = new BigDecimal("0.00");
    private SCMLockInvDataVO resultVO = null;
    private BigDecimal curLockAssQty = new BigDecimal("0.00");
    private DataChangeListener prmtWareHouseChange = null;
    private Map storageOrgUnitMap = new HashMap();
    public static final String BILLID = "FBillID";
    public static final String BILLENTRYID = "FBillEntryID";
    public static final String INVENTORYID = "FInventoryID";
    public static final String BILLNUMBER = "FBillNumber";
    public static final String BILLTYPEID = "FBillTypeID";
    public static final String WAREHOUSEID = "FWarehouseID";
    public static final String LOCATIONID = "FLocationID";
    public static final String LOT = "Flot";
    public static final String STORETYPEID = "FStoreTypeID";
    public static final String STORESTATEID = "FStoreStateID";
    public static final String LOCKQTY = "FLockQty";
    public static final String LOCKORDERQTY = "FLockOrderQty";
    public static final String LOCKBASEQTY = "FLockBaseQty";
    public static final String LOCKASSISTQTY = "FLockAssistQty";
    public static final String UNLOCKDATE = "FUnLockDate";
    public static final String PROJECTID = "FProjectID";
    public static final String TRACKNUMBER = "FTrackNumberID";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblOrder.checkParsed();
        this.btnLock.setEnabled(true);
        this.btnUnLock.setEnabled(true);
        this.btnLock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.tblLock.getActionMap().remove("Delete");
        this.tblOrder.getActionMap().remove("Delete");
        this.addcbProxyListen();
        this.cbProxy.setVisible(false);
        this.registerWarehouseF7(null);
        this.initChangeListener();
        String orderRule = this.getCurrentOrderRule();
        if (orderRule != null && orderRule.equals("0")) {
            this.comboOrderRule.setSelectedItem((Object)SaleLockOrderRuleEnum.WAREHOUSE);
        } else if (orderRule != null && orderRule.equals("1")) {
            this.comboOrderRule.setSelectedItem((Object)SaleLockOrderRuleEnum.LOT);
        }
        this.btnAllClear.setEnabled(true);
        this.btnAllSelect.setEnabled(true);
        this.btnBatchLock.setEnabled(true);
        this.btnBatchLock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        KDCheckBox cbIsBatchLock = new KDCheckBox();
        this.tblOrder.getColumn("isBatchLock").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)cbIsBatchLock));
        int length = this.tblOrder.getColumnCount();
        for (int i = 1; i < length; ++i) {
            this.tblOrder.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    private void registerWarehouseF7(StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        if (storageOrgUnitInfo == null) {
            if (this.tblOrder != null && this.tblOrder.getRowCount() > 0) {
                String storageOrgUnitId = (String)this.tblOrder.getRow(0).getCell("storageOrgUnit").getValue();
                if (this.storageOrgUnitMap.get(storageOrgUnitId) != null) {
                    storageOrgUnitInfo = (StorageOrgUnitInfo)this.storageOrgUnitMap.get(storageOrgUnitId);
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitId), sic);
                }
            } else {
                return;
            }
        }
        if (storageOrgUnitInfo != null) {
            this.prmtWareHouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
            this.prmtWareHouse.setEntityViewInfo(SCMClientUtils.getWarehouseFilter((StorageOrgUnitInfo)storageOrgUnitInfo, (int)-1));
        }
    }

    private void initChangeListener() {
        this.prmtWareHouseChange = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleOrderLockUI.this.prmtWareHouse_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleOrderLockUI.this.handUIException(exc);
                }
            }
        };
        this.prmtWareHouse.addDataChangeListener(this.prmtWareHouseChange);
    }

    protected void prmtWareHouse_dataChanged(DataChangeEvent e) throws Exception {
        WarehouseInfo warehouseInfo = (WarehouseInfo)this.prmtWareHouse.getValue();
        if (warehouseInfo == null) {
            return;
        }
        String warehouseId = warehouseInfo.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)warehouseId, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        this.prmtLocation.setEntityViewInfo(view);
    }

    protected void cbProxy_stateChanged(ItemEvent e) throws Exception {
        this.tableValueChanged(this.tblLock.getSelectManager().getActiveRowIndex(), 0);
    }

    @Override
    public void loadFields() {
        this.handleBtnEnable(0);
    }

    public void onShow() throws Exception {
        this.tblLock.removeKDTEditListener((KDTEditListener)this.entryTableChange);
        super.onShow();
        this.LockMap = new HashMap();
        this.tblOrder.getSelectManager().setSelectMode(2);
        SCMClientHelper scmClientHelper = new SCMClientHelper((CoreUIObject)this);
        scmClientHelper.validQtyCell(this.tblLock, UNNEGATIVEDTAB);
        String lockType = this.getUIContext().get("lockType").toString();
        if (lockType.equals("lock")) {
            this.tblOrderInsertRows(1);
            this.combLockMaterial.setSelectedIndex(0);
        } else {
            this.tblOrderInsertRows(2);
            this.tblOrder.getSelectManager().setSelectMode(10);
            this.combLockMaterial.setSelectedIndex(1);
        }
        this.initKDTListener();
        this.cbProxy.addItemListener(this.cbProxyListener);
        this.tblOrder.getColumn("FAssitQty").getStyleAttributes().setHided(false);
        this.tblOrder.getColumn("FAssUnit").getStyleAttributes().setHided(false);
    }

    private void initKDTListener() {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BigDecimal baseQty;
                    BigDecimal saleQty;
                    BigDecimal curLockQty;
                    int active_row_index = SaleOrderLockUI.this.tblOrder.getSelectManager().getActiveRowIndex();
                    IRow activeRow = SaleOrderLockUI.this.tblOrder.getRow(active_row_index);
                    MaterialInfo aMaterialInfo = (MaterialInfo)activeRow.getCell("FMaterialNum").getUserObject();
                    String materialID = aMaterialInfo.getId().toString();
                    int rowIndex = e.getRowIndex();
                    int colIndex = e.getColIndex();
                    MeasureUnitInfo lockUnitInfo = (MeasureUnitInfo)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FUnit").getUserObject();
                    MeasureUnitInfo lockBaseUnitInfo = (MeasureUnitInfo)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FBaseUnit").getUserObject();
                    MeasureUnitInfo lockSaleUnitInfo = (MeasureUnitInfo)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FSaleUnit").getUserObject();
                    if ("FCurLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey())) {
                        curLockQty = (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").getValue();
                        saleQty = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockUnitInfo, lockSaleUnitInfo, curLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FSaleLockQty").setValue((Object)saleQty);
                        baseQty = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockUnitInfo, lockBaseUnitInfo, curLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FBaseLockQty").setValue((Object)baseQty);
                    }
                    if ("FSaleLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey())) {
                        BigDecimal curSaleLockQty = (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FSaleLockQty").getValue();
                        BigDecimal curLockQty2 = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockSaleUnitInfo, lockUnitInfo, curSaleLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").setValue((Object)curLockQty2);
                        baseQty = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockSaleUnitInfo, lockBaseUnitInfo, curSaleLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FBaseLockQty").setValue((Object)baseQty);
                    }
                    if ("FBaseLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey())) {
                        BigDecimal curBaseLockQty = (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FBaseLockQty").getValue();
                        saleQty = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockSaleUnitInfo, lockSaleUnitInfo, curBaseLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FSaleLockQty").setValue((Object)saleQty);
                        BigDecimal curLockQty3 = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockSaleUnitInfo, lockUnitInfo, curBaseLockQty);
                        SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").setValue((Object)curLockQty3);
                    }
                    if ("FCurLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey()) || "FSaleLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey()) || "FBaseLockQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey())) {
                        curLockQty = (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").getValue();
                        BigDecimal curQty = (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurQty").getValue();
                        if (curLockQty != null && curQty != null && curLockQty.compareTo(curQty) == 1) {
                            BigDecimal oldCurLockQty = e.getOldValue() == null ? SaleOrderLockUI.this.ZERO : (BigDecimal)e.getOldValue();
                            SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").setValue(e.getOldValue());
                            BigDecimal saleQty2 = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockUnitInfo, lockSaleUnitInfo, oldCurLockQty);
                            SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FSaleLockQty").setValue((Object)saleQty2);
                            BigDecimal baseQty2 = SaleOrderLockUI.this.getExchangeQtyForClient(materialID, lockUnitInfo, lockBaseUnitInfo, oldCurLockQty);
                            SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FBaseLockQty").setValue((Object)baseQty2);
                        }
                        if (curLockQty != null && curLockQty.toString().trim().length() > 0 && SaleOrderLockUI.this.tblOrder.getRow(active_row_index).getCell("FAssUnit").getValue() != null) {
                            if (curLockQty.compareTo(SaleOrderLockUI.this.ZERO) > 0) {
                                SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getStyleAttributes().setLocked(false);
                                boolean isSelect = false;
                                if (SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("select").getValue() != null) {
                                    isSelect = (Boolean)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("select").getValue();
                                }
                                BigDecimal lockAssQty = SaleOrderLockUI.this.ZERO;
                                if (isSelect) {
                                    int assUnitscale = 2;
                                    if (SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getEditor() != null) {
                                        assUnitscale = ((KDFormattedTextField)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getEditor().getComponent()).getPrecision();
                                    }
                                    lockAssQty = SaleOrderLockUI.this.calEntryBaseQty(SaleOrderLockUI.this.tblOrder, SaleOrderLockUI.this.tblLock, active_row_index, rowIndex, "FAssUnit", "FCanLockBaseQty", (BigDecimal)SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockQty").getValue(), "FUnit", active_row_index, assUnitscale);
                                    SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").setValue((Object)lockAssQty);
                                }
                            } else {
                                SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getStyleAttributes().setLocked(true);
                                SaleOrderLockUI.this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").setValue((Object)SaleOrderLockUI.this.curLockAssQty);
                            }
                        }
                        SaleOrderLockUI.this.updateCurLockQtyTotal(SaleOrderLockUI.this.tblOrder.getSelectManager().getActiveRowIndex());
                    } else if ("FCurLockAssQty".equals(SaleOrderLockUI.this.tblLock.getColumn(colIndex).getKey())) {
                        SaleOrderLockUI.this.updateCurLockQtyTotal(SaleOrderLockUI.this.tblOrder.getSelectManager().getActiveRowIndex());
                    }
                }
                catch (EASBizException exc) {
                    SaleOrderLockUI.this.handUIException(exc);
                }
                catch (BOSException exc) {
                    SaleOrderLockUI.this.handUIException(exc);
                }
            }
        };
        this.tblLock.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    private void tblOrderInsertRows(int comValue) throws Exception {
        this.tblOrder.removeRows();
        IObjectPK[] idList = (IObjectPK[])this.getUIContext().get("idList");
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setIdList(idList);
        vo.setTableNether(false);
        vo.setType("top");
        this.resultVO = SCMGroupFacadeFactory.getRemoteInstance().loadSaleLockInvData(vo);
        String seq = "";
        String pSeorderNumber = "";
        boolean NumberIsVisible = true;
        CellTextIconRender LockRender = new CellTextIconRender();
        LockRender.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        CellTextIconRender UnLockRender = new CellTextIconRender();
        UnLockRender.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        boolean isLock = false;
        int negative = 0;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        Map infoMap = this.resultVO.getInfoMap();
        Map entryInfoMap = this.resultVO.getEntryInfoMap();
        Map materialMap = this.resultVO.getMaterialMap();
        Map materialInvMap = this.resultVO.getMaterialInvMap();
        Map baseUnitMap = this.resultVO.getBaseUnitMap();
        Map asstUnitMap = this.resultVO.getAsstUnitMap();
        Map unitMap = this.resultVO.getUnitMap();
        Map assitAttrMap = this.resultVO.getAssitAttrMap();
        Map projectMap = this.resultVO.getProjectMap();
        Map trackNumberMap = this.resultVO.getTrackNumberMap();
        Map wareHouseMap = this.resultVO.getWareHouseMap();
        int num = idList.length;
        for (int i = 0; i < num; ++i) {
            SaleOrderEntryInfo saleOrderEntryInfo = (SaleOrderEntryInfo)entryInfoMap.get(idList[i].toString());
            if (saleOrderEntryInfo == null) continue;
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)infoMap.get(idList[i].toString());
            if (saleOrderEntryInfo.getMaterial() == null) continue;
            MaterialInfo materialInfo = (MaterialInfo)materialMap.get(idList[i].toString());
            if (!saleOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || saleOrderEntryInfo.getStorageOrgUnit() == null) continue;
            MaterialInventoryInfo materialInventoryInfo = (MaterialInventoryInfo)materialInvMap.get(idList[i].toString() + materialInfo.getId().toString());
            if (materialInventoryInfo != null && materialInventoryInfo.isIsNegative()) {
                ++negative;
                continue;
            }
            if (saleOrderEntryInfo.getBaseStatus().getValue() != 4) continue;
            isLock = false;
            isLock = saleOrderEntryInfo.isIsLocked();
            if (comValue == 1 && isLock || comValue == 2 && !isLock) continue;
            IRow newRow = this.tblOrder.addRow();
            if (!isLock) {
                this.tblOrder.getRow(this.tblOrder.getRowCount() - 1).getCell("isBatchLock").setValue((Object)new Boolean(true));
                this.tblOrder.getRow(this.tblOrder.getRowCount() - 1).getCell("isBatchLock").getStyleAttributes().setLocked(false);
            } else {
                this.tblOrder.getRow(this.tblOrder.getRowCount() - 1).getCell("isBatchLock").setValue((Object)new Boolean(false));
                this.tblOrder.getRow(this.tblOrder.getRowCount() - 1).getCell("isBatchLock").getStyleAttributes().setLocked(true);
            }
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)unitMap.get(idList[i].toString());
            MeasureUnitInfo measureBaseUnitInfo = (MeasureUnitInfo)baseUnitMap.get(idList[i].toString());
            MeasureUnitInfo measureAssUnitInfo = null;
            if (saleOrderEntryInfo.getAssistUnit() != null) {
                measureAssUnitInfo = (MeasureUnitInfo)asstUnitMap.get(idList[i].toString());
            }
            if (saleOrderEntryInfo.getAssistQty() != null) {
                newRow.getCell("FAssitQty").setValue((Object)saleOrderEntryInfo.getAssistQty());
            }
            AsstAttrValueInfo asstAttrValueInfo = null;
            if (saleOrderEntryInfo.getAssistProperty() != null) {
                asstAttrValueInfo = (AsstAttrValueInfo)assitAttrMap.get(idList[i].toString());
            }
            WarehouseInfo warehouseInfo = null;
            if (saleOrderEntryInfo.getWarehouse() != null) {
                warehouseInfo = (WarehouseInfo)wareHouseMap.get(idList[i].toString());
            }
            ProjectInfo projectInfo = null;
            if (saleOrderEntryInfo.getProject() != null) {
                projectInfo = (ProjectInfo)projectMap.get(idList[i].toString());
            }
            TrackNumberInfo TrackNumberInfo2 = null;
            if (saleOrderEntryInfo.getTrackNumber() != null) {
                TrackNumberInfo2 = (TrackNumberInfo)trackNumberMap.get(idList[i].toString());
            }
            newRow.getCell("FNumber").setValue((Object)saleOrderInfo.getNumber());
            seq = "" + saleOrderEntryInfo.getSeq();
            newRow.getCell("FSeq").setValue((Object)seq);
            newRow.getCell("FEntryID").setValue((Object)saleOrderEntryInfo.getId());
            newRow.getCell("id").setValue((Object)saleOrderInfo.getId());
            if (materialInfo != null) {
                newRow.getCell("FMaterialNum").setValue((Object)materialInfo.getNumber());
                newRow.getCell("FMaterialNum").setUserObject((Object)materialInfo);
                newRow.getCell("FMaterialName").setValue((Object)materialInfo.getName());
                newRow.getCell("FModel").setValue((Object)materialInfo.getModel());
            }
            if (asstAttrValueInfo != null) {
                newRow.getCell("FAss").setValue((Object)asstAttrValueInfo.getName());
                newRow.getCell("FAss").setUserObject((Object)asstAttrValueInfo);
            }
            if (measureUnitInfo != null) {
                newRow.getCell("FUnit").setUserObject((Object)measureUnitInfo);
                newRow.getCell("FUnit").setValue((Object)measureUnitInfo.getName());
            }
            if (measureBaseUnitInfo != null) {
                newRow.getCell("FBaseUnit").setUserObject((Object)measureBaseUnitInfo);
                newRow.getCell("FBaseUnit").setValue((Object)measureBaseUnitInfo.getName());
            }
            if (measureAssUnitInfo != null) {
                newRow.getCell("FAssUnit").setUserObject((Object)measureAssUnitInfo);
                newRow.getCell("FAssUnit").setValue((Object)measureAssUnitInfo.getName());
            }
            if (saleOrderEntryInfo.getQty() != null) {
                newRow.getCell("FQty").setValue((Object)saleOrderEntryInfo.getQty());
            }
            if (saleOrderEntryInfo.getLockQty() != null) {
                newRow.getCell(LOCKQTY).setValue((Object)saleOrderEntryInfo.getLockQty());
            }
            if (saleOrderEntryInfo.getLockAssistQty() != null) {
                newRow.getCell(LOCKASSISTQTY).setValue((Object)saleOrderEntryInfo.getLockAssistQty());
            }
            if (saleOrderEntryInfo.getLockBaseQty() != null) {
                newRow.getCell(LOCKBASEQTY).setValue((Object)saleOrderEntryInfo.getLockBaseQty());
            }
            if (warehouseInfo != null) {
                newRow.getCell("FWarHouse").setUserObject((Object)warehouseInfo);
                newRow.getCell("FWarHouse").setValue((Object)warehouseInfo.getId().toString());
            }
            if (projectInfo != null) {
                newRow.getCell(PROJECTID).setUserObject((Object)projectInfo);
                newRow.getCell(PROJECTID).setValue((Object)projectInfo.getNumber());
            }
            if (TrackNumberInfo2 != null) {
                newRow.getCell(TRACKNUMBER).setUserObject((Object)TrackNumberInfo2);
                newRow.getCell(TRACKNUMBER).setValue((Object)TrackNumberInfo2.getNumber());
            }
            this.changePrecision(this.resultVO, this.tblOrder, QTYPRECISIONFROMUNITTAB, saleOrderEntryInfo.getMaterial(), measureUnitInfo, newRow.getRowIndex());
            this.changePrecision(this.resultVO, this.tblOrder, QTYPRECISIONFROMBASEUNITTAB, saleOrderEntryInfo.getMaterial(), measureBaseUnitInfo, newRow.getRowIndex());
            this.changePrecision(this.resultVO, this.tblOrder, new String[]{"FAssitQty", LOCKASSISTQTY}, saleOrderEntryInfo.getMaterial(), measureAssUnitInfo, newRow.getRowIndex());
            if (saleOrderEntryInfo.getQty() != null) {
                BigDecimal qty = new BigDecimal(saleOrderEntryInfo.getQty().toString());
                qty = qty.subtract(saleOrderEntryInfo.getTotalIssueQty());
                newRow.getCell("FCanLockQty").setValue((Object)qty);
                newRow.getCell("FCanLockBaseQty").setValue((Object)this.calEntryBaseQty(this.tblOrder, this.tblOrder, newRow.getRowIndex(), newRow.getRowIndex(), "FBaseUnit", "FCanLockBaseQty", new BigDecimal(newRow.getCell("FCanLockQty").getValue().toString()), "FUnit", newRow.getRowIndex(), 0));
            }
            if (saleOrderEntryInfo.getStorageOrgUnit() != null) {
                newRow.getCell("storageOrgUnit").setValue((Object)saleOrderEntryInfo.getStorageOrgUnit().getId());
            }
            newRow.getCell("lockType").setValue((Object)"   ");
            if (saleOrderEntryInfo.isIsLocked()) {
                newRow.getCell("FCanLockQty").setValue(null);
                newRow.getCell("FCanLockBaseQty").setValue(null);
                newRow.getCell("lockType").setRenderer((IBasicRender)LockRender);
            } else {
                newRow.getCell("lockType").setRenderer((IBasicRender)UnLockRender);
            }
            newRow.getCell("lockType").setUserObject((Object)new Boolean(saleOrderEntryInfo.isIsLocked()));
            if (i == 0) {
                pSeorderNumber = saleOrderInfo.getNumber();
            }
            NumberIsVisible = !pSeorderNumber.equalsIgnoreCase(saleOrderInfo.getNumber());
        }
        if (idList.length == 1) {
            NumberIsVisible = false;
        }
        if (this.isFirst && comValue == 2 && this.tblOrder.getRowCount() == 0) {
            this.isFirst = false;
            throw new OrderException(OrderException.ORDER_NOTHAVELOCKQTY);
        }
        this.tblOrder.getColumn("FNumber").getStyleAttributes().setHided(!NumberIsVisible);
        if (this.isFirst && negative == idList.length) {
            this.isFirst = false;
            throw new OrderException(OrderException.MATERIALISNEGATIVE);
        }
        this.tblOrder.getSelectManager().select(0, 0);
        this.isFirst = false;
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        int selectRow = this.tblOrder.getSelectManager().get().getBeginRow();
        this.saveCurrentOrderRule();
        this.insertRowFromInv(selectRow);
    }

    private void saveCurrentOrderRule() throws Exception {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)this.getMetaDataPK().getFullName().toString(), CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)CONFIGTYPEKEY, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        aSMSDBillConfig = aSMSDBillConfigCollection.size() > 0 ? aSMSDBillConfigCollection.get(0) : new SMSDBillConfigInfo();
        String selected = ((SaleLockOrderRuleEnum)((Object)this.comboOrderRule.getSelectedItem())).getValue();
        aSMSDBillConfig.setConfigValue(selected);
        aSMSDBillConfig.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        aSMSDBillConfig.setBillClassName(this.getMetaDataPK().getFullName().toString());
        aSMSDBillConfig.setConfigType(CONFIGTYPEKEY);
        iSMSDBillConfig.submit((CoreBaseInfo)aSMSDBillConfig);
    }

    public String getCurrentOrderRule() throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)this.getMetaDataPK().getFullName().toString(), CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId(), CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)CONFIGTYPEKEY, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        String result = null;
        if (aSMSDBillConfigCollection.size() > 0 && (aSMSDBillConfig = aSMSDBillConfigCollection.get(0)).getConfigValue() != null) {
            result = aSMSDBillConfig.getConfigValue().toString();
            if ("0".equals(result)) {
                this.comboOrderRule.setSelectedItem((Object)SaleLockOrderRuleEnum.WAREHOUSE);
            } else if ("1".equals(result)) {
                this.comboOrderRule.setSelectedItem((Object)SaleLockOrderRuleEnum.LOT);
            }
        }
        return result;
    }

    private void changePrecision(SCMLockInvDataVO resultVO, KDTable tblOrder, String[] fieldNames, MaterialInfo info, MeasureUnitInfo measureUnitInfo, int rowIndex) {
        int precision = 2;
        Map mmuMap = resultVO.getMmuPrecisions();
        if (info != null && measureUnitInfo != null) {
            MultiMeasureUnitInfo multiUnitInfo = (MultiMeasureUnitInfo)mmuMap.get(info.getId().toString() + measureUnitInfo.getId().toString());
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            } else {
                try {
                    IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                    multiUnitInfo = imultiUnit.getMultiUnit(info.getId().toString(), measureUnitInfo.getId().toString());
                    if (multiUnitInfo != null) {
                        precision = multiUnitInfo.getQtyPrecision();
                        mmuMap.put(info.getId().toString() + measureUnitInfo.getId().toString(), multiUnitInfo);
                    }
                }
                catch (Exception e) {
                    logger.info((Object)"error when get MultiMeasureUnitInfo...");
                }
            }
        }
        SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)tblOrder, (String[])fieldNames, (int)rowIndex);
    }

    @Override
    public void actionLock_actionPerformed(ActionEvent e) throws Exception {
        this.LockMap = new HashMap();
        if (this.tblOrder.getRowCount() > 0) {
            int active_row_index = this.tblOrder.getSelectManager().getActiveRowIndex();
            IRow activeRow = this.tblOrder.getRow(active_row_index);
            BigDecimal ZERO = new BigDecimal("0.00");
            if (activeRow != null) {
                int retInt;
                BigDecimal curLocAsstQty;
                BigDecimal canLocAsstQty;
                BigDecimal curLocBaseQty;
                BigDecimal canLocBaseQty = (BigDecimal)activeRow.getCell("FCanLockBaseQty").getValue();
                if (canLocBaseQty == null) {
                    canLocBaseQty = ZERO;
                }
                if ((curLocBaseQty = (BigDecimal)activeRow.getCell(LOCKBASEQTY).getValue()) == null) {
                    curLocBaseQty = ZERO;
                }
                if ((canLocAsstQty = (BigDecimal)activeRow.getCell("FAssitQty").getValue()) == null) {
                    canLocAsstQty = ZERO;
                }
                if ((curLocAsstQty = (BigDecimal)activeRow.getCell(LOCKASSISTQTY).getValue()) == null) {
                    curLocAsstQty = ZERO;
                }
                if (canLocBaseQty.compareTo(curLocBaseQty) == 0 && canLocAsstQty.compareTo(curLocAsstQty) != 0 && (retInt = MsgBox.showConfirm2((String)SaleUtil.getUIResource("MATERIAL_LOCK_ASST_NOT_EQUAL"))) != 0) {
                    return;
                }
            }
            this.saveCurLockInfo(this.tblOrder.getSelectManager().getActiveRowIndex());
        }
        if (this.LockMap.size() == 0) {
            return;
        }
        this.checkOrderQty();
        HashMap[] hms = new HashMap[this.LockMap.size()];
        Iterator keyValuePairs1 = this.LockMap.entrySet().iterator();
        for (int i = 0; i < this.LockMap.size(); ++i) {
            HashMap hm;
            Map.Entry entry = keyValuePairs1.next();
            Object value = entry.getValue();
            hms[i] = hm = (HashMap)value;
        }
        IInventory ii = InventoryFactory.getRemoteInstance();
        ii.lockInventory(hms);
        this.LockMap = new HashMap();
        SaleLockUIEnum aSaleLockUIEnum = (SaleLockUIEnum)((Object)this.combLockMaterial.getSelectedItem());
        this.tblOrderInsertRows(aSaleLockUIEnum.getValue());
    }

    @Override
    public void actionUnLock_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblOrder.getRowCount() == 0) {
            return;
        }
        KDTSelectManager sm = this.tblOrder.getSelectManager();
        int blockCount = sm.size();
        this.LockMap = new HashMap();
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                this.getUnLockInventory(j);
            }
        }
        if (this.LockMap.size() == 0) {
            return;
        }
        HashMap[] hms = new HashMap[this.LockMap.size()];
        Iterator keyValuePairs1 = this.LockMap.entrySet().iterator();
        for (int i = 0; i < this.LockMap.size(); ++i) {
            HashMap hm;
            Map.Entry entry = keyValuePairs1.next();
            Object value = entry.getValue();
            hms[i] = hm = (HashMap)value;
        }
        IInventory ii = InventoryFactory.getRemoteInstance();
        ii.unLockInventory(hms);
        this.LockMap = new HashMap();
        SaleLockUIEnum aSaleLockUIEnum = (SaleLockUIEnum)((Object)this.combLockMaterial.getSelectedItem());
        this.tblOrderInsertRows(aSaleLockUIEnum.getValue());
    }

    @Override
    protected void tblOrder_tableSelectChanged(KDTSelectEvent e) throws Exception {
        String storageOrgUnitId;
        this.prmtLocation.setValue(null);
        this.prmtWareHouse.setValue(null);
        int row = e.getSelectBlock().getBeginRow();
        Object uuidStroageOrg = null;
        if (this.tblOrder.getRow(row) != null) {
            uuidStroageOrg = this.tblOrder.getRow(row).getCell("storageOrgUnit").getValue();
        }
        String string = storageOrgUnitId = uuidStroageOrg != null ? uuidStroageOrg.toString() : null;
        if (storageOrgUnitId != null) {
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            if (this.storageOrgUnitMap.get(storageOrgUnitId) != null) {
                storageOrgUnitInfo = (StorageOrgUnitInfo)this.storageOrgUnitMap.get(storageOrgUnitId);
            } else {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                storageOrgUnitInfo = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitId), sic);
                this.storageOrgUnitMap.put(storageOrgUnitInfo, storageOrgUnitId);
            }
            this.registerWarehouseF7(storageOrgUnitInfo);
        }
        if (e.getPrevSelectBlock() != null) {
            this.updateCurLockQtyTotal(row);
        }
        if (this.tblOrder.getRowCount() > 0) {
            this.getLockInventory(row);
        }
        this.insertRowFromInv(row);
        this.updateCurLockQtyTotal(row);
    }

    @Override
    protected void combLockMaterial_itemStateChanged(ItemEvent e) throws Exception {
        if (this.tblOrder.getRowCount() > 0) {
            this.saveCurLockInfo(this.tblOrder.getSelectManager().getActiveRowIndex());
        }
        SaleLockUIEnum aSaleLockUIEnum = (SaleLockUIEnum)((Object)this.combLockMaterial.getSelectedItem());
        this.tblOrderInsertRows(aSaleLockUIEnum.getValue());
        if (aSaleLockUIEnum.getValue() == 1) {
            this.btnBatchLock.setEnabled(true);
            this.btnAllClear.setEnabled(true);
            this.btnAllSelect.setEnabled(true);
        } else if (aSaleLockUIEnum.getValue() == 2) {
            this.btnBatchLock.setEnabled(false);
            this.btnAllClear.setEnabled(false);
            this.btnAllSelect.setEnabled(false);
        } else if (aSaleLockUIEnum.getValue() == 3) {
            this.btnBatchLock.setEnabled(true);
            this.btnAllClear.setEnabled(true);
            this.btnAllSelect.setEnabled(true);
        }
    }

    private void handleBtnEnable(int rowIndex) {
        IRow aRow = this.tblOrder.getRow(rowIndex);
        if (((Boolean)aRow.getCell("lockType").getUserObject()).booleanValue()) {
            this.btnLock.setEnabled(false);
            this.btnUnLock.setEnabled(true);
        } else {
            this.btnLock.setEnabled(true);
            this.btnUnLock.setEnabled(false);
        }
    }

    private void insertRowFromInv(int rowIndex) throws Exception {
        this.tblLock.removeRows();
        Boolean unSelect = new Boolean(true);
        if (this.tblOrder.getRowCount() == 0) {
            return;
        }
        IRow aRow = this.tblOrder.getRow(rowIndex);
        Boolean isLocked = (Boolean)aRow.getCell("lockType").getUserObject();
        MeasureUnitInfo saleOrderUnitInfo = (MeasureUnitInfo)aRow.getCell("FUnit").getUserObject();
        this.tblLock.getColumn("select").getStyleAttributes().setLocked(isLocked.booleanValue());
        this.handleBtnEnable(rowIndex);
        EntityViewInfo ev = new EntityViewInfo();
        MaterialInfo aMaterialInfo = (MaterialInfo)aRow.getCell("FMaterialNum").getUserObject();
        AsstAttrValueInfo asstAttrValueInfo = (AsstAttrValueInfo)aRow.getCell("FAss").getUserObject();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo companyFilter = new FilterItemInfo("STORAGEORGUNIT.ID", aRow.getCell("storageOrgUnit").getValue(), CompareType.EQUALS);
        FilterItemInfo materialFilter = new FilterItemInfo("MATERIAL.ID", (Object)aMaterialInfo.getId().toString(), CompareType.EQUALS);
        FilterItemInfo storeTypeFilter = new FilterItemInfo("STORETYPE.ID", (Object)"181875d5-0105-1000-e000-0111c0a812fd97D461A6", CompareType.EQUALS);
        FilterItemInfo storeStatusFilter = new FilterItemInfo("STORESTATUS.ID", (Object)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5", CompareType.EQUALS);
        WarehouseInfo wareHouseInfo = (WarehouseInfo)aRow.getCell("FWarHouse").getUserObject();
        if (wareHouseInfo != null) {
            FilterItemInfo wareHouseFilter = new FilterItemInfo("WAREHOUSE.ID", (Object)wareHouseInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(wareHouseFilter);
        }
        filter.getFilterItems().add(companyFilter);
        filter.getFilterItems().add(materialFilter);
        filter.getFilterItems().add(storeTypeFilter);
        filter.getFilterItems().add(storeStatusFilter);
        if (asstAttrValueInfo != null) {
            FilterItemInfo assistFilter = new FilterItemInfo("assistProperty.ID", (Object)asstAttrValueInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(assistFilter);
        }
        ev.setFilter(filter);
        SorterItemCollection sorterIc = new SorterItemCollection();
        if ("0".equals(((SaleLockOrderRuleEnum)((Object)this.comboOrderRule.getSelectedItem())).getValue())) {
            sorterIc.add(new SorterItemInfo("warehouse"));
            sorterIc.add(new SorterItemInfo("lot"));
        } else {
            sorterIc.add(new SorterItemInfo("lot"));
        }
        ev.setSorter(sorterIc);
        SCMLockInvDataVO vo = new SCMLockInvDataVO();
        vo.setTableNether(true);
        vo.setViewInfo(ev);
        vo.setType("bottom");
        SCMLockInvDataVO tblLockVO = SCMGroupFacadeFactory.getRemoteInstance().loadSaleLockInvData(vo);
        IObjectPK[] invIdList = tblLockVO.getInvIdList();
        Map wareHouseMap = tblLockVO.getWareHouseMap();
        Map locationMap = tblLockVO.getLocationMap();
        Map storeTypeMap = tblLockVO.getStoreTypeMap();
        Map storeStateMap = tblLockVO.getStoreStateMap();
        Map supplierMap = tblLockVO.getSupplierMap();
        Map customerMap = tblLockVO.getCustomerMap();
        Map storageMap = tblLockVO.getStorageMap();
        Map invUnitMap = tblLockVO.getInvUnitMap();
        Map invBaseUnitMap = tblLockVO.getBaseUnitMap();
        Map inventoryMap = tblLockVO.getInventoryMap();
        Map invProjectMap = tblLockVO.getInvProjectMap();
        Map invTrackNumberMap = tblLockVO.getInvTrackNumberMap();
        KDTDefaultCellEditor col_CellEditor = new KDTDefaultCellEditor((JCheckBox)this.cbProxy);
        this.tblLock.getColumn("select").setEditor((ICellEditor)col_CellEditor);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        String invID = null;
        int n = invIdList.length;
        for (int i = 0; i < n; ++i) {
            MeasureUnitInfo measureUnitInfo;
            LocationInfo aLocationInfo;
            WarehouseInfo aWarehouseInfo;
            invID = invIdList[i].toString();
            InventoryInfo aInventoryInfo = (InventoryInfo)inventoryMap.get(invID);
            LocationInfo locationInfo = (LocationInfo)this.prmtLocation.getValue();
            WarehouseInfo warehouseInfo = (WarehouseInfo)this.prmtWareHouse.getValue();
            if (warehouseInfo != null && locationInfo != null) {
                if (aInventoryInfo.getWarehouse() != null) {
                    aWarehouseInfo = (WarehouseInfo)wareHouseMap.get(invID);
                    if (!warehouseInfo.getName().equals(aWarehouseInfo.getName())) continue;
                }
                if (aInventoryInfo.getLocation() != null) {
                    aLocationInfo = (LocationInfo)locationMap.get(invID);
                    if (!locationInfo.getName().equals(aLocationInfo.getName())) {
                        continue;
                    }
                }
            } else if (warehouseInfo != null && locationInfo == null && !warehouseInfo.getName().equals(aInventoryInfo.getWarehouse())) {
                if (aInventoryInfo.getWarehouse() != null) {
                    aWarehouseInfo = (WarehouseInfo)wareHouseMap.get(invID);
                    if (!warehouseInfo.getName().equals(aWarehouseInfo.getName())) {
                        continue;
                    }
                }
            } else if (warehouseInfo == null && locationInfo != null && !locationInfo.getName().equals(aInventoryInfo.getLocation()) && aInventoryInfo.getLocation() != null) {
                aLocationInfo = (LocationInfo)locationMap.get(invID);
                if (!locationInfo.getName().equals(aLocationInfo.getName())) continue;
            }
            String key = aRow.getCell("FEntryID").getValue().toString() + invID;
            if (aInventoryInfo.getCurStoreQty().compareTo(this.ZERO) <= 0 && this.LockMap.get(key) == null) continue;
            IRow newRow = this.tblLock.addRow();
            StorageOrgUnitInfo aStorageOrgUnitInfo = (StorageOrgUnitInfo)storageMap.get(invID);
            newRow.getCell("FStorageOrg").setValue((Object)aStorageOrgUnitInfo.getName());
            newRow.getCell("FStorageOrg").setUserObject((Object)aStorageOrgUnitInfo);
            newRow.getCell("id").setValue((Object)invIdList[i]);
            newRow.getCell("select").setValue((Object)new Boolean(false));
            if (aInventoryInfo.getWarehouse() != null) {
                WarehouseInfo aWarehouseInfo2 = (WarehouseInfo)wareHouseMap.get(invID);
                newRow.getCell("FWareHouse").setValue((Object)aWarehouseInfo2.getName());
                newRow.getCell("FWareHouse").setUserObject((Object)aWarehouseInfo2);
            }
            if (aInventoryInfo.getLocation() != null) {
                LocationInfo aLocationInfo2 = (LocationInfo)locationMap.get(invID);
                newRow.getCell("FLocation").setValue((Object)aLocationInfo2.getName());
                newRow.getCell("FLocation").setUserObject((Object)aLocationInfo2);
            }
            newRow.getCell("FCurQty").setValue((Object)aInventoryInfo.getCurStoreQty());
            newRow.getCell("FBaseQty").setValue((Object)aInventoryInfo.getBaseQty());
            String materialID = aMaterialInfo.getId().toString();
            if (aInventoryInfo.getUnit() != null) {
                measureUnitInfo = (MeasureUnitInfo)invUnitMap.get(invID);
                BigDecimal saleQty = this.getExchangeQtyForClient(materialID, measureUnitInfo, saleOrderUnitInfo, aInventoryInfo.getCurStoreQty());
                newRow.getCell("FSaleQty").setValue((Object)saleQty);
            }
            if (aInventoryInfo.getLot() != null) {
                newRow.getCell("FLot").setValue((Object)aInventoryInfo.getLot());
            }
            if (aInventoryInfo.getStoretype() != null) {
                StoreTypeInfo aStoreTypeInfo = (StoreTypeInfo)storeTypeMap.get(invID);
                newRow.getCell("FStoreType").setValue((Object)aStoreTypeInfo.getName());
                newRow.getCell("FStoreType").setUserObject((Object)aStoreTypeInfo);
            }
            if (aInventoryInfo.getStorestatus() != null) {
                StoreStateInfo aStoreStateInfo = (StoreStateInfo)storeStateMap.get(invID);
                newRow.getCell("FStoreState").setValue((Object)aStoreStateInfo.getName());
                newRow.getCell("FStoreState").setUserObject((Object)aStoreStateInfo);
            }
            if (aInventoryInfo.getSupplier() != null) {
                SupplierInfo aSupplierInfo = (SupplierInfo)supplierMap.get(invID);
                newRow.getCell("FSupplier").setValue((Object)aSupplierInfo.getName());
                newRow.getCell("FSupplier").setUserObject((Object)aSupplierInfo);
            }
            if (aInventoryInfo.getCustomer() != null) {
                CustomerInfo aCustomerInfo = (CustomerInfo)customerMap.get(invID);
                newRow.getCell("FCustomer").setValue((Object)aCustomerInfo.getName());
                newRow.getCell("FCustomer").setUserObject((Object)aCustomerInfo);
            }
            if (aInventoryInfo.getUnit() != null) {
                measureUnitInfo = (MeasureUnitInfo)invUnitMap.get(invID);
                newRow.getCell("FUnit").setValue((Object)measureUnitInfo.getName());
                newRow.getCell("FUnit").setUserObject((Object)measureUnitInfo);
                this.changePrecision(tblLockVO, this.tblLock, QTYPRECISIONFROMUNITTAB2, aMaterialInfo, measureUnitInfo, newRow.getRowIndex());
            }
            if (aInventoryInfo.getBaseUnit() != null) {
                measureUnitInfo = (MeasureUnitInfo)invBaseUnitMap.get(invID);
                newRow.getCell("FBaseUnit").setValue((Object)measureUnitInfo.getName());
                newRow.getCell("FBaseUnit").setUserObject((Object)measureUnitInfo);
                this.changePrecision(tblLockVO, this.tblLock, QTYPRECISIONFORBASEQTY, aMaterialInfo, measureUnitInfo, newRow.getRowIndex());
            }
            if (saleOrderUnitInfo != null) {
                newRow.getCell("FSaleUnit").setValue((Object)saleOrderUnitInfo.getName());
                newRow.getCell("FSaleUnit").setUserObject((Object)saleOrderUnitInfo);
                this.changePrecision(tblLockVO, this.tblLock, QTYPRECISIONFORSALEQTY, aMaterialInfo, saleOrderUnitInfo, newRow.getRowIndex());
            }
            if (aInventoryInfo.getCurStoreAssistQty() != null && aInventoryInfo.getCurStoreAssistQty().compareTo(this.ZERO) > 0) {
                this.changePrecision(this.resultVO, this.tblLock, new String[]{"FCurAssitQty", "FCurLockAssQty"}, aInventoryInfo.getMaterial(), aInventoryInfo.getAssistUnit(), newRow.getRowIndex());
                newRow.getCell("FCurAssitQty").setValue((Object)aInventoryInfo.getCurStoreAssistQty());
            } else {
                this.changePrecision(this.resultVO, this.tblLock, new String[]{"FCurAssitQty", "FCurLockAssQty"}, aInventoryInfo.getMaterial(), aInventoryInfo.getAssistUnit(), newRow.getRowIndex());
            }
            newRow.getCell("FCurLockAssQty").getStyleAttributes().setLocked(true);
            newRow.getCell("FCurLockQty").getStyleAttributes().setLocked(true);
            newRow.getCell("FBaseLockQty").getStyleAttributes().setLocked(true);
            newRow.getCell("FSaleLockQty").getStyleAttributes().setLocked(true);
            if (aInventoryInfo.getProject() != null) {
                ProjectInfo projectInfo = (ProjectInfo)invProjectMap.get(invID);
                newRow.getCell(PROJECTID).setValue((Object)projectInfo.getNumber());
                newRow.getCell(PROJECTID).setUserObject((Object)projectInfo);
            }
            if (aInventoryInfo.getTrackNumber() != null) {
                TrackNumberInfo trackNumberInfo = (TrackNumberInfo)invTrackNumberMap.get(invID);
                newRow.getCell(TRACKNUMBER).setValue((Object)trackNumberInfo.getNumber());
                newRow.getCell(TRACKNUMBER).setUserObject((Object)trackNumberInfo);
            }
            newRow.getCell(PROJECTID).getStyleAttributes().setLocked(true);
            newRow.getCell(TRACKNUMBER).getStyleAttributes().setLocked(true);
            SaleLockUIEnum aSaleLockUIEnum = (SaleLockUIEnum)((Object)this.combLockMaterial.getSelectedItem());
            if (this.LockMap.get(key) != null) {
                if (this.isFirst) continue;
                HashMap hm = (HashMap)this.LockMap.get(key);
                newRow.getCell("select").setValue((Object)unSelect);
                newRow.getCell("FCurLockQty").setValue((Object)((BigDecimal)hm.get(LOCKQTY)));
                newRow.getCell("FCurLockQty").getStyleAttributes().setLocked(false);
                newRow.getCell("FCurLockAssQty").setValue((Object)((BigDecimal)hm.get(LOCKASSISTQTY)));
                newRow.getCell("FCurLockAssQty").getStyleAttributes().setLocked(false);
                newRow.getCell("FBaseLockQty").setValue((Object)((BigDecimal)hm.get(LOCKBASEQTY)));
                if (aInventoryInfo.getUnit() != null) {
                    MeasureUnitInfo measureUnitInfo2 = (MeasureUnitInfo)invUnitMap.get(invID);
                    BigDecimal saleLockQty = this.getExchangeQtyForClient(materialID, measureUnitInfo2, saleOrderUnitInfo, (BigDecimal)hm.get(LOCKQTY));
                    newRow.getCell("FSaleLockQty").setValue((Object)saleLockQty);
                }
                newRow.getCell("FSaleLockQty").getStyleAttributes().setLocked(false);
                continue;
            }
            if (aSaleLockUIEnum.getValue() != 2) continue;
            this.tblLock.removeRow(newRow.getRowIndex());
        }
    }

    public void tableValueChanged(int rowIndex, int colIndex) throws Exception {
        boolean isSelect = this.cbProxy.isSelected();
        int orderRowIndex = this.tblOrder.getSelectManager().getActiveRowIndex();
        IRow aRow = this.tblOrder.getRow(orderRowIndex);
        IRow bRow = this.tblLock.getRow(rowIndex);
        MeasureUnitInfo saleOrderUnitInfo = (MeasureUnitInfo)aRow.getCell("FUnit").getUserObject();
        MaterialInfo aMaterialInfo = (MaterialInfo)aRow.getCell("FMaterialNum").getUserObject();
        String materialID = aMaterialInfo.getId().toString();
        if (colIndex == 0) {
            if (isSelect) {
                BigDecimal curLockQty;
                int scale;
                this.tblLock.getRow(rowIndex).getCell("select").setValue((Object)isSelect);
                BigDecimal canLockQty = (BigDecimal)aRow.getCell("FCanLockBaseQty").getValue();
                BigDecimal curQty = (BigDecimal)bRow.getCell("FCurQty").getValue();
                MeasureUnitInfo lockUnitInfo = (MeasureUnitInfo)bRow.getCell("FUnit").getUserObject();
                MeasureUnitInfo lockBaseUnitInfo = (MeasureUnitInfo)bRow.getCell("FBaseUnit").getUserObject();
                curQty = this.calEntryBaseQty(this.tblOrder, this.tblLock, orderRowIndex, rowIndex, "FBaseUnit", "FCanLockBaseQty", curQty, "FUnit", orderRowIndex, 0);
                int n = scale = bRow.getCell("FCurQty").getEditor() == null ? 2 : ((KDFormattedTextField)bRow.getCell("FCurQty").getEditor().getComponent()).getPrecision();
                if (canLockQty == null) {
                    canLockQty = this.ZERO;
                }
                if (canLockQty.compareTo(curQty) <= 0) {
                    this.clearLockQty(rowIndex);
                    canLockQty = this.calEntryBaseQty(this.tblLock, this.tblOrder, rowIndex, orderRowIndex, "FUnit", "FCanLockBaseQty", canLockQty, "FBaseUnit", orderRowIndex, scale);
                    canLockQty = canLockQty.setScale(scale, 4);
                    bRow.getCell("FCurLockQty").setValue((Object)canLockQty);
                } else {
                    if (aRow.getCell(LOCKQTY).getValue() != null) {
                        canLockQty = canLockQty.subtract((BigDecimal)aRow.getCell(LOCKBASEQTY).getValue());
                    }
                    curQty = this.calEntryBaseQty(this.tblLock, this.tblOrder, rowIndex, orderRowIndex, "FUnit", "FCanLockBaseQty", curQty, "FBaseUnit", orderRowIndex, scale);
                    if ((canLockQty = this.calEntryBaseQty(this.tblLock, this.tblOrder, rowIndex, orderRowIndex, "FUnit", "FCanLockBaseQty", canLockQty, "FBaseUnit", orderRowIndex, scale)).compareTo(curQty) > 0) {
                        bRow.getCell("FCurLockQty").setValue((Object)curQty);
                    } else {
                        bRow.getCell("FCurLockQty").setValue((Object)canLockQty);
                    }
                }
                BigDecimal tempLockQty = (BigDecimal)bRow.getCell("FCurLockQty").getValue();
                if (tempLockQty != null) {
                    BigDecimal canLockBaseQty = this.getExchangeQtyForClient(materialID, lockUnitInfo, lockBaseUnitInfo, tempLockQty);
                    bRow.getCell("FBaseLockQty").setValue((Object)canLockBaseQty);
                    BigDecimal canLockSaleQty = this.getExchangeQtyForClient(materialID, lockUnitInfo, saleOrderUnitInfo, tempLockQty);
                    bRow.getCell("FSaleLockQty").setValue((Object)canLockSaleQty);
                }
                int tblOrderRow = 0;
                if (this.tblOrder.getRowCount() > 0) {
                    tblOrderRow = this.tblOrder.getSelectManager().getActiveRowIndex();
                }
                if ((curLockQty = (BigDecimal)bRow.getCell("FCurLockQty").getValue()) != null && curLockQty.toString().trim().length() > 0 && this.tblOrder.getRow(tblOrderRow).getCell("FAssUnit").getValue() != null) {
                    if (curLockQty.compareTo(this.ZERO) > 0) {
                        this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getStyleAttributes().setLocked(false);
                        BigDecimal lockAssQty = this.ZERO;
                        int assUnitscale = this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getEditor() == null ? 2 : ((KDFormattedTextField)this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getEditor().getComponent()).getPrecision();
                        lockAssQty = this.calEntryBaseQty(this.tblOrder, this.tblLock, tblOrderRow, rowIndex, "FAssUnit", "FCanLockBaseQty", (BigDecimal)this.tblLock.getRow(rowIndex).getCell("FCurLockQty").getValue(), "FUnit", tblOrderRow, assUnitscale);
                        this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").setValue((Object)lockAssQty);
                    } else {
                        this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").getStyleAttributes().setLocked(true);
                        this.tblLock.getRow(rowIndex).getCell("FCurLockAssQty").setValue((Object)this.curLockAssQty);
                    }
                }
                bRow.getCell("FCurLockQty").getStyleAttributes().setLocked(false);
                bRow.getCell("FSaleLockQty").getStyleAttributes().setLocked(false);
                int count = this.tblLock.getRowCount();
                for (int i = 0; i < count; ++i) {
                    if (i == rowIndex) {
                        Color necessaryColor = new Color(252, 255, 206);
                        this.tblLock.getRow(rowIndex).getCell("FCurLockQty").getStyleAttributes().setBackground(necessaryColor);
                        this.tblLock.getRow(rowIndex).getCell("FSaleLockQty").getStyleAttributes().setBackground(necessaryColor);
                        continue;
                    }
                    this.tblLock.getRow(i).getCell("FCurLockQty").getStyleAttributes().setBackground(null);
                    this.tblLock.getRow(i).getCell("FSaleLockQty").getStyleAttributes().setBackground(null);
                }
            } else {
                bRow.getCell("FCurLockQty").setValue(null);
                bRow.getCell("FCurLockAssQty").setValue(null);
                bRow.getCell("FBaseLockQty").setValue(null);
                bRow.getCell("FSaleLockQty").setValue(null);
                bRow.getCell("FBaseLockQty").getStyleAttributes().setLocked(true);
                bRow.getCell("FSaleLockQty").getStyleAttributes().setLocked(true);
                bRow.getCell("FCurLockQty").getStyleAttributes().setLocked(true);
                bRow.getCell("FCurLockAssQty").getStyleAttributes().setLocked(true);
                bRow.getCell("FCurLockQty").getStyleAttributes().setBackground(null);
                bRow.getCell("FSaleLockQty").getStyleAttributes().setBackground(null);
            }
        }
        this.updateCurLockQtyTotal(orderRowIndex);
        this.saveCurLockInfo(orderRowIndex);
    }

    private void updateCurLockQtyTotal(int rowIndex) {
        if (this.tblOrder.getRowCount() == 0) {
            return;
        }
        if (((Boolean)this.tblOrder.getRow(rowIndex).getCell("lockType").getUserObject()).booleanValue()) {
            return;
        }
        try {
            BigDecimal curLockQtyTotal = new BigDecimal("0.00");
            BigDecimal curLockAssistQtyTotal = new BigDecimal("0.00");
            BigDecimal curLockAssistQty = null;
            BigDecimal curLockQty = null;
            BigDecimal zero = new BigDecimal("0.00");
            Boolean unSelect = new Boolean(false);
            int scale = this.tblOrder.getRow(rowIndex).getCell(LOCKQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.tblOrder.getRow(rowIndex).getCell(LOCKQTY).getEditor().getComponent()).getPrecision();
            int n = this.tblLock.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (this.tblLock.getRow(i).getCell("FCurLockQty").getValue() == null) continue;
                curLockQty = this.calEntryBaseQty(this.tblOrder, this.tblLock, rowIndex, i, "FBaseUnit", "FCanLockBaseQty", new BigDecimal(this.tblLock.getRow(i).getCell("FCurLockQty").getValue().toString()), "FUnit", rowIndex, 0);
                if ((curLockQtyTotal = curLockQtyTotal.setScale(scale, 4)) != null && curLockQty != null) {
                    curLockQtyTotal = curLockQtyTotal.add(curLockQty);
                }
                if ((curLockAssistQty = this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue() instanceof String ? new BigDecimal(((String)this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue()).trim()) : (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue()) != null) {
                    curLockAssistQtyTotal = curLockAssistQtyTotal.add(curLockAssistQty);
                }
                if (curLockQty == null || curLockQty.compareTo(zero) != 0) continue;
                this.tblLock.getRow(i).getCell("FCurLockQty").setValue(null);
                this.cbProxy.setSelected(false);
                this.tblLock.getRow(i).getCell("select").setValue((Object)unSelect);
            }
            if (this.tblOrder.getRowCount() > 0) {
                this.tblOrder.getRow(rowIndex).getCell(LOCKBASEQTY).setValue((Object)curLockQtyTotal);
                this.tblOrder.getRow(rowIndex).getCell(LOCKQTY).setValue((Object)this.calEntryBaseQty(this.tblOrder, this.tblOrder, rowIndex, rowIndex, "FUnit", "FCanLockBaseQty", curLockQtyTotal, "FBaseUnit", rowIndex, 0));
                this.tblOrder.getRow(rowIndex).getCell(LOCKASSISTQTY).setValue((Object)curLockAssistQtyTotal);
            }
        }
        catch (EASBizException exc) {
            this.handUIException(exc);
        }
        catch (BOSException exc) {
            this.handUIException(exc);
        }
    }

    private void clearLockQty(int rowIndex) {
        Boolean unSelect = new Boolean(false);
        int n = this.tblLock.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (i == rowIndex) continue;
            this.tblLock.getRow(i).getCell("select").setValue((Object)unSelect);
            this.tblLock.getRow(i).getCell("FCurLockQty").setValue(null);
            this.tblLock.getRow(i).getCell("FCurLockAssQty").setValue(null);
            this.tblLock.getRow(i).getCell("FBaseLockQty").setValue(null);
            this.tblLock.getRow(i).getCell("FSaleLockQty").setValue(null);
            this.tblLock.getRow(i).getCell("FBaseLockQty").getStyleAttributes().setLocked(true);
            this.tblLock.getRow(i).getCell("FSaleLockQty").getStyleAttributes().setLocked(true);
            this.tblLock.getRow(i).getCell("FCurLockQty").getStyleAttributes().setLocked(true);
            this.tblLock.getRow(i).getCell("FCurLockAssQty").getStyleAttributes().setLocked(true);
        }
    }

    private void saveCurLockInfo(int rowIndex) {
        String billentryid = this.tblOrder.getRow(rowIndex).getCell("FEntryID").getValue().toString();
        String billid = this.tblOrder.getRow(rowIndex).getCell("id").getValue().toString();
        String billnumber = this.tblOrder.getRow(rowIndex).getCell("FNumber").getValue().toString();
        try {
            int n = this.tblLock.getRowCount();
            for (int i = 0; i < n; ++i) {
                boolean isSelect = this.tblLock.getRow(i).getCell("select").getValue() == null ? false : (Boolean)this.tblLock.getRow(i).getCell("select").getValue();
                String invID = this.tblLock.getRow(i).getCell("id").getValue().toString();
                if (isSelect && this.tblLock.getRow(i).getCell("FCurLockQty").getValue() != null && this.tblLock.getRow(i).getCell("FCurLockQty").getValue().toString().length() > 0) {
                    ProjectInfo projectInfo;
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    hm.put(BILLID, billid);
                    hm.put(BILLENTRYID, billentryid);
                    hm.put(INVENTORYID, this.tblLock.getRow(i).getCell("id").getValue().toString());
                    hm.put(BILLNUMBER, billnumber);
                    hm.put(BILLTYPEID, "510b6503-0105-1000-e000-0113c0a812fd463ED552");
                    hm.put(WAREHOUSEID, ((WarehouseInfo)this.tblLock.getRow(i).getCell("FWareHouse").getUserObject()).getId().toString());
                    if (this.tblLock.getRow(i).getCell("FLocation").getUserObject() != null) {
                        hm.put(LOCATIONID, ((LocationInfo)this.tblLock.getRow(i).getCell("FLocation").getUserObject()).getId().toString());
                    } else {
                        hm.put(LOCATIONID, null);
                    }
                    if (this.tblLock.getRow(i).getCell("FLot").getValue() != null) {
                        hm.put(LOT, this.tblLock.getRow(i).getCell("FLot").getValue().toString());
                    } else {
                        hm.put(LOT, null);
                    }
                    hm.put(STORETYPEID, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                    hm.put(STORESTATEID, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                    if (this.tblLock.getRow(i).getCell("FCurLockQty").getValue() != null) {
                        hm.put(LOCKQTY, (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockQty").getValue());
                        hm.put(LOCKBASEQTY, this.calEntryBaseQty(this.tblOrder, this.tblLock, rowIndex, i, "FBaseUnit", "FCanLockBaseQty", (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockQty").getValue(), "FUnit", rowIndex, 0));
                        hm.put(LOCKORDERQTY, this.calEntryBaseQty(this.tblOrder, this.tblLock, rowIndex, i, "FUnit", "FCanLockBaseQty", (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockQty").getValue(), "FUnit", rowIndex, 0));
                        if (this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue() != null) {
                            if (this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue() instanceof String) {
                                hm.put(LOCKASSISTQTY, new BigDecimal(((String)this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue()).trim()));
                            } else {
                                BigDecimal curLockAssQty = (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue();
                                if (curLockAssQty != null && curLockAssQty.compareTo(this.ZERO) == 0) {
                                    hm.put(LOCKASSISTQTY, SCMConstant.BIGDECIMAL_ZERO);
                                } else {
                                    hm.put(LOCKASSISTQTY, (BigDecimal)this.tblLock.getRow(i).getCell("FCurLockAssQty").getValue());
                                }
                            }
                        } else {
                            hm.put(LOCKASSISTQTY, SCMConstant.BIGDECIMAL_ZERO);
                        }
                    }
                    if ((projectInfo = (ProjectInfo)this.tblLock.getCell(i, PROJECTID).getUserObject()) != null) {
                        hm.put(PROJECTID, projectInfo.getId().toString());
                    } else {
                        hm.put(PROJECTID, null);
                    }
                    TrackNumberInfo trackNumberInfo = (TrackNumberInfo)this.tblLock.getCell(i, TRACKNUMBER).getUserObject();
                    if (trackNumberInfo != null) {
                        hm.put(TRACKNUMBER, trackNumberInfo.getId().toString());
                    } else {
                        hm.put(TRACKNUMBER, null);
                    }
                    this.LockMap.put(billentryid + invID, hm);
                    continue;
                }
                if (this.LockMap.get(billentryid + invID) == null) continue;
                this.LockMap.remove(billentryid + invID);
            }
        }
        catch (EASBizException exc) {
            this.handUIException(exc);
        }
        catch (BOSException exc) {
            this.handUIException(exc);
        }
    }

    private void getLockInventory(int rowIndex) {
        String billentryid = this.tblOrder.getRow(rowIndex).getCell("FEntryID").getValue().toString();
        String billid = this.tblOrder.getRow(rowIndex).getCell("id").getValue().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billidFilter = new FilterItemInfo("BILLID", (Object)billid, CompareType.EQUALS);
        FilterItemInfo billEntryidFilter = new FilterItemInfo("BILLENTRYID", (Object)billentryid, CompareType.EQUALS);
        filter.getFilterItems().add(billidFilter);
        filter.getFilterItems().add(billEntryidFilter);
        ev.setFilter(filter);
        try {
            ILockInventory iLockInventory = LockInventoryFactory.getRemoteInstance();
            LockInventoryCollection aLockInventoryCollection = iLockInventory.getLockInventoryCollection(ev);
            int n = aLockInventoryCollection.size();
            for (int i = 0; i < n; ++i) {
                LockInventoryInfo aInventoryInfo = (LockInventoryInfo)aLockInventoryCollection.getObject(i);
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put(BILLID, billid);
                hm.put(BILLENTRYID, billentryid);
                hm.put(INVENTORYID, aInventoryInfo.getInventoryID().toString());
                hm.put(LOCKQTY, aInventoryInfo.getLockQty());
                hm.put(LOCKBASEQTY, aInventoryInfo.getLockBaseQty());
                hm.put(LOCKASSISTQTY, aInventoryInfo.getLockAssistQty());
                this.LockMap.put(billentryid + aInventoryInfo.getInventoryID().toString(), hm);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void getUnLockInventory(int rowIndex) {
        String billentryid = this.tblOrder.getRow(rowIndex).getCell("FEntryID").getValue().toString();
        String billid = this.tblOrder.getRow(rowIndex).getCell("id").getValue().toString();
        String billnumber = this.tblOrder.getRow(rowIndex).getCell("FNumber").getValue().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billidFilter = new FilterItemInfo("BILLID", (Object)billid, CompareType.EQUALS);
        FilterItemInfo billEntryidFilter = new FilterItemInfo("BILLENTRYID", (Object)billentryid, CompareType.EQUALS);
        filter.getFilterItems().add(billidFilter);
        filter.getFilterItems().add(billEntryidFilter);
        ev.setFilter(filter);
        try {
            ILockInventory iLockInventory = LockInventoryFactory.getRemoteInstance();
            LockInventoryCollection aLockInventoryCollection = iLockInventory.getLockInventoryCollection(ev);
            int tblOrderRow = 0;
            if (this.tblOrder.getRowCount() > 0) {
                tblOrderRow = this.tblOrder.getSelectManager().getActiveRowIndex();
            }
            int n = aLockInventoryCollection.size();
            for (int i = 0; i < n; ++i) {
                LockInventoryInfo lockInventoryInfo = (LockInventoryInfo)aLockInventoryCollection.getObject(i);
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put(BILLID, billid);
                hm.put(BILLENTRYID, billentryid);
                hm.put(BILLNUMBER, billnumber);
                hm.put(INVENTORYID, lockInventoryInfo.getInventoryID().toString());
                hm.put(LOCKQTY, lockInventoryInfo.getLockQty());
                hm.put(LOCKBASEQTY, lockInventoryInfo.getLockBaseQty());
                hm.put(LOCKORDERQTY, this.getBaseUnitQty(this.tblOrder, this.tblOrder, tblOrderRow, tblOrderRow, "FMaterialNum", "FUnit", "FBaseUnit", lockInventoryInfo.getLockBaseQty(), tblOrderRow));
                hm.put(LOCKASSISTQTY, lockInventoryInfo.getLockAssistQty());
                if (lockInventoryInfo.getProjectID() != null) {
                    hm.put(PROJECTID, lockInventoryInfo.getProjectID().toString());
                } else {
                    hm.put(PROJECTID, null);
                }
                if (lockInventoryInfo.getTrackNumberID() != null) {
                    hm.put(TRACKNUMBER, lockInventoryInfo.getTrackNumberID().toString());
                } else {
                    hm.put(TRACKNUMBER, null);
                }
                this.LockMap.put(billentryid + lockInventoryInfo.getInventoryID().toString(), hm);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void checkOrderQty() {
        BigDecimal curLockQty = null;
        BigDecimal canLockQty = null;
        int errorLine = 0;
        Color necessaryColor = new Color(252, 255, 206);
        int i = this.tblOrder.getSelectManager().getActiveRowIndex();
        BigDecimal lockQty = (BigDecimal)this.tblOrder.getRow(i).getCell(LOCKQTY).getValue();
        if (lockQty != null) {
            int scale;
            curLockQty = (BigDecimal)this.tblOrder.getRow(i).getCell(LOCKBASEQTY).getValue();
            canLockQty = (BigDecimal)this.tblOrder.getRow(i).getCell("FCanLockBaseQty").getValue();
            int n = scale = this.tblOrder.getRow(i).getCell(LOCKQTY).getEditor() == null ? 2 : ((KDFormattedTextField)this.tblOrder.getRow(i).getCell(LOCKQTY).getEditor().getComponent()).getPrecision();
            if (curLockQty == null) {
                return;
            }
            canLockQty = canLockQty.setScale(scale, 4);
            if ((curLockQty = curLockQty.setScale(scale, 4)).compareTo(canLockQty) > 0) {
                ++errorLine;
                this.tblOrder.getRow(i).getStyleAttributes().setBackground(necessaryColor);
            } else {
                this.tblOrder.getRow(i).getStyleAttributes().setBackground(null);
            }
        }
        if (errorLine > 0) {
            MsgBox.showInfo((String)SaleUtil.getUIResource("LOCKUI_ERROR"));
            SysUtil.abort();
        }
    }

    public BigDecimal calEntryBaseQty(KDTable table, KDTable table2, int rowIndex, int rowIndex2, String UnitName, String UnitQty, BigDecimal mainQty, String CUnitName, int tblOrderRow, int scale) throws EASBizException, BOSException {
        BigDecimal baseUnitQty = this.getBaseUnitQty(table, table2, rowIndex, rowIndex2, "FMaterialNum", UnitName, CUnitName, mainQty, tblOrderRow);
        if (baseUnitQty != null) {
            if (scale == 0) {
                scale = this.tblOrder.getRow(tblOrderRow).getCell(UnitQty).getEditor() == null ? 2 : ((KDFormattedTextField)this.tblOrder.getRow(tblOrderRow).getCell(UnitQty).getEditor().getComponent()).getPrecision();
            }
            baseUnitQty = baseUnitQty.setScale(scale, 4);
            return baseUnitQty;
        }
        return null;
    }

    public BigDecimal getBaseUnitQty(KDTable table, KDTable table2, int rowIndex, int rowIndex2, String materialFieldName, String baseUnitFieldName, String unitFieldName, BigDecimal orderQty, int tblOrderRow) throws EASBizException, BOSException {
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)table.getRow(rowIndex).getCell(baseUnitFieldName).getUserObject();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)table2.getRow(rowIndex2).getCell(unitFieldName).getUserObject();
        MaterialInfo materialInfo = null;
        if (this.tblOrder.getRow(tblOrderRow).getCell(materialFieldName).getUserObject() != null && this.tblOrder.getRow(tblOrderRow).getCell(materialFieldName).getUserObject() instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)this.tblOrder.getRow(tblOrderRow).getCell(materialFieldName).getUserObject();
        }
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        BigDecimal baseUnitQty = this.getExchangeQtyForClient(materialInfo.getId().toString(), unitInfo, baseUnitInfo, orderQty);
        return baseUnitQty;
    }

    public BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        Map mmuMap = this.resultVO.getMmuPrecisions();
        BigDecimal targetQty = qty;
        MultiMeasureUnitInfo multiUnifInfo = (MultiMeasureUnitInfo)mmuMap.get(materialID + unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = (MultiMeasureUnitInfo)mmuMap.get(materialID + otherUnitInfo.getId().toString());
        if (multiUnifInfo == null || othermultiUnifInfo == null) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            if (multiUnifInfo == null) {
                multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
            }
            if (othermultiUnifInfo == null) {
                othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
            }
        }
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = SCMUtils.effectualNumeric((BigDecimal)baseQty).divide(SCMUtils.effectualExchangeRate((BigDecimal)baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    private void addcbProxyListen() {
        this.cbProxyListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleOrderLockUI.this.cbProxy_stateChanged(e);
                }
                catch (Exception exc) {
                    SaleOrderLockUI.this.handUIException(exc);
                }
            }
        };
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected void initContextOrg() {
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            String lockType = this.getUIContext().get("lockType").toString();
            IObjectPK[] idList = (IObjectPK[])this.getUIContext().get("idList");
            request.put("idList", (Object)idList);
            request.put("lockType", (Object)lockType);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public void actionAllSelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblOrder.getRowCount() > 0) {
            int size = this.tblOrder.getRowCount();
            for (int i = 0; i < size; ++i) {
                if (((Boolean)this.tblOrder.getRow(i).getCell("lockType").getUserObject()).booleanValue()) continue;
                this.tblOrder.getRow(i).getCell(0).setValue((Object)new Boolean(true));
            }
        }
    }

    @Override
    public void actionAllClear_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblOrder.getRowCount();
        for (int i = 0; i < size; ++i) {
            this.tblOrder.getRow(i).getCell(0).setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionBatchLock_actionPerformed(ActionEvent e) throws Exception {
        ArrayList orderEntryList = new ArrayList();
        int size = this.tblOrder.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (!((Boolean)this.tblOrder.getRow(i).getCell("isBatchLock").getValue()).booleanValue()) continue;
            MaterialInfo materialInfo = (MaterialInfo)this.tblOrder.getRow(i).getCell("FMaterialNum").getUserObject();
            AsstAttrValueInfo asstAttrValueInfo = (AsstAttrValueInfo)this.tblOrder.getRow(i).getCell("FAss").getUserObject();
            Object storageOrgUnit = this.tblOrder.getRow(i).getCell("storageOrgUnit").getValue();
            BigDecimal canLockOrderBaseQty = (BigDecimal)this.tblOrder.getRow(i).getCell("FCanLockBaseQty").getValue();
            String orderEntryId = this.tblOrder.getRow(i).getCell("FEntryID").getValue().toString();
            String orderId = this.tblOrder.getRow(i).getCell("id").getValue().toString();
            String orderNumber = this.tblOrder.getRow(i).getCell("FNumber").getValue().toString();
            MeasureUnitInfo orderEntryUnitInfo = (MeasureUnitInfo)this.tblOrder.getRow(i).getCell("FUnit").getUserObject();
            WarehouseInfo wareHouseInfo = (WarehouseInfo)this.tblOrder.getRow(i).getCell("FWarHouse").getUserObject();
            HashMap<String, Object> orderEntryItemMap = new HashMap<String, Object>();
            orderEntryItemMap.put("materialInfo", materialInfo);
            orderEntryItemMap.put("asstAttrValueInfo", asstAttrValueInfo);
            orderEntryItemMap.put("storageOrgUnit", storageOrgUnit);
            orderEntryItemMap.put("canLockOrderBaseQty", canLockOrderBaseQty);
            orderEntryItemMap.put("orderEntryId", orderEntryId);
            orderEntryItemMap.put("orderId", orderId);
            orderEntryItemMap.put("orderNumber", orderNumber);
            orderEntryItemMap.put("orderEntryUnitInfo", orderEntryUnitInfo);
            orderEntryItemMap.put("orderEntryUnitInfo", orderEntryUnitInfo);
            orderEntryItemMap.put("warehouseInfo", wareHouseInfo);
            orderEntryList.add(orderEntryItemMap);
        }
        if (orderEntryList.size() == 0) {
            return;
        }
        IInventory ii = InventoryFactory.getRemoteInstance();
        ii.lockInventoryBatch(orderEntryList);
        SaleLockUIEnum aSaleLockUIEnum = (SaleLockUIEnum)((Object)this.combLockMaterial.getSelectedItem());
        this.tblOrderInsertRows(aSaleLockUIEnum.getValue());
    }
}

