/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ActionProxyFactory;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.credit.CreditCtrlResult;
import com.kingdee.eas.scm.credit.CreditFormulaSceneEnum;
import com.kingdee.eas.scm.credit.ICreditControlFacade;
import com.kingdee.eas.scm.credit.util.CreditOrgUnitUtils;
import com.kingdee.eas.scm.credit.util.CreditUtils;
import com.kingdee.eas.scm.im.dt.util.DtUtils;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.ISaleReturnsEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSaleReturnsListUI;
import com.kingdee.eas.scm.sd.sale.client.SaleReturnsEditUI;
import com.kingdee.eas.scm.sd.sale.client.SaleReturnsQueryUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;

public class SaleReturnsListUI
extends AbstractSaleReturnsListUI {
    private static final long serialVersionUID = 1L;
    private static final String TB_STATUS = "baseStatus";
    private static final String TB_BizType = "bizType";
    public static final String TB_ENTRIES_BASESTATUS = "entries_basestatus";
    SaleReturnsQueryUI conditionPanel = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected String readResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.client.SaleReturnsResource", (String)key);
    }

    protected SaleReturnsInfo getInfoById(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CoreBaseInfo info = SaleReturnsFactory.getRemoteInstance().getValue((IObjectPK)pk);
        if (info != null && info instanceof SaleReturnsInfo) {
            return (SaleReturnsInfo)info;
        }
        return null;
    }

    public SaleReturnsListUI() throws Exception {
        this.menuItemImportData.setVisible(true);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog != null) {
            this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
            return this.commonQueryDialog;
        }
        this.commonQueryDialog = super.initCommonQueryDialog();
        this.commonQueryDialog.setVisibleTableCols(this.getVisibleFields());
        return this.commonQueryDialog;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return SaleReturnsEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleReturnsFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        SaleReturnsInfo objectValue = new SaleReturnsInfo();
        return objectValue;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkRemove();
        super.actionRemove_actionPerformed(e);
    }

    private void checkRemove() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_STATUS).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString()) || baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString())) continue;
                String msg = MessageFormat.format(this.readResString("stateCannotDel"), baseStatus);
                MsgBox.showWarning((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    private void checkCancel() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_STATUS).getValue().toString();
                if (baseStatus.trim().equals(BillBaseStatusEnum.SUBMITED.toString())) continue;
                MsgBox.showError((Component)((Object)this), (String)this.readResString("check_cancel"));
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCancelBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCancel();
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(this.readResString("cancelPartialFail")).append("\n");
        boolean hasError = false;
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        try {
            this.setOprtState("REVOKE");
            int num = billIdlist.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(billIdlist[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                int n;
                if (reasonCodeInfo instanceof IObjectValue) {
                    n = billIdlist.length;
                    for (i = 0; i < n; ++i) {
                        try {
                            ((ISaleReturns)this.getBizInterface()).cancelWithReason((IObjectPK)new ObjectUuidPK(billIdlist[i]), (ReasonCodeInfo)reasonCodeInfo);
                            continue;
                        }
                        catch (EASBizException e1) {
                            hasError = true;
                        }
                    }
                }
                if (reasonCodeInfo instanceof String) {
                    n = billIdlist.length;
                    for (i = 0; i < n; ++i) {
                        try {
                            ((ISaleReturns)this.getBizInterface()).cancelWithReason((IObjectPK)new ObjectUuidPK(billIdlist[i]), (String)reasonCodeInfo);
                            continue;
                        }
                        catch (EASBizException e1) {
                            hasError = true;
                        }
                    }
                }
                if (hasError) {
                    MsgBox.showWarning((Component)((Object)this), (String)sbMsg.toString());
                } else {
                    this.setMessageText(this.readResString("cancelSuccess"));
                    this.showMessage();
                }
            }
            this.refreshList();
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean beforeAction(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, ActionEvent event) {
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISBATCHACTION", (Object)Boolean.FALSE);
        this.getMainOrgContext().put((Object)"CONTEXT_KEY_ISCHECKCREDIT_SERVER", (Object)Boolean.TRUE);
        boolean flag = super.beforeAction(bizAction, selectionEntries, event);
        if (!flag) {
            return flag;
        }
        if (!this.isCreditControl(bizAction)) {
            return false;
        }
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            try {
                ISaleReturns iSaleReturns = SaleReturnsFactory.getRemoteInstance();
                Map selectedIDNumberMap = this.getSelectedIdNumber();
                Object[] ids = selectedIDNumberMap.keySet().toArray();
                ObjectUuidPK[] pks = new ObjectUuidPK[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    pks[i] = new ObjectUuidPK(ids[i].toString());
                }
                if (pks.length > 0) {
                    StringBuffer saleIDs = new StringBuffer();
                    saleIDs.append("where id in (");
                    for (int j = 0; j < pks.length; ++j) {
                        if (j > 0) {
                            saleIDs.append(",");
                        }
                        saleIDs.append("'").append(pks[j]).append("'");
                    }
                    saleIDs.append(")");
                    SaleReturnsCollection saleReturnsCollection = iSaleReturns.getSaleReturnsCollection(saleIDs.toString());
                    if (saleReturnsCollection != null) {
                        for (int i = 0; i < saleReturnsCollection.size(); ++i) {
                            SaleReturnsInfo saleReturnsInfo = saleReturnsCollection.get(i);
                            flag = this.checkFetchInnerPriceCtrlBatch(saleReturnsInfo);
                            if (flag) continue;
                            return false;
                        }
                    }
                }
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
                return false;
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                return false;
            }
        }
        if (!bizAction.equals((Object)BatchActionEnum.AUDIT)) return flag;
        try {
            String saleOrgID = ((BatchSelectionEntry)selectionEntries.getEntries().get(0)).getOrgId();
            if (this.isCheapPrice(saleOrgID)) return flag;
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
            return false;
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            return false;
        }
        return flag;
    }

    private boolean isNeedHanldeCheckkCreditAtAudit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleReturnsInfo bill = (SaleReturnsInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtAudit(bill.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getReturnsCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCreditAtUnAudit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleReturnsInfo bill = (SaleReturnsInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtUnAudit(bill.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getReturnsCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCreditAtDelete(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleReturnsInfo bill = (SaleReturnsInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtDelete(bill.getId().toString(), CreditFormulaSceneEnum.SALERETURN);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getReturnsCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    private boolean isNeedHanldeCheckkCredit(IObjectValue model) throws Exception {
        boolean isNeedHanldeCheck = false;
        SaleReturnsInfo bill = (SaleReturnsInfo)model;
        ICreditControlFacade creditCtrl = CreditControlFacadeFactory.getRemoteInstance();
        CreditCtrlResult result = null;
        result = creditCtrl.verifyCreditAtSubmit((Object)bill);
        if (bill.getEntries() != null && bill.getEntries().size() > 0 && bill.getReturnsCustomer() != null && result.isRequiredCheck() && (result.isOverspend() || result.isTimeout())) {
            isNeedHanldeCheck = true;
        }
        return isNeedHanldeCheck;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkAudit();
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(this.readResString("auditPartialFail")).append("\n");
        boolean hasError = false;
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        SCMClientUtils.checkCurrentBillIsInActiveWorkFlow((String[])billIdlist);
        int n = billIdlist.length;
        for (int i = 0; i < n; ++i) {
            try {
                ((ISaleReturns)this.getBizInterface()).audit((IObjectPK)new ObjectUuidPK(billIdlist[i]));
                continue;
            }
            catch (EASBizException e1) {
                hasError = true;
            }
        }
        if (hasError) {
            if (billIdlist.length > 1) {
                MsgBox.showWarning((String)sbMsg.toString());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)this.readResString("cannotaudit"));
            }
        } else {
            this.setMessageText(this.readResString("auditSuccess"));
            this.showMessage();
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCloseBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] entryIDs = this.getBillEntryIDs();
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])entryIDs);
        ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getRemoteInstance();
        try {
            this.setOprtState("CLOSE");
            int num = entryIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(entryIDs[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showClosedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                if (reasonCodeInfo instanceof IObjectValue) {
                    iSaleReturnsEntry.closewithReason(pks, ((ReasonCodeInfo)reasonCodeInfo).getName());
                }
                if (reasonCodeInfo instanceof String) {
                    iSaleReturnsEntry.closewithReason(pks, (String)reasonCodeInfo);
                }
            }
            this.setMessageText(this.readResString("closeSuccess"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = entryIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(entryIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void checkBlock(IObjectPK[] pks) throws Exception {
        ISaleReturnsEntry iEntry = SaleReturnsEntryFactory.getRemoteInstance();
        ISaleReturns iSale = SaleReturnsFactory.getRemoteInstance();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo tempEntryInfo = (SaleReturnsEntryInfo)iEntry.getValue(pks[i]);
            SaleReturnsInfo info = iSale.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(tempEntryInfo.getParent().getId()));
            if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && tempEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            MsgBox.showError((String)this.readResString("check_block"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selEntryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        super.actionFreeze_actionPerformed(e);
        IObjectPK[] entrypks = SCMUtils.convertStringToObjectPK((String[])selEntryIDs);
        this.checkBlock(entrypks);
        ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        ISaleReturns iSaleReturns = (ISaleReturns)this.getBizInterface();
        try {
            this.setOprtState("FREEZED");
            int num = selEntryIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selEntryIDs[i]);
            }
            Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showBlockedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                SaleReturnsEntryInfo entryInfo;
                int j;
                int size;
                SaleReturnsEntryCollection entryCol;
                SaleReturnsInfo srInfo;
                boolean flag;
                int i;
                int num2;
                if (reasonCodeInfo instanceof IObjectValue) {
                    num2 = selEntryIDs.length;
                    for (i = 0; i < num2; ++i) {
                        iSaleReturnsEntry.freezeWithReason(entrypks[i], (ReasonCodeInfo)reasonCodeInfo);
                        flag = true;
                        srInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(iSaleReturnsEntry.getSaleReturnsEntryInfo(entrypks[i]).getParent().getId()));
                        entryCol = srInfo.getEntries();
                        if (entryCol != null) {
                            size = entryCol.size();
                            for (j = 0; j < size; ++j) {
                                entryInfo = entryCol.get(j);
                                if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.BLOCKED) continue;
                                flag = false;
                                break;
                            }
                        }
                        if (!flag) continue;
                        iSaleReturns.freeze((IObjectPK)new ObjectUuidPK(srInfo.getId()));
                    }
                }
                if (reasonCodeInfo instanceof String) {
                    num2 = selEntryIDs.length;
                    for (i = 0; i < num2; ++i) {
                        iSaleReturnsEntry.freezeWithReason(entrypks[i], (String)reasonCodeInfo);
                        flag = true;
                        srInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(iSaleReturnsEntry.getSaleReturnsEntryInfo(entrypks[i]).getParent().getId()));
                        entryCol = srInfo.getEntries();
                        if (entryCol != null) {
                            size = entryCol.size();
                            for (j = 0; j < size; ++j) {
                                entryInfo = entryCol.get(j);
                                if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.BLOCKED) continue;
                                flag = false;
                                break;
                            }
                        }
                        if (!flag) continue;
                        iSaleReturns.freeze((IObjectPK)new ObjectUuidPK(srInfo.getId()));
                    }
                }
            }
            this.setMessageText(this.readResString("freezeSuccess"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    private void checkUnBlock(IObjectPK[] pks) throws Exception {
        ISaleReturnsEntry iEntry = SaleReturnsEntryFactory.getRemoteInstance();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo tempEntryInfo = (SaleReturnsEntryInfo)iEntry.getValue(pks[i]);
            if (tempEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.BLOCKED)) continue;
            MsgBox.showError((Component)((Object)this), (String)this.readResString("check_unblock"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnFreeze_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] selEntryIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getEntriesPKName());
        super.actionUnFreeze_actionPerformed(e);
        IObjectPK[] entrypks = SCMUtils.convertStringToObjectPK((String[])selEntryIDs);
        this.checkUnBlock(entrypks);
        ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        ISaleReturns iSaleReturns = (ISaleReturns)this.getBizInterface();
        try {
            int i;
            this.setOprtState("UNFREEZED");
            int num = selEntryIDs.length;
            for (i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selEntryIDs[i]);
            }
            num = selEntryIDs.length;
            for (i = 0; i < num; ++i) {
                iSaleReturnsEntry.unfreezeLine(entrypks[i]);
                SaleReturnsInfo srInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(iSaleReturnsEntry.getSaleReturnsEntryInfo(entrypks[i]).getParent().getId()));
                if (!srInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) continue;
                iSaleReturns.unfreeze((IObjectPK)new ObjectUuidPK(srInfo.getId()));
            }
            this.setMessageText(this.readResString("unfreezeSuccess"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener(null);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.scm.sd.sale.SaleReturnsPrintQuery");
    }

    protected String getTDFileName() {
        return "/SCM/SD/SaleReturns";
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", TB_STATUS, TB_BizType, "bizDate", "sourceBillType.name", "orderCustomer", "customerNumber", "returnsCustomer", "invoiceCustomer", "saleOrgUnit", "saleSymbol", "totalAmount", "totalTaxAmount", "totalTax", "returnsReason", "currency", "description", "salePerson.name", "isCentralBalance", "creator.name", "createTime", "modifier.name", "modifyTime", "auditor.name", "auditTime", "adminOrgUnit", "paymentType.name", "processNode"};
    }

    public String[] getVisibleFields() {
        return new String[]{"number", "bizDate", "returnsCustomer", TB_STATUS, "saleOrgUnit", "entries.seq", "material.number", "material.name", "material.model", "unit.name", "entries_quantity", "storageOrgUnit", "entries.price", "entries.taxPrice", "entries.amount", "entries.tax", "entries.taxAmount"};
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleReturnsQueryUI();
        }
        return this.conditionPanel;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SaleReturnsQueryUI();
        }
        return this.conditionPanel;
    }

    protected SaleReturnsCollection getSelectedBills() throws EASBizException, BOSException {
        ArrayList list = this.getSelectedIdValues();
        SaleReturnsCollection ret = new SaleReturnsCollection();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK((String)list.get(i));
            SaleReturnsInfo info = (SaleReturnsInfo)SaleReturnsFactory.getRemoteInstance().getValue((IObjectPK)pk);
            ret.add(info);
        }
        return ret;
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionCreateTo_actionPerformed(e);
    }

    protected FilterInfo getBOTPFilterByBillType(String BillTypeId, OrgType destType, String destOrgId) {
        String billTypeId;
        HashMap botpMap;
        FilterInfo bizFilterInfo = null;
        if (this.getBOTPViewStatus() == 1 && (botpMap = this.getBOTPMap()) != null && botpMap.containsKey("DESTBILLTYPE.ID") && botpMap.get("DESTBILLTYPE.ID") != null && "18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(billTypeId = botpMap.get("DESTBILLTYPE.ID").toString())) {
            TransportOrgUnitInfo transport = (TransportOrgUnitInfo)botpMap.get("MAINBIZORG");
            OrgUnitCollection saleous = DtUtils.getOrgCollection(null, (TransportOrgUnitInfo)transport, (int)2);
            LinkedHashSet<String> saleIDs = new LinkedHashSet<String>();
            int size = saleous.size();
            for (int i = 0; i < size; ++i) {
                saleIDs.add(saleous.get(i).getId().toString());
            }
            bizFilterInfo = new FilterInfo();
            if (saleIDs != null && saleIDs.size() > 0) {
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", saleIDs, CompareType.INCLUDE));
            } else {
                bizFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
            }
        }
        return bizFilterInfo;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!"8B07BBDB".equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotp(srcBillInfos, destBosTypeList);
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("returnsCustomer.id"));
        sic.add(new SelectorItemInfo("returnsCustomer.name"));
        sic.add(new SelectorItemInfo("returnsCustomer.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("saleGroup.id"));
        sic.add(new SelectorItemInfo("saleGroup.name"));
        sic.add(new SelectorItemInfo("saleGroup.number"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.name"));
        sic.add(new SelectorItemInfo("salePerson.number"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.taxPrice"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entry.material.pricePrecision"));
        return sic;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex(TB_BizType));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnCloseBill.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.btnUnFreeze.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCancelBill.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnUnCloseBill.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.kDMenuItemUnClose.setIcon(EASResource.getIcon((String)"imgTbtn_fclose"));
        this.kDMenuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.kDMenuItemBlock.setIcon(EASResource.getIcon((String)"imgTbtn_freeze"));
        this.kDMenuItemUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.kDMenuItemCancel.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnAuditResult.setVisible(false);
        this.btnAudit.setVisible(true);
        this.menuItemAudit.setVisible(true);
        this.btnUnCloseBill.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.menuItemSubmit.setVisible(true);
        this.menuItemSubmit.setEnabled(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("modifyTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
        this.tblMain.getColumn("auditTime").getStyleAttributes().setNumberFormat(SCMClientUtils.strTimeFormat);
    }

    protected String[] getFormattedDateColumns() {
        return new String[]{"bizDate", "entries_returnsDate", "createTime", "modifyTime", "auditTime"};
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.refreshList();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.SaleReturns";
        param.alias = this.readResString("SaleReturns");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        this.initColPrecision(rowSet);
    }

    private void initColPrecision(IRowSet rowSet) {
        int amountPre = 2;
        int localAmountprc = 2;
        String[] QTY_COLUMNS = new String[]{"entries.quantity", "entries.returnsQty", "entries.remainingQty", "entries.invoiceQty", "entries.planDeliveryQty", "entries.planDeliveryBaseQty"};
        String[] PRICE_COLUMNS = new String[]{"entries.price", "entries.taxPrice"};
        String[] ASSISQTY_COLUMNS = new String[]{"entries.assistQuantity"};
        String[] AMOUNT_COLUMNS = new String[]{"totalAmount", "totalTaxAmount", "totalTax", "entries.amount", "entries.taxAmount", "entries.totalReturnAmt", "entries.invoicePrice"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{"entries.localAmount", "entries.localTax", "entries.localTaxAmount"};
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getInt("currency.precision") > 0) {
                    amountPre = rowSet.getInt("currency.precision");
                }
                if (!this.isSwitchView() && rowSet.getInt("currency2.precision") > 0) {
                    localAmountprc = rowSet.getInt("currency2.precision");
                }
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])QTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.qtyPrecision, (String[])ASSISQTY_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)this.pricePrecision, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])AMOUNT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)localAmountprc, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getAmountColumns() {
        return new String[]{"totalAmount", "totalTax", "totalTaxAmount", "entries.amount", "entries.tax", "entries.taxAmount", "entries.totalReturnAmt", "entries.localAmount", "entries.localTax", "entries.localTaxAmount"};
    }

    protected String[][] getNullColumns() {
        return new String[][]{{"NULL", "priceSourceType"}};
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"entries_quantity", "entries_returnsQty", "entries_remainingQty", "entries_invoiceQty", "entries_assistQuantity", "entries.planDeliveryQty", "entries.planDeliveryBaseQty"};
    }

    protected String[] getPriceColumns() throws Exception {
        return new String[]{"entries.price", "entries.taxPrice"};
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleReturnsInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }

    protected String[] getExColumns() throws Exception {
        return new String[]{"exchangeRate"};
    }

    protected String[] getTaxRateColumns() {
        return new String[]{"entries.taxRate"};
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        ISaleReturns iSaleReturns = (ISaleReturns)this.getBizInterface();
        this.checkSelected();
        String[] allIDs = KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
        String[] selIDs = SCMClientUtils.getSetArray((String[])allIDs);
        this.checkUnAudit(selIDs);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        iSaleReturns.unAudit(pks);
        this.setMessageText(SaleUtil.getUIResource("UNAUDIT_SUCCESS"));
        this.showMessage();
        this.refreshList();
    }

    protected void checkUnAudit(String[] selIDs) throws BOSException, EASBizException, SCMBillException {
        if (selIDs == null) {
            this.handleException((Exception)((Object)new OrderException(OrderException.ORDER_MUSTSELECT_ONERECORD, new String[]{SaleUtil.getUIResource("OPERATOR_AUDIT")})));
            return;
        }
        ISaleReturns iSaleReturns = SaleReturnsFactory.getRemoteInstance();
        int cont = selIDs.length;
        for (int i = 0; i < cont; ++i) {
            SaleReturnsInfo info = iSaleReturns.getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(selIDs[i]));
            SCMClientUtils.checkUnAuditDetail((SaleReturnsInfo)info);
        }
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, SaleReturnsFactory.class);
        this.actionManager.setClzIBizFactory(ActionLevelEnum.ENTRY, SaleReturnsEntryFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", "entries.id", "number", "entries.seq", "saleOrgUnit.id");
        ActionProxy actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CLOSE, (ItemAction)this.actionCloseBill, (String)"closewithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionCloseBill");
        actionProxy.bindTo((AbstractButton)this.btnCloseBill);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNCLOSE, (ItemAction)this.actionUnCloseBill, (String)"unCloseLine");
        this.actionManager.registerBatchAction(actionProxy, "actionUnCloseBill");
        actionProxy.bindTo((AbstractButton)this.btnUnCloseBill);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemUnClose);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.FREEZE, (ItemAction)this.actionFreeze, (String)"freezeWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionFreeze");
        actionProxy.bindTo((AbstractButton)this.btnFreeze);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemBlock);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.UNFREEZE, (ItemAction)this.actionUnFreeze, (String)"unfreezeLine");
        this.actionManager.registerBatchAction(actionProxy, "actionUnFreeze");
        actionProxy.bindTo((AbstractButton)this.btnUnFreeze);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemUnBlock);
        actionProxy = ActionProxyFactory.createActionProxy((BatchActionEnum)BatchActionEnum.CANCEL, (ItemAction)this.actionCancelBill, (String)"cancelWithReason");
        this.actionManager.registerBatchAction(actionProxy, "actionCancelBill");
        actionProxy.bindTo((AbstractButton)this.btnCancelBill);
        actionProxy.bindTo((AbstractButton)this.kDMenuItemCancel);
        super.initBatchActions();
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionNextPerson() {
        return false;
    }

    private boolean isCheapPrice(String saleOrgID) throws EASBizException, BOSException {
        String[] parameters = new String[]{"PricePa023"};
        HashMap map = ParamControlFactory.getRemoteInstance().getParamHashMap(parameters, saleOrgID);
        if (map != null && map.containsKey("PricePa023")) {
            String retStr = (String)map.get("PricePa023");
            return Boolean.valueOf(retStr);
        }
        return false;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    public String getsourceBillEntryId() {
        return "entries.sourceBillEntryId";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnCloseBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] entryIDs = this.getBillEntryIDs();
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])entryIDs);
        try {
            this.setOprtState("UNCLOSE");
            int num = entryIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(entryIDs[i]);
            }
            ISaleReturnsEntry iSaleReturnsEntry = SaleReturnsEntryFactory.getRemoteInstance();
            iSaleReturnsEntry.unCloseLine(pks);
            this.setMessageText(SaleUtil.getUIResource("UNCLOSE_ENTRY_SUCCESS"));
            this.showMessage();
            this.refreshList();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                int num = entryIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(entryIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected String getBaseQtyName() throws Exception {
        return "entries_quantity";
    }

    private boolean checkFetchInnerPriceCtrlBatch(SaleReturnsInfo info) throws EASBizException, BOSException {
        ISaleReturns iSaleReturns;
        Map retMap;
        if (info.getSourceBillType() != null && info.getSourceBillType().getId() != null && info.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
            return true;
        }
        if (info.getSaleOrgUnit().getId() == null) {
            return false;
        }
        boolean isCentral = info.isIsCentralBalance();
        boolean isSquare = info.isIsSquareBalance();
        String saleOrgId = info.getSaleOrgUnit().getId().toString();
        if (!this.isCheapPrice(saleOrgId) && isCentral && !(retMap = (iSaleReturns = SaleReturnsFactory.getRemoteInstance()).isPricePolicyPriceExist((IObjectValue)info)).isEmpty()) {
            int ctrlPolicy = this.canNotFetchInnerPriceCtrl(saleOrgId);
            Iterator it = retMap.keySet().iterator();
            String valStr = "";
            while (it.hasNext()) {
                String keyStr = (String)it.next();
                valStr = valStr + (String)retMap.get(keyStr) + "\r\n";
            }
            valStr = valStr + "  \r\n";
            if (ctrlPolicy == 2 || ctrlPolicy == 1) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)this.getStringRes("BILL_MATERIAL_NEED_INNERPRICE"), (String)valStr, (int)0);
                return false;
            }
        }
        return true;
    }

    public String getStringRes(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key);
    }

    private int canNotFetchInnerPriceCtrl(String saleOrgID) throws EASBizException, BOSException {
        String[] parameters = new String[]{"SALEORDER007"};
        HashMap map = ParamControlFactory.getRemoteInstance().getParamHashMap(parameters, saleOrgID);
        if (map != null && map.containsKey("SALEORDER007")) {
            String ctrlPolicy = (String)map.get("SALEORDER007");
            if (ctrlPolicy != null && ctrlPolicy.trim().length() > 0) {
                return Integer.valueOf(ctrlPolicy);
            }
            return 0;
        }
        return 0;
    }

    protected String getBillEntryName() {
        return "entries";
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo(IObjectValue info) throws Exception {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)info;
        return CreditOrgUnitUtils.readCompanyOrgUnitInfo(null, (OrgUnitInfo)saleReturnsInfo.getCompanyOrgUnit(), (boolean)true);
    }

    public CustomerInfo getCustomerInfo(IObjectValue info) throws Exception {
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)info;
        CustomerInfo customerInfo = saleReturnsInfo.getOrderCustomer() == null ? saleReturnsInfo.getReturnsCustomer() : saleReturnsInfo.getOrderCustomer();
        return CreditUtils.readFullCustomerInfo(null, (CustomerInfo)customerInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        try {
            this.getUserFunctionPermission(filterInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private void getUserFunctionPermission(FilterInfo filterInfo) throws Exception {
        ObjectUuidPK userId = null;
        ObjectUuidPK orgId = null;
        IPermission ipermission = null;
        FilterInfo tmpFilterInfo = null;
        userId = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        orgId = new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
        ipermission = PermissionFactory.getRemoteInstance();
        if (!ipermission.hasFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "Customer_Mana")) {
            tmpFilterInfo = SysContext.getSysContext().getCurrentUserInfo().getPerson() != null ? new FilterInfo("returnscustomer.id IN (select distinct b.fcustomerid FROM t_bd_customersaler a inner join t_bd_customersaleinfo b on a.FCustomerSaleID=b.fid  WHERE a.fpersonid = '" + SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString() + "')") : new FilterInfo("returnscustomer.id  IN (select distinct b.fcustomerid FROM t_bd_customersaler a inner join t_bd_customersaleinfo b on a.FCustomerSaleID=b.fid WHERE a.fpersonid = '###################')");
        }
        if (tmpFilterInfo != null) {
            filterInfo.mergeFilter(tmpFilterInfo, "and");
        }
    }

    protected HashMap getBOTPMap() {
        String billTypeId;
        HashMap map = (HashMap)this.getUIContext().get("BTPEDITPARAMETER");
        if (map == null) {
            return map;
        }
        map.put("has_owner_filter", false);
        if (map == null || !map.containsKey("DESTBILLTYPE.ID") || map.get("DESTBILLTYPE.ID") == null || (billTypeId = map.get("DESTBILLTYPE.ID").toString()).equals("18b7FpLNSrmaD8V9SPcOhkY+1VI=")) {
            // empty if block
        }
        return map;
    }
}

