/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.InvoicePrintDataSource;
import com.kingdee.eas.scm.sd.sale.ISalesExpenseInvoice;
import com.kingdee.eas.scm.sd.sale.SaleExpenseInvoiceException;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceAgent;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryAgent;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSalesExpenseInvoiceEditUI;
import com.kingdee.eas.scm.sd.sale.util.VerifyUtils;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SalesExpenseInvoiceEditUI
extends AbstractSalesExpenseInvoiceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SalesExpenseInvoiceEditUI.class);
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String TB_AMOUNT = "amount";
    private static final String TB_AMOUNTHOME = "amountHome";
    private static final String TB_QUANTITY = "quantity";
    private static final String TB_PRICE = "price";
    private static final String TB_EXPENSEITEM = "expenseItem";
    private static final String TB_EXPENSEITEMNAME = "expenseItemName";
    private static final String TB_AMOUNTTAX = "amountTax";
    private static final String TB_AMOUNTTAXHOME = "amountTaxHome";
    private static final String TB_AMOUNTWITHOUTTA = "amountWithoutTa";
    private static final String TB_AMOUNTNOTAXHOME = "amountNoTaxHome";
    private static final String TB_TAXRATIO = "taxRatio";
    private static final String TB_EXPENSETYEP = "expenseType";
    private KDFormattedTextField[] allAmount;
    private static final String[] allEntryAmount = new String[]{"quantity", "amount", "amountHome", "amountTax", "amountTaxHome", "amountWithoutTa", "amountNoTaxHome"};
    private static final String[] entryAmount = new String[]{"price", "quantity", "amount", "amountTax", "amountWithoutTa"};
    private static final String[] entryAmountHome = new String[]{"amountHome", "amountTaxHome", "amountNoTaxHome"};
    private IObjectPK oldPk;
    private SalesExpenseInvoiceInfo oldValue;
    private DataChangeListener prmtfiOrgUnitListener;
    private DataChangeListener prmtCurrencyListener;
    private DataChangeListener txtexchangeRateListener;
    CompanyOrgUnitInfo companyOrgInfo;
    ExchangeRateInfo exchangeRateInfo;
    CurrencyInfo currencyHomeInfo;
    private static final String[] ENTRY_NEED = new String[]{"expenseItem", "price", "quantity", "amount"};
    SCMClientHelper clientHelper;

    protected void showCannotBeEmptyMsg(KDLabelContainer label) {
        VerifyUtils.showCannotBeEmptyMsg(label.getBoundLabelText());
    }

    protected void verifyF7NotEmpty(KDBizPromptBox box, KDLabelContainer label) {
        if (box.getText() == null || box.getText().trim().length() == 0) {
            box.requestFocus();
            this.showCannotBeEmptyMsg(label);
        }
    }

    protected void verifyTextNotEmpty(JTextField edit, KDLabelContainer label) {
        if (edit.getText() == null || edit.getText().trim().length() == 0) {
            edit.requestFocus();
            this.showCannotBeEmptyMsg(label);
        }
    }

    public void verifyComboBoxNotEmpty(KDComboBox edit, KDLabelContainer label) {
        if (edit.getSelectedIndex() < 0) {
            edit.requestFocus();
            this.showCannotBeEmptyMsg(label);
        }
    }

    protected void veriyDatePickerNotEmpty(KDDatePicker datePicker, KDLabelContainer label) {
        if (datePicker.getText() == null || datePicker.getText().trim().length() == 0) {
            datePicker.requestFocus();
            this.showCannotBeEmptyMsg(label);
        }
    }

    protected String readResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)key);
    }

    protected void reloadData() throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
    }

    protected void makeActionsReadOnly(boolean value) {
        this.actionSave.setEnabled(value);
        this.actionAddLine.setEnabled(value);
        this.actionInsertLine.setEnabled(value);
        this.actionRemoveLine.setEnabled(value);
        this.actionSubmit.setEnabled(value);
    }

    protected IObjectPK getCurPK() {
        SalesExpenseInvoiceInfo info = this.editData;
        ObjectUuidPK ret = new ObjectUuidPK(info.getId());
        return ret;
    }

    public SalesExpenseInvoiceEditUI() throws Exception {
        this.allAmount = new KDFormattedTextField[]{this.txttotalAmount, this.txttotalTax, this.txtamountWithTax};
        this.oldPk = null;
        this.oldValue = null;
        this.prmtfiOrgUnitListener = null;
        this.companyOrgInfo = null;
        this.exchangeRateInfo = null;
        this.currencyHomeInfo = null;
        this.clientHelper = new SCMClientHelper((SCMBillEditUI)this);
        this.initDefaultData(SysContext.getSysContext().getCurrentFIUnit());
        if (this.exchangeRateInfo == null) {
            this.exchangeRateInfo = this.getDefaultExchangeRateInfo();
        }
    }

    protected void initKDTEntry() {
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntrys, (String[])new String[]{TB_EXPENSEITEM, TB_PRICE, TB_QUANTITY, TB_AMOUNT});
    }

    private void initBtn() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnDeleteBill.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnCancelVerify.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.kDMenuItemVerify.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        if (this.isFromMsgCenterToEditUI(this)) {
            this.btnAudit.setEnabled(false);
            this.btnCancelVerify.setEnabled(false);
            this.btnDeleteBill.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnPrintPreview.setEnabled(false);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.pkinvoiceDate.requestFocusInWindow();
        if (this.txtNumber.isEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.pkinvoiceDate.requestFocus();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtbrief.setMaxLength(80);
        SCMClientUtils.setEntriesTableStrLength((KDTable)this.kdtEntrys, (String[])new String[]{"remark"}, (int)80);
        this.initHeadNumber();
        this.initBtn();
        this.initKDTEntry();
        this.kdtEntrys.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent arg0) {
            }

            public void editStarted(KDTEditEvent arg0) {
            }

            public void editValueChanged(KDTEditEvent arg0) {
            }

            public void editStopping(KDTEditEvent arg0) {
            }

            public void editStopped(KDTEditEvent arg0) {
                try {
                    SalesExpenseInvoiceEditUI.this.kdtEntrys_editStopped(arg0);
                }
                catch (Exception e) {
                    SalesExpenseInvoiceEditUI.this.handUIException(e);
                }
            }

            public void editCanceled(KDTEditEvent arg0) {
            }
        });
        this.pkinvoiceDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
            }
        });
        try {
            GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = null;
            selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.prmtcustomer, (Component)new F7CustomerTreeDetailListUI(), (Object)this, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard", "browseGroup.id");
            this.assignSelector((KDPromptBox)this.prmtcustomer, (KDPromptSelector)selectorLisenterCustomer);
            selectorLisenterCustomer.setQueryProperty("mnemonicCode", "or");
            this.prmtcustomer.addSelectorListener((SelectorListener)selectorLisenterCustomer);
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        KDBizPromptBox kdtEntrys_expenseItem_PromptBox = new KDBizPromptBox();
        kdtEntrys_expenseItem_PromptBox.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7ExpenseItemQuery");
        kdtEntrys_expenseItem_PromptBox.setVisible(true);
        kdtEntrys_expenseItem_PromptBox.setEditable(true);
        kdtEntrys_expenseItem_PromptBox.setDisplayFormat("$name$");
        kdtEntrys_expenseItem_PromptBox.setEditFormat("$number$");
        kdtEntrys_expenseItem_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntrys_expenseItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_expenseItem_PromptBox);
        this.kdtEntrys.getColumn(TB_EXPENSEITEM).setEditor((ICellEditor)kdtEntrys_expenseItem_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn(TB_EXPENSEITEM).setRenderer((IBasicRender)avr);
        KDBizPromptBox prmtExpenseType = new KDBizPromptBox();
        prmtExpenseType.setQueryInfo("com.kingdee.eas.basedata.scm.common.app.F7ExpenseTypeQuery");
        prmtExpenseType.setEditable(true);
        prmtExpenseType.setEditFormat("$name$");
        prmtExpenseType.setDisplayFormat("$number$");
        prmtExpenseType.setCommitFormat("$number$");
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)prmtExpenseType);
        this.kdtEntrys.getColumn(TB_EXPENSETYEP).setEditor((ICellEditor)itemEditor);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtfiOrgUnit);
        SCMClientUtils.setF7OrgUnitBizUnit((KDBizPromptBox)this.prmtsaleOrgUnit);
        SCMClientUtils.setCompanyOrgF7((KDBizPromptBox)this.prmtfiOrgUnit);
        SCMClientUtils.setSaleOrgF7((KDBizPromptBox)this.prmtsaleOrgUnit);
        SCMClientUtils.setNecessColorInTable((KDTable)this.kdtEntrys, (String)TB_TAXRATIO);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initHeadNumber() {
        this.txtexchage.setHorizontalAlignment(4);
        this.txttotalAmount.setHorizontalAlignment(4);
        this.txtamountWithTax.setHorizontalAlignment(4);
        this.txttotalTax.setHorizontalAlignment(4);
        this.txtexchage.setSupportedEmpty(true);
        this.txttotalAmount.setSupportedEmpty(true);
        this.txtamountWithTax.setSupportedEmpty(true);
        this.txttotalTax.setSupportedEmpty(true);
        this.txtexchage.setRemoveingZeroInDispaly(false);
        this.txttotalAmount.setRemoveingZeroInDispaly(false);
        this.txtamountWithTax.setRemoveingZeroInDispaly(false);
        this.txttotalTax.setRemoveingZeroInDispaly(false);
    }

    protected void clearField() {
        this.txttotalAmount.setText(null);
        this.txttotalTax.setText(null);
        this.txtamountWithTax.setText(null);
    }

    @Override
    public void loadFields() {
        if (this.prmtfiOrgUnitListener != null) {
            this.prmtfiOrgUnit.removeDataChangeListener(this.prmtfiOrgUnitListener);
        }
        if (this.prmtCurrencyListener != null) {
            this.prmtcurrency.removeDataChangeListener(this.prmtCurrencyListener);
        }
        if (this.txtexchangeRateListener != null) {
            this.txtexchage.removeDataChangeListener(this.txtexchangeRateListener);
        }
        this.clearField();
        if (this.editData.getCompanyOrgUnit() != null && this.oprtState.equals(OprtState.ADDNEW)) {
            CompanyOrgUnitInfo org = this.editData.getCompanyOrgUnit();
            try {
                this.isAutoNumber = this.isAutoNumber(org.getId().toString());
                if (this.isAutoNumber) {
                    this.isAddView = this.isAddView(org.getId().toString());
                    if (this.isAddView && this.isAutoNumber && (this.editData.getNumber() == null || this.editData.getNumber().toString().trim().length() == 0)) {
                        this.getNumTextField().setText(null);
                        String newNum = this.getNewNumberByUnit(org.getId().toString());
                        this.getNumTextField().setText(newNum);
                        this.editData.setNumber(newNum);
                    }
                } else {
                    super.setEditable(true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        super.loadFields();
        this.initF7ControlListener();
        this.clientHelper.registerRequireColumns(ENTRY_NEED);
        this.initPrecision();
        if (this.editData.isIsReversed()) {
            this.btnSubmit.setEnabled(false);
            this.btnSave.setEnabled(false);
        }
        if (this.oprtState.equalsIgnoreCase(OprtState.ADDNEW)) {
            this.prmtfiOrgUnit.setEnabled(true);
        }
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.prmtfiOrgUnit.setEnabled(false);
        }
        if (this.prmtfiOrgUnit.getData() == null) {
            this.prmtcustomer.setEnabled(false);
        } else {
            this.setCustomerF7();
        }
        this.disPlayDataToRed();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void setCustomerF7() {
        CompanyOrgUnitInfo OrgUnitInfo2 = (CompanyOrgUnitInfo)this.prmtfiOrgUnit.getData();
        if (OrgUnitInfo2 != null) {
            this.prmtcustomer.setEnabled(true);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)OrgUnitInfo2.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            this.prmtcustomer.setEntityViewInfo(viewInfo);
        } else {
            this.prmtcustomer.setEnabled(false);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.prmtfiOrgUnit.setEnabled(false);
        }
    }

    private void initF7ControlListener() {
        this.prmtfiOrgUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SalesExpenseInvoiceEditUI.this.prmtCompanyOrgUnit_dataChange(e);
                }
                catch (Exception exc) {
                    SalesExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtfiOrgUnit.addDataChangeListener(this.prmtfiOrgUnitListener);
        this.prmtcustomer.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    if (SalesExpenseInvoiceEditUI.this.prmtcustomer.getData() != null) {
                        SalesExpenseInvoiceEditUI.this.customerChange((CustomerInfo)SalesExpenseInvoiceEditUI.this.prmtcustomer.getData(), (CompanyOrgUnitInfo)SalesExpenseInvoiceEditUI.this.prmtfiOrgUnit.getData());
                    }
                }
                catch (Exception exc) {
                    SalesExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtCurrencyListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SalesExpenseInvoiceEditUI.this.prmtcurrency_dataChanged1(e);
                }
                catch (Exception exc) {
                    SalesExpenseInvoiceEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtcurrency.addDataChangeListener(this.prmtCurrencyListener);
        if (this.txtexchangeRateListener == null) {
            this.txtexchangeRateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        SalesExpenseInvoiceEditUI.this.txtExchangeRate_dataChanged(e);
                    }
                    catch (Exception exc) {
                        SalesExpenseInvoiceEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.txtexchage.addDataChangeListener(this.txtexchangeRateListener);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 ");
        viewInfo.setFilter(filter);
        this.prmtPaymentType.setEntityViewInfo(viewInfo);
    }

    private void txtExchangeRate_dataChanged(DataChangeEvent e) {
        int scale = this.prmtcurrency.getData() == null ? 2 : ((CurrencyInfo)this.prmtcurrency.getData()).getPrecision();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            this.calEntryAmount(row, scale);
            this.calEntryAmountTax(row, scale);
            this.calAmountTaxHome(row, scale);
            this.calcAmountHome(row);
            this.calcAmountTaxHome(row);
            this.calcAmountNoTaxHome(row);
        }
    }

    @Override
    public void storeFields() {
        try {
            this.editData.setAdminOrgUnit(this.getAdminOrgUnitInfo());
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        super.storeFields();
    }

    protected void updateButtonStatus() {
        super.updateButtonStatus();
        if (this.oprtState.equals("ADDNEW")) {
            this.btnAudit.setEnabled(false);
        }
        switch (this.editData.getBaseStatus().getValue()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.actionRemove.setEnabled(false);
                this.actionDeleteBill.setEnabled(false);
                this.actionAudit.setEnabled(false);
                break;
            }
            case 2: {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
                this.actionDeleteBill.setEnabled(true);
                this.actionAudit.setEnabled(true);
                break;
            }
            default: {
                logger.warn((Object)(this.readResString("BillStateInvalid") + this.editData.getBaseStatus().toString()));
            }
        }
    }

    protected void calcAmountHome(IRow row) {
        if (this.txtexchage.getText() != null && this.txtexchage.getText().trim().length() > 0) {
            int scale;
            String strExRate = this.txtexchage.getText();
            BigDecimal objExRate = new BigDecimal(strExRate);
            Object objCash = row.getCell(TB_AMOUNT).getValue();
            int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
            if (objCash != null) {
                BigDecimal bdExRate = objExRate;
                BigDecimal bdCash = (BigDecimal)objCash;
                if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    row.getCell(TB_AMOUNTHOME).setValue((Object)bdCash.divide(bdExRate, scale, 4));
                } else {
                    row.getCell(TB_AMOUNTHOME).setValue((Object)bdCash.multiply(bdExRate).setScale(scale, 4));
                }
            }
        } else {
            row.getCell(TB_AMOUNTHOME).setValue((Object)ZERO);
        }
    }

    protected void calcAmountTaxHome(IRow row) {
        int scale;
        String strExchangeRate = this.txtexchage.getText();
        Object objMortTaxRate = row.getCell(TB_AMOUNTTAX).getValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (strExchangeRate != null && strExchangeRate.trim().length() > 0 && objMortTaxRate != null) {
            BigDecimal bdExRate = new BigDecimal(strExchangeRate);
            BigDecimal bdMortTax = (BigDecimal)objMortTaxRate;
            if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                row.getCell(TB_AMOUNTTAXHOME).setValue((Object)bdMortTax.divide(bdExRate, scale, 4));
            } else {
                row.getCell(TB_AMOUNTTAXHOME).setValue((Object)bdExRate.multiply(bdMortTax).setScale(scale, 4));
            }
        }
    }

    protected void calcAmountNoTaxHome(IRow row) {
        int scale;
        String strExchangeRate = this.txtexchage.getText();
        Object objNoTaxCash = row.getCell(TB_AMOUNTWITHOUTTA).getValue();
        int n = scale = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        if (strExchangeRate != null && strExchangeRate.trim().length() > 0 && objNoTaxCash != null) {
            BigDecimal bdExRate = new BigDecimal(strExchangeRate);
            BigDecimal bdNoTaxCash = new BigDecimal(objNoTaxCash.toString());
            if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                row.getCell(TB_AMOUNTNOTAXHOME).setValue((Object)bdNoTaxCash.divide(bdExRate, scale, 4));
            } else {
                row.getCell(TB_AMOUNTNOTAXHOME).setValue((Object)bdExRate.multiply(bdNoTaxCash).setScale(scale, 4));
            }
        } else {
            row.getCell(TB_AMOUNTNOTAXHOME).setValue((Object)ZERO);
        }
    }

    protected void calcNoTaxCash(IRow row) {
        Object objAmount = row.getCell(TB_AMOUNT).getValue();
        Object objAmountTax = row.getCell(TB_AMOUNTTAX).getValue();
        if (objAmount != null && objAmountTax != null) {
            BigDecimal bdAmount = new BigDecimal(objAmount.toString());
            BigDecimal bdAmountTax = new BigDecimal(objAmountTax.toString());
            row.getCell(TB_AMOUNTWITHOUTTA).setValue((Object)bdAmount.subtract(bdAmountTax));
        }
    }

    private void calEntryAmount(IRow row, int scale) {
        Object objAmount = row.getCell(TB_QUANTITY).getValue();
        Object objFeePrice = row.getCell(TB_PRICE).getValue();
        if (objAmount != null && objFeePrice != null) {
            BigDecimal bdAmount = new BigDecimal(objAmount.toString());
            BigDecimal bdFeePrice = new BigDecimal(objFeePrice.toString());
            row.getCell(TB_AMOUNT).setValue((Object)bdAmount.multiply(bdFeePrice).setScale(scale, 4));
            row.getCell("amountUnPaid").setValue((Object)bdAmount.multiply(bdFeePrice).setScale(scale, 4));
        }
    }

    private void calEntryAmountTax(IRow row, int scale) {
        Object objAmount = row.getCell(TB_AMOUNT).getValue();
        Object objTaxRate = row.getCell(TB_TAXRATIO).getValue();
        if (objAmount != null && objTaxRate != null) {
            BigDecimal bdAmount = new BigDecimal(objAmount.toString());
            BigDecimal bdTaxRate = new BigDecimal(objTaxRate.toString()).divide(new BigDecimal("100"), 10, 4);
            row.getCell(TB_AMOUNTTAX).setValue((Object)bdAmount.multiply(bdTaxRate).setScale(scale, 4));
        }
    }

    private void calAmountTaxHome(IRow row, int scale) {
        String strExchangeRate = this.txtexchage.getText();
        Object objMortTaxRate = row.getCell(TB_AMOUNTTAX).getValue();
        if (strExchangeRate != null && strExchangeRate.trim().length() > 0 && objMortTaxRate != null) {
            BigDecimal bdExRate = new BigDecimal(strExchangeRate);
            BigDecimal bdMortTax = new BigDecimal(objMortTaxRate.toString());
            if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                row.getCell(TB_AMOUNTTAXHOME).setValue((Object)bdMortTax.divide(bdExRate, scale, 4));
            } else {
                row.getCell(TB_AMOUNTTAXHOME).setValue((Object)bdExRate.multiply(bdMortTax).setScale(scale, 4));
            }
        } else {
            row.getCell(TB_AMOUNTTAXHOME).setValue((Object)ZERO);
        }
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        BigDecimal qty;
        BigDecimal price;
        BigDecimal taxRate;
        int rowInd = e.getRowIndex();
        int colInd = e.getColIndex();
        IRow row = this.kdtEntrys.getRow(rowInd);
        int scale = this.prmtcurrency.getData() == null ? 2 : ((CurrencyInfo)this.prmtcurrency.getData()).getPrecision();
        int scale1 = this.currencyHomeInfo == null ? 2 : this.currencyHomeInfo.getPrecision();
        String fieldName = this.kdtEntrys.getColumnKey(colInd);
        if (fieldName.equalsIgnoreCase(TB_TAXRATIO) && (taxRate = (BigDecimal)this.kdtEntrys.getRow(rowInd).getCell(TB_TAXRATIO).getValue()) != null && (taxRate.compareTo(new BigDecimal("100.00")) == 1 || taxRate.compareTo(new BigDecimal("0.00")) == -1)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)"taxRateThan100"));
            this.kdtEntrys.getRow(rowInd).getCell(TB_TAXRATIO).setValue((Object)new BigDecimal("0.00"));
            SysUtil.abort();
        }
        if (fieldName.equalsIgnoreCase(TB_PRICE) && (price = (BigDecimal)this.kdtEntrys.getRow(rowInd).getCell(TB_PRICE).getValue()) != null && price.compareTo(new BigDecimal("0.00")) == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)"priceLessZero"));
            this.kdtEntrys.getRow(rowInd).getCell(TB_PRICE).setValue((Object)new BigDecimal("0.00"));
            SysUtil.abort();
        }
        if (fieldName.equalsIgnoreCase(TB_QUANTITY) && (qty = (BigDecimal)this.kdtEntrys.getRow(rowInd).getCell(TB_QUANTITY).getValue()) != null && qty.compareTo(new BigDecimal("0.00")) == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)"qtyLessZero"));
            this.kdtEntrys.getRow(rowInd).getCell(TB_QUANTITY).setValue((Object)new BigDecimal("0.00"));
            SysUtil.abort();
        }
        this.calEntryAmount(row, scale);
        this.calEntryAmountTax(row, scale);
        this.calAmountTaxHome(row, scale1);
        if (this.txtexchage.getText() != null && this.txtexchage.getText().trim().length() > 0) {
            this.calcAmountHome(row);
        }
        if (colInd == this.kdtEntrys.getColumnIndex(TB_EXPENSEITEM)) {
            Object objFeeCode = row.getCell(TB_EXPENSEITEM).getValue();
            if (objFeeCode != null && objFeeCode instanceof ExpenseItemInfo) {
                Object objFeeItem = row.getCell(TB_EXPENSEITEM).getValue();
                if (objFeeItem != null && objFeeItem instanceof ExpenseItemInfo) {
                    BOSUuid unitInfoID;
                    MeasureUnitInfo unitInfo;
                    ExpenseItemInfo info = (ExpenseItemInfo)objFeeItem;
                    row.getCell(TB_EXPENSEITEMNAME).setValue((Object)info.getName());
                    if (info.getExpenseType() != null) {
                        ExpenseTypeInfo typeInfo = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(info.getExpenseType().getId()));
                        row.getCell(TB_EXPENSETYEP).setValue((Object)typeInfo);
                    }
                    if ((unitInfo = info.getDefaultUnit()) != null && (unitInfoID = info.getDefaultUnit().getId()) != null) {
                        try {
                            unitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfoID));
                            this.kdtEntrys.getRow(rowInd).getCell("measureUnit").setValue((Object)unitInfo);
                            this.kdtEntrys.getRow(rowInd).getCell("measureUnit").setUserObject((Object)unitInfo);
                        }
                        catch (Exception e1) {
                            logger.error((Object)e1);
                        }
                    }
                }
            } else {
                this.kdtEntrys.getRow(rowInd).getCell("measureUnit").setValue(null);
                this.kdtEntrys.getRow(rowInd).getCell(TB_EXPENSETYEP).setValue(null);
                this.kdtEntrys.getRow(rowInd).getCell(TB_EXPENSEITEMNAME).setValue(null);
            }
        }
        this.calcNoTaxCash(row);
        this.calcAmountTaxHome(row);
        this.calcAmountNoTaxHome(row);
        this.calcSum();
    }

    private void submitVerify() {
        this.verifyF7NotEmpty(this.prmtcustomer, this.contcustomer);
        this.verifyF7NotEmpty(this.prmtfiOrgUnit, this.contfiOrgUnit);
        this.verifyF7NotEmpty(this.prmtcurrency, this.contcurrency);
        this.veriyDatePickerNotEmpty(this.pkinvoiceDate, this.continvoiceDate);
        this.veriyDatePickerNotEmpty(this.pkarDate, this.contarDate);
        this.verifyF7NotEmpty(this.prmtSettleType, this.contsettlementType);
        this.verifyF7NotEmpty(this.prmtPaymentType, this.contpaymentType);
        this.clientHelper.checkEntryRquiredColumns();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            BigDecimal bdPrice;
            BigDecimal bdAmount;
            IRow row = this.kdtEntrys.getRow(i);
            Object objQty = row.getCell(TB_QUANTITY).getValue();
            Object objPrice = row.getCell(TB_PRICE).getValue();
            if (objQty instanceof BigDecimal && (bdAmount = (BigDecimal)objQty).compareTo(ZERO) == -10 && !this.editData.getRedBlueType().equals((Object)RedBlueEnum.BLUE)) {
                MsgBox.showWarning((String)this.readResString("AmountMustMoreThanZero"));
                this.kdtEntrys.getSelectManager().select(this.kdtEntrys.getColumnIndex(TB_QUANTITY), i);
                SysUtil.abort();
            }
            if (!(objPrice instanceof BigDecimal) || (bdPrice = (BigDecimal)objPrice).compareTo(ZERO) != -1) continue;
            MsgBox.showWarning((String)this.readResString("PriceMustMoreThanZero"));
            this.kdtEntrys.getSelectManager().select(this.kdtEntrys.getColumnIndex(TB_PRICE), i);
            SysUtil.abort();
        }
        this.verifyTextNotEmpty((JTextField)this.txttotalAmount, this.conttotalAmount);
        this.verifyTextNotEmpty((JTextField)this.txttotalTax, this.conttotalTax);
        this.verifyTextNotEmpty((JTextField)this.txtamountWithTax, this.contamountWithTax);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verifyTextNotEmpty((JTextField)this.txtNumber, this.contNumber);
    }

    protected void calcSum() {
        BigDecimal bdCash = new BigDecimal("0");
        BigDecimal bdTaxCash = new BigDecimal("0");
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            Object objCash = row.getCell(TB_AMOUNT).getValue();
            Object objTaxCash = row.getCell(TB_AMOUNTTAX).getValue();
            if (objCash != null && objCash instanceof BigDecimal) {
                bdCash = bdCash.add((BigDecimal)objCash);
            }
            if (objTaxCash == null || !(objTaxCash instanceof BigDecimal)) continue;
            bdTaxCash = bdTaxCash.add((BigDecimal)objTaxCash);
        }
        this.editData.setTotalAmount(bdCash.subtract(bdTaxCash));
        this.editData.setTotalTax(bdTaxCash);
        this.editData.setTotalTaxAmount(bdCash);
        this.txttotalAmount.setValue((Object)bdCash.subtract(bdTaxCash));
        this.txttotalTax.setValue((Object)bdTaxCash);
        this.txtamountWithTax.setValue((Object)this.editData.getTotalTaxAmount());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SalesExpenseInvoiceFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    protected IObjectValue createNewData() {
        SalesExpenseInvoiceInfo objectValue = null;
        try {
            objectValue = this.isUseAgent() ? SalesExpenseInvoiceAgent.create() : new SalesExpenseInvoiceInfo();
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            objectValue.setBillType(billTypeInfo);
            SysContext sysCtx = SysContext.getSysContext();
            objectValue.setCreator(sysCtx.getCurrentUserInfo());
            objectValue.setBaseStatus(BillBaseStatusEnum.ADD);
            objectValue.setInvoiceDate(new Date(System.currentTimeMillis()));
            objectValue.setSaleOrgUnit(sysCtx.getCurrentSaleUnit());
            if (SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit()) {
                objectValue.setCompanyOrgUnit(sysCtx.getCurrentFIUnit());
            } else {
                objectValue.setCompanyOrgUnit(null);
            }
            objectValue.setBizDate(new Date(System.currentTimeMillis()));
            objectValue.setAdminOrgUnit(SysContext.getSysContext().getCurrentAdminUnit());
            try {
                objectValue.setCurrency(this.getCurrencyHome());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            objectValue.setExchangeRate(new BigDecimal("1.00"));
            objectValue.setRedBlueType(RedBlueEnum.BLUE);
            objectValue.setIsReversed(false);
            objectValue.getEntries().add((SalesExpenseInvoiceEntryInfo)this.createNewDetailData(null));
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        SalesExpenseInvoiceEntryInfo info = null;
        try {
            info = this.isUseAgent() ? SalesExpenseInvoiceEntryAgent.create() : new SalesExpenseInvoiceEntryInfo();
            info.setTaxRate(new BigDecimal("0.00"));
            info.setSettlementStatus(SettlementStateEnum.UNSETTLED);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return info;
    }

    private void setAutoNumber() {
        if (this.editData.getNumber() == null) {
            String sysNumber = null;
            try {
                sysNumber = FrameWorkUtils.getCodeRuleClient((CoreBillBaseInfo)this.editData, (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (sysNumber != null && sysNumber.trim().length() > 0) {
                this.editData.setNumber(sysNumber);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            this.txtNumber.setText(this.editData.getNumber());
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    protected void prmtcurrency_dataChanged1(DataChangeEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)e.getNewValue();
        CurrencyInfo oldCurrencyInfo = (CurrencyInfo)e.getOldValue();
        if (currencyInfo != null && oldCurrencyInfo != null) {
            currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
            oldCurrencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(oldCurrencyInfo.getId()));
            CompanyOrgUnitInfo couInfo = (CompanyOrgUnitInfo)this.prmtfiOrgUnit.getData();
            this.currencyChange(couInfo, currencyInfo, oldCurrencyInfo);
        }
    }

    private void currencyChange(CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo sourcecurrencyInfo, CurrencyInfo oldCurrencyInfo) throws BOSException, EASBizException {
        SCMClientUtils.calPriceByCurrencyChange((CompanyOrgUnitInfo)ficompanyOrgInfo, (CurrencyInfo)sourcecurrencyInfo, (CurrencyInfo)oldCurrencyInfo, (KDTable)this.kdtEntrys, (String)TB_PRICE);
        this.currencyChange(sourcecurrencyInfo);
    }

    protected void checkBeforeDeleteBill() {
        if (this.getOprtState() == OprtState.ADDNEW || this.editData.getBaseStatus().getValue() != 2) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)"CannotDeleteBill"));
            SysUtil.abort();
        }
    }

    public boolean checkBeforeAudit() throws Exception {
        return this.editData.getBaseStatus().getValue() != 2;
    }

    @Override
    public void actionDeleteBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteBill_actionPerformed(e);
        this.checkBeforeDeleteBill();
        Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        if (reasonCodeInfo == null) {
            SysUtil.abort();
        } else {
            ISalesExpenseInvoice iSaleExpenseInvoice;
            if (reasonCodeInfo instanceof IObjectValue) {
                iSaleExpenseInvoice = SalesExpenseInvoiceFactory.getRemoteInstance();
                try {
                    iSaleExpenseInvoice.cancelWithReason(this.getCurPK(), (ReasonCodeInfo)reasonCodeInfo);
                    this.setMessageText(this.readResString("CancelBillSucceed"));
                    this.showMessage();
                }
                catch (EASBizException ex) {
                    this.handleException((Exception)((Object)ex));
                }
            }
            if (reasonCodeInfo instanceof String) {
                iSaleExpenseInvoice = SalesExpenseInvoiceFactory.getRemoteInstance();
                try {
                    iSaleExpenseInvoice.cancelWithReason(this.getCurPK(), (String)reasonCodeInfo);
                    this.setMessageText(this.readResString("CancelBillSucceed"));
                    this.showMessage();
                }
                catch (EASBizException ex) {
                    this.handleException((Exception)((Object)ex));
                }
            }
        }
        this.reloadData();
        this.updateButtonStatus();
    }

    private CurrencyInfo getCurrencyHome() throws EASBizException, BOSException {
        CompanyOrgUnitInfo comOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (comOrgInfo.getBaseCurrency() != null) {
            CurrencyInfo curHomeInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrgInfo.getBaseCurrency().getId()));
            return curHomeInfo;
        }
        throw new SaleExpenseInvoiceException(SaleExpenseInvoiceException.NOTFINDHOMECURRENCY);
    }

    private ExchangeRateInfo getExchangeRateInfo(CurrencyInfo srcCurInfo) throws BOSException, EASBizException {
        ExchangeTableInfo exchangeTableInfo = SysContext.getSysContext().getCurrentFIUnit().getBaseExchangeTable();
        if (exchangeTableInfo != null) {
            ObjectUuidPK excTablepk = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseExchangeTable().getId());
            ObjectUuidPK srcCurPK = new ObjectUuidPK(srcCurInfo.getId());
            ObjectUuidPK homeCurPK = new ObjectUuidPK(this.getCurrencyHome().getId());
            ExchangeRateInfo ret = ExchangeRateFactory.getRemoteInstance().getExchangeRate((IObjectPK)excTablepk, (IObjectPK)srcCurPK, (IObjectPK)homeCurPK, Calendar.getInstance().getTime());
            return ret;
        }
        return null;
    }

    private void updateColPrec(String colName, String format, ICellEditor editor) {
        this.kdtEntrys.getColumn(colName).getStyleAttributes().setNumberFormat(format);
        this.kdtEntrys.getColumn(colName).setEditor(editor);
    }

    private void updatePrecision(CurrencyInfo currencyInfo) {
        this.txttotalAmount.setPrecision(currencyInfo.getPrecision());
        this.txttotalTax.setPrecision(currencyInfo.getPrecision());
        this.txtamountWithTax.setPrecision(currencyInfo.getPrecision());
        this.txtexchage.setPrecision(currencyInfo.getPrecision());
    }

    protected void currencyChange(CurrencyInfo srcCurrency) throws EASBizException, BOSException {
        BigDecimal exchangeRate = null;
        if (this.currencyHomeInfo.getId().equals((Object)srcCurrency.getId())) {
            exchangeRate = new BigDecimal("1.00");
            this.txtexchage.setValue((Object)exchangeRate);
            this.txtexchage.setPrecision(2);
        } else {
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo exchangeTableInfo = this.companyOrgInfo.getBaseExchangeTable();
            if (exchangeTableInfo != null) {
                excTablepk = new ObjectUuidPK(this.companyOrgInfo.getBaseExchangeTable().getId());
            }
            sourceCurrPK = new ObjectUuidPK(srcCurrency.getId());
            destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            if (tempexrateinfo != null) {
                this.exchangeRateInfo = tempexrateinfo;
                exchangeRate = this.exchangeRateInfo.getConvertRate();
                this.txtexchage.setPrecision(this.exchangeRateInfo.getPrecision());
                this.txtexchage.setValue((Object)exchangeRate);
            }
        }
        int scale = this.prmtcurrency.getData() == null ? 2 : ((CurrencyInfo)this.prmtcurrency.getData()).getPrecision();
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            this.calEntryAmount(row, scale);
            this.calEntryAmountTax(row, scale);
            this.calcNoTaxCash(row);
            this.calcAmountHome(row);
            this.calcAmountTaxHome(row);
            this.calcAmountNoTaxHome(row);
            this.calcSum();
        }
        this.changePrecision(srcCurrency);
    }

    private void changePrecision(CurrencyInfo currencyInfo) {
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDFormattedTextField[])this.allAmount);
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.kdtEntrys, (String[])entryAmount);
        SCMClientUtils.changeTableColPrecision((int)this.currencyHomeInfo.getPrecision(), (KDTable)this.kdtEntrys, (String[])entryAmountHome);
    }

    @Override
    public void actionCancelVerify_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)this.readResString("addnew_cannot_verify"));
            return;
        }
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) || this.editData.isIsReversed()) {
            MsgBox.showError((Component)((Object)this), (String)this.readResString("check_verify_edit"));
            return;
        }
        IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK(this.editData.getId())};
        ISalesExpenseInvoice iSalesExpenseInvoice = (ISalesExpenseInvoice)this.getBizInterface();
        IObjectPK[] newpks = null;
        try {
            newpks = iSalesExpenseInvoice.createReverse(pks);
            this.setMessageText(this.readResString("CancelVerifySuccess"));
            this.showMessage();
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        SelectorItemCollection sic = this.getBOTPSelectors();
        this.setDataObject((IObjectValue)iSalesExpenseInvoice.getSalesExpenseInvoiceInfo(newpks[0], sic));
        this.loadFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        SalesExpenseInvoiceFactory.getRemoteInstance().audit(this.getCurPK());
        this.setMessageText(this.readResString("AuditSucceed"));
        this.showMessage();
        this.reloadData();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 1) {
            SCMClientUtils.delEmptyEntry((KDTable)this.kdtEntrys, (String)TB_EXPENSEITEM, (SCMBillEditUI)this);
        }
        this.submitVerify();
        if (this.editData.getBillType() == null) {
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            this.editData.setBillType(billTypeInfo);
        }
        if (this.oprtState.equals(OprtState.ADDNEW) && this.editData.getRedBlueType().equals((Object)RedBlueEnum.RED)) {
            this.oldValue.setIsReversed(true);
            SalesExpenseInvoiceFactory.getRemoteInstance().update(this.oldPk, (CoreBaseInfo)this.oldValue);
        }
        super.actionSubmit_actionPerformed(e);
    }

    private void customerChange(CustomerInfo customerInfo, CompanyOrgUnitInfo companyOrgUnitInfo) throws BOSException, EASBizException {
        if (customerInfo == null) {
            throw new IllegalArgumentException();
        }
        if (customerInfo.getTaxRegisterNo() != null && customerInfo.getTaxRegisterNo().length() > 0) {
            this.txtTaxRegNum.setText(customerInfo.getTaxRegisterNo());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("bank"));
        sic.add(new SelectorItemInfo("bankAccount"));
        CustomerCompanyInfoInfo customerCompanyInfo = null;
        if (companyOrgUnitInfo != null) {
            customerCompanyInfo = CustomerFactory.getRemoteInstance().getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerInfo.getId()), (IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()), sic);
        }
        if (customerCompanyInfo != null) {
            if (customerCompanyInfo.getBank() != null) {
                this.txtCustBank.setText(customerCompanyInfo.getBank());
            }
            if (customerCompanyInfo.getBankAccount() != null) {
                this.txtCustAccountNumber.setText(customerCompanyInfo.getBankAccount());
            }
            if (customerCompanyInfo.getPaymentType() != null) {
                this.prmtPaymentType.setValue((Object)customerCompanyInfo.getPaymentType());
            }
            if (customerCompanyInfo.getSettlementType() != null) {
                this.prmtSettleType.setValue((Object)customerCompanyInfo.getSettlementType());
            }
        }
    }

    private void disPlayDataToRed() {
        if (this.editData != null && this.editData.isIsReversed() && this.editData.getTotalAmount().compareTo(ZERO) <= 0) {
            for (int i = 0; i < this.allAmount.length; ++i) {
                this.allAmount[i].setForeground(Color.RED);
                BigDecimal amount = (BigDecimal)this.allAmount[i].getNumberValue();
                if (amount == null) continue;
                this.allAmount[i].setValue((Object)amount.abs());
            }
            int num = this.kdtEntrys.getRowCount();
            for (int row = 0; row < num; ++row) {
                ICell cell = null;
                for (int i = 0; i < allEntryAmount.length; ++i) {
                    cell = this.kdtEntrys.getCell(row, allEntryAmount[i]);
                    cell.getStyleAttributes().setFontColor(Color.RED);
                    BigDecimal amount = (BigDecimal)cell.getValue();
                    if (amount == null) continue;
                    cell.setValue((Object)amount.abs());
                }
            }
        }
    }

    private void prmtCompanyOrgUnit_dataChange(DataChangeEvent e) throws Exception {
        Object vo = this.prmtfiOrgUnit.getData();
        CompanyOrgUnitInfo cInfo = null;
        if (vo != null && !e.getNewValue().equals(e.getOldValue())) {
            cInfo = (CompanyOrgUnitInfo)vo;
            if (e.getOldValue() != null) {
                MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)"prompt_clear_comorg"));
            }
            this.setNumberEnabled(cInfo.getId().toString());
            SalesExpenseInvoiceInfo tempInfo = (SalesExpenseInvoiceInfo)this.createNewData();
            tempInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)this.prmtfiOrgUnit.getValue());
            this.setDataObject((IObjectValue)tempInfo);
            try {
                this.isAutoNumber = this.isAutoNumber(cInfo.getId().toString());
                if (this.isAutoNumber) {
                    this.isAddView = this.isAddView(cInfo.getId().toString());
                    if (this.isAddView && this.isAutoNumber) {
                        this.getNumTextField().setText(null);
                        String newNum = this.getNewNumberByUnit(cInfo.getId().toString());
                        this.getNumTextField().setText(newNum);
                        this.editData.setNumber(newNum);
                    }
                } else {
                    super.setEditable(true);
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.setEditable(true);
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            this.loadFields();
        }
        if (cInfo != null) {
            this.initDefaultData(cInfo);
        }
        this.setCustomerF7();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("reasonCode.name"));
        sic.add(new SelectorItemInfo("reasonCode.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        return sic;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtfiOrgUnit;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, false);
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        SalesExpenseInvoiceCollection billCol = new SalesExpenseInvoiceCollection();
        billCol.add(this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        InvoicePrintDataSource rsprv = new InvoicePrintDataSource(billCol){

            public InvoicePrintDataSource.ColDesc[] getColDesc() {
                return new InvoicePrintDataSource.ColDesc[]{new InvoicePrintDataSource.ColDesc("number", "number"), new InvoicePrintDataSource.ColDesc("fiOrgUnit", "companyOrgUnit.number"), new InvoicePrintDataSource.ColDesc("saleOrgUnit", "saleOrgUnit.name"), new InvoicePrintDataSource.ColDesc("customer", "customer.name"), new InvoicePrintDataSource.ColDesc("baseStatus", "baseStatus"), new InvoicePrintDataSource.ColDesc("paymentType", "paymentType.name"), new InvoicePrintDataSource.ColDesc("settlementType", "settlementType.name"), new InvoicePrintDataSource.ColDesc("currency", "currency.name"), new InvoicePrintDataSource.ColDesc("exchage", "exchage", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("invoiceDate", "invoiceDate", 2), new InvoicePrintDataSource.ColDesc("reasonCode", "reasonCode.name"), new InvoicePrintDataSource.ColDesc("voucherNumber", "voucherNumber"), new InvoicePrintDataSource.ColDesc("fiVouchered", "fiVouchered"), new InvoicePrintDataSource.ColDesc("remark", "remark"), new InvoicePrintDataSource.ColDesc("creator", "creator.name"), new InvoicePrintDataSource.ColDesc("createTime", "createTime", 2), new InvoicePrintDataSource.ColDesc("lastupdateUser", "modifier.name"), new InvoicePrintDataSource.ColDesc("lastupdateTime", "modificationTime", 2), new InvoicePrintDataSource.ColDesc("audit", "auditor.name"), new InvoicePrintDataSource.ColDesc("auditTime", "auditTime", 2), new InvoicePrintDataSource.ColDesc("localTax", "totalTax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("nonTaxAmount", "totalTax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("localAmount", "totalTaxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_seq", "entries.seq"), new InvoicePrintDataSource.ColDesc("e_expenseItem", "entries.expenseItem.name"), new InvoicePrintDataSource.ColDesc("e_measureUnit", "expenseItem.measureUnit.name"), new InvoicePrintDataSource.ColDesc("e_qty", "entries.qty", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_price", "entries.price", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_amount", "entries.amount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_localAmount", "entries.localAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_taxRate", "entries.taxRate", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_localTax", "entries.localTax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_amountTax", "entries.tax", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_nonTaxAmount", "entries.nonTaxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_localNonTaxAmount", "entries.localNonTaxAmount", 1, (Object)"2"), new InvoicePrintDataSource.ColDesc("e_remark", "entries.remark")};
            }
        };
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListner());
        if (noPreview) {
            appHlp.print("/SCM/SD/SaleExpenseInvoice", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/SCM/SD/SaleExpenseInvoice", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    public boolean isFromMsgCenterToEditUI(SCMBillEditUI ui) {
        Map ctx = ui.getUIContext();
        boolean isFromMsgCenter = Boolean.TRUE.equals(ctx.get("isFromWorkflow"));
        return isFromMsgCenter;
    }

    protected void checkCanEdit() throws Exception {
        String id = this.editData.getId().toString();
        if (id != null) {
            SalesExpenseInvoiceInfo sinfo;
            ObjectStringPK pk = new ObjectStringPK(id);
            SalesExpenseInvoiceInfo billInfo = this.editData;
            if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                MsgBox.showError((Component)((Object)this), (String)(SCMClientUtils.getResource((String)"BillAt") + billInfo.getBaseStatus().getAlias() + SCMClientUtils.getResource((String)"CantBeEdited")));
                SysUtil.abort();
            }
            if ((sinfo = SalesExpenseInvoiceFactory.getRemoteInstance().getSalesExpenseInvoiceInfo((IObjectPK)pk)).isIsReversed()) {
                MsgBox.showError((String)this.readResString("reverse_cannot_edit"));
                SysUtil.abort();
            }
        }
    }

    private ExchangeRateInfo getDefaultExchangeRateInfo() {
        ExchangeRateInfo tempExchangeRateinfo = new ExchangeRateInfo();
        tempExchangeRateinfo.setConvertRate(new BigDecimal("1.00"));
        tempExchangeRateinfo.setExchangeAux(this.getDefaultExchangeAuxInfo());
        return tempExchangeRateinfo;
    }

    private ExchangeAuxInfo getDefaultExchangeAuxInfo() {
        ExchangeAuxInfo exAux = new ExchangeAuxInfo();
        exAux.setPrecision(2);
        exAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        return exAux;
    }

    private void initDefaultData(CompanyOrgUnitInfo couInfo) throws Exception {
        this.companyOrgInfo = couInfo;
        if (this.companyOrgInfo.getBaseCurrency() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_BASECURRENCY);
        }
        this.currencyHomeInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.companyOrgInfo.getBaseCurrency().getId()));
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        ExchangeTableInfo exchangeTableInfo = this.companyOrgInfo.getBaseExchangeTable();
        if (exchangeTableInfo == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_EXCHANGETABLE);
        }
        excTablepk = new ObjectUuidPK(this.companyOrgInfo.getBaseExchangeTable().getId());
        sourceCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
        this.exchangeRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
        if (this.oprtState != null && this.oprtState.equalsIgnoreCase("ADDNEW")) {
            this.prmtcurrency.setData((Object)this.currencyHomeInfo);
            this.changePrecision(this.currencyHomeInfo);
        }
    }

    private void initPrecision() {
        this.initPurPrecision();
        this.initEntryPrecision();
    }

    private void initPurPrecision() {
        CurrencyInfo currencyInfo = this.prmtcurrency.getValue() == null ? null : (CurrencyInfo)this.prmtcurrency.getValue();
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDFormattedTextField[])this.allAmount);
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId());
        sourceCurrPK = currencyInfo == null ? destCurrPK : new ObjectUuidPK(currencyInfo.getId());
        ExchangeRateInfo tempexrateinfo = null;
        try {
            tempexrateinfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)this.companyOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (tempexrateinfo != null) {
            this.exchangeRateInfo = tempexrateinfo;
            this.txtexchage.setPrecision(this.exchangeRateInfo.getPrecision());
        } else {
            this.txtexchage.setPrecision(2);
        }
    }

    private void initEntryPrecision() {
        CurrencyInfo currencyInfo;
        SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)this.currencyHomeInfo, (KDTable)this.getDetailTable(), (String[])entryAmountHome);
        CurrencyInfo currencyInfo2 = currencyInfo = this.prmtcurrency.getValue() == null ? null : (CurrencyInfo)this.prmtcurrency.getValue();
        if (currencyInfo != null) {
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currencyInfo, (KDTable)this.getDetailTable(), (String[])entryAmount);
        } else {
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.kdtEntrys, (String[])entryAmount);
        }
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.kdtEntrys, (String[])new String[]{TB_QUANTITY});
        SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.kdtEntrys, (String[])new String[]{TB_TAXRATIO});
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        SalesExpenseInvoiceInfo sinfo = (SalesExpenseInvoiceInfo)newData;
        sinfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
        sinfo.setVoucherNumber(null);
        sinfo.setFiVouchered(false);
        sinfo.setAuditTime(null);
        sinfo.setAuditor(null);
        sinfo.setModifier(null);
        sinfo.setModificationTime(null);
        sinfo.setLastUpdateTime(null);
        sinfo.setLastUpdateUser(null);
        sinfo.setIsReversed(false);
        sinfo.setReverseInvNumber(null);
        sinfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
        sinfo.setSourceBillId(null);
        sinfo.setSourceBillType(null);
        SalesExpenseInvoiceEntryCollection collection = sinfo.getEntries();
        if (collection != null) {
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                SalesExpenseInvoiceEntryInfo entryinfo = collection.get(i);
                entryinfo.setSettlementStatus(SettlementStateEnum.UNSETTLED);
            }
        }
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.calcSum();
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void setNumWhereCopy() throws Exception {
    }

    protected String getOnloadPermItemName() {
        if ("ADDNEW".equals(this.getOprtState())) {
            return "salesExpInv_addnew";
        }
        return null;
    }

    protected void insertLine(int row) {
        if (this.kdtEntrys == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetailData(this.kdtEntrys);
        IRow irow = null;
        irow = this.kdtEntrys.addRow(row);
        this.editData.getEntries().addObject(detailData);
        this.loadLineFields(this.kdtEntrys, irow, detailData);
        this.afterInsertLine(this.kdtEntrys, detailData);
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo() throws EASBizException, BOSException {
        SaleOrgUnitInfo saleInfo = (SaleOrgUnitInfo)this.prmtsaleOrgUnit.getData();
        AdminOrgUnitInfo adminInfo = null;
        if (saleInfo != null) {
            IOrgUnitRelation iour = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection ioc = iour.getToUnit(saleInfo.getId().toString(), 2, 0);
            OrgUnitInfo ouInfo = null;
            int size = ioc.size();
            for (int i = 0; i < size; ++i) {
                ouInfo = ioc.get(i);
                if (ouInfo == null) continue;
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(ouInfo.getId());
                adminInfo.setName(ouInfo.getName());
                adminInfo.setNumber(ouInfo.getNumber());
                return adminInfo;
            }
        }
        return adminInfo;
    }

    static class PrintListner
    implements IPrintActionListener {
        PrintListner() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
            IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SalesExpenseInvoiceInfo().getBOSType(), null, (String)operName);
            LogUtil.afterLog(null, (IObjectPK)pk);
        }

        public void closePreview() {
        }
    }
}

