/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.client.ReasonF7Until;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.UserQueryFilterProcessor;
import com.kingdee.eas.scm.sd.sale.ISalesExpenseInvoice;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractSalesExpenseInvoiceListUI;
import com.kingdee.eas.scm.sd.sale.client.SalesExpenseInvoiceEditUI;
import com.kingdee.eas.scm.sd.sale.client.SalesExpenseInvoiceQueryUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SalesExpenseInvoiceListUI
extends AbstractSalesExpenseInvoiceListUI {
    private static final Logger logger = CoreUIObject.getLogger(SalesExpenseInvoiceListUI.class);
    private static final String TB_ID = "id";
    private static final String TB_NUMBER = "number";
    private static final String TB_BASESTATE = "baseStatus";
    private static final String TB_ISREVERSE = "isRedBill";
    private static final String[] AMOUTCOLS = new String[]{"entries_price", "entries_amount", "entries_amountHome", "entries_amountTax", "entries_amountTaxHome", "entries_amountPaid", "entries_amountUnPaid", "entries_amountWithoutTa", "entries_amountNoTaxHome", "entries_quantity", "totalAmount", "totalTax", "amountWithTax"};
    private static final String TB_Precision = "precision";
    CommonQueryDialog conditionDialog = null;
    SalesExpenseInvoiceQueryUI conditionPanel = null;
    Map companyOrgisArScmRelateMap = new HashMap();

    public SalesExpenseInvoiceListUI() throws Exception {
        boolean isArScmRelate = false;
        isArScmRelate = SCMClientUtils.isARRelationSCM((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
        this.companyOrgisArScmRelateMap.put(SysContext.getSysContext().getCurrentFIUnit().getId().toString(), new Boolean(isArScmRelate));
        if (isArScmRelate) {
            this.btnVoucher.setEnabled(false);
            this.menuItemVoucher.setEnabled(false);
            this.btnDelVoucher.setEnabled(false);
            this.menuItemDelVoucher.setEnabled(false);
        } else {
            this.btnVoucher.setEnabled(true);
            this.menuItemVoucher.setEnabled(true);
            this.btnDelVoucher.setEnabled(true);
            this.menuItemDelVoucher.setEnabled(true);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return SalesExpenseInvoiceEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SalesExpenseInvoiceFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SalesExpenseInvoiceInfo objectValue = new SalesExpenseInvoiceInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.getSelectedIdValues();
        super.onLoad();
        this.tblMain.getViewManager().setFreezeView(0, this.tblMain.getColumnIndex("invoiceDate"));
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SalesExpenseInvoiceListUI.this.initAmoutPrecision(e);
            }
        });
        this.initBtn();
        this.changeVoucherBtn();
    }

    private void initBtn() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnCancelInvoice.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnCheckCancelVerify.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.kDMenuItem4.setIcon(EASResource.getIcon((String)"imgTbtn_redclash"));
        this.kDMenuItem2.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
    }

    protected String readResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SalesExpenseInvoice", (String)key);
    }

    protected SalesExpenseInvoiceInfo getInfoById(String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CoreBaseInfo info = SalesExpenseInvoiceFactory.getRemoteInstance().getValue((IObjectPK)pk);
        if (info != null && info instanceof SalesExpenseInvoiceInfo) {
            return (SalesExpenseInvoiceInfo)info;
        }
        return null;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.conditionDialog.setShowFilter(true);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setWidth(430);
            this.conditionDialog.setHeight(310);
            try {
                this.conditionDialog.addUserPanel(this.getConditionPanel());
                UserQueryFilterProcessor userFilter = new UserQueryFilterProcessor();
                userFilter.setOwner((IUIObject)this.conditionPanel);
                this.conditionDialog.setProcessor((IProcessor)userFilter);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.conditionDialog.setQueryObjectPK(this.mainQueryPK);
            this.conditionDialog.setParentUIClassName(SalesExpenseInvoiceListUI.class.getName());
        }
        return this.conditionDialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SalesExpenseInvoiceQueryUI();
        }
        return this.conditionPanel;
    }

    @Override
    public void actionCancelInvoice_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCancel();
        Object reasonCodeInfo = ReasonF7Until.getReason((IUIWindow)ReasonF7Until.showRevokedReasonUI((Map)this.getUIContext(), (IUIWindow)this.getUIWindow()));
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int count = billIdlist.length;
        if (count != 0) {
            if (reasonCodeInfo == null) {
                SysUtil.abort();
            } else {
                int i;
                if (reasonCodeInfo instanceof IObjectValue) {
                    for (i = 0; i < count; ++i) {
                        try {
                            ((ISalesExpenseInvoice)this.getBizInterface()).cancelWithReason((IObjectPK)new ObjectStringPK(billIdlist[i]), (ReasonCodeInfo)reasonCodeInfo);
                            continue;
                        }
                        catch (Exception ex) {
                            this.handleException(ex);
                        }
                    }
                }
                if (reasonCodeInfo instanceof String) {
                    for (i = 0; i < count; ++i) {
                        try {
                            ((ISalesExpenseInvoice)this.getBizInterface()).cancelWithReason((IObjectPK)new ObjectStringPK(billIdlist[i]), (String)reasonCodeInfo);
                            continue;
                        }
                        catch (Exception ex) {
                            this.handleException(ex);
                        }
                    }
                }
                this.setMessageText(this.readResString("CancelBillSucceed"));
                this.showMessage();
            }
        }
        this.refreshList();
    }

    private void checkCancel() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equals(BillBaseStatusEnum.SUBMITED.toString())) continue;
                MsgBox.showError((String)this.readResString("check_cancel"));
                SysUtil.abort();
            }
        }
    }

    private void checkReverser() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String baseStatus = row.getCell(TB_BASESTATE).getValue().toString();
                if (baseStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString()) && !row.getCell(TB_ISREVERSE).getValue().toString().equalsIgnoreCase("true")) continue;
                MsgBox.showError((String)this.readResString("check_reverse"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCheckCancelVerify_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkReverser();
        super.actionCheckCancelVerify_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
            try {
                IObjectPK[] newPKs = ((ISalesExpenseInvoice)this.getBizInterface()).createReverse(pks);
                this.setMessageText(this.readResString("CheckVerifySuccess"));
                this.showMessage();
                this.refreshList();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{TB_NUMBER, "customer", TB_BASESTATE, "exchage", "currency", "fiOrgUnit", "fiVouchered", "invoiceDate", "paymentType", "lnkReasonCode", "remark", "brief", "saleGroup", "saleOrgUnit", "salePerson", "settlementType", "totalAmount", "totalTax", "amountWithTax", "arDate", "vourchNo"};
    }

    private String getNumberById(String id) {
        String ret = "";
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell(TB_ID).getValue().equals(id)) continue;
            ret = (String)row.getCell(TB_NUMBER).getValue();
        }
        return ret;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append(this.readResString("AuditPartalFail")).append("\n");
        boolean hasError = false;
        String[] billIdlist = SCMClientUtils.filterDistnctID((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName()));
        int n = billIdlist.length;
        for (int i = 0; i < n; ++i) {
            try {
                SalesExpenseInvoiceFactory.getRemoteInstance().audit((IObjectPK)new ObjectUuidPK(billIdlist[i]));
                continue;
            }
            catch (EASBizException e1) {
                String number = this.getNumberById(billIdlist[i]);
                hasError = true;
            }
        }
        if (hasError) {
            MsgBox.showWarning((String)sbMsg.toString());
        } else {
            this.setMessageText(this.readResString("AuditSucceed"));
        }
        this.refreshList();
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo(TB_NUMBER));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("fiOrgUnit.id"));
        sic.add(new SelectorItemInfo("fiOrgUnit.number"));
        sic.add(new SelectorItemInfo("fiOrgUnit.name"));
        sic.add(new SelectorItemInfo("salePerson.id"));
        sic.add(new SelectorItemInfo("salePerson.number"));
        sic.add(new SelectorItemInfo("salePerson.name"));
        sic.add(new SelectorItemInfo("department.id"));
        sic.add(new SelectorItemInfo("department.number"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("exchage"));
        sic.add(new SelectorItemInfo("amountWithTax"));
        sic.add(new SelectorItemInfo("entries.amountHome"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.measureUnit.id"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.number"));
        return sic;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        this.logUIOperation("LOG_IMPORT");
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.SalesExpenseInvoice";
        param.alias = this.readResString("SalesExpenseInvoice");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkedit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkedit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!row.getCell(TB_ISREVERSE).getValue().toString().equalsIgnoreCase("true")) continue;
                MsgBox.showError((String)this.readResString("reverse_cannot_edit"));
                SysUtil.abort();
            }
        }
    }

    private void disPlayDataToRed(KDTDataRequestEvent e) {
        int last = e.getLastRow();
        for (int i = e.getFirstRow(); i <= last; ++i) {
            if (this.tblMain.getCell(i, TB_ISREVERSE).getValue() == null || !(this.tblMain.getCell(i, TB_ISREVERSE).getValue() instanceof Boolean) || !((Boolean)this.tblMain.getCell(i, TB_ISREVERSE).getValue()).booleanValue()) continue;
            for (int j = 0; j < AMOUTCOLS.length; ++j) {
                BigDecimal value = (BigDecimal)this.tblMain.getCell(i, AMOUTCOLS[j]).getValue();
                if (value == null) continue;
                this.tblMain.getCell(i, AMOUTCOLS[j]).setValue((Object)value.abs());
                this.tblMain.getCell(i, AMOUTCOLS[j]).getStyleAttributes().setFontColor(Color.RED);
            }
        }
    }

    private void initAmoutPrecision(KDTDataRequestEvent e) {
        int last = e.getLastRow();
        for (int i = e.getFirstRow(); i <= last; ++i) {
            if (this.tblMain.getCell(i, TB_Precision).getValue() != null) {
                int precision = Integer.parseInt(this.tblMain.getCell(i, TB_Precision).getValue().toString());
                SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.tblMain, (String[])AMOUTCOLS);
                continue;
            }
            SCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.tblMain, (String[])AMOUTCOLS);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        FilterInfo companyOrgFilter = SCMClientUtils.getF7FilterInfoByAuthorizedCompanyOrg((String)"fiOrgUnit.id");
        try {
            filter.mergeFilter(companyOrgFilter, "AND");
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return filter;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.canCreateVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void canCreateVoucher() {
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            SysUtil.abort();
        }
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                BizEnumValueInfo value = (BizEnumValueInfo)row.getCell(TB_BASESTATE).getValue();
                if (value.getValue().equals(String.valueOf(BillBaseStatusEnum.AUDITED.getValue()))) continue;
                MsgBox.showError((String)this.readResString("expInv_cannotVoucher"));
                SysUtil.abort();
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1) {
            this.changeVoucherBtn();
        }
    }

    private void changeVoucherBtn() throws Exception {
        SalesExpenseInvoiceInfo info = this.getSelectedSalesExpInvInfo();
        if (info != null && info.getCompanyOrgUnit() != null) {
            if (this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString()) == null) {
                boolean isArScmRelate = false;
                isArScmRelate = SCMClientUtils.isARRelationSCM((CompanyOrgUnitInfo)info.getCompanyOrgUnit());
                this.companyOrgisArScmRelateMap.put(info.getCompanyOrgUnit().getId().toString(), new Boolean(isArScmRelate));
            }
            if (((Boolean)this.companyOrgisArScmRelateMap.get(info.getCompanyOrgUnit().getId().toString())).booleanValue()) {
                this.btnVoucher.setEnabled(false);
                this.menuItemVoucher.setEnabled(false);
                this.btnDelVoucher.setEnabled(false);
                this.menuItemDelVoucher.setEnabled(false);
            } else {
                this.btnVoucher.setEnabled(true);
                this.menuItemVoucher.setEnabled(true);
                this.btnDelVoucher.setEnabled(true);
                this.menuItemDelVoucher.setEnabled(true);
            }
        }
    }

    private SalesExpenseInvoiceInfo getSelectedSalesExpInvInfo() throws Exception {
        SalesExpenseInvoiceInfo saleExpInvoiceInfo = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return null;
        }
        ISalesExpenseInvoice iSalesExpenseInvoice = SalesExpenseInvoiceFactory.getRemoteInstance();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                ObjectStringPK pk = new ObjectStringPK(row.getCell(TB_ID).getValue().toString());
                saleExpInvoiceInfo = iSalesExpenseInvoice.getSalesExpenseInvoiceInfo((IObjectPK)pk);
            }
        }
        return saleExpInvoiceInfo;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo() throws Exception {
        ISalesExpenseInvoice iSalesExpInvoice = SalesExpenseInvoiceFactory.getRemoteInstance();
        String[] billIdlist = this.getSelectedListId();
        ObjectStringPK pk = new ObjectStringPK(billIdlist[0]);
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        SalesExpenseInvoiceInfo salesExpinvInfo = iSalesExpInvoice.getSalesExpenseInvoiceInfo((IObjectPK)pk, sic);
        return salesExpinvInfo.getCompanyOrgUnit();
    }

    private String[] getSelectedListId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        HashMap<String, String> mapId = new HashMap<String, String>();
        if (selectBlock != null) {
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell cell = row.getCell(this.getKeyFieldName());
                Object keyValue = cell.getValue();
                if (keyValue == null || mapId.containsKey(keyValue.toString())) continue;
                mapId.put(keyValue.toString(), keyValue.toString());
            }
        }
        String[] listId = null;
        if (mapId != null && mapId.size() > 0) {
            Iterator iterat = mapId.keySet().iterator();
            listId = new String[mapId.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        this.initColPrecision(rowSet);
    }

    private void initColPrecision(IRowSet rowSet) {
        int amountPre = 2;
        int localAmountPre = 2;
        String[] AMOUNT_COLUMNS = new String[]{"totalAmount", "totalTax", "amountWithTax", "entries.amount", "entries.amountTax", "entries.amountWithoutTa"};
        String[] LOCALAMOUNT_COLUMNS = new String[]{"entries.amountHome", "entries.amountTaxHome", "entries.amountNoTaxHome"};
        try {
            while (rowSet.next()) {
                amountPre = rowSet.getInt("currency.precision");
                localAmountPre = rowSet.getInt("baseCurrency.precision");
                SCMClientUtils.iniColumnsPrecision((int)amountPre, (String[])AMOUNT_COLUMNS, (IRowSet)rowSet);
                SCMClientUtils.iniColumnsPrecision((int)localAmountPre, (String[])LOCALAMOUNT_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceDown_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = SCMClientUtils.getResource((String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SalesExpenseInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void logPrint() {
        this.logUIOperation("LOG_PRINT");
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.SALESMANAGEMENT;
    }
}

