/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractConsignIssueBalanceConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConsignIssueBalanceConditionUI
extends AbstractConsignIssueBalanceConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(ConsignIssueBalanceConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.ConsignSaleBalanceResource";
    private static final String permItem_view = "consign_verify";
    private Map curPeriodMap = new HashMap();

    public ConsignIssueBalanceConditionUI() throws Exception {
        this.setSize(440, 280);
        this.isReport = false;
        this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.kdtVerifyDate);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        SingleFilterElement mainOrgElement = new SingleFilterElement("StorageOrgUnit", (Component)this.bizPromptStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        element = new SingleFilterElement("SaleOrgUnit", (Component)this.bizPromptSaleOrgUnit);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialFrom", (Component)this.bizPrmtMaterialFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialTo", (Component)this.bizPrmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("Customer", (Component)this.bizPrmtCustomer);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("balanceCustomer", (Component)this.bizPrmtBalanceCustomer);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.bizPrmtCustomer, this.bizPrmtMaterialFrom, this.bizPrmtMaterialTo, this.bizPromptSaleOrgUnit});
        this.setDateDefaultValue();
    }

    private void setDateDefaultValue() {
        this.bizPromptStorageOrgUnit.setData((Object)this.getDefaultMainBizOrg());
        this.bizPrmtCustomer.setData(null);
        this.bizPrmtMaterialFrom.setData(null);
        this.bizPrmtMaterialTo.setData(null);
        this.setVerifyDate(null);
    }

    private void setVerifyDate(String companyID) {
        try {
            this.kdtVerifyDate.setValue((Object)SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    private SystemStatusCtrolCollection getSystemStatusColl(String companyID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)String.valueOf(2)));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("systemStatus.*"));
        view.getSelector().add(new SelectorItemInfo("startPeriod.*"));
        view.getSelector().add(new SelectorItemInfo("currentPeriod.*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        return SystemStatusCtrolFactory.getRemoteInstance().getSystemStatusCtrolCollection(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.bizPromptStorageOrgUnit, (OrgType)OrgType.Storage, (String)permItem_view);
        this.bizPromptStorageOrgUnit.setEnabledMultiSelection(true);
        this.bizPromptSaleOrgUnit.setEnabledMultiSelection(true);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
    }

    private void setCustomerFilter(CompanyOrgUnitInfo companyInfo) throws Exception {
        if (companyInfo != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)new Integer(0), CompareType.EQUALS));
            evi.setFilter(filterInfo);
            String queryInfo = "com.kingdee.eas.scm.sd.sale.app.F7ConsignCustomerCompanyQuery";
            this.bizPrmtCustomer.setQueryInfo(queryInfo);
            this.bizPrmtCustomer.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
            this.bizPrmtCustomer.setEntityViewInfo(evi);
            this.bizPrmtCustomer.setCommitFormat("$number$");
            this.bizPrmtCustomer.setDisplayFormat("$name$");
            this.bizPrmtCustomer.setEditFormat("$number$");
            this.bizPrmtCustomer.setCommitParser((IParser)new MainDataParser(this.bizPrmtCustomer));
            GeneralKDPromptSelectorAdaptor selectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.bizPrmtCustomer, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            this.bizPrmtCustomer.setSelector((KDPromptSelector)selectorAdaptor);
            this.bizPrmtCustomer.addSelectorListener((SelectorListener)selectorAdaptor);
            this.bizPrmtBalanceCustomer.setQueryInfo(queryInfo);
            this.bizPrmtBalanceCustomer.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
            this.bizPrmtBalanceCustomer.setEntityViewInfo(evi);
            this.bizPrmtBalanceCustomer.setCommitFormat("$number$");
            this.bizPrmtBalanceCustomer.setDisplayFormat("$name$");
            this.bizPrmtBalanceCustomer.setEditFormat("$number$");
            this.bizPrmtBalanceCustomer.setCommitParser((IParser)new MainDataParser(this.bizPrmtBalanceCustomer));
            GeneralKDPromptSelectorAdaptor balanceSelectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.bizPrmtBalanceCustomer, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), queryInfo, "browseGroup.id", "companyOrgUnit.id");
            this.bizPrmtBalanceCustomer.setSelector((KDPromptSelector)balanceSelectorAdaptor);
            this.bizPrmtBalanceCustomer.addSelectorListener((SelectorListener)balanceSelectorAdaptor);
        } else {
            this.setBizCustomerF7(this.bizPrmtCustomer, null);
            this.setBizCustomerF7(this.bizPrmtBalanceCustomer, null);
            this.setBizMaterialF7(this.bizPrmtMaterialFrom, false, null);
            this.setBizMaterialF7(this.bizPrmtMaterialTo, false, null);
        }
    }

    private void setMaterialFilter(KDBizPromptBox bizPrmtMaterial, Set storageIDs) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageIDs, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        bizPrmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery");
        bizPrmtMaterial.setEntityViewInfo(view);
        bizPrmtMaterial.setCommitFormat("$number$");
        bizPrmtMaterial.setDisplayFormat("$name$");
        bizPrmtMaterial.setEditFormat("$number$");
        F7MaterialMultiUISelectorAdaptor selectorAdaptor = SCMGroupClientUtils.setBizMaterialF7((KDBizPromptBox)bizPrmtMaterial, (Component)((Object)this), (OrgType)this.getMainBizOrgType(), (boolean)false, (String)"com.kingdee.eas.basedata.master.material.app.F7MaterialInventoryQuery");
        bizPrmtMaterial.setSelector((KDPromptSelector)selectorAdaptor);
        bizPrmtMaterial.addSelectorListener((SelectorListener)selectorAdaptor);
        bizPrmtMaterial.setCommitParser((IParser)new MainDataParser(bizPrmtMaterial));
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.bizPromptStorageOrgUnit;
    }

    protected String getViewPermission() {
        return permItem_view;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("storageOrgUnit", this.bizPromptStorageOrgUnit.getValue());
        para.setObject("saleOrgUnit", this.bizPromptSaleOrgUnit.getValue());
        para.setObject("customer", this.bizPrmtCustomer.getValue());
        para.setObject("balanceCustomer", this.bizPrmtBalanceCustomer.getValue());
        para.setObject("materialFrom", this.bizPrmtMaterialFrom.getValue());
        para.setObject("materialTo", this.bizPrmtMaterialTo.getValue());
        para.setObject("verifyDate", this.kdtVerifyDate.getValue());
        return para;
    }

    private Object getCustomerByText(String number) {
        CustomerInfo customer = null;
        try {
            ICustomer iCustomer = CustomerFactory.getRemoteInstance();
            CustomerCollection customerCollection = iCustomer.getCustomerCollection("select id where number='" + number + "'");
            if (customerCollection == null || customerCollection.size() <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"customerNumerNotExist"));
                return null;
            }
            customer = customerCollection.get(0);
        }
        catch (BOSException e) {
            logger.info((Object)e);
        }
        return customer;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void setCustomCondition(RptParams params) {
        this.bizPromptStorageOrgUnit.setValue(params.getObject("storageOrgUnit"));
        this.bizPromptSaleOrgUnit.setValue(params.getObject("saleOrgUnit"));
        this.bizPrmtCustomer.setValue(params.getObject("customer"));
        this.bizPrmtMaterialFrom.setValue(params.getObject("materialFrom"));
        this.bizPrmtMaterialTo.setValue(params.getObject("materialTo"));
        this.kdtVerifyDate.setValue(params.getObject("verifyDate"));
    }

    @Override
    protected void bizPromptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object storageObj = this.bizPromptStorageOrgUnit.getValue();
        if (storageObj == null) {
            this.bizPromptStorageOrgUnit.setData(e.getOldValue());
        }
        this.bizPromptSaleOrgUnit.setValue(null);
        this.bizPrmtCustomer.setValue(null);
        this.bizPrmtMaterialFrom.setValue(null);
        this.bizPrmtMaterialTo.setValue(null);
        if (storageObj != null && storageObj instanceof Object[]) {
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
            HashSet storageIDs = new HashSet();
            HashSet saleIDs = new HashSet();
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            StorageOrgUnitInfo[] storageOrgUnitInfos = null;
            Object[] obj = (Object[])storageObj;
            int len = obj.length;
            for (int i = 0; i < len; ++i) {
                if (obj[i] instanceof Object[]) {
                    Object[] childObj = (Object[])obj[i];
                    int len2 = childObj.length;
                    for (int j = 0; j < len2; ++j) {
                        if (!(childObj[j] instanceof StorageOrgUnitInfo)) continue;
                        storageOrgUnitInfo = (StorageOrgUnitInfo)childObj[j];
                        this.setStorageIDs(storageIDs, saleIDs, storageOrgUnitInfo);
                    }
                    continue;
                }
                if (!(obj[i] instanceof StorageOrgUnitInfo)) continue;
                storageOrgUnitInfo = (StorageOrgUnitInfo)obj[i];
                this.setStorageIDs(storageIDs, saleIDs, storageOrgUnitInfo);
            }
            if (storageIDs.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", storageIDs, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                StorageOrgUnitCollection storageOrgUnitCollection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
                int size = storageOrgUnitCollection.size();
                if (storageOrgUnitCollection != null && size > 0) {
                    storageOrgUnitInfos = new StorageOrgUnitInfo[size];
                    for (int i = 0; i < size; ++i) {
                        storageOrgUnitInfos[i] = storageOrgUnitCollection.get(i);
                    }
                }
            }
            CompanyOrgUnitInfo[] companyOrgUnitInfos = null;
            if (storageOrgUnitInfos != null && storageOrgUnitInfos.length > 0) {
                companyOrgUnitInfos = InvClientUtils.getCompanyInfos2(storageOrgUnitInfos);
            }
            if (null == companyOrgUnitInfos || companyOrgUnitInfos.length == 0) {
                this.setCustomerFilter(null);
                return;
            }
            HashSet<CompanyOrgUnitInfo> companySet = new HashSet<CompanyOrgUnitInfo>();
            int length = companyOrgUnitInfos.length;
            for (int i = 0; i < length; ++i) {
                if (companyOrgUnitInfos[i] == null) continue;
                companySet.add(companyOrgUnitInfos[i]);
            }
            if (companySet.size() > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyMustSame"));
                this.bizPromptStorageOrgUnit.setData(e.getOldValue());
            }
            if (companySet.size() == 1) {
                if (saleIDs.size() > 0) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", saleIDs, CompareType.INCLUDE));
                    viewInfo.setFilter(filter);
                    this.bizPromptSaleOrgUnit.setEntityViewInfo(viewInfo);
                    this.bizPromptSaleOrgUnit.setCommitFormat("$number$");
                    this.bizPromptSaleOrgUnit.setDisplayFormat("$name$");
                    this.bizPromptSaleOrgUnit.setEditFormat("$number$");
                }
                this.setMaterialFilter(this.bizPrmtMaterialFrom, storageIDs);
                this.setMaterialFilter(this.bizPrmtMaterialTo, storageIDs);
                CompanyOrgUnitInfo companyInfo = companyOrgUnitInfos[0];
                this.setCustomerFilter(companyInfo);
                String companyID = companyInfo == null ? null : companyInfo.getId().toString();
                this.setVerifyDate(companyID);
            }
        }
    }

    private void setStorageIDs(Set storageIDs, Set saleIDs, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        if (storageOrgUnitInfo != null) {
            storageIDs.add(storageOrgUnitInfo.getId().toString());
            OrgUnitCollection orgUnitCollection = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (BOSUuid)storageOrgUnitInfo.getId());
            int size = orgUnitCollection.size();
            for (int j = 0; j < size; ++j) {
                saleIDs.add(orgUnitCollection.get(j).getId().toString());
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (Boolean.valueOf(String.valueOf(this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
                return;
            }
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setCustomCondition((RptParams)RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setCustomCondition((RptParams)RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)customerParams, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getCustomCondition()));
        return customerParams;
    }

    public boolean verify() {
        Object obj;
        if (this.bizPromptStorageOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (this.bizPromptStorageOrgUnit.getData() instanceof Object[] && ((Object[])(obj = (Object[])this.bizPromptStorageOrgUnit.getData())).length > 0 && obj[0] == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (this.bizPrmtCustomer.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"customerNotNull"));
            return false;
        }
        obj = this.bizPrmtCustomer.getValue();
        Object customer = null;
        if (obj instanceof CustomerInfo) {
            customer = obj;
        } else if (obj != null) {
            customer = this.getCustomerByText(obj.toString());
        }
        if (customer == null) {
            return false;
        }
        this.bizPrmtCustomer.setValue(customer);
        if (this.kdtVerifyDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"verifyDateNotNull"));
            return false;
        }
        Object storageObj = this.bizPromptStorageOrgUnit.getValue();
        if (storageObj != null && storageObj instanceof Object[]) {
            Object[] obj2 = (Object[])storageObj;
            ArrayList<OrgUnitInfo> companyOrgUnitCollection = new ArrayList<OrgUnitInfo>();
            try {
                CompanyOrgUnitInfo companyOrgUnitInfo;
                int len = obj2.length;
                for (int i = 0; i < len; ++i) {
                    StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)obj2[i];
                    if (storageOrgUnitInfo == null) continue;
                    OrgUnitCollection companyOrgUnit = null;
                    companyOrgUnit = SCMGroupClientUtils.getOrgsByRelation((OrgType)OrgType.Storage, (OrgType)OrgType.Company, (BOSUuid)storageOrgUnitInfo.getId());
                    int size = companyOrgUnit.size();
                    for (int j = 0; j < size; ++j) {
                        if (companyOrgUnitCollection.contains(companyOrgUnit.get(j))) continue;
                        companyOrgUnitCollection.add(companyOrgUnit.get(j));
                    }
                }
                if (companyOrgUnitCollection.size() > 1) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyMustSame"));
                    return false;
                }
                if (companyOrgUnitCollection.size() == 1 && (companyOrgUnitInfo = (CompanyOrgUnitInfo)companyOrgUnitCollection.get(0)) != null) {
                    boolean consignParams;
                    String consignSaleParams = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()), "CONSIGNSALES");
                    if (consignSaleParams != null && (consignParams = Boolean.valueOf(consignSaleParams).booleanValue())) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"canNotVerifyConsign"));
                        return false;
                    }
                    if (this.kdtVerifyDate.getValue() != null) {
                        SystemStatusCtrolInfo systemStatusCtrolInfo = (SystemStatusCtrolInfo)this.curPeriodMap.get(companyOrgUnitInfo.getId().toString());
                        if (systemStatusCtrolInfo != null) {
                            PeriodInfo periodInfo = systemStatusCtrolInfo.getCurrentPeriod();
                            if (periodInfo.getBeginDate().after((Date)this.kdtVerifyDate.getValue())) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"verifyDateAfterBeginDate"));
                                return false;
                            }
                        } else {
                            String companyID = companyOrgUnitInfo.getId().toString();
                            SystemStatusCtrolCollection systemStatusColl = this.getSystemStatusColl(companyID);
                            if (systemStatusColl != null && systemStatusColl.size() > 0 && (systemStatusCtrolInfo = systemStatusColl.get(0)) != null) {
                                this.curPeriodMap.put(companyID, systemStatusCtrolInfo);
                                PeriodInfo periodInfo = systemStatusCtrolInfo.getCurrentPeriod();
                                if (periodInfo.getBeginDate().after((Date)this.kdtVerifyDate.getValue())) {
                                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"verifyDateAfterBeginDate"));
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
            catch (EASBizException e) {
                logger.debug((Object)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.debug((Object)e);
                this.handUIException(e);
            }
        }
        return true;
    }

    public void clear() {
        this.bizPrmtCustomer.setData(null);
        this.bizPrmtMaterialFrom.setData(null);
        this.bizPrmtMaterialTo.setData(null);
        this.bizPromptSaleOrgUnit.setData(null);
        this.bizPromptStorageOrgUnit.setData((Object)new Object[]{this.getDefaultMainBizOrg()});
        this.setVerifyDate(null);
    }
}

