/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.RptFilterCollection;
import com.kingdee.eas.framework.report.RptFilterInfo;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractConsignVeriConditionUI;
import com.kingdee.eas.scm.sd.sale.util.DateUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ConsignVeriConditionUI
extends AbstractConsignVeriConditionUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.client.ConsignVeriConditionUI");
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private DataChangeListener companyDataChangeListener = null;
    private DataChangeListener matAndCusDataChangeListener = null;

    public ConsignVeriConditionUI() throws Exception {
        this.isReport = true;
        this.setSize(450, 300);
        this.setOrgUnitF7();
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        this.addListener();
        this.setFilterManager();
    }

    protected void setMainBizF72(KDBizPromptBox bizOrgUnitBox) {
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        NewSaleF7 model = null;
        String permissionItem = this.getViewPermission();
        NewOrgUnitFilterInfoProducer iProducer = null;
        if (this.getMainBizOrgType().equals((Object)OrgType.Sale)) {
            model = new NewSaleF7();
        }
        if ((iProducer = !this.isSupportVirturalOrgs() ? new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType(), permissionItem) : (model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model, permissionItem) : new NewOrgUnitFilterInfoProducer(this.getMainBizOrgType(), permissionItem))) != null && iProducer.getModel() != null) {
            iProducer.getModel().setNeedAddSealUp(true);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    private void setOrgUnitF7() {
        this.prmtCompanyOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.CompanyOrgUnitQuery");
        this.setMainBizF72(this.prmtCompanyOrgUnit);
        this.prmtSaleOrgUnit.setQueryInfo("com.kingdee.eas.scm.common.app.SaleOrgUnitQuery");
        this.prmtSaleOrgUnit.setCommitFormat("$number$;$code$");
        this.setBizOrgF7ByType(this.prmtStorageOrgUnit, OrgType.Storage, this.getMainBizOrgType(), false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSaleOrgUnit, this.prmtStorageOrgUnit, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtMaterialFrom, this.prmtMaterialTo});
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(false);
        this.prmtCompanyOrgUnit.setDisplayFormat("$name$");
        this.prmtCompanyOrgUnit.setCommitFormat("$number$");
        this.prmtCompanyOrgUnit.setEditFormat("$number$");
        this.prmtSaleOrgUnit.setDisplayFormat("$name$");
        this.prmtSaleOrgUnit.setCommitFormat("$number$");
        this.prmtSaleOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
    }

    private void addListener() {
        this.removeListener();
        this.companyDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newObject = e.getNewValue();
                Object oldObject = e.getOldValue();
                if (newObject != null && !newObject.equals(oldObject)) {
                    ConsignVeriConditionUI.this.prmtStorageOrgUnit.setValue(null);
                    ConsignVeriConditionUI.this.prmtSaleOrgUnit.setValue(null);
                    ConsignVeriConditionUI.this.prmtCustomerFrom.setValue(null);
                    ConsignVeriConditionUI.this.prmtCustomerTo.setValue(null);
                    ConsignVeriConditionUI.this.prmtMaterialFrom.setValue(null);
                    ConsignVeriConditionUI.this.prmtMaterialTo.setValue(null);
                }
                ConsignVeriConditionUI.this.setSaleAndStorageOrgFilter();
                ConsignVeriConditionUI.this.prmtCompanyOrgUnit.setEnabledMultiSelection(false);
            }
        };
        this.prmtCompanyOrgUnit.addDataChangeListener(this.companyDataChangeListener);
        this.matAndCusDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object value = e.getNewValue();
                if (value != null && ConsignVeriConditionUI.this.prmtCompanyOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)ConsignVeriConditionUI.resClassName, (String)"companyOrgUnitNotNull"));
                    KDBizPromptBox prmtBox = (KDBizPromptBox)e.getSource();
                    prmtBox.setValue(null);
                }
            }
        };
        this.prmtMaterialFrom.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtMaterialTo.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtCustomerFrom.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtCustomerTo.addDataChangeListener(this.matAndCusDataChangeListener);
    }

    private void removeListener() {
        if (this.companyDataChangeListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.companyDataChangeListener);
        }
        if (this.matAndCusDataChangeListener != null) {
            this.prmtMaterialFrom.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtMaterialTo.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtCustomerFrom.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtCustomerTo.removeDataChangeListener(this.matAndCusDataChangeListener);
        }
    }

    private void setSaleAndStorageOrgFilter() {
        Object tempObject = this.prmtCompanyOrgUnit.getValue();
        OrgUnitInfo companyInfo = null;
        if (tempObject instanceof OrgUnitInfo[]) {
            companyInfo = tempObject != null ? ((OrgUnitInfo[])tempObject)[0] : null;
        } else if (tempObject instanceof OrgUnitInfo) {
            companyInfo = (OrgUnitInfo)tempObject;
        } else if (tempObject instanceof CompanyOrgUnitInfo) {
            companyInfo = (CompanyOrgUnitInfo)tempObject;
        } else if (tempObject instanceof Object[] && tempObject != null && ((Object[])tempObject).length > 0 && ((Object[])tempObject)[0] != null && ((Object[])tempObject)[0] instanceof OrgUnitInfo) {
            companyInfo = (OrgUnitInfo)((Object[])tempObject)[0];
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"-1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtSaleOrgUnit.setEntityViewInfo(view);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        this.prmtSaleOrgUnit.setEnabledMultiSelection(false);
        this.prmtStorageOrgUnit.setEnableToMaintainBizdata(false);
        if (companyInfo != null) {
            OrgUnitCollection collection = this.getSalesInfo(companyInfo);
            if (collection != null) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collection.get(i).getId().toString());
                }
                EntityViewInfo viewForSale = new EntityViewInfo();
                FilterInfo filterForSale = new FilterInfo();
                filterForSale.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewForSale.setFilter(filterForSale);
                this.prmtSaleOrgUnit.setEntityViewInfo(viewForSale);
            }
            if ((collection = this.getStorageUnitInfo(companyInfo)) != null) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collection.get(i).getId().toString());
                }
                EntityViewInfo viewForSale = new EntityViewInfo();
                FilterInfo filterForSale = new FilterInfo();
                filterForSale.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewForSale.setFilter(filterForSale);
                this.prmtStorageOrgUnit.setEntityViewInfo(viewForSale);
            }
            this.prmtSaleOrgUnit.setEnabledMultiSelection(true);
            this.prmtStorageOrgUnit.setEnableToMaintainBizdata(true);
        }
    }

    private void setFilterManager() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateFrom", (Component)this.dateFrom);
        element.setDefaultValue((Object)DateUtils.getFirstDateCurMonth(new Date()));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateTo", (Component)this.dateTo);
        element.setDefaultValue((Object)DateUtils.getEndDateOfMonth(new Date()));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("companyOrg", (Component)this.prmtCompanyOrgUnit);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("storageOrg", (Component)this.prmtStorageOrgUnit);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("saleOrg", (Component)this.prmtSaleOrgUnit);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        MultiF7FilterElement multiElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        multiElement = new MultiF7FilterElement("customerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("customerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement chkRadioElemnet = new CheckRadioFilterElement("onlyDisplaySumLine", (Component)this.onlyDisplaySumLine);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        chkRadioElemnet = new CheckRadioFilterElement("noDisplaySendZero", (Component)this.noDisplaySendZero);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        chkRadioElemnet = new CheckRadioFilterElement("noDisplayStockZero", (Component)this.noDisplayStockZero);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected String getViewPermission() {
        return "ConsignVerificationOfAccount_view";
    }

    public void onLoad() throws Exception {
        this.setReport(false);
        super.onLoad();
        this.setSaleAndStorageOrgFilter();
    }

    @Override
    public void loadFields() {
    }

    public void loadData(EntityViewInfo entityViewInfo) {
    }

    public void clear() {
        this.prmtCompanyOrgUnit.removeDataChangeListener(this.companyDataChangeListener);
        super.clear();
        this.prmtCompanyOrgUnit.addDataChangeListener(this.companyDataChangeListener);
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        if (this.dateFrom.getTimestamp() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            return false;
        }
        if (this.dateTo.getTimestamp() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            return false;
        }
        if (this.dateTo.getTimestamp().before(this.dateFrom.getTimestamp())) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"CompareDate"));
            return false;
        }
        return flag;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public RptParams getCustomCondition() {
        RptParams pp = super.getCustomCondition();
        pp.setObject("companyOrg", this.prmtCompanyOrgUnit.getValue());
        pp.setObject("saleOrg", this.prmtSaleOrgUnit.getValue());
        pp.setObject("storageOrg", this.prmtStorageOrgUnit.getValue());
        pp.setObject("dateFrom", this.dateFrom.getValue());
        pp.setObject("dateTo", this.dateTo.getValue());
        pp.setObject("materialFrom", this.prmtMaterialFrom.getValue());
        pp.setObject("materialTo", this.prmtMaterialTo.getValue());
        pp.setObject("customerTo", this.prmtCustomerTo.getValue());
        pp.setObject("customerFrom", this.prmtCustomerFrom.getValue());
        pp.setObject("noDisplaySendZero", (Object)this.noDisplaySendZero.isSelected());
        pp.setObject("noDisplayStockZero", (Object)this.noDisplayStockZero.isSelected());
        pp.setObject("onlyDisplaySumLine", (Object)this.onlyDisplaySumLine.isSelected());
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        this.prmtCompanyOrgUnit.setValue(params.getObject("companyOrg"));
        this.prmtStorageOrgUnit.setValue(params.getObject("storageOrg"));
        this.prmtSaleOrgUnit.setValue(params.getObject("saleOrg"));
        this.prmtCustomerFrom.setValue(params.getObject("customerFrom"));
        this.prmtCustomerTo.setValue(params.getObject("customerTo"));
        this.prmtMaterialFrom.setValue(params.getObject("materialFrom"));
        this.prmtMaterialTo.setValue(params.getObject("materialTo"));
        this.dateFrom.setValue(params.getObject("dateFrom"));
        this.dateTo.setValue(params.getObject("dateTo"));
        this.onlyDisplaySumLine.setSelected(params.getBoolean("onlyDisplaySumLine"));
        this.noDisplaySendZero.setSelected(params.getBoolean("noDisplaySendZero"));
        this.noDisplayStockZero.setSelected(params.getBoolean("noDisplayStockZero"));
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            if (Boolean.valueOf(String.valueOf(this.getUIContext().get("com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_BE_JOINQUERY"))).booleanValue()) {
                return;
            }
            Object param = RptParamsUtil.getFromCustomerParams((CustomerParams)cp);
            if (param instanceof RptFilterInfo || param instanceof RptFilterCollection || param instanceof RptFilterInfo[] || param instanceof RptFilterCollection[]) {
                this.setCustomCondition((RptParams)RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
            } else {
                this.setCustomCondition((RptParams)RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams customerParams = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)customerParams, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getCustomCondition()));
        return customerParams;
    }

    private OrgUnitCollection getSalesInfo(OrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUtilRel.getFromUnit(cou.getId().toString(), 1, 2);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private OrgUnitCollection getStorageUnitInfo(OrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }
}

