/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractConsignVerificationOfAccountConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ConsignVerificationOfAccountConditionUI
extends AbstractConsignVerificationOfAccountConditionUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.client.ConsignVerificationOfAccountConditionUI");
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private DataChangeListener companyDataChangeListener = null;
    private DataChangeListener matAndCusDataChangeListener = null;

    public ConsignVerificationOfAccountConditionUI() throws Exception {
        this.setSize(450, 450);
        this.isReport = true;
        this.setOrgUnitF7();
        this.setBizMaterialF7(this.prmtMaterialFrom, false, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        this.setBizCustomerF7(this.prmtCustomerFrom, null);
        this.setBizCustomerF7(this.prmtCustomerTo, null);
        this.setFilterManager();
    }

    private void setOrgUnitF7() {
        this.prmtCompanyOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.setMainBizF7(this.prmtCompanyOrgUnit);
        this.setBizOrgF7ByType(this.prmtSaleOrgUnit, OrgType.Sale, this.getMainBizOrgType(), false);
        this.setBizOrgF7ByType(this.prmtStorageOrgUnit, OrgType.Storage, this.getMainBizOrgType(), false);
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(false);
        this.prmtCompanyOrgUnit.setDisplayFormat("$name$");
        this.prmtCompanyOrgUnit.setCommitFormat("$number$");
        this.prmtCompanyOrgUnit.setEditFormat("$number$");
        this.prmtSaleOrgUnit.setDisplayFormat("$name$");
        this.prmtSaleOrgUnit.setCommitFormat("$number$");
        this.prmtSaleOrgUnit.setEditFormat("$number$");
        this.prmtStorageOrgUnit.setDisplayFormat("$name$");
        this.prmtStorageOrgUnit.setCommitFormat("$number$");
        this.prmtStorageOrgUnit.setEditFormat("$number$");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSaleOrgUnit, this.prmtStorageOrgUnit, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtMaterialFrom, this.prmtMaterialTo});
        this.addListener();
        this.setSaleAndStorageOrgFilter();
    }

    private void addListener() {
        this.removeListener();
        this.companyDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object newObject = e.getNewValue();
                Object oldObject = e.getOldValue();
                if (newObject != null && !newObject.equals(oldObject)) {
                    ConsignVerificationOfAccountConditionUI.this.prmtCustomerFrom.setValue(null);
                    ConsignVerificationOfAccountConditionUI.this.prmtCustomerTo.setValue(null);
                    ConsignVerificationOfAccountConditionUI.this.prmtMaterialFrom.setValue(null);
                    ConsignVerificationOfAccountConditionUI.this.prmtMaterialTo.setValue(null);
                }
                ConsignVerificationOfAccountConditionUI.this.setSaleAndStorageOrgFilter();
            }
        };
        this.prmtCompanyOrgUnit.addDataChangeListener(this.companyDataChangeListener);
        this.matAndCusDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object value = e.getNewValue();
                if (value != null && ConsignVerificationOfAccountConditionUI.this.prmtCompanyOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)ConsignVerificationOfAccountConditionUI.resClassName, (String)"companyOrgUnitNotNull"));
                    KDBizPromptBox prmtBox = (KDBizPromptBox)e.getSource();
                    prmtBox.setValue(null);
                }
            }
        };
        this.prmtMaterialFrom.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtMaterialTo.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtCustomerFrom.addDataChangeListener(this.matAndCusDataChangeListener);
        this.prmtCustomerTo.addDataChangeListener(this.matAndCusDataChangeListener);
    }

    private void removeListener() {
        if (this.companyDataChangeListener != null) {
            this.prmtCompanyOrgUnit.removeDataChangeListener(this.companyDataChangeListener);
        }
        if (this.matAndCusDataChangeListener != null) {
            this.prmtMaterialFrom.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtMaterialTo.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtCustomerFrom.removeDataChangeListener(this.matAndCusDataChangeListener);
            this.prmtCustomerTo.removeDataChangeListener(this.matAndCusDataChangeListener);
        }
    }

    private void setSaleAndStorageOrgFilter() {
        Object tempObject = this.prmtCompanyOrgUnit.getValue();
        OrgUnitInfo companyInfo = null;
        if (tempObject instanceof OrgUnitInfo[]) {
            companyInfo = tempObject != null ? ((OrgUnitInfo[])tempObject)[0] : null;
        } else if (tempObject instanceof OrgUnitInfo) {
            companyInfo = (OrgUnitInfo)tempObject;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"-1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtSaleOrgUnit.setEntityViewInfo(view);
        this.prmtStorageOrgUnit.setEntityViewInfo(view);
        this.prmtSaleOrgUnit.setEnabledMultiSelection(false);
        this.prmtStorageOrgUnit.setEnableToMaintainBizdata(false);
        if (companyInfo != null) {
            OrgUnitCollection collection = this.getSalesInfo(companyInfo);
            if (collection != null) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collection.get(i).getId().toString());
                }
                EntityViewInfo viewForSale = new EntityViewInfo();
                FilterInfo filterForSale = new FilterInfo();
                filterForSale.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewForSale.setFilter(filterForSale);
                this.prmtSaleOrgUnit.setEntityViewInfo(viewForSale);
            }
            if ((collection = this.getStorageUnitInfo(companyInfo)) != null) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collection.get(i).getId().toString());
                }
                EntityViewInfo viewForSale = new EntityViewInfo();
                FilterInfo filterForSale = new FilterInfo();
                filterForSale.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                viewForSale.setFilter(filterForSale);
                this.prmtStorageOrgUnit.setEntityViewInfo(viewForSale);
            }
            this.prmtSaleOrgUnit.setEnabledMultiSelection(true);
            this.prmtStorageOrgUnit.setEnableToMaintainBizdata(true);
        }
    }

    private void setFilterManager() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        Timestamp[] dates = SCMUtils.getDefaultDateRange((Date)SCMClientUtils.getServerDate2());
        SingleFilterElement element = new SingleFilterElement("dateFrom", (Component)this.dateFrom);
        element.setDefaultValue((Object)dates[0]);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateTo", (Component)this.dateTo);
        element.setDefaultValue((Object)dates[1]);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialFrom", (Component)this.prmtMaterialFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("customerFrom", (Component)this.prmtCustomerFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("customerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement chkRadioElemnet = new CheckRadioFilterElement("onlyDisplaySumLine", (Component)this.onlyDisplaySumLine);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        chkRadioElemnet = new CheckRadioFilterElement("noDisplaySendZero", (Component)this.noDisplaySendZero);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        chkRadioElemnet = new CheckRadioFilterElement("noDisplayStockZero", (Component)this.noDisplayStockZero);
        chkRadioElemnet.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)chkRadioElemnet);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    protected String getViewPermission() {
        return "ConsignVerificationOfAccount_view";
    }

    public void onLoad() throws Exception {
    }

    @Override
    public void loadFields() {
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        if (this.dateFrom.getTimestamp() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            return false;
        }
        if (this.dateTo.getTimestamp() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            return false;
        }
        if (this.dateTo.getTimestamp().before(this.dateFrom.getTimestamp())) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"CompareDate"));
            return false;
        }
        return flag;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public RptParams getCustomCondition() {
        RptParams pp = super.getCustomCondition();
        pp.setObject("companyOrg", this.prmtCompanyOrgUnit.getValue());
        pp.setObject("saleOrg", this.prmtSaleOrgUnit.getValue());
        pp.setObject("storageOrg", this.prmtStorageOrgUnit.getValue());
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        super.setCustomCondition(params);
    }

    private OrgUnitCollection getSalesInfo(OrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUtilRel.getFromUnit(cou.getId().toString(), 1, 2);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    private OrgUnitCollection getStorageUnitInfo(OrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }
}

