/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sd.sale.report.CustomerTradeRptEnum;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractCustomerTradeConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;

public class CustomerTradeConditionUI
extends AbstractCustomerTradeConditionUI {
    private SCMRptMultiOrgsF7 f7;
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";

    public CustomerTradeConditionUI() throws Exception {
        this.isReport = true;
        this.f7 = new SCMRptMultiOrgsF7(this.prmtCompany, OrgType.Company, EASResource.getString((String)resClassName, (String)"companyOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullCompanyOrgUnit", this.f7, this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "fullCompanyOrgUnit");
        elements.add((FilterElement)element);
        element = new SingleFilterElement("CustomerType", (Component)this.comCustomerType);
        element.setDefaultValue((Object)CustomerTradeRptEnum.OrderCustomer);
        elements.add((FilterElement)element);
        MultiF7FilterElement MultiElement = new MultiF7FilterElement("CustomerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)MultiElement);
        element = new SingleFilterElement("CustomerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement e = new CheckRadioFilterElement("IsTotalWithAll", (Component)this.kdcIsTotalAll);
        e.setDefaultValue((Object)false);
        elements.add((FilterElement)e);
        CheckRadioFilterElement eIsIncludeExElement = new CheckRadioFilterElement("IsIncludeExInvoice", (Component)this.kdcIsIncludeExInvoice);
        eIsIncludeExElement.setDefaultValue((Object)false);
        elements.add((FilterElement)eIsIncludeExElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtCustomerFrom, this.prmtCustomerTo});
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        SCMQueryFormat.formatStartTime((KDDatePicker)this.datePickerStart);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.datePickerEnd);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
    }

    public boolean verify() {
        Object[] purchaseOrg;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtCompany.getValue() == null || ((Object[])this.prmtCompany.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtCompany.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtCompany.getValue())[0] == null || purchaseOrg[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        Object[] companyOrgUnit = (Object[])this.f7.getFullData();
        if (!CustomerTradeConditionUI.checkSameCurrency(companyOrgUnit)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"COMORG_CUR_UNIQUE"));
            return false;
        }
        return true;
    }

    protected String getPermissionItem(String status) {
        return "CustomerTrade_print";
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected String getViewPermission() {
        String viewPermission = "CustomerTrade_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public static boolean checkSameCurrency(Object[] infos) {
        CompanyOrgUnitInfo currCom = null;
        String firstCur = null;
        int length = infos.length;
        for (int i = 0; i < length; ++i) {
            if (firstCur == null) {
                currCom = InvClientUtils.getCompanyInfo((String)((FullOrgUnitInfo)infos[i]).getId().toString());
                if (currCom == null) continue;
                firstCur = currCom.getBaseCurrency().getId().toString();
                continue;
            }
            currCom = InvClientUtils.getCompanyInfo((String)((FullOrgUnitInfo)infos[i]).getId().toString());
            if (currCom == null || firstCur.equals(currCom.getBaseCurrency().getId().toString())) continue;
            return false;
        }
        return true;
    }
}

