/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.client.VirtualRptBaseUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.SaleContractTrackRptFacadeFactory;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleContractTrackRptUI;
import com.kingdee.eas.scm.sd.sale.report.client.SaleContractTrackRptConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleContractTrackRptUI
extends AbstractSaleContractTrackRptUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleContractTrackRptUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    RptParams pp = new RptParams();
    private boolean firstLoadData = true;
    private String orgTempTable;
    private CustomerQueryPanel userPanel = null;
    private CommonQueryDialog queryDialog = new CommonQueryDialog();

    public SaleContractTrackRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.setEnabled(false);
        this.prmtDateRange.setEnabled(false);
        this.prmtCustomerRange.setEnabled(false);
        this.prmtSaleOrg.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return SaleContractTrackRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return (CommRptBaseConditionUI)new SaleContractTrackRptConditionUI().getUserObject();
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new SaleContractTrackRptConditionUI();
    }

    protected void query() {
        String customerRange;
        String customerFrom;
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        super.query();
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bd = this.params.getObject("dateStart").toString();
        String ed = this.params.getObject("dateEnd").toString();
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        java.util.Date beginDate = tempBDCalendar.getTime();
        java.util.Date endDate = tempEDCalendar.getTime();
        DateFormat format = BOSLocaleUtil.getDateFormat();
        this.prmtDateRange.setText(format.format(beginDate) + " - " + format.format(endDate));
        StringBuffer saleOrgUnitbf = new StringBuffer();
        Object[] saleOrgUnit = (Object[])this.params.getObject("saleOrgFrom");
        int n = saleOrgUnit.length;
        for (int i = 0; i < n; ++i) {
            saleOrgUnitbf.append((String)((FullOrgUnitInfo)saleOrgUnit[i]).get("name") + ";");
        }
        this.params.setString("OrgUnitFilter", saleOrgUnitbf.toString());
        this.prmtSaleOrg.setText(saleOrgUnitbf.toString());
        if (this.pp.getObject("customerFrom") != null) {
            if (this.pp.getObject("customerFrom") instanceof Object[]) {
                Object[] customers = (Object[])this.pp.getObject("customerFrom");
                StringBuffer nums = new StringBuffer();
                for (int i = 0; i < customers.length; ++i) {
                    nums.append(((CustomerInfo)customers[i]).getNumber()).append(";");
                }
                customerFrom = nums.substring(0, nums.length() - 1);
            } else {
                customerFrom = this.pp.getObject("customerFrom") instanceof CustomerInfo ? ((CustomerInfo)this.pp.getObject("customerFrom")).getNumber() : this.pp.getObject("customerFrom").toString();
            }
        } else {
            customerFrom = "";
        }
        String customerTo = this.pp.getObject("customerTo") != null ? this.pp.getObject("customerTo").toString() : "";
        if (customerFrom.length() > 1 && customerTo.length() > 1) {
            this.prmtCustomerRange.setText(customerFrom + "_" + customerTo);
            customerRange = customerFrom + "_" + customerTo;
        } else {
            this.prmtCustomerRange.setText(customerFrom + customerTo);
            customerRange = customerFrom + customerTo;
        }
        this.pp.setString("CustomerRange", customerRange);
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        RptParams rpt = null;
        try {
            if (from == 0 && this.firstLoadData) {
                try {
                    this.pp.clear();
                    this.pp.putAll(this.params.toMap());
                    rpt = SaleContractTrackRptFacadeFactory.getRemoteInstance().createTempTable(this.pp);
                    this.setTempTable(rpt.getString("tempTable"));
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    this.pp.setString("tempTable", rpt.getString("tempTable"));
                    this.orgTempTable = rpt.getString("OrgTempTable");
                    this.pp.setString("OrgTempTable", this.orgTempTable);
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                    this.tblMain.setRowCount(rpt.getInt("verticalCount"));
                    int freezeCol = this.tblMain.getColumnIndex("ContractEntryTaxAmount");
                    this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
                    rpt = SaleContractTrackRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                    this.setBackGroundColor(this.tblMain, rs.getRowCount());
                    this.setMergeColumn();
                    this.tHelper.restoreDefault(this.tblMain);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    super.handUIException((Throwable)ex);
                }
            } else {
                rpt = SaleContractTrackRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                this.setBackGroundColor(this.tblMain, from + rs.getRowCount());
            }
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            super.handUIException((Throwable)ee);
            this.abort();
        }
        if (from == 0 && this.firstLoadData) {
            this.initUserConfig();
            this.firstLoadData = false;
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected void getAllDataOfId() {
        GetIdThread getAllIdThread = new GetIdThread(this);
        getAllIdThread.setDaemon(true);
        getAllIdThread.start();
        java.util.Date nowEnd = new java.util.Date();
        logger.debug((Object)("getAllDataOfId end at : " + nowEnd));
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return SaleContractTrackRptFacadeFactory.getRemoteInstance();
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        Object[] rowData = null;
        while (rs.next()) {
            Object dateObject;
            IRow row = this.isExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            if (rs.getObject("FBASESTATUS") != null && rs.getInt("FBASESTATUS") != -9) {
                rs.setValue("FBASESTATUS", (Object)BillBaseStatusEnum.getEnum((int)rs.getInt("FBASESTATUS")).getAlias());
            } else {
                rs.setValue("FBASESTATUS", null);
            }
            if (rs.getObject("FOrderStatus") != null && rs.getInt("FOrderStatus") != -9) {
                rs.setValue("FOrderStatus", (Object)BillBaseStatusEnum.getEnum((int)rs.getInt("FOrderStatus")).getAlias());
            } else {
                rs.setValue("FOrderStatus", null);
            }
            if (rs.getObject("FExchangeRate") != null && rs.getInt("FExchangeRate") == -1) {
                rs.setValue("FExchangeRate", null);
            }
            if ((dateObject = rs.getObject("FDeliveryDate")) != null && dateObject instanceof Timestamp) {
                Date d = new Date(((Timestamp)dateObject).getTime());
                rs.setValue("FDeliveryDate", (Object)d);
            }
            rowData = SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"ContractNumber", "Seq", "ContractDeliveryDate", "BillStatus", "CustomerName", "CustomerNumber", "SaleOrg", "SalePerson", "Currency", "ExchangRate", "MaterialNum", "MaterialNam", "MaterialMod", "Unit", "ContractQty", "ContractEntryTaxAmount", "totalOrderEntryQty", "totalOrderEntryTaxAmount", "NoorderQty", "NoorderEntryTaxAmount", "TotalShippingQty", "TotalPostRequisitionQty", "NototalQty", "unVcAmount", "TotalReceiveAmount", "NototalRecieveAmount", "TotalReceiveQty", "TotalARAmount", "NovoiceQty", "NovoiceAmount", "TotalAmout"};
        return strMergeColKeys;
    }

    private void setBackGroundColor(KDTable table, int toRow) {
        if (toRow > 0) {
            IRow row = table.getRow(toRow - 1);
            Color necessaryColor = new Color(252, 251, 223);
            String heji = (String)row.getCell("ContractNumber").getValue();
            Object seq = row.getCell("Seq").getValue();
            if ("".equals(seq) || null == seq || heji != null && Integer.parseInt(seq.toString()) == -1) {
                row.getStyleAttributes().setBackground(necessaryColor);
                row.getCell("Seq").setValue(null);
            }
        }
    }

    public String getTreeCol() {
        return "SaleOrg";
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT7");
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)resClassName, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new MaterialInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)resClassName, (String)"Date"));
        sb.append(" &[Period]");
        sb.append("&|");
        sb.append(EASResource.getString((String)resClassName, (String)"SaleOrg"));
        sb.append(" : &[SaleOrg]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Period", this.prmtDateRange.getText());
        map.put("SaleOrg", this.prmtSaleOrg.getText());
        return map;
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    public void beforePreview() {
        super.beforePreview();
    }

    public void beforePrintOrPreview() {
        super.beforePrintOrPreview();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(540);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sd.sale.report.client.SaleContractTrackRptUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    class GetIdThread
    extends Thread {
        VirtualRptBaseUI baseUi;

        public GetIdThread(VirtualRptBaseUI baseUI) {
            this.baseUi = baseUI;
        }

        @Override
        public void run() {
            try {
                SaleContractTrackRptUI.this.allIdList = new ArrayList();
                if (SaleContractTrackRptUI.this.getTempTable() != null) {
                    IVirtualRptBaseFacade report = SaleContractTrackRptUI.this.getVirtualRemoteInstance();
                    IRowSet result = report.getIdList(SaleContractTrackRptUI.this.pp);
                    while (result.next()) {
                        SaleContractTrackRptUI.this.allIdList.add(result.getString("FId"));
                    }
                }
                SaleContractTrackRptUI.this.getTable().setRowCount(SaleContractTrackRptUI.this.allIdList.size());
                SaleContractTrackRptUI.this.setButtonEnabled(true);
            }
            catch (Exception ex) {
                SaleContractTrackRptUI.this.setButtonEnabled(true);
                this.baseUi.handUIExceptionAndAbort(ex);
            }
        }
    }
}

