/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.WrittenOffFacadeFactory;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgs4SaleFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleCostDetailOrderColEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleIncomDetailOrderColEnum;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleCostDetailConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaleCostDetailConditionUI
extends AbstractSaleCostDetailConditionUI {
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private SCMRptMultiOrgsF7 companyOrgf7;
    private SCMRptMultiOrgsF7 storageOrgf7;
    private SCMRptMultiOrgsF7 saleOrgf7;
    protected transient Object[] selectedCompanyOrgs = null;
    protected transient CompanyOrgUnitCollection selectedCompanyInfos = null;
    protected transient Object[] selectedStorageOrgs = null;
    protected transient Object[] selectedSaleOrgs = null;
    protected transient StorageOrgUnitCollection selectedStorageOrgInfos = null;
    protected transient SaleOrgUnitCollection selectedSaleOrgInfos = null;
    private Map periodMap = new HashMap();

    public SaleCostDetailConditionUI() throws Exception {
        this.isReport = true;
        this.addCkBxSimpleNameListener();
        this.addAuxiliaryPropertiesListener();
        this.prmtDeptFrom.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtDeptTo.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.setDepartF7filter();
        this.companyOrgf7 = new SCMRptMultiOrgsF7(this.prmtCompanyOrgUnit, OrgType.Company, EASResource.getString((String)resClassName, (String)"companyOrgUnitMutilF7"));
        this.companyOrgf7.setPermItemName(this.getViewPermission());
        this.companyOrgf7.setUseCache(false);
        this.companyOrgf7.setNeedWait4UIOpen(false);
        this.prmtSaleOrgUnit.setRequired(true);
        this.storageOrgf7 = new SCMRptMultiOrgsF7(this.prmtStorageOrgUnit, OrgType.Storage, EASResource.getString((String)resClassName, (String)"storageOrgUnitMutilF7"));
        this.storageOrgf7.setUseCache(false);
        this.storageOrgf7.setNeedWait4UIOpen(false);
        this.prmtSaleOrgUnit.setRequired(true);
        this.saleOrgf7 = new SCMRptMultiOrgsF7(this.prmtSaleOrgUnit, OrgType.Sale, EASResource.getString((String)resClassName, (String)"saleOrgUnitMutilF7"));
        this.saleOrgf7.setUseCache(true);
        this.saleOrgf7.setNeedWait4UIOpen(false);
        this.prmtSaleOrgUnit.setRequired(true);
        this.prmtSalePersonFrom.setEnabledMultiSelection(true);
        this.prmtSalePersonFrom.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        this.prmtSalePersonTo.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        SCMClientUtils.setSalePersonDisplayMulti((KDBizPromptBox)this.prmtSalePersonFrom);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)this.prmtSalePersonTo);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtSalePersonFrom, (KDBizPromptBox)this.prmtSalePersonTo);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgs4SaleFilterElement companyOrgElement = new MultiOrgs4SaleFilterElement("fullCompanyOrgUnit", this.companyOrgf7, this.prmtCompanyOrgUnit);
        companyOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull")));
        elements.add((FilterElement)companyOrgElement);
        MultiOrgs4SaleFilterElement storageOrgElement = new MultiOrgs4SaleFilterElement("fullStorageOrgUnit", this.storageOrgf7, this.prmtStorageOrgUnit);
        storageOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull")));
        elements.add((FilterElement)storageOrgElement);
        MultiOrgs4SaleFilterElement mainOrgElement = new MultiOrgs4SaleFilterElement("fullSaleOrgUnit", this.saleOrgf7, this.prmtSaleOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        MultiF7FilterElement multiElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        CheckRadioFilterElement e2 = new CheckRadioFilterElement("AuxiliaryProperties", (Component)this.AuxiliaryProperties);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)e2);
        multiElement = new MultiF7FilterElement("CustomerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("CustomerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupFrom", (Component)this.prmtSaleGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupTo", (Component)this.prmtSaleGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        multiElement = new MultiF7FilterElement("SalePersonFrom", this.prmtSalePersonFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("SalePersonTo", (Component)this.prmtSalePersonTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("DeptFrom", (Component)this.prmtDeptFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("DeptTo", (Component)this.prmtDeptTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("WarehouseFrom", (Component)this.prmtWarehouseFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("WarehouseTo", (Component)this.prmtWarehouseTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("CombOrderCol", (Component)this.combOrderCol);
        element.setDefaultValue((Object)SaleIncomDetailOrderColEnum.Date);
        elements.add((FilterElement)element);
        CheckRadioFilterElement chrElement = new CheckRadioFilterElement("IsSum", (Component)this.chrDispAllSum);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        chrElement = new CheckRadioFilterElement("IsTotal", (Component)this.chrDispSum);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtSaleGroupFrom, this.prmtSaleGroupTo, this.prmtSalePersonFrom, this.prmtSalePersonFrom, this.prmtDeptFrom, this.prmtDeptTo});
        element = new SingleFilterElement("billStatus", (Component)this.combBillStatus);
        element.setDefaultValue((Object)SaleReportBillStatusEnum.all);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodYear", (Component)this.spinPeriodYear);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodYearTo", (Component)this.spinPeriodYearTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodMonth", (Component)this.spinPeriodMonth);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodMonthTo", (Component)this.spinPeriodMonthTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
    }

    public void onLoad() throws Exception {
        this.addListener();
        super.onLoad();
        this.combBillStatus.removeAllItems();
        this.combBillStatus.addItem((Object)SaleReportBillStatusEnum.all);
        this.combBillStatus.addItem((Object)SaleReportBillStatusEnum.cal);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        if (null != company && !this.periodMap.containsKey(company.getId().toString())) {
            Map map = WrittenOffFacadeFactory.getRemoteInstance().loadFinanceData(company.getId().toString());
            WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(company.getId().toString());
            this.periodMap.put(company.getId().toString(), info);
        }
    }

    protected void combBillStatus_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.combBillStatus.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (selectedItem.equals((Object)SaleReportBillStatusEnum.all)) {
            this.spinPeriodYear.setEnabled(false);
            this.spinPeriodYearTo.setEnabled(false);
            this.spinPeriodMonth.setEnabled(false);
            this.spinPeriodMonthTo.setEnabled(false);
            this.datePickerStart.setEnabled(true);
            this.datePickerEnd.setEnabled(true);
        } else {
            this.spinPeriodYear.setEnabled(true);
            this.spinPeriodYearTo.setEnabled(true);
            this.spinPeriodMonth.setEnabled(true);
            this.spinPeriodMonthTo.setEnabled(true);
            this.datePickerStart.setEnabled(false);
            this.datePickerEnd.setEnabled(false);
        }
    }

    private void addListener() {
        this.prmtCompanyOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleCostDetailConditionUI.this.prmtCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleCostDetailConditionUI.this.prmtStorageOrg_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
        this.prmtSaleOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SaleCostDetailConditionUI.this.prmtSaleOrg_dataChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
        this.spinPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
                if (((KDSpinner)arg0.getSource()).equals(SaleCostDetailConditionUI.this.spinPeriodYear)) {
                    SaleCostDetailConditionUI.this.setPeriod(SaleCostDetailConditionUI.this.spinPeriodYear, company);
                }
            }
        });
        this.spinPeriodYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
                if (((KDSpinner)arg0.getSource()).equals(SaleCostDetailConditionUI.this.spinPeriodYearTo)) {
                    SaleCostDetailConditionUI.this.setPeriod(SaleCostDetailConditionUI.this.spinPeriodYearTo, company);
                }
            }
        });
        this.combBillStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleCostDetailConditionUI.this.combBillStatus_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitCollection comps;
        if (this.companyOrgf7 == null || this.companyOrgf7.getFullData() == null) {
            return;
        }
        Object[] oldComps = this.selectedCompanyOrgs;
        this.selectedCompanyOrgs = (Object[])this.companyOrgf7.getFullData();
        this.orgsChanged(this.companyOrgf7, this.f7Manager);
        if (oldComps != null && Arrays.equals(oldComps, this.selectedCompanyOrgs)) {
            return;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        this.selectedCompanyInfos = comps = SaleCostDetailConditionUI.getFullPermCompany((IObjectPK)userPK, this.selectedCompanyOrgs, this.getViewPermission());
    }

    protected void prmtStorageOrg_dataChanged(DataChangeEvent e) throws Exception {
        StorageOrgUnitCollection comps;
        if (this.storageOrgf7 == null || this.storageOrgf7.getFullData() == null) {
            return;
        }
        Object[] oldComps = this.selectedStorageOrgs;
        this.selectedStorageOrgs = (Object[])this.storageOrgf7.getFullData();
        if (oldComps != null && Arrays.equals(oldComps, this.selectedStorageOrgs)) {
            return;
        }
        Object[] obj = (Object[])this.prmtStorageOrgUnit.getValue();
        this.selectedStorageOrgInfos = comps = this.getStorageUnitColl(obj, this.selectedStorageOrgs);
        EntityViewInfo view = new EntityViewInfo();
        if (comps == null) {
            this.prmtStorageOrgUnit.setValue(null);
        } else {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < comps.size(); ++i) {
                idSet.add(comps.get(i).getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
        }
        this.prmtWarehouseFrom.setEntityViewInfo(view);
        this.prmtWarehouseTo.setEntityViewInfo(view);
        this.prmtWarehouseFrom.setValue(null);
        this.prmtWarehouseTo.setValue(null);
    }

    private StorageOrgUnitCollection getStorageUnitColl(Object[] storageOrg, Object[] selectedStorageOrgs) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        int length = selectedStorageOrgs.length;
        for (int i = 0; i < length; ++i) {
            if (!(selectedStorageOrgs[i] instanceof FullOrgUnitInfo)) continue;
            idSet.add(((FullOrgUnitInfo)selectedStorageOrgs[i]).getId().toString());
        }
        StorageOrgUnitCollection storageColl = null;
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("name");
            view.getSelector().add("number");
            view.getSelector().add("isBizUnit");
            view.getSelector().add("isOnlyUnion");
            view.getSelector().add("cu.id");
            storageColl = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
            StorageOrgUnitCollection storageOrgColl = new StorageOrgUnitCollection();
            int size = storageColl.size();
            block1: for (int i = 0; i < size; ++i) {
                int length2 = storageOrg.length;
                for (int j = 0; j < length2; ++j) {
                    if (!(storageOrg[j] instanceof FullOrgUnitInfo) || !storageColl.get(i).isIsBizUnit() || !storageColl.get(i).getId().toString().equals(((FullOrgUnitInfo)storageOrg[j]).getId().toString())) continue;
                    storageOrgColl.add(storageColl.get(i));
                    continue block1;
                }
            }
            if (storageOrgColl.size() > 0) {
                return storageOrgColl;
            }
            return storageColl;
        }
        return storageColl;
    }

    protected void prmtSaleOrg_dataChanged(DataChangeEvent e) throws Exception {
        SaleOrgUnitCollection comps;
        if (this.saleOrgf7 == null || this.saleOrgf7.getFullData() == null) {
            return;
        }
        Object[] oldComps = this.selectedSaleOrgs;
        this.selectedSaleOrgs = (Object[])this.saleOrgf7.getFullData();
        if (oldComps != null && Arrays.equals(oldComps, this.selectedSaleOrgs)) {
            return;
        }
        Object[] obj = (Object[])this.prmtSaleOrgUnit.getValue();
        this.selectedSaleOrgInfos = comps = this.getSaleUnitColl(obj, this.selectedSaleOrgs);
        if (comps == null) {
            this.prmtSaleOrgUnit.setValue(null);
            return;
        }
    }

    private SaleOrgUnitCollection getSaleUnitColl(Object[] saleOrg, Object[] selectedSaleOrgs) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        int length = selectedSaleOrgs.length;
        for (int i = 0; i < length; ++i) {
            if (!(selectedSaleOrgs[i] instanceof FullOrgUnitInfo)) continue;
            idSet.add(((FullOrgUnitInfo)selectedSaleOrgs[i]).getId().toString());
        }
        SaleOrgUnitCollection saleColl = null;
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("name");
            view.getSelector().add("number");
            view.getSelector().add("isBizUnit");
            view.getSelector().add("isOnlyUnion");
            view.getSelector().add("cu.id");
            saleColl = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitCollection(view);
            SaleOrgUnitCollection saleOrgColl = new SaleOrgUnitCollection();
            int size = saleColl.size();
            block1: for (int i = 0; i < size; ++i) {
                int length2 = saleOrg.length;
                for (int j = 0; j < length2; ++j) {
                    if (!(saleOrg[j] instanceof FullOrgUnitInfo) || !saleColl.get(i).isIsBizUnit() || !saleColl.get(i).getId().toString().equals(((FullOrgUnitInfo)saleOrg[j]).getId().toString())) continue;
                    saleOrgColl.add(saleColl.get(i));
                    continue block1;
                }
            }
            if (saleOrgColl.size() > 0) {
                return saleOrgColl;
            }
            return saleColl;
        }
        return saleColl;
    }

    public static CompanyOrgUnitCollection getFullPermCompany(IObjectPK userPK, Object[] selectedComps, String permissionItem) throws Exception {
        if (selectedComps == null || selectedComps.length == 0) {
            return null;
        }
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        for (int i = 0; i < selectedComps.length; ++i) {
            CoreBaseInfo orgInfo = (CoreBaseInfo)selectedComps[i];
            ids.add(orgInfo.getId());
        }
        ObjectUuidPK ORG_FIVIEW_ID = new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD");
        IPermission iPerm = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection orgs = iPerm.getAuthorizedOrg(userPK, OrgType.Company, (IObjectPK)ORG_FIVIEW_ID, permissionItem);
        HashSet<BOSUuid> withPermIds = new HashSet<BOSUuid>();
        int n = orgs.size();
        for (int i = 0; i < n; ++i) {
            withPermIds.add(orgs.get(i).getId());
        }
        ids.retainAll(withPermIds);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        view.setFilter(filter);
        items.add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("isBizUnit");
        view.getSelector().add("isOnlyUnion");
        view.getSelector().add("cu.id");
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
        return iComp.getCompanyOrgUnitCollection(view);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    public RptParams getCustomCondition() {
        FilterItemCollection items;
        int i;
        RptParams params = super.getCustomCondition();
        Object[] companyOrgUnit = (Object[])params.getObject("fullCompanyOrgUnit");
        Object[] storageOrgUnit = (Object[])params.getObject("fullStorageOrgUnit");
        Object[] SaleOrgUnit = (Object[])params.getObject("fullSaleOrgUnit");
        HashSet<String> companyIdSet = new HashSet<String>();
        HashSet<String> storageIdSet = new HashSet<String>();
        HashSet<String> SaleIdSet = new HashSet<String>();
        StorageOrgUnitCollection storageColl = null;
        CompanyOrgUnitCollection companyColl = null;
        SaleOrgUnitCollection saleColl = null;
        int length = companyOrgUnit.length;
        for (i = 0; i < length; ++i) {
            if (!(companyOrgUnit[i] instanceof OrgUnitInfo)) continue;
            companyIdSet.add(((OrgUnitInfo)companyOrgUnit[i]).getId().toString());
        }
        length = storageOrgUnit.length;
        for (i = 0; i < length; ++i) {
            if (!(storageOrgUnit[i] instanceof OrgUnitInfo)) continue;
            storageIdSet.add(((OrgUnitInfo)storageOrgUnit[i]).getId().toString());
        }
        length = SaleOrgUnit.length;
        for (i = 0; i < length; ++i) {
            if (!(SaleOrgUnit[i] instanceof OrgUnitInfo)) continue;
            SaleIdSet.add(((OrgUnitInfo)SaleOrgUnit[i]).getId().toString());
        }
        if (this.selectedCompanyInfos == null && companyOrgUnit != null && companyOrgUnit.length != 0 && companyIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            items = filter.getFilterItems();
            view.setFilter(filter);
            items.add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
            view.getSelector().add("id");
            view.getSelector().add("name");
            view.getSelector().add("number");
            view.getSelector().add("isBizUnit");
            view.getSelector().add("isOnlyUnion");
            view.getSelector().add("cu.id");
            try {
                companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.selectedCompanyInfos = companyColl;
        }
        if (this.selectedStorageOrgInfos == null && storageOrgUnit != null && storageOrgUnit.length != 0 && storageIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            items = filter.getFilterItems();
            items.add(new FilterItemInfo("id", storageIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("name");
            view.getSelector().add("number");
            view.getSelector().add("isBizUnit");
            view.getSelector().add("isOnlyUnion");
            view.getSelector().add("cu.id");
            try {
                storageColl = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.selectedStorageOrgInfos = storageColl;
        }
        if (this.selectedSaleOrgInfos == null && SaleOrgUnit != null && SaleOrgUnit.length != 0 && SaleIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            items = filter.getFilterItems();
            items.add(new FilterItemInfo("id", SaleIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("name");
            view.getSelector().add("number");
            view.getSelector().add("isBizUnit");
            view.getSelector().add("isOnlyUnion");
            view.getSelector().add("cu.id");
            try {
                saleColl = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.selectedSaleOrgInfos = saleColl;
        }
        params.setString("fullSaleOrgUnitName", this.prmtSaleOrgUnit.getText());
        params.setObject("fullCompanyOrgUnit", (Object)this.selectedCompanyInfos);
        params.setObject("fullStorageOrgUnit", (Object)this.selectedStorageOrgInfos);
        params.setObject("fullSaleOrgUnit", (Object)this.selectedSaleOrgInfos);
        return params;
    }

    protected String getViewPermission() {
        String viewPermission = "SaleCostDetailUI_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public void clear() {
        super.clear();
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (currentMainOrg.isIsSaleOrgUnit()) {
            this.prmtSaleOrgUnit.setValue((Object)new OrgUnitInfo[]{currentMainOrg.castToFullOrgUnitInfo()});
        } else {
            this.prmtSaleOrgUnit.setValue(null);
        }
        if (currentMainOrg.isIsStorageOrgUnit()) {
            this.prmtStorageOrgUnit.setValue((Object)new OrgUnitInfo[]{currentMainOrg.castToFullOrgUnitInfo()});
        } else {
            this.prmtStorageOrgUnit.setValue(null);
        }
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtSaleGroupFrom.setValue(null);
        this.prmtSaleGroupTo.setValue(null);
        this.prmtSalePersonFrom.setValue(null);
        this.prmtSalePersonTo.setValue(null);
        this.prmtDeptFrom.setValue(null);
        this.prmtDeptTo.setValue(null);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.AuxiliaryProperties.setSelected(false);
        try {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
            if (company != null) {
                this.loadAccountPeriod(company);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.spinPeriodYear.setEnabled(false);
        this.spinPeriodYearTo.setEnabled(false);
        this.spinPeriodMonth.setEnabled(false);
        this.spinPeriodMonthTo.setEnabled(false);
        this.chrDispSum.setSelected(false);
        this.chrDispAllSum.setSelected(false);
    }

    private void setPeriod(KDSpinner periodYear, CompanyOrgUnitInfo companyInfo) {
        try {
            if (periodYear.getValue() != null) {
                KDSpinner kdspinner = this.spinPeriodMonth;
                if (periodYear.equals(this.spinPeriodYearTo)) {
                    kdspinner = this.spinPeriodMonthTo;
                }
                int year = (Integer)periodYear.getValue();
                PeriodInfo curPeriodInfo = null;
                PeriodInfo startPeriodInfo = null;
                int minMonth = 1;
                int maxMonth = 12;
                if (companyInfo != null) {
                    if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                        WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                        curPeriodInfo = info.getCurPeriodInfo();
                        startPeriodInfo = info.getStartPeriodInfo();
                        minMonth = info.getMinMonth();
                        maxMonth = info.getMaxMonth();
                    } else {
                        curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        minMonth = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                        maxMonth = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                    }
                    if (minMonth == 0) {
                        minMonth = 1;
                    }
                    if (maxMonth == 0) {
                        maxMonth = 12;
                    }
                }
                if (startPeriodInfo != null && year == startPeriodInfo.getPeriodYear()) {
                    minMonth = startPeriodInfo.getPeriodNumber();
                }
                this.setSpinnerMaxMin((JSpinner)kdspinner, minMonth, maxMonth);
                if (curPeriodInfo != null) {
                    kdspinner.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                }
                if (kdspinner.getIntegerVlaue() < minMonth) {
                    kdspinner.setValue((Object)new Integer(minMonth));
                }
                if (kdspinner.getIntegerVlaue() > maxMonth) {
                    kdspinner.setValue((Object)new Integer(maxMonth));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo = null;
        int minYear = 0;
        int maxYear = 0;
        if (companyInfo != null) {
            if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                curPeriodInfo = info.getCurPeriodInfo();
                minYear = info.getMinYear();
                maxYear = info.getMaxYear();
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                minYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)false);
                maxYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)true);
            }
        }
        this.setSpinnerMaxMin((JSpinner)this.spinPeriodYear, minYear, maxYear);
        this.setSpinnerMaxMin((JSpinner)this.spinPeriodYearTo, minYear, maxYear);
        if (curPeriodInfo != null) {
            this.spinPeriodYear.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.spinPeriodYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.setPeriod(this.spinPeriodYear, companyInfo);
            this.setPeriod(this.spinPeriodYearTo, companyInfo);
        } else {
            Calendar ca = Calendar.getInstance();
            this.spinPeriodYear.setValue((Object)new Integer(ca.get(1)));
            this.spinPeriodYearTo.setValue((Object)new Integer(ca.get(1)));
            this.spinPeriodMonth.setValue((Object)new Integer(ca.get(2) + 1));
            this.spinPeriodMonthTo.setValue((Object)new Integer(ca.get(2) + 1));
        }
    }

    public boolean verify() {
        Object[] org;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtCompanyOrgUnit.getValue() == null || ((Object[])this.prmtCompanyOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtCompanyOrgUnit.getValue()).length == 1 && ((org = (Object[])this.prmtCompanyOrgUnit.getValue())[0] == null || org[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"companyOrgUnitNotNull"));
            return false;
        }
        if (this.prmtStorageOrgUnit.getValue() == null || ((Object[])this.prmtStorageOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtStorageOrgUnit.getValue()).length == 1 && ((org = (Object[])this.prmtStorageOrgUnit.getValue())[0] == null || org[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"storageOrgUnitNotNull"));
            return false;
        }
        if (this.prmtSaleOrgUnit.getValue() == null || ((Object[])this.prmtSaleOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtSaleOrgUnit.getValue()).length == 1 && ((org = (Object[])this.prmtSaleOrgUnit.getValue())[0] == null || org[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleCostDetailConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }

    protected void addAuxiliaryPropertiesListener() {
        this.AuxiliaryProperties.setVisible(false);
        this.AuxiliaryProperties.setSelected(false);
        this.AuxiliaryProperties.setEnabled(false);
        this.combOrderCol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleCostDetailConditionUI.this.AuxiliaryProperties_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleCostDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void AuxiliaryProperties_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.combOrderCol.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (selectedItem.equals((Object)SaleCostDetailOrderColEnum.Material)) {
            this.AuxiliaryProperties.setVisible(true);
            this.AuxiliaryProperties.setEnabled(true);
        } else {
            this.AuxiliaryProperties.setVisible(false);
            this.AuxiliaryProperties.setEnabled(false);
            this.AuxiliaryProperties.setSelected(false);
        }
    }

    public void setDepartF7filter() throws Exception {
        OrgUnitCollection collection = null;
        collection = this.getAuthOrgByPermItem(SysContext.getSysContext(), OrgType.Admin, "SaleCostDetailUI_view");
        if (collection == null || collection.size() == 0) {
            return;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo = SCMClientUtils.getAdminF7OUFilter();
        FilterInfo filter = null;
        filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmtDeptFrom.setEntityViewInfo(viewInfo);
        this.prmtDeptTo.setEntityViewInfo(viewInfo);
    }

    public OrgUnitCollection getAuthOrgByPermItem(SysContext sysContext, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getRemoteInstance();
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(sysContext.getCurrentUserInfo().getId().toString());
        FullOrgUnitCollection result = permission.getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }
}

