/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.sale.report.SaleDiscountTotalRptEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleDiscountTotalStatusEnum;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleDiscountTotalRptConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class SaleDiscountTotalRptConditionUI
extends AbstractSaleDiscountTotalRptConditionUI {
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private SCMRptMultiOrgsF7 f7;

    public SaleDiscountTotalRptConditionUI() throws Exception {
        this.isReport = true;
        this.addCkBxSimpleNameListener();
        this.f7 = new SCMRptMultiOrgsF7(this.prmtOrgUnit, OrgType.Sale, EASResource.getString((String)resClassName, (String)"saleOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        this.prmtSalePersonFrom.setEnabledMultiSelection(true);
        this.prmtSalePersonFrom.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        this.prmtSalePersonTo.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        SCMClientUtils.setSalePersonDisplayMulti((KDBizPromptBox)this.prmtSalePersonFrom);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)this.prmtSalePersonTo);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtSalePersonFrom, (KDBizPromptBox)this.prmtSalePersonTo);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullOrgUnit", this.f7, this.prmtOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        element = new SingleFilterElement("Currency", (Component)this.prmtCurrency);
        element.setDefaultValue((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId())));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupFrom", (Component)this.prmtSaleGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupTo", (Component)this.prmtSaleGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiF7FilterElement multiElement = new MultiF7FilterElement("SalePersonFrom", this.prmtSalePersonFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("SalePersonTo", (Component)this.prmtSalePersonTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        multiElement = new MultiF7FilterElement("CustomerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("CustomerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        multiElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        element = new SingleFilterElement("baseStatus", (Component)this.combBillStatus);
        element.setDefaultValue((Object)SaleDiscountTotalStatusEnum.all);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("Classification", (Component)this.combClassification);
        element.setDefaultValue((Object)SaleDiscountTotalRptEnum.material);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SpinnerGrade", (Component)this.spinnerGrade, this.spinnerGrade.getValue());
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSaleGroupFrom, this.prmtSaleGroupTo, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtMaterialFrom, this.prmtMaterialTo});
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                SaleDiscountTotalRptConditionUI.this.orgsChanged(SaleDiscountTotalRptConditionUI.this.f7, SaleDiscountTotalRptConditionUI.this.f7Manager);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.setSize(436, 310);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    protected String getViewPermission() {
        String viewPermission = "SaleDiscountTotalRptUI_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    @Override
    protected void combClassification_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.combClassification.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (selectedItem.equals((Object)SaleDiscountTotalRptEnum.material) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.customer) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.salePerson) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.saleGroup) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.materialPlusCustomer) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.customerPlusMaterial) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.saleGroupPlusSalePersonPlusMaterial) || selectedItem.equals((Object)SaleDiscountTotalRptEnum.saleGroupPlusMaterial)) {
            this.contGrade.setVisible(false);
            this.setSpinValue(this.spinnerGrade, new Integer(0));
        }
    }

    public void clear() {
        super.clear();
        this.prmtSaleGroupFrom.setValue(null);
        this.prmtSaleGroupTo.setValue(null);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtSaleGroupFrom.setValue(null);
        this.prmtSaleGroupTo.setValue(null);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        try {
            this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId())));
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    private void setSpinValue(KDSpinner sp, Integer val) {
        SpinnerModel sm = sp.getModel();
        SpinnerNumberModel nm = (SpinnerNumberModel)sm;
        Integer maxVal = (Integer)nm.getMaximum();
        if (maxVal == null) {
            maxVal = new Integer(1);
        }
        if (maxVal.compareTo(val) < 0) {
            nm.setValue(maxVal);
        } else {
            nm.setValue(val);
        }
    }

    public boolean verify() {
        Object[] purchaseOrg;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtCurrency.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"CURRENCY_NOT_NULL"));
            this.prmtCurrency.requestFocus();
            return false;
        }
        if (this.combBillStatus.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"combBillStatusNotNull"));
            this.combBillStatus.requestFocus();
            return false;
        }
        if (this.combClassification.getSelectedItem() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"combClassificationNotNull"));
            this.combBillStatus.requestFocus();
            return false;
        }
        if (this.prmtOrgUnit.getValue() == null || ((Object[])this.prmtOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtOrgUnit.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtOrgUnit.getValue())[0] == null || purchaseOrg[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleDiscountTotalRptConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleDiscountTotalRptConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }
}

