/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReportClassificationEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleGrossProfitsFactory;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleGrossProfitsUI;
import com.kingdee.eas.scm.sd.sale.report.client.SaleGrossProfitsConditionUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleGrossProfitsUI
extends AbstractSaleGrossProfitsUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleGrossProfitsUI.class);
    private static final int defaultCurrencyPercision = 4;
    private boolean isCreateTempTable = false;
    private int levelCount = 1;
    private List totalColLst = null;
    private SaleGrossProfitsConditionUI conditionUI = null;
    private boolean isShowStat = false;

    public SaleGrossProfitsUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        if (this.conditionUI == null) {
            this.conditionUI = new SaleGrossProfitsConditionUI();
        }
        return this.conditionUI;
    }

    public void beforePrint() {
        this.logUIOperation("LOG_SALEGROSSPROFITS");
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.report.SDReportResource", (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void query() {
        this.isCreateTempTable = false;
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            if (!this.isCreateTempTable) {
                int freezeCol;
                pp.setString("tempTable", this.getTempTable());
                pp.putAll(this.params.toMap());
                rpt = SaleGrossProfitsFactory.getRemoteInstance().createTempTable(pp);
                this.setTempTable(rpt.getString("tempTable"));
                logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"65_SaleGrossProfitsUI") + rpt.getString("tempTable")));
                this.levelCount = rpt.getInt("levelCount");
                RptTableHeader header = this.createHead();
                this.totalColLst = null;
                this.tblMain.removeHeadRows();
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                if (!this.params.getBoolean("ckBxShowMShortName") && (freezeCol = this.tblMain.getColumnIndex("fmaterialShortName")) != -1) {
                    this.tblMain.getColumn(freezeCol).getStyleAttributes().setHided(true);
                    this.tblMain.getColumn(freezeCol).setWidth(-1);
                }
                if (this.params.getBoolean("AuxiliaryProperties")) {
                    freezeCol = this.tblMain.getColumnIndex("FassistPropertyName");
                    if (freezeCol != -1) {
                        this.tblMain.getColumn(freezeCol).getStyleAttributes().setHided(false);
                    }
                } else {
                    freezeCol = this.tblMain.getColumnIndex("FassistPropertyName");
                    if (freezeCol != -1) {
                        this.tblMain.getColumn(freezeCol).getStyleAttributes().setHided(true);
                    }
                }
                SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(this.params.getString("classification")));
                if (classficationType.equals((Object)SaleReportClassificationEnum.saleorder) || classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
                    this.tblMain.getColumn("custormer").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("custormer").setWidth(100);
                    this.tblMain.getColumn("adminOrgUnit").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("adminOrgUnit").setWidth(100);
                    this.tblMain.getColumn("saleGroup").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("saleGroup").setWidth(100);
                    this.tblMain.getColumn("salePerson").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("salePerson").setWidth(100);
                }
                this.tblMain.setRowCount(rpt.getInt("rowCount"));
                this.appendFootRow(rpt);
                this.setFiledPression(rpt);
            } else {
                pp.putAll(this.params.toMap());
            }
            this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
            pp.setString("tempTable", this.getTempTable());
            pp.setInt("levelCount", this.levelCount);
            rpt = SaleGrossProfitsFactory.getRemoteInstance().query(pp, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            if (rs != null) {
                SCMRptUtil.insertRows((RptRowSet)rs, (int)from, (CoreUI)this, (KDTable)this.tblMain, (ITablePreferenceHelper)this.tHelper);
            }
            String curPrecision = PrecisionUtil.getFormatString((int)4);
            this.tblMain.getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("FSaleIncome").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FSaleIncome").getStyleAttributes().setNumberFormat(curPrecision);
            this.tblMain.getColumn("FSaleCost").getStyleAttributes().setNumberFormat(curPrecision);
            this.tblMain.getColumn("FSaleCost").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FTotalSaleFee").getStyleAttributes().setNumberFormat(curPrecision);
            this.tblMain.getColumn("FTotalSaleFee").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FSaleProfit").getStyleAttributes().setNumberFormat(curPrecision);
            this.tblMain.getColumn("FSaleProfit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FSaleProfitRate").getStyleAttributes().setNumberFormat("%r-{#,##0.00%*}f");
            this.tblMain.getColumn("FSaleProfitRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FQtyPrecision").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("FSaleQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn("FOutQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (this.isShowStat) {
                this.tblMain.getColumn("FstatSaleProfit").getStyleAttributes().setNumberFormat(curPrecision);
                this.tblMain.getColumn("FstatSaleProfit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn("FUnitSaleProfit").getStyleAttributes().setNumberFormat(curPrecision);
                this.tblMain.getColumn("FUnitSaleProfit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn("FstatSaleQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn("FstatOutQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            this.setQtyPrecision(this.tblMain, e.getFirstRow(), e.getLastRow());
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (!this.isCreateTempTable) {
            int freezeCol;
            this.initUserConfig();
            this.isCreateTempTable = true;
            if (!this.params.getBoolean("ckBxShowMShortName") && (freezeCol = this.tblMain.getColumnIndex("fmaterialShortName")) != -1) {
                this.tblMain.getColumn(freezeCol).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(freezeCol).setWidth(-1);
            }
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected IRow appendFootRow(RptParams params) {
        try {
            RptRowSet singleRowSet = null;
            singleRowSet = (RptRowSet)params.getObject("totalRs");
            KDTFootManager footRowManager = this.tblMain.getFootManager();
            if (singleRowSet == null) {
                if (footRowManager != null) {
                    footRowManager.getFoot().removeRows();
                }
                return null;
            }
            DefaultKDTableInsertHandler handler = new DefaultKDTableInsertHandler(singleRowSet);
            singleRowSet.next();
            IRow footRow = null;
            if (footRowManager == null) {
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                footRowManager = new KDTFootManager(this.tblMain);
                footRowManager.addFootView();
                this.tblMain.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                this.tblMain.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            if (singleRowSet != null && handler != null) {
                handler.setTableRowData(footRow, SCMRptUtil.sortRowData((Object[])singleRowSet.toRowArray(), (CoreUI)this, (KDTable)this.tblMain, (ITablePreferenceHelper)this.tHelper));
            }
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            footRow.getStyleAttributes().setFontColor(Color.BLACK);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            this.setFootRowNumberFormat(footRow);
            return footRow;
        }
        catch (Exception E) {
            E.printStackTrace();
            logger.error((Object)E);
            return null;
        }
    }

    private void setFootRowNumberFormat(IRow footRow) {
        int qtyPrecision;
        int amountPrecision;
        SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(this.params.getString("classification")));
        if (classficationType.equals((Object)SaleReportClassificationEnum.customer) || classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || classficationType.equals((Object)SaleReportClassificationEnum.saleorder) || classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            amountPrecision = Integer.parseInt(this.params.getObject("amountPrecision1").toString());
            qtyPrecision = Integer.parseInt(this.params.getObject("spnPrecision").toString());
        } else {
            amountPrecision = Integer.parseInt(this.params.getObject("amountPrecision2").toString());
            qtyPrecision = Integer.parseInt(this.params.getObject("qtyPrecision").toString());
        }
        if (amountPrecision == 0) {
            amountPrecision = 4;
        }
        String amountPrecisionString = PrecisionUtil.getFormatString((int)amountPrecision);
        footRow.getCell("FSaleCost").getStyleAttributes().setNumberFormat(amountPrecisionString);
        footRow.getCell("FSaleIncome").getStyleAttributes().setNumberFormat(amountPrecisionString);
        footRow.getCell("FSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
        if (this.isShowStat) {
            footRow.getCell("FUnitSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
            footRow.getCell("FstatSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
        }
        if (qtyPrecision == 0) {
            qtyPrecision = 2;
        }
        String qtyPrecisionString = PrecisionUtil.getFormatString((int)qtyPrecision);
        footRow.getCell("FSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
        footRow.getCell("FOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
        if (this.isShowStat) {
            footRow.getCell("FstatSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
            footRow.getCell("FstatOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
        }
        footRow.getCell("FSaleProfitRate").getStyleAttributes().setNumberFormat("%r-{#,##0.00%*}f");
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        Object[] rowData = null;
        while (rs.next()) {
            IRow row = table.setRow(rowIndex++);
            rowData = SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    private void setFiledPression(RptParams rpt) {
        boolean SaleQtyFlag = rpt.getBoolean("SaleQty");
        boolean OutQtyFlag = rpt.getBoolean("OutQty");
        boolean SaleIncomeFlag = rpt.getBoolean("SaleIncome");
        boolean SaleCostFlag = rpt.getBoolean("SaleCost");
        boolean SaleProfitFlag = rpt.getBoolean("SaleProfit");
        boolean SaleProfitRateFlag = rpt.getBoolean("SaleProfitRate");
        int FSaleQty = this.tblMain.getColumnIndex("FSaleQty");
        int FStatSaleQty = this.tblMain.getColumnIndex("FstatSaleQty");
        int FOutQty = this.tblMain.getColumnIndex("FOutQty");
        int FStatOutQty = this.tblMain.getColumnIndex("FstatOutQty");
        int FSaleIncome = this.tblMain.getColumnIndex("FSaleIncome");
        int FSaleCost = this.tblMain.getColumnIndex("FSaleCost");
        int FSaleProfit = this.tblMain.getColumnIndex("FSaleProfit");
        int FSaleProfitRate = this.tblMain.getColumnIndex("FSaleProfitRate");
        int FstatSaleProfitRate = this.tblMain.getColumnIndex("FstatSaleProfit");
        int FstatUnitSaleProfitRate = this.tblMain.getColumnIndex("FUnitSaleProfit");
        int colWith = 128;
        if (!SaleQtyFlag) {
            if (FSaleQty != -1) {
                this.tblMain.getColumn(FSaleQty).setWidth(-1);
                this.tblMain.getColumn(FSaleQty).getStyleAttributes().setHided(true);
            }
            if (FStatSaleQty != -1) {
                this.tblMain.getColumn(FStatSaleQty).setWidth(-1);
                this.tblMain.getColumn(FStatSaleQty).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FSaleQty).setWidth(colWith);
            this.tblMain.getColumn(FSaleQty).getStyleAttributes().setHided(false);
            if (FStatSaleQty != -1) {
                this.tblMain.getColumn(FStatSaleQty).setWidth(colWith);
                this.tblMain.getColumn(FStatSaleQty).getStyleAttributes().setHided(false);
            }
        }
        if (!OutQtyFlag) {
            if (FOutQty != -1) {
                this.tblMain.getColumn(FOutQty).setWidth(-1);
                this.tblMain.getColumn(FOutQty).getStyleAttributes().setHided(true);
            }
            if (FStatOutQty != -1) {
                this.tblMain.getColumn(FStatOutQty).setWidth(-1);
                this.tblMain.getColumn(FStatOutQty).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FOutQty).setWidth(colWith);
            this.tblMain.getColumn(FOutQty).getStyleAttributes().setHided(false);
            if (FStatOutQty != -1) {
                this.tblMain.getColumn(FStatOutQty).setWidth(colWith);
                this.tblMain.getColumn(FStatOutQty).getStyleAttributes().setHided(false);
            }
        }
        if (!SaleIncomeFlag) {
            if (FSaleIncome != -1) {
                this.tblMain.getColumn(FSaleIncome).setWidth(-1);
                this.tblMain.getColumn(FSaleIncome).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FSaleIncome).setWidth(100);
            this.tblMain.getColumn(FSaleIncome).getStyleAttributes().setHided(false);
        }
        if (!SaleCostFlag) {
            if (FSaleCost != -1) {
                this.tblMain.getColumn(FSaleCost).setWidth(-1);
                this.tblMain.getColumn(FSaleCost).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FSaleCost).setWidth(100);
            this.tblMain.getColumn(FSaleCost).getStyleAttributes().setHided(false);
        }
        if (!SaleProfitFlag) {
            if (FSaleProfit != -1) {
                this.tblMain.getColumn(FSaleProfit).setWidth(-1);
                this.tblMain.getColumn(FSaleProfit).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FSaleProfit).setWidth(100);
            this.tblMain.getColumn(FSaleProfit).getStyleAttributes().setHided(false);
        }
        if (!SaleProfitRateFlag) {
            if (FSaleProfitRate != -1) {
                this.tblMain.getColumn(FSaleProfitRate).setWidth(-1);
                this.tblMain.getColumn(FSaleProfitRate).getStyleAttributes().setHided(true);
            }
            if (FstatSaleProfitRate != -1) {
                this.tblMain.getColumn(FstatSaleProfitRate).setWidth(-1);
                this.tblMain.getColumn(FstatSaleProfitRate).getStyleAttributes().setHided(true);
            }
            if (FstatUnitSaleProfitRate != -1) {
                this.tblMain.getColumn(FstatUnitSaleProfitRate).setWidth(-1);
                this.tblMain.getColumn(FstatUnitSaleProfitRate).getStyleAttributes().setHided(true);
            }
        } else {
            this.tblMain.getColumn(FSaleProfitRate).setWidth(100);
            this.tblMain.getColumn(FSaleProfitRate).getStyleAttributes().setHided(false);
            if (FstatSaleProfitRate != -1) {
                this.tblMain.getColumn(FstatSaleProfitRate).setWidth(colWith);
                this.tblMain.getColumn(FstatSaleProfitRate).getStyleAttributes().setHided(false);
            }
            if (FstatUnitSaleProfitRate != -1) {
                this.tblMain.getColumn(FstatUnitSaleProfitRate).setWidth(colWith);
                this.tblMain.getColumn(FstatUnitSaleProfitRate).getStyleAttributes().setHided(false);
            }
        }
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception e) {
                            this.handleException(e);
                            logger.error((Object)e);
                        }
                    }
                }
            }
            boolean ok = false;
            if (cp == null || !useDefaultSolution) {
                this.conditionUI.onShow();
                if (this.queryDialog.show()) {
                    rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                    this.params = rbqp.getCustomCondition();
                    ok = true;
                }
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setHeight(580);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    private void setQtyPrecision(KDTable table, int fromRow, int toRow) {
        String subLabel = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.report.SDReportResource", (String)"SUB_STRING");
        toRow = Math.min(table.getRowCount(), toRow + 1);
        int precision = Integer.valueOf(this.params.getObject("spnPrecision").toString());
        int qtyprecision = Integer.valueOf(this.params.getObject("qtyPrecision").toString());
        int amountPrecision1 = Integer.valueOf(this.params.getObject("amountPrecision1").toString());
        int amountPrecision2 = Integer.valueOf(this.params.getObject("amountPrecision2").toString());
        SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(this.params.getString("classification")));
        boolean isNotDefaultPrecision = classficationType.equals((Object)SaleReportClassificationEnum.customer) || classficationType.equals((Object)SaleReportClassificationEnum.materialGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerGroup) || classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup) || classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer) || classficationType.equals((Object)SaleReportClassificationEnum.saleorder) || classficationType.equals((Object)SaleReportClassificationEnum.salecontract);
        String amountPrecisionString = null;
        if (isNotDefaultPrecision && amountPrecision1 != 0) {
            amountPrecisionString = PrecisionUtil.getFormatString((int)amountPrecision1);
        } else if (!isNotDefaultPrecision && amountPrecision2 != 0) {
            amountPrecisionString = PrecisionUtil.getFormatString((int)amountPrecision2);
        }
        if (amountPrecisionString != null) {
            table.getColumn("FSaleIncome").getStyleAttributes().setNumberFormat(amountPrecisionString);
            table.getColumn("FSaleCost").getStyleAttributes().setNumberFormat(amountPrecisionString);
            table.getColumn("FSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
            if (this.isShowStat) {
                table.getColumn("FUnitSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
                table.getColumn("FstatSaleProfit").getStyleAttributes().setNumberFormat(amountPrecisionString);
            }
        }
        for (int row = fromRow; row < toRow; ++row) {
            String qtyPrecisionString;
            int qtyPrecision;
            Object qtyPre;
            String qtyPrecisionString2;
            if (isNotDefaultPrecision) {
                if (precision != 0) {
                    qtyPrecisionString2 = PrecisionUtil.getFormatString((int)precision);
                    table.getCell(row, "FSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                    table.getCell(row, "FOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                    if (this.isShowStat) {
                        table.getCell(row, "FstatSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                        table.getCell(row, "FstatOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                    }
                } else {
                    qtyPre = table.getCell(row, "FQtyPrecision").getValue();
                    if (qtyPre != null) {
                        qtyPrecision = Integer.parseInt(qtyPre.toString());
                        qtyPrecisionString = PrecisionUtil.getFormatString((int)qtyPrecision);
                        table.getCell(row, "FSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                        table.getCell(row, "FOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                        if (this.isShowStat) {
                            table.getCell(row, "FstatSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                            table.getCell(row, "FstatOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                        }
                    }
                }
            } else if (qtyprecision != 0) {
                qtyPrecisionString2 = PrecisionUtil.getFormatString((int)qtyprecision);
                table.getCell(row, "FSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                table.getCell(row, "FOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                if (this.isShowStat) {
                    table.getCell(row, "FstatSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                    table.getCell(row, "FstatOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString2);
                }
            } else {
                qtyPre = table.getCell(row, "FQtyPrecision").getValue();
                if (qtyPre != null) {
                    qtyPrecision = Integer.parseInt(qtyPre.toString());
                    qtyPrecisionString = PrecisionUtil.getFormatString((int)qtyPrecision);
                    table.getCell(row, "FSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                    table.getCell(row, "FOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                    if (this.isShowStat) {
                        table.getCell(row, "FstatSaleQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                        table.getCell(row, "FstatOutQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
                    }
                }
            }
            for (String colName : this.getTotalColName()) {
                Object value = table.getCell(row, colName).getValue();
                if (value == null || !value.toString().trim().equals(subLabel)) continue;
                IRow tRow = table.getRow(row);
                Color necessaryColor = new Color(252, 251, 223);
                tRow.getStyleAttributes().setBackground(necessaryColor);
            }
        }
    }

    private RptTableHeader createHead() {
        String materialNum = SaleUtil.getReportUIResource("materialNumber");
        String materialName = SaleUtil.getReportUIResource("materialName");
        String shortName = SaleUtil.getReportUIResource("MaterialShortName");
        String model = SaleUtil.getReportUIResource("materialModel");
        String baseUnit = SaleUtil.getReportUIResource("baseUnit");
        String saleQty = SaleUtil.getReportUIResource("saleQty");
        String outQty = SaleUtil.getReportUIResource("storageQty");
        String saleQtyUnit = SaleUtil.getReportUIResource("saleQtyUnit");
        String outQtyUnit = SaleUtil.getReportUIResource("storageQtyUnit");
        String statUnit = SaleUtil.getReportUIResource("statUnit");
        String statSaleQty = SaleUtil.getReportUIResource("statSaleQty");
        String statOutQty = SaleUtil.getReportUIResource("statStorageQty");
        String saleIncome = SaleUtil.getReportUIResource("saleIncome");
        String saleCost = SaleUtil.getReportUIResource("saleCost");
        String totalSaleFee = SaleUtil.getReportUIResource("totalSaleFee");
        String saleProfit = SaleUtil.getReportUIResource("saleProfit");
        String statSaleProfit = SaleUtil.getReportUIResource("statSaleProfit");
        String unitProfit = SaleUtil.getReportUIResource("unitSaleProfit");
        String materialClassification = SaleUtil.getReportUIResource("materialClassfication");
        String customerNum = SaleUtil.getReportUIResource("customerNumber");
        String customerName = SaleUtil.getReportUIResource("customerName");
        String customerClassfication = SaleUtil.getReportUIResource("customerClassfication");
        String saleProfitRate = SaleUtil.getReportUIResource("saleProfitRate");
        String saleOrderNo = SaleUtil.getReportUIResource("saleOrderNo");
        String saleContractNo = SaleUtil.getReportUIResource("saleContractNo");
        String deptName = SaleUtil.getReportUIResource("adminunitName");
        String salePersonNum = SaleUtil.getReportUIResource("salePersonNumber");
        String salePersonName = SaleUtil.getReportUIResource("salePersonName");
        String saleGroupName = SaleUtil.getReportUIResource("saleGroupName");
        String saleOrgUnitNumber = SaleUtil.getReportUIResource("saleOrgUnitNumber");
        String saleOrgUnitName = SaleUtil.getReportUIResource("saleOrgUnitName");
        String assistProperty = SaleUtil.getReportUIResource("assistProperty");
        SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(this.params.getString("classification")));
        StringBuffer colsMGBuff = new StringBuffer();
        StringBuffer labelMGBuff = new StringBuffer();
        for (int i = 0; i < this.levelCount; ++i) {
            labelMGBuff.append(String.valueOf(i + 1) + materialClassification);
            labelMGBuff.append(",");
            colsMGBuff.append("FGroup" + String.valueOf(i + 1));
            colsMGBuff.append(",");
        }
        StringBuffer colsCGBuff = new StringBuffer();
        StringBuffer labelCGBuff = new StringBuffer();
        for (int i = 0; i < this.levelCount; ++i) {
            labelCGBuff.append(String.valueOf(i + 1) + customerClassfication);
            labelCGBuff.append(",");
            colsCGBuff.append("FGroup" + String.valueOf(i + 1));
            colsCGBuff.append(",");
        }
        RptTableHeader header = new RptTableHeader();
        this.isShowStat = false;
        StringBuffer cols = new StringBuffer(300).append("id,");
        StringBuffer labels = new StringBuffer(300).append("id,");
        if (classficationType.equals((Object)SaleReportClassificationEnum.material)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            } else {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customer)) {
            cols.append("fcustomerNumber,fcustomerName,FQtyPrecision,");
            labels.append(customerNum).append(",").append(customerName).append(",FQtyPrecision,");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialGroup)) {
            cols.append(colsMGBuff).append("FQtyPrecision,");
            labels.append(labelMGBuff).append("FQtyPrecision,");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) {
            cols.append(colsCGBuff).append("FQtyPrecision,");
            labels.append(labelCGBuff).append("FQtyPrecision,");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,").append(colsCGBuff);
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",").append(labelCGBuff);
            } else {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,").append(colsCGBuff);
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",").append(labelCGBuff);
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,fcustomerNumber,fcustomerName,");
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",").append(customerNum).append(",").append(customerName).append(",");
            } else {
                cols.append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,fcustomerNumber,fcustomerName,");
                labels.append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",").append(customerNum).append(",").append(customerName).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fcustomerNumber,fcustomerName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(customerNum).append(",").append(customerName).append(",").append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            } else {
                cols.append("fcustomerNumber,fcustomerName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(customerNum).append(",").append(customerName).append(",").append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            cols.append("fcustomerNumber,fcustomerName,FQtyPrecision,").append(colsMGBuff);
            labels.append(customerNum).append(",").append(customerName).append(",FQtyPrecision,").append(labelMGBuff);
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append(colsCGBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(labelCGBuff).append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            } else {
                cols.append(colsCGBuff).append("fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(labelCGBuff).append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            cols.append(colsMGBuff).append("fcustomerNumber,fcustomerName,FQtyPrecision,");
            labels.append(labelMGBuff).append(customerNum).append(",").append(customerName).append(",FQtyPrecision,");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            cols.append("fsoNumber,FQtyPrecision,custormer,adminOrgUnit,saleGroup,salePerson,");
            labels.append(saleOrderNo).append(",FQtyPrecision,").append(customerName).append(",").append(deptName).append(",").append(saleGroupName).append(",").append(salePersonName).append(",");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            cols.append("fscNumber,FQtyPrecision,custormer,adminOrgUnit,saleGroup,salePerson,");
            labels.append(saleContractNo).append(",FQtyPrecision,").append(customerName).append(",").append(deptName).append(",").append(saleGroupName).append(",").append(salePersonName).append(",");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(deptName).append(",").append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append(assistProperty).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            } else {
                cols.append("fadminunitName,fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(deptName).append(",").append(materialNum).append(",").append(materialName).append(",").append(shortName).append(",").append(model).append(",").append("FQtyPrecision").append(",").append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fSalePersonNumber,fsalePersonName");
                cols.append(",fcustomerNumber,fcustomerName");
                cols.append(",fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(salePersonNum).append(",");
                labels.append(salePersonName).append(",");
                labels.append(customerNum).append(",");
                labels.append(customerName).append(",");
                labels.append(materialNum).append(",");
                labels.append(materialName).append(",");
                labels.append(shortName).append(",");
                labels.append(model).append(",");
                labels.append(assistProperty).append(",");
                labels.append("FQtyPrecision").append(",");
                labels.append(baseUnit).append(",");
            } else {
                cols.append("fSalePersonNumber,fsalePersonName");
                cols.append(",fcustomerNumber,fcustomerName");
                cols.append(",fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(salePersonNum).append(",");
                labels.append(salePersonName).append(",");
                labels.append(customerNum).append(",");
                labels.append(customerName).append(",");
                labels.append(materialNum).append(",");
                labels.append(materialName).append(",");
                labels.append(shortName).append(",");
                labels.append(model).append(",");
                labels.append("FQtyPrecision").append(",");
                labels.append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            this.isShowStat = true;
            if (this.params.getBoolean("AuxiliaryProperties")) {
                cols.append("fSaleOrgNum,fSaleOrgName");
                cols.append(",fcustomerNumber,fcustomerName");
                cols.append(",fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FassistPropertyName,FQtyPrecision,baseUnitName,");
                labels.append(saleOrgUnitNumber).append(",");
                labels.append(saleOrgUnitName).append(",");
                labels.append(customerNum).append(",");
                labels.append(customerName).append(",");
                labels.append(materialNum).append(",");
                labels.append(materialName).append(",");
                labels.append(shortName).append(",");
                labels.append(model).append(",");
                labels.append(assistProperty).append(",");
                labels.append("FQtyPrecision").append(",");
                labels.append(baseUnit).append(",");
            } else {
                cols.append("fSaleOrgNum,fSaleOrgName");
                cols.append(",fcustomerNumber,fcustomerName");
                cols.append(",fmaterialNum,fmaterialName,fmaterialShortName,Fmodel,FQtyPrecision,baseUnitName,");
                labels.append(saleOrgUnitNumber).append(",");
                labels.append(saleOrgUnitName).append(",");
                labels.append(customerNum).append(",");
                labels.append(customerName).append(",");
                labels.append(materialNum).append(",");
                labels.append(materialName).append(",");
                labels.append(shortName).append(",");
                labels.append(model).append(",");
                labels.append("FQtyPrecision").append(",");
                labels.append(baseUnit).append(",");
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            cols.append("fSalePersonNumber,fsalePersonName,");
            cols.append("fcustomerNumber,fcustomerName,");
            cols.append(colsMGBuff).append("FQtyPrecision,");
            labels.append(salePersonNum).append(",");
            labels.append(salePersonName).append(",");
            labels.append(customerNum).append(",");
            labels.append(customerName).append(",");
            labels.append(labelMGBuff);
            labels.append("FQtyPrecision").append(",");
        }
        if (this.isShowStat) {
            cols.append("FSaleQty,FOutQty,statUnitName,FstatSaleQty,FstatOutQty,FSaleIncome,FSaleCost,FTotalSaleFee,FSaleProfit,FSaleProfitRate,FUnitSaleProfit,FstatSaleProfit");
            labels.append(saleQtyUnit).append(",").append(outQtyUnit).append(",").append(statUnit).append(",").append(statSaleQty).append(",").append(statOutQty).append(",").append(saleIncome).append(",").append(saleCost).append(",").append(totalSaleFee).append(",").append(saleProfit).append(",").append(saleProfitRate).append(",").append(unitProfit).append(",").append(statSaleProfit);
        } else {
            cols.append("FSaleQty,FOutQty,FSaleIncome,FSaleCost,FTotalSaleFee,FSaleProfit,FSaleProfitRate");
            labels.append(saleQty).append(",").append(outQty).append(",").append(saleIncome).append(",").append(saleCost).append(",").append(totalSaleFee).append(",").append(saleProfit).append(",").append(saleProfitRate);
        }
        this.setHeaderColumns(header, cols.toString().split(","));
        header.setLabels((Object[][])new Object[][]{labels.toString().split(",")});
        return header;
    }

    private List getTotalColName() {
        if (this.totalColLst != null) {
            return this.totalColLst;
        }
        this.totalColLst = new ArrayList();
        SaleReportClassificationEnum classficationType = SaleReportClassificationEnum.getEnum(new Integer(this.params.getString("classification")));
        if (classficationType.equals((Object)SaleReportClassificationEnum.material)) {
            this.totalColLst.add("fmaterialNum");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customer)) {
            this.totalColLst.add("fcustomerNumber");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialGroup)) {
            for (int i = this.levelCount; i >= 1; --i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerGroup)) {
            for (int i = this.levelCount; i >= 1; --i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustGroup)) {
            for (int i = 1; i <= this.levelCount; ++i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materialPlusCustomer)) {
            this.totalColLst.add("fcustomerNumber");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusmaterial)) {
            this.totalColLst.add("fmaterialNum");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroup)) {
            for (int i = 1; i <= this.levelCount; ++i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.custGroupPlusMaterial)) {
            this.totalColLst.add("fmaterialNum");
            for (int i = this.levelCount; i >= 1; --i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.materGroupPlusCustomer)) {
            this.totalColLst.add("fcustomerNumber");
            for (int i = this.levelCount; i >= 1; --i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleorder)) {
            this.totalColLst.add("fsoNumber");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.salecontract)) {
            this.totalColLst.add("fscNumber");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.departmentplusmaterial)) {
            this.totalColLst.add("fmaterialNum");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterPerson)) {
            this.totalColLst.add("fcustomerNumber");
            this.totalColLst.add("fmaterialNum");
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.customerPlusMaterGroupPerson)) {
            this.totalColLst.add("fcustomerNumber");
            for (int i = this.levelCount; i >= 1; --i) {
                this.totalColLst.add("FGroup" + String.valueOf(i));
            }
        } else if (classficationType.equals((Object)SaleReportClassificationEnum.saleOrgPlusCustomerPlusMaterial)) {
            this.totalColLst.add("fmaterialNum");
            this.totalColLst.add("fcustomerNumber");
        }
        return this.totalColLst;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns) {
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            if (columns[i].equals("FSaleQty") || columns[i].equals("FOutQty") || columns[i].equals("FstatSaleQty") || columns[i].equals("FstatOutQty") || columns[i].equals("FUnitSaleProfit") || columns[i].equals("FstatSaleProfit")) {
                col.setWidth(128);
            } else {
                col.setWidth(-1);
            }
            header.addColumn(col);
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return SaleGrossProfitsFactory.getRemoteInstance();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    protected Map preparePrintVariantMap() {
        return null;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sd.sale.report.client.SaleGrossProfitsUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
            request.put("company", (Object)company);
            String currentCtrlUnitId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            String cuNumber = SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber();
            request.put("CurrentCtrlUnit", (Object)currentCtrlUnitId);
            request.put("cuNumber", (Object)cuNumber);
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.tHelper.setDefaultUserData(null);
        super.actionQuery_actionPerformed(e);
    }
}

