/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.WrittenOffFacadeFactory;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.report.SaleIncomDetailOrderColEnum;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleIncomDetailConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SaleIncomDetailConditionUI
extends AbstractSaleIncomDetailConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleIncomDetailConditionUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private SCMRptMultiOrgsF7 f7;
    private Map periodMap = new HashMap();

    public SaleIncomDetailConditionUI() throws Exception {
        this.datePickerStart.setRequired(true);
        this.datePickerEnd.setRequired(true);
        this.isReport = true;
        this.prmtDeptFrom.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtDeptTo.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.setDepartF7filter();
        this.addCkBxSimpleNameListener();
        this.addCkBxAssistPropertyListener();
        this.addListener();
        this.f7 = new SCMRptMultiOrgsF7(this.prmtOrgUnit, OrgType.Sale, EASResource.getString((String)resClassName, (String)"saleOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        this.prmtSalePersonFrom.setEnabledMultiSelection(true);
        this.prmtSalePersonFrom.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        this.prmtSalePersonTo.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        SCMClientUtils.setSalePersonDisplayMulti((KDBizPromptBox)this.prmtSalePersonFrom);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)this.prmtSalePersonTo);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtSalePersonFrom, (KDBizPromptBox)this.prmtSalePersonTo);
        this.prmtStorageOrgUnit.setEnabledMultiSelection(true);
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(true);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        this.combBillStatus.removeAllItems();
        this.combBillStatus.addItem((Object)SaleReportBillStatusEnum.all);
        this.combBillStatus.addItem((Object)SaleReportBillStatusEnum.cal);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        if (null != company && !this.periodMap.containsKey(company.getId().toString())) {
            Map map = WrittenOffFacadeFactory.getRemoteInstance().loadFinanceData(company.getId().toString());
            WriteOffPeriodInfo info = (WriteOffPeriodInfo)map.get(company.getId().toString());
            this.periodMap.put(company.getId().toString(), info);
        }
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.datePickerStart);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.datePickerEnd);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullOrgUnit", this.f7, this.prmtOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        element = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        element.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"StorageOrgUnitNotNull")));
        elements.add((FilterElement)element);
        element = new SingleFilterElement("companyOrgUnit.number", (Component)this.prmtCompanyOrgUnit);
        elements.add((FilterElement)element);
        MultiF7FilterElement multiElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        multiElement = new MultiF7FilterElement("CustomerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("CustomerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupFrom", (Component)this.prmtSaleGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("SaleGroupTo", (Component)this.prmtSaleGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        multiElement = new MultiF7FilterElement("SalePersonFrom", this.prmtSalePersonFrom, Boolean.valueOf(false));
        elements.add((FilterElement)multiElement);
        element = new SingleFilterElement("SalePersonTo", (Component)this.prmtSalePersonTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("DeptFrom", (Component)this.prmtDeptFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("DeptTo", (Component)this.prmtDeptTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("CombOrderCol", (Component)this.combOrderCol);
        element.setDefaultValue((Object)SaleIncomDetailOrderColEnum.Date);
        elements.add((FilterElement)element);
        CheckRadioFilterElement chrElement = new CheckRadioFilterElement("IsSum", (Component)this.chrDispAllSum);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        element = new SingleFilterElement("billStatus", (Component)this.combBillStatus);
        element.setDefaultValue((Object)SaleReportBillStatusEnum.all);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodYear", (Component)this.spinPeriodYear);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodYearTo", (Component)this.spinPeriodYearTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodMonth", (Component)this.spinPeriodMonth);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodMonthTo", (Component)this.spinPeriodMonthTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        chrElement = new CheckRadioFilterElement("IsTotal", (Component)this.chrDispSum);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        element = new SingleFilterElement("isDirectSale", (Component)this.chkDirectSale);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("isBizBill", (Component)this.chkIsBizBill);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setBizOrgF7ByType(this.prmtStorageOrgUnit, OrgType.Storage, this.getMainBizOrgType(), true);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtStorageOrgUnit, this.prmtMaterialFrom, this.prmtMaterialTo, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtSaleGroupFrom, this.prmtSaleGroupTo, this.prmtSalePersonFrom, this.prmtSalePersonFrom, this.prmtDeptFrom, this.prmtDeptTo});
        CheckRadioFilterElement e2 = new CheckRadioFilterElement("isCkBxAssistProperty", (Component)this.ckBxAssistProperty);
        e2.setDefaultValue((Object)new Boolean(false));
        element = new SingleFilterElement("isNotIncludeDebit", (Component)this.chkNotIncludeDebit);
        elements.add((FilterElement)element);
        elements.add((FilterElement)e2);
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                SaleIncomDetailConditionUI.this.orgsChanged(SaleIncomDetailConditionUI.this.f7, SaleIncomDetailConditionUI.this.f7Manager);
            }
        });
    }

    public boolean verify() {
        Object[] org;
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.datePickerStart.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.datePickerEnd.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.datePickerStart.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.datePickerEnd.requestFocus();
            return false;
        }
        if (this.prmtOrgUnit.getValue() == null || ((Object[])this.prmtOrgUnit.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtOrgUnit.getValue()).length == 1 && ((org = (Object[])this.prmtOrgUnit.getValue())[0] == null || org[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtOrgUnit;
    }

    protected String getViewPermission() {
        String viewPermission = "SaleIncomDetailUI_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public void clear() {
        super.clear();
        this.prmtCompanyOrgUnit.setValue(null);
        this.prmtStorageOrgUnit.setValue(null);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtSaleGroupFrom.setValue(null);
        this.prmtSaleGroupTo.setValue(null);
        this.prmtSalePersonFrom.setValue(null);
        this.prmtSalePersonTo.setValue(null);
        this.prmtDeptFrom.setValue(null);
        this.prmtDeptTo.setValue(null);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.ckBxAssistProperty.setSelected(false);
        this.chkIsBizBill.setSelected(false);
        this.chrDispAllSum.setSelected(false);
        this.chrDispSum.setSelected(false);
        this.chkNotIncludeDebit.setSelected(false);
        this.chkDirectSale.setSelected(false);
        try {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
            if (company != null) {
                this.loadAccountPeriod(company);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.spinPeriodYear.setEnabled(false);
        this.spinPeriodYearTo.setEnabled(false);
        this.spinPeriodMonth.setEnabled(false);
        this.spinPeriodMonthTo.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleIncomDetailConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleIncomDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void addCkBxAssistPropertyListener() {
        this.ckBxAssistProperty.setVisible(false);
        this.ckBxAssistProperty.setEnabled(false);
        this.ckBxAssistProperty.setSelected(false);
        this.combOrderCol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleIncomDetailConditionUI.this.combOrderCol_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleIncomDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void addListener() {
        this.spinPeriodYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
                if (((KDSpinner)arg0.getSource()).equals(SaleIncomDetailConditionUI.this.spinPeriodYear)) {
                    SaleIncomDetailConditionUI.this.setPeriod(SaleIncomDetailConditionUI.this.spinPeriodYear, company);
                }
            }
        });
        this.spinPeriodYearTo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
                if (((KDSpinner)arg0.getSource()).equals(SaleIncomDetailConditionUI.this.spinPeriodYearTo)) {
                    SaleIncomDetailConditionUI.this.setPeriod(SaleIncomDetailConditionUI.this.spinPeriodYearTo, company);
                }
            }
        });
        this.combBillStatus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleIncomDetailConditionUI.this.combBillStatus_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleIncomDetailConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    protected void combOrderCol_itemStateChanged(ItemEvent e) throws Exception {
        if (this.combOrderCol.getShowSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"37_SaleIncomDetailConditionUI"))) {
            this.ckBxAssistProperty.setVisible(true);
            this.ckBxAssistProperty.setEnabled(true);
        } else {
            this.ckBxAssistProperty.setVisible(false);
            this.ckBxAssistProperty.setEnabled(false);
            this.ckBxAssistProperty.setSelected(false);
        }
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }

    public void setDepartF7filter() throws Exception {
        OrgUnitCollection collection = null;
        collection = this.getAuthOrgByPermItem(SysContext.getSysContext(), OrgType.Admin, "SaleIncomDetailUI_view");
        if (collection == null || collection.size() == 0) {
            return;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo = SCMClientUtils.getAdminF7OUFilter();
        FilterInfo filter = null;
        filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        this.prmtDeptFrom.setEntityViewInfo(viewInfo);
        this.prmtDeptTo.setEntityViewInfo(viewInfo);
    }

    public OrgUnitCollection getAuthOrgByPermItem(SysContext sysContext, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getRemoteInstance();
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        ObjectUuidPK userPK = new ObjectUuidPK(sysContext.getCurrentUserInfo().getId().toString());
        FullOrgUnitCollection result = permission.getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    protected void combBillStatus_itemStateChanged(ItemEvent e) throws Exception {
        Object selectedItem = this.combBillStatus.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (selectedItem.equals((Object)SaleReportBillStatusEnum.all)) {
            this.spinPeriodYear.setEnabled(false);
            this.spinPeriodYearTo.setEnabled(false);
            this.spinPeriodMonth.setEnabled(false);
            this.spinPeriodMonthTo.setEnabled(false);
            this.datePickerStart.setEnabled(true);
            this.datePickerEnd.setEnabled(true);
        } else {
            this.spinPeriodYear.setEnabled(true);
            this.spinPeriodYearTo.setEnabled(true);
            this.spinPeriodMonth.setEnabled(true);
            this.spinPeriodMonthTo.setEnabled(true);
            this.datePickerStart.setEnabled(false);
            this.datePickerEnd.setEnabled(false);
        }
    }

    private void setPeriod(KDSpinner periodYear, CompanyOrgUnitInfo companyInfo) {
        try {
            if (periodYear.getValue() != null) {
                KDSpinner kdspinner = this.spinPeriodMonth;
                if (periodYear.equals(this.spinPeriodYearTo)) {
                    kdspinner = this.spinPeriodMonthTo;
                }
                int year = (Integer)periodYear.getValue();
                PeriodInfo curPeriodInfo = null;
                PeriodInfo startPeriodInfo = null;
                int minMonth = 1;
                int maxMonth = 12;
                if (companyInfo != null) {
                    if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                        WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                        curPeriodInfo = info.getCurPeriodInfo();
                        startPeriodInfo = info.getStartPeriodInfo();
                        minMonth = info.getMinMonth();
                        maxMonth = info.getMaxMonth();
                    } else {
                        curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                        minMonth = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                        maxMonth = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
                    }
                    if (minMonth == 0) {
                        minMonth = 1;
                    }
                    if (maxMonth == 0) {
                        maxMonth = 12;
                    }
                }
                if (startPeriodInfo != null && year == startPeriodInfo.getPeriodYear()) {
                    minMonth = startPeriodInfo.getPeriodNumber();
                }
                this.setSpinnerMaxMin((JSpinner)kdspinner, minMonth, maxMonth);
                if (curPeriodInfo != null) {
                    kdspinner.setValue((Object)new Integer(curPeriodInfo.getPeriodNumber()));
                }
                if (kdspinner.getIntegerVlaue() < minMonth) {
                    kdspinner.setValue((Object)new Integer(minMonth));
                }
                if (kdspinner.getIntegerVlaue() > maxMonth) {
                    kdspinner.setValue((Object)new Integer(maxMonth));
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    private void loadAccountPeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo = null;
        int minYear = 0;
        int maxYear = 0;
        if (companyInfo != null) {
            if (this.periodMap.containsKey(companyInfo.getId().toString())) {
                WriteOffPeriodInfo info = (WriteOffPeriodInfo)this.periodMap.get(companyInfo.getId().toString());
                curPeriodInfo = info.getCurPeriodInfo();
                minYear = info.getMinYear();
                maxYear = info.getMaxYear();
            } else {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                minYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)false);
                maxYear = PeriodUtils.getMaxOrMinPeriodYear(null, (String)companyInfo.getId().toString(), (boolean)true);
            }
        }
        this.setSpinnerMaxMin((JSpinner)this.spinPeriodYear, minYear, maxYear);
        this.setSpinnerMaxMin((JSpinner)this.spinPeriodYearTo, minYear, maxYear);
        if (curPeriodInfo != null) {
            this.spinPeriodYear.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.spinPeriodYearTo.setValue((Object)new Integer(curPeriodInfo.getPeriodYear()));
            this.setPeriod(this.spinPeriodYear, companyInfo);
            this.setPeriod(this.spinPeriodYearTo, companyInfo);
        } else {
            Calendar ca = Calendar.getInstance();
            this.spinPeriodYear.setValue((Object)new Integer(ca.get(1)));
            this.spinPeriodYearTo.setValue((Object)new Integer(ca.get(1)));
            this.spinPeriodMonth.setValue((Object)new Integer(ca.get(2) + 1));
            this.spinPeriodMonthTo.setValue((Object)new Integer(ca.get(2) + 1));
        }
    }
}

