/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.IVirtualRptBaseFacade;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.client.VirtualRptBaseUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.SaleOrderTrackRptFacadeFactory;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleOrderTrackRptUI;
import com.kingdee.eas.scm.sd.sale.report.client.SaleOrderTrackRptConditionUI;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleOrderTrackRptUI
extends AbstractSaleOrderTrackRptUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleOrderTrackRptUI.class);
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    RptParams pp = new RptParams();
    private boolean firstLoadData = true;
    private String orgTempTable;
    private CustomerQueryPanel userPanel = null;
    private CommonQueryDialog queryDialog = new CommonQueryDialog();

    public SaleOrderTrackRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.setEnabled(false);
        this.prmtDateRange.setEnabled(false);
        this.prmtCustomerRange.setEnabled(false);
        this.prmtSaleOrg.setEnabled(false);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        this.insertRowCount = 0;
        super.actionQuery_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionChart_actionPerformed(ActionEvent e) throws Exception {
        super.actionChart_actionPerformed(e);
    }

    @Override
    public void actionOrderQuerySetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionOrderQuerySetup_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return SaleOrderTrackRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new SaleOrderTrackRptConditionUI();
    }

    protected void query() {
        String customerRange;
        String customerFrom;
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        super.query();
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bd = this.params.getString("dateStart");
        String ed = this.params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        java.util.Date beginDate = tempBDCalendar.getTime();
        java.util.Date endDate = tempEDCalendar.getTime();
        DateFormat format = BOSLocaleUtil.getDateFormat();
        this.prmtDateRange.setText(format.format(beginDate) + "-" + format.format(endDate));
        StringBuffer saleOrgUnitbf = new StringBuffer();
        Object[] saleOrgUnit = (Object[])this.params.getObject("fullOrgUnit");
        int n = saleOrgUnit.length;
        for (int i = 0; i < n; ++i) {
            saleOrgUnitbf.append((String)((FullOrgUnitInfo)saleOrgUnit[i]).get("name") + ";");
        }
        this.params.setString("OrgUnitFilter", saleOrgUnitbf.toString());
        this.prmtSaleOrg.setText(saleOrgUnitbf.toString());
        if (this.pp.getObject("CustomerFrom") != null) {
            if (this.pp.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])this.pp.getObject("CustomerFrom");
                StringBuffer nums = new StringBuffer();
                for (int i = 0; i < customers.length; ++i) {
                    nums.append(((CustomerInfo)customers[i]).getNumber()).append(";");
                }
                customerFrom = nums.substring(0, nums.length() - 1);
            } else {
                customerFrom = this.pp.getObject("CustomerFrom") instanceof CustomerInfo ? ((CustomerInfo)this.pp.getObject("CustomerFrom")).getNumber() : this.pp.getObject("CustomerFrom").toString();
            }
        } else {
            customerFrom = "";
        }
        String customerTo = this.pp.getObject("CustomerTo") != null ? this.pp.getObject("CustomerTo").toString() : "";
        if (customerFrom.length() > 1 && customerTo.length() > 1) {
            this.prmtCustomerRange.setText(customerFrom + "_" + customerTo);
            customerRange = customerFrom + "_" + customerTo;
        } else {
            this.prmtCustomerRange.setText(customerFrom + customerTo);
            customerRange = customerFrom + customerTo;
        }
        this.pp.setString("CustomerRange", customerRange);
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        this.tblMain.getMergeManager().setMergeMode(0);
        RptParams rpt = null;
        try {
            if (from == 0 && this.firstLoadData) {
                try {
                    int QTY_PRECISION;
                    int AMOUNT_PRECISION;
                    int TOTALFLAG;
                    int MATERIAL_FID;
                    int SALEORG_FID;
                    this.pp.clear();
                    this.pp.putAll(this.params.toMap());
                    rpt = SaleOrderTrackRptFacadeFactory.getRemoteInstance().createTempTable(this.handleRptParams());
                    this.setTempTable(rpt.getString("tempTable"));
                    RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                    this.pp.setString("tempTable", rpt.getString("tempTable"));
                    this.orgTempTable = rpt.getString("OrgTempTable");
                    this.pp.setString("OrgTempTable", this.orgTempTable);
                    KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                    this.tblMain.setRowCount(rpt.getInt("verticalCount"));
                    if (this.params.getBoolean("IsOutWarehs")) {
                        int freezeCol1 = this.tblMain.getColumnIndex("TOTAL_AMOUNT");
                        if (freezeCol1 != -1) {
                            this.tblMain.getColumn(freezeCol1).getStyleAttributes().setHided(false);
                        }
                    } else {
                        int TOTALNOTICE_QTY = this.tblMain.getColumnIndex("TOTALNOTICE_QTY");
                        if (TOTALNOTICE_QTY != -1) {
                            this.tblMain.getColumn(TOTALNOTICE_QTY).getStyleAttributes().setHided(false);
                        }
                    }
                    int freezeCol2 = this.tblMain.getColumnIndex("NOINWAREHS_QTY");
                    if (freezeCol2 != -1) {
                        this.tblMain.getColumn(freezeCol2).getStyleAttributes().setHided(false);
                    }
                    if ((SALEORG_FID = this.tblMain.getColumnIndex("SALEORG_FID")) != -1) {
                        this.tblMain.getColumn(SALEORG_FID).getStyleAttributes().setHided(true);
                    }
                    if ((MATERIAL_FID = this.tblMain.getColumnIndex("MATERIAL_FID")) != -1) {
                        this.tblMain.getColumn(MATERIAL_FID).getStyleAttributes().setHided(true);
                    }
                    if ((TOTALFLAG = this.tblMain.getColumnIndex("TOTALFLAG")) != -1) {
                        this.tblMain.getColumn(TOTALFLAG).getStyleAttributes().setHided(true);
                    }
                    if ((AMOUNT_PRECISION = this.tblMain.getColumnIndex("AMOUNT_PRECISION")) != -1) {
                        this.tblMain.getColumn(AMOUNT_PRECISION).getStyleAttributes().setHided(true);
                    }
                    if ((QTY_PRECISION = this.tblMain.getColumnIndex("QTY_PRECISION")) != -1) {
                        this.tblMain.getColumn(QTY_PRECISION).getStyleAttributes().setHided(true);
                    }
                    int freezeCol = this.tblMain.getColumnIndex("MATERIAL_NUMBER");
                    this.tblMain.getViewManager().setFreezeView(-1, freezeCol + 1);
                    if (this.tHelper != null) {
                        this.tHelper.setDefaultUserData(null);
                    }
                    this.initUserConfig();
                    rpt = SaleOrderTrackRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                    RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                    this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    this.handUIExceptionAndAbort(ex);
                }
            } else {
                rpt = SaleOrderTrackRptFacadeFactory.getRemoteInstance().query(this.pp, from, len);
                RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
                this.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), 0);
            }
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            this.abort();
        }
        if (from == 0 && this.firstLoadData) {
            this.firstLoadData = false;
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private RptParams handleRptParams() {
        int i;
        String[] numbers;
        RptParams rptParams = new RptParams();
        rptParams.putAll(this.pp.toMap());
        if (this.pp.getObject("CustomerFrom") != null && this.pp.getObject("CustomerFrom") instanceof Object[]) {
            Object[] customers = (Object[])this.pp.getObject("CustomerFrom");
            numbers = new String[customers.length];
            for (i = 0; i < customers.length; ++i) {
                numbers[i] = ((CustomerInfo)customers[i]).getNumber();
            }
            rptParams.setObject("CustomerFrom", (Object)numbers);
        }
        if (this.pp.getObject("materialFrom") != null && this.pp.getObject("materialFrom") instanceof Object[]) {
            Object[] materials = (Object[])this.pp.getObject("materialFrom");
            numbers = new String[materials.length];
            for (i = 0; i < materials.length; ++i) {
                numbers[i] = ((MaterialInfo)materials[i]).getNumber();
            }
            rptParams.setObject("materialFrom", (Object)numbers);
        }
        return rptParams;
    }

    protected void getAllDataOfId() {
        GetIdThread getAllIdThread = new GetIdThread(this);
        getAllIdThread.setDaemon(true);
        getAllIdThread.start();
        java.util.Date nowEnd = new java.util.Date();
        logger.debug((Object)("getAllDataOfId end at : " + nowEnd));
    }

    protected IVirtualRptBaseFacade getVirtualRemoteInstance() throws BOSException {
        return SaleOrderTrackRptFacadeFactory.getRemoteInstance();
    }

    public void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler, int insertRowCount) {
        table.setRefresh(false);
        int rowIndex = insertRowIndex + insertRowCount;
        Object[] rowData = null;
        while (rs.next()) {
            Object dateObject;
            IRow row = this.isExpand ? table.addRow(rowIndex++) : table.setRow(rowIndex++);
            if (rs.getInt("FBASESTATUS") == 4) {
                rs.setValue("FBASESTATUS", (Object)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"41_SaleOrderTrackRptUI"));
            } else if (rs.getInt("FBASESTATUS") == 6) {
                rs.setValue("FBASESTATUS", (Object)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"54_SaleOrderTrackRptUI"));
            } else if (rs.getInt("FBASESTATUS") == 7) {
                rs.setValue("FBASESTATUS", (Object)EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"55_SaleOrderTrackRptUI"));
            }
            boolean isTotalRow = false;
            if (rs.getString("TOTALFLAG") != null && rs.getString("TOTALFLAG").equals("TotalAll")) {
                rs.setValue("BILLNUMBER", (Object)EASResource.getString((String)resClassName, (String)"SUB_STRING"));
                rs.setValue("FBASESTATUS", (Object)"");
                rs.setValue("MATERIAL_NUMBER", (Object)"");
                rs.setValue("MATERIAL_NAME", (Object)"");
                rs.setValue("MATERIAL_MODEL", (Object)"");
                this.setTotalColColor(row);
                isTotalRow = true;
            }
            if ((dateObject = rs.getObject("FDeliveryDate")) != null && dateObject instanceof Timestamp) {
                Date d = new Date(((Timestamp)dateObject).getTime());
                rs.setValue("FDeliveryDate", (Object)d);
            }
            if (!isTotalRow) {
                int amountPresicion = rs.getInt("AMOUNT_PRECISION");
                int qtyPresicion = rs.getInt("QTY_PRECISION");
                String amountFormat = SaleUtil.getFormatPattern(amountPresicion, true);
                String qtyFormat = SaleUtil.getFormatPattern(qtyPresicion, true);
                row.getCell("ORDER_AMOUT").getStyleAttributes().setNumberFormat(amountFormat);
                if (this.pp.getBoolean("IsOutWarehs")) {
                    row.getCell("TOTAL_AMOUNT").getStyleAttributes().setNumberFormat(amountFormat);
                } else {
                    row.getCell("TOTALNOTICE_QTY").getStyleAttributes().setNumberFormat(qtyFormat);
                }
                row.getCell("NOINWAREHS_AMOUNT").getStyleAttributes().setNumberFormat(amountFormat);
                row.getCell("ORDER_QTY").getStyleAttributes().setNumberFormat(qtyFormat);
                row.getCell("TOTALRECEIVE_QTY").getStyleAttributes().setNumberFormat(qtyFormat);
                row.getCell("NOINWAREHS_QTY").getStyleAttributes().setNumberFormat(qtyFormat);
                rs.setValue("TAXMOUNT", (Object)rs.getBigDecimal("TAXMOUNT").setScale(amountPresicion, 4));
                rs.setValue("FTOTAL_AMOUNT", (Object)rs.getBigDecimal("FTOTAL_AMOUNT").setScale(amountPresicion, 4));
                rs.setValue("NONAMOUNT", (Object)rs.getBigDecimal("NONAMOUNT").setScale(amountPresicion, 4));
                rs.setValue("QTY", (Object)rs.getBigDecimal("QTY").setScale(qtyPresicion, 4));
                rs.setValue("TOTALRECEIVE_QTY", (Object)rs.getBigDecimal("TOTALRECEIVE_QTY").setScale(qtyPresicion, 4));
                rs.setValue("NONWAREHS_QTY", (Object)rs.getBigDecimal("NONWAREHS_QTY").setScale(qtyPresicion, 4));
            }
            rowData = SCMRptUtil.sortRowData((Object[])rs.toRowArray(), (CoreUI)this, (KDTable)table, (ITablePreferenceHelper)this.tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"MATERIAL_NUMBER", "MATERIAL_NAME", "MATERIAL_MODEL", "MATERIALGROUP_NAME", "UNIT_NAME"};
        return strMergeColKeys;
    }

    private void setTotalColColor(IRow row) {
        Color necessaryColor = new Color(252, 251, 223);
        row.getStyleAttributes().setBackground(necessaryColor);
    }

    public String getTreeCol() {
        return "SALEORG_NAME";
    }

    public void beforePrint() {
        this.logUIOperation("LOG_REPORT4");
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)resClassName, (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new MaterialInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected KDTable getTable() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)resClassName, (String)"Date"));
        sb.append(" &[Period]");
        sb.append("&|");
        sb.append(EASResource.getString((String)resClassName, (String)"CustomerName"));
        sb.append(" : &[CustomerRange]");
        sb.append("&|");
        sb.append(EASResource.getString((String)resClassName, (String)"SaleOrg"));
        sb.append(" : &[SaleOrg]");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Period", this.prmtDateRange.getText());
        map.put("CustomerRange", this.prmtCustomerRange.getText());
        map.put("SaleOrg", this.prmtSaleOrg.getText());
        return map;
    }

    protected boolean isLoadPrintSetting() {
        return false;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    public void beforePreview() {
        super.beforePreview();
    }

    public void beforePrintOrPreview() {
        super.beforePrintOrPreview();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setMaxReturnCountVisible(false);
            this.queryDialog.setWidth(494);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sd.sale.report.client.SaleOrderTrackRptUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    class GetIdThread
    extends Thread {
        VirtualRptBaseUI baseUi;

        public GetIdThread(VirtualRptBaseUI baseUI) {
            this.baseUi = baseUI;
        }

        @Override
        public void run() {
            try {
                SaleOrderTrackRptUI.this.allIdList = new ArrayList();
                if (SaleOrderTrackRptUI.this.getTempTable() != null) {
                    IVirtualRptBaseFacade report = SaleOrderTrackRptUI.this.getVirtualRemoteInstance();
                    IRowSet result = report.getIdList(SaleOrderTrackRptUI.this.pp);
                    while (result.next()) {
                        SaleOrderTrackRptUI.this.allIdList.add(result.getString("FId"));
                    }
                }
                SaleOrderTrackRptUI.this.getTable().setRowCount(SaleOrderTrackRptUI.this.allIdList.size());
                SaleOrderTrackRptUI.this.setButtonEnabled(true);
            }
            catch (Exception ex) {
                SaleOrderTrackRptUI.this.setButtonEnabled(true);
                this.baseUi.handUIExceptionAndAbort(ex);
            }
        }
    }
}

