/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CheckRadioFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiF7FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleReportBizTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleReportOrderByEnum;
import com.kingdee.eas.scm.sd.sale.SaleReportSourceBillForSaleTopListEnum;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleTopListConditionUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SaleTopListConditionUI
extends AbstractSaleTopListConditionUI {
    private SCMRptMultiOrgsF7 f7;
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private ItemListener combSourceBillListener;
    private DataChangeListener saleOrgListener;
    private ItemListener combOrderByListener;

    public SaleTopListConditionUI() throws Exception {
        this.setSize(560, 424);
        this.initInterface();
        this.isReport = true;
        this.addCkBxSimpleNameListener();
        this.f7 = new SCMRptMultiOrgsF7(this.prmtSaleOrgUnitFrom, OrgType.Sale, EASResource.getString((String)resClassName, (String)"saleOrgUnitMutilF7"));
        this.f7.setPermItemName(this.getViewPermission());
        this.f7.setUseCache(true);
        this.f7.setNeedWait4UIOpen(false);
        this.prmtCompanyOrgUnit.setEnabledMultiSelection(true);
        this.setBizMaterialF7(this.prmtMaterialFrom, true, null);
        this.setBizMaterialF7(this.prmtMaterialTo, false, null);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtMaterialFrom, (KDBizPromptBox)this.prmtMaterialTo);
        this.prmtCustomerFrom.setDisplayFormat("$name$");
        this.prmtCustomerTo.setDisplayFormat("$name$");
        this.setBizCustomerF7(this.prmtCustomerFrom, null, true);
        this.setBizCustomerF7(this.prmtCustomerTo, null, false);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtCustomerFrom, (KDBizPromptBox)this.prmtCustomerTo);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("dateStart", (Component)this.kdpFrom);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("dateEnd", (Component)this.kdpTo);
        element.setDefaultValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiF7FilterElement mutilElement = new MultiF7FilterElement("materialFrom", this.prmtMaterialFrom, Boolean.valueOf(false));
        elements.add((FilterElement)mutilElement);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMaterialTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameFrom", (Component)this.txtMShortNameFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("shortNameTo", (Component)this.txtMShortNameTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        CheckRadioFilterElement el = new CheckRadioFilterElement("ckBxShowMShortName", (Component)this.ckBxShowMShortName);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        el = new CheckRadioFilterElement("isShowSum", (Component)this.ckbxShowSum);
        el.setDefaultValue((Object)new Boolean(false));
        elements.add((FilterElement)el);
        element = new SingleFilterElement("materialGroupFrom", (Component)this.prmtMaterialGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialGroupTo", (Component)this.prmtMaterialGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        mutilElement = new MultiF7FilterElement("customerFrom", this.prmtCustomerFrom, Boolean.valueOf(false));
        elements.add((FilterElement)mutilElement);
        element = new SingleFilterElement("customerTo", (Component)this.prmtCustomerTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("customerGroupFrom", (Component)this.prmtCustomerGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("customerGroupTo", (Component)this.prmtCustomerGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MultiOrgsFilterElement mainOrgElement = new MultiOrgsFilterElement("fullCompanyOrgUnit", this.f7, this.prmtSaleOrgUnitFrom);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull")));
        elements.add((FilterElement)mainOrgElement);
        element = new SingleFilterElement("companyOrgUnit.number", (Component)this.prmtCompanyOrgUnit);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("saleGroupFrom", (Component)this.prmtSaleGroupFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("saleGroupTo", (Component)this.prmtSaleGroupTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.prmtSalePersonFrom.setEnabledMultiSelection(true);
        this.prmtSalePersonFrom.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        this.prmtSalePersonTo.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7SalePersonQuery");
        SCMClientUtils.setSalePersonDisplayMulti((KDBizPromptBox)this.prmtSalePersonFrom);
        SCMClientUtils.setSalePersonDisplay((KDBizPromptBox)this.prmtSalePersonTo);
        SCMClientUtils.addListenerForMultiF7((KDBizPromptBox)this.prmtSalePersonFrom, (KDBizPromptBox)this.prmtSalePersonTo);
        mutilElement = new MultiF7FilterElement("salePersonFrom", this.prmtSalePersonFrom, Boolean.valueOf(false));
        elements.add((FilterElement)mutilElement);
        element = new SingleFilterElement("salePersonTo", (Component)this.prmtSalePersonTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("sourceBill", (Component)this.combSourceBill);
        element.setDefaultValue((Object)SaleReportSourceBillForSaleTopListEnum.saleOrder);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("orderStatus", (Component)this.combStatus);
        element.setDefaultValue((Object)SaleReportBillStatusEnum.all);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("orderBillType", (Component)this.combBizType);
        element.setDefaultValue((Object)SaleReportBizTypeEnum.all);
        elements.add((FilterElement)element);
        CheckRadioFilterElement chrElement = new CheckRadioFilterElement("seq", (Component)this.dRbtn);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        chrElement = new CheckRadioFilterElement("seq", (Component)this.dRbtnConverse);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)chrElement);
        this.txtSeq.setNegatived(false);
        element = new SingleFilterElement("totalNumSeq", (Component)this.txtSeq);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        this.txtConverse.setNegatived(false);
        element = new SingleFilterElement("totalNumConverse", (Component)this.txtConverse);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("orderBy", (Component)this.combOrderBy);
        element.setDefaultValue((Object)SaleReportOrderByEnum.material);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("containInvoice", (Component)this.chkContainInvoice);
        element.setDefaultValue((Object)Boolean.FALSE);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtSaleGroupFrom, this.prmtSaleGroupTo, this.prmtCustomerFrom, this.prmtCustomerTo, this.prmtMaterialFrom, this.prmtMaterialTo});
        if (this.combSourceBillListener == null) {
            this.combSourceBillListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        SaleTopListConditionUI.this.combSourceBill_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        SaleTopListConditionUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.combSourceBill.addItemListener(this.combSourceBillListener);
        if (this.saleOrgListener == null) {
            this.saleOrgListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    SaleTopListConditionUI.this.orgsChanged(SaleTopListConditionUI.this.f7, SaleTopListConditionUI.this.f7Manager);
                }
            };
        }
        this.prmtSaleOrgUnitFrom.addDataChangeListener(this.saleOrgListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
        HashSet setDestSouID = new HashSet();
        Map viewPermission = PermissionFactory.getRemoteInstance().getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD"), null, null);
        Iterator iter = viewPermission.keySet().iterator();
        while (iter.hasNext()) {
            setDestSouID.add(iter.next());
        }
        EntityViewInfo viewCou = new EntityViewInfo();
        FilterInfo filterCou = new FilterInfo();
        filterCou.getFilterItems().add(new FilterItemInfo("id", setDestSouID, CompareType.INCLUDE));
        viewCou.setFilter(filterCou);
        this.prmtCompanyOrgUnit.setEntityViewInfo(viewCou);
        if (this.combStatus.getItemCount() == 4) {
            this.combStatus.removeItemAt(this.combStatus.getItemCount() - 1);
        }
    }

    private void combSourceBill_itemStateChanged(ItemEvent e) {
        Object selectedItem = this.combSourceBill.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        SaleReportSourceBillForSaleTopListEnum fromBill = (SaleReportSourceBillForSaleTopListEnum)((Object)selectedItem);
        if (fromBill.equals((Object)SaleReportSourceBillForSaleTopListEnum.arOtherBill)) {
            this.chkContainInvoice.setVisible(true);
        } else {
            this.chkContainInvoice.setVisible(false);
        }
    }

    @Override
    public void loadFields() {
        if (this.combOrderByListener != null) {
            this.combOrderBy.removeItemListener(this.combOrderByListener);
        }
        if (this.combOrderByListener == null) {
            this.combOrderByListener = new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    block6: {
                        try {
                            Object selectedItem = SaleTopListConditionUI.this.combOrderBy.getSelectedItem();
                            if (selectedItem == null) {
                                return;
                            }
                            SaleReportOrderByEnum orderBy = (SaleReportOrderByEnum)((Object)selectedItem);
                            if (!orderBy.equals((Object)SaleReportOrderByEnum.material)) {
                                SaleTopListConditionUI.this.ckBxShowMShortName.setEnabled(false);
                                SaleTopListConditionUI.this.ckBxShowMShortName.setSelected(false);
                                break block6;
                            }
                            SaleTopListConditionUI.this.ckBxShowMShortName.setEnabled(true);
                        }
                        catch (Exception exc) {
                            SaleTopListConditionUI.this.handUIException(exc);
                        }
                    }
                }
            };
        }
        this.combOrderBy.addItemListener(this.combOrderByListener);
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    private void initInterface() {
        this.txtConverse.setEnabled(false);
        this.prmtMaterialFrom.setEditable(true);
        this.prmtMaterialTo.setEditable(true);
        this.prmtMaterialGroupFrom.setEditable(true);
        this.prmtMaterialGroupTo.setEditable(true);
        this.prmtCustomerFrom.setEditable(true);
        this.prmtCustomerTo.setEditable(true);
        this.prmtCustomerGroupFrom.setEditable(true);
        this.prmtCustomerGroupTo.setEditable(true);
        this.prmtSaleOrgUnitFrom.setEditable(true);
        this.prmtSaleGroupFrom.setEditable(true);
        this.prmtSaleGroupTo.setEditable(true);
        this.prmtSalePersonFrom.setEditable(true);
        this.prmtSalePersonTo.setEditable(true);
        this.txtSeq.setMaximumNumber((Number)Integer.MAX_VALUE);
        this.txtSeq.setMinimumNumber((Number)0);
        this.txtConverse.setMaximumNumber((Number)Integer.MAX_VALUE);
        this.txtConverse.setMinimumNumber((Number)0);
    }

    @Override
    protected void dRbtn_itemStateChanged(ItemEvent e) throws Exception {
        this.txtConverse.setText(null);
        this.txtConverse.setEnabled(false);
        this.txtSeq.setEnabled(true);
    }

    @Override
    protected void dRbtnConverse_itemStateChanged(ItemEvent e) throws Exception {
        this.txtSeq.setText(null);
        this.txtSeq.setEnabled(false);
        this.txtConverse.setEnabled(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSaleOrgUnitFrom;
    }

    protected String getViewPermission() {
        String viewPermission = "saleTopList_view";
        return viewPermission;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public void clear() {
        super.clear();
        this.prmtCompanyOrgUnit.setValue(null);
        this.prmtMaterialFrom.setValue(null);
        this.prmtMaterialTo.setValue(null);
        this.prmtMaterialGroupFrom.setValue(null);
        this.prmtMaterialGroupTo.setValue(null);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
        this.prmtCustomerGroupFrom.setValue(null);
        this.prmtCustomerGroupTo.setValue(null);
        this.prmtSaleGroupFrom.setValue(null);
        this.prmtSaleGroupTo.setValue(null);
        this.prmtSalePersonFrom.setValue(null);
        this.prmtSalePersonTo.setValue(null);
        SCMQueryFormat.formatStartTime((KDDatePicker)this.kdpFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.kdpTo);
        this.ckBxShowMShortName.setSelected(false);
        this.ckbxShowSum.setSelected(false);
        this.txtMShortNameFrom.setText(null);
        this.txtMShortNameTo.setText(null);
        this.chkContainInvoice.setVisible(false);
        this.dRbtn.setSelected(true);
    }

    public boolean verify() {
        Object[] purchaseOrg;
        if (this.prmtSaleOrgUnitFrom.getValue() == null || ((Object[])this.prmtSaleOrgUnitFrom.getValue()).length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        if (((Object[])this.prmtSaleOrgUnitFrom.getValue()).length == 1 && ((purchaseOrg = (Object[])this.prmtSaleOrgUnitFrom.getValue())[0] == null || purchaseOrg[0].toString() == null)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SaleOrgUnitNotNull"));
            return false;
        }
        Timestamp dateFrom = SCMUtils.getDayStartTime((Date)((Date)this.kdpFrom.getValue()));
        Timestamp dateTo = SCMUtils.getDayEndTime((Date)((Date)this.kdpTo.getValue()));
        if (dateFrom == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"STARTDATE_NOT_NULL"));
            this.kdpFrom.requestFocus();
            return false;
        }
        if (dateTo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_DATE_NULL"));
            this.kdpTo.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.kdpTo.requestFocus();
            return false;
        }
        if (((Date)dateTo).getTime() < ((Date)dateFrom).getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"END_LATE_NOW"));
            this.kdpTo.requestFocus();
            return false;
        }
        Object[] saleOrgs = (Object[])this.prmtSaleOrgUnitFrom.getValue();
        try {
            if (!this.checkSaleCurrency(saleOrgs)) {
                return false;
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return true;
    }

    private boolean checkSaleCurrency(Object[] saleOrgs) throws BOSException {
        if (saleOrgs.length == 0) {
            return true;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select toUnit.id where fromUnit.id in (");
        int size = saleOrgs.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            oql.append("'").append(((OrgUnitInfo)saleOrgs[i]).getId().toString()).append("'");
        }
        oql.append(") ").append("and typeRelation.fromType = '").append(2).append("' ").append("and typeRelation.toType = '").append(1).append("' ");
        OrgUnitRelationCollection orgRelColl = iOrgRelation.getOrgUnitRelationCollection(oql.toString());
        if (orgRelColl.size() == 0) {
            return true;
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        oql = new StringBuffer();
        oql.append("select  id,name,number,baseCurrency.id,isLeaf where id in (");
        int size2 = orgRelColl.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                oql.append(",");
            }
            FullOrgUnitInfo toOrgUnit = orgRelColl.get(i).getToUnit();
            oql.append("'").append(toOrgUnit.getId().toString()).append("'");
        }
        oql.append(")");
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        CompanyOrgUnitInfo firstCompanyOrgInfo = null;
        int size3 = companyColl.size();
        for (int i = 0; i < size3; ++i) {
            CompanyOrgUnitInfo companyOrgInfo = companyColl.get(i);
            if (!companyOrgInfo.isIsLeaf()) continue;
            if (firstCompanyOrgInfo == null) {
                firstCompanyOrgInfo = companyOrgInfo;
            }
            if (firstCompanyOrgInfo.getBaseCurrency().getId().toString().equals(companyOrgInfo.getBaseCurrency().getId().toString())) continue;
            MsgBox.showError((String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.im.rpt.IMRptResource", (String)"DIFF_COMORG_CUR", (String[])new String[]{firstCompanyOrgInfo.getName(), companyOrgInfo.getName()}));
            return false;
        }
        return true;
    }

    protected void addCkBxSimpleNameListener() {
        this.ckBxShowMShortName.setVisible(true);
        this.txtMShortNameFrom.setVisible(true);
        this.txtMShortNameTo.setVisible(true);
        this.ckBxShowMShortName.setSelected(false);
        this.txtMShortNameFrom.setEnabled(false);
        this.txtMShortNameTo.setEnabled(false);
        this.ckBxShowMShortName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SaleTopListConditionUI.this.ckBxShowMShortName_itemStateChanged(e);
                }
                catch (Exception exc) {
                    SaleTopListConditionUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void ckBxShowMShortName_itemStateChanged(ItemEvent e) throws Exception {
        boolean isSelected = this.ckBxShowMShortName.isSelected();
        if (isSelected) {
            this.txtMShortNameFrom.setEnabled(true);
            this.txtMShortNameTo.setEnabled(true);
        } else {
            this.txtMShortNameFrom.setEnabled(false);
            this.txtMShortNameTo.setEnabled(false);
            this.txtMShortNameFrom.setText(null);
            this.txtMShortNameTo.setText(null);
        }
    }
}

