/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.client.SCMBillFilterUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReportOrderByEnum;
import com.kingdee.eas.scm.sd.sale.report.ISaleTopList;
import com.kingdee.eas.scm.sd.sale.report.SaleTopListFactory;
import com.kingdee.eas.scm.sd.sale.report.client.AbstractSaleTopListUI;
import com.kingdee.eas.scm.sd.sale.report.client.SaleTopListConditionUI;
import com.kingdee.eas.scm.util.SCMRptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleTopListUI
extends AbstractSaleTopListUI {
    private static final Logger logger = CoreUIObject.getLogger(SaleTopListUI.class);
    private static final int defaultCurrencyPercision = 4;
    int totalNum = 0;

    public SaleTopListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setExportMemoryCallback(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.tHelper != null) {
            this.tHelper.setCanMoveColumn(true);
        }
    }

    protected boolean enableTablePreferences() {
        return true;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initUserConfig();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.initUserConfig();
    }

    public void beforePrint() {
        this.logUIOperation("LOG_SALETOPLIST");
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    private void logUIOperation(String key) {
        String operName = EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.report.SDReportResource", (String)key);
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new SaleInvoiceInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return SaleTopListFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return null;
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        return new SaleTopListConditionUI();
    }

    protected void query() {
        this.totalNum = 0;
        if (this.params.getString("seq").equals("true")) {
            if (this.params.getString("totalNumConverse") != null && !this.params.getString("totalNumConverse").equals("")) {
                String tempValue = this.params.getString("totalNumConverse").toString().replaceAll(",", "");
                this.totalNum = Long.valueOf(tempValue).intValue();
            }
        } else if (this.params.getString("totalNumSeq") != null && !this.params.getString("totalNumSeq").equals("")) {
            String tempValue = this.params.getString("totalNumSeq").toString().replaceAll(",", "");
            this.totalNum = Long.valueOf(tempValue).intValue();
        }
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        this.initUserConfig();
    }

    public Object getTablePreferenceSchemaKey() {
        QuerySolutionInfo currentSolutionInfo;
        Object obj = super.getTablePreferenceSchemaKey();
        if (obj == null && (currentSolutionInfo = this.queryDialog.getCommonQueryParam().getCurrentSolutionInfo()) != null) {
            obj = currentSolutionInfo.getId();
        }
        return obj;
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            RptParams rpt;
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            if (from == 0) {
                pp.setString("tempTable", this.getTempTable());
                pp.putAll(this.params.toMap());
                rpt = SaleTopListFactory.getRemoteInstance().createTempTable(pp);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                int rowCount = rpt.getInt("verticalCount");
                if (this.totalNum > 0 && rowCount > this.totalNum) {
                    rowCount = this.totalNum;
                    len = this.totalNum;
                }
                this.tblMain.setRowCount(rowCount);
                if (this.tHelper != null) {
                    this.tHelper.setDefaultUserData(null);
                }
                this.initUserConfig();
            } else {
                pp.putAll(this.params.toMap());
            }
            pp.setString("tempTable", this.getTempTable());
            rpt = SaleTopListFactory.getRemoteInstance().query(pp, from, len);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            if (rs != null) {
                SCMRptUtil.insertRows((RptRowSet)rs, (int)from, (CoreUI)this, (KDTable)this.tblMain, (ITablePreferenceHelper)this.tHelper);
            }
            String curPrecision = PrecisionUtil.getFormatString((int)4);
            CompanyOrgUnitInfo companyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyOrgInfo != null && companyOrgInfo.getBaseCurrency() != null) {
                CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
                curPrecision = PrecisionUtil.getFormatString((int)baseCurrInfo.getPrecision());
            }
            int iOrderBy = new Integer(this.params.getString("orderBy"));
            SaleReportOrderByEnum orderByEnum = SaleReportOrderByEnum.getEnum(iOrderBy);
            this.tblMain.getStyleAttributes().setLocked(true);
            this.tblMain.getColumn("FNumber").setWidth(100);
            this.tblMain.getColumn("FName").setWidth(200);
            this.tblMain.getColumn("FSaleAmount").setWidth(100);
            if (orderByEnum.equals((Object)SaleReportOrderByEnum.material)) {
                this.tblMain.getColumn("FQty").setWidth(100);
                this.tblMain.getColumn("FQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn("FQtyPrecision").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("FPrice").setWidth(100);
                this.tblMain.getColumn("FPrice").getStyleAttributes().setNumberFormat(curPrecision);
                this.tblMain.getColumn("FPrice").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (!this.params.getBoolean("ckBxShowMShortName")) {
                    this.tblMain.getColumn("FShortName").getStyleAttributes().setHided(true);
                    this.tblMain.getColumn("FShortName").setWidth(-1);
                }
            }
            this.setQtyPrecision(this.tblMain, from, from + rs.getRowCount());
            this.tblMain.getColumn("FSaleAmount").getStyleAttributes().setNumberFormat(curPrecision);
            this.tblMain.getColumn("FSaleAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.appendFootRow(pp);
            if (from == 0 && orderByEnum.equals((Object)SaleReportOrderByEnum.material) && !this.params.getBoolean("ckBxShowMShortName")) {
                this.tblMain.getColumn("FShortName").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("FShortName").setWidth(-1);
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void setQtyPrecision(KDTable table, int fromRow, int toRow) {
        toRow = Math.min(table.getRowCount(), toRow);
        for (int row = fromRow; row < toRow; ++row) {
            int qtyPrecision = 4;
            String qtyPrecisionString = PrecisionUtil.getFormatString((int)qtyPrecision);
            table.getCell(row, "FQty").getStyleAttributes().setNumberFormat(qtyPrecisionString);
        }
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        CustomerParams cp = null;
        try {
            SCMBillFilterUI rbqp;
            this.initQueryDialog();
            this.userPanel.getUIContext().clear();
            this.userPanel.getUIContext().putAll(this.getUIContext());
            if (useDefaultSolution) {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.getQueryMetaDataPK()).getFullName();
                if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
                    QuerySolutionInfo solution = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
                    this.queryDialog.setCurrentSolutionInfo(solution);
                    QueryPanelInfo qpi = solution.getQueryPanelInfo().get(0);
                    if (qpi != null) {
                        try {
                            cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean ok = false;
            if ((cp == null || !useDefaultSolution) && this.queryDialog.show()) {
                rbqp = (SCMBillFilterUI)this.queryDialog.getUserPanel(0);
                this.params = rbqp.getCustomCondition();
                ok = true;
            }
            if (cp != null) {
                rbqp = (SCMBillFilterUI)this.getCustomerQueryPanel();
                rbqp.setCustomerParams(cp);
                rbqp.loadData(null);
                this.params = rbqp.getCustomCondition();
            }
            if (this.params != null && (ok || useDefaultSolution)) {
                this.queryWithWrap();
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void initQueryDialog() throws Exception {
        if (this.userPanel == null) {
            this.userPanel = this.getCustomerQueryPanel();
            this.userPanel.loadFields();
            Dimension dd = this.userPanel.getSize();
            this.queryDialog.setWidth(dd.width);
            this.queryDialog.setHeight(dd.height);
            this.queryDialog.addUserPanel((KDPanel)this.userPanel);
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setTitle(this.userPanel.getUITitle());
            this.queryDialog.setQueryObjectPK(this.getQueryMetaDataPK());
            this.queryDialog.setShowFilter(false);
            this.queryDialog.setShowSorter(false);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            Method m = this.userPanel.getClass().getMethod("onInit", RptParams.class);
            m.invoke((Object)this.userPanel, this.getUIContextInitParams());
            this.userPanel.initLayout();
            if (this.params != null) {
                this.userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)this.params));
            }
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
    }

    protected Map preparePrintVariantMap() {
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PURCHASINGMANAGEMENT;
    }

    protected String getUIFullName() {
        return "com.kingdee.eas.scm.sd.sale.report.client.SaleTopListUI";
    }

    public boolean isAsynchronism() {
        return true;
    }

    private void appendFootRow(RptParams pp) throws BOSException, EASBizException {
        boolean isShowSum = this.params.getBoolean("isShowSum");
        if (isShowSum) {
            IRow footRow = null;
            KDTFootManager footRowManager = this.tblMain.getFootManager();
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(this.tblMain);
                footRowManager.addFootView();
                this.tblMain.setFootManager(footRowManager);
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                this.tblMain.getIndexColumn().setWidth(30);
                footRowManager.addIndexText(0, total);
                footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            } else {
                footRow = footRowManager.getFootRow(0);
                if (footRow == null) {
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                }
            }
            RptRowSet sumRs = ((ISaleTopList)this.getRemoteInstance()).getSumRow(pp);
            footRow.getCell("FQty").setValue(sumRs.toArray("fqty")[0]);
            footRow.getCell("FSaleAmount").setValue(sumRs.toArray("fsaleamount")[0]);
        }
    }
}

