/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DateUtils {
    private static final Logger logger = Logger.getLogger(DateUtils.class);
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfhh = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Map getIntervalDate(Date fromDate, Date toDate) {
        try {
            fromDate = fromDate == null ? sdf.parse("1900-01-01") : fromDate;
            toDate = toDate == null ? new Date() : toDate;
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        Calendar calFrom = Calendar.getInstance();
        Calendar calTo = Calendar.getInstance();
        calFrom.setTime(fromDate);
        calTo.setTime(toDate);
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        if (DateUtils.isFirstDateOfYear(fromDate) && DateUtils.isEndDateOfYear(toDate)) {
            DateUtils.putDate(map, YEAR, list, fromDate, toDate);
        } else if (DateUtils.isFirstDateOfYear(fromDate) && !DateUtils.isEndDateOfYear(toDate)) {
            if (DateUtils.isEnoughYear(fromDate, toDate) < 1) {
                int months = calTo.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, toDate, months);
            } else {
                Date tempYear = DateUtils.getEndDatePreviousYear(toDate);
                DateUtils.putDate(map, YEAR, list, fromDate, tempYear);
                Date tempFromDay = DateUtils.getFirstDateCurYear(toDate);
                Calendar tempCal = Calendar.getInstance();
                tempCal.setTime(tempFromDay);
                int months = calTo.get(2) - tempCal.get(2);
                DateUtils.parseMonth(map, list, tempFromDay, toDate, months);
            }
        } else if (!DateUtils.isFirstDateOfYear(fromDate) && DateUtils.isEndDateOfYear(toDate)) {
            if (DateUtils.isEnoughYear(fromDate, toDate) < 1) {
                int months = calTo.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, toDate, months);
            } else {
                Date tempYear = DateUtils.getFirstDateNextYear(fromDate);
                DateUtils.putDate(map, YEAR, list, tempYear, toDate);
                Date tempToDay = DateUtils.getEndDateOfYear(fromDate);
                Calendar tempCal = Calendar.getInstance();
                tempCal.setTime(tempToDay);
                int months = tempCal.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, tempToDay, months);
            }
        } else if (!DateUtils.isFirstDateOfYear(fromDate) && !DateUtils.isEndDateOfYear(toDate)) {
            if (DateUtils.isEnoughYear(fromDate, toDate) < 1) {
                int months = calTo.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, toDate, months);
            } else if (DateUtils.isEnoughYear(fromDate, toDate) == 1) {
                Date fromEndYear = DateUtils.getEndDateOfYear(fromDate);
                Calendar tempCal = Calendar.getInstance();
                tempCal.setTime(fromEndYear);
                int months = tempCal.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, fromEndYear, months);
                Date toFirstYear = DateUtils.getFirstDateCurYear(toDate);
                tempCal.setTime(toFirstYear);
                months = calTo.get(2) - tempCal.get(2);
                DateUtils.parseMonth(map, list, toFirstYear, toDate, months);
            } else if (DateUtils.isEnoughYear(fromDate, toDate) > 1) {
                Date fromNextYear = DateUtils.getFirstDateNextYear(fromDate);
                Date toPreviousYear = DateUtils.getEndDatePreviousYear(toDate);
                DateUtils.putDate(map, YEAR, list, fromNextYear, toPreviousYear);
                Date fromEndYear = DateUtils.getEndDateOfYear(fromDate);
                Calendar tempCal = Calendar.getInstance();
                tempCal.setTime(fromEndYear);
                int months = tempCal.get(2) - calFrom.get(2);
                DateUtils.parseMonth(map, list, fromDate, fromEndYear, months);
                Date toFirstYear = DateUtils.getFirstDateCurYear(toDate);
                tempCal.setTime(toFirstYear);
                months = calTo.get(2) - tempCal.get(2);
                DateUtils.parseMonth(map, list, toFirstYear, toDate, months);
            }
        }
        return map;
    }

    private static void putDate(Map map, String key, List list, Date from, Date to) {
        Date[] dates = new Date[]{from, to};
        ArrayList tempList = null;
        tempList = map.get(key) == null ? new ArrayList() : (ArrayList)map.get(key);
        tempList.add(dates);
        map.put(key, tempList);
    }

    private static void parseMonth(Map map, List list, Date fromDate, Date toDate, int months) {
        if (months < 1) {
            DateUtils.putDate(map, DAY, list, fromDate, toDate);
        } else if (months == 1) {
            if (DateUtils.isFirstDateOfMonth(fromDate) && DateUtils.isEndDateOfMonth(toDate)) {
                DateUtils.putDate(map, MONTH, list, fromDate, toDate);
            } else if (DateUtils.isFirstDateOfMonth(fromDate) && !DateUtils.isEndDateOfMonth(toDate)) {
                Date tempPreviousMonth = DateUtils.getEndDatePreviousMonth(toDate);
                DateUtils.putDate(map, MONTH, list, fromDate, tempPreviousMonth);
                Date toFirstDate = DateUtils.getFirstDateCurMonth(toDate);
                DateUtils.putDate(map, DAY, list, toFirstDate, toDate);
            } else if (!DateUtils.isFirstDateOfMonth(fromDate) && DateUtils.isEndDateOfMonth(toDate)) {
                Date tempNextMonth = DateUtils.getFirstDateNextMonth(fromDate);
                DateUtils.putDate(map, MONTH, list, tempNextMonth, toDate);
                Date fromEndDate = DateUtils.getEndDateOfMonth(fromDate);
                DateUtils.putDate(map, DAY, list, fromDate, fromEndDate);
            } else {
                Date fromEndDate = DateUtils.getEndDateOfMonth(fromDate);
                DateUtils.putDate(map, DAY, list, fromDate, fromEndDate);
                Date toFirstDate = DateUtils.getFirstDateCurMonth(toDate);
                DateUtils.putDate(map, DAY, list, toFirstDate, toDate);
            }
        } else if (months > 1) {
            if (DateUtils.isFirstDateOfMonth(fromDate) && DateUtils.isEndDateOfMonth(toDate)) {
                DateUtils.putDate(map, MONTH, list, fromDate, toDate);
            } else if (DateUtils.isFirstDateOfMonth(fromDate) && !DateUtils.isEndDateOfMonth(toDate)) {
                Date tempPreviousMonth = DateUtils.getEndDatePreviousMonth(toDate);
                DateUtils.putDate(map, MONTH, list, fromDate, tempPreviousMonth);
                Date toFirstDate = DateUtils.getFirstDateCurMonth(toDate);
                DateUtils.putDate(map, DAY, list, toFirstDate, toDate);
            } else if (!DateUtils.isFirstDateOfMonth(fromDate) && DateUtils.isEndDateOfMonth(toDate)) {
                Date tempNextMonth = DateUtils.getFirstDateNextMonth(fromDate);
                DateUtils.putDate(map, MONTH, list, tempNextMonth, toDate);
                Date fromEndDate = DateUtils.getEndDateOfMonth(fromDate);
                DateUtils.putDate(map, DAY, list, fromDate, fromEndDate);
            } else if (!DateUtils.isFirstDateOfMonth(fromDate) && !DateUtils.isEndDateOfMonth(toDate)) {
                Date tempNextMonth = DateUtils.getFirstDateNextMonth(fromDate);
                Date tempPreviousMonth = DateUtils.getEndDatePreviousMonth(toDate);
                DateUtils.putDate(map, MONTH, list, tempNextMonth, tempPreviousMonth);
                Date fromEndDate = DateUtils.getEndDateOfMonth(fromDate);
                DateUtils.putDate(map, DAY, list, fromDate, fromEndDate);
                Date toFirstDate = DateUtils.getFirstDateCurMonth(toDate);
                DateUtils.putDate(map, DAY, list, toFirstDate, toDate);
            }
        }
    }

    private static int isEnoughYear(Date fromDate, Date toDate) {
        Calendar calFrom = Calendar.getInstance();
        Calendar calTo = Calendar.getInstance();
        calFrom.setTime(fromDate);
        calTo.setTime(toDate);
        return calTo.get(1) - calFrom.get(1);
    }

    private static int isEnoughMonth(Date fromDate, Date toDate) {
        Calendar calFrom = Calendar.getInstance();
        Calendar calTo = Calendar.getInstance();
        calFrom.setTime(fromDate);
        calTo.setTime(toDate);
        return calTo.get(2) - calFrom.get(2);
    }

    public static boolean isFirstDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(2) == 0) {
            if (cal.get(5) == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFirstDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5) == 1;
    }

    public static boolean isEndDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(2) == 11) {
            if (cal.get(5) == 31) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int tempMonth = cal.get(2);
        int tempDay = cal.get(5);
        cal.set(5, tempDay + 1);
        int newMonth = cal.get(2);
        boolean flag = false;
        flag = tempMonth != newMonth;
        return flag;
    }

    public static Date getEndDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int curMonth = cal.get(2);
        cal.set(2, curMonth + 1);
        cal.set(5, 1);
        cal.set(5, cal.get(5) - 1);
        return cal.getTime();
    }

    public static Date getEndDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return cal.getTime();
    }

    public static Date getEndDatePreviousYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, cal.get(1) - 1);
        cal.set(2, 11);
        cal.set(5, 31);
        return cal.getTime();
    }

    public static Date getEndDatePreviousMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(5, cal.get(5) - 1);
        return cal.getTime();
    }

    public static Date getFirstDateNextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDateNextYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, cal.get(1) + 1);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDateCurMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDateCurYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String getSimpleDateFormat(Date date) {
        return sdfhh.format(date);
    }

    public static void main(String[] args) throws Exception {
        List list;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String from = "2008-1-2";
        String to = "2010-11-29";
        Calendar calFrom = Calendar.getInstance();
        Date fromDate = df.parse(from);
        Date toDate = df.parse(to);
        calFrom.setTime(fromDate);
        Map map = DateUtils.getIntervalDate(fromDate, toDate);
        if (map.get(YEAR) != null) {
            list = (List)map.get(YEAR);
            for (Date[] dateArray : list) {
            }
        }
        if (map.get(MONTH) != null) {
            list = (List)map.get(MONTH);
            for (Date[] dateArray : list) {
            }
        }
        if (map.get(DAY) != null) {
            list = (List)map.get(DAY);
            for (Date[] dateArray : list) {
            }
        }
    }
}

