/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.scm.sd.sale.util.IAutoCalcable;
import java.math.BigDecimal;

public class ExprMidNode
implements IAutoCalcable {
    private IRow row = null;
    private IAutoCalcable leftNode;
    private IAutoCalcable rightNode;
    private String operator;

    @Override
    public void setCurRow(IRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.row = row;
    }

    public ExprMidNode(IAutoCalcable leftNode, IAutoCalcable rightNode, String oprt) {
        if (leftNode == null || rightNode == null || oprt == null) {
            throw new IllegalArgumentException("parameters cannot be null");
        }
        if (!(oprt.equals("+") || oprt.equals("-") || oprt.equals("*") || oprt.equals("/"))) {
            throw new IllegalArgumentException("oprtor can only permit + - * /");
        }
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.operator = oprt;
    }

    @Override
    public BigDecimal calcValue() throws Exception {
        this.leftNode.setCurRow(this.row);
        this.rightNode.setCurRow(this.row);
        if (this.operator.equals("+")) {
            return this.leftNode.calcValue().add(this.rightNode.calcValue());
        }
        if (this.operator.equals("-")) {
            return this.leftNode.calcValue().subtract(this.rightNode.calcValue());
        }
        if (this.operator.equals("*")) {
            return this.leftNode.calcValue().multiply(this.rightNode.calcValue());
        }
        return this.leftNode.calcValue().divide(this.rightNode.calcValue(), 2);
    }

    @Override
    public String[] getRelatedColName() {
        int i;
        String[] leftList = this.leftNode.getRelatedColName();
        String[] rightList = this.rightNode.getRelatedColName();
        int leftCount = leftList.length;
        int rightCount = rightList.length;
        int totalcount = leftCount + rightCount;
        String[] retList = new String[totalcount];
        int n = leftCount;
        for (i = 0; i < n; ++i) {
            retList[i] = leftList[i];
        }
        n = totalcount;
        for (i = leftCount; i < n; ++i) {
            retList[i] = rightList[i - leftCount];
        }
        return retList;
    }
}

