/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.client.SaleInvoiceUIUtil;
import java.math.BigDecimal;

public class SaleInvoiceUtil {
    public static BigDecimal caculatePrice(BigDecimal taxRate, BigDecimal taxPrice) {
        BigDecimal price = null;
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (taxPrice != null) {
            taxRate = SaleInvoiceUtil.getLittleRate(taxRate);
            int scale = taxRate.scale() + taxPrice.scale();
            price = taxPrice.divide(taxRate.add(new BigDecimal("1.00")), scale, 4);
        }
        return price;
    }

    public static BigDecimal calculateTaxPrice(BigDecimal price, BigDecimal taxRate) {
        BigDecimal taxPrice = null;
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (price != null) {
            taxRate = SaleInvoiceUtil.getLittleRate(taxRate);
            taxPrice = price.add(price.multiply(taxRate));
        }
        return taxPrice;
    }

    public static BigDecimal calculateAmount(BigDecimal price, BigDecimal qty, BigDecimal discount, DiscountModeEnum discountType, BigDecimal taxRate, int pricePrecision) {
        BigDecimal amount = new BigDecimal("0.0");
        if (price == null) {
            price = new BigDecimal("0.0");
        }
        if (qty == null) {
            qty = new BigDecimal("0.00");
        }
        if (discount == null) {
            discount = new BigDecimal("0.0");
        }
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (discountType != null) {
            if (discountType.equals((Object)DiscountModeEnum.PERCENT)) {
                if (price != null && qty != null) {
                    discount = SaleInvoiceUtil.getLittleRate(discount);
                    BigDecimal temp = new BigDecimal("1.00").subtract(discount);
                    BigDecimal realPrice = price.multiply(temp).setScale(pricePrecision, 4);
                    amount = realPrice.multiply(qty);
                }
            } else if (discountType.equals((Object)DiscountModeEnum.PERUNIT)) {
                BigDecimal temp = new BigDecimal("1.00").add(taxRate = SaleInvoiceUtil.getLittleRate(taxRate));
                int length = temp.toString().length();
                if (length < 4) {
                    length = 4;
                }
                BigDecimal realPrice = price.subtract(discount.divide(temp, length, 4)).setScale(pricePrecision, 4);
                amount = realPrice.multiply(qty);
            } else {
                amount = price.multiply(qty);
            }
        } else {
            amount = price.multiply(qty);
        }
        return amount;
    }

    public static BigDecimal caculateDiscountAmount(DiscountModeEnum discountType, BigDecimal discount, BigDecimal qty, BigDecimal taxPrice) {
        BigDecimal discountAmount = new BigDecimal("0.00");
        if (discountType != null) {
            if (discountType.equals((Object)DiscountModeEnum.PERCENT)) {
                if (discount != null && qty != null && taxPrice != null) {
                    discount = SaleInvoiceUIUtil.getLittleRate(discount);
                    discountAmount = taxPrice.multiply(qty).multiply(discount);
                }
            } else if (discountType.equals((Object)DiscountModeEnum.PERUNIT)) {
                if (discount != null && qty != null && taxPrice != null) {
                    discountAmount = discount.multiply(qty);
                }
            } else {
                discountAmount = new BigDecimal("0.00");
            }
        } else {
            discountAmount = new BigDecimal("0.00");
        }
        return discountAmount;
    }

    public static BigDecimal calculateDealPrice(BigDecimal taxPrice, BigDecimal discount, DiscountModeEnum discountType) {
        BigDecimal dealPrice = new BigDecimal("0.00");
        if (discount == null) {
            discount = new BigDecimal("0.0");
        }
        if (taxPrice == null) {
            taxPrice = new BigDecimal("0.0");
        }
        if (discountType != null) {
            if (taxPrice != null) {
                if (discountType.equals((Object)DiscountModeEnum.PERCENT)) {
                    discount = SaleInvoiceUtil.getLittleRate(discount);
                    BigDecimal temp = new BigDecimal("1.00").subtract(discount);
                    dealPrice = taxPrice.multiply(temp);
                } else {
                    dealPrice = discountType.equals((Object)DiscountModeEnum.PERUNIT) ? taxPrice.subtract(discount) : taxPrice;
                }
            }
        } else {
            dealPrice = taxPrice;
        }
        return dealPrice;
    }

    public static BigDecimal calculateLocalAmount(BigDecimal amount, ExchangeRateInfo exchangeRateinfo) {
        return SCMUtils.calculateLocalAmount((BigDecimal)amount, (ExchangeRateInfo)exchangeRateinfo);
    }

    public static BigDecimal calculateTaxAmount(BigDecimal amount, BigDecimal taxRate) {
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (amount != null) {
            taxRate = SaleInvoiceUtil.getLittleRate(taxRate);
            return amount.add(SaleInvoiceUtil.calculateTax(amount, taxRate));
        }
        return new BigDecimal("0.00");
    }

    public static BigDecimal getLittleRate(BigDecimal ratePercent) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return new BigDecimal("0.00");
        }
        int length = ratePercent.toString().length();
        if (length < 4) {
            length = 4;
        }
        rate = ratePercent.divide(new BigDecimal("100.0"), length, 4);
        return rate;
    }

    public static BigDecimal calculateTax(BigDecimal amount, BigDecimal taxRate) {
        if (amount == null) {
            amount = new BigDecimal("0.00");
        }
        return amount.multiply(taxRate);
    }

    public static void storeDefaultValues(SaleInvoiceInfo editData, ExchangeRateInfo exchangeRateinfo) {
        BigDecimal totalTaxAmount = editData.getTotalTaxAmount();
        BigDecimal totalAmount = editData.getTotalAmount();
        if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
            if (totalTaxAmount != null) {
                BigDecimal localtotalTaxAmount = SaleInvoiceUtil.calculateLocalAmount(totalTaxAmount, exchangeRateinfo);
                editData.setLocalTotalTaxAmount(localtotalTaxAmount);
            }
            if (totalAmount != null) {
                BigDecimal localTotalAmount = SaleInvoiceUtil.calculateLocalAmount(totalAmount, exchangeRateinfo);
                editData.setLocalTotalAmount(localTotalAmount);
            }
        } else {
            editData.setLocalTotalTaxAmount(totalTaxAmount);
            editData.setLocalTotalAmount(totalAmount);
        }
        SaleInvoiceEntryCollection entryCollection = editData.getEntries();
        SaleInvoiceEntryInfo entryInfo = null;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCollection.get(i);
            BigDecimal entrylocalAmount = entryInfo.getLocalAmount();
            BigDecimal entryBaseQty = entryInfo.getBaseQty();
            BigDecimal entryQty = entryInfo.getQty();
            if (entrylocalAmount != null) {
                entryInfo.setUnwriteOffAmount(entrylocalAmount);
                entryInfo.setLocalUnwriteOffAmount(entrylocalAmount);
            }
            if (entryBaseQty != null) {
                entryInfo.setUnwriteOffBaseQty(entryBaseQty);
            }
            if (entryQty == null) continue;
            entryInfo.setUnwriteOffQty(entryQty);
        }
    }
}

