/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.srm.supm.EvalClassCollection;
import com.kingdee.eas.scm.srm.supm.EvalClassFactory;
import com.kingdee.eas.scm.srm.supm.EvalClassInfo;
import com.kingdee.eas.scm.srm.supm.IEvalClass;
import com.kingdee.eas.scm.srm.supm.UsedStatesEnum;
import com.kingdee.eas.scm.srm.supm.client.AbstractEvalClassListUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;

public class EvalClassListUI
extends AbstractEvalClassListUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.initButtonEnable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionApprove.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionReApprove.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
    }

    private void initButtonEnable() {
        this.actionImportData.setVisible(true);
        this.actionExportData.setVisible(true);
        this.actionAddNew.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionEdit.setEnabled(true);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ArrayList getImportParam() {
        return this.getParam(0);
    }

    protected ArrayList getExportParam() {
        return this.getParam(1);
    }

    private ArrayList getParam(int datataskMode) {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.SupplierManage.EvalClass";
        param.alias = EASResource.getString((String)"com.kingdee.eas.scm.srm.supm.client.SupmResource", (String)"EvalClassQueryF7WindowTitle");
        param.datataskMode = datataskMode;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private EvalClassInfo getSelectInfo() throws BOSException, EASBizException {
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IEvalClass instance = this.getRemoteInstance();
        EvalClassInfo info = instance.getEvalClassInfo((IObjectPK)pk);
        return info;
    }

    private EvalClassCollection getSelectCollection() throws BOSException, EASBizException {
        ArrayList list = this.getSelectedIdValues();
        IEvalClass instance = this.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        EvalClassCollection coll = instance.getEvalClassCollection(evi);
        return coll;
    }

    private IEvalClass getRemoteInstance() throws BOSException {
        return EvalClassFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (UsedStatesEnum.APPROVED.equals((Object)this.getSelectInfo().getUsedState())) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_UPDATE_ISUNAPPROVE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (UsedStatesEnum.APPROVED.equals((Object)this.getSelectInfo().getUsedState())) {
            throw new CustomerSupplierException(CustomerSupplierException.CANNOT_DELETE_ISNOTUNAPPOVE);
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalClassCollection coll = this.getSelectCollection();
        boolean hasError = false;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u540d\u79f0\u4e3a\uff1a");
        IEvalClass biz = this.getRemoteInstance();
        for (int i = 0; i < coll.size(); ++i) {
            EvalClassInfo info = coll.get(i);
            if (UsedStatesEnum.APPROVED.equals((Object)info.getUsedState())) {
                hasError = true;
                errorMsg.append(info.getName() + " ");
            }
            biz.doApprove(info.getId());
        }
        if (hasError) {
            errorMsg.append("\u7684\u4f9b\u5e94\u5546\u7b49\u7ea7\u662f\u6838\u51c6\u72b6\u6001\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01");
            MsgBox.showInfo((String)errorMsg.toString());
        } else {
            this.setMessageText("\u6838\u51c6\u6210\u529f");
            this.showMessage();
        }
        this.tblMain.refresh();
    }

    public void actionReApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalClassCollection coll = this.getSelectCollection();
        boolean hasError = false;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u540d\u79f0\u4e3a\uff1a");
        IEvalClass biz = this.getRemoteInstance();
        for (int i = 0; i < coll.size(); ++i) {
            EvalClassInfo info = coll.get(i);
            if (UsedStatesEnum.SAVE.equals((Object)info.getUsedState())) {
                hasError = true;
                errorMsg.append(info.getName() + " ");
            }
            biz.doReApprove(info.getId());
        }
        if (hasError) {
            errorMsg.append("\u7684\u4f9b\u5e94\u5546\u7b49\u7ea7\u662f\u4fdd\u5b58\u72b6\u6001\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
            MsgBox.showInfo((String)errorMsg.toString());
        } else {
            this.setMessageText("\u53cd\u6838\u51c6\u6210\u529f");
            this.showMessage();
        }
        this.tblMain.refresh();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvalClassFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        EvalClassInfo objectValue = new EvalClassInfo();
        return objectValue;
    }
}

