/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.srm.supm.EvalGroupEntryCollection;
import com.kingdee.eas.scm.srm.supm.EvalGroupFactory;
import com.kingdee.eas.scm.srm.supm.EvalGroupInfo;
import com.kingdee.eas.scm.srm.supm.UsedStatesEnum;
import com.kingdee.eas.scm.srm.supm.client.AbstractEvalGroupEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class EvalGroupEditUI
extends AbstractEvalGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EvalGroupEditUI.class);

    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        this.initOldData((IObjectValue)this.editData);
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.kdtEntrys.addRow();
        }
        this.initTable();
        this.initButtonEnable();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initDataStatus() {
        EvalGroupInfo info = (EvalGroupInfo)this.getDataObject();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            if (UsedStatesEnum.APPROVED.equals((Object)info.getUsedState())) {
                this.actionEdit.setEnabled(false);
            }
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.kdtEntrys.addRow();
        }
        super.initDataStatus();
    }

    private void initButtonEnable() {
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    private void initTable() {
        this.kdtEntrys.getColumn("personName").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("personOrgUnit").getStyleAttributes().setLocked(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if (this.editData.getEntrys().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5fc5\u987b\u6709\u4e00\u6761\u4eba\u5458\u4fe1\u606f");
            SysUtil.abort();
        }
        for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
            if (this.editData.getEntrys().get(i).getPerson() != null) continue;
            MsgBox.showInfo((Component)((Object)this), (String)"\u672a\u586b\u5199\u5b8c\u6574");
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected void kdtEntrys_editStopped(KDTEditEvent e) throws Exception {
        Object val;
        if (e.getValue() == null) {
            return;
        }
        IRow row = this.kdtEntrys.getRow(e.getRowIndex());
        if ("person".equals(this.kdtEntrys.getColumnKey(e.getColIndex())) && (val = row.getCell("person").getValue()) instanceof PersonInfo) {
            PersonInfo item = (PersonInfo)val;
            if (this.isSamePerson(item, e.getRowIndex())) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8be5\u4eba\u5458\u5df2\u5b58\u5728");
                row.getCell("personName").setValue(null);
                row.getCell("person").setValue(null);
                row.getCell("personOrgUnit").setValue(null);
                SysUtil.abort();
            }
            row.getCell("personName").setValue((Object)item.getName());
            AdminOrgUnitCollection orgUnitList = PersonFacadeFactory.getRemoteInstance().getAdminOrgUnitByPerson(item.getId());
            if (orgUnitList != null) {
                AdminOrgUnitInfo info = orgUnitList.get(0);
                row.getCell("personOrgUnit").setValue((Object)info.getName());
            }
        }
    }

    public boolean isSamePerson(PersonInfo info, int rowIndex) {
        EvalGroupEntryCollection entrys = this.editData.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            if (i == rowIndex || !(entrys.get(i).getPerson() instanceof PersonInfo) || !entrys.get(i).getPerson().equals((Object)info)) continue;
            return true;
        }
        return false;
    }

    protected void applyDefaultValue(IObjectValue vo) {
        vo.put("usedState", (Object)new Integer(0));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvalGroupFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected IObjectValue createNewData() {
        EvalGroupInfo objectValue = new EvalGroupInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setUsedState(UsedStatesEnum.SAVE);
        return objectValue;
    }
}

