/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.scm.srm.supm.EvalItemCollection;
import com.kingdee.eas.scm.srm.supm.EvalItemFactory;
import com.kingdee.eas.scm.srm.supm.EvalItemInfo;
import com.kingdee.eas.scm.srm.supm.EvalItemTreeFactory;
import com.kingdee.eas.scm.srm.supm.EvalItemTreeInfo;
import com.kingdee.eas.scm.srm.supm.IEvalItem;
import com.kingdee.eas.scm.srm.supm.UsedStatesEnum;
import com.kingdee.eas.scm.srm.supm.client.AbstractEvalItemListUI;
import com.kingdee.eas.scm.srm.supm.client.EvalItemTreeEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;

public class EvalItemListUI
extends AbstractEvalItemListUI {
    private static final String RESOURCE_FILE_NAME = "com.kingdee.eas.scm.srm.supm.client.SupmResource";

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAddNew.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.actionApprove.setEnabled(true);
        this.actionUnApprove.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (!this.validateNode()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8bc4\u4f30\u7c7b\u522b\uff01");
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        EvalItemInfo info = this.getEvalItem();
        if (UsedStatesEnum.APPROVED.equals((Object)info.getStatus())) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6b64\u9879\u76ee\u5df2\u6838\u51c6,\u4e0d\u80fd\u79fb\u52a8\uff01");
            SysUtil.abort();
        }
        super.actionMoveTree_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalItemInfo info = this.getEvalItem();
        if (UsedStatesEnum.APPROVED.equals((Object)info.getStatus())) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6b64\u9879\u76ee\u5df2\u6838\u51c6,\u4e0d\u80fd\u4fee\u6539\uff01");
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalItemInfo info = this.getEvalItem();
        if (UsedStatesEnum.APPROVED.equals((Object)info.getStatus())) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u6b64\u9879\u76ee\u5df2\u6838\u51c6,\u4e0d\u80fd\u5220\u9664\uff01");
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean validateNode() {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        return treeNode.isLeaf() && treeNode.getParent() != null;
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateEvalItem()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8282\u70b9\u4e0b\u5df2\u6709\u8bc4\u4f30\u9879\u76ee,\u4e0d\u80fd\u65b0\u589e\uff01");
            SysUtil.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateEvalItem()) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8282\u70b9\u4e0b\u5df2\u6709\u8bc4\u4f30\u9879\u76ee,\u4e0d\u80fd\u5220\u9664\uff01");
            SysUtil.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    private boolean validateEvalItem() throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.treeMain.getSelectionPath().getLastPathComponent();
        if (treeNode.isRoot()) {
            return false;
        }
        String id = ((EvalItemTreeInfo)treeNode.getUserObject()).getId().toString();
        IEvalItem instance = EvalItemFactory.getRemoteInstance();
        return instance.getCollectionByTreeID(id);
    }

    protected ArrayList getImportParam() {
        return this.getParam(0);
    }

    protected ArrayList getExportParam() {
        return this.getParam(1);
    }

    private ArrayList getParam(int datataskMode) {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.scm.srm.supm.client.EvalItem";
        param.alias = EASResource.getString((String)RESOURCE_FILE_NAME, (String)"EvalItem");
        param.datataskMode = datataskMode;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalItemCollection coll = this.getSelectCollection();
        boolean hasError = false;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u540d\u79f0\u4e3a\uff1a");
        IEvalItem biz = EvalItemFactory.getRemoteInstance();
        for (int i = 0; i < coll.size(); ++i) {
            EvalItemInfo info = coll.get(i);
            if (UsedStatesEnum.APPROVED.equals((Object)info.getStatus())) {
                hasError = true;
                errorMsg.append(info.getName() + " ");
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            biz.doApprove((IObjectPK)pk);
        }
        if (hasError) {
            errorMsg.append("\u7684\u8bc4\u4f30\u9879\u76ee\u662f\u6838\u51c6\u72b6\u6001\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01");
            MsgBox.showInfo((String)errorMsg.toString());
        } else {
            this.setMessageText("\u6838\u51c6\u6210\u529f");
            this.showMessage();
        }
        this.tblMain.refresh();
    }

    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        EvalItemCollection coll = this.getSelectCollection();
        boolean hasError = false;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u540d\u79f0\u4e3a\uff1a");
        IEvalItem biz = EvalItemFactory.getRemoteInstance();
        for (int i = 0; i < coll.size(); ++i) {
            EvalItemInfo info = coll.get(i);
            if (UsedStatesEnum.SAVE.equals((Object)info.getStatus())) {
                hasError = true;
                errorMsg.append(info.getName() + " ");
            }
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            biz.doUnApprove((IObjectPK)pk);
        }
        if (hasError) {
            errorMsg.append("\u7684\u8bc4\u4f30\u9879\u76ee\u662f\u4fdd\u5b58\u72b6\u6001\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01");
            MsgBox.showInfo((String)errorMsg.toString());
        } else {
            this.setMessageText("\u53cd\u6838\u51c6\u6210\u529f");
            this.showMessage();
        }
        this.tblMain.refresh();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EvalItemFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return EvalItemTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return EvalItemTreeEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getQueryFieldName() {
        return "treeid.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)RESOURCE_FILE_NAME, (String)"EvalItem");
    }

    protected IObjectValue createNewData() {
        EvalItemInfo objectValue = new EvalItemInfo();
        return objectValue;
    }

    private EvalItemInfo getEvalItem() throws BOSException, EASBizException {
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IEvalItem instance = EvalItemFactory.getRemoteInstance();
        EvalItemInfo info = instance.getEvalItemInfo((IObjectPK)pk);
        return info;
    }

    private EvalItemCollection getSelectCollection() throws BOSException, EASBizException {
        ArrayList list = this.getSelectedIdValues();
        IEvalItem instance = EvalItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelectors());
        EvalItemCollection coll = instance.getEvalItemCollection(evi);
        return coll;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.tblMain.refresh();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }
}

