/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.DefaultContextHandler;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateContextHandler
implements IContextHandler,
Serializable {
    public static final String DATE = "DateContextHandler_date";
    public static final String COMPANY = "IContextHandler_company";
    public static final String CURRENCY = "IContextHandler_currency";
    public static final String INCLUDE_POSTED = "IncludePosted";
    public static final String INCLUDE_SUB = "IncludeSub";
    public static final String INCLUDE_LEAF = "IncludeLeaf";
    public static final String TIMPTYPE = "timetype";
    public static final Map PERIODTYPE_MAP = new HashMap();

    public void handlerContext(Context ctx, ReportInfo report, ReportVariables iv) {
        Object object = ctx.get((Object)DATE);
        Object objectPeriodType = ctx.get((Object)TIMPTYPE);
        if (object != null && object instanceof Date && objectPeriodType != null && objectPeriodType instanceof KPITimeTypeEnum) {
            RptPeriodTypeEnum periodType = this.covertPeriodType((KPITimeTypeEnum)((Object)objectPeriodType));
            int[] period = RPTDateUtil.getPeriod((Date)((Date)object), (RptPeriodTypeEnum)periodType);
            report.setPeriodType(periodType);
            report.setYear(period[0]);
            report.setPeriod((short)period[1]);
            report.setStartDate(RPTDateUtil.getPeriodFirstDate((int)period[0], (int)period[1], (RptPeriodTypeEnum)periodType));
            report.setEndDate(RPTDateUtil.getPeriodLastDate((int)period[0], (int)period[1], (RptPeriodTypeEnum)periodType));
        }
        if ((object = ctx.get((Object)COMPANY)) != null && object instanceof CompanyOrgUnitInfo) {
            report.setCompany((CompanyOrgUnitInfo)object);
        }
        if ((object = ctx.get((Object)CURRENCY)) != null && object instanceof CurrencyInfo) {
            report.setCurrency((CurrencyInfo)object);
        }
        report.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        iv.addAll(DefaultContextHandler.initSheetReservedVariables((Context)ctx, (String)"sheet1", (RptPeriodTypeEnum)report.getPeriodType()), false);
    }

    private RptPeriodTypeEnum covertPeriodType(KPITimeTypeEnum objectPeriodType) {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)PERIODTYPE_MAP.get((Object)objectPeriodType);
        if (periodType == null) {
            return RptPeriodTypeEnum.DAILY;
        }
        return periodType;
    }

    static {
        PERIODTYPE_MAP.put(KPITimeTypeEnum.day, RptPeriodTypeEnum.DAILY);
        PERIODTYPE_MAP.put(KPITimeTypeEnum.week, RptPeriodTypeEnum.WEEKLY);
        PERIODTYPE_MAP.put(KPITimeTypeEnum.month, RptPeriodTypeEnum.MONTHLY);
        PERIODTYPE_MAP.put(KPITimeTypeEnum.season, RptPeriodTypeEnum.QUARTERLY);
        PERIODTYPE_MAP.put(KPITimeTypeEnum.halfYear, RptPeriodTypeEnum.SEMIYEARLY);
        PERIODTYPE_MAP.put(KPITimeTypeEnum.year, RptPeriodTypeEnum.YEARLY);
    }
}

