/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.sem.mp.DailScopeInfo;
import com.kingdee.eas.sem.mp.DisplaySchemaFactory;
import com.kingdee.eas.sem.mp.DisplaySchemaInfo;
import com.kingdee.eas.sem.mp.DisplaySchemaKPICollection;
import com.kingdee.eas.sem.mp.DisplaySchemaKPIFactory;
import com.kingdee.eas.sem.mp.IDisplaySchema;
import com.kingdee.eas.sem.mp.IDisplaySchemaKPI;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class DisplaySchemeUtil {
    protected DisplaySchemaInfo displaySchemaInfo;
    protected KPICollection kpiCollection;
    protected KPIInfo kpiInfo;
    protected KPIValueInfo kpiValueInfo;
    protected KPIWarnParamCollection kpiWarnParamCollection;
    String currUserId;
    DailScopeInfo[] dailScopeInfoArry;
    HashMap soluColor = new HashMap();
    String currCompanyid;
    Context curCtx;

    public DisplaySchemeUtil(String userID) {
        this.currUserId = userID;
    }

    public DisplaySchemeUtil(String userID, Context ctx) {
        this.currUserId = userID;
        this.curCtx = ctx;
    }

    public void constructData() throws Exception {
        this.sonstrustSoluColor();
        this.constructDisplayData();
        this.constructKpiData();
    }

    public BigDecimal getCurrKpiValue() {
        int displayPrecision = 2;
        displayPrecision = this.kpiInfo.getDisplayPrecision();
        if (this.kpiInfo.isIsPercent()) {
            return this.kpiValueInfo.getKpiValue().setScale(displayPrecision, 4);
        }
        return this.kpiValueInfo.getKpiValue().setScale(displayPrecision, 4);
    }

    public static String transColorDataToHex(String c) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        StringTokenizer tk = new StringTokenizer(c, ",");
        while (tk.hasMoreTokens()) {
            int lastIndex;
            String temp = tk.nextToken().trim();
            String colorV = temp.substring((lastIndex = temp.lastIndexOf(32)) + 1);
            String htemp = Integer.toHexString(Integer.parseInt(colorV)).trim();
            if (htemp.length() == 1) {
                buf.append("0");
            }
            buf.append(htemp);
        }
        return buf.toString().trim().toUpperCase();
    }

    public void constructDataInclueOneKpi() throws Exception {
        this.sonstrustSoluColor();
        this.constructDisplayData();
        this.constructKpiData();
        this.constructCurrentKpiData();
        this.constructWarnParam();
    }

    public void sonstrustSoluColor() throws Exception {
        IWarnGroup iWarnGroup = this.curCtx != null ? WarnGroupFactory.getLocalInstance(this.curCtx) : WarnGroupFactory.getRemoteInstance();
        WarnGroupCollection warnGroupCollection = iWarnGroup.getWarnGroupCollection();
        int size = warnGroupCollection.size();
        for (int i = 0; i < size; ++i) {
            this.soluColor.put(String.valueOf(warnGroupCollection.get(i).getPeriority()), warnGroupCollection.get(i).getColor());
        }
    }

    public void constructDisplayData() throws Exception {
        IDisplaySchema iDisplaySchema = this.curCtx != null ? DisplaySchemaFactory.getLocalInstance(this.curCtx) : DisplaySchemaFactory.getRemoteInstance();
        List displaySchemaCollection = iDisplaySchema.getPermCollection(this.currUserId, this.currCompanyid);
        if (displaySchemaCollection != null && displaySchemaCollection.size() > 0) {
            this.displaySchemaInfo = (DisplaySchemaInfo)displaySchemaCollection.get(0);
        }
    }

    public void constructKpiData() throws Exception {
        if (this.displaySchemaInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("displaySchema"));
        sc.add(new SelectorItemInfo("dashBoardOrder"));
        sc.add(new SelectorItemInfo("kpi.id"));
        sc.add(new SelectorItemInfo("kpi.name"));
        sc.add(new SelectorItemInfo("kpi.isPercent"));
        sc.add(new SelectorItemInfo("kpi.displayPrecision"));
        sc.add(new SelectorItemInfo("kpi.kpiValue.*"));
        sc.add(new SelectorItemInfo("kpi.kpiValue.kpiValue"));
        sc.add(new SelectorItemInfo("kpi.kpiValue.currentWarnStatus.id"));
        sc.add(new SelectorItemInfo("kpi.kpiValue.currentWarnStatus.color"));
        sc.add(new SelectorItemInfo("kpi.kpiValue.currentWarnStatus.periority"));
        sc.add(new SelectorItemInfo("kpi.measureUnit"));
        sc.add(new SelectorItemInfo("kpi.numberUnit"));
        sc.add(new SelectorItemInfo("kpi.isPercent"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("displaySchema", (Object)this.displaySchemaInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("dashBoardOrder", (Object)"0", CompareType.GREATER_EQUALS));
        SorterItemInfo sorter = new SorterItemInfo("displayOrder");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        sorter = new SorterItemInfo("kpi.kpiValue.bizDate");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        view.setFilter(filter);
        IDisplaySchemaKPI iDisplaySchemaKPI = this.curCtx != null ? DisplaySchemaKPIFactory.getLocalInstance(this.curCtx) : DisplaySchemaKPIFactory.getRemoteInstance();
        DisplaySchemaKPICollection displaySchemaKPICollection = iDisplaySchemaKPI.getDisplaySchemaKPICollection(view);
        this.kpiCollection = new KPICollection();
        int size = displaySchemaKPICollection.size();
        for (int i = 0; i < size; ++i) {
            this.kpiCollection.add(displaySchemaKPICollection.get(i).getKpi());
        }
    }

    public void constructCurrentKpiData() {
        if (this.kpiCollection != null && this.kpiCollection.size() > 0) {
            this.kpiInfo = this.kpiCollection.get(0);
        }
    }

    private void generateRange(KPIWarnParamCollection params, double kpiValue, int rountSize, boolean isPercent) {
        KpiRange normal = new KpiRange(0.0, kpiValue * 2.0);
        KpiRange warning = new KpiRange(0.0, 0.0);
        KpiRange critical = new KpiRange(0.0, 0.0);
        boolean isShow = false;
        if (params != null) {
            int count = params.size();
            if (count == 2) {
                double low;
                double high;
                double paramLowValue;
                KPIWarnParamInfo paramHigh = params.get(0);
                KPIWarnParamInfo paramLow = params.get(1);
                if (paramHigh.getWarnGroup().getPeriority() > paramLow.getWarnGroup().getPeriority()) {
                    KPIWarnParamInfo temp = paramHigh;
                    paramHigh = paramLow;
                    paramLow = temp;
                }
                double paramHighValue = paramHigh.getCurrentValue() == null ? 0.0 : paramHigh.getCurrentValue().doubleValue();
                double d = paramLowValue = paramLow.getCurrentValue() == null ? 0.0 : paramLow.getCurrentValue().doubleValue();
                if (paramHighValue > paramLowValue) {
                    high = paramHighValue + (paramHighValue - paramLowValue);
                    low = paramLowValue - (paramHighValue - paramLowValue);
                    if (kpiValue > high) {
                        high = kpiValue;
                    } else if (kpiValue < low) {
                        low = kpiValue;
                    }
                    normal = new KpiRange(low, paramLowValue);
                    warning = new KpiRange(paramLowValue, paramHighValue);
                    critical = new KpiRange(paramHighValue, high);
                } else {
                    high = paramHighValue - (paramLowValue - paramHighValue);
                    low = paramLowValue + (paramLowValue - paramHighValue);
                    if (kpiValue > low) {
                        low = kpiValue;
                    } else if (kpiValue < high) {
                        high = kpiValue;
                    }
                    normal = new KpiRange(paramLowValue, low);
                    warning = new KpiRange(paramHighValue, paramLowValue);
                    critical = new KpiRange(high, paramHighValue);
                }
                isShow = true;
            } else if (count == 4) {
                int i;
                double[] paramValue = new double[4];
                for (i = 0; i < count; ++i) {
                    KPIWarnParamInfo param = params.get(i);
                    paramValue[i] = param.getCurrentValue().doubleValue();
                }
                for (i = 0; i < count - 1; ++i) {
                    int min = i;
                    for (int j = i + 1; j < count; ++j) {
                        if (!(paramValue[j] < paramValue[min])) continue;
                        min = j;
                    }
                    if (min == i) continue;
                    double swap = paramValue[i];
                    paramValue[i] = paramValue[min];
                    paramValue[min] = swap;
                }
                double middle = (paramValue[1] + paramValue[2]) / 2.0;
                double lack = middle - paramValue[1];
                if (kpiValue < middle) {
                    double minimum = paramValue[0] - lack;
                    if (minimum > kpiValue) {
                        minimum = kpiValue;
                    }
                    critical = new KpiRange(minimum, paramValue[0]);
                    warning = new KpiRange(paramValue[0], paramValue[1]);
                    normal = new KpiRange(paramValue[1], middle);
                } else {
                    double maxmum = paramValue[3] + lack;
                    if (kpiValue > maxmum) {
                        maxmum = kpiValue;
                    }
                    normal = new KpiRange(middle, paramValue[2]);
                    warning = new KpiRange(paramValue[2], paramValue[3]);
                    critical = new KpiRange(paramValue[3], maxmum);
                }
                isShow = true;
            } else if (this.kpiInfo.getCurrentWarnStatus() != null) {
                int periority = 0;
                if (periority == 0) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-5.0, -3.0);
                        normal = new KpiRange(-3.0, -1.0);
                        critical = new KpiRange(-1.0, 1.0);
                    } else {
                        warning = new KpiRange(0.0, kpiValue * 2.0 / 5.0);
                        normal = new KpiRange(kpiValue * 2.0 / 5.0, kpiValue * 4.0 / 5.0);
                        critical = new KpiRange(kpiValue * 4.0 / 5.0, kpiValue * 6.0 / 5.0);
                    }
                    isShow = true;
                } else if (periority == 1) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-1.0, 1.0);
                        normal = new KpiRange(1.0, 3.0);
                        critical = new KpiRange(3.0, 5.0);
                    } else {
                        warning = new KpiRange(0.0, kpiValue * 2.0);
                        normal = new KpiRange(kpiValue * 2.0, kpiValue * 4.0);
                        critical = new KpiRange(kpiValue * 4.0, kpiValue * 6.0);
                    }
                    isShow = true;
                } else if (periority == 2) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-3.0, -1.0);
                        normal = new KpiRange(-1.0, 1.0);
                        critical = new KpiRange(1.0, 3.0);
                    } else {
                        normal = new KpiRange(kpiValue * 2.0 / 3.0, kpiValue * 4.0 / 3.0);
                        warning = new KpiRange(0.0, kpiValue * 2.0 / 3.0);
                        critical = new KpiRange(kpiValue * 4.0 / 3.0, kpiValue * 2.0);
                    }
                    isShow = true;
                }
            }
        }
        int[] sort = new int[]{0, 1, 2};
        if (isShow) {
            double[] v = new double[]{normal.getLowerBound() + normal.getUpperBound(), warning.getLowerBound() + warning.getUpperBound(), critical.getLowerBound() + critical.getUpperBound()};
            int minIndex = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == minIndex || !(v[i] < v[minIndex])) continue;
                minIndex = i;
            }
            int maxIndex = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == maxIndex || !(v[i] > v[maxIndex])) continue;
                maxIndex = i;
            }
            int mid = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == minIndex || i == maxIndex) continue;
                mid = i;
            }
            sort[0] = minIndex;
            sort[1] = mid;
            sort[2] = maxIndex;
        }
        if (!isShow) {
            if (kpiValue == 0.0) {
                kpiValue = 5.0;
            }
            normal = new KpiRange(0.0, kpiValue * 2.0);
            warning = new KpiRange(0.0, 0.0);
            critical = new KpiRange(0.0, 0.0);
            sort[0] = 0;
            sort[1] = 1;
            sort[2] = 2;
            isShow = true;
        }
        DailScopeInfo normaldailScopeInfo = new DailScopeInfo();
        normaldailScopeInfo.setMin(new BigDecimal(normal.getLowerBound()).setScale(rountSize, 4));
        normaldailScopeInfo.setMax(new BigDecimal(normal.getUpperBound()).setScale(rountSize, 4));
        normaldailScopeInfo.setType(2);
        normaldailScopeInfo.setColor(this.soluColor.get("2").toString());
        DailScopeInfo warningldailScopeInfo = new DailScopeInfo();
        warningldailScopeInfo.setMin(new BigDecimal(warning.getLowerBound()).setScale(rountSize, 4));
        warningldailScopeInfo.setMax(new BigDecimal(warning.getUpperBound()).setScale(rountSize, 4));
        warningldailScopeInfo.setType(1);
        warningldailScopeInfo.setColor(this.soluColor.get("1").toString());
        DailScopeInfo criticaldailScopeInfo = new DailScopeInfo();
        criticaldailScopeInfo.setMin(new BigDecimal(critical.getLowerBound()).setScale(rountSize, 4));
        criticaldailScopeInfo.setMax(new BigDecimal(critical.getUpperBound()).setScale(rountSize, 4));
        criticaldailScopeInfo.setType(0);
        criticaldailScopeInfo.setColor(this.soluColor.get("0").toString());
        DailScopeInfo[] temp = new DailScopeInfo[]{normaldailScopeInfo, warningldailScopeInfo, criticaldailScopeInfo};
        this.dailScopeInfoArry = new DailScopeInfo[3];
        for (int i = 0; i < 3; ++i) {
            this.dailScopeInfoArry[i] = temp[sort[i]];
        }
    }

    public void constructWarnParam() throws Exception {
        if (this.kpiInfo == null || this.kpiValueInfo == null) {
            return;
        }
        IKPIWarnParam iKPIWarnParam = this.curCtx != null ? KPIWarnParamFactory.getLocalInstance(this.curCtx) : KPIWarnParamFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("warnGroup.id"));
        sc.add(new SelectorItemInfo("warnGroup.periority"));
        sc.add(new SelectorItemInfo("edgeParam"));
        sc.add(new SelectorItemInfo("paramValue"));
        sc.add(new SelectorItemInfo("currentValue"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)this.kpiValueInfo.getId().toString()));
        view.setFilter(filter);
        this.kpiWarnParamCollection = iKPIWarnParam.getKPIWarnParamCollection(view);
        double kpiValue = this.kpiValueInfo.getKpiValue().doubleValue();
        int rountSize = 2;
        rountSize = this.kpiInfo.getDisplayPrecision();
        if (rountSize < 0 || rountSize > 10) {
            rountSize = 2;
        }
        if (this.kpiInfo.isIsPercent()) {
            rountSize = 4;
        }
        this.generateRange(this.kpiWarnParamCollection, kpiValue, rountSize, this.kpiInfo.isIsPercent());
    }

    public String getCurrUserId() {
        return this.currUserId;
    }

    public void setCurrUserId(String currUserId) {
        this.currUserId = currUserId;
    }

    public KPICollection getKpiCollection() {
        return this.kpiCollection;
    }

    public KPIInfo getKpiInfo() {
        return this.kpiInfo;
    }

    public void setKpiInfo(KPIInfo kpiInfo) {
        this.kpiInfo = kpiInfo;
        this.kpiValueInfo = this.getRecentKpiValueInfo(kpiInfo);
    }

    public KPIWarnParamCollection getKpiWarnParamCollection() {
        return this.kpiWarnParamCollection;
    }

    public HashMap getSoluColor() {
        return this.soluColor;
    }

    public DailScopeInfo[] getDailScopeInfoArry() {
        return this.dailScopeInfoArry;
    }

    public DisplaySchemaInfo getDisplaySchemaInfo() {
        return this.displaySchemaInfo;
    }

    public void setDisplaySchemaInfo(DisplaySchemaInfo displaySchemaInfo) {
        this.displaySchemaInfo = displaySchemaInfo;
    }

    public String getCurrCompanyid() {
        return this.currCompanyid;
    }

    public void setCurrCompanyid(String currCompanyid) {
        this.currCompanyid = currCompanyid;
    }

    public String getKPIValueItemString() {
        if (this.kpiInfo == null) {
            return "";
        }
        KPIValueCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("id");
        selector.add("name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)this.kpiInfo.getId().toString()));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("bizDate");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        try {
            IKPIValue iKpiValue = null;
            iKpiValue = this.curCtx != null ? KPIValueFactory.getLocalInstance(this.curCtx) : KPIValueFactory.getRemoteInstance();
            cols = iKpiValue.getKPIValueCollection(ev);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuffer dcStr = new StringBuffer("");
        if (cols != null) {
            for (int i = 0; i < cols.size(); ++i) {
                KPIValueInfo valueInfo = cols.get(i);
                dcStr.append("<item itemid='");
                dcStr.append(valueInfo.getId());
                dcStr.append("' data='");
                dcStr.append(valueInfo.getId());
                dcStr.append("' desc='");
                dcStr.append(valueInfo.getName(this.curCtx.getLocale()));
                if (i == 0) {
                    dcStr.append("' selected='true");
                }
                dcStr.append("'/>\n");
            }
        }
        return dcStr.toString();
    }

    private KPIValueInfo getRecentKpiValueInfo(KPIInfo kpiInfo) {
        if (kpiInfo == null) {
            return null;
        }
        IKPIValue kpiValue = null;
        KPIValueInfo valueInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiInfo.getId().toString()));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("bizDate");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        try {
            kpiValue = this.curCtx == null ? KPIValueFactory.getRemoteInstance() : KPIValueFactory.getLocalInstance(this.curCtx);
            KPIValueCollection cols = kpiValue.getKPIValueCollection(ev);
            if (cols != null && cols.size() > 0) {
                valueInfo = cols.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return valueInfo;
    }

    public KPIValueInfo getKpiValueInfo() {
        return this.kpiValueInfo;
    }

    public void setKpiValueInfo(KPIValueInfo kpiValueInfo) {
        this.kpiValueInfo = kpiValueInfo;
    }
}

