/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.AnalysisClassEntryCollection;
import com.kingdee.eas.sem.mp.AnalysisClassEntryFactory;
import com.kingdee.eas.sem.mp.AnalysisClassEntryInfo;
import com.kingdee.eas.sem.mp.AnalysisClassFactory;
import com.kingdee.eas.sem.mp.AnalysisClassInfo;
import com.kingdee.eas.sem.mp.AnalysisItemFactory;
import com.kingdee.eas.sem.mp.AnalysisItemInfo;
import com.kingdee.eas.sem.mp.client.AbstractAnalysisClassEditUI;
import com.kingdee.eas.sem.mp.client.AnalysisItemSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisClassEditUI
extends AbstractAnalysisClassEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisClassEditUI.class);
    private HashMap itemMap = new HashMap();
    private HashMap delItemMap = new HashMap();

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionAddItem.setEnabled(true);
        this.actionDelItem.setEnabled(true);
        this.actionMoveUp.setEnabled(true);
        this.actionMoveDown.setEnabled(true);
        this.addItem.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addItem.setToolTipText(EASResource.getString((String)"add"));
        this.delItem.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delItem.setToolTipText(EASResource.getString((String)"delete"));
        this.moveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.moveUp.setToolTipText("\u4e0a\u79fb");
        this.moveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.moveDown.setToolTipText("\u4e0b\u79fb");
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getName() == null || this.editData.getName().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199BI\u5206\u7c7b\u540d\u79f0");
            SysUtil.abort();
        }
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199\u8bf7\u586b\u5199BI\u7c7b\u522b\u7f16\u7801");
            SysUtil.abort();
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit().getCU();
        this.prmtCU.setData((Object)cuInfo);
        super.onLoad();
        this.kdtEntries.getStyleAttributes().setLocked(true);
        KDTSortManager sm = new KDTSortManager(this.kdtEntries);
        sm.setSortAuto(true);
        this.kdtEntries.getColumn("number").setSortable(true);
        this.kdtEntries.getColumn("name").setSortable(true);
    }

    public void loadFields() {
        super.loadFields();
        this.initTable();
    }

    private void initTable() {
        this.itemMap.clear();
        this.delItemMap.clear();
        this.kdtEntries.removeRows();
        this.kdtEntries.checkParsed();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)this.editData.getId()));
        view.getSelector().add(new SelectorItemInfo("item.id"));
        view.getSelector().add(new SelectorItemInfo("item.name"));
        view.getSelector().add(new SelectorItemInfo("item.number"));
        SorterItemInfo sort = new SorterItemInfo("displayOrder");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        AnalysisClassEntryInfo classEntryInfo = null;
        AnalysisClassEntryCollection classEntryCols = null;
        try {
            System.out.println("######before getAnalysisClassEntryCollection()...");
            logger.debug((Object)"######before getAnalysisClassEntryCollection()...");
            classEntryCols = AnalysisClassEntryFactory.getRemoteInstance().getAnalysisClassEntryCollection(view);
            System.out.println("######classEntryCols size:" + classEntryCols.size());
            logger.debug((Object)("######classEntryCols size:" + classEntryCols.size()));
            if (null != classEntryCols && classEntryCols.size() > 0) {
                IRow row = null;
                for (int i = 0; i < classEntryCols.size(); ++i) {
                    classEntryInfo = classEntryCols.get(i);
                    boolean flag = AnalysisItemFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(classEntryInfo.getItem().getId()));
                    if (!flag) continue;
                    row = this.kdtEntries.addRow();
                    row.getCell("id").setValue((Object)classEntryInfo.getItem().getId());
                    row.getCell("name").setValue((Object)classEntryInfo.getItem().getName());
                    row.getCell("number").setValue((Object)classEntryInfo.getItem().getNumber());
                    row.setUserObject((Object)classEntryInfo.getItem());
                    this.itemMap.put(classEntryInfo.getItem().getId().toString(), classEntryInfo.getItem().getId().toString());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList itemList = new ArrayList();
        HashMap confirmMap = new HashMap();
        uiContext.put((Object)"itemList", itemList);
        uiContext.put((Object)"confirmMap", confirmMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(AnalysisItemSelectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (null != confirmMap.get("confirm") && ((Boolean)confirmMap.get("confirm")).booleanValue() && itemList.size() > 0) {
            IRow row = null;
            String clsID = null;
            AnalysisItemInfo itemInfo = null;
            for (int i = 0; i < itemList.size(); ++i) {
                clsID = ((AnalysisItemInfo)itemList.get(i)).getId().toString();
                if (this.checkIsExist(this.kdtEntries, clsID)) continue;
                row = this.kdtEntries.addRow();
                itemInfo = (AnalysisItemInfo)itemList.get(i);
                row.getCell("id").setValue((Object)itemInfo.getId());
                row.getCell("name").setValue((Object)itemInfo.getName());
                row.getCell("number").setValue((Object)itemInfo.getNumber());
                row.setUserObject((Object)itemInfo);
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.classPrepareSubmit();
        super.actionSubmit_actionPerformed(e);
    }

    private void classPrepareSubmit() throws Exception {
        int classCount = this.kdtEntries.getRowCount();
        String clsID = null;
        int size = this.delItemMap.size();
        ArrayList<AnalysisClassEntryInfo> list = new ArrayList<AnalysisClassEntryInfo>();
        if (size > 0) {
            ObjectUuidPK[] delPks = new ObjectUuidPK[size];
            Iterator it = this.delItemMap.keySet().iterator();
            int i = 0;
            AnalysisClassEntryInfo classEntryInfo = null;
            while (it.hasNext()) {
                clsID = (String)it.next();
                Iterator iter = this.editData.getEntries().iterator();
                while (iter.hasNext()) {
                    classEntryInfo = (AnalysisClassEntryInfo)iter.next();
                    if (!clsID.equals(classEntryInfo.getItem().getId().toString())) continue;
                    list.add(classEntryInfo);
                }
                delPks[i] = new ObjectUuidPK(clsID);
                ++i;
            }
            AnalysisClassEntryFactory.getRemoteInstance().delete((IObjectPK[])delPks);
        }
        for (int m = 0; m < list.size(); ++m) {
            this.editData.getEntries().removeObject((IObjectValue)((AnalysisClassEntryInfo)list.get(m)));
        }
        IRow row = null;
        AnalysisItemInfo itemInfo = null;
        AnalysisClassEntryInfo classEntryInfo = null;
        Object obj = null;
        for (int j = 0; j < classCount; ++j) {
            row = this.kdtEntries.getRow(j);
            if (null == row) continue;
            clsID = row.getCell("id").getValue().toString();
            obj = this.itemMap.get(row.getCell("id").getValue().toString());
            if (null == obj) {
                itemInfo = (AnalysisItemInfo)row.getUserObject();
                classEntryInfo = new AnalysisClassEntryInfo();
                classEntryInfo.setId(BOSUuid.create((BOSObjectType)classEntryInfo.getBOSType()));
                classEntryInfo.setParent(this.editData);
                classEntryInfo.setItem(itemInfo);
                classEntryInfo.setDisplayOrder(j);
                this.editData.getEntries().add(classEntryInfo);
                continue;
            }
            Iterator iter = this.editData.getEntries().iterator();
            while (iter.hasNext()) {
                classEntryInfo = (AnalysisClassEntryInfo)iter.next();
                if (!obj.toString().equals(classEntryInfo.getItem().getId().toString())) continue;
                classEntryInfo.setDisplayOrder(j);
            }
        }
    }

    private boolean checkIsExist(KDTable table, String clsId) {
        boolean flag = false;
        int rowCount = table.getRowCount();
        IRow row = null;
        String curID = null;
        for (int i = 0; i < rowCount; ++i) {
            row = table.getRow(i);
            if (null == row || !(curID = row.getCell("id").getValue().toString()).equals(clsId)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void actionDelItem_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.kdtEntries.getSelectManager();
        if (null == this.kdtEntries.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)"\u8bf7\u9009\u62e9\u5206\u7c7b");
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectRows.length > 0) {
            String rowID = null;
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.kdtEntries.getRow(selectRows[i]);
                if (row == null) continue;
                rowID = row.getCell("id").getValue().toString();
                this.delItemMap.put(rowID, rowID);
                row = this.kdtEntries.removeRow(selectRows[i]);
            }
        }
    }

    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.kdtEntries);
    }

    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.kdtEntries);
    }

    private void upRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > 0) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw - 1, selectRow);
            table.getSelectManager().select(selectRpw - 1, 0);
        }
    }

    private void downRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw >= 0 && selectRpw < table.getRowCount() - 1) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw + 1, selectRow);
            table.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    protected void delSelectLine(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            table.removeRow(selectRpw);
        }
    }

    protected IObjectValue createNewData() {
        AnalysisClassInfo aClassInfo = new AnalysisClassInfo();
        aClassInfo.setId(BOSUuid.create((BOSObjectType)aClassInfo.getBOSType()));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        aClassInfo.setCreator(user);
        aClassInfo.setCreateTime(this.getTime());
        aClassInfo.setCU((CtrlUnitInfo)this.prmtCU.getData());
        return aClassInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisClassFactory.getRemoteInstance();
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

