/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.AnalysisItemEntryCollection;
import com.kingdee.eas.sem.mp.AnalysisItemEntryFactory;
import com.kingdee.eas.sem.mp.AnalysisItemEntryInfo;
import com.kingdee.eas.sem.mp.AnalysisItemFactory;
import com.kingdee.eas.sem.mp.AnalysisItemInfo;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.AbstractAnalysisItemEditUI;
import com.kingdee.eas.sem.mp.client.AnalysisItemKPIUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisItemEditUI
extends AbstractAnalysisItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisItemEditUI.class);
    private HashMap kpiMap = new HashMap();
    private HashMap delKpiMap = new HashMap();

    public void onLoad() throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit().getCU();
        this.prmtCU.setData((Object)cuInfo);
        super.onLoad();
        KDTSortManager sm = new KDTSortManager(this.kdtEntries);
        sm.setSortAuto(true);
        this.kdtEntries.getColumn("kpiName").setSortable(true);
        this.kdtEntries.getColumn("orgName").setSortable(true);
        this.kdtEntries.getColumn("kpiName").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("orgName").getStyleAttributes().setLocked(true);
    }

    public void loadFields() {
        super.loadFields();
        this.initTable();
    }

    private void initTable() {
        this.delKpiMap.clear();
        this.kpiMap.clear();
        this.kdtEntries.removeRows();
        this.kdtEntries.checkParsed();
        AnalysisItemEntryInfo entryInfo = null;
        AnalysisItemEntryCollection ItemEntryCols = this.editData.getEntries();
        if (null != ItemEntryCols && ItemEntryCols.size() > 0) {
            IRow row = null;
            for (int i = 0; i < ItemEntryCols.size(); ++i) {
                entryInfo = ItemEntryCols.get(i);
                row = this.kdtEntries.addRow();
                row.getCell("id").setValue((Object)entryInfo.getKpi().getId());
                row.getCell("kpiName").setValue((Object)entryInfo.getKpi().getName());
                row.getCell("orgName").setValue((Object)entryInfo.getKpiCompany().getName());
                row.getCell("orgID").setValue((Object)entryInfo.getKpiCompany().getId());
                entryInfo.getKpi().setPartFI(entryInfo.getKpiCompany());
                row.setUserObject((Object)entryInfo.getKpi());
                this.kpiMap.put(entryInfo.getKpi().getId().toString(), entryInfo.getKpi().getId().toString());
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuBiz.setVisible(false);
        if (this.getOprtState().equalsIgnoreCase("VIEW")) {
            this.actionAddKpi.setEnabled(false);
            this.actionAddClass.setEnabled(false);
            this.actionDelKpi.setEnabled(false);
            this.actionDelClass.setEnabled(false);
        } else {
            this.actionAddKpi.setEnabled(true);
            this.actionAddClass.setEnabled(true);
            this.actionDelKpi.setEnabled(true);
            this.actionDelClass.setEnabled(true);
        }
        this.addKpi.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addKpi.setToolTipText(EASResource.getString((String)"add"));
        this.delKpi.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delKpi.setToolTipText(EASResource.getString((String)"delete"));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getName() == null || this.editData.getName().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199BI\u5206\u7c7b\u540d\u79f0");
            SysUtil.abort();
        }
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199\u8bf7\u586b\u5199BI\u7c7b\u522b\u7f16\u7801");
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.getOprtState().equalsIgnoreCase("EDIT")) {
            this.actionAddKpi.setEnabled(true);
            this.actionAddClass.setEnabled(true);
            this.actionDelKpi.setEnabled(true);
            this.actionDelClass.setEnabled(true);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionAddKpi_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList kpiList = new ArrayList();
        HashMap confirmMap = new HashMap();
        uiContext.put((Object)"kpiList", kpiList);
        uiContext.put((Object)"aList", (Object)this.getKpiList());
        uiContext.put((Object)"confirmMap", confirmMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(AnalysisItemKPIUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (null != confirmMap.get("confirm") && ((Boolean)confirmMap.get("confirm")).booleanValue() && kpiList.size() > 0) {
            KPIInfo kpiInfo = null;
            IRow row = null;
            for (int i = 0; i < kpiList.size(); ++i) {
                kpiInfo = (KPIInfo)kpiList.get(i);
                if (this.checkIsExist(this.kdtEntries, kpiInfo.getId().toString())) continue;
                row = this.kdtEntries.addRow();
                row.getCell("id").setValue((Object)kpiInfo.getId());
                row.getCell("kpiName").setValue((Object)kpiInfo.getName());
                row.getCell("orgName").setValue((Object)kpiInfo.getPartFI().getName());
                row.getCell("orgID").setValue((Object)kpiInfo.getPartFI().getId());
                row.setUserObject((Object)kpiInfo);
            }
        }
    }

    private List getKpiList() {
        ArrayList<KPIInfo> list = new ArrayList<KPIInfo>();
        int count = this.kdtEntries.getRowCount();
        IRow row = null;
        KPIInfo kpiInfo = null;
        CompanyOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < count; ++i) {
            row = this.kdtEntries.getRow(i);
            kpiInfo = new KPIInfo();
            orgUnitInfo = new CompanyOrgUnitInfo();
            kpiInfo.setPartFI(orgUnitInfo);
            kpiInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            kpiInfo.setName(row.getCell("kpiName").getValue().toString());
            kpiInfo.getPartFI().setName(row.getCell("orgName").getValue().toString());
            kpiInfo.getPartFI().setId(BOSUuid.read((String)row.getCell("orgID").getValue().toString()));
            list.add(kpiInfo);
        }
        return list;
    }

    public void actionDelKpi_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.kdtEntries.getSelectManager();
        if (null == this.kdtEntries.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)"\u8bf7\u9009\u62e9KPI");
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectRows.length > 0) {
            String rowID = null;
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.kdtEntries.getRow(selectRows[i]);
                if (row == null) continue;
                rowID = row.getCell("id").getValue().toString();
                this.delKpiMap.put(rowID, rowID);
                this.kpiMap.remove(rowID);
                row = this.kdtEntries.removeRow(selectRows[i]);
            }
        }
    }

    private boolean checkIsExist(KDTable table, String clsId) {
        boolean flag = false;
        int rowCount = table.getRowCount();
        IRow row = null;
        String curID = null;
        for (int i = 0; i < rowCount; ++i) {
            row = table.getRow(i);
            if (null == row || !(curID = row.getCell("id").getValue().toString()).equals(clsId)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        AnalysisItemInfo itemInfo = new AnalysisItemInfo();
        itemInfo.setId(BOSUuid.create((BOSObjectType)itemInfo.getBOSType()));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        itemInfo.setCreator(user);
        itemInfo.setCreateTime(this.getTime());
        itemInfo.setCU((CtrlUnitInfo)this.prmtCU.getData());
        return itemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AnalysisItemFactory.getRemoteInstance();
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.kpiPrepareSubmit();
        super.actionSubmit_actionPerformed(e);
    }

    private void kpiPrepareSubmit() throws Exception {
        int classCount = this.kdtEntries.getRowCount();
        String clsID = null;
        int size = this.delKpiMap.size();
        ArrayList<AnalysisItemEntryInfo> list = new ArrayList<AnalysisItemEntryInfo>();
        if (size > 0) {
            ObjectUuidPK[] delPks = new ObjectUuidPK[this.delKpiMap.size()];
            Iterator it = this.delKpiMap.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                clsID = (String)it.next();
                Iterator iter = this.editData.getEntries().iterator();
                while (iter.hasNext()) {
                    AnalysisItemEntryInfo entryInfo = (AnalysisItemEntryInfo)iter.next();
                    if (!clsID.equals(entryInfo.getKpi().getId().toString())) continue;
                    list.add(entryInfo);
                }
                delPks[i] = new ObjectUuidPK(clsID);
                ++i;
            }
            AnalysisItemEntryFactory.getRemoteInstance().delete((IObjectPK[])delPks);
        }
        for (int m = 0; m < list.size(); ++m) {
            this.editData.getEntries().removeObject((IObjectValue)((AnalysisItemEntryInfo)list.get(m)));
        }
        IRow row = null;
        KPIInfo kpiInfo = null;
        AnalysisItemEntryInfo itemEntryInfo = null;
        for (int j = 0; j < classCount; ++j) {
            row = this.kdtEntries.getRow(j);
            if (null == row) continue;
            clsID = row.getCell("id").getValue().toString();
            if (null != this.kpiMap.get(row.getCell("id").getValue().toString())) continue;
            kpiInfo = (KPIInfo)row.getUserObject();
            itemEntryInfo = new AnalysisItemEntryInfo();
            itemEntryInfo.setId(BOSUuid.create((BOSObjectType)itemEntryInfo.getBOSType()));
            itemEntryInfo.setParent(this.editData);
            itemEntryInfo.setKpi(kpiInfo);
            itemEntryInfo.setKpiCompany(kpiInfo.getPartFI());
            this.editData.getEntries().add(itemEntryInfo);
        }
    }
}

