/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FindLedger;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.MPResUtil;
import com.kingdee.eas.sem.mp.client.AbstractAnalysisItemKPIUI;
import com.kingdee.eas.sem.mp.client.KPISimpleEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisItemKPIUI
extends AbstractAnalysisItemKPIUI {
    private static final Logger logger = CoreUIObject.getLogger(AnalysisItemKPIUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    protected String currentCompanyId;
    private Map confirmMap;
    private boolean isConfrimImport = false;

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    public void onLoad() throws Exception {
        this.confirmMap = (Map)this.getUIContext().get("confirmMap");
        this.btnAutoCalculate.setVisible(true);
        this.btnAutoCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnAutoCalculate.setEnabled(true);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
        this.btnImportData.setEnabled(true);
        super.onLoad();
        CompanyOrgUnitInfo currentAdminOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (currentAdminOrg != null) {
            if (currentAdminOrg.getInvalidDate() != null && currentAdminOrg.getInvalidDate().before(new Date())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                SysUtil.abort();
            }
        } else {
            String resource = "com.kingdee.eas.sem.mp.MPResource";
            String strMsg = EASResource.getString((String)resource, (String)"currOrgNotAdminOrg");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
        this.actionQuery.setVisible(false);
        this.initRightTable();
    }

    private void initRightTable() {
        KPIInfo kpiInfo = null;
        List list = (List)this.getUIContext().get("aList");
        Iterator it = list.iterator();
        IRow rightRow = null;
        while (it.hasNext()) {
            kpiInfo = (KPIInfo)it.next();
            rightRow = this.rightTable.addRow();
            rightRow.getCell("id").setValue((Object)kpiInfo.getId());
            rightRow.getCell("name").setValue((Object)kpiInfo.getName());
            rightRow.getCell("company.name").setValue((Object)kpiInfo.getPartFI().getName());
            rightRow.getCell("company.id").setValue((Object)kpiInfo.getPartFI().getId());
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAssign.setEnabled(true);
        this.btnEnable.setVisible(false);
        this.btnDisable.setVisible(false);
        this.btnImportData.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"import"));
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.actionSingleRight.setEnabled(true);
        this.actionSingleLeft.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionImport.setVisible(false);
        this.actionExport.setVisible(false);
        this.actionAutoCalculate.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.actionView.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAssign.setVisible(false);
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    public IKPI getKPIInterface() throws Exception {
        return KPIFactory.getRemoteInstance();
    }

    protected void findLedger(String findType, KPIInfo kpiInfo) {
        try {
            ArrayList expresions = this.getCurrCellexpresion(kpiInfo);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"expressions", (Object)expresions);
            uiContext.put((Object)"report", (Object)this.getEditData(kpiInfo));
            uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
            uiContext.put((Object)"rptSheetParam", (Object)this.getCurrParam(kpiInfo));
            uiContext.put((Object)"type", (Object)findType);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(FindLedger.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            if (expresions != null && expresions.size() > 1) {
                uiWindow.show();
            }
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    public RptSheetParamInfo getCurrParam(KPIInfo kpiInfo) throws Exception {
        RptSheetParamInfo rptSheetParamInfo = new RptSheetParamInfo();
        IInitDataFacada iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
        PeriodInfo periodInfo = iInitDataFacada.getCurrentFiscal();
        rptSheetParamInfo.setStartYear(periodInfo.getPeriodYear());
        rptSheetParamInfo.setStartPeriod(periodInfo.getPeriodNumber());
        rptSheetParamInfo.setEndYear(periodInfo.getPeriodYear());
        rptSheetParamInfo.setEndPeriod(periodInfo.getPeriodNumber());
        rptSheetParamInfo.setStartDate(periodInfo.getBeginDate());
        rptSheetParamInfo.setEndDate((Date)periodInfo.getEndDate());
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("where number ='GLC'");
        if (currencyCollection != null && currencyCollection.size() > 0) {
            rptSheetParamInfo.setCurrency(currencyCollection.get(0));
        }
        rptSheetParamInfo.setIsIncludingUnposted(kpiInfo.isIsUnpassedVoucherIncluded());
        return rptSheetParamInfo;
    }

    public ReportInfo getEditData(KPIInfo kpiInfo) throws Exception {
        ReportInfo reportInfo = new ReportInfo();
        CompanyOrgUnitInfo ou = kpiInfo.getPartFI();
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getRemoteInstance().getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        CompanyOrgUnitInfo companyInfo = ou == null ? RptUtilForClient.getCurrentCompany() : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ou.getId()));
        reportInfo.setCompany(companyInfo);
        return reportInfo;
    }

    public ArrayList getCurrCellexpresion(KPIInfo kpiInfo) throws ParserException {
        ArrayList formulaList;
        String formula = kpiInfo.getFormula();
        if (formula == null || formula.length() == 0) {
            MsgBox.showInfo((String)("KPI" + MPResUtil.getRes("NoFormula")));
            SysUtil.abort();
        }
        if ((formulaList = (ArrayList)TableToolkit.parseFormula((String)(formula = "=" + formula), (boolean)true)) == null || formulaList.size() == 0) {
            MsgBox.showInfo((String)("KPI" + MPResUtil.getRes("NoFormula")));
            SysUtil.abort();
        }
        return formulaList;
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return KPISimpleEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        Object obj = e.getSource();
        if (obj.equals(this.btnAddNew) || obj.equals(this.menuItemAddNew)) {
            OrgStructureInfo org = this.getSelectObjectInfo();
            String orgId = org != null ? org.getUnit().getId().toString() : null;
            uiContext.put((Object)"company", (Object)orgId);
        }
    }

    protected void initTree() throws Exception {
    }

    protected void execQuery() {
        super.execQuery();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return KPIFactory.getRemoteInstance();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.buildTreeFilter();
        this.execQuery();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    public boolean isConfrimImport() {
        return this.isConfrimImport;
    }

    public void setConfrimImport(boolean isConfrimImport) {
        this.isConfrimImport = isConfrimImport;
    }

    public void actionSingleRight_actionPerformed(ActionEvent e) throws Exception {
        int[] selectCount = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        IRow rightRow = null;
        String curID = null;
        String orgID = null;
        boolean isTip = false;
        for (int i = 0; i < selectCount.length; ++i) {
            row = this.tblMain.getRow(selectCount[i]);
            if (null == row) continue;
            curID = row.getCell("id").getValue().toString();
            orgID = row.getCell("company.id").getValue().toString();
            if (this.checkIsExist(curID, "id")) continue;
            if (this.checkIsExist(orgID, "company.id")) {
                isTip = true;
                continue;
            }
            rightRow = this.rightTable.addRow();
            rightRow.getCell("id").setValue(row.getCell("id").getValue());
            rightRow.getCell("name").setValue(row.getCell("name").getValue());
            rightRow.getCell("company.name").setValue(row.getCell("company.name").getValue());
            rightRow.getCell("company.id").setValue(row.getCell("company.id").getValue());
        }
        if (isTip) {
            MsgBox.showInfo((String)"\u4e00\u4e2a\u7ec4\u7ec7\u4e0b\u53ea\u80fd\u9009\u62e9\u4e00\u4e2aKPI");
            return;
        }
    }

    private boolean checkIsExist(String clsId, String destStr) {
        boolean flag = false;
        int rowCount = this.rightTable.getRowCount();
        IRow row = null;
        String curID = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.rightTable.getRow(i);
            if (null == row || !(curID = row.getCell(destStr).getValue().toString()).equals(clsId)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void actionSingleLeft_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.rightTable.getSelectManager();
        if (null == this.rightTable.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)"\u8bf7\u9009\u62e9KPI");
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.rightTable);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.rightTable.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.rightTable.removeRow(selectRows[i]);
            }
        }
    }

    protected void ok_actionPerformed(ActionEvent e) throws Exception {
        this.confirmMap.put("confirm", true);
        int rowCount = this.rightTable.getRowCount();
        List kList = (List)this.getUIContext().get("kpiList");
        IRow row = null;
        KPIInfo kpiInfo = null;
        CompanyOrgUnitInfo org = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.rightTable.getRow(i);
            kpiInfo = new KPIInfo();
            org = new CompanyOrgUnitInfo();
            kpiInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            kpiInfo.setName(row.getCell("name").getValue().toString());
            org.setName(row.getCell("company.name").getValue().toString());
            org.setId(BOSUuid.read((String)row.getCell("company.id").getValue().toString()));
            kpiInfo.setPartFI(org);
            kList.add(kpiInfo);
        }
        this.getUIWindow().close();
    }

    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        this.confirmMap.put("confirm", false);
        this.getUIWindow().close();
    }
}

