/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.AbstractAssignKpiUI;
import com.kingdee.eas.sem.mp.client.FormulaParamSetUI;
import com.kingdee.eas.sem.mp.client.KPISortManager;
import com.kingdee.eas.sem.mp.client.SelectKPINewUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssignKpiUI
extends AbstractAssignKpiUI {
    private static final Logger logger = CoreUIObject.getLogger(AssignKpiUI.class);
    private String resource = "com.kingdee.eas.sem.mp.client.KPIResource";
    private HashSet kpiSet = new HashSet();
    private HashMap companyMap = new HashMap();
    private String orgId;
    private HashMap params;
    private String acctItemParam;
    private String dyItemParam;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParams();
        this.initKPITable();
        this.initCompanyTable();
        this.initButton();
    }

    private void initButton() {
        this.btnAddCompany.setEnabled(true);
        this.btnDelCompany.setEnabled(true);
        this.btnAddKPI.setEnabled(true);
        this.btnDelKpi.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnAddCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAddKPI.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelKpi.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnAddCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSetParams.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
    }

    private void initParams() {
        this.orgId = this.getUIContext().get("currentOrgID").toString();
        this.params = (HashMap)this.getUIContext().get("params");
        this.params.put("isConfirm", Boolean.FALSE);
    }

    private void initCompanyTable() {
        this.companyTable.checkParsed();
        this.companyTable.getStyleAttributes().setLocked(true);
        this.companyTable.getSelectManager().setSelectMode(10);
        KPISortManager sm = new KPISortManager(this.companyTable);
        sm.setSortAuto(true);
        this.companyTable.getColumn("number").setSortable(true);
        this.companyTable.getColumn("name").setSortable(true);
    }

    private void initKPITable() {
        this.kpiTable.checkParsed();
        this.kpiTable.getStyleAttributes().setLocked(true);
        this.kpiTable.getSelectManager().setSelectMode(10);
        this.initKpiTable();
    }

    private void initKpiTable() {
        Object obj = this.getUIContext().get("selectKpis");
        if (obj != null && obj instanceof List) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("timeType");
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            int i = 0;
            Iterator ite = ((List)obj).iterator();
            StringBuffer mark = new StringBuffer();
            while (ite.hasNext()) {
                if (i == 0) {
                    mark.append(" #").append(i);
                } else {
                    mark.append(" or #").append(i);
                }
                filter.getFilterItems().add(new FilterItemInfo("id", ite.next(), CompareType.EQUALS));
                ++i;
            }
            filter.setMaskString(mark.toString());
            ev.setSelector(selector);
            ev.setFilter(filter);
            try {
                KPICollection kpiCols = KPIFactory.getRemoteInstance().getKPICollection(ev);
                this.loadKpiTableValue(kpiCols);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadKpiTableValue(KPICollection kpiCols) {
        if (kpiCols != null) {
            Iterator ite = kpiCols.iterator();
            this.kpiSet.clear();
            while (ite.hasNext()) {
                KPIInfo kpiInfo = (KPIInfo)ite.next();
                this.kpiSet.add(kpiInfo.getId().toString());
                IRow row = this.kpiTable.addRow();
                row.getCell("id").setValue((Object)kpiInfo.getId().toString());
                row.getCell("number").setValue((Object)kpiInfo.getNumber());
                row.getCell("name").setValue((Object)kpiInfo.getName());
                row.getCell("dateType").setValue((Object)kpiInfo.getTimeType());
            }
        }
    }

    public void actionSetParam_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        uiContext.put((Object)"Data", map);
        map.put("isConfirm", Boolean.FALSE);
        uiContext.put((Object)"ImportKpiF7UI", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(FormulaParamSetUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        Object obj = map.get("isConfirm");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            obj = map.get("acctItemParam");
            if (obj != null && obj instanceof RptSrcTypeEnum) {
                this.acctItemParam = ((RptSrcTypeEnum)obj).getName();
            }
            if ((obj = map.get("dyitemparam")) != null && obj instanceof RptSrcTypeEnum) {
                this.dyItemParam = ((RptSrcTypeEnum)obj).getName();
            }
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isParamSet.isSelected()) {
            if (this.acctItemParam == null || this.dyItemParam == null) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"kpi_params_set"));
                return;
            }
            this.params.put("setKpiParams", Boolean.TRUE);
            this.params.put("dyitemparam", this.dyItemParam);
            this.params.put("acctItemParam", this.acctItemParam);
        }
        if (this.kpiSet == null || this.kpiSet.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"select_assign_kpi"));
            return;
        }
        if (this.companyMap == null || this.companyMap.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"company_select"));
            return;
        }
        int index = this.assignType.getSelectedIndex();
        this.params.put("isConfirm", Boolean.TRUE);
        this.params.put("kpi", this.kpiSet);
        this.params.put("comapny", this.companyMap);
        this.params.put("assignType", new Integer(index));
        this.getUIWindow().close();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.params.put("isConfirm", Boolean.FALSE);
        this.getUIWindow().close();
    }

    public void actionAddCompany_actionPerformed(ActionEvent e) throws Exception {
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(this.orgId);
        af7.setCheckedOrgIDs(this.companyMap.keySet());
        af7.show();
        Object obj = af7.getData();
        if (obj instanceof OrgUnitInfo[]) {
            this.companyTable.removeRows();
            this.companyMap.clear();
            OrgUnitInfo[] tempOrgInfo = (OrgUnitInfo[])obj;
            if (tempOrgInfo != null && tempOrgInfo.length > 0) {
                for (int i = 0; i < tempOrgInfo.length; ++i) {
                    IRow tempRow = this.companyTable.addRow();
                    this.companyMap.put(((CompanyOrgUnitInfo)tempOrgInfo[i]).getId().toString(), tempOrgInfo[i]);
                    tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                    tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                    tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                    tempRow.setUserObject((Object)tempOrgInfo);
                }
            }
        }
    }

    public void actionAddKPI_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList list = new ArrayList();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isConfirm", Boolean.FALSE);
        uiContext.put((Object)"Data", list);
        uiContext.put((Object)"currentOrg", (Object)this.orgId);
        uiContext.put((Object)"params", params);
        uiContext.put((Object)"hasSelected", (Object)this.kpiSet);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(SelectKPINewUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        Object obj = params.get("isConfirm");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue() && list != null) {
            for (KPIInfo kpiInfo : list) {
                if (this.kpiSet.contains(kpiInfo.getId().toString())) continue;
                this.kpiSet.add(kpiInfo.getId().toString());
                IRow irow = this.kpiTable.addRow();
                irow.getCell("id").setValue((Object)kpiInfo.getId());
                irow.getCell("number").setValue((Object)kpiInfo.getNumber());
                irow.getCell("name").setValue((Object)kpiInfo.getName());
                irow.getCell("dateType").setValue((Object)kpiInfo.getTimeType());
            }
        }
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.companyTable);
        if (rowID != null && rowID.length > 0) {
            IRow iRow = null;
            for (int count = rowID.length - 1; count >= 0; --count) {
                iRow = this.companyTable.getRow(rowID[count]);
                if (null == iRow) continue;
                String companyId = iRow.getCell(0).getValue().toString();
                this.companyTable.removeRow(rowID[count]);
                this.companyMap.remove(companyId);
            }
        } else {
            MsgBox.showConfirm2((String)EASResource.getString((String)this.resource, (String)"no_select"));
            return;
        }
    }

    public void actionDelKPI_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.kpiTable);
        if (rowID != null && rowID.length > 0) {
            IRow iRow = null;
            for (int count = rowID.length - 1; count >= 0; --count) {
                iRow = this.kpiTable.getRow(rowID[count]);
                if (null == iRow) continue;
                String kpiId = iRow.getCell(0).getValue().toString();
                this.kpiTable.removeRow(rowID[count]);
                this.kpiSet.remove(kpiId);
            }
        } else {
            MsgBox.showConfirm2((String)EASResource.getString((String)this.resource, (String)"no_select"));
            return;
        }
    }

    protected void isParamSet_itemStateChanged(ItemEvent e) throws Exception {
        if (this.isParamSet.isSelected()) {
            this.btnSetParams.setEnabled(true);
        } else {
            this.btnSetParams.setEnabled(false);
        }
    }
}

