/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.basedata.common.BasedataSysException;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.sem.mp.BSCCollection;
import com.kingdee.eas.sem.mp.BSCFactory;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.IBSC;
import com.kingdee.eas.sem.mp.client.AbstractBSCEditUI;
import com.kingdee.eas.sem.mp.util.MCUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BSCEditUI
extends AbstractBSCEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BSCEditUI.class);
    private AdminOrgUnitInfo adminOrgInfo;
    private CompanyOrgUnitInfo companyOrgInfo;
    private int bscSize;
    private boolean isEditOprt;
    private BSCLogic bscLogic = new BSCLogic();
    private BSCInfo parentInfo = null;
    private String selectItemID = null;

    public void onLoad() throws Exception {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.getContextData();
        this.bscLogic.initNewBSCTree();
        this.bscLogic.buildBSCValueTree();
        this.addMouseListenerToBSCTree();
        super.onLoad();
        this.txtOrg.setEnabled(false);
        this.txtOrg.setEditable(false);
        Object obj = this.BSCCollectionTreeValue.getLastSelectedPathComponent();
        DefaultKingdeeTreeNode selectNode = null;
        if (obj != null && obj instanceof DefaultKingdeeTreeNode) {
            selectNode = (DefaultKingdeeTreeNode)obj;
        } else if (obj != null && obj instanceof KDTreeNode) {
            selectNode = (DefaultKingdeeTreeNode)obj;
        }
        BSCInfo selectBscInfo = null;
        if (null != selectNode && selectNode.isRoot()) {
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(true);
        } else {
            if (selectNode != null && selectNode.getUserObject() instanceof BSCInfo) {
                selectBscInfo = (BSCInfo)selectNode.getUserObject();
            }
            if (OprtState.EDIT.equals(this.getOprtState())) {
                if (this.checkCanModify(selectBscInfo)) {
                    this.btnEdit.setEnabled(true);
                    this.btnSave.setEnabled(true);
                    this.mltName.setEditable(true);
                } else {
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.mltName.setEditable(false);
                }
            } else if (OprtState.VIEW.equals(this.getOprtState())) {
                if (this.checkCanModify(selectBscInfo)) {
                    this.btnEdit.setEnabled(true);
                    this.btnSave.setEnabled(false);
                } else {
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                }
            } else {
                this.btnEdit.setEnabled(false);
                this.btnSave.setEnabled(true);
            }
        }
        this.btnSave.setEnabled(false);
        this.txtNumber.setMaxLength(80);
        this.mltName.setMaxLength(255);
        this.mltDesc.setMaxLength(255);
    }

    private void getContextData() {
        this.setValueForAdminOrgInfo();
        this.setSelectItemID();
    }

    private void setValueForAdminOrgInfo() {
        OrgStructureInfo info = (OrgStructureInfo)this.getUIContext().get("selectObjectInfo");
        BOSUuid adminOrgId = info.getUnit().getId();
        try {
            this.adminOrgInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId.toString()));
            this.companyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId.toString()));
        }
        catch (Exception e) {
            logger.info((Object)"sem_mp: setValueForAdminOrgInfo error!");
            e.printStackTrace();
        }
    }

    private void setSelectItemID() {
        if (this.getUIContext().get("selectItemID") != null) {
            this.selectItemID = (String)this.getUIContext().get("selectItemID");
        }
    }

    public void loadFields() {
        super.loadFields();
        this.isEditOprt = !this.getOprtState().equalsIgnoreCase("edit") || !this.isEditOprt;
        this.txtOrg.setData((Object)this.companyOrgInfo);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        boolean isAdd = "ADDNEW".equals(this.getOprtState());
        this.txtNumber.setEditable(isAdd);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkCanModify()) {
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.isEditOprt = true;
        this.changeCompState(true);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("partfi.id"));
        sic.add(new SelectorItemInfo("isRef"));
        sic.add(new SelectorItemInfo("partfi.number"));
        sic.add(new SelectorItemInfo("refBSC.isModifiable"));
        sic.add(new SelectorItemInfo("isModifiable"));
        return sic;
    }

    private boolean checkCanModify() {
        return this.editData.getRefBSC() == null || this.editData.getRefBSC().isIsModifiable();
    }

    private boolean checkCanModify(BSCInfo bscInfo) {
        if (bscInfo != null) {
            if (!bscInfo.isIsRef()) {
                return true;
            }
            if (bscInfo.getRefBSC() != null) {
                return bscInfo.getRefBSC().isIsModifiable();
            }
            return false;
        }
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
        this.changeCompState(true);
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.setRequestFocusEnabled(true);
            this.txtNumber.requestFocusInWindow();
            throw new BasedataSysException(BasedataSysException.NUMBER_IS_EMPTY);
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.mltName, (IObjectValue)this.editData, (String)"name");
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.mltName.setRequestFocusEnabled(true);
            this.mltName.requestFocusInWindow();
            throw new BasedataSysException(BasedataSysException.NAME_IS_EMPTY);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkCanModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)MCUtil.getString("refNotModify"));
            this.abort();
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.BSCCollectionTreeValue.getModel().getRoot();
        TreePath tempTreePath = this.BSCCollectionTreeValue.getSelectionPath();
        if (null != root) {
            BSCInfo parentBsc = (BSCInfo)root.getUserObject();
            this.editData.setParent(parentBsc);
        }
        this.setOprtState(OprtState.EDIT);
        super.actionSubmit_actionPerformed(e);
        this.bscLogic.buildBSCValueTree();
        BSCInfo bscInfo = this.editData;
        this.btnRemove.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.txtNumber.setEditable(false);
        this.mltName.setEnabled(false);
        this.mltDesc.setEditable(false);
        this.BSCCollectionTreeValue.setSelectionPath(tempTreePath);
        this.SelectNode(this.editData);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            this.bscLogic.buildBSCValueTree();
            this.setValToComp((BSCInfo)((DefaultKingdeeTreeNode)this.BSCCollectionTreeValue.getModel().getRoot()).getUserObject());
            this.BSCCollectionTreeValue.setSelectionNode((DefaultKingdeeTreeNode)this.BSCCollectionTreeValue.getModel().getRoot());
            this.setSave(true);
            this.setSaved(true);
        }
    }

    protected IObjectValue createNewData() {
        BSCInfo info = new BSCInfo();
        info.setCompany(this.adminOrgInfo);
        info.setPartFI(this.companyOrgInfo);
        info.setIsModifiable(true);
        info.setIsRef(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BSCFactory.getRemoteInstance();
    }

    private void addMouseListenerToBSCTree() {
        this.BSCCollectionTreeValue.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TreePath path = BSCEditUI.this.BSCCollectionTreeValue.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    BSCInfo info = (BSCInfo)node.getUserObject();
                    String rootNodeID = ((BSCInfo)((DefaultKingdeeTreeNode)BSCEditUI.this.BSCCollectionTreeValue.getModel().getRoot()).getUserObject()).getId().toString();
                    if (info != null) {
                        BSCEditUI.this.setValToComp(info);
                        if (info.getId().toString().equalsIgnoreCase(rootNodeID)) {
                            BSCEditUI.this.btnRemove.setEnabled(false);
                            BSCEditUI.this.btnEdit.setEnabled(false);
                            BSCEditUI.this.btnSave.setEnabled(false);
                            return;
                        }
                        BSCEditUI.this.btnRemove.setEnabled(true);
                        BSCEditUI.this.changeCompState(false);
                        if (BSCEditUI.this.checkCanModify(info)) {
                            BSCEditUI.this.btnEdit.setEnabled(true);
                            BSCEditUI.this.btnSave.setEnabled(true);
                        } else {
                            BSCEditUI.this.btnEdit.setEnabled(false);
                            BSCEditUI.this.btnSave.setEnabled(false);
                        }
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void setValToComp(BSCInfo info) {
        this.setDataObject((IObjectValue)info);
        this.loadFields();
        this.setOprtState(OprtState.VIEW);
    }

    private void changeCompState(boolean isEditable) {
        if (!isEditable) {
            this.actionEdit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.txtNumber.setEditable(false);
            this.mltName.setEditable(false);
            this.mltDesc.setEditable(false);
            this.btnEdit.setEnabled(false);
            this.btnSubmit.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(true);
            this.actionSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.txtNumber.setEditable(OprtState.ADDNEW.equals(this.getOprtState()));
            this.mltName.setEnabled(true);
            this.mltName.setEditable(true);
            this.mltDesc.setEditable(true);
            if (this.editData.getRefBSC() != null) {
                this.txtNumber.setEditable(false);
                this.mltName.setEditable(false);
            }
        }
        TreePath path = this.BSCCollectionTreeValue.getSelectionPath();
        if (null != path) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            String rootNodeID = ((BSCInfo)((DefaultKingdeeTreeNode)this.BSCCollectionTreeValue.getModel().getRoot()).getUserObject()).getId().toString();
            BSCInfo info = (BSCInfo)node.getUserObject();
            if (info != null) {
                if (!info.getId().toString().toString().trim().equalsIgnoreCase(rootNodeID.trim())) {
                    this.btnRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                }
                this.btnEdit.setEnabled(true);
            }
        }
    }

    public int getBscSize() {
        return this.bscSize;
    }

    public void setBscSize(int bscSize) {
        this.bscSize = bscSize;
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        IObjectValue subMitValue = null;
        try {
            Object objectNumber;
            if (!(OprtState.ADDNEW.equals(this.getOprtState()) && this.chkMenuItemSubmitAndAddNew.isSelected() || (objectNumber = (subMitValue = this.getValue(pk)).get("number")) == null)) {
                this.editData.setString("number", objectNumber.toString());
            }
            this.getUIContext().put("ID", pk.toString());
            this.getUIContext().put("InitDataObject", subMitValue);
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.showMessageForStatus();
        this.showSubmitSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int size = this.idList.size();
            this.idList.add(size, pk.toString());
        }
        if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.addToDataMap((Object)pk.toString(), (Object)pk.toString());
        }
        this.actionCopy.setEnabled(true);
        this.setSave(true);
        this.setSaved(true);
        this.afterSubmitPerform(pk);
    }

    private void afterSubmitPerform(IObjectPK pk) throws Exception {
        this.updateButtonStatus();
        this.afterSubmitEdit(pk);
        this.initOldData((IObjectValue)this.editData);
    }

    protected void SelectNode(BSCInfo bscInfo) throws EASBizException, BOSException, Exception {
        this.BSCCollectionTreeValue.setSelectionRow(0);
        DefaultKingdeeTreeNode selectNode = this.getSelectedTreeNode();
        if (!(selectNode.getUserObject() instanceof DefaultKingdeeTreeNode)) {
            selectNode = this.getSelectedTreeNode();
        }
        String bscId = this.editData.getId().toString();
        this.getSelectNode(bscId, selectNode);
        this.btnRemove.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnSave.setEnabled(true);
    }

    private void getSelectNode(String bscId, DefaultKingdeeTreeNode selectNode) throws Exception {
        if (selectNode.getChildCount() == 0) {
            return;
        }
        int leng = selectNode.getChildCount();
        for (int j = 0; j < leng; ++j) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)selectNode.getChildAt(j);
            BSCInfo tempTree = (BSCInfo)tempNode.getUserObject();
            if (bscId.equals(tempTree.getId().toString())) {
                this.BSCCollectionTreeValue.setSelectionNode(tempNode);
                break;
            }
            this.getSelectNode(bscId, tempNode);
        }
    }

    public DefaultKingdeeTreeNode getSelectedTreeNode() {
        return (DefaultKingdeeTreeNode)this.BSCCollectionTreeValue.getLastSelectedPathComponent();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    private class BSCLogic {
        private BSCLogic() {
        }

        public void buildBSCValueTree() throws BOSException {
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            BSCCollection bscCols = this.getBSC();
            KDTreeNode selectedNode = null;
            KDTreeNode bscNode = null;
            BSCInfo bscInfo = null;
            int num = bscCols.size();
            for (int i = 0; i < num; ++i) {
                bscInfo = bscCols.get(i);
                if (!bscInfo.isIsRef()) {
                    bscNode = new KDTreeNode((Object)bscInfo);
                    root.add((MutableTreeNode)bscNode);
                } else {
                    BSCEditUI.this.parentInfo = bscInfo;
                }
                if (null == BSCEditUI.this.selectItemID || !bscInfo.getId().toString().trim().equalsIgnoreCase(BSCEditUI.this.selectItemID.trim())) continue;
                selectedNode = bscNode;
            }
            root.setUserObject((Object)BSCEditUI.this.parentInfo);
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
            BSCEditUI.this.BSCCollectionTreeValue.setModel((TreeModel)model);
            if (OprtState.ADDNEW.equals(BSCEditUI.this.getOprtState())) {
                BSCEditUI.this.BSCCollectionTreeValue.setSelectionNode((DefaultKingdeeTreeNode)BSCEditUI.this.BSCCollectionTreeValue.getModel().getRoot());
            } else {
                BSCEditUI.this.BSCCollectionTreeValue.setSelectionNode(selectedNode);
            }
        }

        private BSCCollection getBSC() throws BOSException {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isRef"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("refBSC.isModifiable"));
            sic.add(new SelectorItemInfo("isModifiable"));
            IBSC bsc = BSCFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)BSCEditUI.this.companyOrgInfo.getId()));
            evi.setFilter(filter);
            evi.setSelector(sic);
            return bsc.getBSCCollection(evi);
        }

        public void initNewBSCTree() throws BOSException, EASBizException {
            if (null == this.getBSC() || this.getBSC().size() == 0) {
                IBSC bsc = BSCFactory.getRemoteInstance();
                BSCInfo basInfo = new BSCInfo();
                basInfo.setNumber("BSC");
                basInfo.setName("BSC", LocaleUtils.getLocale((String)"L1"));
                basInfo.setName("BSC", LocaleUtils.getLocale((String)"L2"));
                basInfo.setName("BSC", LocaleUtils.getLocale((String)"L3"));
                basInfo.setIsRef(true);
                basInfo.setParent(null);
                basInfo.setPartFI(BSCEditUI.this.companyOrgInfo);
                bsc.addnew((CoreBaseInfo)basInfo);
            }
        }
    }
}

