/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.sem.mp.BGCompanyMapFacadeFactory;
import com.kingdee.eas.sem.mp.IBGCompanyMapFacade;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.SemMPHelper;
import com.kingdee.eas.sem.mp.client.AbstractBgOrgUnitSetUI;
import com.kingdee.eas.sem.mp.client.NumberExpandInfo;
import com.kingdee.eas.sem.mp.client.NumberExpendRender;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgOrgUnitSetUI
extends AbstractBgOrgUnitSetUI {
    private static final Logger logger = CoreUIObject.getLogger(BgOrgUnitSetUI.class);
    private static final String SOURCE_STR = "com.kingdee.eas.sem.mp.client.KPIResource";
    private NumberExpendRender expendRender = null;
    private boolean isModify = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setEnabled(true);
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.expendRender = new NumberExpendRender();
        this.tblMain.getColumn(1).setRenderer((IBasicRender)this.expendRender);
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(false);
        af7.setRootUnitID(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        af7.setInputData(this.getParams());
        prmtSelect.setSelector((KDPromptSelector)af7);
        this.tblMain.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.comArea_actionPerformed(null);
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                BgOrgUnitSetUI.this.setModify(true);
            }
        });
    }

    protected void init() throws Exception {
        this.comArea.removeAllItems();
        this.comArea.addItems(this.getAreaFacade().getOrgTreeInfo(null).toArray());
        this.comArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BgOrgUnitSetUI.this.comArea_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgOrgUnitSetUI.this.handUIException(ex);
                }
            }
        });
        AbstractAction actionSave = new AbstractAction(){
            private static final long serialVersionUID = 8707818271853932164L;

            public void actionPerformed(ActionEvent e) {
                try {
                    BgOrgUnitSetUI.this.actionSave_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgOrgUnitSetUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_S";
        KeyStroke ks = KeyStroke.getKeyStroke(83, 192, false);
        this.getActionMap().put(strKey, actionSave);
        this.getInputMap(2).put(ks, strKey);
        ActionMap map = this.tblMain.getActionMap();
        map.remove("Cut");
        map.remove("Paste");
        map.remove("Copy");
        map.remove("Delete");
    }

    public IBGCompanyMapFacade getAreaFacade() throws Exception {
        return BGCompanyMapFacadeFactory.getRemoteInstance();
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    public boolean isModify() {
        return this.isModify;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.comArea.setLimitedSize(false);
        this.comArea.setComboPopupWidth(300);
    }

    protected void comArea_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comArea.getSelectedItem();
        if (obj != null) {
            int _result;
            if (this.isModify() && (_result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSelect"))) == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            }
            this.tblMain.removeRows();
            OrgTreeInfo orgTreeInfo = null;
            if (obj instanceof String) {
                int i;
                IBGCompanyMapFacade ibgAreaFacade = BGCompanyMapFacadeFactory.getRemoteInstance();
                Map unionMap = null;
                ArrayList<String> unionIdList = new ArrayList<String>();
                int in = this.comArea.getItemCount();
                for (i = 0; i < in; ++i) {
                    obj = this.comArea.getItemAt(i);
                    if (!(obj instanceof OrgTreeInfo)) continue;
                    orgTreeInfo = (OrgTreeInfo)obj;
                    unionIdList.add(orgTreeInfo.getId().toString());
                }
                unionMap = ibgAreaFacade.getUnionInfo(unionIdList);
                in = this.comArea.getItemCount();
                for (i = 0; i < in; ++i) {
                    obj = this.comArea.getItemAt(i);
                    if (!(obj instanceof OrgTreeInfo)) continue;
                    orgTreeInfo = (OrgTreeInfo)obj;
                    List unionList = ibgAreaFacade.getUnionCollection(orgTreeInfo.getId());
                    this.builderAreaInfo(orgTreeInfo, unionList, unionMap);
                    SemMPHelper.objClear(unionList);
                }
                SemMPHelper.objClear(unionIdList);
                SemMPHelper.objClear(unionMap);
            } else if (obj instanceof OrgTreeInfo) {
                orgTreeInfo = (OrgTreeInfo)obj;
                ArrayList<String> unionIdList = new ArrayList<String>();
                unionIdList.add(orgTreeInfo.getId().toString());
                IBGCompanyMapFacade ibgAreaFacade = BGCompanyMapFacadeFactory.getRemoteInstance();
                List unionList = ibgAreaFacade.getUnionCollection(orgTreeInfo.getId());
                Map unionMap = ibgAreaFacade.getUnionInfo(unionIdList);
                this.builderAreaInfo(orgTreeInfo, unionList, unionMap);
                SemMPHelper.objClear(unionList);
                SemMPHelper.objClear(unionIdList);
                SemMPHelper.objClear(unionMap);
            }
        }
        this.setModify(false);
    }

    protected void builderAreaInfo(OrgTreeInfo orgTreeInfo, List unionList, Map unionMap) {
        if (orgTreeInfo == null || unionList == null || unionList.isEmpty()) {
            return;
        }
        IRow _row = null;
        String _areaId = null;
        String _unitId = null;
        String _key = null;
        String _orgTreeStr = null;
        OrgUnitInfo _unitInfo = null;
        OrgUnitInfo _tmpInfo = null;
        CompanyOrgUnitInfo _cOrgUnitInfo = null;
        NumberExpandInfo _expandInfo = null;
        _areaId = orgTreeInfo.getId().toString();
        int _rowBegin = this.tblMain.getRowCount();
        int in = unionList.size();
        for (int i = 0; i < in; ++i) {
            _unitInfo = (OrgUnitInfo)unionList.get(i);
            _unitId = _unitInfo.getId().toString();
            _row = this.tblMain.addRow();
            _orgTreeStr = orgTreeInfo.getStartDate() != null ? new StringBuffer(orgTreeInfo.getName()).append(" (").append(SemMPHelper.getMessageStr(SOURCE_STR, "startdate")).append(new SimpleDateFormat("yyyy-MM-dd").format(orgTreeInfo.getStartDate())).append(")").toString() : orgTreeInfo.getName();
            _row.getCell(0).setValue((Object)_orgTreeStr);
            _row.getCell(1).setValue((Object)_unitInfo.getName());
            if (i < in - 1) {
                _tmpInfo = (OrgUnitInfo)unionList.get(i + 1);
                _expandInfo = new NumberExpandInfo();
                _expandInfo.setId(_unitId);
                _expandInfo.setName(_unitInfo.getName());
                _expandInfo.setNumber(_unitInfo.getNumber());
                _expandInfo.setLongNumber(_unitInfo.getLongNumber());
                _expandInfo.setLevel(_unitInfo.getLongNumber().split("!").length);
                if (_tmpInfo.getLongNumber().startsWith(_unitInfo.getLongNumber() + "!")) {
                    _expandInfo.setLeaf(false);
                } else {
                    _expandInfo.setLeaf(true);
                }
                _expandInfo.setExpandStatus(true);
            } else {
                _expandInfo = new NumberExpandInfo();
                _expandInfo.setId(_unitId);
                _expandInfo.setName(_unitInfo.getName());
                _expandInfo.setNumber(_unitInfo.getNumber());
                _expandInfo.setLongNumber(_unitInfo.getLongNumber());
                _expandInfo.setLevel(_unitInfo.getLongNumber().split("!").length);
                _expandInfo.setLeaf(true);
                _expandInfo.setExpandStatus(true);
            }
            _row.getCell(1).setValue((Object)_expandInfo);
            _row.getCell(0).setUserObject((Object)orgTreeInfo);
            _row.getCell(1).setUserObject((Object)_unitInfo);
            _key = _areaId + "_" + _unitId;
            if (unionMap == null || !unionMap.containsKey(_key)) continue;
            _cOrgUnitInfo = (CompanyOrgUnitInfo)unionMap.get(_key);
            _row.getCell(2).setValue((Object)_cOrgUnitInfo);
        }
        this.tblMain.getMergeManager().mergeBlock(_rowBegin, 0, _row.getRowIndex(), 0);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1 && e.getColIndex() == 1) {
            int rowIndex = e.getRowIndex();
            if (this.tblMain.getRowCount() <= 0) {
                return;
            }
            if (this.tblMain.getRow(rowIndex) != null && this.tblMain.getRow(rowIndex).getCell(1) != null) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)this.tblMain.getRow(rowIndex).getCell(1).getValue();
            }
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        if (!expandInfo.isLeaf()) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(1).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(1).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(true);
            }
        }
    }

    protected void verify() throws Exception {
        String _key = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        IRow row = null;
        OrgTreeInfo _orgTreeInfo = null;
        CompanyOrgUnitInfo _cOrgUnitInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(2).getValue() != null && row.getCell(2).getValue() instanceof CompanyOrgUnitInfo) {
                _orgTreeInfo = (OrgTreeInfo)row.getCell(0).getUserObject();
                _cOrgUnitInfo = (CompanyOrgUnitInfo)row.getCell(2).getValue();
                _key = _orgTreeInfo.getId().toString() + "_" + _cOrgUnitInfo.getId().toString();
                if (orgUnitSet.contains(_key)) {
                    this.tblMain.getSelectManager().select(i, 2);
                    orgUnitSet.clear();
                    MsgBox.showInfo((Component)((Object)this), (String)"\u540c\u4e00\u4e2a\u5408\u5e76\u8303\u56f4\u5185\u5408\u5e76\u5355\u5143\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\u91cd\u590d\uff01");
                    super.abort();
                    continue;
                }
                orgUnitSet.add(_key);
                continue;
            }
            row.getCell(2).setValue(null);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        IRow row = null;
        OrgTreeInfo _orgTreeInfo = null;
        OrgUnitInfo _unitInfo = null;
        CompanyOrgUnitInfo _cOrgUnitInfo = null;
        ArrayList<String[]> areaList = new ArrayList<String[]>();
        String[] areaInfo = null;
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            areaInfo = new String[3];
            _orgTreeInfo = (OrgTreeInfo)row.getCell(0).getUserObject();
            _unitInfo = (OrgUnitInfo)row.getCell(1).getUserObject();
            areaInfo[0] = _orgTreeInfo.getId().toString();
            areaInfo[1] = _unitInfo.getId().toString();
            if (row.getCell(2).getValue() != null) {
                _cOrgUnitInfo = (CompanyOrgUnitInfo)row.getCell(2).getValue();
                areaInfo[2] = _cOrgUnitInfo.getId().toString();
            }
            areaList.add(areaInfo);
        }
        KPIInfo kpiINfo = new KPIInfo();
        String msg = SemMPHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgNFormResource", "orgunitmapping");
        IObjectPK pk = LogUtil.beginLog(null, (String)msg, (BOSObjectType)kpiINfo.getBOSType(), null, (String)msg, (String)"bg_orgmapping_save");
        IBGCompanyMapFacade ibgAreaFacade = BGCompanyMapFacadeFactory.getRemoteInstance();
        if (ibgAreaFacade.updateCompanyMap(areaList)) {
            this.setMessageText(SemMPHelper.getMessageStr(SOURCE_STR, "success"));
            this.showMessage();
            this.setModify(false);
        }
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re && this.isModify()) {
            int _result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSave"));
            if (_result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            } else if (_result == 2) {
                re = false;
            }
        }
        return re;
    }

    private HashMap getParams() throws EASBizException, BOSException {
        HashMap<String, Boolean> map = null;
        List list = BGCompanyMapFacadeFactory.getRemoteInstance().getVirtureCompanyOrg();
        if (list != null) {
            map = new HashMap<String, Boolean>();
            Iterator ite = list.iterator();
            while (ite.hasNext()) {
                map.put(ite.next().toString(), Boolean.TRUE);
            }
        }
        return map;
    }
}

