/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.sem.mp.BussAnalysisFacadeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisViewerFactory;
import com.kingdee.eas.sem.mp.IBussAnalysisFacade;
import com.kingdee.eas.sem.mp.IBussAnalysisViewer;
import com.kingdee.eas.sem.mp.client.AbstractBqyViewerManagerUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BqyViewerManagerUI
extends AbstractBqyViewerManagerUI {
    private static final Logger logger = CoreUIObject.getLogger(BqyViewerManagerUI.class);
    private IUIWindow currViewerListDialog = null;
    private HashMap ctx = new HashMap();
    private IBussAnalysisViewer iBussAnalysisViewer = BussAnalysisViewerFactory.getRemoteInstance();
    private String resource = "com.kingdee.eas.sem.mp.BussAnalysisResource";

    public BqyViewerManagerUI() throws Exception {
        this.ctx.put("Owner", this);
    }

    public BqyViewerManagerUI(Frame owner) throws Exception {
        this.ctx.put("Owner", this);
    }

    public BqyViewerManagerUI(IUIObject owner) throws Exception {
        this.ctx.put("Owner", owner);
    }

    public BqyViewerManagerUI(HashMap theMap) throws Exception {
        this.ctx = theMap != null ? theMap : new HashMap();
        this.ctx.put("Owner", this);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButtonIcon();
        this.initOtherComponents();
        this.setKDTableProperty();
        this.rebuilderQueryFilter(false);
    }

    public void actionAddViewer_actionPerformed(ActionEvent e) throws Exception {
        Object[] persons;
        UIContext uiContext = new UIContext((Object)this.getUIContext());
        PersonPromptBox personPromptBox = new PersonPromptBox((IUIObject)this, (HashMap)uiContext);
        personPromptBox.setIsSingleSelect(false);
        personPromptBox.showAllChildren();
        personPromptBox.show();
        if (null != personPromptBox.getData() && personPromptBox.getData() instanceof Object[] && null != (persons = (Object[])personPromptBox.getData())) {
            Vector leftPersonVct = new Vector();
            String authorizedName = this.getAuthorizedName(this.getConfigID(), persons, leftPersonVct);
            if (null != authorizedName) {
                if (leftPersonVct.size() > 0) {
                    if (0 == MsgBox.showConfirm2((String)(authorizedName + EASResource.getString((String)this.resource, (String)"partPersonAuthorized")))) {
                        Object[] objs = new Object[leftPersonVct.size()];
                        leftPersonVct.toArray(objs);
                        this.iBussAnalysisViewer.addViewerBatch(objs, this.getConfigID());
                    }
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)(authorizedName + EASResource.getString((String)this.resource, (String)"allPersonAuthorized")));
                }
            } else {
                this.iBussAnalysisViewer.addViewerBatch(persons, this.getConfigID());
            }
        }
        this.refresh();
    }

    public void actionDelViewer_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSelectedRows()) {
            if (this.isViewerOfU()) {
                if (0 == MsgBox.showConfirm2((String)EASResource.getString((String)this.resource, (String)"isDelSelectedViewer"))) {
                    Iterator iter = this.getSelectConfigIDs().iterator();
                    String viewerID = null;
                    while (iter.hasNext()) {
                        viewerID = (String)iter.next();
                        this.iBussAnalysisViewer.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)viewerID)));
                    }
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"youCannotDelConfig"));
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
        this.refresh();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh();
    }

    public void actionListAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkListAll.isSelected()) {
            this.rebuilderQueryFilter(true);
        } else {
            this.rebuilderQueryFilter(false);
        }
    }

    public void show() {
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
            this.currViewerListDialog = uiFactory.create(BqyViewerManagerUI.class.getName(), (Map)this.ctx);
            this.currViewerListDialog.show();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
    }

    public void setConfigID(String configID) {
        this.ctx.put("configID", configID);
    }

    private String getConfigID() {
        return this.getUIContext().get("configID") == null ? null : (String)this.getUIContext().get("configID");
    }

    private void initButtonIcon() {
        this.btnAddViewer.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelViewer.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void initOtherComponents() {
        this.chkListAll.setEnabled(true);
    }

    private void rebuilderQueryFilter(boolean isListAll) throws Exception {
        if (null == this.queryBqyViewerQuery) {
            this.queryBqyViewerQuery = new EntityViewInfo();
            this.setDataObject((IObjectValue)this.queryBqyViewerQuery);
        } else {
            FilterItemCollection filterColl = null;
            if (null != this.queryBqyViewerQuery.getFilter()) {
                filterColl = this.queryBqyViewerQuery.getFilter().getFilterItems();
                Iterator iter = filterColl.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
                this.queryBqyViewerQuery.getFilter().remove("maskString");
            }
        }
        String configID = this.getConfigID();
        if (null == configID) {
            throw new RuntimeException("can not get config-id from context");
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        FilterItemInfo bqyFilter = new FilterItemInfo("configID", (Object)configID);
        filterItemColl.add(bqyFilter);
        if (!isListAll) {
            FilterItemInfo creatorFilter = new FilterItemInfo("creatorID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString().trim());
            filterItemColl.add(creatorFilter);
            String mark = "#0 and #1";
            filter.setMaskString(mark);
        }
        this.queryBqyViewerQuery.setFilter(filter);
        this.kdtQueryBqyViewerQuery.refresh();
        this.selectFirstRow();
    }

    private void setKDTableProperty() {
        this.kdtQueryBqyViewerQuery.getStyleAttributes().setLocked(true);
        this.kdtQueryBqyViewerQuery.getDataRequestManager().setDataRequestMode(1);
        this.kdtQueryBqyViewerQuery.getSelectManager().setSelectMode(10);
    }

    private boolean isSelectedRows() {
        boolean isSelected = true;
        if (this.kdtQueryBqyViewerQuery.getRowCount() == 0 || this.kdtQueryBqyViewerQuery.getSelectManager().size() == 0) {
            isSelected = false;
        }
        return isSelected;
    }

    private ArrayList getSelectConfigIDs() {
        ArrayList<String> idList = new ArrayList<String>();
        int size = this.kdtQueryBqyViewerQuery.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = this.kdtQueryBqyViewerQuery.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                idList.add(this.kdtQueryBqyViewerQuery.getRow(j).getCell("id").getValue().toString());
            }
        }
        return idList;
    }

    private boolean isViewerOfU() {
        boolean delTag = true;
        String currUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString().trim();
        int size = this.kdtQueryBqyViewerQuery.getSelectManager().size();
        KDTSelectBlock sb = null;
        String selectedRowCreatorID = null;
        block0: for (int i = 0; i < size; ++i) {
            sb = this.kdtQueryBqyViewerQuery.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                selectedRowCreatorID = this.kdtQueryBqyViewerQuery.getRow(j).getCell("creatorID").getValue().toString();
                if (selectedRowCreatorID.trim().equals(currUserID)) continue;
                delTag = false;
                continue block0;
            }
        }
        return delTag;
    }

    private void refresh() throws Exception {
        if (this.chkListAll.isSelected()) {
            this.rebuilderQueryFilter(true);
        } else {
            this.rebuilderQueryFilter(false);
        }
    }

    protected void selectFirstRow() {
        if (this.kdtQueryBqyViewerQuery.getRow(0) != null) {
            this.kdtQueryBqyViewerQuery.getSelectManager().select(0, 0);
        }
    }

    private String getAuthorizedName(String configID, Object[] persons, Vector leftPerson) {
        String names = null;
        try {
            IBussAnalysisFacade iBAFacade = BussAnalysisFacadeFactory.getRemoteInstance();
            ArrayList authorizedList = iBAFacade.getPersonsIDByConfigID(configID);
            if (null != authorizedList && 0 < authorizedList.size()) {
                int personSize = persons.length;
                StringBuffer personBuff = null;
                for (int i = 0; i < personSize; ++i) {
                    if (authorizedList.size() > 0) {
                        int listSize = authorizedList.size();
                        int pos = 0;
                        for (int j = 0; j < listSize; ++j) {
                            if (((String)authorizedList.get(j)).trim().equals(((PersonInfo)persons[i]).getId().toString().trim())) {
                                if (null == personBuff) {
                                    personBuff = new StringBuffer();
                                    personBuff.append(((PersonInfo)persons[i]).getName());
                                } else {
                                    personBuff.append("\u3001").append(((PersonInfo)persons[i]).getName());
                                }
                                authorizedList.remove(j);
                                break;
                            }
                            ++pos;
                        }
                        if (pos != listSize) continue;
                        leftPerson.add(persons[i]);
                        continue;
                    }
                    leftPerson.add(persons[i]);
                }
                if (null != personBuff) {
                    names = personBuff.toString();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return names;
    }
}

