/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.sem.mp.BussAnalysisConfigFactory;
import com.kingdee.eas.sem.mp.BussAnalysisFacadeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisTopicsFactory;
import com.kingdee.eas.sem.mp.BussAnalysisTopicsInfo;
import com.kingdee.eas.sem.mp.IBussAnalysisFacade;
import com.kingdee.eas.sem.mp.client.AbstractBussAnalysisConfigListUI;
import com.kingdee.eas.sem.mp.client.BqyViewerManagerUI;
import com.kingdee.eas.sem.mp.client.BussAnalysisConfigEduitUI;
import com.kingdee.eas.sem.mp.client.BussAnalysisTopicEduitUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BussAnalysisConfigListUI
extends AbstractBussAnalysisConfigListUI {
    private static final Logger logger = CoreUIObject.getLogger(BussAnalysisConfigListUI.class);
    private IBussAnalysisFacade iFacade = null;
    private String rootName = null;
    private String ResoucePath = "com.kingdee.eas.sem.mp.BussAnalysisResource";
    private String selectedTopicItem = null;

    public BussAnalysisConfigListUI() throws Exception {
        super.setIsNeedDefaultFilter(true);
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"fileName", "filePath", "topic", "createTime", "creator", "id"};
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        String title;
        super.setIsNeedDefaultFilter(false);
        this.rootName = title = EASResource.getString((String)this.ResoucePath, (String)"BATitle");
        super.onLoad();
        this.initUI();
    }

    protected Object getRootObject() {
        return null;
    }

    protected void initTree() throws Exception {
        TreeSelectionListener treeSelectionListener = null;
        TreeSelectionListener[] listeners = this.treeMain.getTreeSelectionListeners();
        treeSelectionListener = listeners[0];
        this.treeMain.removeTreeSelectionListener(treeSelectionListener);
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), null);
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            rootNode.setText(this.rootName);
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.addTreeSelectionListener(treeSelectionListener);
        this.treeMain.setShowPopMenuDefaultItem(true);
        this.initPopmenu();
    }

    protected void buildTreeFilter() {
        this.buildTreeFilter(this.getSelectedTreeNode());
    }

    protected EntityViewInfo buildTreeFilter(KDTreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        if (this.mainQuery.getFilter() == null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection filterColl = this.mainQuery.getFilter().getFilterItems();
        Iterator iter = filterColl.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        this.mainQuery.getFilter().remove("maskString");
        if (treeNode.getUserObject() instanceof TreeBaseInfo) {
            filterColl.add(new FilterItemInfo("topic.id", (Object)this.getSelectedNodeKeyValue()));
            return this.mainQuery;
        }
        return null;
    }

    protected String getGroupEditUIName() {
        return BussAnalysisTopicEduitUI.class.getName();
    }

    protected String getQueryFieldName() {
        return null;
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BussAnalysisTopicsFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BussAnalysisConfigEduitUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BussAnalysisConfigFactory.getRemoteInstance();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK key = new ObjectUuidPK(this.getSelectedNodeKeyValue());
        return key;
    }

    private BussAnalysisTopicsInfo getSelectedTopic() throws Exception {
        BussAnalysisTopicsInfo topic = null;
        topic = (BussAnalysisTopicsInfo)this.getTreeInterface().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedNodeKeyValue()));
        return topic;
    }

    protected void initGroupButton() {
        String addTopic = EASResource.getString((String)this.ResoucePath, (String)"addTopic");
        this.btnGroupAddNew.setToolTipText(addTopic);
        String updateTopic = EASResource.getString((String)this.ResoucePath, (String)"updateTopic");
        this.btnGroupEdit.setToolTipText(updateTopic);
        String delTopic = EASResource.getString((String)this.ResoucePath, (String)"delTopic");
        this.btnGroupRemove.setToolTipText(delTopic);
        this.treeView.getControlPane().add((Component)this.btnGroupAddNew);
        this.treeView.getControlPane().add((Component)this.btnGroupEdit);
        this.treeView.getControlPane().add((Component)this.btnGroupRemove);
    }

    private void initUI() {
        this.chkIncludeChild.setVisible(false);
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.btnMoveTree.setVisible(false);
        this.btnGroupView.setVisible(false);
        this.btnGroupMoveTree.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.menuItemGroupAddNew.setVisible(false);
        this.menuItemGroupEdit.setVisible(false);
        this.menuItemGroupRemove.setVisible(false);
        this.menuItemGroupView.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.btnSetViewers.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.setToolsButton();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected String getKeyFieldName() {
        return "id";
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.iFacade) {
            this.iFacade = BussAnalysisFacadeFactory.getRemoteInstance();
        }
        if (this.iFacade.isEmptyTree()) {
            this.showPopMessage(EASResource.getString((String)this.ResoucePath, (String)"AddTopicFirst"));
        }
        if (this.treeMain.getSelectionPath().toString().trim().equalsIgnoreCase("[" + this.rootName + "]")) {
            this.showPopMessage(EASResource.getString((String)this.ResoucePath, (String)"PlsSelectTopic"));
        }
        this.getUIContext().put("selectedTopic", this.getSelectedTopic());
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionSetViewers_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        BqyViewerManagerUI viewerUI = new BqyViewerManagerUI((IUIObject)this);
        if (null != this.tblMain && null != this.tblMain.getSelectManager().get()) {
            int row = this.tblMain.getSelectManager().get().getBeginRow();
            String configID = this.tblMain.getRow(row).getCell("id").getValue().toString();
            viewerUI.setConfigID(configID);
        }
        viewerUI.show();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (null != this.tblMain && null != this.tblMain.getSelectManager().get()) {
            int row = this.tblMain.getSelectManager().get().getBeginRow();
            this.selectedTopicItem = this.tblMain.getRow(row).getCell("topic").getValue().toString();
            uiContext.put((Object)"TopicItem", (Object)this.selectedTopicItem);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IBussAnalysisFacade iBAFacade = BussAnalysisFacadeFactory.getRemoteInstance();
        ArrayList idList = this.getSelectedIdValues();
        if (null != idList) {
            for (int i = 0; i < idList.size(); ++i) {
                if (iBAFacade.isUndelConfig(((String)idList.get(i)).trim())) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.ResoucePath, (String)"unDelConfigTip"));
                return;
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (null != this.getSelectedTreeNode() && this.getSelectedTreeNode().getUserObject() instanceof TreeBaseInfo) {
            String topicID = ((BussAnalysisTopicsInfo)this.getSelectedTreeNode().getUserObject()).getId().toString().trim();
            IBussAnalysisFacade iBAFacade = BussAnalysisFacadeFactory.getRemoteInstance();
            if (!iBAFacade.isUndelTopic(topicID)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.ResoucePath, (String)"unDelTopicTip"));
                return;
            }
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected void showPopMessage(String message) {
        this.setShowMessagePolicy(3);
        this.setMessageText(message);
        this.showMessage();
        SysUtil.abort();
        this.resetShowMessagePolicy();
    }

    protected void initPopmenu() {
    }

    private void setToolsButton() {
        IObjectPK userPK = null;
        IObjectPK orgPK = null;
        userPK = this.getUserPk();
        orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            boolean isEnable = iPermission.hasFunctionPermission(userPK, orgPK, "buss_analysis_config_add");
            this.btnAddNew.setEnabled(isEnable);
            isEnable = iPermission.hasFunctionPermission(userPK, orgPK, "buss_analysis_config_edit");
            this.btnEdit.setEnabled(isEnable);
            isEnable = iPermission.hasFunctionPermission(userPK, orgPK, "buss_analysis_config_delete");
            this.btnRemove.setEnabled(isEnable);
            isEnable = iPermission.hasFunctionPermission(userPK, orgPK, "buss_analysis_config_authorization");
            this.btnSetViewers.setEnabled(isEnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

