/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.BussAnalysisThemeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportCollection;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeTreeInfo;
import com.kingdee.eas.sem.mp.BussLayoutFactory;
import com.kingdee.eas.sem.mp.BussLayoutInfo;
import com.kingdee.eas.sem.mp.client.AbstractBussAnalysisEditUI;
import com.kingdee.eas.sem.mp.client.BussAnalysisSolutionSelectUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BussAnalysisEditUI
extends AbstractBussAnalysisEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BussAnalysisEditUI.class);
    private static final String RES = "com.kingdee.eas.sem.mp.BussAnalysisResource";
    private BussAnalysisThemeInfo parentInfo;
    protected AbstractBussAnalysisEditUI.ActionAddLine actionAddLine = null;
    protected DataBinder dataBinderOfEntry = new DataBinder();
    protected DataBinder dataBinderOfBussLayOut = new DataBinder();
    protected BussLayoutInfo bussLayout = null;
    protected List selectData = new ArrayList();
    protected BussAnalysisThemeReportCollection layoutData = new BussAnalysisThemeReportCollection();
    protected BussAnalysisThemeReportCollection bussReportList = new BussAnalysisThemeReportCollection();
    private boolean isCancel = true;
    protected KDMenuItem menuItemToMerge;
    protected KDMenuItem menuItemToOriginal;
    private HashMap selfTableToMenu = new HashMap();
    private static final int MAXSIZE = 5;
    private boolean firstMark = true;

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.initKdtEntries(this.editData.getId());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.isBussLeaf.setSelected(this.editData.isIsBusiLeaf());
        this.cols.setValue((Object)new Integer(this.bussLayout.getCols()));
        this.rows.setValue((Object)new Integer(this.bussLayout.getRows()));
    }

    public void storeFields() {
        super.storeFields();
        if (32 == this.isBussLeaf.getSelected()) {
            this.editData.setIsBusiLeaf(true);
        } else {
            this.editData.setIsBusiLeaf(false);
        }
        if (this.editData.isIsBusiLeaf()) {
            this.bussLayout.setCols(this.cols.getIntegerValue() == null ? 1 : this.cols.getIntegerValue());
            this.bussLayout.setRows(this.rows.getIntegerValue() == null ? 1 : this.rows.getIntegerValue());
            this.readData(this.layoutData);
        }
    }

    public void onLoad() throws Exception {
        this.addListeners();
        this.addLine.setEnabled(false);
        this.cols.setEditable(false);
        this.rows.setEditable(false);
        super.onLoad();
        this.menuBiz.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.layoutTable.setScrollStateHorizon(1);
        this.layoutTable.setScrollStateVertical(1);
        this.layoutTable.getStyleAttributes().setLocked(true);
        this.cols.setDataType(Integer.class);
        this.rows.setDataType(Integer.class);
        this.reportList.setSelectionMode(0);
        this.initPersonalSet();
        this.initParentNode();
        this.initTableRightMenu();
        if (this.isBussLeaf.isSelected()) {
            this.initLayoutTable();
        }
        this.addSelfMenu();
        if (OprtState.EDIT.equals(this.oprtState)) {
            if (this.editData.isIsLeaf()) {
                this.isBussLeaf.setEnabled(true);
                if (this.editData.isIsBusiLeaf()) {
                    this.setButtonState(true);
                } else {
                    this.setButtonState(false);
                }
            } else {
                this.isBussLeaf.setEnabled(false);
                this.setButtonState(false);
            }
            this.reportList.removeAllElements();
        } else if (!OprtState.ADDNEW.equals(this.oprtState) && OprtState.VIEW.equals(this.oprtState)) {
            this.reportList.removeAllElements();
            this.isBussLeaf.setEnabled(false);
            this.cols.setEditable(false);
            this.rows.setEditable(false);
            KDTMenuManager kdtMenu = (KDTMenuManager)this.selfTableToMenu.get(this.layoutTable);
            if (kdtMenu != null) {
                Component[] menus = kdtMenu.getMenu().getComponents();
                for (int i = 0; i < menus.length; ++i) {
                    if (!(menus[i] instanceof JMenuItem)) continue;
                    JMenuItem menu = (JMenuItem)menus[i];
                    if ("menuItemToOriGalCell".equals(menu.getName()) || "menuItemToMergeCell".equals(menu.getName())) {
                        menu.setEnabled(false);
                        continue;
                    }
                    menu.setVisible(false);
                }
            }
        }
        this.layoutTable.getLayoutManager().setVSplitButtonVisible(false);
        this.layoutTable.getLayoutManager().setHSplitButtonVisible(false);
        this.layoutTable.getIndexColumn().getStyleAttributes().setHided(true);
    }

    private void setButtonState(boolean mark) {
        this.addLine.setEnabled(mark);
        this.delLine.setEnabled(mark);
        this.btnLayout.setEnabled(mark);
        this.btnToRight.setEnabled(mark);
        this.brnToLeft.setEnabled(mark);
        this.btnMerge.setEnabled(mark);
        this.btnOriginal.setEnabled(mark);
    }

    protected void initTableRightMenu() {
        this.menuItemToMerge = new KDMenuItem();
        this.menuItemToMerge.setName("menuItemToMergeCell");
        this.menuItemToMerge.setText(EASResource.getString((String)RES, (String)"merge_cell"));
        this.menuItemToMerge.setToolTipText(EASResource.getString((String)RES, (String)"merge_cell1"));
        this.menuItemToOriginal = new KDMenuItem();
        this.menuItemToOriginal.setName("menuItemToOriGalCell");
        this.menuItemToOriginal.setText(EASResource.getString((String)RES, (String)"ori_cell"));
        this.menuItemToOriginal.setToolTipText(EASResource.getString((String)RES, (String)"ori_cell1"));
    }

    protected void addSelfMenu() {
        KDTMenuManager kdtMenu = this.getMenuManager(this.layoutTable);
        if (kdtMenu != null) {
            kdtMenu.getMenu().removeAll();
        } else {
            kdtMenu = new KDTMenuManager(this.layoutTable);
            Component[] menus = kdtMenu.getMenu().getComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem menu = (JMenuItem)menus[i];
                menu.setVisible(false);
            }
            kdtMenu.getMenu().add((JMenuItem)this.menuItemToMerge);
            kdtMenu.getMenu().add((JMenuItem)this.menuItemToOriginal);
            this.menuItemToMerge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BussAnalysisEditUI.this.mergeTableCell();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        BussAnalysisEditUI.this.handUIException(e1);
                    }
                }
            });
            this.menuItemToOriginal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        BussAnalysisEditUI.this.originalTableCell();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        BussAnalysisEditUI.this.handUIException(e1);
                    }
                }
            });
            this.selfTableToMenu.put(this.layoutTable, kdtMenu);
        }
    }

    private void initLayoutTable() {
        if (this.bussLayout.getCols() > 0 && this.bussLayout.getRows() > 0) {
            int initRows = this.bussLayout.getRows();
            int initCols = this.bussLayout.getCols();
            this.layoutTable.removeColumns();
            this.layoutTable.removeRows();
            int defHeight = this.layoutTable.getHeight() / initRows;
            int defWidth = this.layoutTable.getWidth() / initCols;
            this.layoutTable.addColumns(initCols);
            this.layoutTable.addRows(initRows);
            for (int i = 0; i < initCols; ++i) {
                this.layoutTable.getColumn(i).setWidth(defWidth);
            }
            for (int j = 0; j < initRows; ++j) {
                this.layoutTable.getRow(j).setHeight(defHeight);
            }
        } else {
            return;
        }
        this.layoutTable.getIndexColumn().getStyleAttributes().setHided(true);
        if (this.bussReportList != null && this.bussReportList.size() > 0) {
            KDTMergeManager mm = this.layoutTable.getMergeManager();
            Iterator ite = this.bussReportList.iterator();
            while (ite.hasNext()) {
                ICell tempCell;
                BussAnalysisThemeReportInfo reportInfo = (BussAnalysisThemeReportInfo)ite.next();
                IRow tempRow = this.layoutTable.getRow(reportInfo.getRowNumber());
                if (tempRow == null || (tempCell = tempRow.getCell(reportInfo.getColNumber())) == null) continue;
                tempCell.setValue((Object)reportInfo);
                if (reportInfo.getColspan() <= 0 && reportInfo.getRowspan() <= 0) continue;
                mm.mergeBlock(reportInfo.getRowNumber(), reportInfo.getColNumber(), reportInfo.getRowNumber() + reportInfo.getRowspan() - 1, reportInfo.getColNumber() + reportInfo.getColspan() - 1);
            }
        }
    }

    public int getMaxRowCount() {
        return 5;
    }

    public int getMaxColCount() {
        return 5;
    }

    private void initPersonalSet() {
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.cols.setMinimumNumber((Number)new Integer(1));
        this.cols.setMaximumNumber((Number)new Integer(this.getMaxRowCount()));
        this.rows.setMinimumNumber((Number)new Integer(1));
        this.rows.setMaximumNumber((Number)new Integer(this.getMaxRowCount()));
        this.cols.setRequired(true);
        this.rows.setRequired(true);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLayoutPreview.setVisible(false);
        this.btnLayout.setVisible(false);
        this.brnToLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnToRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnMerge.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.btnOriginal.setIcon(EASResource.getIcon((String)"imgTbtn_restore"));
        this.addLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.delLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void initBussLayout(BOSUuid id) throws EASBizException, BOSException, Exception {
        if (id == null) {
            this.bussLayout = new BussLayoutInfo();
            this.bussLayout.setCols(0);
            this.bussLayout.setRows(0);
        } else {
            this.bussLayout = (BussLayoutInfo)this.getBussLayoutInterface().getValue((IObjectPK)new ObjectUuidPK(id));
        }
    }

    protected void initKdtEntries(BOSUuid themeId) throws BOSException {
        this.selectData.clear();
        if (themeId == null) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("theme", (Object)themeId.toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        BussAnalysisThemeReportCollection cols = BussAnalysisThemeReportFactory.getRemoteInstance().getBussAnalysisThemeReportCollection(ev);
        if (cols != null && cols.size() > 0) {
            Iterator ite = cols.iterator();
            while (ite.hasNext()) {
                BussAnalysisThemeReportInfo reportInfo = (BussAnalysisThemeReportInfo)ite.next();
                this.bussReportList.add(reportInfo);
                this.selectData.add(this.createBizReportInfoByBATInfo(reportInfo));
            }
        }
    }

    protected void loadData() throws Exception {
        if ("ADDNEW".equals(this.getOprtState())) {
            if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectValue) {
                this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
            } else {
                this.editData = (BussAnalysisThemeInfo)this.createNewData();
                this.applyDefaultValue((IObjectValue)this.editData);
                this.setDataObject((IObjectValue)this.editData);
            }
            this.bussLayout = this.createBussLayoutInfo();
            this.loadFields();
        } else {
            this.inOnload();
        }
        this.showMessageForStatus();
    }

    protected void inOnload() throws Exception {
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectValue) {
            this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
        } else {
            if (this.getUIContext().get("ID") == null) {
                String s = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_IDIsNull");
                MsgBox.showError((String)s);
                SysUtil.abort();
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
            this.setDataObject(this.getValue((IObjectPK)pk));
        }
        this.initBussLayout(this.editData.getEntry() == null ? null : this.editData.getEntry().getId());
        this.initKdtEntries(this.editData.getId());
        this.loadFields();
        Object id = this.getUIContext().get("ID");
        if (id != null) {
            this.prepareData(id.toString());
        }
    }

    public BussLayoutInfo createBussLayoutInfo() {
        BussLayoutInfo bussLayoutInfo = new BussLayoutInfo();
        return bussLayoutInfo;
    }

    public void setLayoutObject(IObjectValue objectValue) {
        this.bussLayout = (BussLayoutInfo)objectValue;
    }

    private void addListeners() {
        this.isBussLeaf.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                BussAnalysisEditUI.this.bussLeafStateChange(arg0);
            }
        });
        this.cols.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object obj = eventObj.getNewValue();
                if (obj != null && (obj instanceof BigDecimal || obj instanceof Integer)) {
                    int newValue = obj instanceof BigDecimal ? ((BigDecimal)obj).intValue() : (obj instanceof Integer ? (Integer)obj : 0);
                    if (newValue <= 0 || newValue > 5) {
                        BussAnalysisEditUI.this.cols.setValue(eventObj.getOldValue());
                    } else if (BussAnalysisEditUI.this.rows.getIntegerValue() != null && BussAnalysisEditUI.this.rows.getIntegerValue() > 0 && BussAnalysisEditUI.this.rows.getIntegerValue() < 5) {
                        BussAnalysisEditUI.this.contructTable(BussAnalysisEditUI.this.rows.getIntegerValue(), newValue);
                    }
                }
            }
        });
        this.rows.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object obj = eventObj.getNewValue();
                if (obj != null && (obj instanceof BigDecimal || obj instanceof Integer)) {
                    int newValue = obj instanceof BigDecimal ? ((BigDecimal)obj).intValue() : (obj instanceof Integer ? (Integer)obj : 0);
                    if (newValue <= 0 || newValue > 5) {
                        BussAnalysisEditUI.this.rows.setValue(eventObj.getOldValue());
                    } else if (BussAnalysisEditUI.this.cols.getIntegerValue() != null && BussAnalysisEditUI.this.cols.getIntegerValue() > 0 && BussAnalysisEditUI.this.cols.getIntegerValue() < 5) {
                        BussAnalysisEditUI.this.contructTable(newValue, BussAnalysisEditUI.this.cols.getIntegerValue());
                    }
                }
            }
        });
    }

    private void contructTable(int initRows, int initCols) {
        if (initRows <= 0 || initCols <= 0 || initRows > this.getMaxRowCount() || initCols > this.getMaxColCount()) {
            return;
        }
        this.reportList.removeAllElements();
        Iterator ite = this.bussReportList.iterator();
        while (ite.hasNext()) {
            this.reportList.addElement(ite.next());
        }
        this.layoutTable.removeColumns();
        this.layoutTable.removeRows();
        int defHeight = this.layoutTable.getHeight() / initRows;
        int defWidth = this.layoutTable.getWidth() / initCols;
        this.layoutTable.addColumns(initCols);
        this.layoutTable.addRows(initRows);
        for (int i = 0; i < initCols; ++i) {
            this.layoutTable.getColumn(i).setWidth(defWidth);
        }
        for (int j = 0; j < initRows; ++j) {
            this.layoutTable.getRow(j).setHeight(defHeight);
        }
    }

    private void bussLeafStateChange(ChangeEvent arg0) {
        if (((KDCheckBox)arg0.getSource()).getSelected() == 32) {
            this.rows.setValue((Object)new Integer(2));
            this.cols.setValue((Object)new Integer(2));
            this.changeStates(true);
        } else {
            this.changeStates(false);
            this.invalidValues();
        }
    }

    private void changeStates(boolean mark) {
        if (!OprtState.VIEW.equals(this.oprtState)) {
            this.addLine.setEnabled(mark);
            this.delLine.setEnabled(mark);
            this.btnLayout.setEnabled(mark);
            this.btnToRight.setEnabled(mark);
            this.brnToLeft.setEnabled(mark);
            this.btnMerge.setEnabled(mark);
            this.btnOriginal.setEnabled(mark);
        }
        this.cols.setEditable(mark);
        this.rows.setEditable(mark);
        if (mark) {
            this.initLayoutTable();
        }
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.layoutTable.setEnabled(false);
        }
    }

    private void invalidValues() {
        this.cols.setValue(null);
        this.rows.setValue(null);
        this.selectData.clear();
        this.bussReportList.clear();
        this.bussLayout.setCols(0);
        this.bussLayout.setRows(0);
        this.invalidLayoutTable();
        this.reportList.removeAllElements();
    }

    private void invalidLayoutTable() {
        this.layoutTable.removeColumns();
        this.layoutTable.removeRows();
    }

    private void initParentNode() {
        BussAnalysisThemeInfo tempInfo = null;
        Object tempNode = this.getUIContext().get("ParentNode");
        if (tempNode != null && tempNode instanceof BussAnalysisThemeInfo) {
            tempInfo = (BussAnalysisThemeInfo)tempNode;
        }
        this.parentInfo = tempInfo;
        this.editData.setParent(this.parentInfo);
    }

    protected IObjectValue createNewData() {
        BussAnalysisThemeInfo newInfo = new BussAnalysisThemeInfo();
        return newInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BussAnalysisThemeFactory.getRemoteInstance();
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        ArrayList addDataList = new ArrayList();
        ArrayList subDataList = new ArrayList();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ADDDATALIST", addDataList);
        uiContext.put((Object)"SUBDATALIST", subDataList);
        uiContext.put((Object)"SELECTEDDATA", (Object)this.selectData);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(BussAnalysisSolutionSelectUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        if (!this.isCancel) {
            this.updateLayout();
        }
        if (this.reportList.getElementCount() > 0) {
            this.reportList.setSelectedIndex(0);
        }
    }

    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        int seleIndex = this.reportList.getSelectedIndex();
        if (seleIndex < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"please_select_report"));
            return;
        }
        Object obj = this.reportList.getElement(seleIndex);
        BussAnalysisThemeReportInfo bussInfo = (BussAnalysisThemeReportInfo)obj;
        int n = this.selectData.size();
        for (int i = 0; i < n; ++i) {
            BussAnalysisThemeTreeInfo bizReportInfo = (BussAnalysisThemeTreeInfo)this.selectData.get(i);
            if (bussInfo.getSubjectName() == null || !bussInfo.getSubjectName().equals(bizReportInfo.getSubName()) || bussInfo.getSubjectPath() == null || !bussInfo.getSubjectPath().equals(bizReportInfo.getSubPath())) continue;
            this.selectData.remove(i);
            break;
        }
        int m = this.bussReportList.size();
        for (int j = 0; j < m; ++j) {
            BussAnalysisThemeReportInfo tempBussInfo = this.bussReportList.get(j);
            if (bussInfo.getSubjectName() == null || !bussInfo.getSubjectName().equals(tempBussInfo.getSubjectName()) || bussInfo.getSubjectPath() == null || !bussInfo.getSubjectPath().equals(tempBussInfo.getSubjectPath())) continue;
            this.bussReportList.removeObject(j);
            break;
        }
        this.reportList.removeElementAt(seleIndex);
        if (this.reportList.getElementCount() > 0) {
            this.reportList.setSelectedIndex(0);
        }
    }

    private void updateLayout() {
        this.subLayout();
        this.addLayout();
    }

    private void addLayout() {
        if (this.selectData == null || this.selectData.size() <= 0) {
            return;
        }
        if (this.reportList.getElementCount() <= 0) {
            // empty if block
        }
        int listCount = this.reportList.getElementCount();
        boolean exist = false;
        Iterator ite = this.selectData.iterator();
        exist = false;
        while (ite.hasNext()) {
            BussAnalysisThemeReportInfo bussInfo;
            int i;
            BussAnalysisThemeTreeInfo reportInfo = (BussAnalysisThemeTreeInfo)ite.next();
            exist = false;
            for (i = 0; i < listCount; ++i) {
                bussInfo = (BussAnalysisThemeReportInfo)this.reportList.getElement(i);
                String subName = bussInfo.getSubjectName();
                String subPath = bussInfo.getSubjectPath();
                if (!reportInfo.getSubName().equals(subName) || !reportInfo.getSubPath().equals(subPath)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                for (i = 0; i < this.layoutTable.getRowCount(); ++i) {
                    IRow row = this.layoutTable.getRow(i);
                    for (int j = 0; j < this.layoutTable.getColumnCount(); ++j) {
                        ICell cell = row.getCell(j);
                        Object obj = cell.getValue();
                        if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
                        bussInfo = (BussAnalysisThemeReportInfo)obj;
                        String name = bussInfo.getSubjectName();
                        String path = bussInfo.getSubjectPath();
                        if (!reportInfo.getSubName().equals(name) || !reportInfo.getSubPath().equals(path)) continue;
                        exist = true;
                        break;
                    }
                    if (exist) break;
                }
            }
            if (exist) continue;
            bussInfo = this.createNewDetailData(reportInfo);
            this.bussReportList.add(bussInfo);
            this.reportList.addElement((Object)bussInfo);
        }
    }

    private void subLayout() {
        BussAnalysisThemeTreeInfo reportInfo;
        Iterator ite;
        Object obj;
        if (this.selectData == null || this.selectData.size() <= 0) {
            this.bussReportList.clear();
            this.reportList.removeAllElements();
            for (int i = 0; i < this.layoutTable.getRowCount(); ++i) {
                IRow row = this.layoutTable.getRow(i);
                for (int j = 0; j < this.layoutTable.getColumnCount(); ++j) {
                    row.getCell(j).setValue(null);
                }
            }
            return;
        }
        int reportListCount = this.reportList.getElementCount();
        boolean exist = false;
        ArrayList<Integer> delRow = new ArrayList<Integer>();
        for (int i = 0; i < reportListCount; ++i) {
            obj = this.reportList.getElement(i);
            BussAnalysisThemeReportInfo bussReportInfo = (BussAnalysisThemeReportInfo)obj;
            String subName = bussReportInfo.getSubjectName();
            String subPath = bussReportInfo.getSubjectPath();
            ite = this.selectData.iterator();
            exist = false;
            while (ite.hasNext()) {
                reportInfo = (BussAnalysisThemeTreeInfo)ite.next();
                if (!reportInfo.getSubName().equals(subName) || !reportInfo.getSubPath().equals(subPath)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            delRow.add(new Integer(i));
        }
        Object[] objArr = delRow.toArray();
        for (int j = objArr.length - 1; j >= 0; --j) {
            this.reportList.removeElementAt(j);
        }
        for (int i = 0; i < this.layoutTable.getRowCount(); ++i) {
            IRow row = this.layoutTable.getRow(i);
            for (int j = 0; j < this.layoutTable.getColumnCount(); ++j) {
                ICell cell = row.getCell(j);
                obj = cell.getValue();
                if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
                BussAnalysisThemeReportInfo bussInfo = (BussAnalysisThemeReportInfo)obj;
                String name = bussInfo.getSubjectName();
                String path = bussInfo.getSubjectPath();
                ite = this.selectData.iterator();
                exist = false;
                while (ite.hasNext()) {
                    reportInfo = (BussAnalysisThemeTreeInfo)ite.next();
                    if (!reportInfo.getSubName().equals(name) || !reportInfo.getSubPath().equals(path)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                cell.setValue(null);
            }
        }
    }

    protected void changeLayoutTable(String subName, String subPath) {
        for (int i = 0; i < this.layoutTable.getRowCount(); ++i) {
            IRow row = this.layoutTable.getRow(i);
            for (int j = 0; j < this.layoutTable.getColumnCount(); ++j) {
                ICell cell = row.getCell(j);
                Object obj = cell.getValue();
                if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
                BussAnalysisThemeReportInfo bussInfo = (BussAnalysisThemeReportInfo)obj;
                String name = bussInfo.getSubjectName();
                String path = bussInfo.getSubjectPath();
                if (name == null || path == null || name.equals(subName) && !path.equals(subPath)) continue;
                cell.setValue(null);
            }
        }
    }

    protected void addLine(KDTable table, BussAnalysisThemeReportInfo bussInfo) {
        if (table == null) {
            return;
        }
        BussAnalysisThemeReportInfo detailData = bussInfo;
        IRow row = table.addRow();
        this.loadLineFields(table, row, (IObjectValue)detailData);
        this.afterAddLine(table, (IObjectValue)detailData);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                this.delSelectedDataByRow(table.getRow(rowIndex));
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(table, detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected final boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    protected BussAnalysisThemeReportInfo createNewDetailData(BussAnalysisThemeTreeInfo bizInfo) {
        BussAnalysisThemeReportInfo info = new BussAnalysisThemeReportInfo();
        info.setSubjectCaption(bizInfo.getName());
        info.setSubjectName(bizInfo.getSubName());
        info.setSubjectPath(bizInfo.getSubPath());
        info.setWidth(1);
        info.setHeight(1);
        return info;
    }

    protected BussAnalysisThemeTreeInfo createBizReportInfoByBATInfo(BussAnalysisThemeReportInfo reportInfo) {
        BussAnalysisThemeTreeInfo bizInfo = new BussAnalysisThemeTreeInfo();
        bizInfo.setSubName(reportInfo.getSubjectName());
        bizInfo.setSubPath(reportInfo.getSubjectPath());
        return bizInfo;
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        ICell tempCell = row.getCell("subjectName");
        if (tempCell != null) {
            tempCell.setValue((Object)((BussAnalysisThemeReportInfo)obj).getSubjectName());
        }
        if ((tempCell = row.getCell("subjectPath")) != null) {
            tempCell.setValue((Object)((BussAnalysisThemeReportInfo)obj).getSubjectPath());
        }
        if ((tempCell = row.getCell("subjectCaption")) != null) {
            tempCell.setValue((Object)((BussAnalysisThemeReportInfo)obj).getSubjectCaption());
        }
        if ((tempCell = row.getCell("id")) != null) {
            tempCell.setValue((Object)((BussAnalysisThemeReportInfo)obj).getId());
        }
        if ((tempCell = row.getCell("colWidth")) != null) {
            tempCell.setValue((Object)new Integer(((BussAnalysisThemeReportInfo)obj).getWidth()));
        }
        if ((tempCell = row.getCell("colHeight")) != null) {
            tempCell.setValue((Object)new Integer(((BussAnalysisThemeReportInfo)obj).getHeight()));
        }
        row.setUserObject((Object)obj);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String nameData;
        LanguageInfo langInfo;
        MultiLangItem name;
        String txtNumber = this.txtNumber.getText();
        if (txtNumber == null || txtNumber.trim().length() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNumberNotNull"));
            SysUtil.abort();
            this.txtNumber.requestFocus();
        }
        if (txtNumber.trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"number_too_long"));
            SysUtil.abort();
            this.txtNumber.requestFocus();
        }
        if ((name = this.txtName.getItemBy(langInfo = new LanguageInfo(this.getLocale()))) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNameNotNull"));
            this.txtName.requestFocus();
            this.abort();
        }
        if ((nameData = (String)name.getData()) == null || nameData.trim().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNameNotNull"));
            this.txtName.requestFocus();
            this.abort();
        }
        if (nameData.length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"name_length_too_long"));
            this.txtName.requestFocus();
            this.abort();
        }
        if (this.isBussLeaf.getSelectState() == 32) {
            if (this.cols.getIntegerValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"layoutColLargerOne"));
                this.abort();
                this.cols.requestFocus();
            }
            if (this.rows.getIntegerValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"layoutRowLargerOne"));
                this.abort();
                this.rows.requestFocus();
            }
            if (this.selectData.size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussDataNotNull"));
                this.abort();
                this.reportList.requestFocus();
            }
            if (this.reportList.getElementCount() > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"all_report_must_layout"));
                this.abort();
                this.reportList.requestFocus();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected ICoreBase getBussLayoutInterface() throws Exception {
        return BussLayoutFactory.getRemoteInstance();
    }

    protected ICoreBase getBussReportInterface() throws BOSException {
        return BussAnalysisThemeReportFactory.getRemoteInstance();
    }

    public IObjectPK runSubmit() throws Exception {
        if (this.isBussLeaf.getSelectState() == 32) {
            IObjectPK pk = this.getBussLayoutInterface().submit((CoreBaseInfo)this.bussLayout);
            this.bussLayout.setId(BOSUuid.read((String)pk.toString()));
            this.editData.setEntry(this.bussLayout);
        } else {
            this.editData.setEntry(null);
        }
        if (this.editData.isIsBusiLeaf()) {
            IObjectPK tempPK = super.runSubmit();
            this.editData.setId(BOSUuid.read((String)tempPK.toString()));
            this.saveBussReport(this.editData, this.layoutData);
            return tempPK;
        }
        return super.runSubmit();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("entry.id"));
        return sic;
    }

    protected void saveBussReport(BussAnalysisThemeInfo theme, BussAnalysisThemeReportCollection dataList) throws BOSException, EASBizException {
        Iterator ite = dataList.iterator();
        ICoreBase icb = this.getBussReportInterface();
        CoreBaseCollection cols = new CoreBaseCollection();
        while (ite.hasNext()) {
            Object obj = ite.next();
            if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
            BussAnalysisThemeReportInfo bussReportInfo = (BussAnalysisThemeReportInfo)obj;
            bussReportInfo.setTheme(theme);
            cols.add((CoreBaseInfo)bussReportInfo);
        }
        icb.submit(cols);
    }

    protected void saveBussReport(BussAnalysisThemeInfo theme, List dataList) throws BOSException, EASBizException {
        Iterator ite = dataList.iterator();
        ICoreBase icb = this.getBussReportInterface();
        CoreBaseCollection cols = new CoreBaseCollection();
        while (ite.hasNext()) {
            Object obj = ite.next();
            if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
            BussAnalysisThemeReportInfo bussReportInfo = (BussAnalysisThemeReportInfo)obj;
            bussReportInfo.setTheme(theme);
            cols.add((CoreBaseInfo)bussReportInfo);
        }
        icb.submit(cols);
    }

    private void delSelectedDataByRow(IRow row) {
        if (row == null) {
            return;
        }
        String subjectName = row.getCell("subjectName").getValue().toString();
        String subjectPath = row.getCell("subjectPath").getValue().toString();
        if (this.selectData != null) {
            Iterator ite = this.selectData.iterator();
            int i = 0;
            while (ite.hasNext()) {
                BussAnalysisThemeTreeInfo reportInfo = (BussAnalysisThemeTreeInfo)ite.next();
                if (subjectName.equals(reportInfo.getSubName()) && subjectPath.equals(reportInfo.getSubPath())) {
                    this.selectData.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void actionLayoutPreview_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionLayout_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void brnToLeft_actionPerformed(ActionEvent e) throws Exception {
        super.brnToLeft_actionPerformed(e);
    }

    protected void btnToRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnToRight_actionPerformed(e);
    }

    public void actionMerge_actionPerformed(ActionEvent e) throws Exception {
        this.mergeTableCell();
    }

    public void actionOriginal_actionPerformed(ActionEvent e) throws Exception {
        this.originalTableCell();
    }

    protected void mergeTableCell() {
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int top_row = selectBlock.getBeginRow();
        int top_col = selectBlock.getBeginCol();
        int bottom_row = selectBlock.getEndRow();
        int bottom_col = selectBlock.getEndCol();
        if (top_row != bottom_row || top_col != bottom_col) {
            int i;
            if (top_row == bottom_row && top_col != bottom_col) {
                for (i = 1; i <= bottom_col - top_col; ++i) {
                    Object obj = this.layoutTable.getRow(top_row).getCell(top_col + i).getValue();
                    if (obj == null) continue;
                    this.reportList.addElement(obj);
                    this.layoutTable.getRow(top_row).getCell(top_col + i).setValue(null);
                }
            } else if (top_row != bottom_row && top_col == bottom_col) {
                for (i = 1; i <= bottom_row - top_row; ++i) {
                    Object obj = this.layoutTable.getRow(top_row + i).getCell(top_col).getValue();
                    if (obj == null) continue;
                    this.reportList.addElement(obj);
                    this.layoutTable.getRow(top_row + i).getCell(top_col).setValue(null);
                }
            } else if (top_row != bottom_row && top_col != bottom_col) {
                for (int i2 = top_row; i2 <= bottom_row; ++i2) {
                    for (int j = i2 == top_row ? top_col + 1 : top_col; j <= bottom_col; ++j) {
                        Object obj = this.layoutTable.getRow(i2).getCell(j).getValue();
                        if (obj == null) continue;
                        this.reportList.addElement(obj);
                        this.layoutTable.getRow(i2).getCell(j).setValue(null);
                    }
                }
            }
            KDTMergeManager mm = this.layoutTable.getMergeManager();
            mm.mergeBlock(top_row, top_col, bottom_row, bottom_col, 4);
            int beginRow = selectManager.get(0).getBeginRow();
            int beginCol = selectManager.get(0).getBeginCol();
        }
    }

    protected void originalTableCell() {
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int top_row = selectBlock.getBeginRow();
        int top_col = selectBlock.getBeginCol();
        int bottom_row = selectBlock.getEndRow();
        int bottom_col = selectBlock.getEndCol();
        KDTMergeManager mm = this.layoutTable.getMergeManager();
        mm.splitBlock(top_row, top_col, bottom_row, bottom_col);
    }

    public void actionLayoutReport_actionPerformed(ActionEvent e) throws Exception {
        if (this.reportList.isSelectionEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"please_select_report"));
            return;
        }
        Object obj = this.reportList.getSelectedValue();
        if (obj == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"please_select_report"));
            return;
        }
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int beginRow = selectBlock.getBeginRow();
        int beginCol = selectBlock.getBeginCol();
        Object oldObj = this.layoutTable.getRow(beginRow).getCell(beginCol).getValue();
        if (oldObj != null && oldObj instanceof BussAnalysisThemeReportInfo) {
            this.reportList.addElement(oldObj);
        }
        this.layoutTable.getRow(beginRow).getCell(beginCol).setValue(obj);
        int seleIndex = this.reportList.getSelectedIndex();
        this.reportList.removeElementAt(seleIndex);
        if (this.reportList.getElementCount() > 0) {
            this.reportList.setSelectedIndex(0);
        }
    }

    public void actionUnlayoutReport_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"please_select_cell"));
            return;
        }
        int beginRow = this.layoutTable.getSelectManager().get(0).getBeginRow();
        int beginCol = this.layoutTable.getSelectManager().get(0).getBeginCol();
        Object obj = this.layoutTable.getRow(beginRow).getCell(beginCol).getValue();
        this.layoutTable.getRow(beginRow).getCell(beginCol).setValue(null);
        if (obj != null && obj instanceof BussAnalysisThemeReportInfo) {
            this.reportList.addElement(obj);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.editData.isIsLeaf()) {
            this.isBussLeaf.setEnabled(true);
        }
        if (!this.editData.isIsBusiLeaf() || !this.editData.isIsLeaf()) {
            return;
        }
        this.addLine.setEnabled(true);
        this.delLine.setEnabled(true);
        this.btnLayout.setEnabled(true);
        this.btnToRight.setEnabled(true);
        this.brnToLeft.setEnabled(true);
        this.btnMerge.setEnabled(true);
        this.btnOriginal.setEnabled(true);
        this.cols.setEditable(true);
        this.rows.setEditable(true);
        this.layoutTable.setEnabled(true);
        KDTMenuManager kdtMenu = (KDTMenuManager)this.selfTableToMenu.get(this.layoutTable);
        if (kdtMenu != null) {
            Component[] menus = kdtMenu.getMenu().getComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem menu = (JMenuItem)menus[i];
                if ("menuItemToOriGalCell".equals(menu.getName()) || "menuItemToMergeCell".equals(menu.getName())) {
                    menu.setEnabled(true);
                    continue;
                }
                menu.setVisible(false);
            }
        }
    }

    private BussAnalysisThemeReportCollection readData(BussAnalysisThemeReportCollection dataList) {
        int rowCount = this.layoutTable.getRowCount();
        int colCount = this.layoutTable.getColumnCount();
        dataList.clear();
        for (int i = 0; i < rowCount; ++i) {
            IRow tempRow = this.layoutTable.getRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell tempCell = tempRow.getCell(j);
                Object obj = tempCell.getValue();
                KDTMergeBlock kdmerge = tempCell.getMergeBlock();
                if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
                BussAnalysisThemeReportInfo layoutInfo = (BussAnalysisThemeReportInfo)obj;
                layoutInfo.setCols(colCount);
                layoutInfo.setRows(rowCount);
                if (kdmerge == null) {
                    layoutInfo.setRowNumber(i);
                    layoutInfo.setColNumber(j);
                    layoutInfo.setRowspan(0);
                    layoutInfo.setColspan(0);
                    layoutInfo.setColWidth(1.0f / (float)colCount);
                    layoutInfo.setRowHeight(1.0f / (float)rowCount);
                } else if (kdmerge.getTop() == i && kdmerge.getLeft() == j) {
                    layoutInfo.setRowNumber(i);
                    layoutInfo.setColNumber(j);
                    layoutInfo.setRowspan(kdmerge.getBottom() - kdmerge.getTop() + 1);
                    layoutInfo.setColspan(kdmerge.getRight() - kdmerge.getLeft() + 1);
                    layoutInfo.setColWidth((float)(kdmerge.getRight() - kdmerge.getLeft() + 1) / (float)colCount);
                    layoutInfo.setRowHeight((float)(kdmerge.getBottom() - kdmerge.getTop() + 1) / (float)rowCount);
                }
                dataList.add(layoutInfo);
            }
        }
        return dataList;
    }
}

